# -*- coding: utf-8 -*-
# @Time    : 2021/5/14 18:06
# @Author  : wangyinghao
# @FileName: RequestHandler.py
# @Software: PyCharm
import requests


class RequestHandler:
    def __init__(self):
        """session管理器"""
        self.session = requests.session()

    def visit(self, method, url, **kwargs):
        return self.session.request(method=method, url=url, **kwargs)

    def close_session(self):
        """关闭session"""
        self.session.close()


if __name__ == '__main__':
    # 以下是测试代码
    # post请求接口
    url = 'https://msg.csdn.net/v1/web/message/view/unread'
    payload = {"coupon": "true"}
    req = RequestHandler()
    login_res = req.visit("post", url, params=payload)
    print(login_res.text)
    requests.request("post", url)
