# -*- coding: utf-8 -*-
# @Time : 2022/2/8 15:16
# @Author : wangyinghao
# @Site : 
# @File : performance_report.py
# @Software: PyCharm
from django.db import models
from automated_main.models.performance_test.performance_script import PerformanceScript


class PerformanceReport(models.Model):
    """
    性能测试报告
    """
    performance_report_name = models.CharField("性能测试报告名称", max_length=5000, null=False)
    pressure_test_content = models.TextField("压测内容", max_length=5000, null=True)
    performance_script = models.ForeignKey(PerformanceScript, on_delete=models.CASCADE, null=True)
    file = models.CharField("性能测试报告地址", max_length=5000, null=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True)

    def __str__(self):
        return self.performance_report_name


class PerformanceReportError(models.Model):
    """
    性能测试报告异常原因
    """
    performance_report_error_name = models.CharField("性能测试报告名称", max_length=5000, null=False)
    performance_report = models.ForeignKey(PerformanceReport, on_delete=models.CASCADE, null=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True)
    update_time = models.DateTimeField("更新时间", auto_now_add=True)

    def __str__(self):
        return self.performance_report_error_name
