# -*- coding: utf-8 -*-
# @Time : 2022/5/24 21:36
# @Author : wangyinghao
# @File : api_management_url.py
# @Software: PyCharm
from django.urls import path
from automated_main.view.api_automation.api_management.api_management_detail_view import ApiManagementView
from automated_main.view.api_automation.api_management.api_management_list_view import ApiManagementListView, ApiManagementSearchView,ApiManagementJudgeView, ApiManagementStructureDataEditView, ApiYaPiInterfaceView, YaPiInterfaceBasicInformationView
from automated_main.view.api_automation.api_management.api_interfaces_case_list_view import ApiInterfacesListView
from automated_main.view.api_automation.api_management.api_interfaces_case_view import ApiInterfacesCaseView, ApiInterfacesCaseDeBugView


urlpatterns = [
    # 获取接口服务列表
    path("api/backend/api_management/list/", ApiManagementListView.as_view()),

    # 变更/获取 单个服务
    path("api/backend/api_management/<int:api_management_id>/", ApiManagementView.as_view()),

    # 获取接口测试用例列表
    path("api/backend/apiInterfacesList/<int:api_server_id>/", ApiInterfacesListView.as_view()),

    # 复制用例
    path("api/backend/apiInterfacesCopyCase/", ApiInterfacesListView.as_view()),

    # 创建接口测试用例
    path("api/backend/apiInterfacesCase/", ApiInterfacesCaseView.as_view()),

    # 获取接口测试用例
    path("api/backend/apiInterfacesCase/<int:api_interfaces_case_id>/", ApiInterfacesCaseView.as_view()),

    # 获取调试测试用例 debug
    path("api/backend/apiInterfacesCase/debug/", ApiInterfacesCaseDeBugView.as_view()),

    # 搜索-服务树行结构
    path("api/backend/apiManagementSearch/", ApiManagementSearchView.as_view()),

    # 判断 父节点 是否可创建用例（只有用例节点才可创建用例）
    path("api/backend/apiManagement/JudgeAddCases/", ApiManagementJudgeView.as_view()),

    # tree树结构变更
    path("api/backend/apiManagement/ApiManagementStructureDataEdit/", ApiManagementStructureDataEditView.as_view()),

    # 获取YAPI接口基础信息
    path("api/backend/apiManagement/yaPiInterfaceBasicInformation/", YaPiInterfaceBasicInformationView.as_view()),

    # YAPI接口-新增/修改 到tree树
    path("api/backend/apiManagement/apiYaPiInterface/", ApiYaPiInterfaceView.as_view()),

]
