# -*- coding: utf-8 -*-
# @Time : 2022/7/5 14:00
# @Author : wangyinghao
# @Site : 
# @File : api_interfaces_case_list_view.py
# @Software: PyCharm
import datetime

from django.views.generic import View
import json
from automated_main.utils.http_format import response_success
from automated_main.models.api_automation.api_interfaces_case import ApiInterfacesCase, ApiInterfacesParameterData
from automated_main.utils.api_management_utils import ApiManagementUtils
from automated_main.models.api_automation.api_management import ApiManagement

import arrow


class ApiInterfacesListView(View):

    def get(self, request, api_server_id, *args, **kwargs):
        """
        获取测试用例列表
        :param api_server_id: api服务id
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        # api_management_id_list = ApiManagementUtils.get_interfaces_case_recursion(api_server_id)
        # api_interfaces_cases_list = []
        # for api_management_id in api_management_id_list:
        #     api_interfaces_cases = ApiInterfacesCase.objects.filter(api_management_id=api_management_id)
        #
        #     for interfaces_cases in api_interfaces_cases:
        #         api_interfaces_cases_dict = {
        #             "id": interfaces_cases.id,
        #             "api_interfaces_case_name": interfaces_cases.api_interfaces_case_name,
        #             "api_test_case_url": interfaces_cases.api_url,
        #             "api_method": interfaces_cases.api_method,
        #             "api_documentation": interfaces_cases.api_documentation,
        #             "update_time": arrow.get(str(interfaces_cases.update_time)).format('YYYY-MM-DD HH:mm:ss'),
        #             "create_time": arrow.get(str(interfaces_cases.create_time)).format('YYYY-MM-DD HH:mm:ss'),
        #         }
        #
        #         api_interfaces_cases_list.append(api_interfaces_cases_dict)
        # return response_success(api_interfaces_cases_list)

        api_interfaces_cases_list = []
        api_management_data = ApiManagement.objects.filter(id=api_server_id)

        for api_management in api_management_data:
            api_management_data_a = ApiManagement.objects.filter(parent=api_management.id)

            api_interfaces_cases_list.append(api_management.id)

            for api_management_a in api_management_data_a:
                api_interfaces_cases_list.append(api_management_a.id)

                api_management_data_b = ApiManagement.objects.filter(parent=api_management_a.id)

                for api_management_b in api_management_data_b:
                    api_interfaces_cases_list.append(api_management_b.id)

        api_interfaces_cases_data_list = []

        for api_management_id in api_interfaces_cases_list:
            api_interfaces_cases = ApiInterfacesCase.objects.filter(api_management_id=api_management_id)

            for interfaces_cases in api_interfaces_cases:
                api_interfaces_cases_dict = {
                    "id": interfaces_cases.id,
                    "api_interfaces_case_name": interfaces_cases.api_interfaces_case_name,
                    "api_test_case_url": interfaces_cases.api_url,
                    "api_method": interfaces_cases.api_method,
                    "api_documentation": interfaces_cases.api_documentation,
                    "update_time": arrow.get(str(interfaces_cases.update_time)).format('YYYY-MM-DD HH:mm:ss'),
                    "create_time": arrow.get(str(interfaces_cases.create_time)).format('YYYY-MM-DD HH:mm:ss'),
                }

                api_interfaces_cases_data_list.append(api_interfaces_cases_dict)

        return response_success(api_interfaces_cases_data_list)

    def post(self, request, *args, **kwargs):
        """
        复制用例
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        body = request.body
        params = json.loads(body)
        if params == {}:
            pass

        else:
            api_case_data = ApiInterfacesCase.objects.filter(id=params['case_id'])
            for api_case in api_case_data:

                copy_api_interfaces_case = ApiInterfacesCase.objects.create(
                    api_interfaces_case_name=str(api_case.api_interfaces_case_name) + "-Copy",
                    api_documentation=api_case.api_documentation,
                    api_management_id=api_case.api_management_id,
                    api_environment_id=api_case.api_environment_id,
                    api_method=api_case.api_method,
                    api_url=api_case.api_url,
                    api_parameter_types=api_case.api_parameter_types,
                    api_headers=api_case.api_headers,
                    api_parameter_body=api_case.api_parameter_body,
                    api_assert_type=api_case.api_assert_type,
                    dataBase_id=api_case.dataBase_id,
                    database_sql=api_case.database_sql,
                    api_assert_text=api_case.api_assert_text
                )

                api_interfaces_parameter_data = ApiInterfacesParameterData.objects.filter(
                    api_test_case_id=params['case_id'])

                for api_interfaces_parameter in api_interfaces_parameter_data:
                    ApiInterfacesParameterData.objects.create(
                        api_test_case_id=copy_api_interfaces_case.id,
                        api_parameter_name=api_interfaces_parameter.api_parameter_name,
                        api_must_parameter=api_interfaces_parameter.api_must_parameter,
                        api_parameter_value=api_interfaces_parameter.api_parameter_value,
                        api_field_describe=api_interfaces_parameter.api_field_describe
                    )

        return response_success({"message": "Copy成功！"})
