# -*- coding: utf-8 -*-
# @Time : 2022/7/25 10:40
# @Author : wangyinghao
# @Site : 
# @File : api_data_synchronization_view.py
# @Software: PyCharm
from django.views.generic import View
import json
from automated_main.utils.http_format import response_success
from automated_main.models.api_automation.api_project import APIProject
from automated_main.models.api_automation.api_test_task import APITestResult, APITestResultAssociated, APITestTask
from automated_main.models.api_automation.api_test_plan import ApiTestPlan, APITestPlanResult, \
    APITestPlanResultAssociated

from automated_main.models.api_automation.api_business_test import ApiBusinessTest, ApiBusinessTestAssociated

from automated_main.models.api_automation.api_module import APIModule
from automated_main.models.api_automation.api_management import ApiManagement
from automated_main.models.api_automation.api_test_case import ApiTestCase, ApiParameterExtraction, ApiParameterData
from automated_main.models.api_automation.api_interfaces_case import ApiInterfacesCase, \
    ApiInterfacesParameterExtraction, ApiInterfacesParameterData
from automated_main.models.api_automation.api_scenarios_case import ApiScenariosCase, ApiScenariosCaseAssociated


class ApiDataSynchronization(View):

    # def post(self, request, *args, **kwargs):
    #     """
    #     数据同步 创建项目、创建测试用例
    #     :param request:
    #     :param args:
    #     :param kwargs:
    #     :return:
    #     """
    #     project = APIProject.objects.all()
    #
    #     for pr in project:
    #         management = ApiManagement.objects.create(name=pr.api_project_name, description=pr.api_project_name)
    #
    #         module = APIModule.objects.filter(api_project_id=pr.id)
    #         for m in module:
    #             Api_m = ApiManagement.objects.create(name=m.api_module_name, description=m.api_module_name,
    #                                                  parent=management.id)
    #             for m2 in module:
    #                 Api_m2 = ApiManagement.objects.create(name=m.api_module_name, description=m2.api_module_name,
    #                                                       parent=Api_m.id)
    #                 case_data = ApiTestCase.objects.filter(api_module_id=m2.id)
    #
    #                 for case in case_data:
    #                     case_node = ApiManagement.objects.create(name=case.api_test_case_name,
    #                                                              description=case.api_test_case_name,
    #                                                              parent=Api_m2.id)
    #
    #                     api = ApiInterfacesCase.objects.create(
    #                         api_interfaces_case_name=case.api_test_case_name,
    #                         api_documentation=case.api_documentation,
    #                         api_management_id=case_node.id,
    #                         api_environment_id=case.api_environment_id,
    #                         api_method=case.api_method,
    #                         api_url=case.api_url,
    #                         api_parameter_types=case.api_parameter_types,
    #                         api_headers=case.api_headers,
    #                         api_parameter_body=case.api_parameter_body,
    #                         api_assert_type=case.api_assert_type,
    #                         dataBase_id=case.dataBase_id,
    #                         database_sql=case.database_sql,
    #                         api_assert_text=case.api_assert_text,
    #                     ) if case.api_assert_text else None
    #
    #                     extraction = ApiParameterExtraction.objects.filter(api_test_case_id=case.id)
    #
    #                     for ex in extraction:
    #                         ApiInterfacesParameterExtraction.objects.create(
    #                             api_test_case_id=api.id,
    #                             api_variable_results=ex.api_variable_results,
    #                             api_value_variable=ex.api_value_variable,
    #                             api_key_variable=ex.api_key_variable
    #                         )
    #
    #                     parameter_data = ApiParameterData.objects.filter(api_test_case_id=case.id)
    #
    #                     for parameter in parameter_data:
    #                         ApiInterfacesParameterData.objects.create(
    #                             api_test_case_id=api.id,
    #                             api_parameter_name=parameter.api_parameter_name,
    #                             api_must_parameter=parameter.api_must_parameter,
    #                             api_parameter_value=parameter.api_parameter_value,
    #                             api_field_describe=parameter.api_field_describe,
    #                         )
    #
    #     return response_success()

    def get(self, request, *args, **kwargs):
        """
        数据同步 同步项目接口
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        project_data = APIProject.objects.all()

        for project in project_data:
            ApiManagement.objects.create(name=project.api_project_name, description=project.api_project_name)

        return response_success()

    def post(self, request, *args, **kwargs):
        """
        数据同步，同步服务名称 tree
        仅限以下两个服务
        开放平台/启客_Frequent_API
        """

        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)
        module_data = APIModule.objects.filter(api_project_id=data['project_id'])
        api_management_data = ApiManagement.objects.get(name=data['management_name'])

        for module in module_data:
            ApiManagement.objects.create(name=module.api_module_name, description=module.api_module_name,
                                         parent=api_management_data.id)

        return response_success()

    def put(self, request, *args, **kwargs):
        """
        数据同步，同步服务名称 tree
        仅限以下两个服务
        数据中心/启魔方APP/招标云/SCRM
        """

        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)
        case_data = ApiTestCase.objects.filter(api_module_id=data['module_id'])
        api_management_data = ApiManagement.objects.get(name=data['management_name'])

        for case in case_data:
            api_tree_data = ApiManagement.objects.create(name=case.api_test_case_name,
                                                         description=case.api_test_case_name,
                                                         parent=api_management_data.id)

            api = ApiInterfacesCase.objects.create(
                api_interfaces_case_name=case.api_test_case_name,
                api_documentation=case.api_documentation,
                api_management_id=api_tree_data.id,
                api_environment_id=case.api_environment_id,
                api_method=case.api_method,
                api_url=case.api_url,
                api_parameter_types=case.api_parameter_types,
                api_headers=case.api_headers,
                api_parameter_body=case.api_parameter_body,
                api_assert_type=case.api_assert_type,
                dataBase_id=case.dataBase_id,
                database_sql=case.database_sql,
                api_assert_text=case.api_assert_text,
            ) if case.api_assert_text else None

            extraction = ApiParameterExtraction.objects.filter(api_test_case_id=case.id)

            for ex in extraction:
                ApiInterfacesParameterExtraction.objects.create(
                    api_test_case_id=api.id,
                    api_variable_results=ex.api_variable_results,
                    api_value_variable=ex.api_value_variable,
                    api_key_variable=ex.api_key_variable
                )

            parameter_data = ApiParameterData.objects.filter(api_test_case_id=case.id)

            for parameter in parameter_data:
                ApiInterfacesParameterData.objects.create(
                    api_test_case_id=api.id,
                    api_parameter_name=parameter.api_parameter_name,
                    api_must_parameter=parameter.api_must_parameter,
                    api_parameter_value=parameter.api_parameter_value,
                    api_field_describe=parameter.api_field_describe,
                )

        return response_success()


class ApiScenarioSynchronization(View):

    def post(self, request, *args, **kwargs):
        """
        业务场景数据同步
        """
        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)

        business_test_data = ApiBusinessTest.objects.filter(api_project_id=data['api_project_id'])

        for business_test in business_test_data:
            api_management = ApiManagement.objects.get(name=business_test.api_project.api_project_name)
            api_scenarios_case = ApiScenariosCase.objects.create(
                api_scenarios_case_name=business_test.api_business_test_name,
                api_scenarios_case_describe=business_test.api_business_test_describe,
                api_management_id=api_management.id
            )

            api_business_test_associated_data = ApiBusinessTestAssociated.objects.filter(bid_id=business_test.id)

            for api_business_test_associated in api_business_test_associated_data:
                api_test_case = ApiTestCase.objects.get(id=api_business_test_associated.api_test_case_id)
                api_module = APIModule.objects.get(id=api_test_case.api_module_id)
                if api_module.api_project_id == data['api_project_id']:
                    api_interfaces_case_data = ApiInterfacesCase.objects.filter(
                        api_interfaces_case_name=api_test_case.api_test_case_name)

                    for api_interfaces_case in api_interfaces_case_data:
                        management_A = ApiManagement.objects.get(id=api_interfaces_case.api_management_id)

                        management_B = ApiManagement.objects.get(id=management_A.parent)

                        management_C = ApiManagement.objects.get(id=management_B.parent)

                        if management_C.parent == 0:
                            pass
                        else:
                            management_D = ApiManagement.objects.get(id=management_C.parent)

                            if management_D.name == business_test.api_project.api_project_name:
                                ApiScenariosCaseAssociated.objects.create(sid_id=api_scenarios_case.id,
                                                                          case_steps=api_business_test_associated.case_steps,
                                                                          interfaces_case_id=api_interfaces_case.id)

        return response_success()

    def put(self, request, *args, **kwargs):
        """
        同步接口测试报告
        """
        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)

        api_test_result_data = APITestResult.objects.filter(api_task_id=data['api_task_id'])

        task = APITestTask.objects.get(id=data['api_task_id'])

        plan = ApiTestPlan.objects.get(api_test_plan_name=task.api_test_task_name)
        for api_test_result in api_test_result_data:
            plan_result = APITestPlanResult.objects.create(api_test_result_name=api_test_result.api_test_result_name,
                                                           api_test_plan_id=plan.id,
                                                           api_error_total_number=api_test_result.api_error_total_number,
                                                           api_successful_total_number=api_test_result.api_successful_total_number,
                                                           api_total_number=api_test_result.api_total_number,
                                                           api_environment_id=api_test_result.api_environment_id
                                                           )
            associated_data = APITestResultAssociated.objects.filter(api_result_id=api_test_result.id)

            for associated in associated_data:
                APITestPlanResultAssociated.objects.create(
                    api_test_case_name=associated.api_test_case_name,
                    api_test_plan_id=plan.id,
                    api_result_id=plan_result.id,
                    api_error=associated.api_error,
                    api_successful=associated.api_successful,
                    abnormal=associated.abnormal,
                    json_extract_variable_conversion=associated.json_extract_variable_conversion,
                    api_assertion_results=associated.api_assertion_results,
                    api_variable_results=associated.api_variable_results,
                    api_request_results=associated.api_request_results,
                    api_business_test_name=associated.api_business_test_name,
                    api_header=associated.api_header,
                    api_url=associated.api_url,
                    api_body=associated.api_body

                )

        return response_success()
