# -*- coding: utf-8 -*- 
# @Time : 2022/10/24 20:50 
# @Author : wyh 
# @File : personnel_allocation_view.py 
# @desc:
from django.views.generic import View
from automated_main.utils.http_format import response_success
from automated_main.models.testing_progress.testing_progress import TestingProgress
import json
import arrow
import datetime
import time
import os
import logging

logger = logging.getLogger('django')


class PersonnelAllocationView(View):

    def put(self, request, *args, **kwargs):
        """
        新增测试任务
        """
        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)

        ENV_PROFILE = os.getenv("ENV")
        logger.info('222222222222')
        logger.info(ENV_PROFILE)
        logger.info('222222222222')

        if 'color' in data.keys():
            TestingProgress.objects.create(testing_progress_title=data['text'],
                                           start_date=data['start_date'],
                                           end_date=data['end_date'],
                                           duration=data['duration'],
                                           group=data['group'],
                                           parent=data['parent'],
                                           testing_progress=data['progress'],
                                           type=data['color'],
                                           description=data['description'])
        else:
            TestingProgress.objects.create(testing_progress_title=data['text'],
                                           group=data['group'],
                                           parent=data['parent'],
                                           testing_progress='',
                                           type='',
                                           description='')

        return response_success("创建成功")

    def post(self, request, *args, **kwargs):
        """
        修改任务
        """

        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)
        # print(data)
        if 'group' in data:
            testing_progress = TestingProgress.objects.get(id=data['id'])
            testing_progress.testing_progress_title = data['text']
            testing_progress.group = data['group']
            testing_progress.parent = data['parent']
            testing_progress.start_date = data['start_date']
            testing_progress.end_date = data['end_date']
            testing_progress.testing_progress = data['progress']
            testing_progress.description = data['description']
            testing_progress.type = data['color']
            testing_progress.save()
        else:
            testing_progress = TestingProgress.objects.get(id=data['id'])
            testing_progress.testing_progress_title = data['text']
            # testing_progress.group = data['group']
            testing_progress.parent = data['parent']
            testing_progress.testing_progress = data['progress']
            testing_progress.start_date = data['start_date']
            testing_progress.end_date = data['end_date']
            testing_progress.description = data['description']
            testing_progress.type = data['color']
            testing_progress.save()
        return response_success()

    def delete(self, request, pid, *args, **kwargs):
        """
        删除任务
        """

        TestingProgress.objects.get(id=pid).delete()

        return response_success()


class PersonnelAllocationListView(View):
    def post(self, request, *args, **kwargs):
        """
        获取任务
        """

        body = request.body
        data = json.loads(body)

        # 查询时间
        date_list_query = []
        begin_date_query = datetime.datetime.strptime(data['data_time_personnel'][0], "%Y-%m-%d")
        end_date_query = datetime.datetime.strptime(data['data_time_personnel'][1], "%Y-%m-%d")
        while begin_date_query <= end_date_query:
            date_str = begin_date_query.strftime("%Y-%m-%d")
            date_list_query.append(date_str)
            begin_date_query += datetime.timedelta(days=1)

        testing_progress_data = TestingProgress.objects.all()
        testing_progress_list = []

        for testing_progress in testing_progress_data:

            if testing_progress.group == 1:
                render = "split"
                testing_progress_dict = {
                    "text": testing_progress.testing_progress_title,
                    "id": testing_progress.id,
                    "render": render,
                    "parent": testing_progress.parent,
                    "group": str(testing_progress.group),
                    "color": testing_progress.type,
                    "description": testing_progress.description
                }
                testing_progress_list.append(testing_progress_dict)
            else:
                render = ""
                # 任务的开始时间 转换 年月日时分
                dates_start_date = time.strptime(testing_progress.start_date, "%Y-%m-%d %H:%M")
                dates_start_date = time.strftime("%Y-%m-%d", dates_start_date)

                # 任务的结束时间 年月日时分
                dates_end_date = time.strptime(testing_progress.end_date, "%Y-%m-%d %H:%M")
                dates_end_date = time.strftime("%Y-%m-%d", dates_end_date)

                data_list_task = []
                date_start = datetime.datetime.strptime(dates_start_date, '%Y-%m-%d')
                date_end = datetime.datetime.strptime(dates_end_date, '%Y-%m-%d')
                data_list_task.append(date_start.strftime('%Y-%m-%d'))
                while date_start < date_end:
                    date_start += datetime.timedelta(days=1)
                    data_list_task.append(date_start.strftime('%Y-%m-%d'))

                set_c = set(date_list_query) & set(data_list_task)
                list_c = list(set_c)
                if len(list_c) > 0:

                    if testing_progress.parent == "0":
                        parent = ""
                    else:
                        parent = testing_progress.parent
                    testing_progress_dict = {
                        "text": testing_progress.testing_progress_title,
                        "start_date": testing_progress.start_date,
                        "id": testing_progress.id,
                        "duration": testing_progress.duration,
                        "parent": parent,
                        "type": testing_progress.type,
                        "end_date": testing_progress.end_date,
                        "render": render,
                        "progress": testing_progress.testing_progress,
                        "group": str(testing_progress.group),
                        "color": testing_progress.type,
                        "description": testing_progress.description
                    }
                    testing_progress_list.append(testing_progress_dict)
                else:
                    pass

        return response_success(testing_progress_list)
