# -*- coding: utf-8 -*-

from django.views.generic import View
import json
from automated_main.utils.http_format import response_success, response_failed
from automated_main.exception.my_exception import MyException
# from automated_main.models.api_automation.api_business_test import ApiBusinessTest, ApiBusinessTestAssociated
# from automated_main.form.api_business_test import ApiBusinessTestForm
from automated_main.models.api_querrydiff.record_opt import DbRecordOpt

import logging

logger = logging.getLogger('django')

class ApiQuerydiffTaskDetailView(View):

    def get(self, request, *args, **kwargs):
        """
        获取任务接口详情列表
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        case_sql = "select * from automated_main_querrydifftaskitems order by status desc,api_url"
        param = dict(request.GET)

        db = DbRecordOpt()
        total = db.querry_excute(case_sql)
        p_size = int(param.get('size')[0]) if len(param.get('size', list())) > 0 else 10
        p_num = int(param.get('page')[0]) if len(param.get('page', list())) > 0 else 1

        list_sql = case_sql + " limit {} offset {}".format(p_size, p_size * (p_num - 1))

        case_list = db.querry_excute(list_sql)

        return response_success({'case': case_list, 'total': len(total)})

