# -*- coding: utf-8 -*-
# @Time : 2022/7/20 10:07
# @Author : wangyinghao
# @Site : 
# @File : api_scenarios_case.py
# @Software: PyCharm
from django.db import models
from automated_main.models.api_automation.api_management import ApiManagement
from automated_main.models.api_automation.api_interfaces_case import ApiInterfacesCase


class ApiScenariosCase(models.Model):
    """
    API场景测试表
    """

    api_scenarios_case_name = models.CharField("API场景测试名称", max_length=200, null=False)
    api_scenarios_case_describe = models.TextField("API业务测试描述", max_length=5000, null=True)
    api_management = models.ForeignKey(ApiManagement, on_delete=models.CASCADE)
    update_time = models.DateTimeField(auto_now_add=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True)

    def __str__(self):
        return self.api_scenarios_case_name


class ApiScenariosCaseAssociated(models.Model):
    """
    API场景测试关联表
    """
    sid = models.ForeignKey(ApiScenariosCase, on_delete=models.CASCADE)
    interfaces_case = models.ForeignKey(ApiInterfacesCase, on_delete=models.CASCADE)
    case_steps = models.CharField("操作步骤", max_length=100, null=False)
    update_time = models.DateTimeField(auto_now_add=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True)

    def __str__(self):
        return str(self.sid)
