# -*- coding: utf-8 -*- 
# @Time : 2022/10/24 20:50 
# @Author : wyh 
# @File : personnel_allocation_view.py 
# @desc:
from django.views.generic import View
from automated_main.utils.http_format import response_success, response_failed
from automated_main.exception.my_exception import MyException
from automated_main.models.testing_progress.testing_progress import TestingProgress

import json
import arrow


class PersonnelAllocationView(View):

    def get(self, request, *args, **kwargs):
        """
        获取任务
        """
        testing_progress_data = TestingProgress.objects.all()
        testing_progress_list = []

        for testing_progress in testing_progress_data:
            if testing_progress.group == "1":
                render = "split"
            else:
                render = ""

            if testing_progress.parent == "0":
                parent = ""
            else:
                parent = testing_progress.parent

            testing_progress_dict = {
                "text": testing_progress.testing_progress_title,
                "start_date": testing_progress.start_date,
                "id": testing_progress.id,
                "duration": testing_progress.duration,
                # "parent": "",
                "type": testing_progress.type,
                "end_date": testing_progress.end_date,
                "render": render,
                "description": testing_progress.description
            }
            testing_progress_list.append(testing_progress_dict)

        return response_success(testing_progress_list)

    def put(self, request, *args, **kwargs):
        """
        新增测试任务
        """
        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)

        TestingProgress.objects.create(testing_progress_title=data['text'],
                                       start_date=arrow.get(str(data['start_date'])).format('YYYY-MM-DD'),
                                       end_date=arrow.get(str(data['end_date'])).format('YYYY-MM-DD'),
                                       duration=data['duration'],
                                       group=data['group'],
                                       parent=data['parent'],
                                       type=data['color'],
                                       description=data['description'])

        return response_success("创建成功")

    def post(self, request, *args, **kwargs):
        return response_success()

    def delete(self, *args, **kwargs):
        return response_success()
