from django.db import models


class TestingProgress(models.Model):
    """
    测试进度
    """
    testing_progress_title = models.CharField("测试进度标题", max_length=50, null=False)
    start_date = models.TextField("开始时间", default="", max_length=200, null=True)
    end_date = models.TextField("开始时间", default="", max_length=200, null=True)
    duration = models.TextField("测试内容-标题", default="", max_length=200, null=True)
    group = models.IntegerField("是否分组", default=1)  # 1 是  0 不是
    parent = models.IntegerField("父id",  null=True, default=0)
    type = models.CharField("图表颜色", max_length=50, null=False)
    description = models.TextField("描述", default="", max_length=20000, null=True)
    update_time = models.DateTimeField(auto_now_add=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True)

    def __str__(self):
        return self.testing_progress_title
