# -*- coding: utf-8 -*-
# @Time : 2021/11/18 20:51
# @Author : wangyinghao
# @Site : 
# @File : jmeter_perform.py
# @Software: PyCharm
import re
from string import Template


def create_para_jmx(jmx, jm_num_threads, jm_loops, jm_duration, jm_ramp_time, jm_scheduler, loop_count_forever, data_set, test_data):
    """
    修改jmeter文件
    :param data_set: 是否参数化
    :param test_data: 参数化数据地址
    :param loop_count_forever: 循环-永远
    :param jmx: jmeter文件路径
    :param jm_num_threads: 线程数
    :param jm_loops: 循环次数
    :param jm_duration: 持续运行时间
    :param jm_ramp_time: Ramp-Up时间(秒)
    :param jm_scheduler: 调度器
    :return:
    """
    test_data_jmeter = test_data.split('/')[-1]
    with open(jmx, 'r', encoding='utf-8') as file:
        jmx_str = file.read()

    # 循环次数
    if loop_count_forever == "true":
        loops = '<stringProp name="LoopController.loops">(.*?)</stringProp>'
        replcae_loops = '<intProp name="LoopController.loops">-$loops</intProp>'
        jmx_str = re.sub(loops, replcae_loops, jmx_str)

    elif loop_count_forever == "false":

        loops = '<intProp name="LoopController.loops">-(.*?)</intProp>'
        replcae_loops = '<stringProp name="LoopController.loops">$loops</stringProp>'
        jmx_str = re.sub(loops, replcae_loops, jmx_str)
        loops = '<stringProp name="LoopController.loops">(.*?)</stringProp>'
        replcae_loops = '<stringProp name="LoopController.loops">$loops</stringProp>'
        jmx_str = re.sub(loops, replcae_loops, jmx_str)

    # 线程数
    num_threads = '<stringProp name="ThreadGroup.num_threads">(.*?)</stringProp>'
    repalce_num_threads = '<stringProp name="ThreadGroup.num_threads">$num_threads</stringProp>'
    jmx_str = re.sub(num_threads, repalce_num_threads, jmx_str)

    # Ramp-Up时间(秒)
    ramp_time = '<stringProp name="ThreadGroup.ramp_time">(.*?)</stringProp>'
    replaced_ramp_time = '<stringProp name="ThreadGroup.ramp_time">$ramp_time</stringProp>'
    jmx_str = re.sub(ramp_time, replaced_ramp_time, jmx_str)

    # 调度器
    scheduler = '<boolProp name="ThreadGroup.scheduler">(.*?)</boolProp>'
    repalce_scheduler = '<boolProp name="ThreadGroup.scheduler">$scheduler</boolProp>'
    jmx_str = re.sub(scheduler, repalce_scheduler, jmx_str)

    # 持续运行时间
    duration = '<stringProp name="ThreadGroup.duration">(.*?)</stringProp>'
    replace_duration = '<stringProp name="ThreadGroup.duration">$duration</stringProp>'
    jmx_str = re.sub(duration, replace_duration, jmx_str)

    # csv文件参数化
    if data_set == 'true':
        csv_data_set = '<stringProp name="filename">(.*?)</stringProp>'
        replace_csv_data_set = '<stringProp name="filename">$csv_data_set</stringProp>'
        jmx_str = re.sub(csv_data_set, replace_csv_data_set, jmx_str, 1)
    elif data_set == "false":
        pass

    with open(jmx, "w+", encoding="utf-8") as file:
        file.writelines(jmx_str)

    with open(jmx, "r", encoding="utf-8") as file:
        tmpstr = Template(file.read()).safe_substitute(loops=jm_loops, num_threads=jm_num_threads,
                                                       duration=jm_duration, scheduler=jm_scheduler,
                                                       ramp_time=jm_ramp_time, csv_data_set='/home/quant_group/data/jmeter/jmeter_data_set/' + test_data_jmeter)

    with open(jmx, "w+", encoding="utf-8") as file:
        file.writelines(tmpstr)

    return jmx

# 执行参数化jmx文件，生成带参数的jmx文件
# create_para_jmx()

# 获取当前时间，格式为20210301122059
# now = time.strftime(r'%Y%m%d%H%M%S', time.localtime(time.time()))

# 创建执行jmx的参数
# def execjmx(self, jmx, duration, throughput, num_threads, loops, scheduler, ramp_time):
#     print(f"本次运行的场景为：运行时间:{duration}s、吞吐量:{throughput / 60}qps、线程数:{num_threads}、循环次数:{loops}")
#     tmpstr = ''
#
#     with open(jmx, "r", encoding="utf-8") as file:
#         tmpstr = Template(file.read()).safe_substitute(loops=loops, num_threads=num_threads, duration=duration,
#                                                        throughput=throughput, scheduler=scheduler,
#                                                        ramp_time=ramp_time)
#
#     with open(jmx, "w+", encoding="utf-8") as file:
#         file.writelines(tmpstr)

# # 生成的jtl文件
# jtl = resultpath + f'/{now}-{duration}s-{throughput}qps-{num_threads}threads-{loops}loops.jtl'
#
# # 生成的html文件
# html = resultpath + f'/{now}-{duration}s-{throughput}qps-{num_threads}threads-{loops}loops-htmlreport'
# run = f"{jmeter_Home} -n -t {jmx} -l {jtl} -e -o {html}"
# os.system(run)

# 执行jmx文件
# 时间、吞吐量、线程数、循环次数
# jm_duration = '2'
# throughput = int('2')
# jm_num_threads = '2'
# jm_loops = '2'
# jm_scheduler = 'true'
# jm_ramp_time = '2'
# jmx = "E:\\test.jmx"
# jm_loop_count_forever = "true"
# test_data = "/home/a"
# #
# create_para_jmx(jmx, jm_num_threads, jm_loops, jm_duration, jm_ramp_time, jm_scheduler, jm_loop_count_forever, 'true', test_data)
