# -*- coding: utf-8 -*-
# @Time : 2022/7/21 15:34
# @Author : wangyinghao
# @Site : 
# @File : api_plan_url.py
# @Software: PyCharm
from django.urls import path
from automated_main.view.api_automation.api_test_plan.api_test_plan_view import APITestPlanSuspended, ApiTestPlanView, GetScenariosCaseTree, PerformApiPlan, CheckApiPlanResultList, CheckApiResult, CheckApiResultErrorList
from automated_main.view.api_automation.api_test_plan.api_test_plan_list_view import ApiTestPlanListView


urlpatterns = [

    # 测试计划-删除/编辑/获取
    path("api/backend/api_test_plan/<int:api_test_plan_id>/", ApiTestPlanView.as_view()),

    # 新增测试计划
    path("api/backend/api_test_plan/", ApiTestPlanView.as_view()),


    # 暂停测试计划
    path("api/backend/api_test_plan/suspended/", APITestPlanSuspended.as_view()),

    # 获取项目下所有测试计划
    path("api/backend/api_test_plan/list/<int:api_management_id>/", ApiTestPlanListView.as_view()),

    # 场景用例树结构
    path("api/backend/api_test_plan/get_scenarios_case_tree/<int:api_management_id>/", GetScenariosCaseTree.as_view()),
    path("api/backend/api_test_plan/post_scenarios_case_tree/<int:api_test_plan_id>/", GetScenariosCaseTree.as_view()),

    # API-执行测试计划
    path("api/backend/api_test_plan/perform_api_test_plan/<int:api_test_plan_id>/", PerformApiPlan.as_view()),

    # API-执行所有测试计划
    path("api/backend/api_test_plan/perform_api_test_plan_all/", PerformApiPlan.as_view()),

    # 测试计划报告列表
    path("api/backend/api_test_plan/check_result_list/<int:api_test_plan_id>/<int:size_page>/<int:page>/",
         CheckApiPlanResultList.as_view()),

    # API测试计划-查看单独测试计划报告
    path("api/backend/api_test_plan/check_result/<int:api_test_result_id>/<int:size_page>/<int:page>/",
         CheckApiResult.as_view()),

    path("api/backend/api_test_plan/single_check_result/<int:api_test_case_result_id>/", CheckApiResult.as_view()),

    path("api/backend/api_test_plan/check_result/<int:api_test_result_id>/", CheckApiResult.as_view()),

    # 查看失败报告
    path("api/backend/api_test_plan/check_result/error/<int:api_test_result_id>/<int:size_page>/<int:page>/",
         CheckApiResultErrorList.as_view()),

]