# -*- coding: utf-8 -*-
"""
@Time ： 2021/5/27 10:51
@Auth ： WangYingHao
@File ：performance_script.py
@IDE ：PyCharm

"""
from django.db import models
from automated_main.models.performance_test.performance_project import PerformanceProject
import time


def upload_to(instance, fielname):
    # 后缀
    sub = fielname.split('.')[-1]
    t = time.strftime('%Y%m%d%H%M%S', time.localtime())
    return 'jmeter_script/namespace/%s.%s' % (t, sub,)


# Create your models here.
class PerformanceScript(models.Model):
    """
    性能测试脚本
    """
    performance_script_name = models.CharField("性能测试脚本名称", max_length=5000, null=False)
    performance_project = models.ForeignKey(PerformanceProject, on_delete=models.CASCADE, null=True)
    performance_threads = models.TextField("线程数", max_length=5000, null=False)
    performance_ramp_up_time_seconds = models.TextField("Ramp-Up时间(秒)", max_length=5000, null=False)
    performance_loop_count = models.TextField("循环次数", max_length=5000, null=True)
    performance_duration = models.TextField("持续时间", max_length=5000, null=True)
    performance_scheduler = models.TextField("调度器", max_length=500, null=False)
    loop_count_forever = models.TextField("循环-永远", max_length=500, null=True)
    performance_script = models.CharField("性能测试脚本", max_length=5000, null=False)
    performance_status = models.IntegerField("性能脚本运行状态", default=0)
    data_set = models.TextField("参数化设置", max_length=500, null=True)
    performance_data_script = models.TextField("jmeter参数化文件", max_length=500, null=True)
    updata_time = models.DateTimeField(auto_now_add=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True)

    def __str__(self):
        return self.performance_script_name
