# -*- coding: utf-8 -*-

from django.db import models
from automated_main.models.api_querrydiff.api_querrydiff_task import QuerryDiffTask


class QuerryDiffTaskItems(models.Model):
    """
    回放任务明细
    """
    task_id = models.ForeignKey(QuerryDiffTask, on_delete=models.CASCADE)
    api_url = models.CharField("请求地址", max_length=255, blank=False)
    param = models.TextField("关联API用例", default=None)
    result = models.CharField("运行结果",  blank=True, null=True)
    req_count = models.BigIntegerField("线上运行次数", default=0, null=True)
    status = models.IntegerField("状态", default=0, null=True)
    method = models.IntegerField("请求方式", blank=False)
    created_time = models.DateTimeField("创建时间", auto_now_add=True)

    def __str__(self):
        return self.task_id
