# -*- coding: utf-8 -*-
# @Time : 2022/7/19 11:49
# @Author : wangyinghao
# @Site : 
# @File : api_scenarios_case_list_view.py
# @Software: PyCharm
from django.views.generic import View
import json
from automated_main.utils.http_format import response_success
from automated_main.models.api_automation.api_interfaces_case import ApiInterfacesCase
from automated_main.models.api_automation.api_management import ApiManagement
from automated_main.models.api_automation.api_scenarios_case import ApiScenariosCaseAssociated, ApiScenariosCase

class ApiScenariosCaseListView(View):

    def get(self, request, *args, **kwargs):
        """
        代表获取所有API接口用例tree-一级目录
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        api_management_data = ApiManagement.objects.filter(parent=0).order_by('-id')

        api_management_list = []

        for api_management in api_management_data:
            api_management_dict = {
                "id": api_management.id,
                "name": api_management.name,
                "parent": api_management.parent,
                "description": api_management.description,
                "icon": "el-icon-folder-opened"

            }
            api_management_list.append(api_management_dict)

        return response_success(api_management_list)

    def post(self, request, *args, **kwargs):
        """
        代表获取所有API接口用例tree-用例
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        body = request.body
        params = json.loads(body)
        api_interfaces_case_list = []

        if params == {}:
            pass

        else:
            api_interfaces_case_data = ApiInterfacesCase.objects.filter(api_management_id=params['parent'])

            for api_interfaces_case in api_interfaces_case_data:
                api_interfaces_case_dict = {
                    "case_id": api_interfaces_case.id,
                    "id": api_interfaces_case.id,
                    "name": api_interfaces_case.api_interfaces_case_name,
                    "children": "",
                    "isParent": True,
                    "icon": "el-icon-tickets"
                }
                api_interfaces_case_list.append(api_interfaces_case_dict)

        return response_success(api_interfaces_case_list)


class InterfacesProjectListView(View):

    def get(self, request, *args, **kwargs):
        """
        代表获取所有API接口项目列表
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        api_management = ApiManagement.objects.filter(parent=0)

        api_management_data_list = []
        for api_management_data in api_management:
            api_management_dict = {
                "api_management_id": api_management_data.id,
                "api_management_name": api_management_data.name,
            }
            api_management_data_list.append(api_management_dict)

        return response_success(api_management_data_list)


class ServiceModuleInterfacesCaseRelationshipView(View):

    def post(self, request, *args, **kwargs):
        """
        代表获取 服务、模块、接口、用例关系
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        body = request.body
        params = json.loads(body)

        api_case = ApiInterfacesCase.objects.get(id=params['case_id'])

        interfaces_name = ApiManagement.objects.get(id=api_case.api_management_id)

        api_module_name = ApiManagement.objects.get(id=interfaces_name.parent)

        api_service_name = ApiManagement.objects.get(id=api_module_name.parent)

        api_management_dict = {
            "interfaces_name": interfaces_name.name,
            "api_module_name": api_module_name.name,
            "api_service_name": api_service_name.name,
        }

        return response_success(api_management_dict)


class ApiScenariosCaseCopyView(View):

    def post(self, request, *args, **kwargs):
        """
        Copy场景用例
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        body = request.body
        params = json.loads(body)

        api_scenarios_case_data = ApiScenariosCase.objects.filter(id=params['sid_id'])

        for api_scenarios_case in api_scenarios_case_data:
            api_scenarios_case_copy = ApiScenariosCase.objects.create(
                api_scenarios_case_name=str(api_scenarios_case.api_scenarios_case_name) + "-Copy",
                api_scenarios_case_describe=api_scenarios_case.api_scenarios_case_describe,
                api_management_id=api_scenarios_case.api_management_id
            )

            api_scenarios_case_associated_copy = ApiScenariosCaseAssociated.objects.filter(sid_id=params['sid_id'])

            for api_scenarios_case_associated in api_scenarios_case_associated_copy:
                ApiScenariosCaseAssociated.objects.create(sid_id=api_scenarios_case_copy.id,
                                                          interfaces_case_id=api_scenarios_case_associated.interfaces_case_id,
                                                          case_steps=api_scenarios_case_associated.case_steps)

        return response_success({"message": "Copy成功！"})
