# Generated by Django 3.1.3 on 2022-08-19 18:25

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='APIDatabase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_database_title', models.CharField(max_length=200, verbose_name='API数据库名称')),
                ('api_host', models.CharField(max_length=200, verbose_name='API_Host')),
                ('api_port', models.CharField(max_length=200, verbose_name='端口号')),
                ('user', models.CharField(max_length=200, verbose_name='用户名')),
                ('password', models.CharField(max_length=200, verbose_name='密码')),
                ('database', models.CharField(max_length=200, verbose_name='数据库表名')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updata_time', models.DateTimeField(auto_now_add=True, verbose_name='更新时间')),
            ],
        ),
        migrations.CreateModel(
            name='APIEnvironment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_environment_name', models.CharField(max_length=200, verbose_name='API环境名称')),
                ('api_title', models.CharField(max_length=200, verbose_name='API环境标题名称')),
                ('api_environment_describe', models.TextField(default='', null=True, verbose_name='API环境描述')),
                ('status', models.BooleanField(default=1, verbose_name='状态')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now_add=True, verbose_name='更新时间')),
            ],
        ),
        migrations.CreateModel(
            name='ApiInterfacesCase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_interfaces_case_name', models.CharField(max_length=200, verbose_name='接口测试用例名称')),
                ('api_documentation', models.TextField(max_length=5000, null=True, verbose_name='API接口文档地址')),
                ('api_method', models.IntegerField(verbose_name='请求方法')),
                ('api_url', models.TextField(verbose_name='API请求地址')),
                ('api_parameter_types', models.IntegerField(verbose_name='参数类型')),
                ('api_headers', models.TextField(verbose_name='请求头')),
                ('api_parameter_body', models.TextField(verbose_name='参数内容')),
                ('api_assert_type', models.IntegerField(verbose_name='断言类型')),
                ('database_sql', models.TextField(blank=True, max_length=8000, null=True, verbose_name='数据库SQL')),
                ('api_assert_text', models.TextField(verbose_name='断言结果')),
                ('update_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('api_environment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apienvironment')),
            ],
        ),
        migrations.CreateModel(
            name='ApiManagement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=200, verbose_name='name')),
                ('description', models.TextField(blank=True, default='', verbose_name='description')),
                ('parent', models.IntegerField(default=0, verbose_name='父节点')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True)),
                ('update_time', models.DateTimeField(auto_now_add=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ApiScenariosCase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_scenarios_case_name', models.CharField(max_length=200, verbose_name='API场景测试名称')),
                ('api_scenarios_case_describe', models.TextField(max_length=5000, null=True, verbose_name='API业务测试描述')),
                ('update_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('api_management', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apimanagement')),
            ],
        ),
        migrations.CreateModel(
            name='ApiTestPlan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_test_plan_name', models.CharField(default='', max_length=100, verbose_name='API测试计划名称')),
                ('api_test_plan_describe', models.TextField(default='', null=True, verbose_name='描述')),
                ('status', models.IntegerField(default=0, verbose_name='状态：')),
                ('cases', models.TextField(default='', verbose_name='关联API用例')),
                ('api_send_email', models.CharField(blank=True, default='', max_length=9999, null=True, verbose_name='API邮件发送')),
                ('api_send_enterprise_wechat', models.IntegerField(blank=True, default='0', verbose_name='API企业微信发送消息')),
                ('timing_task_status', models.CharField(blank=True, default='', max_length=50, null=True, verbose_name='定时任务是否开启')),
                ('starting_time', models.CharField(blank=True, default='', max_length=50, null=True, verbose_name='起始时间')),
                ('end_time', models.CharField(blank=True, default='', max_length=50, null=True, verbose_name='截至时间')),
                ('time_interval_day', models.IntegerField(blank=True, default=0, null=True, verbose_name='间隔时间-天')),
                ('time_interval_minutes', models.IntegerField(blank=True, default=0, null=True, verbose_name='间隔时间-分钟')),
                ('time_interval_hours', models.IntegerField(blank=True, default=0, null=True, verbose_name='间隔时间-小时')),
                ('time_interval_seconds', models.IntegerField(blank=True, default=0, null=True, verbose_name='间隔时间-秒')),
                ('update_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('api_environment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apienvironment')),
                ('api_management', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apimanagement')),
                ('database', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apidatabase')),
            ],
        ),
        migrations.CreateModel(
            name='APITestPlanResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_test_result_name', models.CharField(default='', max_length=200, verbose_name='api测试报告名称')),
                ('api_error_total_number', models.CharField(blank=True, max_length=100, null=True, verbose_name='失败总数')),
                ('api_successful_total_number', models.CharField(blank=True, max_length=100, null=True, verbose_name='成功总数')),
                ('api_total_number', models.CharField(blank=True, max_length=100, null=True, verbose_name='API总数')),
                ('api_environment_id', models.CharField(blank=True, max_length=100, null=True, verbose_name='API环境')),
                ('update_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('api_test_plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apitestplan')),
            ],
        ),
        migrations.CreateModel(
            name='PerformanceProject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('performance_project_name', models.CharField(max_length=50, verbose_name='性能项目名称')),
                ('describe', models.TextField(default='', max_length=2000, null=True, verbose_name='描述')),
                ('status', models.BooleanField(default=1, verbose_name='状态')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
            ],
        ),
        migrations.CreateModel(
            name='PerformanceReport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('performance_report_name', models.CharField(max_length=5000, verbose_name='性能测试报告名称')),
                ('pressure_test_content', models.TextField(max_length=5000, null=True, verbose_name='压测内容')),
                ('file', models.CharField(max_length=5000, null=True, verbose_name='性能测试报告地址')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
            ],
        ),
        migrations.CreateModel(
            name='UIElementsOperation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('elements_operation_name', models.CharField(max_length=500, verbose_name='元素操作名称')),
                ('elements_operation_title', models.CharField(max_length=500, verbose_name='元素操作标题')),
                ('elements_operation_associated_interface', models.CharField(max_length=50, null=True, verbose_name='是否关联接口')),
                ('elements_operation_api_url', models.CharField(max_length=600, null=True, verbose_name='接口地址')),
                ('elements_operation_describe', models.TextField(default='', null=True, verbose_name='描述')),
                ('status', models.BooleanField(default=True, verbose_name='状态')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
            ],
        ),
        migrations.CreateModel(
            name='UIPage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ui_page_name', models.CharField(max_length=50, verbose_name='UI页面名称')),
                ('ui_page_describe', models.TextField(default='', null=True, verbose_name='UI页面描述')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updata_time', models.DateTimeField(auto_now_add=True, verbose_name='更新时间')),
            ],
        ),
        migrations.CreateModel(
            name='UIPageElement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ui_page_element_name', models.CharField(max_length=100, verbose_name='UI页面元素名称')),
                ('ui_page_element', models.CharField(max_length=600, verbose_name='UI页面元素')),
                ('ui_page_element_more', models.CharField(max_length=600, null=True, verbose_name='UI页面元素-多个')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='UIPositioning',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('positioning_name', models.CharField(max_length=50, verbose_name='定位方法名称')),
                ('locating_method', models.CharField(max_length=200, verbose_name='定位方法')),
                ('describe', models.TextField(default='', null=True, verbose_name='描述')),
                ('status', models.BooleanField(default=True, verbose_name='状态')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
            ],
        ),
        migrations.CreateModel(
            name='UIProject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ui_project_name', models.CharField(max_length=50, verbose_name='UI项目名称')),
                ('describe', models.TextField(default='', max_length=2000, null=True, verbose_name='描述')),
                ('status', models.BooleanField(default=1, verbose_name='状态')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
            ],
        ),
        migrations.CreateModel(
            name='UITestCase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ui_test_case_name', models.CharField(max_length=100, verbose_name='UI测试用例名称')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('ui_project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.uiproject')),
            ],
        ),
        migrations.CreateModel(
            name='UITestResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ui_test_result_name', models.CharField(default='', max_length=100, verbose_name='UI测试报告名称')),
                ('ui_error_total_number', models.CharField(blank=True, max_length=100, null=True, verbose_name='失败总数')),
                ('ui_total_number', models.CharField(blank=True, max_length=100, null=True, verbose_name='UI测试用例总数')),
                ('ui_successful_total_number', models.CharField(blank=True, max_length=100, null=True, verbose_name='成功总数')),
                ('ui_test_script', models.CharField(default='', max_length=1000, null=True, verbose_name='UI测试脚本')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
            ],
        ),
        migrations.CreateModel(
            name='UITestTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ui_test_task_name', models.CharField(default='', max_length=100, verbose_name='UI测试任务名称')),
                ('describe', models.TextField(default='', null=True, verbose_name='描述')),
                ('status', models.IntegerField(default=0, verbose_name='状态：')),
                ('cases', models.TextField(default='', verbose_name='关联UI用例')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('ui_project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.uiproject')),
            ],
        ),
        migrations.CreateModel(
            name='UITestResultAssociated',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ui_test_case_name', models.CharField(default='', max_length=100, verbose_name='ui测试用例名称')),
                ('ui_error', models.CharField(blank=True, max_length=100, null=True, verbose_name='失败')),
                ('ui_successful', models.CharField(blank=True, max_length=100, null=True, verbose_name='成功')),
                ('abnormal', models.TextField(blank=True, max_length=5000, null=True, verbose_name='异常')),
                ('ui_assertion_results', models.TextField(blank=True, max_length=5000, null=True, verbose_name='断言结果')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('ui_result', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.uitestresult')),
                ('ui_task', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.uitesttask')),
            ],
        ),
        migrations.AddField(
            model_name='uitestresult',
            name='ui_task',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.uitesttask'),
        ),
        migrations.CreateModel(
            name='UITestCaseAssociated',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('element_operation', models.CharField(max_length=100, verbose_name='元素操作')),
                ('element_input', models.CharField(blank=True, max_length=100, null=True, verbose_name='元素输出')),
                ('x_coordinates', models.CharField(blank=True, max_length=100, null=True, verbose_name='X坐标')),
                ('y_coordinates', models.CharField(blank=True, max_length=100, null=True, verbose_name='Y坐标')),
                ('waiting_time', models.CharField(max_length=100, null=True, verbose_name='等待时间')),
                ('case_steps', models.CharField(max_length=100, null=True, verbose_name='操作步骤')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('cid', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.uitestcase')),
                ('ui_page_elements', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='automated_main.uipageelement')),
            ],
        ),
        migrations.AddField(
            model_name='uipageelement',
            name='ui_element_positioning',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.uipositioning'),
        ),
        migrations.AddField(
            model_name='uipageelement',
            name='ui_page',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.uipage'),
        ),
        migrations.AddField(
            model_name='uipageelement',
            name='ui_project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.uiproject'),
        ),
        migrations.AddField(
            model_name='uipage',
            name='ui_project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='automated_main.uiproject'),
        ),
        migrations.CreateModel(
            name='PerformanceScript',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('performance_script_name', models.CharField(max_length=5000, verbose_name='性能测试脚本名称')),
                ('performance_threads', models.TextField(max_length=5000, verbose_name='线程数')),
                ('performance_ramp_up_time_seconds', models.TextField(max_length=5000, verbose_name='Ramp-Up时间(秒)')),
                ('performance_loop_count', models.TextField(max_length=5000, null=True, verbose_name='循环次数')),
                ('performance_duration', models.TextField(max_length=5000, null=True, verbose_name='持续时间')),
                ('performance_scheduler', models.TextField(max_length=500, verbose_name='调度器')),
                ('loop_count_forever', models.TextField(max_length=500, null=True, verbose_name='循环-永远')),
                ('performance_script', models.CharField(max_length=5000, verbose_name='性能测试脚本')),
                ('performance_status', models.IntegerField(default=0, verbose_name='性能脚本运行状态')),
                ('data_set', models.TextField(max_length=500, null=True, verbose_name='参数化设置')),
                ('performance_data_script', models.TextField(max_length=500, null=True, verbose_name='jmeter参数化文件')),
                ('updata_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('performance_project', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='automated_main.performanceproject')),
            ],
        ),
        migrations.CreateModel(
            name='PerformanceReportError',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('performance_report_error_name', models.CharField(max_length=5000, verbose_name='性能测试报告名称')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now_add=True, verbose_name='更新时间')),
                ('performance_report', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='automated_main.performancereport')),
            ],
        ),
        migrations.AddField(
            model_name='performancereport',
            name='performance_script',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='automated_main.performancescript'),
        ),
        migrations.CreateModel(
            name='APITestPlanResultAssociated',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_test_case_name', models.CharField(default='', max_length=100, verbose_name='api测试用例名称')),
                ('api_error', models.CharField(blank=True, max_length=100, null=True, verbose_name='失败')),
                ('api_successful', models.CharField(blank=True, max_length=100, null=True, verbose_name='成功')),
                ('abnormal', models.TextField(blank=True, max_length=5000, null=True, verbose_name='异常')),
                ('json_extract_variable_conversion', models.TextField(blank=True, max_length=5000, null=True, verbose_name='json提取变量转换')),
                ('api_assertion_results', models.TextField(blank=True, max_length=50000, null=True, verbose_name='断言结果')),
                ('api_variable_results', models.TextField(blank=True, max_length=5000, null=True, verbose_name='参数提取')),
                ('api_request_results', models.TextField(default=None, max_length=500000, null=True, verbose_name='API请求结果')),
                ('api_business_test_name', models.TextField(blank=True, max_length=5000, null=True, verbose_name='API业务测试名称')),
                ('api_header', models.TextField(blank=True, max_length=5000, null=True, verbose_name='header')),
                ('api_url', models.TextField(blank=True, max_length=5000, null=True, verbose_name='请求地址')),
                ('api_body', models.TextField(blank=True, max_length=5000, null=True, verbose_name='body')),
                ('update_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('api_result', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apitestplanresult')),
                ('api_test_plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apitestplan')),
            ],
        ),
        migrations.CreateModel(
            name='ApiScenariosCaseAssociated',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('case_steps', models.CharField(max_length=100, verbose_name='操作步骤')),
                ('update_time', models.DateTimeField(auto_now_add=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('interfaces_case', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apiinterfacescase')),
                ('sid', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apiscenarioscase')),
            ],
        ),
        migrations.CreateModel(
            name='ApiInterfacesParameterExtraction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_variable_results', models.TextField(max_length=5000, null=True, verbose_name='变量提取结果')),
                ('api_value_variable', models.TextField(max_length=5000, null=True, verbose_name='提取变量')),
                ('api_key_variable', models.TextField(max_length=5000, null=True, verbose_name='关键字变量名称')),
                ('api_test_case', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apiinterfacescase')),
            ],
        ),
        migrations.CreateModel(
            name='ApiInterfacesParameterData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_parameter_name', models.CharField(max_length=500, null=True, verbose_name='参数名称')),
                ('api_must_parameter', models.TextField(max_length=50, null=True, verbose_name='必填')),
                ('api_parameter_value', models.TextField(max_length=5000, null=True, verbose_name='参数值')),
                ('api_field_describe', models.TextField(max_length=5000, null=True, verbose_name='字段描述')),
                ('api_test_case', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apiinterfacescase')),
            ],
        ),
        migrations.AddField(
            model_name='apiinterfacescase',
            name='api_management',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apimanagement'),
        ),
        migrations.AddField(
            model_name='apiinterfacescase',
            name='dataBase',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='automated_main.apidatabase'),
        ),
        migrations.CreateModel(
            name='APIGlobalVariable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_global_variable_name', models.TextField(max_length=5000, null=True, verbose_name='全局变量名称')),
                ('api_global_variable_value', models.TextField(max_length=5000, null=True, verbose_name='全局变量值')),
                ('api_global_variable_describe', models.TextField(max_length=5000, null=True, verbose_name='全局变量描述')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now_add=True, verbose_name='更新时间')),
                ('api_environment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='automated_main.apienvironment')),
            ],
        ),
    ]
