"""
@autor:Yue
@date::16:37
@file:requestResult.py
@project:appQutoInfo

"""

from blueprints.tools.dealCasefile import readCaseFile,writeCaseFile

from blueprints.tools.dealDatabase import dealParamSql,delDatabase
from blueprints.tools.dealScene import  dealScene
from blueprints.tools.dealbody import requesturl,dealbodyHeaderType,deal_globalParam,setGloablValue,setup_step
from blueprints.tools.rwKeyData import rwKeyData
import requests,jsonpath,re,json,os,pickle
from blueprints.settings import testConfig,qaConfig,ka2Config,qa2Config,test1Config,qa3Config,msgConfig,config as kconfig
import warnings,demjson,base64,urllib3,time,html
from blueprints.tools.debugtalk import finalexecaql
from urllib.parse import  urlencode
from blueprints.tools.deals import getenv,getenvconfig,dealSign
from requests_toolbelt.multipart.decoder import MultipartDecoder

from urllib.parse import  urlencode,unquote
warnings.filterwarnings("ignore")

class requestResult:
    def __init__(self,config,casefile):
        self.casefilemeta=casefile
        self.casefile=readCaseFile(casefile)

        self.config = config
        self.config = kconfig.get(self.casefile.get('env')) or self.config

        self.keydata = rwKeyData(config)
        #setGloablValue(self.keydata,self.casefile)

        try:
            setup_step(self.casefile)
            self.casefile = deal_globalParam(self.config, self.casefile)
        except:
            self.casefile = deal_globalParam(self.config, self.casefile)
            setup_step(self.casefile)

        #print('*****',self.casefile)
        self.casefilename=casefile
        self.namespace=self.config.namespace
        self.finalresult=[]
        self.baseSleepTime=self.keydata.readKeyData('baseinfo','defaluttime') or 2
        self.timeout=int(self.keydata.readKeyData('baseinfo','timeout')) or 20
        self.keydata.deleteKeyData('circleData')



    def person_timeout(self):
        msg={
            "code":"0001",
            "msg":"响应超时",
            "source":"python_yue"
        }
        return msg


    def afterdeallsql(self,sql, section, k="logindata"):
        #将手机号存储在KeyData配置文件中，功能类似数据库的表
        colum = "username"
        recolum = "username"
        revalue = self.keydata.readKeyData(section,k)


        revalue = self.keydata.readKeyData(section, k)
        #print("re=====",section,k,revalue)

        sql=dealParamSql(sql,colum,recolum,revalue)

        colum = 'phone_no'
        recolum = 'phone'
        revalue=self.keydata.readKeyData(section,k)

        sql = dealParamSql(sql, colum, recolum, revalue)

        colum = 'phone_no'
        recolum = 'logindata'
        revalue = self.keydata.readKeyData(section, k)
        sql = dealParamSql(sql, colum, recolum, revalue)

        return sql


    def getsqldate(self):
        section = "globalvar"
        db = self.casefile.get("db", None)

        if self.casefile.get("aftersql"):
            #print("===exec sql===")
            sql=self.afterdeallsql(self.casefile.get("sql"),section)
            #print(sql)
            sqlData=delDatabase(self.config,sql,db)
        # print("从表里查到的数据===",sqlData,sql)
        return sqlData


    def keyoption(self):
        ##setGloablValue(self.keydata, self.casefile)
        #self.need_print()
        url,type=requesturl(self.config,self.casefile)
        #print(url)
        section="globalvar"
        try:
            _url=url.format(namespace=self.namespace)
        except:
            _url=url

        db=self.casefile.get("db",None)
        method=self.casefile.get("method","get")
        commit=self.casefile.get("commit")
        isurl=self.casefile.get("isurl")
        #print( re.findall(r"({.*})",self.casefile.get("url")))
        if self.casefile.get("sql") and (re.findall(r"%s",str(self.casefile.get("param"))) or re.findall(r"%s",str(self.casefile.get("body")))
                                         or  re.findall(r"{{(.*)}}",self.casefile.get("url")) or re.findall(r"%s",self.casefile.get("url"))):
            #print("===exec sql===")
            sql=self.afterdeallsql(self.casefile.get("sql"),section)
            #print("==="*10,sql)
            sqlData=delDatabase(self.config,sql,db)
            self.keydata.writeKeyData('sqldata','sqldata',sqlData)

            #print("从表里查到的数据===", sqlData,self.casefile,sql)


            casejson = dealbodyHeaderType(self.config, self.casefile, sqlData)
            casejson =dealSign(casejson)
            #print(casejson)
            header=casejson.get('header')or casejson.get('Headers')
            body=casejson.get('body')
            _url=_url+casejson.get('url')
            #print(header,casejson)
            for k in header.keys():

                if 'token'==k.lower() or 'x-auth-token'==k.lower() or 'token' in k.lower():
                    if 'token' in header.get(k):
                        token = self.keydata.readKeyData(section, header.get(k))
                    #print("token======",k,token,header.get(k))
                        header[k]=token or "NOTFOUND"


            return _url, method, body, header,casejson.get('param'), commit, isurl

        #body,header=dealbodyHeaderType(self.config,self.casefile)
        casejson = dealbodyHeaderType(self.config, self.casefile)
        casejson = dealSign(casejson)
        header = casejson.get('header') or casejson.get('Headers')
        body = casejson.get('body')
        _url = _url + casejson.get('url')
        #print(header,casejson)
        for k in header.keys():
            if 'token' == k.lower() or 'x-auth-token' == k.lower() or 'token' in k.lower():
                if 'token' in header.get(k):
                    token = self.keydata.readKeyData(section, header.get(k))
                    header[k] = token or "NOTFOUND"
        return _url, method, body, header,casejson.get('param'),commit,isurl



    def writeKeyDatafile(self,name,data):
        #print(data,name)
        try:
            if data:
                if isinstance(data,list):

                    self.keydata.writeKeyData('baseinfo', name, data[0] if data else None)
                else:
                    self.keydata.writeKeyData('baseinfo', name, data if data else None)
        except:
            pass






    def saveKeyData(self,v,savevalue='token',flag=False):
        #v可以是请求body，也可以是响应数据
        url, type = requesturl(self.config, self.casefile)
        section="globalvar"

        if '/login/receive_token' not in url and re.findall(r"login|signin|",url):
            if flag:
                k="logindata"
                self.keydata.writeKeyData(section,k,v)
        if '/querySQL/qa/xyqb' in url:
            if '查询用户审核记录' in self.casefile.get('commit'):
                self.keydata.writeKeyData(section, 'quotaRecordOrderNo', v)
            elif '查询loanID' in self.casefile.get('commit'):
                self.keydata.writeKeyData(section, 'loanID', v)


        token=jsonpath.jsonpath(v,"$..token")

        money=jsonpath.jsonpath(v,"$..money")
        applyno = jsonpath.jsonpath(v, "$..applyNo")

        requestId=jsonpath.jsonpath(v,'$..requestId')
        phone_no = jsonpath.jsonpath(v, '$..phoneNo')
        #print("phone_no cunc==========",phone_no)

        vcode=jsonpath.jsonpath(v,'$..vcode')

        totalAmount=jsonpath.jsonpath(v,'$..totalAmount')
        # verificationid

        verificationId=jsonpath.jsonpath(v,'$..verificationId')

        #print(verificationId)
        self.writeKeyDatafile('verificationId', verificationId)

        #考拉还款
        totalLoanAmount=jsonpath.jsonpath(v,'$..requiredRepayment')
        termno=jsonpath.jsonpath(v,'$..periodNo')
        repaymentStatus=jsonpath.jsonpath(v,'$..repaymentStatus')

        if totalLoanAmount and termno and repaymentStatus:
            ta=list(zip(totalLoanAmount,termno,repaymentStatus))
            #print('=====',[i for i in ta if i[-1]==0])
            totalLoanAmount,termno,repaymentStatus=[i for i in ta if i[-1]==0][0]
            #print(totalLoanAmount,termno,repaymentStatus)
            self.writeKeyDatafile('totalloanamount', totalLoanAmount)
            self.writeKeyDatafile('termno', termno)
            self.writeKeyDatafile('repaymentstatus', repaymentStatus)


        loanid = jsonpath.jsonpath(v, '$..loanId')

        #print(vcode)
        if requestId:
            self.keydata.writeKeyData(section, 'requestid', requestId[0])
        if vcode:
            self.keydata.writeKeyData(section, 'vcode', vcode[0])

        try:
            if isinstance(v,dict):
                #print("v======",v)
                if 'token' in str(v):
                    othertoken=re.findall(r'token=(.*?)&', str(v))
                    #print("====",othertoken,type)
                    if othertoken and len(othertoken) > 0:
                        self.keydata.writeKeyData(section, type + "token", othertoken[0] if othertoken else None)
        except:
            pass

        #print("token==",token)
        if token and len(token)>0:
            self.keydata.writeKeyData(section, type+"token", token[0] if token else None)
        if money and len(money)>0:
            self.keydata.writeKeyData(section, "money", money[0] if token else None)

        if phone_no and len(phone_no)>0:
            self.keydata.writeKeyData('baseinfo', "phone_no", phone_no[0] if phone_no else None)

        if applyno and len(applyno)>0:
            self.keydata.writeKeyData('baseinfo', "applyno", applyno[0] if applyno else None)

        if totalAmount and len(totalAmount)>0:
            self.keydata.writeKeyData('baseinfo', "totalamount", totalAmount[0] if totalAmount else None)

        if loanid and len(loanid)>0:
            self.keydata.writeKeyData('baseinfo', "loanid", loanid[0] if loanid else None)

    def dealResquest(self,url, method, body, header,commit,isurl,param,jianrongces,headertype,sleeptime):
        try:
            if method.lower()=="get":
                if body or param:

                    with open("cookie.txt", "rb") as file:
                        with open("cookie.txt", "wb+") as wfile:
                            pickle.dump(jianrongces, wfile)

                        if param and body:
                            #print('212123123',url + "?" + body)

                        #     result = requests.get(url + "?" + body, headers=header, verify=False,
                        #                            cookies=pickle.load(file),timeout=5)
                        # else:
                            result = requests.get(url, params=param,data=body, headers=header, verify=False, cookies=pickle.load(file),timeout=self.timeout)
                        elif param:
                            #print("+++"*20)
                            result = requests.get(url, params=param, headers=header, verify=False,
                                                  cookies=pickle.load(file), timeout=self.timeout)
                        else:
                            #print("+++"*20,3,body,type(body))
                            result = requests.get(url, params=body, headers=header, verify=False,
                                                  cookies=pickle.load(file), timeout=self.timeout)


                    #result=requests.get(url,params=body,headers=header,verify=False)
                else:
                    with open("cookie.txt", "rb") as file:
                        with open("cookie.txt", "wb+") as wfile:
                            pickle.dump(jianrongces, wfile)
                        result = requests.get(url, headers=header, verify=False, cookies=pickle.load(file),timeout=self.timeout)
                    #result = requests.get(url, headers=header,verify=False)

            if method.lower()=="post":
                #print('======',body,param)
                if body:
                    with open("cookie.txt","rb") as file:
                        with open("cookie.txt", "wb+") as wfile:
                            pickle.dump(jianrongces, wfile)
                        if 'json' in headertype :
                            if isinstance(body,str):
                                #print(body.replace("'","\"").replace('\\"',"'"))
                                body=body.replace("'","\"").replace('\\"',"'").replace('`','')
                                body = body.encode("utf-8")

                                result = requests.post(url, data=body, headers=header, verify=False,
                                                   cookies=pickle.load(file),timeout=self.timeout)
                            else:
                                #print(body)
                                result = requests.post(url, json=body, headers=header, verify=False, cookies=pickle.load(file),timeout=self.timeout)
                        elif 'urlencoded' in headertype:
                            #print(pickle.load(file))

                            if param and body:
                                #print('212123123',url + "?" + body)
                                with open("cookie.txt", "wb+") as wfile:

                                    pickle.dump(jianrongces, wfile)

                                result = requests.post(url, params=param, data=body, headers=header, verify=False,
                                                      cookies=pickle.load(file), timeout=self.timeout)
                            elif param:
                                #print("+++1"*20)
                                result = requests.post(url, params=param, headers=header, verify=False,
                                                      cookies=pickle.load(file), timeout=self.timeout)
                            elif isurl:
                                result = requests.post(url, params=body, headers=header, verify=False,
                                                      cookies=pickle.load(file), timeout=self.timeout)
                            else:

                                if isinstance(body,dict):
                                    body=urlencode(body)

                                result = requests.post(url, data=body, headers=header, verify=False,
                                                      cookies=pickle.load(file), timeout=self.timeout)
                        else:
                            result = requests.post(url, data=body, headers=header, verify=False,
                                                    timeout=self.timeout)


                else:
                        with open("cookie.txt", "wb+") as wfile:
                            pickle.dump(jianrongces, wfile)
                        if param:
                            # print("+++1"*20)
                            result = requests.post(url, params=param, headers=header, verify=False,
                                                   timeout=self.timeout)
                        else:
                                result=requests.post(url,headers=header,verify=False,timeout=self.timeout)


            elif method.lower()=="delete":
                if body:
                    with open("cookie.txt","rb") as file:
                        with open("cookie.txt", "wb+") as wfile:
                            pickle.dump(jianrongces, wfile)
                        if isurl:
                            result = requests.delete(url+"?"+body, headers=header, verify=False, cookies=pickle.load(file),timeout=self.timeout)
                        else:
                            result=requests.delete(url,json=body,headers=header,verify=False,cookies=pickle.load(file),timeout=self.timeout)
                else:
                    with open("cookie.txt", "rb") as file:
                        pickle.dump(jianrongces, open("cookie.txt", "wb+"))
                        result = requests.delete(url, headers=header,verify=False,cookies=pickle.load(file),timeout=self.timeout)

            elif method.lower()=="put":
                if body:
                    with open("cookie.txt","rb") as file:
                        with open("cookie.txt", "wb+") as wfile:
                            pickle.dump(jianrongces, wfile)
                        if 'json' in headertype:
                            if isinstance(body,dict):
                                result=requests.put(url,json=body,headers=header,verify=False,cookies=pickle.load(file),timeout=self.timeout)
                            else:
                                result = requests.put(url, json=json.loads(body), headers=header, verify=False,
                                                      cookies=pickle.load(file), timeout=self.timeout)

                        elif 'urlencoded' in headertype:
                            if isurl:
                                result = requests.put(url+"?"+body, headers=header, verify=False, cookies=pickle.load(file),timeout=self.timeout)
                            else:
                                result = requests.put(url, data=body, headers=header, verify=False,
                                                      cookies=pickle.load(file),timeout=self.timeout)

                else:
                    with open("cookie.txt", "rb") as file:
                        with open("cookie.txt", "wb+") as wfile:
                            pickle.dump(jianrongces, wfile)
                        result = requests.put(url, headers=header,verify=False,cookies=pickle.load(file),timeout=self.timeout)
            elif method.lower()=='patch':

                if body:
                    with open("cookie.txt","rb") as file:
                        with open("cookie.txt", "wb+") as wfile:
                            pickle.dump(jianrongces, wfile)
                        if 'json' in headertype:
                            if isinstance(body,dict):
                                result=requests.patch(url,json=body,headers=header,verify=False,cookies=pickle.load(file),timeout=self.timeout)
                            else:
                                #print("=====",body)
                                body = body.replace("'", "\"").replace('\\"', "'").replace('`', '')
                                #print("=====", body,type(body))
                                result = requests.patch(url, json=json.loads(body), headers=header, verify=False,
                                                      cookies=pickle.load(file), timeout=self.timeout)
                        elif 'urlencoded' in headertype:
                            if isurl:
                                result = requests.patch(url+"?"+body, headers=header, verify=False, cookies=pickle.load(file),timeout=self.timeout)
                            else:
                                result = requests.patch(url, data=body, headers=header, verify=False,
                                                      cookies=pickle.load(file),timeout=self.timeout)

                else:
                    with open("cookie.txt", "rb") as file:
                        with open("cookie.txt", "wb+") as wfile:
                            pickle.dump(jianrongces, wfile)
                        result = requests.patch(url, headers=header,verify=False,cookies=pickle.load(file),timeout=self.timeout)

            result.encoding = "utf-8"

            if re.findall(r'login|signin',url):
                try:
                    #if re.findall(r'username|phone|Phone', json.dumps(body)):
                    self.saveKeyData(result.json())
                except:
                    pass
                if not os.path.exists('cookie.txt'):
                    os.system("touch cookie.txt")
                    #
                with open("cookie.txt","wb")as file:
                    #print(result.cookies)
                    #print(result.cookies)
                    pickle.dump(result.cookies,file)

            else:
                try:
                    #print(12312321321)
                    self.saveKeyData(result.json())
                    #self.saveKeyData(body)
                except Exception as e:
                    #print(e)
                    pass


            try:
                unicodetostr = 'u' + "'" + json.dumps(result.json()) + "'"
            except:
                unicodetostr = 'u' + "'" + result.text + "'"

            try:
                if '<!DOCTYPE html>' in result.text or len(result.text) >= 3000:

                    print("响应数据11===", re.findall(r'<title>(.*)</title>',result.text)[0]  if re.findall(r'<title>(.*)</title>',result.text) else "html文本略" + "........", "=======end3")
                    print("<br>")
                else:
                    print("响应数据1===",eval(unicodetostr),"=======end1")
                    print("<br>")

            except:
                try:
                    print("响应数据2===",result.json(),"=======end2")
                    print("<br>")

                except Exception as e:
                    if '<!DOCTYPE html>' in result.text or len(result.text)>=3000:
                        print("响应数据3===",re.findall(r'<title>(.*)</title>',result.text)[0] if re.findall(r'<title>(.*)</title>',result.text) else "html文本略"+"........","=======end3")
                        print("<br>")

                    else:
                        print("响应数据4===",result.text[0:10],"=======end4")
                        print("<br>")



            #print('断言结果==',asertcase(self.casefilemeta,result))
            #self.deal_followupWork()
            if sleeptime:
                time.sleep(int(sleeptime))
            # else:
            #     time.sleep(int(self.baseSleepTime))
            return result
            # if result.status_code==200:
            #     self.saveKeyData(result.json())
            #     return result.json()
            # return result.text

        except (urllib3.exceptions.ReadTimeoutError, requests.exceptions.ReadTimeout):
            print("响应数据5===", self.person_timeout(),"=======end")
            print("<br>")

            return self.person_timeout()

    def requestJson(self):
        i=1
        while True:
            sleeptime = self.casefile.get('sleep')
            jianrongces = dict(ces="testing")
            url, method, body, header,param, commit, isurl = self.keyoption()
            #print(url, method, body, header,param, commit, isurl )


            if header.get("Authorization"):
                t = bytes.decode(base64.b64decode(header.get("Authorization").split()[-1]))
                temp = "phone={0}".format(t.split(":")[0])
                self.saveKeyData(temp, flag=True)
            else:
                #print(body)
                if (re.findall(r'login', url) and re.findall(r'username|phone|Phone',
                                                            json.dumps(body)) and not re.findall(
                        r'select|insert|update', json.dumps(body))) or re.findall(r'/credit_order/create',url) \
                        or re.findall(r'/early_settlement/plan',url):

                    self.saveKeyData(body, flag=True)
            print("请求url==", url)
            print("<br>")
            print("请求method==", method)
            print("<br>")
            try:
                print("请求body1==", unquote(body))
            except:
                if param:
                    print("请求body2==", param)
                else:
                   if 'form-data' in header.get('Content-Type'):
                        print("由于multipart/form-data格式,测试报告页面无法显示body，可通过开发者模式查看详细数据")
                   else:
                       print("请求body3==", body)
            print("<br>")
            print("请求header==", header)
            print("<br>")
            print("请求commit(说明)==", commit)
            print("<br>")
            basis = self.casefile.get('result')
            print("响应中非必须字段== ", basis.get('notmustexist')) if basis and basis.get('notmustexist') else None
            print("<br/>")


            headertype = header.get("Content-Type") or header.get("content-type")

            #print("circleflag=====",self.keydata.readKeyData('circleData', 'circleflag'))
            try:
                if self.keydata.readKeyData('channnel','issimple')=='1':
                    self.keydata.writeKeyData('circleData', 'circleflag',0)

                circleparam=int(self.keydata.readKeyData('circleData', 'circleflag'))
            except:
                circleparam=0


            result=self.dealResquest(url, method, body, header,commit,isurl,param,jianrongces,headertype,sleeptime)

            from blueprints.tools.asertcase import asertcase
            t = asertcase(self.casefilemeta, result, self.config)
            #print(self.casefilename)

            self.finalresult.append(t)
            #print("circleparam====",circleparam)
            print("<br>")
            print("====" * 10, '下一个请求', "====" * 10)
            print("<br>")
            print("<br>")
            if circleparam<=0:
                self.keydata.deleteKeyData('circleData')
                #print("=========ecex======*******",self.keydata.readKeyData('circleData', 'circleflag'))

                return result,self.finalresult
            else:
                circleparam=circleparam-1
                self.keydata.writeKeyData('circleData', 'circleflag',int(self.keydata.readKeyData('circleData', 'circleflag'))-1)



            if '前往提现页' in commit and '账户不存在'==result.json().get('msg'):
                time.sleep(60)
                if i>2:
                    break
                i+=1
            elif '绑卡后提现' in commit and '成功'!=result.json().get('msg'):
                time.sleep(60)
                if i > 3:
                    break
                i += 1
            elif '二次风控' in commit and 'uuid=0'in body:
                time.sleep(20)
                if i > 3:
                    break
                i += 1
            elif '进入支付绑卡' in commit and 'accountId=0' in body:
                time.sleep(20)
                if i > 3:
                    break
                i += 1

            # else:
            #     break

        print("断言结果=====",self.finalresult)
        return result,self.finalresult




if __name__ == '__main__':
    #"281.json","282.json",
    # casefile = [{"hetong": []}]
    # for i in range(43):
    #     casefile[0]["hetong"].append(str(280+i)+".json")
    #print(casefile)
    #casefile=[{'hetong': ['280.json', '283.json', '284.json', '299.json', '300.json', '301.json', '302.json', '319.json', '320.json', '321.json', '322.json']}]
    #casefile=[{'hetong':[]}]
    #casefile = [{'hetong': ["267.json"]}]


    # ##合同接口用例
    # casefile=[{'hetong':['281.json','282.json']}]
    # otherfile=['243.json', '244.json', '245.json', '246.json', '247.json', '248.json', \
    #           '249.json', '250.json', '251.json', '252.json', '253.json', '254.json',\
    #           '255.json', '256.json', '257.json', '258.json', '259.json', '260.json', \
    #           '261.json', '262.json', '263.json', '264.json', '265.json', '266.json',\
    #           '267.json', '268.json', '269.json', '270.json', '271.json', '272.json',
    #           '283.json','284.json','299.json','300.json','301.json','302.json','319.json',
    #            '320.json','321.json','322.json']
    #
    #
    # totalfile=casefile[0].get("hetong")+otherfile
    # casefile[0]['hetong']=totalfile
    # casefile=[{'hetong':['259.json']}]


    ##信用钱包接口用例

    #casefile=[{'passportapi':['328.json']}]
    #casefile=[{"hetong":['322.json','322.json','322.json','322.json','322.json']}]

    #casefile=[{'passportapi':['323.json','357.json','361.json']}]#,'359.json','360.json']}]
    #casefile=[{'passportapi':['372.json']}]
    #casefile=[{"hetong":['322.json','322.json','322.json','322.json','322.json']}]

    cases_number = [323, 382, 383, 384, 385, 357, 361, 358, 359, 360, 361]
    cases_number= [323,399,358, 359, 360,362,365,366,367]
    cases_number = [323, 368, 371, 372, 374, 375, 376, 377, 378]


    cases_number = [323, 379, 396, 380, 375, 363, 359, 358, 362, 374, 381, 378, 397,
                    373, 365, 390, 369, 386, 368, 387, 391, 364, 372, 388, 367, 371,
                    384, 392, 393, 385, 370, 389, 366, 382, 394, 361, 398, 377, 399, 376, 360, 395, 383]


    cases_number=[ 398, 377, 399, 376, 360, 395, 383]

    cases_number = [358, 359, 360, 323, 357, 400, 361, 399, 367, 368, 371, 372, 374, 375, 376, 378, 363, 364, 369, 358,
                    370, 373, 386,
                    387, 388, 389, 390, 391, 392, 389, 390, 393, 394, 395, 396, 397]

    #cases_number=[323, 368, 371, 372, 374, 375, 376, 378]
    #cases_number=[409,373,410,411]

    cases_number=[358, 359, 360,323, 382, 383, 384, 385,361, 402, 403,404, 405,401]

    ###授信,xyqb.assign_funding_record.assign_status=3
    cases_number= [358, 359, 360,323, 382, 383, 384, 385,361, 402, 403, 404, 405,401,399,407,367]
    ###绑卡payment_center.user，loan_application_history.process=50
    cases_number=[368,371,372,374,375,376,378]
    ####二次风控loan_application_history.process从50到20
    cases_number=[364]
    ####修改合同状态
    cases_number=[369]
    ###提现1
    cases_number=[370,409,373,410]
    ###提现2
    cases_number=[412,411]

    ###还款-查询相关卡记录
    cases_number=[323,387, 388,389,390, 391, 392]


    #cases_number=[323,387, 388,389,390, 391, 392,389, 390, 393, 394, 395, 396, 397]

    #cases_number=[416, 420, 421, 417, 426, 427, 431, 424, 432, 428, 425, 414, 422, 418, 419, 423, 415]
    cases_number=[358, 359, 360,323, 382, 383, 384, 385,361, 402, 403,404, 405,401]
    cases_number = [323]

    cases_number=[323, 382, 383, 384, 385,361, 402, 403, 404, 405,401,399,407,367,368]
    cases_number = [590, 591, 592] #530
    cases_number=[565, 566, 607, 608, 609, 610, 611]


    #cases_number= [323, 382, 383, 384, 385,361, 402, 403, 404, 405,401]

    cases_number= [323, 382, 383, 384, 385,361, 402, 403, 404, 405]
    cases_number=[786]
    cases_number = [445]
    cases_number=[611]

    #cases_number = [369,370,409,373]
    #cases_number=[358, 359, 360,323, 382, 383, 384, 385,361, 402, 403, 404, 405,401,399,407,367,368,371,372,374,375,376,378,363,364,369,370]
    t = '.json,'.join([str(i) for i in cases_number]) + ".json"
    #casefile = [{'passportapi':['323.json', '382.json','383.json', '384.json', '385.json']},{'payment': t.split(',')}]


    casefile =[{'payment': t.split(',')}]


    #casefile = [{'ka_koala_repay': t.split(',')}]

    #print(casefile)

    testc=getenvconfig()
    f=dealScene(testc,casefile)
    #print(f)
    for i in f:
        for k,v in i.items():
            #print(k,v)
            for ii in v:
                #print(ii)
                a=requestResult(testc,ii)

                #a.deal_followupWork()

                t=a.requestJson()

                print("=="*10,"end","=="*10)
                # tt = jsonpath.jsonpath(t.json(), '$..image')[0].split(',')[-1]
                #
                print(t)
                # ttt=base64.b64decode(tt)
                #
                # with open('1.jpg','wb') as f:
                #     f.write(ttt)

                # from PIL import Image
                # import pytesseract
                #
                # t=Image.open('1.jpg')

                #bytes.decode(base64.b64decode(header.get("Authorization").split()[-1]))
                #print(bytes.decode(ttt,encoding=))


