/*
 * Decompiled with CFR 0.152.
 */
package com.asc.utils.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceUtil.class);

    public boolean persistence(String PersistenceResposity, String dataFile, String data) {
        boolean result = true;
        String persistencePath = this.getPersistencePath(PersistenceResposity);
        this.mkdir(persistencePath);
        this.mkfile(persistencePath, dataFile);
        try {
            FileWriter fileWriter = new FileWriter(persistencePath + File.separator + dataFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(data);
            bufferedWriter.close();
        }
        catch (Exception e) {
            result = false;
            LOGGER.error("", (Throwable)e);
        }
        return result;
    }

    public String load(String PersistenceResposity, String dataFile) {
        String persistencePath = this.getPersistencePath(PersistenceResposity);
        BufferedReader reader = null;
        StringBuffer lines = new StringBuffer("");
        try {
            File file = new File(persistencePath + File.separator + dataFile);
            if (file.exists()) {
                String line;
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    lines.append(line);
                }
                reader.close();
            } else {
                LOGGER.error(file.getPath() + " FileNotFound");
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return lines.toString();
    }

    private String getPersistencePath(String PersistenceResposity) {
        return System.getProperty("user.dir") + File.separator + PersistenceResposity;
    }

    private void mkdir(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private void mkfile(String dir, String filename) {
        File file = new File(dir, filename);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public boolean isFileExist(String PersistenceResposity, String fileName) {
        String persistencePath = this.getPersistencePath(PersistenceResposity);
        File file = new File(persistencePath, fileName);
        return file.exists();
    }

    public void rmDir(String PersistenceResposity) {
        String persistencePath = this.getPersistencePath(PersistenceResposity);
        File file = new File(persistencePath);
        if (file.exists()) {
            file.delete();
        }
    }
}

