/*
 * Decompiled with CFR 0.152.
 */
package com.asc.es.service.impl;

import com.alibaba.fastjson.JSON;
import com.asc.es.bean.EsRequest;
import com.asc.es.bean.EsSync;
import com.asc.es.bean.EsSystem;
import com.asc.es.dao.EsRequestDao;
import com.asc.es.dao.EsSyncDao;
import com.asc.es.dao.EsSystemDao;
import com.asc.es.service.PushInterfaces;
import com.asc.es.service.impl.BaseImpl;
import com.asc.utils.file.PersistenceUtil;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class PushInterfacesImpl
extends BaseImpl
implements PushInterfaces {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushInterfacesImpl.class);
    private static boolean isPush = false;
    @Value(value="${atm_push_url}")
    String atmPushUrl;
    @Autowired
    EsRequestDao erdImpl;
    @Autowired
    EsSystemDao esdImpl;
    @Autowired
    EsSyncDao esnImpl;
    private String day;
    OkHttpClient client = new OkHttpClient();

    public void pushInterfaces(boolean isSheduler) {
        if (!isPush) {
            isPush = true;
            this.day = this.getDate();
            try {
                this.push(isSheduler);
            }
            catch (Exception e) {
                LOGGER.error("=======push ", (Throwable)e);
            }
            finally {
                isPush = false;
            }
        }
    }

    private void push(boolean isSheduler) {
        EsSync esync = this.esnImpl.select(this.day);
        if (esync == null) {
            esync = new EsSync();
            esync.setDay(this.day);
            esync.setIsSync(0);
            esync.setCount(0);
            esync.setResult("never push");
            this.esnImpl.insert(esync);
        } else if (isSheduler && esync.getIsSync() == 1) {
            LOGGER.warn(" *********** scheduler:{} push {} is alerday sync ", (Object)isSheduler, (Object)this.day);
            return;
        }
        PersistenceUtil pu = new PersistenceUtil();
        String day = this.getDate();
        List essl = this.esdImpl.selectAll();
        HashMap content = new HashMap();
        ArrayList lm = new ArrayList();
        int changeTotalCount = 0;
        for (EsSystem esSystem : essl) {
            List esrl = this.erdImpl.selectByExplainDay(day, esSystem.getId());
            HashMap<String, Serializable> system = new HashMap<String, Serializable>();
            ArrayList detail = new ArrayList();
            int changeCount = 0;
            for (EsRequest er : esrl) {
                HashMap<String, Object> erm = new HashMap<String, Object>();
                erm.put("request_url", er.getRequestUrl());
                erm.put("class_name", esSystem.getSysAlias());
                erm.put("content_type", er.getContentType());
                erm.put("path", er.getPath());
                erm.put("type", er.getType());
                erm.put("restful_params", JSON.parseObject((String)er.getRestfulParams()));
                erm.put("body", JSON.parseObject((String)er.getBody(), HashMap.class));
                erm.put("route_params", JSON.parseObject((String)er.getRouterParams(), HashMap.class));
                erm.put("param_names", JSON.parseObject((String)er.getParamNames(), ArrayList.class));
                erm.put("timestamp", er.getTimestamp());
                changeCount += er.getIsChange().intValue();
                detail.add(erm);
            }
            HashMap<String, Integer> summary = new HashMap<String, Integer>();
            if (esync.getIsSync() == 1) {
                summary.put("change_flag", 0);
            } else {
                summary.put("change_flag", changeCount > 0 ? 1 : 0);
            }
            summary.put("total_count", esrl.size());
            system.put("detail", detail);
            system.put("status", Integer.valueOf(0));
            system.put("summary", summary);
            content.put(esSystem.getSysAlias(), system);
            changeTotalCount += changeCount;
        }
        LOGGER.warn(" *********** scheduler:{} push {} is total count is 0 ", new Object[]{isSheduler, day, changeTotalCount});
        if (isSheduler && changeTotalCount > 0) {
            LOGGER.warn(" *********** stop push ");
            return;
        }
        this.http(JSON.toJSONString(content));
    }

    private void http(String body) {
        try {
            EsSync esync = this.esnImpl.select(this.day);
            RequestBody requestbody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body);
            Request request = new Request.Builder().url(this.atmPushUrl).addHeader("content-type", "application/json").addHeader("cache-control", "no-cache").post(requestbody).build();
            Response response = this.client.newCall(request).execute();
            String responseBody = String.valueOf(response.body().string());
            LOGGER.info("====================push {} result {} ", (Object)this.day, (Object)responseBody);
            if (response.code() == 200) {
                esync.setIsSync(1);
            }
            esync.setCount(esync.getCount() + 1);
            esync.setResult(response.code() + "  " + (responseBody.length() > 255 ? responseBody.substring(0, 200) : responseBody));
            this.esnImpl.update(esync);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public boolean isPushIng() {
        return isPush;
    }
}

