/*
 * Decompiled with CFR 0.152.
 */
package com.asc.es.service.impl;

import com.alibaba.fastjson.JSON;
import com.asc.es.bean.EsFetchRecord;
import com.asc.es.bean.EsRequest;
import com.asc.es.bean.EsSystem;
import com.asc.es.dao.EsFetchRecordDao;
import com.asc.es.dao.EsRequestDao;
import com.asc.es.dao.EsSystemDao;
import com.asc.es.service.InterfacesExplainer;
import com.asc.es.service.bean.EsRequestRegx;
import com.asc.es.service.bean.EsResult;
import com.asc.es.service.impl.BaseImpl;
import com.asc.utils.file.PersistenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class InterFacesExplainerImpl
extends BaseImpl
implements InterfacesExplainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterFacesExplainerImpl.class);
    public static boolean isExplain = false;
    @Autowired
    EsFetchRecordDao efrImpl;
    @Autowired
    EsRequestDao erdImpl;
    @Autowired
    EsSystemDao esdImpl;
    static final String RESTFUL_PARAMS = "restful_params";
    static final String BODY = "body";
    static final String ROUTER_PARAMS = "router_params";
    static final String SYS = "sys";
    static final String REQUEST_URL = "request_url";
    static final String PATH = "path";
    static final String CONTENT_TYPE = "content_type";
    static final String TYPE = "type";
    String day;
    Map<String, String> sysMap = new HashMap();

    private String getSysId(String doamin) {
        EsSystem es = this.esdImpl.selectBySys(doamin);
        if (es == null) {
            es = new EsSystem();
            es.setSys(doamin);
            es.setSysAlias(doamin.replace(".", ""));
            this.esdImpl.insert(es);
            es = this.esdImpl.selectBySys(doamin);
        }
        return es.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void explain() {
        try {
            if (!isExplain) {
                isExplain = true;
                this.day = this.getDate();
                String[] dates = this.getLast7Dates();
                Map maps = this.read(dates);
                Map mapf = this.filter(maps);
                this.compareWithBefore(mapf);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        finally {
            isExplain = false;
        }
    }

    public Map<String, Object> read(String[] dates) {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        PersistenceUtil pu = new PersistenceUtil();
        LOGGER.info("Explain={}", (Object)JSON.toJSONString((Object)dates));
        ArrayList efrl = new ArrayList();
        for (String date : dates) {
            List efrs = this.efrImpl.select(date, 2, 1);
            efrl.addAll(efrs);
        }
        for (EsFetchRecord efr : efrl) {
            String data = pu.load(PersistenceLocation + efr.getFetchDay(), efr.getPersistence());
            if (data.length() == 0) continue;
            List ler = JSON.parseArray((String)data, EsResult.class);
            LOGGER.info("===day:{} page:{} limit:{} total:{} actual:{}", new Object[]{efr.getFetchDay(), efr.getPage(), efr.getLimit(), efr.getTotal(), ler.size()});
            for (EsResult er : ler) {
                Map<String, Map> esreq;
                if (er.getSys() == null) continue;
                if (er.getExtraInfo() == null) {
                    LOGGER.warn("not exist ExtraInfo");
                    continue;
                }
                if (er.getExtraInfo().getUri() == null) {
                    LOGGER.warn("not exist uri");
                    continue;
                }
                String key = this.getRequestKey(er.getExtraInfo().getMethod(), this.getDomain(er.getExtraInfo().getUri()), this.urlDecode(er.getExtraInfo().getUri()));
                if (maps.containsKey(key)) {
                    esreq = (Map)maps.get(key);
                    Map body = this.mergetMap((Map)esreq.get("body"), (Map)((HashMap)JSON.parseObject((String)er.getExtraInfo().getBody(), HashMap.class)));
                    Map routerParameter = this.mergetMap((Map)esreq.get("router_params"), (Map)((HashMap)JSON.parseObject((String)er.getExtraInfo().getRouterParameter(), HashMap.class)));
                    esreq.put("body", body);
                    esreq.put("router_params", routerParameter);
                    maps.put(key, esreq);
                    continue;
                }
                esreq = new HashMap();
                esreq.put("sys", (Map)((Object)er.getSys()));
                esreq.put("request_url", (Map)((Object)this.urlDecode(er.getExtraInfo().getUri())));
                esreq.put("content_type", (Map)((Object)er.getExtraInfo().getContentType()));
                esreq.put("type", (Map)((Object)er.getExtraInfo().getMethod()));
                esreq.put("body", (HashMap)JSON.parseObject((String)er.getExtraInfo().getBody(), HashMap.class));
                esreq.put("router_params", (HashMap)JSON.parseObject((String)er.getExtraInfo().getRouterParameter(), HashMap.class));
                maps.put(key, esreq);
            }
            LOGGER.info("maps.size :{}", (Object)maps.size());
        }
        return maps;
    }

    private void compareWithBefore(Map<String, Object> maps) {
        maps.forEach((k, v) -> {
            Map esreq = (Map)v;
            String requestUrl = (String)esreq.get("request_url");
            String domain = this.getDomain(requestUrl);
            if (this.isXyqbDomain(domain)) {
                String sysId = this.getSysId(domain);
                String path = this.getPath((String)esreq.get("path"));
                String type = (String)esreq.get("type");
                String contentType = (String)esreq.get("content_type");
                String restfulParams = JSON.toJSONString(esreq.get("restful_params"));
                Map body = (Map)esreq.get("body");
                Map routerparamter = (Map)esreq.get("router_params");
                Map paramnames = this.mergetMap(body, routerparamter);
                List paramsL = this.getMapKey(paramnames);
                Object[] params = paramsL.toArray();
                Arrays.sort(params);
                String paramsStr = JSON.toJSONString((Object)params);
                EsRequest er = this.erdImpl.select(sysId, path, type);
                if (er == null) {
                    er = new EsRequest();
                    er.setSysId(sysId);
                    er.setRequestUrl(requestUrl);
                    er.setType(type);
                    er.setContentType(contentType);
                    er.setPath(path);
                    er.setRestfulParams(restfulParams);
                    er.setBody(JSON.toJSONString((Object)body));
                    er.setRouterParams(JSON.toJSONString((Object)routerparamter));
                    er.setParamNames(paramsStr);
                    er.setExplainDay(this.day);
                    er.setTimestamp(Long.valueOf(System.currentTimeMillis()));
                    er.setIsChange(Integer.valueOf(1));
                    try {
                        this.erdImpl.insert(er);
                    }
                    catch (Exception e) {
                        LOGGER.error("INSERT {} ====", (Object)JSON.toJSONString((Object)er), (Object)e);
                    }
                } else {
                    if (!paramsStr.equals(er.getParamNames())) {
                        if (!contentType.equals(er.getContentType())) {
                            LOGGER.warn("=======CONTENT-TYPE NOT EQUAL {} : {}", (Object)er.getContentType(), (Object)contentType);
                        }
                        er.setBody(JSON.toJSONString((Object)body));
                        er.setRouterParams(JSON.toJSONString((Object)routerparamter));
                        er.setParamNames(paramsStr);
                        er.setTimestamp(Long.valueOf(System.currentTimeMillis()));
                        er.setExplainDay(this.day);
                        er.setIsChange(Integer.valueOf(1));
                    } else {
                        er.setExplainDay(this.day);
                        er.setIsChange(Integer.valueOf(0));
                    }
                    try {
                        this.erdImpl.refresh(er);
                    }
                    catch (Exception e) {
                        LOGGER.error("UPDATE {} ====", (Object)JSON.toJSONString((Object)er), (Object)e);
                    }
                }
            }
        });
    }

    public Map<String, Object> filter(Map<String, Object> maps) {
        HashMap<String, Object> mapRegx = new HashMap<String, Object>();
        ArrayList regxL = new ArrayList();
        maps.forEach((k, v) -> {
            LOGGER.info("{}", k);
            Map esreq = (Map)v;
            String newRegx = null;
            String requestUrl = (String)esreq.get("request_url");
            for (String regx : regxL) {
                if (!InterFacesExplainerImpl.matchRegx((String)requestUrl, (String)regx)) continue;
                newRegx = regx;
            }
            if (newRegx != null) {
                Map mapRegxEr = (Map)mapRegx.get(newRegx);
                Map body = this.mergetMap((Map)mapRegxEr.get("body"), (Map)((HashMap)esreq.get("body")));
                Map routerParameter = this.mergetMap((Map)mapRegxEr.get("router_params"), (Map)((HashMap)esreq.get("router_params")));
                mapRegxEr.put("body", body);
                mapRegxEr.put("router_params", routerParameter);
            } else {
                EsRequestRegx err = this.calcRegx(requestUrl);
                esreq.put("path", err.getPath());
                esreq.put("restful_params", err.getRestfulParams());
                mapRegx.put(err.getRegxPath(), esreq);
                regxL.add(err.getRegxPath());
            }
        });
        return mapRegx;
    }

    public EsRequestRegx calcRegx(String path) {
        EsRequestRegx err = new EsRequestRegx();
        int index = 1;
        String[] paths = path.split("/");
        String[] patho = new String[paths.length];
        int length = paths.length;
        StringBuffer pathRegx = new StringBuffer("");
        StringBuffer pathOri = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            patho[i] = paths[i];
            if (i >= 3) {
                if (NumberUtils.isNumber((String)paths[i])) {
                    patho[i] = ":rd" + index;
                    err.put("rd" + index, (Object)paths[i]);
                    paths[i] = "(0-9){1,}";
                    ++index;
                } else if (this.isLikeid(paths[i])) {
                    patho[i] = ":rd" + index;
                    err.put("rd" + index, (Object)paths[i]);
                    paths[i] = "([a-zA-Z0-9-]){5,}";
                    ++index;
                }
            }
            if (i == 0) {
                paths[0] = "(http:|https:)";
            }
            pathRegx.append(paths[i]).append(i >= 0 && i < length - 1 ? "/" : "");
            pathOri.append(patho[i]).append(i >= 0 && i < length - 1 ? "/" : "");
        }
        err.setRegxPath(pathRegx.toString());
        err.setPath(pathOri.toString());
        LOGGER.info("{} {} {} {}", new Object[]{path, err.getRegxPath(), err.getPath(), JSON.toJSONString((Object)err.getRestfulParams())});
        return err;
    }

    public static boolean matchRegx(String url, String regx) {
        Pattern pattern = Pattern.compile(regx);
        Matcher matcher = pattern.matcher(url);
        return matcher.matches();
    }

    public boolean isLikeid(String temp) {
        int count = 0;
        int maxSquence = 0;
        int lastIndex = -1;
        char[] chars = temp.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            ++count;
            if (i - 1 == lastIndex) {
                ++maxSquence;
                lastIndex = i;
                continue;
            }
            maxSquence = 0;
        }
        return count > 5 || maxSquence > 5;
    }

    public boolean isExplainIng() {
        return isExplain;
    }
}

