/*
 * Decompiled with CFR 0.152.
 */
package com.asc.es.service.impl;

import com.alibaba.fastjson.JSON;
import com.asc.es.bean.EsFetchRecord;
import com.asc.es.dao.EsFetchRecordDao;
import com.asc.es.service.FetchInterfaces;
import com.asc.es.service.bean.EsResponse;
import com.asc.es.service.impl.BaseImpl;
import com.asc.utils.file.PersistenceUtil;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class FetchInterfacesImpl
extends BaseImpl
implements FetchInterfaces {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchInterfacesImpl.class);
    private static boolean isFetch = false;
    @Value(value="${es_apis_url}")
    private String esApisUrl;
    @Value(value="${page}")
    private int page;
    @Value(value="${limit}")
    private int limit;
    @Value(value="${day}")
    private int day;
    private String fetchDay;
    private int totalPage;
    OkHttpClient client = new OkHttpClient();
    @Autowired
    EsFetchRecordDao efrImpl;
    EsFetchRecord ef;

    public void fetchInterfaces() {
        if (!isFetch) {
            isFetch = true;
            this.fetchDay = this.getDate(-1);
            this.page = 1;
            this.totalPage = 0;
            try {
                this.clear(this.getDate(-8));
                this.fetch();
                this.checkInterfaces();
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            finally {
                isFetch = false;
            }
        }
    }

    private void clear(String clearDay) {
        PersistenceUtil pu = new PersistenceUtil();
        pu.rmDir(PersistenceLocation + clearDay);
    }

    /*
     * Unable to fully structure code
     */
    private void fetch() throws Exception {
        pu = new PersistenceUtil();
        this.totalPage = this.fetchTotal();
        while (this.page <= this.totalPage) {
            block9: {
                block10: {
                    this.ef = this.efrImpl.select(this.fetchDay, this.page);
                    if (this.ef != null) break block10;
                    this.ef = new EsFetchRecord(this.fetchDay, this.page, this.limit, this.day, this.totalPage, 0, 0);
                    this.ef.setId(UUID.randomUUID().toString());
                    this.ef.setPersistence(this.day + "-" + this.limit + "-" + this.page);
                    this.efrImpl.insert(this.ef);
                    ** GOTO lbl-1000
                }
                if (this.ef.getFlow() == 2 && this.ef.getStatus() == 1) {
                    FetchInterfacesImpl.LOGGER.info("{}====================fetch page {} ,limit {},day {} [last total:{}]======exist", new Object[]{this.fetchDay, this.page, this.limit, this.day, this.totalPage});
                } else lbl-1000:
                // 2 sources

                {
                    try {
                        response = this.http(this.page, this.limit, this.day, this.totalPage);
                    }
                    catch (Exception e) {
                        FetchInterfacesImpl.LOGGER.error("fetch", (Throwable)e);
                        this.ef.setFlow(Integer.valueOf(2));
                        this.ef.setStatus(Integer.valueOf(2));
                        this.efrImpl.update(this.ef);
                        break block9;
                    }
                    this.ef.setStatus(Integer.valueOf(1));
                    this.efrImpl.update(this.ef);
                    esResponse = (EsResponse)JSON.parseObject((String)response, EsResponse.class);
                    if (esResponse.getCode() == null || !esResponse.getCode().equals("0000") || esResponse.getData().getTotal() <= 0 || esResponse.getData().getResult() == null || esResponse.getData().getResult().size() <= 0) {
                        FetchInterfacesImpl.LOGGER.error("@@@@@@@@@@ fetch data error -> {}", (Object)response);
                    } else {
                        esData = esResponse.getData();
                        this.ef.setFlow(Integer.valueOf(2));
                        this.ef.setStatus(Integer.valueOf(0));
                        this.efrImpl.update(this.ef);
                        isPer = pu.persistence(FetchInterfacesImpl.PersistenceLocation + this.ef.getFetchDay(), this.ef.getPersistence(), JSON.toJSONString((Object)esData.getResult()));
                        if (isPer) {
                            this.ef.setStatus(Integer.valueOf(1));
                        } else {
                            this.ef.setStatus(Integer.valueOf(2));
                        }
                        this.efrImpl.update(this.ef);
                    }
                }
            }
            ++this.page;
        }
    }

    private String http(int page, int limit, int day, int total) throws Exception {
        LOGGER.info("{}====================fetch page {} ,limit {},day {} [last total:{}]", new Object[]{this.fetchDay, page, limit, day, total});
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("page", page);
        param.put("limit", limit);
        param.put("day", day);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JSON.toJSONString(param));
        Request request = new Request.Builder().url(this.esApisUrl).addHeader("content-type", "application/json").addHeader("cache-control", "no-cache").post(body).build();
        Response response = this.client.newCall(request).execute();
        return String.valueOf(response.body().string());
    }

    private int fetchTotal() throws Exception {
        String response = this.http(1, this.limit, 1, 0);
        EsResponse esResponse = (EsResponse)JSON.parseObject((String)response, EsResponse.class);
        int pageSize = esResponse.getData().getTotal() / this.limit + (esResponse.getData().getTotal() % this.limit > 0 ? 1 : 0);
        return pageSize;
    }

    public void checkInterfaces() {
        LOGGER.info("=========Fetch  - check start {}=========", (Object)this.fetchDay);
        List efrl = this.efrImpl.select(this.fetchDay, 2, 1);
        efrl.forEach(ef -> {
            String path = PersistenceLocation + this.fetchDay + File.separator + ef.getPersistence();
            File file = new File(path);
            if (!file.exists()) {
                LOGGER.error(file.getPath() + "File Not Exist");
                ef.setStatus(Integer.valueOf(2));
                this.efrImpl.update(ef);
            }
        });
        LOGGER.info("=========Fetch  - check end {}=========", (Object)this.fetchDay);
    }

    public boolean isFetchIng() {
        return isFetch;
    }
}

