/*
 * Decompiled with CFR 0.152.
 */
package com.asc.es.dao.impl;

import com.asc.es.bean.EsRequest;
import com.asc.es.dao.EsRequestDao;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class EsRequestDaoImpl
implements EsRequestDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public EsRequest select(String id) {
        String sql = "select * from es_request where id=?";
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(EsRequest.class);
        List le = this.jdbcTemplate.query(sql, (RowMapper)rowMapper, new Object[]{id});
        if (le.size() > 0) {
            return (EsRequest)le.get(0);
        }
        return null;
    }

    public EsRequest select(String sysId, String path, String type) {
        String sql = "select * from es_request where sys_id=? and path=? and type=?";
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(EsRequest.class);
        List le = this.jdbcTemplate.query(sql, (RowMapper)rowMapper, new Object[]{sysId, path, type});
        if (le.size() > 0) {
            return (EsRequest)le.get(0);
        }
        return null;
    }

    public List<EsRequest> selectByExplainDay(String fatchDay, String sysId) {
        String sql = "select * from es_request where explain_day=? and sys_id=?";
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(EsRequest.class);
        List le = this.jdbcTemplate.query(sql, (RowMapper)rowMapper, new Object[]{fatchDay, sysId});
        return le;
    }

    public int insert(EsRequest es) {
        return this.jdbcTemplate.update("insert into es_request (id,sys_id, request_url, type,path,content_type,restful_params,body,router_params,param_names,`timestamp`,explain_day,is_change,create_time,update_time) value (?,?,?,?,?,?,?,?,?,?,?,?,?,now(),now())", new Object[]{UUID.randomUUID().toString(), es.getSysId(), es.getRequestUrl(), es.getType(), es.getPath(), es.getContentType(), es.getRestfulParams(), es.getBody(), es.getRouterParams(), es.getParamNames(), es.getTimestamp(), es.getExplainDay(), es.getIsChange()});
    }

    public int refresh(EsRequest es) {
        return this.jdbcTemplate.update("update es_request set content_type=?,restful_params=?,body=?,router_params=?,param_names=?,`timestamp`=?,explain_day=?,is_change=?,update_time=now() where id = ? and explain_day != ? ", new Object[]{es.getContentType(), es.getRestfulParams(), es.getBody(), es.getRouterParams(), es.getParamNames(), es.getTimestamp(), es.getExplainDay(), es.getIsChange(), es.getId(), es.getExplainDay()});
    }

    public int delete(String id) {
        return this.jdbcTemplate.update("update es_request set logical_del=1,update_time=now() where id = ?", new Object[]{id});
    }
}

