/*
 * Decompiled with CFR 0.152.
 */
package com.asc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.asc.controller.CaptchaController;
import com.asc.utils.MD5Util;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.hash.Hashing;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/encrypt"})
@RestController
class EncryptController {
    @Value(value="${train.key}")
    private String mt;
    @Value(value="${apix.key}")
    private String ma;
    @Value(value="${fl.key}")
    private String mf;
    @Value(value="${wx.mall.apikey}")
    private String wxmallapikey;
    @Value(value="${wx.btzt.apikey}")
    private String wxBtztApikey;
    @Value(value="${wx.bt.apikey}")
    private String wxBtApikey;
    @Value(value="${wx.xyqb.apikey}")
    private String wxXyqbApikey;
    static Logger log = LoggerFactory.getLogger(CaptchaController.class);

    EncryptController() {
        log.info("----EncryptController   init -------------");
    }

    @RequestMapping(value={"/md5/t"}, method={RequestMethod.GET})
    public String muc(String method, String param) {
        String sign = MD5Util.build((String)("method=" + method + "&param=" + param + "&md5key=" + this.mt)).toUpperCase();
        log.info("/md5/t sign:{} method:{} param:{} ", new Object[]{sign, method, param});
        return sign;
    }

    @RequestMapping(value={"/md5/a"}, method={RequestMethod.GET})
    @ResponseBody
    public String mlc(String orderid, String ordertime) {
        String sign = MD5Util.build((String)(this.ma + orderid + ordertime)).toLowerCase();
        log.info("/md5/t sign:{} orderid:{} ordertime:{} ", new Object[]{sign, orderid, ordertime});
        return sign;
    }

    @RequestMapping(value={"/md5/f"}, method={RequestMethod.GET})
    @ResponseBody
    public String mlf(String jsonsign) {
        JSONObject jo = JSON.parseObject((String)jsonsign);
        TreeMap tree = new TreeMap(jo);
        TreeMap newtree = new TreeMap();
        for (Map.Entry a : tree.entrySet()) {
            String key = (String)a.getKey();
            Object value = a.getValue();
            newtree.put(key.toLowerCase(), value);
        }
        newtree.remove("sign");
        String signStr = Joiner.on((String)"&").withKeyValueSeparator("=").join(newtree);
        String sign = MD5Util.build((String)(signStr + this.mf)).toLowerCase();
        log.info("/md5/f sign:{} signStr:{} ", (Object)sign, (Object)signStr);
        return sign;
    }

    @RequestMapping(value={"/wx/mall/sign"}, method={RequestMethod.GET})
    @ResponseBody
    public String mlc(String jsonsign) {
        JSONObject jo = JSON.parseObject((String)jsonsign);
        TreeMap m = new TreeMap(jo);
        m.remove("sign");
        return this.sign(m, this.wxmallapikey);
    }

    private String sign(Map<String, Object> value, String apiKey) {
        TreeMap tree = (TreeMap)value;
        String signStr = Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)tree);
        return Hashing.md5().newHasher().putString((CharSequence)(signStr + "&key=" + apiKey), Charsets.UTF_8).hash().toString().toUpperCase();
    }
}

