/*
 * Decompiled with CFR 0.152.
 */
package utils.Hubei;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Hubei.HubeiCodeResponse;
import utils.Hubei.HubeiStatusResponse;
import utils.Hubei.QGRequest;

public final class HubeiXmlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HubeiXmlUtil.class);
    private static final ObjectMapper XML_MAPPER = new XmlMapper();

    public static String parse(String xmlString, ArrayList loanContNo, ArrayList loanContNoBak) throws IOException {
        QGRequest QGRequest2 = (QGRequest)XML_MAPPER.readValue(xmlString, QGRequest.class);
        String bussinessCode = QGRequest2.getHead().getCurrentBusinessCode();
        String thirdSeq = QGRequest2.getReqData().getThirdSeq();
        String applCde = new String();
        String ec = new String();
        String em = new String();
        String outSts = new String();
        String xml = new String();
        HubeiCodeResponse hubeiCodeResponse = new HubeiCodeResponse();
        HubeiStatusResponse hubeiStatusResponse = new HubeiStatusResponse();
        HubeiStatusResponse.Resp hubeiStatusResponseResp = new HubeiStatusResponse.Resp(hubeiStatusResponse);
        HubeiCodeResponse.Resp hubeiResponseResp = new HubeiCodeResponse.Resp(hubeiCodeResponse);
        switch (bussinessCode) {
            case "CF001014": {
                applCde = "1002201610171002704";
                ec = "0";
                hubeiResponseResp.setApplCde(applCde);
                hubeiCodeResponse.setResp(hubeiResponseResp);
                hubeiCodeResponse.setEc(ec);
                xml = XML_MAPPER.writeValueAsString((Object)hubeiCodeResponse);
                break;
            }
            case "CF004043": {
                applCde = "1002201610171002704";
                ec = "0";
                hubeiResponseResp.setApplCde(applCde);
                hubeiCodeResponse.setResp(hubeiResponseResp);
                hubeiCodeResponse.setEc(ec);
                xml = XML_MAPPER.writeValueAsString((Object)hubeiCodeResponse);
                break;
            }
            case "CF002016": {
                applCde = "1002201610171002704";
                ec = "0";
                if (!loanContNo.contains(thirdSeq)) {
                    outSts = "04";
                    loanContNo.add(thirdSeq);
                } else {
                    outSts = "2";
                    loanContNo.remove(thirdSeq);
                    loanContNoBak.add(thirdSeq);
                }
                LOGGER.info("loanContNo:{}", (Object)loanContNo);
                LOGGER.info("backup loanContNo:{}", (Object)loanContNoBak);
                hubeiStatusResponse.setEc(ec);
                hubeiStatusResponseResp.setApplCde(applCde);
                hubeiStatusResponseResp.setOutSts(outSts);
                hubeiStatusResponseResp.setLoanContNo(thirdSeq);
                hubeiStatusResponse.setResp(hubeiStatusResponseResp);
                xml = XML_MAPPER.writeValueAsString((Object)hubeiStatusResponse);
                break;
            }
            case "CF004044": {
                applCde = "1002201610171002704";
                ec = "0";
                hubeiResponseResp.setApplCde(applCde);
                hubeiCodeResponse.setResp(hubeiResponseResp);
                hubeiCodeResponse.setEc(ec);
                xml = XML_MAPPER.writeValueAsString((Object)hubeiCodeResponse);
                break;
            }
            case "CF001013": {
                applCde = "1002201610171002704";
                ec = "0";
                hubeiResponseResp.setApplCde(applCde);
                hubeiCodeResponse.setResp(hubeiResponseResp);
                hubeiCodeResponse.setEc(ec);
                xml = XML_MAPPER.writeValueAsString((Object)hubeiCodeResponse);
                break;
            }
            case "CF002105": {
                applCde = "1002201610171002704";
                ec = "0";
                outSts = "2";
                hubeiStatusResponse.setEc(ec);
                hubeiStatusResponseResp.setApplCde(applCde);
                hubeiStatusResponseResp.setOutSts(outSts);
                hubeiStatusResponseResp.setLoanContNo(thirdSeq);
                hubeiStatusResponse.setResp(hubeiStatusResponseResp);
                xml = XML_MAPPER.writeValueAsString((Object)hubeiStatusResponse);
                break;
            }
        }
        LOGGER.info("\u8fd4\u56de\u7684xml:{}", (Object)xml);
        return xml;
    }

    static {
        XML_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ((XmlMapper)XML_MAPPER).configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
    }
}

