# encoding: utf8
import pandas as pd
from sqlalchemy import create_engine
import numpy as np
import os
import datetime

'''
需求 C 部分：https://yiqixie.com/d/home/fcACEpyJxWH2zt1qe9OtPv1C7
注意：提前导出表  service_fee_detail_2015,service_fee_detail_2016 的数据，如果以后有2017，那么应该是新表的数据了
'''

path='E:/'
engine_audit = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/temp?charset=utf8', echo=True)

#数据量太大，故直接读csv，需要将数据库中的数据导出到csv
def get_data(year):
    if year == 2015:
        sql_2015 = '''
            select '2015' loan_year,ref_id,service_fee1,service_fee2,deadline,service_fee2_deadline,real_service_fee1,real_service_fee2,mitigate_service_fee1,mitigate_service_fee2,F,no_repay_fee
            from service_fee_detail_2015
        '''
        # df= pd.read_sql(sql_2015, engine_audit)
        # df.to_csv(path + 'all_2015.csv')
        return pd.read_csv(path+'all_2015.csv')
    elif year == 2016 :
        sql_2016 = '''
            select '2016' loan_year,ref_id,service_fee1,service_fee2,deadline,service_fee2_deadline,real_service_fee1,real_service_fee2,mitigate_service_fee1,mitigate_service_fee2,F,no_repay_fee
            from service_fee_detail_2016
            '''
        # df= pd.read_sql(sql_2016, engine_audit)
        # df.to_csv(path+'all_2016.csv')
        return pd.read_csv(path+'all_2016.csv')
    else :
        return pd.DataFrame()



#贷前服务费，贷后服务费统一使用deadline进行统计
def c2(df,year):
    df.deadline = pd.to_datetime(df.deadline).dt.date
    df['days'] = df['deadline'].apply(lambda x: (datetime.date(year, 12, 31) - x).days)
    # 标记是多少天
    df['flag'] = 0
    df.ix[(df['days'] <= 30) & (df['days'] >= 0), 'flag'] = 30
    df.ix[(df['days'] > 30) & (df['days'] <= 60), 'flag'] = 60
    df.ix[(df['days'] > 60) & (df['days'] <= 90), 'flag'] = 90
    df.ix[(df['days'] > 90) & (df['days'] <= 120), 'flag'] = 120
    df.ix[(df['days'] > 120) & (df['days'] <= 150), 'flag'] = 150
    df.ix[(df['days'] > 150) & (df['days'] <= 180), 'flag'] = 180
    df.ix[(df['days'] > 180), 'flag'] = 200

    df.fillna(0,inplace=True)
    df_year=pd.pivot_table(df,index=['flag'],values=['service_fee1','service_fee2_deadline','real_service_fee1','real_service_fee2',
                                                                   'mitigate_service_fee1','mitigate_service_fee2','F','no_repay_fee'],
                   aggfunc=np.sum,fill_value=0,margins=True)
    df_year.fillna(0,inplace=True)
    df_year.to_csv(path+'c2_%d.csv' % year)

def c1(df,year):
    # sql_loan='''
    # select ref_id,loan_paid_at from loan_manifest where is_active = 1 and loan_paid_at < '2017-01-01'
    # '''
    # df_loan=pd.read_sql(sql_loan,engine_audit)
    df_loan = pd.read_csv(path+'loan_2017.csv')
    df=pd.merge(df,df_loan,on='ref_id',how='left')
    # plan 计划进行区分
    print df.ix[df.loan_paid_at.isnull()]
    df.loan_paid_at = pd.to_datetime(df.loan_paid_at).dt.date
    df['loan_days'] = df['loan_paid_at'].apply(lambda x: (datetime.date(year, 12, 31) - x).days)
    # 标记是多少天
    df['loan_flag'] = 0
    df.ix[(df['loan_days'] <= 30) & (df['loan_days'] >= 0), 'loan_flag'] = 30
    df.ix[(df['loan_days'] > 30) & (df['loan_days'] <= 60), 'loan_flag'] = 60
    df.ix[(df['loan_days'] > 60) & (df['loan_days'] <= 90), 'loan_flag'] = 90
    df.ix[(df['loan_days'] > 90) & (df['loan_days'] <= 120), 'loan_flag'] = 120
    df.ix[(df['loan_days'] > 120) & (df['loan_days'] <= 150), 'loan_flag'] = 150
    df.ix[(df['loan_days'] > 150) & (df['loan_days'] <= 180), 'loan_flag'] = 180
    df.ix[(df['loan_days'] > 180), 'loan_flag'] = 200

    df.deadline = pd.to_datetime(df.deadline).dt.date
    df['days'] = df['deadline'].apply(lambda x: (datetime.date(year, 12, 31) - x).days)
    # 标记是多少天
    df['flag'] = 0
    df.ix[(df['days'] <= 30) & (df['days'] >= 0), 'flag'] = 30
    df.ix[(df['days'] > 30) & (df['days'] <= 60), 'flag'] = 60
    df.ix[(df['days'] > 60) & (df['days'] <= 90), 'flag'] = 90
    df.ix[(df['days'] > 90) & (df['days'] <= 120), 'flag'] = 120
    df.ix[(df['days'] > 120) & (df['days'] <= 150), 'flag'] = 150
    df.ix[(df['days'] > 150) & (df['days'] <= 180), 'flag'] = 180
    df.ix[(df['days'] > 180), 'flag'] = 200

    df.fillna(0,inplace=True)
    df_dq=df.groupby('loan_flag')['service_fee1','real_service_fee1','mitigate_service_fee1'].sum().reset_index()
    df_dh=df.groupby('flag')['service_fee2_deadline','real_service_fee2','mitigate_service_fee2','F'].sum().reset_index()
    df=pd.merge(df_dq,df_dh,left_on='loan_flag',right_on='flag',how='outer')
    df.fillna(0,inplace=True)
    df['tj'] = np.round(df['service_fee1'] - df['real_service_fee1']-df['mitigate_service_fee1'] + df['service_fee2_deadline']
                             - df['real_service_fee2'] - df['mitigate_service_fee2'] - df['F'],
                             2)
    df.to_csv(path+'c1_%d.csv' % year)



if __name__ == '__main__':
    ## 2015年
    # df_2015=get_data(2015)
    # c2(df_2015,2015)
    # c1(df_2015,2015)
    ## 2016 年
    # df_2016 = get_data(2016)
    # c2(df_2016,2016)
    # c1(df_2016,2016)
    pass