# -*- coding:utf-8 -*-
# Author: Perry_Zhu
import numpy as np
import pandas as pd
import sys
from sqlalchemy import create_engine

engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/new_transaction?charset=utf8', echo=True)

engine_xyqb = create_engine('mysql+mysqldb://syzhu_data_r:ulk0989742097y43@192.168.4.6:8066/xyqb?charset=utf8',
                            echo=True)

query_zc = """
SELECT plan.plan_id repay_plan_id,plan.term_no,plan.deadline,plan.principal,plan.interest,
  plan.discount,date(r.created_at)repaid_at,plan.finance_record_id
FROM baitiao_fund_repayment_plan plan 
JOIN baitiao_finance_record r ON plan.finance_record_id=r.id AND r.type=1 AND locate('正常',r.remark) > 0
"""


def update_zc():
    df = pd.read_sql(query_zc, engine_xyqb)
    df['funding_code'] = 5
    df['refund_status'] = 0
    df['principal_account'] = 1
    df['interest_account'] = 1
    df['discount_acount'] = 2
    df['behalf_repay'] = 0
    df.to_sql('bt_funding_repayment_record', con=engine_new_transaction, chunksize=10000, if_exists='append',
              index=None)


# update_zc()



query_yq = """
SELECT plan.plan_id repay_plan_id,plan.term_no,plan.deadline,plan.principal,plan.interest,
  IF(ISNULL(plan.free_interest_record_id),3,2) interest_account,
  plan.discount,date(r.created_at)repaid_at,plan.finance_record_id
FROM baitiao_fund_repayment_plan plan 
JOIN baitiao_finance_record r ON plan.finance_record_id=r.id AND r.type=1 AND locate('逾期',r.remark) > 0
"""


def update_yq():
    df = pd.read_sql(query_yq, engine_xyqb)
    df['funding_code'] = 5
    df['refund_status'] = 0
    df['principal_account'] = 3
    df['discount_acount'] = 2
    df['behalf_repay'] = 0
    df.to_sql('bt_funding_repayment_record', con=engine_new_transaction, chunksize=10000, if_exists='append',
              index=None)


# update_yq()




query_refund = """
SELECT plan.fund_order_id,date(r.created_at)repaid_at,plan.finance_record_id
FROM baitiao_fund_repayment_plan plan 
JOIN baitiao_finance_record r ON plan.finance_record_id=r.id AND r.type=1 AND locate('退款',r.remark) > 0
"""
query_tk = """
SELECT plan.fund_order_id,plan.plan_id repay_plan_id,plan.term_no,plan.deadline,plan.principal,
  case plan.term_no
  WHEN 1
  THEN plan.interest
  ELSE 0.0
  END AS interest,
  case plan.term_no
  WHEN 1
  THEN 2
  ELSE 3
  END AS interest_account,
  plan.discount
FROM baitiao_fund_repayment_plan plan 
WHERE plan.fund_order_id in %s
"""


def update_tk():
    df_t = pd.read_sql(query_refund, engine_xyqb)
    df_t['fund_order_id'] = df_t['fund_order_id'].astype(int)
    plan_ids = df_t['fund_order_id'].tolist()
    df = pd.read_sql(query_tk % (str(tuple(plan_ids)).replace(',)', ')')), engine_xyqb)
    df['fund_order_id'] = df['fund_order_id'].astype(int)
    df = pd.merge(df_t, df, on='fund_order_id')
    df.drop(['fund_order_id'], axis=1, inplace=True)
    df['funding_code'] = 5
    df['refund_status'] = 3
    df['principal_account'] = 3
    # df['interest_account'] = 3
    df['discount_acount'] = 2
    df['behalf_repay'] = 0
    df.to_sql('bt_funding_repayment_record', con=engine_new_transaction, chunksize=10000, if_exists='append',
              index=None)


# update_tk()
