# -*- coding: utf-8 -*-
"""
    出白条还资金方汇总表
"""
import pandas as pd

pd.options.mode.chained_assignment = None
import sys
from sqlalchemy import create_engine

reload(sys)
sys.setdefaultencoding('utf8')
engine_baitiao_audit = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/baitiao_audit?charset=utf8', echo=True)

select_service_sql = """
SELECT YEAR (service_fee_time) repay_time_year,MONTH(service_fee_time)repay_time_month,
fund_name fund_corp,SUM(service_fee_amount) 服务费 
FROM fund_qg_detail 
WHERE service_fee_time is not NULL   GROUP BY 1,2,3 ;"""

select_qg2fund_sql = """
SELECT
	YEAR (qtf.transfer_time) 打款年份,
	MONTH (qtf.transfer_time) 打款月份,
	  qtf.qg_name 打款账户,
	qtf.fund_name,
	SUM(qtf.transfer_amount) 当期本息和
FROM
	qg_to_fund qtf
GROUP BY 1,2,3,4"""



select_fund_qg_detail_sql = """
SELECT 
	YEAR (repay_time) repay_time_year,
	MONTH (repay_time)repay_time_month,
    fund_name 资金方,
    fund_name fund_corp,
	SUM(IFNULL(repaid_principal_amount,0)) 当期本金,
	SUM(IFNULL(interest,0))当期利息
 FROM (
    (
    SELECT DISTINCT 
      r1.package_batch,r1.fund_name,
      SUM(IFNULL(r1.repaid_principal_amount,0))repaid_principal_amount,
      SUM(IFNULL(r1.interest,0)) interest
    FROM baitiao_fund_repayment_record r1
    GROUP BY r1.package_batch
    )t1 
JOIN (
    SELECT DISTINCT 
      d1.repay_time,
	  d1.package_batch
    FROM fund_qg_detail d1 
    GROUP BY  d1.package_batch
      )t2 ON t1.package_batch=t2.package_batch
)
WHERE repay_time is not NULL
GROUP BY 1,2,3"""





jinrongquan_sql="""SELECT
	YEAR (tfq.transfer_time) 打款年份,
	MONTH (tfq.transfer_time) 打款月份,
	SUM(total_amount) 当期本息和,
	SUM(order_amount) 当期本金,
	SUM(interest) 当期利息
FROM
	baitiao_audit.jinrongquan_order t1
JOIN qg_to_fund tfq ON tfq.package_names = t1.package_name
GROUP BY 1,2
"""

def baitiao_to_excel():
    df = pd.read_sql(sql=select_qg2fund_sql, con=engine_baitiao_audit)
    df['fund_name'] = df['fund_name'].astype(str)
    df[u'打款年份'] = df[u'打款年份'].astype(int)
    df[u'打款月份'] = df[u'打款月份'].astype(int)
    df['repay_time_year'] = df[u'打款年份']
    df['repay_time_month'] = df[u'打款月份']
    df.rename(columns={'fund_name': 'fund_corp'}, inplace=True)
    # df['join_key'] = df[u'打款年份'] + df[u'打款月份'] + df['fund_name']
    # a = df.repay_time.tolist()
    df_temp = pd.read_sql(sql=select_fund_qg_detail_sql, con=engine_baitiao_audit)
    df_temp = df_temp.ix[~df_temp.repay_time_year.isnull()]
    df_temp['fund_corp'] = df_temp['fund_corp'].astype(str)
    df_temp['repay_time_year'] = df_temp['repay_time_year'].astype(int)
    df_temp['repay_time_month'] = df_temp['repay_time_month'].astype(int)
    df = pd.merge(df, df_temp, on=['fund_corp','repay_time_year','repay_time_month'])
    df_service = pd.read_sql(sql=select_service_sql, con=engine_baitiao_audit)
    df_service = df_service.ix[~df_service.repay_time_year.isnull()]
    df_service['fund_corp'] = df_service['fund_corp'].astype(str)
    df_service['repay_time_year'] = df_service['repay_time_year'].astype(int)
    df_service['repay_time_month'] = df_service['repay_time_month'].astype(int)
    df = pd.merge(df, df_service,how='left', on=['fund_corp','repay_time_year','repay_time_month'])
    df = df[[u'打款年份',u'打款月份',u'打款账户',u'资金方',u'当期本息和',u'当期本金',u'当期利息',u'服务费']]
    df.fillna(0, inplace=True)

    df_jinrongquan = pd.read_sql(sql=jinrongquan_sql, con=engine_baitiao_audit)
    df_jinrongquan[u'打款账户'] = '去哪儿代收账户'
    df_jinrongquan[u'资金方'] = '金融圈'
    df_jinrongquan[u'服务费'] = 0
    df_jinrongquan = df_jinrongquan[[u'打款年份',u'打款月份',u'打款账户',u'资金方',u'当期本息和',u'当期本金',u'当期利息',u'服务费']]
    df = df_jinrongquan.append(df)
    df.to_excel(u"E:/数据汇总/还资金方/白条还资金方2017-08.xlsx", index=None)


baitiao_to_excel()
