# encoding: utf8
import numpy as np
import pandas as pd
from dateutil.relativedelta import *
from sqlalchemy import create_engine
import datetime

pd.options.mode.chained_assignment = None

engine_audit = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/audit?charset=utf8', echo=True)
engine_audit_select = create_engine('mysql+mysqldb://yulong_rw:TouBStYwN8wkdxVt@172.16.3.201:3306/audit?charset=utf8',
                                    echo=True)
engine_new_transaction_select = create_engine(
    'mysql+mysqldb://yulong_rw:TouBStYwN8wkdxVt@172.16.3.201:3306/new_transaction?charset=utf8', echo=True)
engine_xyqb = create_engine('mysql+mysqldb://syzhu_data_r:ulk0989742097y43@192.168.4.6:8066/xyqb?charset=utf8',
                            echo=True)

deadline_y = 2017
deadline_m = 9
select_funding_sql = """ select DISTINCT loan_id, funding_code,ref_id,contract_loan_amount,contract_term,monthly_interest_rate from loan_manifest WHERE loan_id IN %s"""
select_exit_funding_sql = """ select DISTINCT id, loan_id, term_no from funding_repayment_record WHERE current_repayment>10 AND is_active=1 AND loan_id IN %s"""

select_funding_double_sql = """ select DISTINCT loan_id, funding_code,ref_id,contract_loan_amount,contract_term,monthly_interest_rate from loan_manifest WHERE funding_code=%s AND loan_id IN %s"""
select_bh_sql = """ 
 SELECT DISTINCT 
	lamh.loan_application_history_id as loan_id,
	c.contract_no AS contract_no,
	rp.term_no,
	rp.remark
  FROM
	loan_application_manifest_history lamh
LEFT JOIN contract c ON c.loan_application_manifest_history_id = lamh.id
LEFT JOIN repayment_plan rp ON rp.loan_application_history_id = lamh.loan_application_history_id
 WHERE
	c.contract_no IN %s"""

select_bh_loan_id_sql = """ 
 SELECT DISTINCT 
	m.loan_application_history_id as loan_id,
	c.contract_no AS contract_no
  FROM
	loan_application_manifest_history m
JOIN contract c ON c.loan_application_manifest_history_id = m.id
WHERE
	c.contract_no IN %s 
	"""

select_loan_id_sql = """ 
 SELECT DISTINCT 
	m.loan_application_history_id as loan_id,
	c.ssq_contract_no AS contract_no
  FROM
	loan_application_manifest_history m
JOIN contract c ON c.loan_application_manifest_history_id = m.id
WHERE
	c.ssq_contract_no IN %s 
	"""

select_request_sql = """ SELECT DISTINCT
	loan_application_history_id as loan_id,
	request_id
FROM
	waiting_funding_corp_operate_people
WHERE
	request_id IN %s """

insert_sql = """ INSERT INTO funding_repayment_record (
	loan_id,
	funding_code,
	term_no,
	deadline,
	principle,
	interest,
	current_repayment,
	AIR,
	repaid_at,
	ref_id
    )
VALUES
	(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""

insert_punish_sql = """ INSERT INTO funding_repayment_record (
	loan_id,
	funding_code,
	term_no,
	deadline,
	principle,
	interest,
	punish_fee,
	current_repayment,
	AIR,
	repaid_at,
	ref_id
    )
VALUES
	(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""

insert_punish_remark = """ INSERT INTO funding_repayment_record (
	loan_id,
	funding_code,
	term_no,
	deadline,
	principle,
	interest,
	punish_fee,
	current_repayment,
	AIR,
	repaid_at,
	ref_id,
	remark
    )
VALUES
	(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""

update_sql = """ update  funding_repayment_record set
	loan_id = %s,
	funding_code = %s,
	term_no = %s,
	deadline= %s,
	principle= %s,
	interest = %s,
	current_repayment = %s,
	AIR = %s,
	repaid_at = %s
   WHERE  id=%s
   """

insert_remark_sql = """ INSERT INTO funding_repayment_record (
	loan_id,
	funding_code,
	term_no,
	deadline,
	principle,
	interest,
	current_repayment,
	AIR,
	repaid_at,
	ref_id,
	remark
    )
VALUES
	(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""

insert_yggy_sql = """  INSERT INTO funding_repayment_record (
	loan_id,
	funding_code,
	term_no,
	deadline,
	principle,
	interest,
	funding_service_fee,
	punish_fee,
	current_repayment,
	AIR,
	repaid_at,
	loan_batch,
	mitigate_fee
    )
VALUES
	(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""

insert_service_sql = """ INSERT INTO funding_repayment_record (
	loan_id,
	funding_code,
	term_no,
	deadline,
	principle,
	interest,
	funding_service_fee,
	punish_fee,
	current_repayment,
	AIR,
	repaid_at,
	remark
    )
VALUES
	(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""
insert_bhhr_sql = """ INSERT INTO funding_repayment_record (
	loan_id,
	funding_code,
	term_no,
	deadline,
	principle,
	interest,
	funding_service_fee,
	punish_fee,
	current_repayment,
	AIR,
	repaid_at,
	ref_id
    )
VALUES
	(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""
insert_hr_sql = """ INSERT INTO funding_repayment_record (
	loan_id,
	funding_code,
	term_no,
	deadline,
	principle,
	interest,
	funding_service_fee,
	current_repayment,
	AIR,
	repaid_at,
	ref_id
    )
VALUES
	(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""

insert_hbxj_sql = """ INSERT INTO funding_repayment_record (
	loan_id,
	funding_code,
	term_no,
	deadline,
	principle,
	interest,
	current_repayment,
	AIR,
	repaid_at,
	lkb2fund_id,
    lkb_to_fund_type,
    is_active
    )
VALUES
	(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""

select_repayment_plan = """ select loan_id,sys_tag,term_no,deadline, principle,interest,service_fee from user_repayment_plan WHERE  loan_id in %s """


# inst:应还利息
# prin:应还本金
# total:应还合计
def cal_prin_inst(x):
    fund_id = int(x['funding_code'])
    a = x['contract_loan_amount']
    c = int(x['contract_term'])
    b = x['monthly_interest_rate'] * 12
    term = int(x['term_no'])
    result = {}
    if fund_id in (170, 190, 230, 260):
        result['total'] = np.pmt(b / 12, c, -a)
        result['prin'] = np.ppmt(b / 12, term, c, -a)
        result['inst'] = np.ipmt(b / 12, term, c, -a)
    elif fund_id == 140:
        result['prin'] = np.ceil(np.ppmt(b / 12, term, c, -a) * 100) / 100
        result['inst'] = np.ceil(np.ipmt(b / 12, term, c, -a) * 100) / 100
        result['total'] = result['prin'] + result['inst']
    elif fund_id == 180:
        # 剩余本金=合同金额
        # 计息天数=第一期还款日期 - 放款日期
        result['total'] = np.round(np.pmt(b / 12, c, -a), 2)
        if term == 1:
            money = a
            term_days = ((datetime.datetime.strptime(x['deadline'], '%Y-%m-%d')).date() - (
                (datetime.datetime.strptime(x['deadline'], '%Y-%m-%d')) + relativedelta(months=-1)).date()).days
            result['inst'] = np.round(b / 360 * money * term_days, 2)
            result['prin'] = result['total'] - result['inst']
        # 合同金额 - 第一期本金
        # 第二期还款日期 - 第一期还款日期
        else:
            money = a
            for i in xrange(1, term):
                term_days = ((
                                 (datetime.datetime.strptime(x['deadline'], '%Y-%m-%d')) + relativedelta(
                                     months=-(term - i))).date() - (
                                 (datetime.datetime.strptime(x['deadline'], '%Y-%m-%d')) + relativedelta(
                                     months=-(term - i + 1))).date()).days
                money -= result['total'] - np.round(b / 360 * money * term_days, 2)

            term_days = ((datetime.datetime.strptime(x['deadline'], '%Y-%m-%d')).date() - (
                (datetime.datetime.strptime(x['deadline'], '%Y-%m-%d')) + relativedelta(months=-1)).date()).days
            result['inst'] = np.round(b / 360 * money * term_days, 2)
            result['prin'] = (term == 3) and money or result['total'] - result['inst']
            result['total'] = (term == 3) and (result['inst'] + result['prin']) or result['total']

    elif fund_id in (150, 240, 290):
        result['inst'] = np.round(np.ipmt(b / 12, term, c, -a), 2)
        if term == c:
            result['prin'] = a
            for i in xrange(1, c):
                result['prin'] -= np.round(np.ppmt(b / 12, i, c, -a), 2)
            result['total'] = result['inst'] + result['prin']
        else:
            result['total'] = np.round(np.pmt(b / 12, c, -a), 2)
            # result['prin'] = np.round(np.ppmt(b / 12, term, c, -a), 2)
            result['prin'] = result['total'] - result['inst']
    elif fund_id == 200:
        result['total'] = np.round(np.pmt(b / 12, c, -a), 2)
        result['inst'] = np.round(np.ipmt(b / 12, term, c, -a), 2)
        if term == c:
            result['prin'] = a
            for i in xrange(1, c):
                result['prin'] -= np.round(np.ppmt(b / 12, i, c, -a), 2)
        else:
            result['prin'] = np.round(np.ppmt(b / 12, term, c, -a), 2)
    elif fund_id == 210:
        result['inst'] = np.round(np.ipmt(b / 12, term, c, -a), 2)
        if term == c:
            result['prin'] = a
            for i in xrange(1, c):
                result['prin'] -= (np.round(np.pmt(b / 12, c, -a), 2) - np.round(np.ipmt(b / 12, i, c, -a), 2))
            result['total'] = result['inst'] + result['prin']
        else:
            result['total'] = np.round(np.pmt(b / 12, c, -a), 2)
            result['prin'] = result['total'] - result['inst']
    elif fund_id == 250:
        result['total'] = np.round(np.pmt(b / 12, c, -a), 2)
        # result['prin'] = np.round(np.ppmt(b / 12, term, c, -a), 2)
        result['inst'] = np.round(np.ipmt(b / 12, term, c, -a), 2)
        result['prin'] = result['total'] - result['inst']
        # result['inst'] = result['total'] - result['prin']
    elif fund_id == 300:
        result['inst'] = 0
        if term == c:
            result['prin'] = a
            for i in xrange(1, c):
                result['prin'] -= np.round(a / c, 2)
            result['total'] = result['prin'] + result['inst']
        else:
            result['prin'] = np.round(a / c, 2)
            result['total'] = result['prin'] + result['inst']
    elif fund_id in (310, 320):
        result['inst'] = np.round(np.ipmt(b / 12, term, c, -a), 2)
        if term == c:
            result['prin'] = a
            for i in xrange(1, c):
                result['prin'] -= np.round(np.ppmt(b / 12, i, c, -a), 2)
            result['total'] = result['inst'] + result['prin']
        else:
            result['total'] = np.round(np.pmt(b / 12, c, -a), 2)
            result['prin'] = np.round(np.ppmt(b / 12, term, c, -a), 2)
    elif fund_id == 270:
        result['inst'] = np.round(np.ipmt(b / 12, term, c, -a), 2)
        if term == c:
            result['prin'] = a
            for i in xrange(1, c):
                result['prin'] -= np.round(np.ppmt(b / 12, i, c, -a), 2)
            result['total'] = result['inst'] + result['prin']
        else:
            result['total'] = np.round(np.pmt(b / 12, c, -a), 2)
            result['prin'] = np.round(np.ppmt(b / 12, term, c, -a), 2)
    return result


'''
晋商的剩余本金计算特殊区别
剩余本金计算
contract_amount：放款金额
term_no：期数
contract_term：合同期数
rate：利率
'''


def cal_surplus_prin(contract_amount, term_no, contract_term, rate, fund_code=0):
    prin = 0
    if fund_code == 300:
        avg = round(contract_amount / contract_term, 2)
        return contract_amount - avg * (term_no - 1)
    else:
        for i in xrange(1, term_no, 1):
            prin += np.ppmt(rate, i, contract_term, -contract_amount)
        return contract_amount - prin


def cal_cur_prin(contract_amount, term_no, contract_term, rate, fund_code=0):
    prin = 0
    if fund_code == 300:
        avg = round(contract_amount / contract_term, 2)
        if term_no < contract_term:
            return avg
        else:
            return contract_amount - avg * (term_no - 1)
    else:
        return np.ppmt(rate, term_no, contract_term, -contract_amount)


'''
剩余本息计算
'''


def cal_surplus_prininst(contract_amount, term_no, contract_term, rate):
    prin_inst = np.pmt(rate, contract_term, -contract_amount)
    return (contract_term + 1 - term_no) * prin_inst


# 罚息计算
def cal_deplay_fee(product_id, sys_tag, loan_id, contract_amount, deadline, repaid_at, contract_term, term_no,
                   monthly_amount, rate, fund_code):
    contract_term = int(contract_term)
    term_no = int(term_no)
    result = {'lkb_deplay_fee': 0}
    lkb_deplay_days = (repaid_at.date() - deadline.date()).days
    if lkb_deplay_days < 1:
        return result
    if repaid_at >= datetime.datetime(2017, 1, 20, 10, 0, 0) and repaid_at < datetime.datetime(2017, 5, 2, 14, 16,
                                                                                               0):  # 2017-1-20 号修改了罚息计算公式
        principle = cal_surplus_prin(contract_amount, term_no, contract_term, rate, fund_code)
        result['lkb_deplay_fee'] = contract_amount * 0.01 + principle * 0.005 * lkb_deplay_days
        return result
    elif repaid_at >= datetime.datetime(2017.5, 2, 14, 16, 0):
        principle = cal_surplus_prin(contract_amount, term_no, contract_term, rate, fund_code)
        result['lkb_deplay_fee'] = np.round(contract_amount * 0.01 + principle * 0.005 * lkb_deplay_days, 2)
        cur_principle = np.round(cal_cur_prin(contract_amount, term_no, contract_term, rate, fund_code), 2)
        if result['lkb_deplay_fee'] > cur_principle * 0.02:
            result['lkb_deplay_fee'] = np.round(cur_principle * 0.02, 2)
        return result
    if product_id == 1:
        # 如何之后跑数据的话，需要去掉repaid_at <= datetime.datetime(2015,11,16,20,0,0) 这个条件
        if sys_tag == 'LKB':
            lkb_deplay_days = lkb_deplay_days - 1
        fee = lkb_deplay_days * 10
        if fee > 150:
            fee = 150
        result['lkb_deplay_fee'] = fee
    elif product_id == 2:
        if sys_tag == 'LKB':
            lkb_deplay_days = lkb_deplay_days - 1
        result['lkb_deplay_fee'] = contract_amount * lkb_deplay_days * 0.005
    elif product_id == 5:
        result['lkb_deplay_fee'] = np.round(contract_amount * 0.01 + monthly_amount * 0.005 * lkb_deplay_days, 2)
    elif product_id in (7, 9, 10, 15):
        result['lkb_deplay_fee'] = np.round(contract_amount * 0.01 + contract_amount * (
            contract_term + 1 - term_no) / contract_term * 0.005 * lkb_deplay_days, 2)
    elif product_id in (11, 12, 13, 14, 16, 17, 19, 20, 21, 22, 23, 25, 26, 27, 28, 29, 32, 34, 35):
        result['lkb_deplay_fee'] = np.round(contract_amount * 0.01 + contract_amount * (
            contract_term + 1 - term_no) / contract_term * 0.005 * lkb_deplay_days, 2)
    elif product_id == 3:
        # 老马上
        if sys_tag == 'LKB':
            lkb_deplay_days = lkb_deplay_days - 1
            result['lkb_deplay_fee'] = np.round(contract_amount * 0.005 * lkb_deplay_days, 2)
        else:
            if repaid_at < datetime.datetime(2015, 11, 2, 21, 0, 0):
                result['lkb_deplay_fee'] = np.round(monthly_amount * 0.005 * lkb_deplay_days, 2)
            elif repaid_at >= datetime.datetime(2015, 11, 2, 21, 0, 0) and repaid_at < datetime.datetime(2015, 11, 3, 0,
                                                                                                         0, 0):
                result['lkb_deplay_fee'] = np.round(contract_amount * 0.01 * lkb_deplay_days, 2)
            elif repaid_at >= datetime.datetime(2015, 11, 3, 0, 0, 0) and repaid_at < datetime.datetime(2015, 11, 3, 17,
                                                                                                        0, 0, 0):
                result['lkb_deplay_fee'] = np.round(contract_amount * 0.005 * lkb_deplay_days, 2)
            elif repaid_at >= datetime.datetime(2015, 11, 3, 17, 0, 0, 0):
                result['lkb_deplay_fee'] = np.round(contract_amount * 0.01 + contract_amount * (
                    contract_term + 1 - term_no) / contract_term * 0.005 * lkb_deplay_days, 2)
    elif product_id == 18:
        pass
    else:
        print 'product_id error !!!', product_id, loan_id
    return result


def transfer_df(df):
    df['prin_record'] = df['prin_record'].apply(lambda x: np.round(x, 2))
    df['inst_record'] = df['inst_record'].apply(lambda x: np.round(x, 2))
    df['total_record'] = df['total_record'].apply(lambda x: np.round(x, 2))
    return df


def transfer(df):
    df['principle'] = df['principle'].apply(lambda x: np.round(x, 2))
    df['interest'] = df['interest'].apply(lambda x: np.round(x, 2))
    df['current_repayment'] = df['current_repayment'].apply(lambda x: np.round(x, 2))
    return df


def transfer_df_plan(df):
    df['prin_record'] = df['prin_record'].apply(lambda x: np.round(x, 2))
    df['inst_record'] = df['inst_record'].apply(lambda x: np.round(x, 2))
    df['total_record'] = df['total_record'].apply(lambda x: np.round(x, 2))
    df['prin'] = df['prin'].apply(lambda x: np.round(x, 2))
    df['inst'] = df['inst'].apply(lambda x: np.round(x, 2))
    df['total'] = df['total'].apply(lambda x: np.round(x, 2))
    return df


step = 10000


# 渤海华瑞
def insert_bhhr_repayment_record():
    # 渤海华瑞7月份
    # path_file = u'E:/xyqb/还资金方/201709简版/渤海宏泰LKB04结算明细——201709月 (简版).xlsx'
    # path_file = u'E:/xyqb/还资金方/201709简版/渤海华瑞二LKB03结算明细——201709月（简版）.xls'
    # path_file = u'E:/xyqb/还资金方/201709简版/渤海华瑞一LKB02结算明细——201709月（简版）.xls'
    path_file = u'E:/xyqb/还资金方/201709简版/渤海中合LKB01结算明细——201709月（简版）.xlsx'
    df1 = pd.read_excel(path_file,
                        skiprows=1, header=None,
                        names=['contract_no',
                               'term_no',
                               u'实还日期',
                               'current_repayment',
                               'principle',
                               'interest',
                               'punish_fee',
                               'funding_service_fee',
                               'repaid_at'
                               ])
    read_bh_deadline(df1)


def read_bh(df):
    df['contract_no'] = df['contract_no'].astype(str)
    a = df['contract_no'].tolist()
    df2 = pd.read_sql(select_bh_sql % (str(tuple(a)),), con=engine_xyqb)
    df = pd.merge(df, df2, how='left', on=['contract_no', 'term_no'])
    df['loan_id'] = df['loan_id'].astype(str)
    df['term_no'] = df['term_no'].astype(int)
    df = query_deadline(df)
    # df = df.ix[(df.deadline >= datetime.date(deadline_y, deadline_m, 1))]
    a = df['loan_id'].tolist()
    df3 = pd.read_sql(select_funding_sql % (str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df3, on='loan_id', how='left')
    df['term_no'] = df['term_no'].astype(int)
    df['ref_id'] = df['ref_id'].astype(int)
    df['principle'] = df['principle'].astype(float)
    df['current_repayment'] = df['current_repayment'].astype(float)
    df['interest'] = df['interest'].astype(float)
    df['punish_fee'] = df['punish_fee'].astype(float)
    df['funding_service_fee'] = df['funding_service_fee'].astype(float)
    df['AIR'] = df['monthly_interest_rate'] * 12
    df_out = df[
        ['loan_id', 'funding_code', 'term_no', 'deadline', 'principle', 'interest', 'funding_service_fee',
         'punish_fee', 'current_repayment', 'AIR', 'repaid_at', 'ref_id']]

    df_out.to_sql('funding_repayment_record', con=engine_audit, chunksize=step, if_exists='append', index=None)


def read_bh_deadline(df):
    df['contract_no'] = df['contract_no'].astype(str)
    a = df['contract_no'].tolist()
    df2 = pd.read_sql(select_bh_sql % (str(tuple(a)),), con=engine_xyqb)
    df = pd.merge(df, df2, how='left', on=['contract_no', 'term_no'])
    df['loan_id'] = df['loan_id'].astype(str)
    df['term_no'] = df['term_no'].astype(int)
    df = query_deadline(df)
    # df = df.ix[(df.deadline >= datetime.date(deadline_y, deadline_m, 1))]
    b = df['loan_id'].tolist()
    df3 = pd.read_sql(select_funding_sql % (str(tuple(b)),), con=engine_audit_select)
    df3['loan_id'] = df3['loan_id'].astype(str)
    df = pd.merge(df, df3, how='left', on='loan_id')
    df['term_no'] = df['term_no'].astype(int)
    df['ref_id'] = df['ref_id'].astype(int)
    df['principle'] = df['principle'].astype(float)
    df['current_repayment'] = df['current_repayment'].astype(float)
    df['interest'] = df['interest'].astype(float)
    df['punish_fee'] = df['punish_fee'].astype(float)
    df['funding_service_fee'] = df['funding_service_fee'].astype(float)
    df['AIR'] = df['monthly_interest_rate'] * 12
    df_out = df[
        ['loan_id', 'funding_code', 'term_no', 'deadline', 'principle', 'interest', 'funding_service_fee',
         'punish_fee', 'current_repayment', 'AIR', 'repaid_at', 'ref_id']]
    df_out.to_sql('funding_repayment_record', con=engine_audit, chunksize=step, if_exists='append', index=None)


query_deadline_sql = """
SELECT DISTINCT loan_application_history_id loan_id,term_no,deadline 
FROM repay 
WHERE loan_application_history_id in %s """


def query_deadline(df):
    df['loan_id'] = df['loan_id'].astype(str)
    df['term_no'] = df['term_no'].astype(int)
    a = df['loan_id'].tolist()
    df3 = pd.read_sql(query_deadline_sql % (str(tuple(a)),), con=engine_xyqb)
    df3['loan_id'] = df3['loan_id'].astype(str)
    df3['term_no'] = df3['term_no'].astype(int)
    df = pd.merge(df, df3, how='left', on=['loan_id', 'term_no'])
    return df


# 湖北消金
def insert_hbxj_repayment_record():
    # 湖北2017-07
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/湖北消金还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              u'湖北入账日期',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at',
                              u'备注'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    read_hbxj(df)


def read_hbxj(df):
    df['term_no'] = df['term_no'].astype(int)
    df = query_deadline(df)
    # df = df.ix[(df.deadline >= datetime.date(deadline_y, deadline_m, 1))]
    print len(df)
    a = df['loan_id'].tolist()
    df2 = pd.read_sql(select_funding_sql % (str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df2, how='left', on='loan_id')
    df['term_no'] = df['term_no'].astype(int)
    df['AIR'] = df['monthly_interest_rate'] * 12
    df['term_no'] = df['term_no'].astype(int)
    df['current_repayment'] = df['current_repayment'].astype(float)
    df_out = df[['loan_id', 'funding_code', 'term_no', 'deadline', 'principle', 'interest', 'current_repayment', 'AIR',
                 'repaid_at', 'ref_id']]
    df_out.to_sql('funding_repayment_record', con=engine_audit, chunksize=step, if_exists='append', index=None)


# 晋商
def insert_js_repayment_record():
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/晋商还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['request_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at',
                              'remark'
                              ], sheetname=u'全部还款')
    df['request_id'] = df['request_id'].astype(str)
    df['deadline'] = pd.to_datetime(df.deadline).dt.date
    # df = df.ix[(df.deadline >= datetime.date(deadline_y, deadline_m, 1))]
    read_js(df)


def read_js(df_out):
    for n in range(0, len(df_out), step):
        df = df_out[n:n + step]
        a = df['request_id'].tolist()
        df2 = pd.read_sql(select_request_sql % (str(tuple(a)).replace(',)', ')')), con=engine_xyqb)
        df2['loan_id'] = df2['loan_id'].astype(str)
        df2['request_id'] = df2['request_id'].astype(str)
        df = pd.merge(df, df2, how='left', on='request_id')
        a = df2['loan_id'].tolist()
        df3 = pd.read_sql(select_funding_sql % (str(tuple(a)),), con=engine_audit_select)
        df = pd.merge(df, df3, on='loan_id', how='left')
        # df = transfer(df)
        df['AIR'] = df['monthly_interest_rate'] * 12
        df = df[['loan_id', 'funding_code', 'term_no', 'deadline', 'principle', 'interest', 'current_repayment', 'AIR',
                 'repaid_at', 'ref_id', 'remark']]
        df.to_sql('funding_repayment_record', con=engine_audit, chunksize=step, if_exists='append', index=None)


# 桔子理财
def insert_jzlc_repayment_record():
    # 桔子理财2017-05月份
    df5 = pd.read_excel(u"E:/xyqb/还资金方/201705简版/桔子理财还款明细 -201705(简版）.xlsx")
    read_jz(df5)


def read_jz(df):
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    df.rename(columns={u'当前期数': 'term_no',
                       u'应还日期': 'deadline',
                       u'总和': 'total_record',
                       u'本金': 'prin_record',
                       u'利息': 'inst_record',
                       u'打款日期': 'repay_at'
                       }, inplace=True)
    print len(df)
    funding(df)


def insert_kl_repayment_record():
    # 考拉 201704
    df4 = pd.read_excel(u"E:/xyqb/还资金方/201704简版/考拉还款明细-201704（简版）.xlsx")
    read_kl(df4)


def read_kl(df):
    df.rename(columns={u'标的唯一ID': 'loan_id'}, inplace=True)
    df.rename(columns={u'当前期数': 'term_no'}, inplace=True)
    df.rename(columns={u'到期日': 'deadline'}, inplace=True)
    df.rename(columns={u'合计': 'total_record'}, inplace=True)
    df.rename(columns={u'本金': 'prin_record'}, inplace=True)
    df.rename(columns={u'利息': 'inst_record'}, inplace=True)
    df.rename(columns={u'打款时间': 'repay_at'}, inplace=True)
    df['loan_id'] = df['loan_id'].astype(str)
    print len(df)
    df['total_record'] = df.apply(lambda x: x.replace("￥", "").replace(",", ""))
    df['prin_record'] = df.apply(lambda x: x.replace("￥", "").replace(",", ""))
    df['prin_record'] = df.apply(lambda x: x.replace("￥", "").replace(",", ""))
    funding(df)


# 科易
def insert_ky_repayment_record():
    df1 = pd.read_excel(u"E:/xyqb/还资金方/201701简版/科易还款明细-201701（简版）.xlsx", sheetname=u'正常还款')
    read_ky(df1)


def read_ky(df):
    df.rename(columns={u'协议编号（c.ssq_contract_no）': 'contract_no',
                       u'还款期数': 'term_no',
                       u'应还日期': 'deadline',
                       u'本期应还款': 'total_record',
                       u'本金': 'prin_record',
                       u'利息': 'inst_record',
                       u'还款日期': 'repay_at'
                       }, inplace=True)
    df['contract_no'] = df['contract_no'].astype(str)
    a = df['contract_no'].tolist()
    df2 = pd.read_sql(select_loan_id_sql % (str(tuple(a)),), con=engine_xyqb)
    df2['loan_id'] = df2['loan_id'].astype(str)
    df = pd.merge(df, df2, on='contract_no', how='left')
    a = df2['loan_id'].tolist()
    df3 = pd.read_sql(select_funding_sql % (str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df3, on='loan_id', how='left')
    df['prin'] = df.apply(lambda x: cal_prin_inst(x)['prin'], axis=1)
    df['total'] = df.apply(lambda x: cal_prin_inst(x)['total'], axis=1)
    df['inst'] = df.apply(lambda x: cal_prin_inst(x)['inst'], axis=1)
    df['term_no'] = df['term_no'].astype(int)
    df['ref_id'] = df['ref_id'].astype(int)
    df['prin_record'] = df['prin_record'].astype(float)
    df['prin'] = df['prin'].astype(float)
    df['total_record'] = df['total_record'].astype(float)
    df['total'] = df['total'].astype(float)
    df['inst_record'] = df['inst_record'].astype(float)
    df['prin'] = df['prin'].astype(float)
    insertToDB(df)


def read_ky_tqjq(df):
    df.rename(columns={u'协议编号（c.ssq_contract_no）': 'contract_no'}, inplace=True)
    df.rename(columns={u'还款期数': 'term_no'}, inplace=True)
    df.rename(columns={u'应还日期': 'deadline'}, inplace=True)
    df.rename(columns={u'应还': 'total_record'}, inplace=True)
    df.rename(columns={u'本金': 'prin_record'}, inplace=True)
    df.rename(columns={u'利息': 'inst_record'}, inplace=True)
    df.rename(columns={u'打款日期': 'repay_at'}, inplace=True)
    df['contract_no'] = df['contract_no'].astype(str)
    a = df['contract_no'].tolist()
    df2 = pd.read_sql(select_loan_id_sql % (str(tuple(a)),), con=engine_xyqb)
    df2['loan_id'] = df2['loan_id'].astype(str)
    df = pd.merge(df, df2, on='contract_no', how='left')
    a = df2['loan_id'].tolist()
    df3 = pd.read_sql(select_funding_sql % (str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df3, on='loan_id', how='left')

    df['funding_code'] = df['funding_code'].astype(str)
    df['term_no'] = df['term_no'].astype(int)
    df['ref_id'] = df['ref_id'].astype(int)
    df['prin_record'] = df['prin_record'].astype(float)
    df['total_record'] = df['total_record'].astype(float)
    df['inst_record'] = df['inst_record'].astype(float)
    df['monthly_interest_rate'] = df['monthly_interest_rate'] * 12
    df['remark'] = '提前结清'
    df['remark'] = df['remark'].astype(str)
    val_list = df[['loan_id', 'funding_code', 'term_no', 'deadline', 'prin_record', 'inst_record', 'total_record',
                   'monthly_interest_rate',
                   'repay_at', 'ref_id', 'remark']].values.tolist()
    engine_audit.execute(insert_remark_sql, val_list)


# 口袋理财
def insert_kdlc_repayment_record():
    # 口袋理财2017-07
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/口袋理财还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'total_record',
                              'prin_record',
                              'inst_record',
                              'repay_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    funding(df)


# 随手记
def insert_ssj_repayment_record():
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/随手还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    insert_immediate(df)


# 真融宝
def insert_zrb_repayment_record():
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/真融宝还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    insert_immediate(df)


# 债转至真融宝
def TFY_repayment_record():
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/听枫语还款明细——201709月(简版).xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    insert_immediate(df)


# 沐金农
def insert_mjn_repayment_record():
    # 沐金农2017-07
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/沐金农还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    insert_immediate(df)


def insert_immediate(df):
    a = df['loan_id'].tolist()
    df2 = pd.read_sql(select_funding_sql % (str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df2, how='left', on='loan_id')
    df['term_no'] = df['term_no'].astype(int)
    df['AIR'] = df['monthly_interest_rate'] * 12
    # df = transfer_df(df)
    df = df[['loan_id', 'funding_code', 'term_no', 'deadline', 'principle', 'interest', 'current_repayment', 'AIR',
             'repaid_at', 'ref_id']]
    df.to_sql('funding_repayment_record', con=engine_audit, chunksize=step, if_exists='append', index=None)


# 米庄
def insert_mz_repayment_record():
    # 2017-04
    df = pd.read_excel(u"E:/xyqb/还资金方/201704简版/米庄还款明细-201704（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'total_record',
                              'prin_record',
                              'inst_record',
                              'repay_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    funding(df)


# 投之家
def insert_tzj01_repayment_record():
    # 2017-04
    df = pd.read_excel(u"E:/xyqb/还资金方/201704简版/投之家还款明细-201704（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'total_record',
                              'prin_record',
                              'inst_record',
                              'repay_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    funding_tzj_yqg(df, 190)


# 小赢
def insert_xy_repayment_record():
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/小赢还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    insert_immediate(df)


# 洋钱罐
def insert_yqg_repayment_record():
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/洋钱罐还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    insert_immediate(df)
    # funding_tzj_yqg(df, 140)


# 众网小贷

def insert_zwxd_repayment_record():
    # 2017-07
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/众网小贷还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'punish_fee',
                              'repaid_at'
                              ])
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    df['deadline'] = pd.to_datetime(df.deadline).dt.date
    read_zwxd(df)


def read_zwxd(df):
    print len(df)
    a = df['loan_id'].tolist()
    df2 = pd.read_sql(select_funding_double_sql % (str(350), str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df2, how='left', on='loan_id')
    df['funding_code'] = df['funding_code'].astype(int)
    df['term_no'] = df['term_no'].astype(int)
    df['ref_id'] = df['ref_id'].astype(int)
    df['AIR'] = df['monthly_interest_rate'] * 12
    df = df[['loan_id', 'funding_code', 'term_no', 'deadline', 'principle', 'interest', 'punish_fee',
             'current_repayment', 'AIR', 'repaid_at', 'ref_id']]
    df.to_sql(name='funding_repayment_record', con=engine_audit, if_exists='append', index=None, chunksize=step)


def funding_zwxd_yqg(df, funding_code):
    a = df['loan_id'].tolist()
    df2 = pd.read_sql(select_funding_double_sql % (str(funding_code), str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df2, how='left', on='loan_id')
    df['prin'] = df.apply(lambda x: cal_prin_inst(x)['prin'], axis=1)
    df['total'] = df.apply(lambda x: cal_prin_inst(x)['total'], axis=1)
    df['inst'] = df.apply(lambda x: cal_prin_inst(x)['inst'], axis=1)
    df['funding_code'] = df['funding_code'].astype(int)
    df['term_no'] = df['term_no'].astype(int)
    df['prin_record'] = df['prin_record'].astype(float)
    df['prin'] = df['prin'].astype(float)
    df['total_record'] = df['total_record'].astype(float)
    df['total'] = df['total'].astype(float)
    df['inst_record'] = df['inst_record'].astype(float)
    df['prin'] = df['prin'].astype(float)
    df['AIR'] = df['monthly_interest_rate'] * 12
    val_list = df[['loan_id', 'funding_code', 'term_no', 'deadline', 'prin', 'inst', 'punish_record', 'total', 'AIR',
                   'repay_at']].values.tolist()
    engine_audit.execute(insert_punish_sql, val_list)


# 广源小贷
def insert_gyxd_repayment_record():
    # 2017-07
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/广源小贷还款明细——201709月（简版）.xlsx",
                       skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at'
                              ])
    df['remark'] = '逾期代偿'
    df['deadline'] = pd.to_datetime(df.deadline).dt.date
    # df = df.ix[(df.deadline >= datetime.date(deadline_y, deadline_m, 1))]
    df['remark'] = df['remark'].astype(str)
    df['loan_id'] = df['loan_id'].map('{:.0f}'.format)
    funding_gyxd(df)


def funding_gyxd(df):
    a = df['loan_id'].tolist()
    df2 = pd.read_sql(select_funding_sql % (str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df2, how='left', on='loan_id')
    df['funding_code'] = df.funding_code.map('{:.0f}'.format)
    df['term_no'] = df['term_no'].astype(int)
    df['ref_id'] = df['ref_id'].astype(int)
    df = transfer_df(df)
    df['interest'] = df['interest'].fillna(0)
    df['monthly_interest_rate'] = df['monthly_interest_rate'].astype(float)
    df['AIR'] = df['monthly_interest_rate'] * 12
    df_out = df[['loan_id', 'funding_code', 'term_no', 'deadline', 'principle', 'interest', 'current_repayment',
                 'AIR', 'repaid_at', 'ref_id', 'remark']]
    df_out.to_sql('funding_repayment_record', con=engine_audit, if_exists='append', index=None, chunksize=step)


check_yggy = """ 
select urp.loan_id,urp.term_no,urp.principle,urp.interest,urp.service_fee

FROM
	 user_repayment_plan urp
	join audit.yangguang_batch_no  ygbn on urp.loan_id=ygbn.loan_id
	
where ygbn.batch_no ='HZ20170316-055-001-001'
and 
	urp.fund_code = 330
AND urp.deadline<'2017-04-24' 	
 AND urp.deadline>='2017-04-01'   """


# 阳光广源
def insert_yggy_repayment_record():
    # 2017-04 实还明细
    df_sh = pd.read_excel(u"E:/xyqb/还资金方/201704简版/阳光广源还款明细-201704（简版）.xlsx", sheetname=u'实还明细')
    df_sh.rename(columns={u'还款日期': 'repay_at'}, inplace=True)
    df_sh.rename(columns={u'还款金额': 'repay_amount'}, inplace=True)
    df_sh.rename(columns={u'放款批次': 'loan_batch'}, inplace=True)
    df_sh['loan_id'] = df_sh['loan_id'].astype(str)
    df_sh['term_no'] = df_sh['term_no'].astype(int)
    a = df_sh['loan_id'].tolist()
    df = pd.read_sql(select_repayment_plan % (str(tuple(a)),), con=engine_new_transaction_select)
    df['loan_id'] = df['loan_id'].astype(str)
    df['term_no'] = df['term_no'].astype(int)
    df = pd.merge(df_sh, df, on=['loan_id', 'term_no'])
    df['punish_fee'] = 0.00
    select_punish_funding_sql = """ 
     select DISTINCT product_code AS product_id,
            loan_id, funding_code,
            contract_loan_amount AS contract_amount,
            contract_term,monthly_interest_rate AS monthly_rate,
            monthly_required_repayment_amount AS monthly_amount 
      from loan_manifest 
      WHERE loan_id IN %s"""
    df2 = pd.read_sql(select_punish_funding_sql % (str(tuple(a)),), con=engine_audit_select)
    df2['loan_id'] = df2['loan_id'].astype(str)
    df = pd.merge(df, df2, how='left', on='loan_id')
    df.rename(columns={'loan_id_x': 'loan_id'}, inplace=True)
    df.rename(columns={'term_no_x': 'term_no'}, inplace=True)
    df_punish = df.ix[df.deadline < df.repay_at]
    df = df.ix[df.deadline >= df.repay_at]
    if len(df_punish) > 0:
        df_punish['punish_fee'] = df_punish.apply(lambda row: cal_deplay_fee(row['product_id'],
                                                                             row['sys_tag'], row['loan_id'],
                                                                             row['contract_amount'],
                                                                             row['deadline'],
                                                                             row['repay_at'], row['contract_term'],
                                                                             row['term_no'],
                                                                             row['monthly_amount'],
                                                                             row['monthly_rate'], row['funding_code'])[
            'lkb_deplay_fee'], axis=1)
    df = df.append(df_punish)
    df['mitigate_fee'] = np.round(
        df['principle'] + df['interest'] + df['service_fee'] + df['punish_fee'] - df['repay_amount'], 2)
    df['current_repayment'] = df['principle'] + df['interest']
    df['monthly_rate'] = df['monthly_rate'].astype(float)
    df['AIR'] = df['monthly_rate'] * 12
    val_list = df[
        ['loan_id', 'funding_code', 'term_no', 'deadline', 'principle', 'interest', 'service_fee', 'punish_fee',
         'current_repayment', 'AIR', 'repay_at', 'loan_batch', 'mitigate_fee']].values.tolist()
    engine_audit.execute(insert_yggy_sql, val_list)
    # df.to_excel(u"E:/xyqb/还资金方/201704简版/one_in_all.xlsx", index=None)


# 华融
def insert_hr_repayment_record():
    df = pd.read_excel(u"E:/xyqb/还资金方/201709简版/华融还款明细——201709月（简版）.xlsx", skiprows=1, header=None,
                       names=['loan_id',
                              'term_no',
                              'deadline',
                              'current_repayment',
                              'principle',
                              'interest',
                              'repaid_at'
                              ], sheetname=u'华融9月总还款')

    df['loan_id'] = df.loan_id.map('{:.0f}'.format)
    df['deadline'] = pd.to_datetime(df.deadline).dt.date
    # df = df.ix[(df.deadline >= datetime.date(deadline_y, deadline_m, 1))]
    insert_immediate(df)


def funding(df):
    a = df['loan_id'].tolist()
    df2 = pd.read_sql(select_funding_sql % (str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df2, how='left', on='loan_id')
    df['prin'] = df.apply(lambda x: cal_prin_inst(x)['prin'], axis=1)
    df['total'] = df.apply(lambda x: cal_prin_inst(x)['total'], axis=1)
    df['inst'] = df.apply(lambda x: cal_prin_inst(x)['inst'], axis=1)
    df['funding_code'] = df['funding_code'].astype(int)
    df['term_no'] = df['term_no'].astype(int)
    df['ref_id'] = df['ref_id'].astype(int)
    # df = transfer_df_plan(df)
    insertToDB(df)


def funding_tzj_yqg(df, funding_code):
    a = df['loan_id'].tolist()
    df2 = pd.read_sql(select_funding_double_sql % (str(funding_code), str(tuple(a)),), con=engine_audit_select)
    df = pd.merge(df, df2, how='left', on='loan_id')
    df['funding_code'] = df['funding_code'].astype(int)
    df['term_no'] = df['term_no'].astype(int)
    df['ref_id'] = df['ref_id'].astype(int)
    df = transfer_df_plan(df)
    insertToDB(df)


def insertToDB(df):
    df['AIR'] = df['monthly_interest_rate'] * 12
    df_1 = df[['loan_id', 'funding_code', 'term_no', 'deadline', 'prin', 'inst', 'total', 'AIR',
               'repay_at', 'ref_id']]
    df_1.rename(
        columns={'prin': 'principle', 'inst': 'interest', 'total': 'current_repayment', 'repay_at': 'repaid_at'},
        inplace=True)
    df_1.to_sql('funding_repayment_record', con=engine_audit, chunksize=step, if_exists='append', index=None)


# 渤海 ok
# insert_bhhr_repayment_record()

# 湖北 ok
# insert_hbxj_repayment_record()

# 橘子理财(无本月数据)
# insert_jzlc_repayment_record()

# 考拉 (无本月数据)
# insert_kl_repayment_record()

# 科易 (无本月数据)
# insert_ky_repayment_record()

# 晋商 ok
# insert_js_repayment_record()

# 口袋理财 ok
# insert_kdlc_repayment_record()

# 米庄 (无本月数据)
# insert_mz_repayment_record()

# 投之家 (无本月数据)
# insert_tzj01_repayment_record()

# 小赢 ok
# insert_xy_repayment_record()

# 洋钱罐 ok
# insert_yqg_repayment_record()

# 华融 ok
# insert_hr_repayment_record()

# 广源小贷 ok
# insert_gyxd_repayment_record()

# 众网小贷 ok
# insert_zwxd_repayment_record()

# 阳光广源(无本月数据)
# insert_yggy_repayment_record()

# 随手记 ok
# insert_ssj_repayment_record()

# 沐金农 ok
# insert_mjn_repayment_record()

# 真融宝 ok
# insert_zrb_repayment_record()

# 听枫语 ok
# TFY_repayment_record()
