import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
from itertools import product
import os
import pyexcelerate
reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None

max_limit = 800000
import os


# '''
# 在代码之前，需要进行前期数据的准备，先从数据库中获取所需数据，然后用pandas读取进行操作
# 需要特别注意数据库、表、字段的使用
# '''

# @author Han
# 表名称：
#	现金贷-核算-放款表明细（1-6月份）
# 表字段：
#	唯一编 号 E=A&C
#
#
# 资金方 Loan id A
# 合同号 放款时 间 B
# 放款金 额
# 放款渠 道
# 应收总 服务费
# 应还期 数 C
# 应还资 金方时 间
# 应还资 金方本 息 D
# Merge E&B&D
# 应还期 数
# 应还资 金方时 间
# 应还资 金方本 息
# 应还期 数
# 客户实还服务 费
# 客户实还本 息
# 应还总服务费-实还服务 费
# 应还资金方本息-客 户实还本息
#
# 数据库：
#	repay_detail，pay_detail
# 注意事项：
#	loan_manifest.is_active in （1，-2）

# 	需要先进行数据的获取，需要时间较长，sql_repay_all中xrd.repaid_at同样需要修改

path = u'E:/审计出表/人工控制/现金贷-放款表/'
engine_xjd = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.4.60:3306/audit?charset=utf8',
						   echo=False).connect()
#
# #使用时先要修改 deadline，如果出9月份的，deadline > = 2017-09-01即可
sql_fund = '''
	select frp.ref_id,frp.term_no '应还期数',date(frp.deadline) '应还资金方时间',frp.principle+frp.interest '应还资金方本息'
	from all_back_0930.funding_repayment_plan frp
	where frp.deadline >= '2017-09-01'
'''
df_fund = pd.read_sql(sql_fund,engine_xjd)
#
#此部分不需要进行修改
sql_contract_no = '''
select ref_id,contract_no
from basic.loan_class_contract_1002 lco
'''
#10月05日修改为basic.loan_class_contract_1002

df_contract_no = pd.read_sql(sql_contract_no,engine_xjd)

# df_repay_all = pd.read_csv(u'E:/人工控制-现金贷-放款表（客户实还汇总）.csv',encoding='utf8')
# df_contract_no = pd.read_csv(u'E:/人工控制-现金贷-放款合同号专用.csv',encoding='utf8')

def mc_pay(year, month):
	#year, month = 2017, 2
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)

	sql_repay_all = '''
	select 
	urp.ref_id,
	urp.term_no '应还期数',
	sum(xrprrr.principle-IFNULL(xrprrr.mitigate_principle,0)+xrprrr.interest-IFNULL(xrprrr.mitigate_interest,0)) '客户实还本息',
	sum(xrprrr.service_fee-IFNULL(xrprrr.mitigate_service_fee,0)) '实还服务费'
	from all_back_0930.xjd_repay_plan_repay_record_ref xrprrr
	join all_back_0930.user_repayment_plan urp on xrprrr.plan_id = urp.id
	join all_back_0930.loan_manifest lm on lm.ref_id = urp.ref_id
	where lm.loan_paid_at>='%s' and lm.loan_paid_at<'%s'
	group by 1,2
	''' %(start_time,end_time)

	sql_pay = '''
	SELECT
		fc.`name` '资金方',
		lm.loan_id 'loan_id',
		date(lm.loan_paid_at) '放款时间',
		lm.contract_loan_amount '放款金额',
		la.accountName '放款渠道',
		lm.contract_term*lm.per_term_service_fee '应收总服务费',
		lm.ref_id
	FROM
		audit.loan_manifest lm
	join basic.funding_corp fc on fc.funding_code = lm.funding_code
	join all_back_0930.loan_account la on la.id = lm.loan_account_id
	WHERE
		lm.loan_paid_at >= '%s'
	AND lm.loan_paid_at < '%s'
	AND lm.is_active IN (1, -2)
	''' % (start_time, end_time)

	df_pay = pd.read_sql(sql_pay, engine_xjd)
	df_repay_all = pd.read_sql(sql_repay_all, engine_xjd)

	print(sum(df_repay_all[u'客户实还本息']))
	df_pay['ref_id'] = df_pay['ref_id'].astype('int64')
	df_fund['ref_id'] = df_fund['ref_id'].astype('int64')

	df_pay = pd.merge(df_pay,df_fund,on='ref_id',how='left')
	# df_pay= df_pay.drop([u'ref_id'])

	df_pay = df_pay.fillna(0)
	df_pay[u'唯一编号'] = df_pay['loan_id'].astype('str')+df_pay[u'应还期数'].astype('int').astype('str')

	df_pay[u'Merge'] = df_pay[u'唯一编号']+df_pay[u'放款时间'].astype('str')+df_pay[u'应还资金方本息'].astype('str')

	df_pay['loan_id'] = df_pay['loan_id'].astype('int64')
	df_pay['ref_id'] = df_pay['ref_id'].astype('int64')
	df_pay[u'应还期数'] = df_pay[u'应还期数'].astype('int64')

	df_repay_all[u'ref_id'] = df_repay_all[u'ref_id'].astype('int64')
	df_repay_all[u'应还期数'] = df_repay_all[u'应还期数'].astype('int64')

	df_pay = pd.merge(df_pay, df_repay_all, on=[u'ref_id',u'应还期数'], how='left')

	df_pay[u'客户实还服务费'] = df_pay[u'实还服务费']
	df_pay.loc[df_pay['loan_id'].duplicated(), u'放款金额'] = 0
	df_pay.loc[df_pay['loan_id'].duplicated(), u'应收总服务费'] = 0

	df_pay[u'应还总服务费-实还服务费'] = df_pay[u'应收总服务费'].fillna(0) - df_pay[u'实还服务费'].fillna(0)
	df_pay[u'应还资金方本息-客户实还本息'] = df_pay[u'应还资金方本息'].fillna(0) - df_pay[u'客户实还本息'].fillna(0)

	df_pay = pd.merge(df_pay,df_contract_no,on='ref_id',how='left')
	df_pay = df_pay.fillna(0)
	df_pay = df_pay.drop(['ref_id',u'实还服务费'],axis = 1)

	print(u'放款金额:' + str(sum(df_pay[u'放款金额'])) + u' 应收总服务费:' + str(sum(df_pay[u'应收总服务费'])) + u' 应还资金方本息:' + str(
		sum(df_pay[u'应还资金方本息'])) + u' 客户实还本息' + str(
		sum(df_pay[u'客户实还本息'])))
	df_pay.rename(columns = {'contract_no':u'合同号',u'实还服务费':u'客户实还服务费'},inplace = True)

	columns = [u'唯一编号',u'资金方',u'loan_id',u'合同号',u'放款时间',u'放款金额',u'放款渠道',u'应收总服务费',u'应还期数',u'应还资金方时间',
			   u'应还资金方本息',u'Merge',u'应还期数',u'应还资金方时间',u'应还资金方本息',u'应还期数',u'客户实还服务费',u'客户实还本息',
			   u'应还总服务费-实还服务费',u'应还资金方本息-客户实还本息']

	all_wb = pyexcelerate.Workbook()
	for i in xrange(0, len(df_pay), max_limit):
		temp = df_pay[i:i+max_limit][columns]
		temp_list = temp.values.tolist()
		temp_list.insert(0,temp.columns.tolist())
		all_wb.new_sheet(str(int(i/max_limit + 1)),data=temp_list)
	all_wb.save(path+u'人工控制-现金贷-放款表_(%d-%02d).xlsx' %(start_time.year,start_time.month))


	# if len(df_pay) > max_limit:
	# 	for i in xrange(0, len(df_pay), max_limit):
	# 		df_pay[i:i + max_limit].to_excel(os.path.join(path, u'人工控制-现金贷-放款表-(%s-%02d)-%d.xlsx' % (
	# 			year, month, i / max_limit + 1)), index=None, columns=columns)
	# else:
	# 	df_pay.to_excel(path + u'人工控制-现金贷-放款表-(%d-%d).xlsx' % (year, month), index=None, columns=columns)

if __name__ == '__main__':
	year = [2017]
	month = range(9, 10, 1)

	for year, month in product(year, month):
		mc_pay(year, month)
