# -*- coding:utf-8 -*-
# Author: WuKong

import sys
import datetime
import itertools
import pandas as pd
from sqlalchemy import create_engine
import multiprocessing as mtp
import os

reload(sys)
sys.setdefaultencoding('utf8')

engine_new_transaction = create_engine(
    'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/new_transaction?charset=utf8',
    echo=True)
# 渤海 160, 270, 310,320, 410 都不需要出赔付表
# 部分资金方取客户应还 210, 365, 350, 290, 330, 340,390,1,2,3,4,5,70,135,141
# 90 金融圈 200 科易小贷  120 网贷天眼 29 马上金融
# 465 首创金服  365 真融宝
path = u'C:\\Users\\wangbo\\Desktop\\11月份对账\\赔付表数据\\'
'''
1、应还资金方本息
'''
sql_fund = '''
select funding_code fund_code,name fund_name from basic.funding_corp WHERE  funding_code  IN (480)
'''
sql_repay_channel = '''
select id repay_channel , approach_name channel_name FROM new_transaction.`repay_channel`
'''
df_fund = pd.read_sql(sql_fund, con=engine_new_transaction)
df_repay_channel = pd.read_sql(sql_repay_channel, con=engine_new_transaction)

# 还资金方时间-- 更改时间为还款时间
start_time = '2015-04-01 00:00:00'
end_time = '2017-11-01 00:00:00'

# 还资金方时间
start_time_deadline = '2016-12-01 00:00:00'
end_time_deadline = '2017-11-01 00:00:00'

# 限制放款时间
start_loan_paid_at = '2017-01-01 00:00:00'
end_laon_paid_at = '2017-11-01 00:00:00'

# 资金方还款计划
sql_fund_hk = '''
SELECT DATE(t1.deadline) day_hk,t1.funding_code fund_code,(t1.`principle`+t1.`interest`) plan_principle_interest, t2.ref_id
FROM audit.`funding_repayment_record` t1
JOIN audit.loan_manifest t2 ON t1.ref_id = t2.ref_id
WHERE  t1.is_active = 1 AND t1.funding_code=%s
and t1.deadline >= '%s' AND t1.deadline < '%s'
AND t2.is_active in (1,-2) AND t2.loan_paid_at>='%s' AND t2.loan_paid_at<'%s'
'''

# 客户还款计划
sql_plan_hk = '''
SELECT DATE(deadline) day_hk,(principle+interest) plan_principle_interest, t2.ref_id
FROM  `user_repayment_plan` t1 JOIN audit.loan_manifest t2 ON t1.ref_id = t2.ref_id
WHERE t1.fund_code=%s and t1.deadline >= '%s' AND t1.deadline < '%s'
AND t2.is_active in (1,-2) AND t2.loan_paid_at>='%s' AND t2.loan_paid_at<'%s'
'''


# 有一部分直投资金方 应还资金方本息 没有录入funding_repayment_record 直接使用 user_repayment_plan
sql_fund_hk_user_plan = '''
SELECT DATE(urp.deadline) day_hk,lm.funding_code fund_code,
  (urp.`principle`+urp.`interest`) plan_principle_interest,
  lm.ref_id
FROM `user_repayment_plan` urp
JOIN audit.loan_manifest lm ON urp.ref_id=lm.ref_id
WHERE  lm.is_active in (1,-2) AND lm.funding_code=%s
and urp.deadline >= '%s' AND urp.deadline < '%s'
AND lm.is_active in (1,-2) AND lm.loan_paid_at>='%s' AND lm.loan_paid_at<'%s'
'''

#=============================实还数据 取客户的deadline  应还时间使用 还资金方的deadlin ========================
sql_hk_online = '''
SELECT
DATE(t2.bill_time) repaid_at,
DATE(t3.deadline) deadline ,
t1.repay_channel,
t3.fund_code,
(t1.`principle`-t1.`mitigate_principle`+t1.`interest`-t1.`mitigate_interest`) repay_principle_interest,
t4.ref_id
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `repay_record_online` t2 ON  t1.record_id = t2.id AND t1.repay_channel =t2.pay_approach
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN audit.loan_manifest t4 ON t3.ref_id = t4.ref_id
WHERE t3.fund_code = %s and t2.bill_time >= '%s' and t2.bill_time < '%s'
AND t4.is_active in (1,-2) AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
'''

sql_hk_alipay = '''
SELECT
DATE(t2.transfer_time) repaid_at,
DATE(t3.deadline) deadline ,
t1.repay_channel,
t3.fund_code,
(t1.`principle`-t1.`mitigate_principle`+t1.`interest`-t1.`mitigate_interest`) repay_principle_interest ,
t4.ref_id
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `offline_alipay_record` t2 ON t1.repay_channel = 13 AND t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  audit.loan_manifest t4 ON t3.ref_id = t4.ref_id
WHERE t3.fund_code=%s and t2.transfer_time >= '%s' and  t2.transfer_time < '%s'
AND t4.is_active in (1,-2) AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
'''

sql_hk_bank = '''
SELECT
DATE(t2.transfer_time) repaid_at,
DATE(t3.deadline) deadline ,
t1.repay_channel,
t3.fund_code,
(t1.`principle`-t1.`mitigate_principle`+t1.`interest`-t1.`mitigate_interest`) repay_principle_interest ,
t4.ref_id
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `offline_bank_repay_record` t2 ON t1.repay_channel in (14,15,16) AND t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  audit.loan_manifest t4 ON t3.ref_id = t4.ref_id
WHERE t3.fund_code=%s and t2.transfer_time >= '%s' and  t2.transfer_time < '%s'
AND t4.is_active in (1,-2) AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
'''
# ============================================================================================

# ====== 实还数据 应还时间使用还资金方的deadline======================
sql_hk_fund_deadline_online = """
SELECT
	DATE(t2.bill_time) repaid_at,
	DATE(t4.deadline) deadline,
	t1.repay_channel,
	t3.fund_code,
	(t1.`principle`-t1.`mitigate_principle`+t1.`interest`-t1.`mitigate_interest`) repay_principle_interest ,
	t5.ref_id
	FROM
	`xjd_repay_plan_repay_record_ref` t1
JOIN `repay_record_online` t2 ON t1.repay_channel =t2.pay_approach AND t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN audit.funding_repayment_record t4 ON t4.ref_id = t3.ref_id AND t4.term_no = t3.term_no
JOIN  audit.loan_manifest t5 ON t4.ref_id = t5.ref_id
WHERE t3.fund_code =  %s  and t2.bill_time >= '%s' and t2.bill_time < '%s'
AND t5.is_active in (1,-2) AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
	"""


sql_hk_fund_deadline_alipay = '''
SELECT
DATE(t2.transfer_time) repaid_at,
DATE(t4.deadline) deadline ,
t1.repay_channel,
t3.fund_code,
(t1.`principle`-t1.`mitigate_principle`+t1.`interest`-t1.`mitigate_interest`) repay_principle_interest,
t5.ref_id
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `offline_alipay_record` t2 ON t1.repay_channel = 13 AND t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN audit.funding_repayment_record t4 ON t4.ref_id = t3.ref_id AND t4.term_no = t3.term_no
JOIN  audit.loan_manifest t5 ON t4.ref_id = t5.ref_id
WHERE t3.fund_code=%s and t2.transfer_time >= '%s' and  t2.transfer_time < '%s'
AND t5.is_active in (1,-2) AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
'''


sql_hk_fund_deadline_bank = '''
SELECT DATE(t2.transfer_time) repaid_at,
DATE(t4.deadline) deadline ,
t1.repay_channel,
t3.fund_code,
(t1.`principle`-t1.`mitigate_principle`+t1.`interest`-t1.`mitigate_interest`) repay_principle_interest ,
t5.ref_id
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `offline_bank_repay_record` t2 ON t1.repay_channel in (14,15,16) AND t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN audit.funding_repayment_record t4 ON t4.ref_id = t3.ref_id AND t4.term_no = t3.term_no
JOIN  audit.loan_manifest t5 ON t4.ref_id = t5.ref_id
WHERE t3.fund_code=%s and t2.transfer_time >= '%s' and  t2.transfer_time < '%s'
AND t5.is_active in (1,-2) AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
'''
# ====================================================================================================


# 阳光徽商的还款数据
sql_yangguang_hk = '''
SELECT
	DATE(repay_date) repaid_at,
	DATE(deadline) deadline,
	2 repay_channel,
	340 fund_code,
	(actual_principle+actual_interest) repay_principle_interest,
    t1.ref_id
FROM
	new_transaction.yg_huishang_repay_term t1
	JOIN	audit.loan_manifest t2 ON t1.ref_id = t2.ref_id
WHERE
	repay_date >= '%s'
AND repay_date < '%s' AND t2.is_active in (1,-2) AND t2.loan_paid_at>='%s' AND t2.loan_paid_at<'%s'
'''

# =====委ACD 还资金方数据======
sql_A = '''
SELECT DATE(transfer_time) day_hk,50 fund_code,transfer_amount plan_principle_interest,0 ref_id FROM audit.lkb_to_fund WHERE  fund_corp='张初阳'
'''
sql_C = '''
SELECT DATE(transfer_time) day_hk,80 fund_code,transfer_amount plan_principle_interest, 0 ref_id FROM audit.lkb_to_fund WHERE  fund_corp='李然'
'''
sql_D = '''
SELECT DATE(transfer_time) day_hk,130 fund_code,transfer_amount plan_principle_interest, 0 ref_id FROM audit.lkb_to_fund WHERE  fund_corp='曾思成'
'''

def other_table(fund_code, fund_name):
    # -----应还资金方本息begin------
    if fund_code == 50:  # 应还本息使用客户实际还款，按照还款时间进行统计
        df_plan = pd.read_sql(sql_A, engine_new_transaction)
    elif fund_code == 80:
        df_plan = pd.read_sql(sql_C, engine_new_transaction)
    elif fund_code == 130:
        df_plan = pd.read_sql(sql_D, engine_new_transaction)
    elif fund_code in ( 210, 365, 350,480,465,365):
        # 众网小贷本月特殊取客户应还
        # 有一部分直投资金方 应还资金方本息 没有录入funding_repayment_record 直接使用 user_repayment_plan
        df_plan = pd.read_sql(sql_fund_hk_user_plan % (fund_code, start_time_deadline, end_time_deadline,start_loan_paid_at,end_laon_paid_at),
                              con=engine_new_transaction)
        df_plan.fillna(0, inplace=True)
    else:
        df_plan = pd.read_sql(sql_fund_hk % (fund_code, start_time_deadline, end_time_deadline,start_loan_paid_at,end_laon_paid_at),
                              con=engine_new_transaction)
        df_plan.fillna(0, inplace=True)

    df_plan['day_hk'] = pd.to_datetime(df_plan['day_hk']).apply(lambda x: x.date())
    df_plan.fund_code = df_plan.fund_code.astype(int)
    # 考拉T+1
    if fund_code == 170:
        df_plan.ix[(df_plan.day_hk == datetime.date(2017, 1, 1)), 'day_hk'] = datetime.date(2016,12,31)

    if fund_code in [140, 230, 240, 250, 260]:
        # 洋钱罐，四小理财T+2
        df_plan.ix[(df_plan.day_hk >= datetime.date(2017, 1, 1)) & (df_plan.day_hk < datetime.date(2017, 1, 3)), 'day_hk'] = datetime.date(2016,12,31)
    if fund_code == 300:
        # 晋商2
        df_plan.ix[(df_plan.day_hk >= datetime.date(2017,9,28)) & (df_plan.day_hk < datetime.date(2017, 10, 1)), 'day_hk'] = datetime.date(2017,10,1)

    df_plan.ref_id = df_plan.ref_id.astype(int)
    df_plan = df_plan.ix[~df_plan.ref_id.isin(delete_ref_id_list)]
    df_plan = df_plan.groupby(by=['day_hk'])['plan_principle_interest'].sum()
    df_plan = df_plan.to_frame()
    df_plan.reset_index(inplace=True)
    # =======================应还资金方本息end===========================================

    # =========实还==============
    if fund_code in [2, 3, 4, 5]:  # 客户实还使用 还资金方deadline
        df_online_hk = pd.read_sql(sql_hk_fund_deadline_online % (fund_code, start_time, end_time,start_loan_paid_at,end_laon_paid_at),
                                   con=engine_new_transaction)
        df_alipay_hk = pd.read_sql(sql_hk_fund_deadline_alipay % (fund_code, start_time, end_time,start_loan_paid_at, end_laon_paid_at),
                                   con=engine_new_transaction)
        df_bank_hk = pd.read_sql(sql_hk_fund_deadline_bank % (fund_code, start_time, end_time,start_loan_paid_at, end_laon_paid_at),
                                 con=engine_new_transaction)
    # elif fund_code in [240,250]:
    #     df_online_hk = pd.read_sql(sql_hk_fund_deadline_online % (fund_code, start_time, end_time,start_loan_paid_at, end_laon_paid_at),
    #                                con=engine_new_transaction)
    #     df_alipay_hk = pd.read_sql(sql_hk_fund_deadline_alipay % (fund_code, start_time, end_time, start_loan_paid_at, end_laon_paid_at),
    #                                con=engine_new_transaction)
    #     df_bank_hk = pd.read_sql(sql_hk_fund_deadline_bank % (fund_code, start_time, end_time,start_loan_paid_at ,end_laon_paid_at),
    #                              con=engine_new_transaction)
    else:
        df_online_hk = pd.read_sql(sql_hk_online % (fund_code, start_time, end_time, start_loan_paid_at, end_laon_paid_at), con=engine_new_transaction)
        df_alipay_hk = pd.read_sql(sql_hk_alipay % (fund_code, start_time, end_time,start_loan_paid_at , end_laon_paid_at), con=engine_new_transaction)
        df_bank_hk = pd.read_sql(sql_hk_bank % (fund_code, start_time, end_time,start_loan_paid_at ,end_laon_paid_at), con=engine_new_transaction)

    df_hk = pd.concat([df_alipay_hk, df_online_hk, df_bank_hk], axis=0, ignore_index=True)
    df_hk['repaid_at'] = pd.to_datetime(df_hk['repaid_at']).apply(lambda x: x.date())
    df_hk['deadline'] = pd.to_datetime(df_hk['deadline']).apply(lambda x: x.date())
    df_hk.fillna(0, inplace=True)
    df_hk.ref_id = df_hk.ref_id.astype(int)
    df_hk = df_hk.ix[~df_hk.ref_id.isin(delete_ref_id_list)]
    if len(df_hk) < 1:
        return

    # =====考拉 T+1---包括这一天的逾期还款和正常还款
    # ======洋钱罐，四理财 T+2
    if fund_code == 170:
        df_hk.ix[(df_hk.repaid_at <= datetime.date(2017, 1, 1)) & (
            df_hk.deadline <= datetime.date(2017, 1, 1)), 'repay_principle_interest'] = 0
    elif fund_code in [140, 230, 240, 250, 260]:
        df_hk.ix[(df_hk.repaid_at <= datetime.date(2017, 1, 2)) & (
        df_hk.deadline <= datetime.date(2017, 1, 2)), 'repay_principle_interest'] = 0
    # =============正常还款=========
    df_zc = df_hk.ix[df_hk['repaid_at'] == df_hk['deadline']]
    df_zc = df_zc.groupby(by=['repaid_at'])['repay_principle_interest'].sum()
    df_zc = df_zc.to_frame()
    df_zc.reset_index(inplace=True)
    df_zc.rename(columns={'repaid_at': 'day_hk', 'repay_principle_interest': 'zc_prin_inst_total'}, inplace=True)
    df_zc['day_hk'] = pd.to_datetime(df_zc['day_hk']).apply(lambda x: x.date())

    # ===========逾期还款==============
    df_yq = df_hk.ix[df_hk['deadline'] < df_hk['repaid_at']]

    df_yq = df_yq.groupby(by=['repaid_at'])['repay_principle_interest'].sum()
    df_yq = df_yq.to_frame()
    df_yq.reset_index(inplace=True)
    df_yq.rename(columns={'repaid_at': 'day_hk', 'repay_principle_interest': 'yq_prin_inst_total'}, inplace=True)
    df_yq['day_hk'] = pd.to_datetime(df_yq['day_hk']).apply(lambda x: x.date())

    # =====考拉 T+1---包括这一天的逾期还款和正常还款
    # ======洋钱罐，四理财 T+2

    # ============提前还款==============
    df_tq = df_hk.ix[df_hk['deadline'] > df_hk['repaid_at']]
    # =================== TODO 本次修改的内容 begin
    df_tq = df_tq.groupby(by=['deadline'])['repay_principle_interest'].sum()
    df_tq = df_tq.to_frame()
    df_tq.reset_index(inplace=True)
    df_tq['deadline'] = pd.to_datetime(df_tq['deadline']).apply(lambda x: x.date())
    df_tq.rename(columns={'deadline': 'day_hk', 'repay_principle_interest': 'tq_prin_inst_total'}, inplace=True)

    # 合并
    df_hk_new = pd.merge(df_zc, df_yq, how='outer', on=['day_hk'])
    df_hk_new = pd.merge(df_hk_new, df_tq, how='outer', on=['day_hk'])
    df_hk_new = pd.merge(df_plan, df_hk_new, how='outer', on=['day_hk'])
    df_hk_new.fillna(0, inplace=True)
    df_hk_new['real_all'] = df_hk_new['zc_prin_inst_total'] + df_hk_new['tq_prin_inst_total'] + df_hk_new['yq_prin_inst_total']
    df_hk_new['fund_name'] = fund_name
    df_hk_new = df_hk_new.ix[df_hk_new.day_hk >= datetime.date(2017, 1, 1)]
    if fund_code == 300:
        # 晋商2 九月开始有提前结清
        df_hk_new = df_hk_new.ix[df_hk_new.day_hk < datetime.date(2017, 9, 1)]
    df_hk_new = df_hk_new[
        ['fund_name', 'day_hk', 'plan_principle_interest', 'real_all', 'zc_prin_inst_total',
         'tq_prin_inst_total', 'yq_prin_inst_total']]
    df_hk_new['peifu'] = df_hk_new['plan_principle_interest'] - df_hk_new['real_all']
    df_hk_new.rename(columns={'fund_name': '资金方', 'day_hk': '日期', 'plan_principle_interest': '应还资金方本息', 'real_all': '客户实还本息可用',
                              'zc_prin_inst_total': '客户正常还款本息', 'yq_prin_inst_total': '当天客户逾期还款本息',
                              'tq_prin_inst_total': '客户提前还款本息当天到期可用', 'peifu': '当日不可用累计本息'
                              },
                     inplace=True)
    df_hk_new.to_excel(path + str(fund_code) + '_bill.xlsx', index=None, columns=df_hk_new.columns, encoding='utf8')


# 200, 330, 290, 340, 390,420,380
# 科易小贷，2017年的还款需要加入应还在 28-31 的提前还款
# 应还本息+ 提前还款（28号之前）- 提前应还款
# fund_code 200, 330, 290, 340, 390,420,380
def divide_table(fund_code, fund_name):
    # -------应还---------
    df_plan = pd.read_sql(sql_fund_hk_user_plan % (fund_code, start_time, end_time,start_loan_paid_at,end_laon_paid_at), con=engine_new_transaction)
    df_plan.fillna(0, inplace=True)
    df_plan['day_hk'] = pd.to_datetime(df_plan['day_hk']).apply(lambda x: x.date())

    df_plan.ref_id = df_plan.ref_id.astype(int)
    df_plan = df_plan.ix[~df_plan.ref_id.isin(delete_ref_id_list)]
    df_plan = df_plan.groupby(by=['day_hk'])['plan_principle_interest'].sum()
    df_plan = df_plan.to_frame()
    df_plan.reset_index(inplace=True)
    # ===================资金方应还结束===========================

    # ==============实际还款======================
    res = []
    if fund_code == 340:
        hk_yg = pd.read_sql(sql=sql_yangguang_hk % (start_time, end_time,start_loan_paid_at,end_laon_paid_at), con=engine_new_transaction)
        res.append(hk_yg)
    else:
        df_online_hk = pd.read_sql(sql_hk_online % (fund_code, start_time, end_time, start_loan_paid_at, end_laon_paid_at), con=engine_new_transaction)
        df_alipay_hk = pd.read_sql(sql_hk_alipay % (fund_code, start_time, end_time, start_loan_paid_at, end_laon_paid_at), con=engine_new_transaction)
        res.append(df_online_hk)
        res.append(df_alipay_hk)
    df_hk = pd.concat(res)
    df_hk['repaid_at'] = pd.to_datetime(df_hk['repaid_at']).apply(lambda x: x.date())
    df_hk['deadline'] = pd.to_datetime(df_hk['deadline']).apply(lambda x: x.date())
    df_hk.fillna(0, inplace=True)
    df_hk.ref_id = df_hk.ref_id.astype(int)
    df_hk = df_hk.ix[~df_hk.ref_id.isin(delete_ref_id_list)]

    # =============正常还款=========
    df_zc = df_hk.ix[df_hk['repaid_at'] == df_hk['deadline']]
    df_zc = df_zc.groupby(by=['repaid_at'])['repay_principle_interest'].sum()
    df_zc = df_zc.to_frame()
    df_zc.reset_index(inplace=True)
    df_zc.rename(columns={'repaid_at': 'day_hk', 'repay_principle_interest': 'zc_prin_inst_total'}, inplace=True)
    df_zc['day_hk'] = pd.to_datetime(df_zc['day_hk']).apply(lambda x: x.date())
    # ===========逾期还款==============
    df_yq = df_hk.ix[df_hk['deadline'] < df_hk['repaid_at']]
    df_yq = df_yq.groupby(by=['repaid_at'])['repay_principle_interest'].sum()
    df_yq = df_yq.to_frame()
    df_yq.reset_index(inplace=True)
    df_yq.rename(columns={'repaid_at': 'day_hk', 'repay_principle_interest': 'yq_prin_inst_total'}, inplace=True)
    df_yq['day_hk'] = pd.to_datetime(df_yq['day_hk']).apply(lambda x: x.date())
    # ============提前还款==============
    df_tq = df_hk.ix[df_hk['deadline'] > df_hk['repaid_at']]
    # =================== TODO 本次修改的内容 begin
    # 将2月1号到期的提前还款放到1月31号
    df_tq.ix[(df_tq.deadline == datetime.date(2016, 2, 1)) & (
        df_tq.repaid_at <= datetime.date(2016, 1, 31)), 'deadline'] = datetime.date(2016, 1, 31)
    # 将5月1号到期的提前还款放到4月30号
    df_tq.ix[(df_tq.deadline == datetime.date(2016, 5, 1)) & (
        df_tq.repaid_at <= datetime.date(2016, 4, 30)), 'deadline'] = datetime.date(2016, 4, 30)
    # 将7月1号至5号到期的提前还款放到6月30号
    df_tq.ix[(df_tq.deadline >= datetime.date(2016, 7, 1)) & (df_tq.deadline <= datetime.date(2016, 7, 5)) & (
        df_tq.repaid_at <= datetime.date(2016, 6, 30)), 'deadline'] = datetime.date(2016, 6, 30)
    # 将10月1号至15号到期的提前还款放到9月30号
    df_tq.ix[(df_tq.deadline >= datetime.date(2016, 10, 1)) & (df_tq.deadline <= datetime.date(2016, 10, 15)) & (
        df_tq.repaid_at <= datetime.date(2016, 9, 30)), 'deadline'] = datetime.date(2016, 9, 30)
    # =================== TODO 本次修改的内容 end

    # 增加一列 提前应还款金额
    df_tq_1 = df_tq.groupby(by=['deadline'])['repay_principle_interest'].sum()
    df_tq_1 = df_tq_1.to_frame()
    df_tq_1.reset_index(inplace=True)
    df_tq_1.rename(columns={'deadline': 'day_hk', 'repay_principle_interest': 'plan_tq_prin_inst_total'}, inplace=True)
    df_tq_1['day_hk'] = pd.to_datetime(df_tq_1['day_hk']).apply(lambda x: x.date())
    # 科易小贷在2016.12.28 号之后的提前还款，放到 2017年第一个周二
    if fund_code == 200:
        df_tq.ix[(df_tq.repaid_at > datetime.date(2016, 12, 26)), 'repaid_at'] = datetime.date(2017, 1, 3)
    df_tq = df_tq.groupby(by=['repaid_at'])['repay_principle_interest'].sum()
    df_tq = df_tq.to_frame()
    df_tq.reset_index(inplace=True)
    df_tq.rename(columns={'repaid_at': 'day_hk', 'repay_principle_interest': 'tq_prin_inst_total'}, inplace=True)
    df_tq['day_hk'] = pd.to_datetime(df_tq['day_hk']).apply(lambda x: x.date())
    # 合并
    df_hk_new = pd.merge(df_zc, df_yq, how='outer', on=['day_hk'])
    df_hk_new = pd.merge(df_hk_new, df_tq, how='outer', on=['day_hk'])
    df_hk_new = pd.merge(df_plan, df_hk_new, how='outer', on=['day_hk'])
    df_hk_new = pd.merge(df_hk_new, df_tq_1, how='outer', on=['day_hk'])
    df_hk_new.fillna(0, inplace=True)
    df_hk_new['real_all'] = df_hk_new['zc_prin_inst_total'] + df_hk_new[
        'yq_prin_inst_total'] + df_hk_new['tq_prin_inst_total']
    df_hk_new['fund_name'] = fund_name
    df_hk_new = df_hk_new.ix[df_hk_new.day_hk >= datetime.date(2017, 1, 1)]
    df_hk_new = df_hk_new[
        ['fund_name', 'day_hk', 'plan_principle_interest', 'real_all', 'zc_prin_inst_total',
         'tq_prin_inst_total', 'yq_prin_inst_total', 'plan_tq_prin_inst_total']]
    df_hk_new['peifu'] = df_hk_new['plan_principle_interest'] - df_hk_new['real_all'] - df_hk_new['plan_tq_prin_inst_total'] + \
                         df_hk_new['tq_prin_inst_total']
    df_hk_new['fund_name'] = fund_name
    df_hk_new.rename(columns={'fund_name': '资金方', 'day_hk': '日期', 'plan_principle_interest': '应还资金方本息', 'real_all': '客户实还本息可用',
                              'zc_prin_inst_total': '客户正常还款本息', 'yq_prin_inst_total': '当天客户逾期还款本息',
                              'tq_prin_inst_total': '客户提前还款本息当天到期可用', 'peifu': '当日不可用累计本息',
                              'plan_tq_prin_inst_total': "提前应还"
                              },
                     inplace=True)
    df_hk_new.to_excel(path + str(fund_code) + '_bill.xlsx', index=None, columns=df_hk_new.columns, encoding='utf8')


# 华融，需要剔除 应还在 16年但还款时间在17年1-10号的数据
def hr_table(fund_code, fund_name):
    # -------应还---------
    df_plan = pd.read_sql(sql_fund_hk % (fund_code, start_time_deadline, end_time_deadline,start_loan_paid_at,end_laon_paid_at), con=engine_new_transaction)
    df_plan.fillna(0, inplace=True)
    df_plan['day_hk'] = pd.to_datetime(df_plan['day_hk']).apply(lambda x: x.date())
    df_plan.ref_id = df_plan.ref_id.astype(int)
    df_plan = df_plan.ix[~df_plan.ref_id.isin(delete_ref_id_list)]
    df_plan = df_plan.groupby(by=['day_hk'])['plan_principle_interest'].sum()
    df_plan = df_plan.to_frame()
    df_plan.reset_index(inplace=True)


    # ------实际还款-------
    df_online_hk = pd.read_sql(sql_hk_online % (fund_code, start_time, end_time,start_loan_paid_at,end_laon_paid_at),
                               con=engine_new_transaction)
    df_alipay_hk = pd.read_sql(sql_hk_alipay % (fund_code, start_time, end_time,start_loan_paid_at,end_laon_paid_at),
                               con=engine_new_transaction)
    df_bank_hk = pd.read_sql(sql_hk_bank % (fund_code, start_time, end_time, start_loan_paid_at, end_laon_paid_at), con=engine_new_transaction)

    df_hk = pd.concat([df_alipay_hk, df_online_hk,df_bank_hk], axis=0, ignore_index=True)
    df_hk['repaid_at'] = pd.to_datetime(df_hk['repaid_at']).apply(lambda x: x.date())
    df_hk['deadline'] = pd.to_datetime(df_hk['deadline']).apply(lambda x: x.date())
    df_hk['fund_code'] = df_hk['fund_code'].astype(int)
    df_hk['fund_name'] = fund_name
    df_hk.fillna(0, inplace=True)
    df_hk.ref_id = df_hk.ref_id.astype(int)
    df_hk = df_hk.ix[~df_hk.ref_id.isin(delete_ref_id_list)]

    # TODO ====逾期还款提前 2017.1-10 的数据 按照 deadline 进行统计即可
    df_hk.ix[(df_hk.deadline < datetime.date(2017, 1, 1)) & (df_hk.repaid_at >= datetime.date(2017, 1, 1)) & (
        df_hk.repaid_at < datetime.date(2017, 1, 11)), 'repaid_at'] = \
        df_hk.ix[(df_hk.deadline < datetime.date(2017, 1, 1)) & (df_hk.repaid_at >= datetime.date(2017, 1, 1)) & (
            df_hk.repaid_at < datetime.date(2017, 1, 11))].apply(lambda x: x['deadline'], axis=1)

    # =============正常还款=========
    df_zc = df_hk.ix[df_hk['repaid_at'] == df_hk['deadline']]
    df_zc = df_zc.groupby(by=['repaid_at'])['repay_principle_interest'].sum()
    df_zc = df_zc.to_frame()
    df_zc.reset_index(inplace=True)
    df_zc.rename(columns={'repaid_at': 'day_hk', 'repay_principle_interest': 'zc_prin_inst_total'}, inplace=True)
    df_zc['day_hk'] = pd.to_datetime(df_zc['day_hk']).apply(lambda x: x.date())
    # ===========逾期还款==============
    df_yq = df_hk.ix[df_hk['deadline'] < df_hk['repaid_at']]
    df_yq = df_yq.groupby(by=['repaid_at'])['repay_principle_interest'].sum()
    df_yq = df_yq.to_frame()
    df_yq.reset_index(inplace=True)
    df_yq.rename(columns={'repaid_at': 'day_hk', 'repay_principle_interest': 'yq_prin_inst_total'}, inplace=True)
    df_yq['day_hk'] = pd.to_datetime(df_yq['day_hk']).apply(lambda x: x.date())

    # ============提前还款==============
    df_tq = df_hk.ix[df_hk['deadline'] > df_hk['repaid_at']]
    # =================== TODO 本次修改的内容 begin
    # 将2月1号到期的提前还款放到1月31号
    df_tq.ix[(df_tq.deadline == datetime.date(2016, 2, 1)) & (
        df_tq.repaid_at <= datetime.date(2016, 1, 31)), 'deadline'] = datetime.date(2016, 1, 31)
    # 将5月1号到期的提前还款放到4月30号
    df_tq.ix[(df_tq.deadline == datetime.date(2016, 5, 1)) & (
        df_tq.repaid_at <= datetime.date(2016, 4, 30)), 'deadline'] = datetime.date(2016, 4, 30)
    # 将7月1号至5号到期的提前还款放到6月30号
    df_tq.ix[(df_tq.deadline >= datetime.date(2016, 7, 1)) & (df_tq.deadline <= datetime.date(2016, 7, 5)) & (
        df_tq.repaid_at <= datetime.date(2016, 6, 30)), 'deadline'] = datetime.date(2016, 6, 30)
    # 将10月1号至15号到期的提前还款放到9月30号
    df_tq.ix[(df_tq.deadline >= datetime.date(2016, 10, 1)) & (df_tq.deadline <= datetime.date(2016, 10, 15)) & (
        df_tq.repaid_at <= datetime.date(2016, 9, 30)), 'deadline'] = datetime.date(2016, 9, 30)
    # =================== TODO 本次修改的内容 end

    df_tq = df_tq.groupby(by=['deadline'])['repay_principle_interest'].sum()
    df_tq = df_tq.to_frame()
    df_tq.reset_index(inplace=True)
    df_tq['deadline'] = pd.to_datetime(df_tq['deadline']).apply(lambda x: x.date())
    df_tq.rename(columns={'deadline': 'day_hk', 'repay_principle_interest': 'tq_prin_inst_total'}, inplace=True)

    # 合并
    df_hk_new = pd.merge(df_zc, df_yq, how='outer', on=['day_hk'])
    df_hk_new = pd.merge(df_hk_new, df_tq, how='outer', on=['day_hk'])
    df_hk_new = pd.merge(df_plan, df_hk_new, how='outer', on=['day_hk'])
    df_hk_new.fillna(0, inplace=True)
    df_hk_new['real_all'] = df_hk_new['zc_prin_inst_total'] + df_hk_new['tq_prin_inst_total'] + df_hk_new[
        'yq_prin_inst_total']
    df_hk_new['fund_name'] = fund_name
    df_hk_new = df_hk_new.ix[(df_hk_new.day_hk >= datetime.date(2017, 5, 1)) & (df_hk_new.day_hk < datetime.date(2017, 5, 1))]
    df_hk_new = df_hk_new[
        ['fund_name', 'day_hk', 'plan_principle_interest', 'real_all', 'zc_prin_inst_total',
         'tq_prin_inst_total', 'yq_prin_inst_total']]
    df_hk_new['peifu'] = df_hk_new['plan_principle_interest'] - df_hk_new['real_all']
    df_hk_new.rename(columns={'fund_name': '资金方', 'day_hk': '日期', 'plan_principle_interest': '应还资金方本息', 'real_all': '客户实还本息可用',
                              'zc_prin_inst_total': '客户正常还款本息', 'yq_prin_inst_total': '当天客户逾期还款本息',
                              'tq_prin_inst_total': '客户提前还款本息当天到期可用', 'peifu': '当日不可用累计本息'
                              },
                     inplace=True)
    df_hk_new.to_excel(path + str(fund_code) + '_bill.xlsx', index=None, columns=df_hk_new.columns, encoding='utf8')


if __name__ == '__main__':
    df_delete_ref_id = pd.read_csv("./del_ref_id.csv")
    delete_ref_id_list = df_delete_ref_id.ref_id.astype(int).tolist()
    for index, row in df_fund.iterrows():
        fund_code = int(row['fund_code'])
        fund_name = row['fund_name']
        print '------begin---', fund_name
        if fund_code in (200, 330, 290, 340, 390,420,380,270, 310,320, 410,480):
            divide_table(fund_code, fund_name)
        elif fund_code == 150:
            hr_table(fund_code, fund_name)
        else:
            # 其他资金方
            other_table(fund_code, fund_name)
    print '=====================main done======================'

