# SQL  适用 2017.8月份之前的去哪儿业务

# 充值表
SELECT trans_time 存值时间,merchant_name 商户名称,trans_amount 存值金额,flow_id 流水号 from qunaer_new.bank_flow
where trans_type = 1

# 放款表-当月真实放款及期后退款----这个财务用于统计坏账，不清楚怎么统计，这么多情况，怎么筛选
# 注意，有转分期后退款，多笔订单转一个分期，谁知道退款退的哪笔订单
# 注意：8月份的退款，有一部分放到了还款账户中，这个sql 没有加限制；如果需要限制，则 refund_detail.flow_id 不为空的是 还款账户中的退款金额
# 注意：有先退款后转分期
# 注意：财务中说 放款对应的退款金额 指的是 退款本金
SET @start_time='2017-01-01',@end_time='2017-02-01';
SELECT t1.`product_no` 产品编号, if(t1.is_ptf = 0,'FALSE','TRUE') 是否转分期后订单号,t3.`fund_name` 资金方,t1.`trans_time` 订单时间,t1.`loan_time` 贷款时间,t1.`loan_amount` 合同放款金额,t2.refund_principle 放款对应的退款金额,t1.stages 分期数
FROM qunaer_new.`pay_detail` t1
LEFT JOIN (
SELECT fund_code,product_no,SUM(refund_principle) refund_principle FROM refund_detail
GROUP BY 1,2
) t2 ON t1.product_no = t2.product_no
JOIN fund_corp t3 ON t1.`fund_code` = t3.`fund_code`
WHERE t1.trans_time >= @start_time AND t1.trans_time < @end_time



#客户实还表-按客户实还时间来提取
# start_time 月初第一天；end_time 下个月第一天
# repayment_plan_2016_201701 放款16年的还款计划表--- 针对不同的还款时间，注意表名的改动
# repayment_plan_201701 放款17年的还款计划表--- 针对不同的还款时间，注意表名的改动
# 目前客户实还 没有实还利息，全是量化派贴息
SET @start_time='2017-01-01',@end_time='2017-02-01';
SELECT t1.repay_no 唯一编号,t1.product_no 产品编号,t3.fund_name 资金方,t2.stages 分期数,t1.current_stage_no 当期期数,t1.repay_time 实还时间,
  t1.repay_amount 实还总额,t1.repay_principle 实还本金,0 '实还利息-直投模式下',t1.repay_fee_amount 实还服务费,t1.repay_due_amount 实还罚息,
  t1.remain 其他收益,t1.flow_id 流水号,t5.principle 当期应还本金,0 '应还利息-直投模式下',t5.principle-t1.repay_principle '应还本息-实还本息'
FROM repay_detail t1
JOIN pay_detail t2 ON t1.product_no = t2.product_no
JOIN fund_corp t3 ON t2.fund_code=t3.fund_code
JOIN  repayment_plan_2016_201701 t5 ON t5.product_no = t1.product_no AND t5.current_stage_no = t1.current_stage_no
WHERE t1.repay_time >= @start_time AND t1.repay_time < @end_time
UNION  ALL
SELECT t1.repay_no 唯一编号,t1.product_no 产品编号,t3.fund_name 资金方,t2.stages 分期数,t1.current_stage_no 当期期数,t1.repay_time 实还时间,
  t1.repay_amount 实还总额,t1.repay_principle 实还本金,0 '实还利息-直投模式下',t1.repay_fee_amount 实还服务费,t1.repay_due_amount 实还罚息,
  t1.remain 其他收益,t1.flow_id 流水号,t5.principle 当期应还本金,IF(t2.fund_code = 1,0,t4.interest) '应还利息-直投模式下',
  IF(t2.fund_code=1,t5.principle-t1.repay_principle,t5.principle+t4.interest-t1.repay_principle) '应还本息-实还本息'
FROM repay_detail t1
JOIN pay_detail t2 ON t1.product_no = t2.product_no and t1.fund_code=t2.fund_code and t2.loan_amount > 0
JOIN fund_corp t3 ON t2.fund_code=t3.fund_code
JOIN repayment_plan_201701 t5 ON t5.product_no = t1.product_no AND t5.current_stage_no = t1.current_stage_no
LEFT JOIN fund_repayment_plan t4 ON t4.product_no = t1.product_no AND t4.current_stage_no = t1.current_stage_no
WHERE t1.repay_time >= @start_time AND t1.repay_time < @end_time


# 客户实还表-按放款对应的实还来提取
# 注意 按照放款时间，故17年的还款中有一些是16年的还款，这部分是剔除掉的
# 注意 处理重复的应还本金，如果有重复的，其中一个置为 0
SET @start_time='2017-01-01',@end_time='2017-02-01';
SELECT t1.repay_no 唯一编号,t1.product_no 产品编号,t3.fund_name 资金方,t2.stages 分期数,t1.current_stage_no 当期期数,t1.repay_time 实还时间,
  t1.repay_amount 实还总额,t1.repay_principle 实还本金,0 '实还利息-直投模式下',t1.repay_fee_amount 实还服务费,t1.repay_due_amount 实还罚息,
  t1.remain 其他收益,t1.flow_id 流水号,t6.trans_amount 银行金额,t5.principle 当期应还本金,IF(t2.fund_code = 1,0,t4.interest) '应还利息-直投模式下',
  IF(t2.fund_code=1,t5.principle-t1.repay_principle,t5.principle+t4.interest-t1.repay_principle) '应还本息-实还本息'
FROM repay_detail t1
JOIN pay_detail t2 ON t1.product_no = t2.product_no
JOIN fund_corp t3 ON t2.fund_code=t3.fund_code
JOIN repayment_plan_2017 t5 ON t5.product_no = t1.product_no AND t5.current_stage_no = t1.current_stage_no
LEFT JOIN fund_repayment_plan t4 ON t4.product_no = t1.product_no AND t4.current_stage_no = t1.current_stage_no
JOIN bank_flow t6 on t1.flow_id = t6.flow_id
WHERE t2.trans_time >= @start_time AND t2.trans_time < @end_time
AND t1.repay_time >= '2017-01-01'

# 客户实还表-按放款对应的实还来提取
# 注意 按照放款时间，故17年的还款中有一些是16年的还款
SET @start_time='2016-12-01',@end_time='2017-01-01';
SELECT t1.repay_no 唯一编号,t1.product_no 产品编号,t3.fund_name 资金方,t2.stages 分期数,t1.current_stage_no 当期期数,t1.repay_time 实还时间,
  t1.repay_amount 实还总额,t1.repay_principle 实还本金,0 '实还利息-直投模式下',t1.repay_fee_amount 实还服务费,t1.repay_due_amount 实还罚息,
  t1.remain 其他收益,t1.flow_id 流水号,t6.trans_amount 银行金额,t5.principle 当期应还本金,0 '应还利息-直投模式下',
  t5.principle-t1.repay_principle '应还本息-实还本息'
FROM repay_detail t1
JOIN pay_detail t2 ON t1.product_no = t2.product_no
JOIN fund_corp t3 ON t2.fund_code=t3.fund_code
JOIN repayment_plan_2016 t5 ON t5.product_no = t1.product_no AND t5.current_stage_no = t1.current_stage_no
JOIN bank_flow t6 on t1.flow_id = t6.flow_id
WHERE t2.trans_time >= @start_time AND t2.trans_time < @end_time
AND t1.repay_time >= '2017-01-01'



# ==================去哪儿坏账率计算   使用 实还金额/ 应还金额=======直接使用还款计划==================
# 应还金额
SELECT YEAR(t2.trans_time) 放款年,MONTH(t2.trans_time) 放款月,t2.stages 期数,SUM(principle) 应还金额 FROM `repayment_plan_2017` t1
JOIN `pay_detail` t2 ON t1.product_no = t2.product_no
WHERE t1.status IN (1,2)
GROUP BY 1,2,3

#实还金额
SELECT YEAR(t2.trans_time) 放款年,MONTH(t2.trans_time) 放款月,t2.stages 期数,SUM(repay_principle) 实还本金
FROM repay_detail t1
JOIN pay_detail t2 ON t1.product_no = t2.product_no
WHERE t2.trans_time >= '2017-01-01'
GROUP BY 1,2,3

#针对上面的 明细
SELECT YEAR(t2.trans_time) 放款年,MONTH(t2.trans_time) 放款月,t1.product_no 产品编号,t2.stages 期数,repay_principle 实还本金,DATE(t1.repay_time) 还款时间,current_stage_no 当期期数
FROM repay_detail t1
JOIN pay_detail t2 ON t1.product_no = t2.product_no
WHERE t2.trans_time >= '2017-01-01'

# 针对上面的 明细
SELECT YEAR(t2.trans_time) 放款年,MONTH(t2.trans_time) 放款月,t1.product_no 产品编号,t2.stages 期数,principle 应还本金,deadline 应还款日,current_stage_no 当前期数,
IF(t1.status = 3,'TRUE','FALSE') 是否发生了转分期
FROM `repayment_plan_2017` t1
JOIN `pay_detail` t2 ON t1.product_no = t2.product_no

# 转分期关系
select trans_no 转分期后订单,product_no 转分期前订单
from qunaer_new.trans_ref

#================坏账率 done=====================================
