# -*- encoding: utf8 -*-
import multiprocessing as mtp
from itertools import product

import pandas as pd
from sqlalchemy import create_engine

engine_audit = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/baitiao_audit?charset=utf8', echo=True)
# engine_audit = create_engine('mysql+mysqldb://zhushiyao_r:cWEdtgeBEYz8UXfV@192.168.4.250:3306/analysis_tmp?charset=utf8',echo=True)

"""
白条放款表（需要确保涉及到关联的字段完整，比如user_biz_id, funding_corp_id, merchantId，还需要注意筛选条件is_active等）
然后通过程序读取还款计划，把还款计划从列向转成行项---
注意：还款计划的required_repayment有为0的情况，需要补充完整，或者用principle + interest
列名根据实际需要增加或修改
还款计划sql查询太慢了，需要优化，不用join联合查询，分开查询，然后用merge组合
"""


# sql_order = """select bo.ref_id,bo.is_active 是否成功订单, bo.funding_corp_id, bo.merchantId merchant_id, bo.order_no 产品编号,
# date(bo.loan_paid_at) 放款日期, month(bo.loan_paid_at) 放款月份, bo.contract_loan_amount 本金债权, bo.real_loan_amount 放款金额, bo.contract_term 总期数
#  from baitiao_audit.baitiao_order bo
#  where bo.loan_paid_at >= '%s-%02d-01 00:00:00' and bo.loan_paid_at < '%s-%02d-01 00:00:00'
#  and bo.is_active in (1,-2);"""

sql_order = """select bo.ref_id,bo.is_active 是否成功订单, bo.funding_corp_id, bo.merchantId merchant_id, bo.order_no 产品编号,
date(bo.loan_paid_at) 放款日期, month(bo.loan_paid_at) 放款月份, bo.contract_loan_amount 本金债权, bo.real_loan_amount 放款金额, bo.contract_term 总期数
 from baitiao_audit.baitiao_order bo
 where bo.loan_paid_at >= '%s-%02d-01 00:00:00' and bo.loan_paid_at < '%s-%02d-01 00:00:00'
 and bo.is_active =1 UNION ALL
 select bo.ref_id,bo.is_active 是否成功订单, bo.funding_corp_id, bo.merchantId merchant_id, bo.order_no 产品编号,
date(bo.loan_paid_at) 放款日期, month(bo.loan_paid_at) 放款月份, bo.contract_loan_amount 本金债权, bo.real_loan_amount 放款金额, bo.contract_term 总期数
 from baitiao_audit.baitiao_order bo
 where bo.train_cancel_at >= '%s-%02d-01 00:00:00' and bo.train_cancel_at < '%s-%02d-01 00:00:00'
 and bo.is_active =-2
 ;"""
sql_plan = """select rp.ref_id,rp.order_no, rp.term_no, rp.required_repayment, date(rp.deadline) deadline from new_transaction.user_bt_repayment_plan rp
 where  rp.ref_id in %s;"""

# term_cnt是为了检验订单期数和还款计划条数是否一致
columns = ['产品编号', 'term_cnt']

# path_huizong = u'E:/数据汇总/白条/汇总/'
# path_detail = u'E:/数据汇总/白条/放款明细/'
path_huizong = 'D:/白条放款/白条/汇总/'
path_detail = 'D:/白条放款/白条/放款明细/'

for i in range(1, 13):
    columns.append('第%s期应还款额' % i)
    columns.append('应还款日-第%s期' % i)
    # columns.append('term_%s_repay' % i)
    # columns.append('term_%s_deadline' % i)


def process_plan(df):
    if len(df) > 0:
        gps = df.groupby('ref_id')
        plan_list = []
        for ref_id, gp in gps:
            try:
                cnt = len(gp)
                tmp = pd.DataFrame(index=[0], columns=columns)
                tmp['ref_id'] = ref_id
                tmp['term_cnt'] = cnt
                for i in range(cnt):
                    tmp.loc[0, '第%s期应还款额' % (i + 1)] = gp.ix[gp.term_no == (i + 1), 'required_repayment'].values[0]
                    tmp.loc[0, '应还款日-第%s期' % (i + 1)] = gp.ix[gp.term_no == (i + 1), 'deadline'].values[0]
                plan_list.append(tmp)
            except Exception as e:
                print('order_no=%s,cnt=%s' % (ref_id, cnt))
                raise e(ref_id,cnt)
        result = pd.concat(plan_list, ignore_index=True)
        return result
    return None

def process_plan_v1(df):
    if len(df) > 0:
        df['term_no'] = df['term_no'].astype(str)
        df['deadline_col'] = '应还款日-第' + df['term_no'] + '期'
        df['req_repay_col'] = '第' + df['term_no'] + '期应还款额'
        result_deadline = df.pivot('ref_id', 'deadline_col', 'deadline')
        result_req_repay = df.pivot('ref_id', 'req_repay_col', 'required_repayment')
        res_cnt = df.pivot_table(index='ref_id', values='term_no', aggfunc=len).reset_index().rename(columns={'term_no': 'term_cnt'})
        result = pd.merge(result_deadline, result_req_repay, left_index=True, right_index=True).reset_index()
        result = result.merge(res_cnt)
        return result
    return None

def baitiao_order_summary():
    """
    白条放款表汇总
    :return:
    """
    # sql_order = """select is_active 是否成功订单, year(loan_paid_at) 年, month(loan_paid_at) 月, funding_corp_id, merchantId merchant_id,contract_term 期数, sum(real_loan_amount) 放款金额, sum(contract_loan_amount) 本金债权
    #  from baitiao_audit.baitiao_order where is_active=1 group by 1,2,3,4,5,6;"""
    sql_order = """select is_active 是否成功订单, year(loan_paid_at) 年, month(loan_paid_at) 月, funding_corp_id, merchantId merchant_id,contract_term 期数,baitiao_type 支付类型 , sum(real_loan_amount) 放款金额, sum(contract_loan_amount) 本金债权
        from baitiao_order where is_active =1 AND loan_paid_at>='2017-01-01' AND loan_paid_at<'2017-08-01' group by 1,2,3,4,5,6,7
UNION ALL
select is_active 是否成功订单, year(train_cancel_at) 年, month(train_cancel_at) 月, funding_corp_id, merchantId merchant_id,contract_term 期数,baitiao_type 支付类型, sum(real_loan_amount) 放款金额, sum(contract_loan_amount) 本金债权
        from baitiao_order where is_active =-2 AND loan_paid_at>='2017-01-01' AND loan_paid_at<'2017-08-01' group by 1,2,3,4,5,6,7;"""

    df = pd.read_sql(sql=sql_order, con=engine_audit)
    df.funding_corp_id = df.funding_corp_id.astype(int)
    df.merchant_id = df.merchant_id.astype(int)
    df = df.merge(df_fund).merge(df_merchant)
    df['是否成功订单'] = df['是否成功订单'].map({0: '失败', 1: '成功',-2:"退"})
    df['支付类型'] = df['支付类型'].map({0: '白条支付', 1: '现金支付'})
    df.drop(['funding_corp_id', 'merchant_id'], axis=1, inplace=True)
    df.to_excel(path_huizong+'白条放款汇总表2017[01-07]0811.xlsx', index=None, columns=['是否成功订单','支付类型', '年', '月', '资金方', '白条商家','期数','放款金额', '本金债权'])


def baitiao_order_detail(year, month, step):
    """
    白条放款表-明细
    :param year:
    :param month:
    :param step:
    :return:
    """
    print('--------------------%s-%s to %s-%s------------------' % (
    year, month + 1, year + (month + 1) / 12, (month + 1) % 12 + 1))

    df_order = pd.read_sql(sql=sql_order % (year, month + 1, year + (month + 1) / 12, (month + 1) % 12 + 1,year, month + 1, year + (month + 1) / 12, (month + 1) % 12 + 1),
                           con=engine_audit)
    if len(df_order) > 0:
        df_order.funding_corp_id = df_order.funding_corp_id.astype(int)
        df_order.merchant_id = df_order.merchant_id.astype(int)
        df_order = df_order.merge(df_fund).merge(df_merchant)
        df_order['是否成功订单'] = df_order['是否成功订单'].map({0: '失败', 1: '成功',2:'退'})
        df_order['支付类型'] = df_order['支付类型'].map({0: '白条支付', 1: '现金支付'})
        df_order.drop(['funding_corp_id', 'merchant_id'], axis=1, inplace=True)
        df_order['产品编号'] = df_order['产品编号'].astype(str)
        ref_ids = df_order['ref_id'].astype(str).tolist()
        result = []
        for i in range(0, len(ref_ids), step):
            df_plan = pd.read_sql(sql=sql_plan % str(tuple(ref_ids[i: i + step])), con=engine_audit)
            result.append(process_plan_v1(df_plan))
        df_plan = pd.concat(result, ignore_index=True)
        df_plan['ref_id']=df_plan['ref_id'].astype(int)
        df_order['ref_id']=df_order['ref_id'].astype(int)
        df_order = df_order.merge(df_plan, on='ref_id', how='left')
        # 检验是否有丢失还款计划的，以及还款计划条数和总期数不一致，需要找出来处理一下
        df_miss = df_order.ix[df_order.term_cnt.isnull()]
        df_not_same = df_order.ix[df_order['term_cnt'] != df_order['总期数']]
        if len(df_miss) > 0:
            df_miss.to_excel(path_detail+'还款计划缺失（%s-%s）.xlsx' % (year, month + 1), index=None)
        if len(df_not_same) > 0:
            df_not_same.to_excel(path_detail+'期数不一致（%s-%s）.xlsx' % (year, month + 1), index=None)
        df_order.drop(['term_cnt'], axis=1, inplace=True)
        all_columns = ['是否成功订单','支付类型', '资金方', '白条商家', '产品编号', '放款日期', '放款月份', '放款金额', '本金债权', '总期数']
        all_columns.extend([col_name for col_name in columns[2:] if col_name in df_order.columns])
        df_order = df_order[all_columns]
        df_order.to_excel(path_detail+'白条放款表（%s-%s）_.xlsx' % (year, month + 1), index=None)


if __name__ == '__main__':

    sql_fund = """select id funding_corp_id, fund_name 资金方 from baitiao_audit.fund_corp"""
    # sql_fund = """select funding_code funding_corp_id, `name` 资金方 from audit.funding_corp"""
    df_fund = pd.read_sql(sql=sql_fund, con=engine_audit)
    df_fund.funding_corp_id = df_fund.funding_corp_id.astype(int)
    sql_merchant = """select merchant_id, merchant_name 白条商家 from baitiao_audit.merchant"""
    # sql_merchant = """select merchant_id, merchant_name 白条商家 from nk_baitiao_merchant"""
    df_merchant = pd.read_sql(sql=sql_merchant, con=engine_audit)
    df_merchant.merchant_id = df_merchant.merchant_id.astype(int)

    # 白条放款表汇总
    baitiao_order_summary()
    # 白条明细表，按月分割
    # step = 5000
    #
    # years = [2016]
    # months = range(0,12)
    # for year, month in product(years, months):
    #     baitiao_order_detail(year, month, step)
    print('-----------------done-----------------')
