# -*- encoding: utf8 -*-

"""
目标：
    现金贷还款表按还款月统计汇总
数据库：
    根据不同时段的需求，选取不同阶段的备份数据库
字段名：
    资金方，loan_id，放款期数，实还当期期数，应还款日，应还款金额，应还本金，应还利息，应还服务费，应还罚息（资金方），实还款日，收款账户，
    收款渠道流水号，实还金额，实还本金，实还利息，实还服务费，实还罚息，其他收益，减免金额，减免本金，减免利息，减免服务费，减免罚息，实还趸收服务费
注意：
    新造的表test_mzh.xjd_repay_plan_repay_record_ref_repay_date_flow包含还款时间和流水号
"""

import os

import datetime
import pandas as pd
import numpy as np
from db_con.db_connect import sql_engine
import multiprocessing as mtp

# ----------------------------------------------
pd.options.mode.chained_assignment = None
step = 10000
max_limit = 900000
file_path = u'E:/审计出表/现金贷'
file_name = u'现金贷还款表-明细表'
if not os.path.exists(file_path):
    os.makedirs(file_path)
mysql = sql_engine('audit', 'temp', False).get_engine()
sql_repay = """
SELECT
  fc.name                           资金方,
  urp.real_loan_id                  loan_id,
  lm.contract_term                  放款期数,
  urp.term_no                       实还当期期数,
  date(urp.deadline)                应还款日,
  urp.required_repayment            应还款金额,
  urp.principle                     应还本金,
  urp.interest                      应还利息,
  urp.service_fee                   应还服务费,
  urp.should_punish                 `应还罚息（资金方）`,
  date(xrprrrrdf.repaid_at)         实还款日,
  rc.approach_name                  收款账户,
  xrprrrrdf.repay_channel_flow_id   收款渠道流水号,
  xrprrr.ref_amount                 实还金额,
  xrprrr.principle                  实还本金,
  xrprrr.interest                   实还利息,
  xrprrr.service_fee                实还服务费,
  xrprrr.punish                     实还罚息,
  xrprrr.remain_income              其他收益,
  xrprrr.collection_relief          减免金额,
  xrprrr.mitigate_principle         减免本金,
  xrprrr.mitigate_interest          减免利息,
  xrprrr.mitigate_service_fee       减免服务费,
  xrprrr.mitigate_collection_relief 减免罚息,
  urp.ref_id
FROM new_transaction.xjd_repay_plan_repay_record_ref xrprrr
  JOIN test_mzh.xjd_repay_plan_repay_record_ref_repay_date_flow xrprrrrdf
    ON xrprrr.id = xrprrrrdf.xjd_ref_id AND xrprrrrdf.repaid_at >= '%s' AND xrprrrrdf.repaid_at < '%s'
  JOIN new_transaction.user_repayment_plan urp ON urp.id = xrprrr.plan_id
  JOIN audit.loan_manifest lm ON lm.ref_id = urp.ref_id
  JOIN audit.funding_corp fc ON fc.funding_code = urp.fund_code
  JOIN new_transaction.repay_channel rc ON rc.id = xrprrr.repay_channel;
"""
sql_dunshou = """
SELECT
  xdp.ref_id,
  xdpr.ref_amount 实还趸收服务费
FROM
  new_transaction.xjd_dunjiao_plan_ref xdpr
  JOIN new_transaction.xjd_dunjiao_plan xdp
    ON xdpr.plan_id = xdp.id
  JOIN new_transaction.repay_record_online rro
    ON xdpr.record_id = rro.id AND rro.bill_time >= '%s' AND rro.bill_time < '%s'
"""
# ----------------------------------------------

def process_loan(start, end):
    df = pd.read_sql(sql=sql_repay % (start, end), con=mysql, chunksize=step)
    df_repay = pd.DataFrame()
    for tmp in df:
        df_repay = df_repay.append(tmp)
    if len(df_repay) > 0:
        df_dunshou = pd.read_sql(sql=sql_dunshou % (start, end), con=mysql)
        if len(df_dunshou) > 0:
            df_repay = df_repay.merge(df_dunshou, on='ref_id', how='left')
            df_repay.loc[df_repay.ref_id.duplicated(), u'实还趸收服务费'] = np.NaN
            # todo: 虑重
        df_repay.drop('ref_id', axis=1, inplace=True)
        if len(df_repay) > max_limit:
            excel_file = pd.ExcelWriter(
                os.path.join(file_path, '%s(%d-%02d).xlsx' % (file_name, start.year, start.month)))
            for i in xrange(0, len(df_repay), max_limit):
                df_repay[i:i + max_limit].to_csv(os.path.join(file_path, '%s(%d-%02d)-%d.csv' % (
                    file_name, start.year, start.month, i / max_limit + 1)), index=None, encoding='utf8')
                df_repay[i:i + max_limit].to_excel(excel_file, str(i / max_limit + 1), index=None)
        else:
            df_repay.to_csv(os.path.join(file_path, '%s(%d-%02d).csv' % (
                file_name, start.year, start.month)), index=None, encoding='utf8')
            df_repay.to_excel(os.path.join(file_path, '%s(%d-%02d).xlsx' % (file_name, start.year, start.month)),
                                  index=None)
        print(start)
        df_repay.fillna(0)
        print(df_repay[[u'实还金额', u'实还趸收服务费']].sum())


if __name__ == '__main__':
    date_range = pd.date_range(start='2017-05', end='2017-08', freq='MS')
    # start = date_range[4]
    # end = date_range[5]
    # process_loan(start=start, end=end)
    pool = mtp.Pool(processes=6)
    for i in range(0, len(date_range) - 1):
        start = date_range[i]
        end = date_range[i + 1]
        pool.apply_async(process_loan, (start, end))
    pool.close()
    pool.join()
    print('--------------------all done---------------------')
