# 统计已还本金
# 明细
SELECT
  t1.principle - t1.mitigate_principle                                   real_principle,
  t4.real_loan_amount,
  t4.contract_term,
  t4.loan_paid_at,
  t4.merchantId,
  t4.funding_corp_id,
  t3.ref_id,
  t3.order_no,
  t2.bill_time                                                           repaid_at,
  concat(DATE(t2.bill_time), '还款', t1.principle - t1.mitigate_principle) remark
FROM baitiao_repay_plan_repay_record_ref t1
  JOIN repay_record_online t2 ON t1.record_id = t2.id AND t1.repay_channel < 13
  JOIN user_bt_repayment_plan t3 ON t1.plan_id = t3.id
  JOIN baitiao_audit.baitiao_order t4 ON t3.ref_id = t4.ref_id AND t4.is_active = 1
WHERE t4.loan_paid_at >= '%s' AND t4.loan_paid_at < '%s' AND t2.bill_time >= '%s' AND t2.bill_time < '%s';

SELECT
  t1.principle - t1.mitigate_principle                                       real_principle,
  t4.real_loan_amount,
  t4.contract_term,
  t4.loan_paid_at,
  t4.merchantId,
  t4.funding_corp_id,
  t3.ref_id,
  t3.order_no,
  t2.transfer_time                                                           repaid_at,
  concat(DATE(t2.transfer_time), '还款', t1.principle - t1.mitigate_principle) remark
FROM baitiao_repay_plan_repay_record_ref t1
  JOIN offline_alipay_record t2 ON t1.record_id = t2.id AND t1.repay_channel = 13
  JOIN user_bt_repayment_plan t3 ON t1.plan_id = t3.id
  JOIN baitiao_audit.baitiao_order t4 ON t3.ref_id = t4.ref_id AND t4.is_active = 1
WHERE t4.loan_paid_at >= '%s' AND t4.loan_paid_at < '%s' AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s';

SELECT
  t1.principle - t1.mitigate_principle                                       real_principle,
  t4.real_loan_amount,
  t4.contract_term,
  t4.loan_paid_at,
  t4.merchantId,
  t4.funding_corp_id,
  t3.ref_id,
  t3.order_no,
  t2.transfer_time                                                           repaid_at,
  concat(DATE(t2.transfer_time), '还款', t1.principle - t1.mitigate_principle) remark
FROM baitiao_repay_plan_repay_record_ref t1
  JOIN offline_bank_repay_record t2 ON t1.record_id = t2.id AND t1.repay_channel IN (14, 15, 16)
  JOIN user_bt_repayment_plan t3 ON t1.plan_id = t3.id
  JOIN baitiao_audit.baitiao_order t4 ON t3.ref_id = t4.ref_id AND t4.is_active = 1
WHERE t4.loan_paid_at >= '%s' AND t4.loan_paid_at < '%s' AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s';


# 统计未还本金
# 明细
SELECT
  t2.ref_id,
  SUM(t1.principle - t1.mitigate_principle) real_principle
FROM `baitiao_repay_plan_repay_record_ref` t1
  JOIN `offline_alipay_record` t3 ON t1.`record_id` = t3.id AND t1.`repay_channel` = 13
  JOIN `user_bt_repayment_plan` t2 ON t1.plan_id = t2.id
  JOIN baitiao_audit.`baitiao_order` t4 ON t2.ref_id = t4.ref_id AND t4.`is_active` = 1
WHERE t3.transfer_time >= '%s' AND t3.transfer_time < '%s'
GROUP BY t2.ref_id;

SELECT
  t2.ref_id,
  SUM(t1.principle - t1.mitigate_principle) real_principle
FROM `baitiao_repay_plan_repay_record_ref` t1
  JOIN `repay_record_online` t3 ON t1.`record_id` = t3.id AND t1.`repay_channel` < 13
  JOIN `user_bt_repayment_plan` t2 ON t1.plan_id = t2.id
  JOIN baitiao_audit.`baitiao_order` t4 ON t2.ref_id = t4.ref_id AND t4.`is_active` = 1
WHERE t3.bill_time >= '%s' AND t3.bill_time < '%s'
GROUP BY t2.ref_id;

SELECT
  t2.ref_id,
  SUM(t1.principle - t1.mitigate_principle) real_principle
FROM `baitiao_repay_plan_repay_record_ref` t1
  JOIN `offline_bank_repay_record` t3 ON t1.`record_id` = t3.id AND t1.`repay_channel` IN (14, 15, 16)
  JOIN `user_bt_repayment_plan` t2 ON t1.plan_id = t2.id
  JOIN baitiao_audit.`baitiao_order` t4 ON t2.ref_id = t4.ref_id AND t4.`is_active` = 1
WHERE t3.transfer_time >= '%s' AND t3.transfer_time < '%s'
GROUP BY t2.ref_id;

