# coding: utf-8
import sys

stdout = sys.stdout
# 加入父级搜索路径，根据情况修改
import pandas as pd
import numpy as np
import os
from sqlalchemy import create_engine

sys.stdout = stdout
# 引入数据库连接，并使修改生效
pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)
mysql_engine = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/all_back_0831?charset=utf8',
                             echo=True)
# 输出文件路径
file_path = u'E:/数据汇总/白条/人工控制还款/'
start_time = '2017-08-01'
end_time = '2017-09-01'

sql = """
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0.0                                               实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(ubrp.deadline)                               应还日期,
  ubrp.principle                                    应还本金,
  0.0                                               应还利息
FROM baitiao_repay_plan_repay_record_ref brprrr
JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel AND rr.repaid_at >= '%s' AND rr.repaid_at < '%s'
JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = ubrp.ref_id   and bo.is_active in(1,-2)
JOIN merchant m ON m.merchant_id = bo.merchantId
JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id and bo.funding_corp_id=1
JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
   
UNION ALL
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0.0                                               实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(bfrp.deadline)                               应还日期,
  bfrp.principal                                    应还本金,
  bfrp.interest                                     应还利息
FROM baitiao_repay_plan_repay_record_ref brprrr
JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel AND rr.repaid_at >= '%s' AND rr.repaid_at < '%s'
JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
join bt_funding_repayment_plan bfrp on ubrp.repayment_plan_id =bfrp.repay_plan_id and ubrp.sys_tag='XYQB_BILL_BT'
JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = ubrp.ref_id and bo.funding_corp_id=5   and bo.is_active in(1,-2)
JOIN merchant m ON m.merchant_id = bo.merchantId
JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
"""

sql_cash_repay = """
SELECT
  bo.order_no 唯一编号,
  m.merchant_name           商户名称,
  bo.order_no               产品编号,
  fc.fund_name              资金方,
  bo.contract_term          放款期数,
  1                         当前期数,
  date(rra.repaid_at)       实还时间,
  bcrr.ref_amount           还款总额,
  bcrr.ref_amount           实还本金,
  0                         实还利息,
  0                         实还服务费,
  0                         实还罚息,
  0                         其他收益,
  rra.repay_channel_flow_id 流水号,
  rc.approach_name          还款账户,
  rra.amount                账单金额,
  ''                        应还日期,
  bo.real_loan_amount       应还本金,
  0.0                       应还利息
FROM new_transaction.baitiao_cash_repay bcr
  JOIN (select repay_id,record_id,repay_channel,sum(ref_amount)ref_amount from new_transaction.baitiao_cash_record_ref group by 1,2) bcrr ON bcrr.repay_id = bcr.id
  JOIN test_mzh.repay_record_amount rra ON rra.record_id = bcrr.record_id and rra.amount=bcrr.ref_amount AND  bcrr.repay_channel in(18,24) AND rra.repaid_at >= '%s' AND rra.repaid_at < '%s'
  JOIN baitiao_order bo ON bo.ref_id = bcr.ref_id  and bo.is_active in(1,-2)
  JOIN merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = bcrr.repay_channel;
"""


# 白条还款按实还时间提取
def repay_repaied():
    df_gen = pd.read_sql(sql=sql % (start_time, end_time, start_time, end_time), con=mysql_engine, chunksize=10000)
    res = []
    for tmp in df_gen:
        res.append(tmp)
    df = pd.concat(res)
    df_cash_repay = pd.read_sql(sql=sql_cash_repay % (start_time, end_time), con=mysql_engine)
    date_range = pd.date_range(start=start_time, end=end_time, freq='MS')
    cnt = 0
    for i in xrange(0, len(date_range) - 1):
        tmp = df.loc[(df[u'实还时间'] >= date_range[i].date()) & (df[u'实还时间'] < date_range[i + 1].date())]
        cnt += len(tmp)
        cash_tmp = df_cash_repay.loc[
            (df_cash_repay[u'实还时间'] >= date_range[i].date()) & (df_cash_repay[u'实还时间'] < date_range[i + 1].date())]
        if len(cash_tmp) > 0:
            tmp = tmp.append(cash_tmp)
        print date_range[i].year, date_range[i].month, len(tmp), tmp[u'还款总额'].sum()
        tmp.loc[tmp[u'唯一编号'].duplicated(), [u'应还本金', u'应还利息']] = 0
        tmp.loc[tmp[[u'流水号', u'还款账户']].duplicated(), [u'账单金额']] = 0
        tmp[u'应还本息-实还本息'] = np.round(tmp[u'应还本金'] - tmp[u'实还本金'] + tmp[u'应还利息'] - tmp[u'实还利息'], 2)
        tmp[u'还款总额-账单金额'] = np.round(tmp[u'还款总额'] - tmp[u'账单金额'], 2)
        tmp.to_csv(os.path.join(file_path, '客户实还表（实还时间%s-%02d,包含现金支付）.csv' % (date_range[i].year, date_range[i].month)),
                   index=None, encoding='utf8')
    print cnt, len(df)



sql_loan_repay = """
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0.0                                               实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(ubrp.deadline)                               应还日期,
  ubrp.principle                                    应还本金,
  0.0                                               应还利息,
  date(bo.loan_paid_at)                             放款日期
FROM baitiao_repay_plan_repay_record_ref brprrr
  JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel
  JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
  JOIN baitiao_order bo ON bo.ref_id = ubrp.ref_id AND bo.is_active=1 and bo.funding_corp_id=1 AND bo.loan_paid_at >= '%s' AND bo.loan_paid_at < '%s'
  JOIN merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
  
union all

SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0.0                                               实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(bfrp.deadline)                               应还日期,
  bfrp.principal                                    应还本金,
  bfrp.interest                                     应还利息,
  date(bo.loan_paid_at)                             放款日期
FROM baitiao_repay_plan_repay_record_ref brprrr
  JOIN test_mzh.repay_record_amount rr
    ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel
  JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
  join bt_funding_repayment_plan bfrp on ubrp.repayment_plan_id =bfrp.repay_plan_id and ubrp.sys_tag='XYQB_BILL_BT'
  JOIN baitiao_order bo ON bo.ref_id = ubrp.ref_id AND bo.is_active=1 and bo.funding_corp_id=5 AND bo.loan_paid_at >= '%s' AND bo.loan_paid_at < '%s'
  JOIN merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel

union all
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0                                                 实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(ubrp.deadline)                               应还日期,
  ubrp.principle                                    应还本金,
  0                                                 应还利息,
  date(bo.train_cancel_at)                          放款日期
FROM baitiao_repay_plan_repay_record_ref brprrr
  JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id  AND rr.repay_channel = brprrr.repay_channel
  JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
  JOIN baitiao_order bo ON bo.ref_id = ubrp.ref_id AND bo.is_active = -2 and bo.funding_corp_id=1 AND bo.train_cancel_at >= '%s' AND bo.train_cancel_at < '%s'
  JOIN merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
  
union all
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0                                                 实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(bfrp.deadline)                               应还日期,
  bfrp.principal                                    应还本金,
  bfrp.interest                                     应还利息,
  date(bo.train_cancel_at)                          放款日期
FROM baitiao_repay_plan_repay_record_ref brprrr
  JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel
  JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
  join bt_funding_repayment_plan bfrp on ubrp.repayment_plan_id =bfrp.repay_plan_id and ubrp.sys_tag='XYQB_BILL_BT'
  JOIN baitiao_audit.baitiao_order bo  ON bo.ref_id = ubrp.ref_id AND bo.is_active = -2 AND bo.funding_corp_id=5 AND bo.train_cancel_at >= '%s' AND bo.train_cancel_at < '%s'
  JOIN merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel;
"""

sql_cash_loan_repay = """
SELECT
  bo.order_no 唯一编号,
  m.merchant_name           商户名称,
  bo.order_no               产品编号,
  fc.fund_name              资金方,
  bo.contract_term          放款期数,
  1                         当前期数,
  date(rra.repaid_at)       实还时间,
  bcrr.ref_amount           还款总额,
  bcrr.ref_amount           实还本金,
  0                         实还利息,
  0                         实还服务费,
  0                         实还罚息,
  0                         其他收益,
  rra.repay_channel_flow_id 流水号,
  rc.approach_name          还款账户,
  rra.amount                账单金额,
  ''                        应还日期,
  bo.real_loan_amount       应还本金,
  0                         应还利息,
  date(bo.train_cancel_at)  放款日期
FROM baitiao_cash_record_ref bcrr
  JOIN baitiao_cash_repay bcr ON bcrr.repay_id = bcr.id
  JOIN test_mzh.repay_record_amount rra ON rra.record_id = bcrr.record_id  and brprrr.repay_channel in(18,24) -- AND rra.repay_channel = bcrr.repay_channel
  JOIN baitiao_order bo ON bo.ref_id = bcr.ref_id AND bo.is_active = -2 AND bo.train_cancel_at >= '%s' AND bo.train_cancel_at < '%s'
  JOIN merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = bcrr.repay_channel
UNION ALL
SELECT
  bo.order_no               唯一编号,
  m.merchant_name           商户名称,
  bo.order_no               产品编号,
  fc.fund_name              资金方,
  bo.contract_term          放款期数,
  1                         当前期数,
  date(rra.repaid_at)       实还时间,
  bcrr.ref_amount           还款总额,
  bcrr.ref_amount           实还本金,
  0                         实还利息,
  0                         实还服务费,
  0                         实还罚息,
  0                         其他收益,
  rra.repay_channel_flow_id 流水号,
  rc.approach_name          还款账户,
  rra.amount                账单金额,
  ''                        应还日期,
  bo.real_loan_amount       应还本金,
  0                         应还利息,
  date(bo.loan_paid_at)     放款日期
FROM baitiao_cash_record_ref bcrr
  JOIN baitiao_cash_repay bcr ON bcrr.repay_id = bcr.id
  JOIN test_mzh.repay_record_amount rra ON rra.record_id = bcrr.record_id and rra.amount=bcrr.ref_amount AND bcrr.repay_channel in(18,24)  -- AND rra.repay_channel = bcrr.repay_channel
  JOIN baitiao_order bo ON bo.ref_id = bcr.ref_id AND bo.is_active <> -2 AND bo.loan_paid_at >= '%s' AND bo.loan_paid_at < '%s'
  JOIN merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = bcrr.repay_channel;
"""


# 白条还款按放款时间提取
def repay_loan_time():
    df_gen = pd.read_sql(
        sql=sql_loan_repay % (start_time, end_time, start_time, end_time, start_time, end_time, start_time, end_time),
        con=mysql_engine, chunksize=10000)
    res = []
    for tmp in df_gen:
        res.append(tmp)
    df_loan_repay = pd.concat(res)
    df_cash_loan_repay = pd.read_sql(sql=sql_cash_loan_repay % (start_time, end_time, start_time, end_time),
                                     con=mysql_engine)
    date_range = pd.date_range(start=start_time, end=end_time, freq='MS')
    cnt = 0
    for i in xrange(0, len(date_range) - 1):
        tmp = df_loan_repay.loc[
            (df_loan_repay[u'放款日期'] >= date_range[i].date()) & (df_loan_repay[u'放款日期'] < date_range[i + 1].date())]
        cash_tmp = df_cash_loan_repay.loc[(df_cash_loan_repay[u'放款日期'] >= date_range[i].date()) & (
            df_cash_loan_repay[u'放款日期'] < date_range[i + 1].date())]
        if len(cash_tmp) > 0:
            tmp = tmp.append(cash_tmp)
        del tmp[u'放款日期']
        cnt += len(tmp)
        tmp.loc[tmp[[u'唯一编号']].duplicated(), [u'应还本金']] = 0
        tmp.loc[tmp[[u'流水号', u'还款账户', u'账单金额']].duplicated(), [u'账单金额']] = 0
        print date_range[i].year, date_range[i].month, len(tmp), tmp[u'应还本金'].sum()
        tmp[u'应还本息-实还本息'] = np.round(tmp[u'应还本金'] - tmp[u'实还本金'] + tmp[u'应还利息'] - tmp[u'实还利息'], 2)
        tmp[u'还款总额-账单金额'] = np.round(tmp[u'还款总额'] - tmp[u'账单金额'], 2)
        tmp.to_csv(os.path.join(file_path, '客户实还表（放款时间%s-%02d,包含现金支付）.csv' % (date_range[i].year, date_range[i].month)),
                   index=None, encoding='gbk')
    print cnt, len(df_loan_repay)


# 白条还款按实还时间提取
# repay_repaied()
# 白条还款按放款时间提取
# repay_loan_time()