# -*- encoding: utf8 -*-

import logging
import pandas as pd
from sqlalchemy import create_engine
import numpy as np

logging.basicConfig(level=logging.INFO,
                    format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                    datefmt='%a, %d %b %Y %H:%M:%S',
                    filename='log_update_repayment.log',
                    filemode='a+')
logging.getLogger('sqlalchemy.engine').setLevel(logging.INFO)
formatter = logging.Formatter('%(name)-12s: %(levelname)-8s %(message)s')
console = logging.StreamHandler()
console.setFormatter(formatter)
logging.getLogger('sqlalchemy.engine').addHandler(console)

engine_audit = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/new_transaction?charset=utf8',
                             echo=True)

'''
注意：1、更新完后，需要校验拆分正确否；
2、注意是否有未使用的红包，如果有，则检查原因
3、如果红包确实不使用，则需要删除 red_packet_detail 中 对应的未使用的红包，注意是该笔有还款且还款状态完成；如果有还款状态未还款，但是有红包，询问审计或财务或玉龙如何处理
'''

# sql_1='''
# select sum(ref_amount) repay_amount,plan_id from xjd_repay_plan_repay_record_ref  where plan_id IN (
# SELECT t2.id  FROM red_packet_detail t1 LEFT JOIN user_repayment_plan t2 ON t1.ref_id=t2.ref_id AND t1.term_no=t2.term_no WHERE xyqb_repaid_at>="2017-06-01" AND xyqb_repaid_at<"2017-07-01"
# ) group by plan_id
# '''
#AND t2.current_repayment = 0
sql_plan_ref = """
SELECT
	sum(ref_amount) repay_amount,
	plan_id
FROM
	xjd_repay_plan_repay_record_ref t1
JOIN user_repayment_plan t2 ON t1.plan_id = t2.id
WHERE
t2.fund_code in (290,350,380,420)
AND	t2.xyqb_repaid_at >= "2017-09-01"
AND t2.xyqb_repaid_at < "2017-10-10"
AND t2.repay_status = 3

GROUP BY
	t1.plan_id
"""
#
# sql_1 = """
#
# SELECT
#  	sum(ref_amount) repay_amount,
#  	plan_id
# FROM
# 	user_repayment_plan t1
# JOIN xjd_repay_plan_repay_record_ref t2 ON t1.id = t2.plan_id
# WHERE
# 	xyqb_repaid_at > "2017-06-01"
# AND xyqb_repaid_at < "2017-07-01"
# AND repay_status = 3
# AND current_repayment = 0
# AND t2.repay_channel in (13)
# GROUP BY
# 	t2.plan_id
# """

# sql_1 = '''
# select sum(ref_amount) repay_amount,plan_id from xjd_repay_plan_repay_record_ref  where plan_id IN (
# SELECT t2.id plan_id FROM red_packet_detail t1 LEFT JOIN user_repayment_plan t2 ON t1.ref_id=t2.ref_id AND t1.term_no=t2.term_no WHERE xyqb_repaid_at>="2017-06-01" AND xyqb_repaid_at<"2017-07-10"
# ) group by plan_id
# '''
# 89647
# 9892093
# sql_plan_ref='''
# select sum(ref_amount) repay_amount,plan_id from xjd_repay_plan_repay_record_ref  where plan_id in (19306061) GROUP BY plan_id
# '''


sql_user_plan = """select id plan_id,ref_id,term_no, principle, interest, service_fee, should_punish,repay_status from user_repayment_plan where id in %s """

sql_red_package = '''
select ref_id,term_no,amount red_amount from red_packet_detail where ref_id in %s
'''

sql_update = """update user_repayment_plan set real_principle = %s, real_interest = %s, real_service_fee = %s, \
 real_punish = %s, current_repayment = %s, collection_relief = %s, remain = %s, repay_msg = %s,red_package = %s,mitigate_all=%s where id = %s;"""


def cal_msg(x):
    repay_amount = x['repay_amount']
    principle = x['principle']
    interest = x['interest']
    service_fee = x['service_fee']
    should_punish = x['should_punish']
    res_msg = ''
    remain = repay_amount - principle
    remain = round(remain, 2)
    if remain < 0:
        res_msg += '减免本金%s元' % (-remain,)
        if interest > 0:
            res_msg += '，减免利息%s元' % (interest,)
        if service_fee > 0:
            res_msg += '，减免服务费%s元' % (service_fee,)
        if should_punish > 0:
            res_msg += '，减免罚息%s元' % (should_punish,)
        return res_msg + '。'
    remain -= interest
    remain = round(remain, 2)
    if remain < 0:
        res_msg += '减免利息%s元' % (-remain,)
        if service_fee > 0:
            res_msg += '，减免服务费%s元' % (service_fee,)
        if should_punish > 0:
            res_msg += '，减免罚息%s元' % (should_punish,)
        return res_msg + '。'
    remain -= service_fee
    remain = round(remain, 2)
    if remain < 0:
        res_msg += '减免服务费%s元' % (-remain,)
        if should_punish > 0:
            res_msg += '，减免罚息%s元' % (should_punish,)
        return res_msg + '。'
    remain -= should_punish
    remain = round(remain, 2)
    if remain < 0:
        return '减免罚息%s元。' % -remain
    return ''


step = 5000
df1_gen = pd.read_sql(sql=sql_plan_ref, con=engine_audit, chunksize=step)
i = 0
for df1 in df1_gen:
    logging.info('-----------------------------> i: %s <--------------------------' % i)
    i += 1
    logging.info('----------------------------> len(df1): %s  <------------------------------' % len(df1))
    ids = df1['plan_id'].astype(str).tolist()
    df2 = pd.read_sql(sql=sql_user_plan % str(tuple(ids)).replace(',)', ')'), con=engine_audit)
    ref_ids = df2.ref_id.astype(str).tolist()
    df3 = pd.read_sql(sql_red_package % str(tuple(ref_ids)).replace(',)', ')'), engine_audit)
    df2['ref_id'] = df2['ref_id'].astype(int)
    df2['term_no'] = df2['term_no'].astype(int)
    df3['ref_id'] = df3['ref_id'].astype(int)
    df3['term_no'] = df3['term_no'].astype(int)

    df = pd.merge(df1, df2, on='plan_id')
    df = pd.merge(df, df3, on=['ref_id', 'term_no'], how='left')
    df.fillna(0, inplace=True)
    df['repay_amount'] = df['repay_amount'].apply(lambda x: round(x, 2))
    df['principle'] = df['principle'].apply(lambda x: round(x, 2))
    df['interest'] = df['interest'].apply(lambda x: round(x, 2))
    df['service_fee'] = df['service_fee'].apply(lambda x: round(x, 2))
    df['should_punish'] = df['should_punish'].apply(lambda x: np.round(x, 2))
    df['red_package_fee'] = df['red_amount'].apply(lambda x: round(x, 2))
    df.repay_status = df.repay_status.astype(int)
    # repay_status == 3 可以做减免，其他的状态不进行减免
    df.ix[df.repay_status != 3, 'principle'] = df.ix[df.repay_status != 3].apply(
        lambda x: min(x.repay_amount, x.principle), axis=1)
    df.ix[df.repay_status != 3, 'interest'] = df.ix[df.repay_status != 3].apply(
        lambda x: min(x.interest, round(x.repay_amount - x.principle, 2)), axis=1)
    df.ix[df.repay_status != 3, 'service_fee'] = df.ix[df.repay_status != 3].apply(
        lambda x: min(x.service_fee, round(x.repay_amount - x.principle - x.interest, 2)), axis=1)
    df.ix[df.repay_status != 3, 'should_punish'] = df.ix[df.repay_status != 3].apply(
        lambda x: min(x.should_punish, round(x.repay_amount - x.principle - x.interest - x.service_fee, 2)), axis=1)
    # 非还款完成状态不使用红包
    df.ix[df.repay_status != 3, 'red_package_fee'] = 0


    df['remain'] = df['repay_amount'] - df['principle'] - df['interest'] - df['service_fee'] - df['should_punish']
    df['remain'] = df['remain'].apply(lambda x: round(x, 2))

    # remain 小于零 变成减免
    df['msg'] = df.apply(lambda x: cal_msg(x), axis=1)
    df['collection_relife'] = 0
    df.loc[df['remain'] < 0, 'collection_relife'] = -df.loc[df['remain'] < 0, 'remain']
    df.loc[df['remain'] <= 0, 'remain'] = 0
    # 如果有减免 < 红包，不使用红包 collection_relife是总减免
    df.ix[(df.repay_status == 3) & (df.collection_relife < df.red_package_fee),'red_package_fee'] = 0

    # mitigate_all是催收减免
    df['mitigate_all'] = np.round(df['collection_relife'] - df['red_package_fee'], 2)
    df_list = df[
        ['principle', 'interest', 'service_fee', 'should_punish', 'repay_amount', 'collection_relife', 'remain', 'msg',
         'red_package_fee', 'mitigate_all', 'plan_id']].values.tolist()
    logging.info('----------------------------> len(df_list): %s  <------------------------------' % len(df_list))
    engine_audit.execute(sql_update, df_list)

print '-------------------------------------------done-----------------------------------'
