# coding: utf-8
# Author: Perry_Zhu
import sys
import pandas as pd
import datetime
from sqlalchemy import create_engine

reload(sys)
sys.setdefaultencoding('utf8')

engine_new_transaction = create_engine(
    'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/all_back_0930?charset=utf8', echo=True)

end_point = '2017-10-01'
watch_point = datetime.date(2017, 9, 30)
out_file_path = u'E:/数据汇总/白条/在贷/'

query_loan = """
    SELECT tt.order_no,tt.term_no,min(tt.deadline)deadline,SUM(tt.principle)principle,min(tt.loan_y)loan_y,
      min(tt.loan_m)loan_m,min(tt.plan_year)plan_year,min(tt.plan_month)plan_month
    FROM(
    SELECT
        plan.order_no,
        plan.term_no,
        date(plan.deadline)deadline,
        sum(plan.principle)principle,
        year(bo.loan_paid_at) loan_y,
        month(bo.loan_paid_at) loan_m,
        year(plan.deadline) plan_year,
        month(plan.deadline) plan_month
    FROM
        baitiao_order bo
    JOIN user_bt_repayment_plan plan ON bo.ref_id=plan.ref_id
    WHERE
        bo.loan_paid_at >= '2015-01-01'
    AND bo.loan_paid_at < '%s'
    AND bo.is_active =1
    AND bo.funding_corp_id = 1
    GROUP BY 1,2
    
    UNION ALL
        SELECT
            plan.order_no,
            plan.term_no,
            date(plan.deadline)deadline,
            sum(plan.principle)principle,
            year(bo.train_cancel_at) loan_y,
            month(bo.train_cancel_at) loan_m,
            year(plan.deadline) plan_year,
            month(plan.deadline) plan_month
        FROM
            baitiao_order bo
        JOIN user_bt_repayment_plan plan ON bo.ref_id=plan.ref_id
        WHERE
            bo.train_cancel_at >= '2015-01-01'
        AND bo.train_cancel_at < '%s'
        AND bo.is_active =- 2
        AND bo.funding_corp_id = 1
        GROUP BY 1,2
    
    
    UNION ALL
        SELECT
            bo.order_no,
            1 term_no ,
            date(bo.loan_paid_at) deadline,
            sum(bcr.real_order_amount) principle,
            year(bo.loan_paid_at) loan_y,
            month(bo.loan_paid_at) loan_m,
            year(bo.loan_paid_at) plan_year,
            month(bo.loan_paid_at) plan_month
        FROM
            baitiao_cash_repay bcr
        JOIN baitiao_order bo ON bo.ref_id = bcr.ref_id AND bo.is_active=1 AND bo.funding_corp_id= 1 
            AND bo.loan_paid_at >= '2017-07-01' AND bo.loan_paid_at < '%s'
         GROUP BY 1,2
    UNION ALL
    SELECT
        bo.order_no,
        1 term_no ,
        date(bo.train_cancel_at) deadline,
        sum(bcr.real_order_amount) principle,
        year(bo.train_cancel_at) loan_y,
        month(bo.train_cancel_at) loan_m,
        year(bo.train_cancel_at) plan_year,
        month(bo.train_cancel_at) plan_month

    FROM
        baitiao_cash_repay bcr
    JOIN baitiao_order bo ON bo.ref_id = bcr.ref_id AND bo.is_active=-2 AND bo.funding_corp_id =1 
        AND bo.train_cancel_at >= '2017-07-01' AND bo.train_cancel_at < '%s'
     GROUP BY 1,2
    )tt
  GROUP BY 1,2
"""

repay_online = """
    SELECT
        t2.order_no,
        t2.term_no,
        SUM(ifnull(t1.principle, 0) - IFNULL(t1.mitigate_principle, 0)) paid_principle
    FROM
        baitiao_repay_plan_repay_record_ref t1
    JOIN repay_record_online t3 ON t1.repay_channel in(1,2,3,4,5,6,7,8,9,10,11,12,22,23,24) AND t3.id = t1.record_id 
        AND t3.bill_time >= '2015-01-01' AND t3.bill_time < '%s' 
        and t1.id not in(14164355,14164357,14164359,13818155,13818157,13818159,13533131,13996965,13996971,13996967,
              13996957,13996959,13996961,13996963,13996973,13996975,13996977,16774675,14471253)
    JOIN user_bt_repayment_plan t2 ON t2.id = t1.plan_id
    JOIN baitiao_audit.baitiao_order t5 ON t2.ref_id = t5.ref_id AND t5.funding_corp_id = 1
    GROUP BY 1,2
"""
repay_ali = """
    SELECT
        t2.order_no,
        t2.term_no,
        SUM(ifnull(t1.principle,0)-ifnull(t1.mitigate_principle,0)) paid_principle
    FROM
        baitiao_repay_plan_repay_record_ref t1
    JOIN user_bt_repayment_plan t2 ON t2.id = t1.plan_id
    JOIN offline_alipay_record t3 ON t1.repay_channel = 13 AND t3.id = t1.record_id  AND  t3.is_ref=1 
        AND t3.transfer_time>='2015-01-01' AND t3.transfer_time<'%s'
    JOIN baitiao_audit.baitiao_order t5 ON t2.ref_id = t5.ref_id  AND t5.funding_corp_id = 1
    GROUP BY 1,2
"""
repay_bank = """
    SELECT
        t2.order_no,
        t2.term_no,
        SUM(ifnull(t1.principle,0)-ifnull(t1.mitigate_principle,0)) paid_principle
    FROM
            baitiao_repay_plan_repay_record_ref t1
    JOIN user_bt_repayment_plan t2 ON t2.id = t1.plan_id
    JOIN offline_bank_repay_record t3 ON t1.repay_channel IN (14, 15, 16) AND t3.id = t1.record_id 
        AND t3.transfer_time>='2015-01-01' AND t3.transfer_time<'%s'
    JOIN baitiao_audit.baitiao_order t5 ON t2.ref_id = t5.ref_id 
    GROUP BY 1,2
"""
repay_cash = """
select tt.order_no,tt.term_no,tt.paid_principle from(
    SELECT
        bo.order_no,
        1 term_no,
        sum(bcrr.ref_amount) paid_principle
    FROM
        baitiao_cash_repay bcr
    JOIN (
        SELECT
            repay_id,
            sum(ref_amount) ref_amount
        FROM
            baitiao_cash_record_ref
        WHERE
            repay_channel IN (18, 24)
        GROUP BY 1
    ) bcrr ON bcrr.repay_id = bcr.id
    JOIN baitiao_order bo ON bo.ref_id = bcr.ref_id AND bo.baitiao_type = 1 AND bo.loan_paid_at >= '2017-07-01' 
        AND bo.loan_paid_at < '%s'
    GROUP BY 1,2
    UNION ALL
        SELECT
            bo.order_no,
            1 term_no,
            sum(bcrr.ref_amount) paid_principle
        FROM
            baitiao_cash_repay bcr
        JOIN (
            SELECT
                repay_id,
                sum(ref_amount) ref_amount
            FROM
                baitiao_cash_record_ref
            WHERE
                repay_channel = 13
            GROUP BY 1
        ) bcrr ON bcrr.repay_id = bcr.id
        JOIN baitiao_order bo ON bo.ref_id = bcr.ref_id AND bo.is_active = -2 AND bo.train_cancel_at >= '2017-07-01' 
            AND bo.train_cancel_at < '%s'
    GROUP BY 1,2
)tt
GROUP BY 1,2

"""

df_loan = pd.read_sql(query_loan % (end_point, end_point, end_point, end_point), engine_new_transaction)
df_online = pd.read_sql(repay_online % end_point, engine_new_transaction)
df_ali = pd.read_sql(repay_ali % end_point, engine_new_transaction)
df_bank = pd.read_sql(repay_bank % end_point, engine_new_transaction)
df_cash = pd.read_sql(repay_cash % (end_point, end_point), engine_new_transaction)
df_repay = pd.concat([df_online, df_ali, df_bank, df_cash], axis=0, ignore_index=True)
df_repay.dropna(axis=0, inplace=True)
df_loan = df_loan.loc[df_loan['principle'] > 0]
df_loan.order_no = df_loan.order_no.astype(str)
df_loan.term_no = df_loan.term_no.astype(int)
df_repay.order_no = df_repay.order_no.astype(str)
df_repay.term_no = df_repay.term_no.astype(int)
df_repay = df_repay.groupby(['order_no', 'term_no'])['paid_principle'].agg({'sum'}).reset_index().rename(
    columns={'sum': 'paid_principle'})
df_out = pd.merge(df_loan, df_repay, on=['order_no', 'term_no'], how='left')
df_out['deadline'] = pd.to_datetime(df_out.deadline)
df_out.fillna(0, inplace=True)
df_out['zaidai'] = df_out['principle'] - df_out['paid_principle']
# df_out.loc[df_out['order_no'].isin(['trainmall1483695024282','trainmall1484301600672','trainmall1486362269554','trainmall1487920296689','trainmall1491536200793','trainmall1483695024282','trainmall1484301600672','trainmall1486362269554','grabtrainmall1484650405321']),'zaidai']=0
df_out.loc[df_out['order_no'].isin(
    ['trainmall1483695024282', 'trainmall1484301600672', 'trainmall1486362269554', 'trainmall1487920296689',
     'trainmall1491536200793', 'trainmall1483695024282', 'trainmall1484301600672', 'trainmall1486362269554',
     'grabtrainmall1484650405321', 'trainmall1495785791995', 'trainmall1499935282194', 'trainmall16008368458050561',
     'trainmall16008408858634241', 'trainmall16112348780571649', 'trainmall16112552463312897']), 'zaidai'] = 0
df_1 = df_out.loc[df_out['deadline'] > watch_point]
df_2 = df_out.loc[((watch_point - df_out['deadline']) < datetime.timedelta(30)) & (df_out['deadline'] <= watch_point)]
df_3 = df_out.loc[((watch_point - df_out['deadline']) >= datetime.timedelta(30)) & (df_out['deadline'] <= watch_point)]
df_1t = df_1.groupby(['loan_y', 'loan_m', 'term_no', 'plan_year', 'plan_month'])['zaidai'].agg(
    {'sum'}).reset_index().rename(columns={'sum': u'未到期在贷'})
df_2t = df_2.groupby(['loan_y', 'loan_m', 'term_no', 'plan_year', 'plan_month'])['zaidai'].agg(
    {'sum'}).reset_index().rename(columns={'sum': u'逾期30天内在贷'})
df_3t = df_3.groupby(['loan_y', 'loan_m', 'term_no', 'plan_year', 'plan_month'])['zaidai'].agg(
    {'sum'}).reset_index().rename(columns={'sum': u'逾期30天以上在贷'})
df = pd.merge(df_1t, df_2t, on=['loan_y', 'loan_m', 'term_no', 'plan_year', 'plan_month'], how='outer')
df = pd.merge(df, df_3t, on=['loan_y', 'loan_m', 'term_no', 'plan_year', 'plan_month'], how='outer')
df.fillna(0, inplace=True)
df = df[['loan_y', 'loan_m', 'term_no', 'plan_year', 'plan_month', u'未到期在贷', u'逾期30天内在贷', u'逾期30天以上在贷']]
df.rename(columns={'loan_y': u'放款年',
                   'loan_m': u'放款月',
                   'term_no': u'期数',
                   'plan_year': u'应还年',
                   'plan_month': u'应还月',
                   }, inplace=True)

df.to_excel(out_file_path + u'白条在贷V2_%s.xlsx' % end_point, index=None)