# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
import multiprocessing as mtp
from itertools import product
import numpy as np
import pyexcelerate

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None
max_limit = 800000
#
# 表名称：
#	白条-去哪儿-核算-放款表：分多种类型，转让保理后的放款表，资金方的放款表，针对用户角度的放款表
#
#


file_path = u'E:/审计出表/人工控制/去哪儿-放款表/'
file_name = u'去哪儿_放款表_现金流_%s_%s.xlsx'
engine_qunaer = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/qunaer_new?charset=utf8',
                              echo=False).connect()


# 债权转让后的保理放款表
def baoli_pay(year, month,plan_table='baoli_repayment_plan'):
    start_time = datetime.datetime(year, month, 1, 0, 0, 0)
    end_time = start_time + relativedelta(months=+1)
    sql_pay = '''
	select 
	    concat(pay.product_no,plan.user_current_stage_no) as '唯一编号',
	    pay.product_no '产品编号',
	    '保理' AS '资金方',
		date(pay.trans_time) '贷款时间',
		'TRUE' as '是否债转',
		pay.loan_amount '合同放款金额',
		pay.new_stages '分期数',
		'FALSE' AS  '是否转分期后订单',
		plan.user_current_stage_no AS '应还期数',
		date(plan.deadline) AS '应还时间',
		plan.principle AS '应还本金',
		0 as '应还利息-直投',
		plan.fee_amount AS '应还服务费'
	from qunaer_new.baoli_pay_detail pay
	join %s plan on pay.product_no = plan.product_no 
	where trans_time >='%s' and trans_time < '%s'
	''' % (plan_table,start_time, end_time)
    df_pay = pd.read_sql(sql_pay, engine_qunaer)
    return df_pay


# 资金方放款表
def fund_pay(year, month,plan_table='fund_repayment_plan'):
    start_time = datetime.datetime(year, month, 1, 0, 0, 0)
    end_time = start_time + relativedelta(months=+1)
    # 资金方的放款表
    sql_pay = '''
    	select 
    	    concat(pay.product_no,plan.current_stage_no) AS '唯一编号',
    	    pay.product_no AS '产品编号',
    	    fc.fund_name AS '资金方',
    		date(pay.trans_time) AS '贷款时间',
    		'FALSE' as '是否债转',
    		pay.loan_amount AS '合同放款金额',
    		pay.stages AS '分期数',
    		'FALSE' as  '是否转分期后订单',
    		plan.current_stage_no AS '应还期数',
    		date(plan.deadline) AS '应还时间',
    		plan.principle '应还本金',
    		plan.interest as '应还利息-直投',
    		plan.fee_amount AS '应还服务费'
    	from qunaer_new.fund_pay_detail pay
    	join %s plan on pay.product_no = plan.product_no 
    	join qunaer_new.fund_corp fc on pay.fund_code = fc.fund_code
    	where trans_time >='%s' and trans_time < '%s'
    ''' % (plan_table,start_time, end_time)
    # 读取sql语句，2分钟左右
    df_pay = pd.read_sql(sql_pay, engine_qunaer)
    return df_pay


# 保理的放款表，注意，非债权转让后的放款表
def user_pay(year, month,plan_table='repayment_plan_2017'):
    start_time = datetime.datetime(year, month, 1, 0, 0, 0)
    end_time = start_time + relativedelta(months=+1)
    #用户的放款表
    sql_pay = '''
        select 
            concat(pay.product_no,plan.current_stage_no) AS '唯一编号',
            pay.product_no '产品编号',
            '保理' AS  '资金方',
        	date(pay.trans_time) '贷款时间',
        	'FALSE' as '是否债转',
        	pay.loan_amount '合同放款金额',
        	pay.stages '分期数',
        	if(pay.is_ptf = 0,'FALSE','TRUE') '是否转分期后订单',
        	plan.current_stage_no '应还期数',
        	date(plan.deadline) '应还时间',
        	plan.principle '应还本金',
        	0 as '应还利息-直投',
        	plan.fee_amount AS '应还服务费'
        from qunaer_new.pay_detail pay
        join %s plan on pay.product_no = plan.product_no 
        where pay.fund_code = 1 and trans_time >='%s' and trans_time < '%s'
    ''' % (plan_table,start_time, end_time)

    # 属于保理的退款
    sql_refund = '''
        select 
        concat(pay.product_no,'0') AS '唯一编号',
        refund.product_no '产品编号',
        '保理' AS '资金方',
        date(pay.trans_time) '贷款时间',
        'FALSE' as '是否债转',
        refund.refund_amount '合同放款金额',
        pay.stages '分期数',
        date(refund.refund_time) '退款时间',
        if(pay.is_ptf = 0,'FALSE','TRUE') '是否转分期后订单'
        from qunaer_new.refund_detail refund
        JOIN qunaer_new.pay_detail pay on refund.product_no = pay.product_no and refund.fund_code = pay.fund_code
        WHERE pay.fund_code = 1 and refund_time >='%s' and refund_time < '%s' AND refund.flow_id IS NULL AND refund_time < '2017-09-01'
    ''' % (start_time, end_time)
    # 读取sql语句，2分钟左右
    df_pay = pd.read_sql(sql_pay, engine_qunaer)
    # 含有 flow_id 的退款，在还款表中体现。
    df_refund = pd.read_sql(sql_refund, engine_qunaer)
    # 合并退款记录和放款记录
    df = pd.concat([df_pay, df_refund], ignore_index=True)
    df = df.fillna(0)
    return df


# 放款时间对应的 实还
def hk(year, month):
    start_time = datetime.datetime(year, month, 1, 0, 0, 0)
    sql_1 = '''
	select fc.fund_name AS '资金方',product_no '产品编号',current_stage_no '应还期数',sum(repay_principle) '实还本金',0 AS '实还利息-直投'
	from repay_detail repay 
	JOIN fund_corp fc on repay.fund_code= fc.fund_code
	where repay_time >= '%s'
	group by 1,2,3
	''' % start_time
    df_hk = pd.read_sql(sql_1, engine_qunaer)
    return df_hk


if __name__ == '__main__':
    years = [2017]
    months = range(9,10)
    for year, month in product(years, months):
        df_baoli = baoli_pay(year, month,plan_table='baoli_repayment_plan')
        df_fund = fund_pay(year, month,plan_table='fund_repayment_plan')
        df_user = user_pay(year, month,plan_table='repayment_plan_2017')
        df_plan = pd.concat([df_baoli, df_fund, df_user], ignore_index=True)
        df_repay = hk(year, month)
        df_plan.fillna(0, inplace=True)
        df_plan = pd.merge(df_plan, df_repay, on=[u'资金方', u'产品编号', u'应还期数'], how='left')
        df_plan.fillna(0, inplace=True)
        # 合同金额不重复显示
        df_plan_1=df_plan.ix[df_plan[u'合同放款金额'] > 0]
        df_plan_2=df_plan.ix[df_plan[u'合同放款金额'] <= 0]
        df_plan_1.loc[df_plan_1[[u'资金方',u'产品编号']].duplicated(),u'合同放款金额'] = 0
        df_plan_1.loc[df_plan_1[[u'资金方',u'产品编号', u'应还期数']].duplicated(), u'应还本金'] = 0
        df_plan=pd.concat([df_plan_1,df_plan_2],ignore_index=True)
        # 应还本息-实还本息
        df_plan[u'应还本息-实还本息'] = np.round(df_plan[u'应还本金'] + df_plan[u'应还利息-直投'] - df_plan[u'实还本金'], 2)
        df_plan=df_plan[[u'唯一编号',u'产品编号',u'资金方',u'贷款时间',u'合同放款金额',u'分期数',u'是否转分期后订单',u'是否债转',u'应还期数',u'应还时间',u'应还本金',u'应还利息-直投',u'应还服务费',u'实还本金',u'实还利息-直投',u'应还本息-实还本息']]

        # df_plan.to_excel(file_path + file_name % (year, month),index=None)

        all_wb = pyexcelerate.Workbook()
        for i in xrange(0, len(df_plan), max_limit):
            temp = df_plan[i:i + max_limit]
            temp_list = temp.values.tolist()
            temp_list.insert(0, temp.columns.tolist())
            all_wb.new_sheet(str(int(i / max_limit + 1)), data=temp_list)
        all_wb.save(file_path +file_name % (year, month))

print '-----------------------main done---------------------------------------'
