import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
from itertools import product
import os
import pyexcelerate
reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None

max_limit = 800000
import os

# @author Han
# 表名称：
#	现金贷-核算-放款表明细（1-6月份）
# 表字段：
#	唯一编 号 E=A&C
#
# 数据库：
#	repay_detail，pay_detail
# 注意事项：
#	loan_manifest.is_active in （1，-2）

# 	需要先进行数据的获取，需要时间较长，sql_repay_all中xrd.repaid_at同样需要修改

path = u'1020_files/'
path = u'E:/审计出表/非去哪儿白条-客户实还表-1023版/'
engine_xjd = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/audit?charset=utf8',
						   echo=False).connect()

def faster_sql_reader(sql):
	cmdstr = 'mysql -h172.16.3.201 -uinternal_r -pArbNgtvlJzZHXsEu -P3306 -e "%s" > %s'
	file_name = 'test.txt'
	path_file = os.path.join(os.getcwd(), file_name)
	exe_sql = cmdstr % (sql.replace('`',''), path_file)
	exe_sql = exe_sql.replace('\t','').replace('\n',' ')
	os.system(exe_sql)
	try:
		df = pd.read_csv(path_file, sep='\t',encoding='utf-8')
	except:
		return pd.DataFrame()
	return df

# #使用时先要修改 deadline，如果出9月份的，deadline > = 2017-09-01即可
sql_fund = '''
	select frp.ref_id,frp.term_no 'term_no',date(frp.deadline) 'deadline',frp.principle+ifnull(frp.interest,0) 'prin_interes'
	from audit.funding_repayment_plan frp
	where frp.deadline >= '2017-01-01'
'''
df_fund = faster_sql_reader(sql_fund)
df_fund.rename(columns={'term_no':u'应还期数','deadline':u'应还资金方时间','prin_interes':u'应还资金方本息'},inplace=True)

# df_fund = pd.read_csv(path)
#
#此部分不需要进行修改
sql_contract_no = '''
select ref_id,contract_no
from basic.loan_class_contract_1002 lco
'''
#10月05日修改为basic.loan_class_contract_1002

df_contract_no = faster_sql_reader(sql_contract_no)

sql_fund_name = '''
select funding_code,name '资金方' 
from basic.funding_corp
'''
df_fund_name = pd.read_sql(sql_fund_name,engine_xjd)

def mc_pay(year, month):
	#year, month = 2017, 2
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)

	sql_repay_all = '''
	select 
	urp.ref_id,
	urp.term_no 'term_no',
	sum(xrprrr.principle-IFNULL(xrprrr.mitigate_principle,0)+xrprrr.interest-IFNULL(xrprrr.mitigate_interest,0)) 'principle_interes',
	sum(xrprrr.service_fee-IFNULL(xrprrr.mitigate_service_fee,0)) 'service_fee'
	from audit_temp.xjd_repay_plan_repay_record_ref_0831 xrprrr
	join all_back_0831.user_repayment_plan urp on xrprrr.plan_id = urp.id
	join all_back_0831.loan_manifest lm on lm.ref_id = urp.ref_id
	where lm.loan_paid_at>='%s' and lm.loan_paid_at<'%s'
	group by 1,2
	''' %(start_time,end_time)

	sql_pay = '''
	SELECT
		lm.funding_code,
		lm.loan_id 'loan_id',
		date(lm.loan_paid_at) 'loan_paid_at',
		lm.contract_loan_amount 'contract_loan_amount',
		lm.loan_account_id 'account_id',
		lm.contract_term*ifnull(lm.per_term_service_fee,0) 'all_service_fee',
		lm.ref_id
	FROM
		audit.loan_manifest lm
	join audit.loan_account la on la.id = lm.loan_account_id
	WHERE
		lm.loan_paid_at >= '%s'
	AND lm.loan_paid_at < '%s'
	AND lm.is_active IN (1, -2)
	''' % (start_time, end_time)

	sql_account_name = '''
	select id 'account_id',accountName
	from audit.loan_account la
	'''
	df_account = pd.read_sql(sql_account_name,engine_xjd)
	df_pay = faster_sql_reader(sql_pay)
	df_pay = pd.merge(df_pay,df_account,on='account_id',how='left')
	df_pay.drop(['account_id'],axis=1,inplace=True)

	df_pay.rename(columns={'loan_paid_at':u'放款时间','contract_loan_amount':u'放款金额','accountName':u'放款渠道','all_service_fee':u'应收总服务费'},inplace=True)
	df_repay_all = faster_sql_reader(sql_repay_all)
	df_repay_all.rename(columns={'term_no':u'应还期数','principle_interes':u'客户实还本息','service_fee':u'实还服务费'},inplace=True)


	print(sum(df_repay_all[u'客户实还本息']))
	df_pay['ref_id'] = df_pay['ref_id'].astype('int64')
	df_fund['ref_id'] = df_fund['ref_id'].astype('int64')

	df_pay = pd.merge(df_pay,df_fund,on='ref_id',how='left')
	# df_pay= df_pay.drop([u'ref_id'])

	df_pay = df_pay.fillna(0)
	df_pay[u'唯一编号'] = df_pay['loan_id'].astype('str')+df_pay[u'应还期数'].astype('int').astype('str')

	df_pay[u'Merge'] = df_pay[u'唯一编号']+df_pay[u'放款时间'].astype('str')+df_pay[u'应还资金方本息'].astype('str')

	df_pay['loan_id'] = df_pay['loan_id'].astype('int64')
	df_pay['ref_id'] = df_pay['ref_id'].astype('int64')
	df_pay[u'应还期数'] = df_pay[u'应还期数'].astype('int64')

	df_repay_all[u'ref_id'] = df_repay_all[u'ref_id'].astype('int64')
	df_repay_all[u'应还期数'] = df_repay_all[u'应还期数'].astype('int64')

	df_pay = pd.merge(df_pay, df_repay_all, on=[u'ref_id',u'应还期数'], how='left')

	df_pay[u'客户实还服务费'] = df_pay[u'实还服务费']
	df_pay.loc[df_pay['loan_id'].duplicated(), u'放款金额'] = 0
	df_pay.loc[df_pay['loan_id'].duplicated(), u'应收总服务费'] = 0

	df_pay[u'应还总服务费-实还服务费'] = df_pay[u'应收总服务费'].fillna(0) - df_pay[u'实还服务费'].fillna(0)
	df_pay[u'应还资金方本息-客户实还本息'] = df_pay[u'应还资金方本息'].fillna(0) - df_pay[u'客户实还本息'].fillna(0)

	df_pay = pd.merge(df_pay,df_contract_no,on='ref_id',how='left')
	df_pay = df_pay.fillna(0)
	df_pay = df_pay.drop(['ref_id',u'实还服务费'],axis = 1)
	df_pay = pd.merge(df_pay,df_fund_name,on='funding_code',how='left')

	print(u'放款金额:' + str(sum(df_pay[u'放款金额'])) + u' 应收总服务费:' + str(sum(df_pay[u'应收总服务费'])) + u' 应还资金方本息:' + str(
		sum(df_pay[u'应还资金方本息'])) + u' 客户实还本息' + str(
		sum(df_pay[u'客户实还本息'])))
	df_pay.rename(columns = {'contract_no':u'合同号',u'实还服务费':u'客户实还服务费'},inplace = True)

	columns = [u'唯一编号',u'资金方',u'loan_id',u'合同号',u'放款时间',u'放款金额',u'放款渠道',u'应收总服务费',u'应还期数',u'应还资金方时间',
			   u'应还资金方本息',u'Merge',u'应还期数',u'应还资金方时间',u'应还资金方本息',u'应还期数',u'客户实还服务费',u'客户实还本息',
			   u'应还总服务费-实还服务费',u'应还资金方本息-客户实还本息']

	all_wb = pyexcelerate.Workbook()
	for i in xrange(0, len(df_pay), max_limit):
		temp = df_pay[i:i+max_limit][columns]
		temp_list = temp.values.tolist()
		temp_list.insert(0,temp.columns.tolist())
		all_wb.new_sheet(str(int(i/max_limit + 1)),data=temp_list)
	all_wb.save(path+u'人工控制-现金贷-放款表_测试(%d-%02d).xlsx' %(start_time.year,start_time.month))


	# if len(df_pay) > max_limit:
	# 	for i in xrange(0, len(df_pay), max_limit):
	# 		df_pay[i:i + max_limit].to_excel(os.path.join(path, u'人工控制-现金贷-放款表-(%s-%02d)-%d.xlsx' % (
	# 			year, month, i / max_limit + 1)), index=None, columns=columns)
	# else:
	# 	df_pay.to_excel(path + u'人工控制-现金贷-放款表-(%d-%d).xlsx' % (year, month), index=None, columns=columns)

if __name__ == '__main__':
	year = [2017]
	month = range(1, 2, 1)

	for year, month in product(year, month):
		mc_pay(year, month)
