# -*- coding: utf-8 -*-
import os
import sys
import datetime
import itertools
import pandas as pd
from sqlalchemy import create_engine
import multiprocessing as mtp

reload(sys)
sys.setdefaultencoding('utf8')

engine_financial = create_engine(
    'mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/all_back_0531?charset=utf8',
    echo=True)

start_time_deadline = '2017-05-01 00:00:00'
end_time_deadline = '2017-06-01 00:00:00'

start_time_loanPaidAt = '2016-01-01 00:00:00'
end_time_loanPaidAt = '2017-01-01 00:00:00'

path = u'C:/Users/wangbo/Desktop/huarong_5/'

start_ancient_time = '2015-01-01 00:00:00'

sql_fund = '''
select id fund_code,name fund_name from new_transaction.funding_corp WHERE id IN (150)
'''
sql_repay_channel = '''
select id repay_channel , approach_name channel_name FROM new_transaction.`repay_channel`
'''
df_fund = pd.read_sql(sql_fund, con=engine_financial)
df_repay_channel = pd.read_sql(sql_repay_channel, con=engine_financial)

sql_fund_hk_hr = '''
SELECT DATE(t1.repaid_at) day_hk,t1.funding_code fund_code, SUM(t1.`principle`)+SUM(t1.`interest`) plan_all
FROM all_back_0531.`funding_repayment_record` t1 JOIN all_back_0531.loan_manifest t2 ON t1.loan_id=t2.loan_id JOIN temp.loan_class t3 ON t2.ref_id=t3.ref_id  WHERE
  t1.is_active = 1 AND t3.class='%s' AND t1.funding_code=%s
AND t2.is_active in (1,-2) AND  t2.loan_paid_at >='%s' and t2.loan_paid_at<'%s'
and t1.repaid_at >= '%s' AND t1.repaid_at < '%s'
GROUP BY DATE(t1.repaid_at)
'''

sql_hk_fund_deadline_online_overdue_hr_5 = """
(SELECT
   t3.id plan_id,
   t3.ref_id,
	DATE(t3.xyqb_repaid_at) repaid_at,
	DATE(t4.deadline) deadline,
	t1.repay_channel,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(t1.`principle` - t1.`mitigate_principle`+t1.`interest` - t1.`mitigate_interest`) real_principle
FROM
	all_back_0531.`xjd_repay_plan_repay_record_ref` t1
JOIN all_back_0531.`repay_record_online` t2 ON t1.repay_channel < 13
AND t1.record_id = t2.id
JOIN all_back_0531.`user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN all_back_0531.funding_repayment_record t4 ON t4.ref_id = t3.ref_id
AND t4.term_no = t3.term_no
JOIN all_back_0531.loan_manifest t5 ON t3.ref_id = t5.ref_id
JOIN temp.loan_class t6 ON t5.ref_id = t6.ref_id
WHERE
    t6.class='%s' AND 	t3.fund_code = %s
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s'
AND t3.xyqb_repaid_at < '%s' AND t3.xyqb_repaid_at>t4.deadline)
UNION ALL
(SELECT
    t3.id plan_id,
    t3.ref_id,
	DATE(t2.transfer_time) repaid_at,
	DATE(t4.deadline) deadline,
	t1.repay_channel,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(t1.`principle` - t1.`mitigate_principle`+t1.`interest` - t1.`mitigate_interest`) real_principle
FROM
	all_back_0531.`xjd_repay_plan_repay_record_ref` t1
JOIN all_back_0531.`offline_alipay_record` t2 ON t1.repay_channel = 13
AND t1.record_id = t2.id
JOIN all_back_0531.`user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN all_back_0531.funding_repayment_record t4 ON t4.ref_id = t3.ref_id
AND t4.term_no = t3.term_no
JOIN all_back_0531.loan_manifest t5 ON t3.ref_id = t5.ref_id
JOIN temp.loan_class t6 ON t5.ref_id = t6.ref_id
WHERE
    t6.class='%s' AND	t3.fund_code = %s
 AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t2.transfer_time >= '%s'
AND t2.transfer_time < '%s' AND t3.xyqb_repaid_at>t4.deadline
)
"""
sql_hk_fund_deadline_online_normal_hr_5 = """
(SELECT
   t3.id plan_id,
   t3.ref_id,
	DATE(t3.xyqb_repaid_at) repaid_at,
	DATE(t4.deadline) deadline,
	t1.repay_channel,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(t1.`principle` - t1.`mitigate_principle`+t1.`interest` - t1.`mitigate_interest`) real_principle
FROM
	all_back_0531.`xjd_repay_plan_repay_record_ref` t1
JOIN all_back_0531.`repay_record_online` t2 ON t1.repay_channel < 13
AND t1.record_id = t2.id
JOIN all_back_0531.`user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN all_back_0531.funding_repayment_record t4 ON t4.ref_id = t3.ref_id
AND t4.term_no = t3.term_no
JOIN all_back_0531.loan_manifest t5 ON t3.ref_id = t5.ref_id
JOIN temp.loan_class t6 ON t5.ref_id = t6.ref_id
WHERE
    t6.class='%s' AND  t3.fund_code = %s AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s'
AND t3.xyqb_repaid_at < '%s' AND t4.deadline>='%s' AND t4.deadline<'%s')
UNION ALL
(SELECT
    t3.id plan_id,
    t3.ref_id,
	DATE(t2.transfer_time) repaid_at,
	DATE(t4.deadline) deadline,
	t1.repay_channel,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(t1.`principle` - t1.`mitigate_principle`+t1.`interest` - t1.`mitigate_interest`) real_principle
FROM
	all_back_0531.`xjd_repay_plan_repay_record_ref` t1
JOIN all_back_0531.`offline_alipay_record` t2 ON t1.repay_channel = 13
AND t1.record_id = t2.id
JOIN all_back_0531.`user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN all_back_0531.funding_repayment_record t4 ON t4.ref_id = t3.ref_id
AND t4.term_no = t3.term_no
JOIN all_back_0531.loan_manifest t5 ON t3.ref_id = t5.ref_id
JOIN temp.loan_class t6 ON t5.ref_id = t6.ref_id
WHERE    t6.class='%s' AND t3.fund_code = %s AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t2.transfer_time >= '%s'
AND t2.transfer_time < '%s' AND t4.deadline>='%s' AND t4.deadline<'%s'
)
"""
sql_hk_fund_deadline_online_advance_hr_5 = """
(SELECT
   t3.id plan_id,
   t3.ref_id,
	DATE(t3.xyqb_repaid_at) repaid_at,
	DATE(t4.deadline) deadline,
	t1.repay_channel,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(t1.`principle` - t1.`mitigate_principle`+t1.`interest` - t1.`mitigate_interest`) real_principle
FROM
	all_back_0531.`xjd_repay_plan_repay_record_ref` t1
JOIN all_back_0531.`repay_record_online` t2 ON t1.repay_channel < 13
AND t1.record_id = t2.id
JOIN all_back_0531.`user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN all_back_0531.funding_repayment_record t4 ON t4.ref_id = t3.ref_id
AND t4.term_no = t3.term_no
JOIN all_back_0531.loan_manifest t5 ON t3.ref_id = t5.ref_id
JOIN temp.loan_class t6 ON t5.ref_id = t6.ref_id
WHERE
    t6.class='%s' AND t3.fund_code = %s AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
	 AND t4.deadline>='%s'
	 AND t4.deadline<'%s'
AND t3.xyqb_repaid_at < '%s' AND t3.xyqb_repaid_at<t4.deadline)
UNION ALL
(SELECT
    t3.id plan_id,
    t3.ref_id,
	DATE(t2.transfer_time) repaid_at,
	DATE(t4.deadline) deadline,
	t1.repay_channel,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(t1.`principle` - t1.`mitigate_principle`+t1.`interest` - t1.`mitigate_interest`) real_principle
FROM
	all_back_0531.`xjd_repay_plan_repay_record_ref` t1
JOIN all_back_0531.`offline_alipay_record` t2 ON t1.repay_channel = 13
AND t1.record_id = t2.id
JOIN all_back_0531.`user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN all_back_0531.funding_repayment_record t4 ON t4.ref_id = t3.ref_id
AND t4.term_no = t3.term_no
JOIN all_back_0531.loan_manifest t5 ON t3.ref_id = t5.ref_id
JOIN temp.loan_class t6 ON t5.ref_id = t6.ref_id
WHERE
    t6.class='%s' AND t3.fund_code = %s
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
	 AND t4.deadline>='%s'
	 AND t4.deadline<'%s'
AND t2.transfer_time < '%s' AND t2.transfer_time<t4.deadline
)
"""

sql_query_advance_settle_plan_id = """
SELECT
	t3.id plan_id
FROM
	all_back_0531.`xjd_repay_plan_repay_record_ref` t1
JOIN all_back_0531.`user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN all_back_0531.loan_manifest t5 ON t3.ref_id = t5.ref_id
JOIN temp.loan_class t6 ON t5.ref_id = t6.ref_id
WHERE
    t6.class='%s' AND t3.fund_code = %s
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s'
AND t3.xyqb_repaid_at < '%s'
AND t3.xyqb_repaid_at <= t3.deadline AND t3.deadline>='%s'
AND t3.ref_id IN (
	SELECT
		t3.ref_id
	FROM
		all_back_0531.`xjd_repay_plan_repay_record_ref` t1
	JOIN all_back_0531.`user_repayment_plan` t3 ON t1.plan_id = t3.id
	JOIN all_back_0531.loan_manifest t5 ON t3.ref_id = t5.ref_id
	AND t3.term_no = t5.contract_term
	WHERE
		t3.fund_code = %s
	AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
	AND t3.xyqb_repaid_at < '%s'
	AND t3.xyqb_repaid_at <= t3.deadline
);
"""

sql_query_advance_settle = """
SELECT
	t3.id plan_id,
	t3.ref_id,
	DATE(t3.xyqb_repaid_at) repaid_at,
	DATE(t4.deadline) deadline,
	t1.repay_channel,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(
		t1.`principle` - t1.`mitigate_principle` + t1.`interest` - t1.`mitigate_interest`
	) real_principle
FROM
	all_back_0531.`xjd_repay_plan_repay_record_ref` t1
JOIN all_back_0531.`repay_record_online` t2 ON t1.repay_channel < 13
AND t1.record_id = t2.id
JOIN all_back_0531.`user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN all_back_0531.funding_repayment_record t4 ON t4.ref_id = t3.ref_id
AND t4.term_no = t3.term_no
JOIN all_back_0531.loan_manifest t5 ON t3.ref_id = t5.ref_id
JOIN temp.loan_class t6 ON t5.ref_id = t6.ref_id
WHERE
    t6.class='%s' AND 	t3.fund_code = %s  AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s' AND 	t3.id IN %s
"""


def hr_table(fund_code, fund_name, loan_class):
    df_plan = pd.read_sql(sql_fund_hk_hr % (loan_class,
                                            fund_code, start_time_loanPaidAt, end_time_loanPaidAt, start_time_deadline,
                                            end_time_deadline),
                          con=engine_financial)
    df_plan.fillna(0, inplace=True)
    df_plan['day_hk'] = pd.to_datetime(df_plan['day_hk']).apply(lambda x: x.date())
    df_plan['repay_channel'] = 2

    df_zc = pd.read_sql(sql_hk_fund_deadline_online_normal_hr_5 % (
        loan_class, fund_code, start_time_loanPaidAt, end_time_loanPaidAt, start_time_deadline, end_time_deadline,
        start_time_deadline, end_time_deadline,
        loan_class, fund_code, start_time_loanPaidAt, end_time_loanPaidAt, start_time_deadline, end_time_deadline,
        start_time_deadline, end_time_deadline),
                        con=engine_financial)
    df_zc['repaid_at'] = pd.to_datetime(df_zc['repaid_at']).apply(lambda x: x.date())
    df_zc['deadline'] = pd.to_datetime(df_zc['deadline']).apply(lambda x: x.date())
    df_zc['fund_code'] = df_zc['fund_code'].astype(int)
    df_zc['fund_name'] = fund_name
    df_zc.fillna(0, inplace=True)
    df_zc = df_zc.ix[df_zc['repaid_at'] == df_zc['deadline']]
    df_zc = df_zc.groupby(by=['repaid_at', 'repay_channel'])['real_principle'].sum()
    df_zc = df_zc.to_frame()
    df_zc.reset_index(inplace=True)
    df_zc.rename(columns={'repaid_at': 'day_hk', 'real_principle': 'zc_prin_inst_total'}, inplace=True)
    df_zc['day_hk'] = pd.to_datetime(df_zc['day_hk']).apply(lambda x: x.date())

    df_yq = pd.read_sql(sql_hk_fund_deadline_online_overdue_hr_5 % (loan_class,
                                                                    fund_code, start_time_loanPaidAt,
                                                                    end_time_loanPaidAt, start_time_deadline,
                                                                    end_time_deadline, loan_class, fund_code,
                                                                    start_time_loanPaidAt, end_time_loanPaidAt,
                                                                    start_time_deadline, end_time_deadline),
                        con=engine_financial)
    df_yq['repaid_at'] = pd.to_datetime(df_yq['repaid_at']).apply(lambda x: x.date())
    df_yq['deadline'] = pd.to_datetime(df_yq['deadline']).apply(lambda x: x.date())
    df_yq['fund_code'] = df_yq['fund_code'].astype(int)
    df_yq['fund_name'] = fund_name
    df_yq.fillna(0, inplace=True)

    df_yq = df_yq.ix[df_yq['deadline'] < df_yq['repaid_at']]
    df_yq = df_yq.groupby(by=['repaid_at', 'repay_channel'])['real_principle'].sum()
    df_yq = df_yq.to_frame()
    df_yq.reset_index(inplace=True)
    df_yq.rename(columns={'repaid_at': 'day_hk', 'real_principle': 'yq_prin_inst_total'}, inplace=True)
    df_yq['day_hk'] = pd.to_datetime(df_yq['day_hk']).apply(lambda x: x.date())

    df_tq = pd.read_sql(sql_hk_fund_deadline_online_advance_hr_5 % (loan_class,
                                                                    fund_code, start_time_loanPaidAt,
                                                                    end_time_loanPaidAt, start_time_deadline,
                                                                    end_time_deadline,
                                                                    end_time_deadline,
                                                                    loan_class, fund_code, start_time_loanPaidAt,
                                                                    end_time_loanPaidAt, start_time_deadline,
                                                                    end_time_deadline,
                                                                    end_time_deadline),
                        con=engine_financial)
    df_tq['repaid_at'] = pd.to_datetime(df_tq['repaid_at']).apply(lambda x: x.date())
    df_tq['deadline'] = pd.to_datetime(df_tq['deadline']).apply(lambda x: x.date())
    df_tq['fund_code'] = df_tq['fund_code'].astype(int)
    df_tq['fund_name'] = fund_name
    df_tq.fillna(0, inplace=True)

    df_hk = pd.concat([df_yq, df_zc, df_tq], ignore_index=True)
    df_advance_plan_id = pd.read_sql(
        sql_query_advance_settle_plan_id % (loan_class,
                                            fund_code, start_time_loanPaidAt, end_time_loanPaidAt, start_time_deadline,
                                            end_time_deadline,
                                            start_time_deadline, fund_code, start_time_loanPaidAt, end_time_loanPaidAt,
                                            end_time_deadline),
        con=engine_financial)
    advance_planid_list = df_advance_plan_id['plan_id'].tolist()
    advance_planid_set = set(advance_planid_list)

    advance_planid_list = map(int, advance_planid_list)
    df_tq_settle = pd.read_sql(sql_query_advance_settle % (loan_class,
                                                           fund_code, start_time_loanPaidAt, end_time_loanPaidAt,
                                                           str(tuple(advance_planid_list))),
                               con=engine_financial)
    df_tq_settle_max_deadline = df_tq_settle.groupby(by=['ref_id'])['repaid_at'].agg(['max']).reset_index().rename(
        columns={'max': 'max_repaid_at'})
    df_tq_settle_max_deadline.reset_index(inplace=True)
    df_tq_settle_max_deadline['max_repaid_at'] = pd.to_datetime(df_tq_settle_max_deadline['max_repaid_at']).apply(
        lambda x: x.date())

    df_tq_settle = pd.merge(df_tq_settle, df_tq_settle_max_deadline, how='left', on=['ref_id'])
    df_tq_settle_leak = df_tq_settle.ix[df_tq_settle.max_repaid_at < datetime.date(2017, 5, 1)]
    df_tq_settle_leak.drop(['max_repaid_at'], inplace=True, axis=1)

    df_tq_settle = df_tq_settle.ix[df_tq_settle.max_repaid_at >= datetime.date(2017, 5, 1)]
    df_tq_settle.drop(['repaid_at'], inplace=True, axis=1)
    df_tq_settle.rename(columns={'deadline': 'repaid_at'}, inplace=True)
    df_tq_settle.rename(columns={'max_repaid_at': 'deadline'}, inplace=True)

    df_tq_no_settle = df_tq[~df_tq.plan_id.isin(advance_planid_set)]
    df_tq = pd.concat([df_tq_no_settle, df_tq_settle, df_tq_settle_leak], ignore_index=True)
    df_tq = df_tq.groupby(by=['deadline', 'repay_channel'])['real_principle'].sum()
    df_tq = df_tq.to_frame()
    df_tq.reset_index(inplace=True)
    df_tq['deadline'] = pd.to_datetime(df_tq['deadline']).apply(lambda x: x.date())
    df_tq.rename(columns={'deadline': 'day_hk', 'real_principle': 'tq_prin_inst_total'}, inplace=True)
    df_tq['repay_channel'] = df_tq['repay_channel'].astype(int)

    df_hk_new = pd.merge(df_zc, df_yq, how='outer', on=['day_hk', 'repay_channel'])
    df_hk_new = pd.merge(df_hk_new, df_tq, how='outer', on=['day_hk', 'repay_channel'])
    df_hk_new = pd.merge(df_plan, df_hk_new, how='outer', on=['day_hk', 'repay_channel'])
    df_hk_new.fillna(0, inplace=True)
    df_hk_new = pd.merge(df_hk_new, df_repay_channel, on=['repay_channel'], how='left')
    df_hk_new['real_all'] = df_hk_new['zc_prin_inst_total'] + df_hk_new['tq_prin_inst_total'] + df_hk_new[
        'yq_prin_inst_total']
    df_hk_new['fund_name'] = fund_name
    df_hk_new['loan_class'] = loan_class
    df_hk_new = df_hk_new[
        ['fund_name', 'day_hk', 'repay_channel', 'channel_name', 'plan_all', 'real_all', 'zc_prin_inst_total',
         'tq_prin_inst_total', 'yq_prin_inst_total', 'loan_class']]
    df_hk_new.rename(
        columns={'day_hk': u'还款日期', 'repay_channel': u'还款账户', 'plan_all': u'应还资金方本息', 'real_all': u'客户实还本息',
                 'zc_prin_inst_total': u'客户正常还款本息', 'yq_prin_inst_total': u'客户逾期还款本息',
                 'tq_prin_inst_total': u'客户提前还款本息', 'loan_class': u'客户等级'},
        inplace=True)
    df_hk_new.to_excel(path + str(fund_code) + '_' + loan_class + '.xlsx', index=None, columns=df_hk_new.columns,
                       encoding='utf8')


# =======================================================================================================================================
loan_class_list = ['A', 'B', 'C']
if __name__ == '__main__':
    # for index, row in df_fund.iterrows():
    #     for loan_class_ in loan_class_list:
    #         fund_code = int(row['fund_code'])
    #         fund_name = row['fund_name']
    #         print '------begin---', fund_name
    #         hr_table(fund_code, fund_name, loan_class_)
    excel_out = pd.ExcelWriter(path + 'all.xlsx')
    df_out = pd.DataFrame()
    for file in os.listdir(path):
        tmp_file = file.replace('.xlsx', '')
        if tmp_file in ['160', '200', '290'] > 0:
            df_tmp = pd.read_excel(path + file)
            df_tmp.to_excel(excel_out, sheet_name=tmp_file, columns=df_tmp.columns, index=None, encoding='utf8')
        elif tmp_file == 'all':
            continue
        else:
            df_out = df_out.append(pd.read_excel(path + file))
    df_out.to_excel(excel_out, sheet_name='sheet1', columns=df_out.columns, index=None, encoding='utf8')
    excel_out.save()
    # ============= 合并文件 end=============

print '=====================main done======================'
