# -*- encoding: utf8 -*-

"""
目标：
    收入确认表-以loan_id为维度比较风险金及客户实还服务费
数据库：

字段名：
    loan_id，资金方，风险等级，本金债权，放款日期，计提风险金比例，计提风险金，实还服务费（减免后，含一次性服务费），Asset余额，收入确认金额
注意：
    加入一次性服务费，计提风险金比例
    15,16年用430库，17年1-6月用630库，7月用731库
    新马上还款、阳光徽商还款单独一张表
"""

import os

import datetime
import numpy as np
import pandas as pd

from db_con.db_connect import sql_engine

pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)

res_sum = []


def proc_save(watch_date):
    loan = df_loan_ratio.loc[df_loan_ratio[u'放款日期'] < watch_date]
    loan.loc[~loan.is_active.isin([1, -2]), u'本金债权'] = 0

    loan_other = loan.loc[~loan[u'funding_code'].isin([160, 340])]
    loan_ms = loan.loc[loan[u'funding_code'] == 160]
    loan_yghs = loan.loc[loan[u'funding_code'] == 340]

    loan_other_unique = loan_other[loan_col]
    loan_ms_unique = loan_ms[loan_col]
    loan_yghs_unique = loan_yghs[loan_col]

    ref = df_ref.loc[df_ref.repaid_at < watch_date]
    gp_other = ref.groupby('ref_id')[u'实还服务费（减免后）'].agg(sum).reset_index()
    loan_other_result = pd.merge(loan_other_unique, gp_other, how='left')
    loan_other_result.fillna(0, inplace=True)
    loan_result = loan_other_result

    print('非新马上: %f' % (loan_result[u'实还服务费（减免后）'].sum(),))
    ms = df_ms.loc[df_ms.repaid_at < watch_date]
    if len(ms) > 0:
        gp_ms = ms.groupby('loan_id')[u'实还服务费（减免后）'].agg(sum).reset_index()
        loan_ms_result = pd.merge(loan_ms_unique, gp_ms, how='left')
        loan_ms_result.fillna(0, inplace=True)
        print('新马上: %f' % (loan_ms_result[u'实还服务费（减免后）'].sum(),))
        loan_result = loan_result.append(loan_ms_result)
    else:
        loan_ms_unique[u'实还服务费（减免后）'] = 0
        loan_result = loan_result.append(loan_ms_unique)

    yghs = df_yghs.loc[df_yghs.repaid_at < watch_date]
    if len(yghs) > 0:
        gp_yghs = yghs.groupby('ref_id')[u'实还服务费（减免后）'].agg(sum).reset_index()
        loan_yghs_result = pd.merge(loan_yghs_unique, gp_yghs, how='left')
        loan_yghs_result.fillna(0, inplace=True)
        print('阳光徽商: %f' % (loan_yghs_result[u'实还服务费（减免后）'].sum(),))
        loan_result = loan_result.append(loan_yghs_result)
    else:
        loan_yghs_unique[u'实还服务费（减免后）'] = 0
        loan_result = loan_result.append(loan_yghs_unique)

    dj = df_dunjiao.loc[df_dunjiao.repaid_at < watch_date, [u'ref_id', u'趸交服务费']]
    if len(dj) > 0:
        loan_result = pd.merge(loan_result, dj, on='ref_id', how='left')
        loan_result.fillna(0, inplace=True)
    else:
        loan_result[u'趸交服务费'] = 0
    print('趸交服务费: %f' % (loan_result[u'趸交服务费'].sum(),))
    loan_result[u'计提风险金'] = np.round(loan_result[u'本金债权'] * loan_result[u'计提风险金比例'], 2)
    loan_result.loc[loan_result.funding_code.isin([270, 310, 320, 410]), u'计提风险金'] = 0

    loan_result[u'实还服务费（减免后、含一次性服务费、趸交服务费）'] = np.round(
        loan_result[u'实还服务费（减免后）'] + loan_result[u'qg_one_time_service_fee'] + loan_result[u'趸交服务费'], 2)
    loan_result[u'asset余额'] = np.maximum(np.round(loan_result[u'计提风险金'] - loan_result[u'实还服务费（减免后、含一次性服务费、趸交服务费）'], 2),
                                         0)
    loan_result[u'收入确认金额'] = np.minimum(np.round(loan_result[u'计提风险金'] - loan_result[u'实还服务费（减免后、含一次性服务费、趸交服务费）'], 2),
                                        0)
    print(
        loan_result[
            [u'本金债权', u'计提风险金', u'qg_one_time_service_fee', u'实还服务费（减免后）', u'趸交服务费', u'实还服务费（减免后、含一次性服务费、趸交服务费）',
             u'asset余额',
             u'收入确认金额']].sum())
    tmp_sum = loan_result[
        [u'本金债权', u'计提风险金', u'qg_one_time_service_fee', u'实还服务费（减免后）', u'趸交服务费', u'实还服务费（减免后、含一次性服务费、趸交服务费）',
         u'asset余额',
         u'收入确认金额']].sum().to_frame().T
    # tmp_sum = loan_result.groupby(u'风险等级')[
    #     [u'本金债权', u'计提风险金', u'qg_one_time_service_fee', u'实还服务费（减免后）', u'趸交服务费', u'实还服务费（减免后、含一次性服务费、趸交服务费）',
    #      u'asset余额', u'收入确认金额']].agg('sum').reset_index()
    tmp_sum[u'截止时间'] = watch_date
    res_sum.append(tmp_sum)

    loan_result = loan_result[res_cols]
    # loan_result.to_csv(os.path.join(file_path, u'%s(%s-%02d).csv' % (file_name, watch_date.year, watch_date.month - 1)),
    #                    index=None, encoding='utf8')
    if len(loan_result) > max_limit:
        for i in xrange(0, len(loan_result), max_limit):
            loan_result[i:i + max_limit].to_csv(os.path.join(file_path, u'%s(%s-%02d)-%d.csv' % (
                file_name, watch_date.year, watch_date.month - 1, i / max_limit + 1)), index=None, encoding='utf8')


# ----------------------------------------------

if __name__ == '__main__':
    step = 10000
    max_limit = 900000
    file_path = u'E:/审计出表/现金贷/1021'
    file_name = u'现金贷收入确认表'
    if not os.path.exists(file_path):
        os.makedirs(file_path)
    mysql = sql_engine('audit', 'audit').get_engine()
    loan_col = [u'loan_id', u'ref_id', u'风险等级', u'funding_code', u'资金方', u'is_active', u'本金债权',
                u'qg_one_time_service_fee', u'放款日期', u'计提风险金比例']
    res_cols = [u'loan_id', u'风险等级', u'资金方', u'本金债权', u'qg_one_time_service_fee', u'放款日期', u'计提风险金比例', u'计提风险金',
                u'实还服务费（减免后）', u'趸交服务费', u'实还服务费（减免后、含一次性服务费、趸交服务费）', u'asset余额', u'收入确认金额']

    sql_ratio = 'SELECT class 风险等级, year 年, month 月, bad_debt_ratio 计提风险金比例 FROM test_mzh.service_fee_ratio'
    df_ratio = pd.read_sql(sql=sql_ratio, con=mysql)

    df_ms = pd.read_csv(os.path.join(file_path, 'ms.csv'), encoding='utf8', low_memory=False)
    df_yghs = pd.read_csv(os.path.join(file_path, 'yghs.csv'), encoding='utf8', low_memory=False)
    df_dunjiao = pd.read_csv(os.path.join(file_path, 'dunjiao.csv'), encoding='utf8', low_memory=False)
    df_ms[u'repaid_at'] = pd.to_datetime(df_ms[u'repaid_at']).dt.date
    df_yghs[u'repaid_at'] = pd.to_datetime(df_yghs[u'repaid_at']).dt.date
    df_dunjiao[u'repaid_at'] = pd.to_datetime(df_dunjiao[u'repaid_at']).dt.date
    df_ms.loan_id = df_ms.loan_id.astype(str)

    db_names = ['all_back_0630', 'all_back_0731', 'all_back_0831', 'new_transaction']
    date_report_list = [
        [datetime.date(2017, 2, 1), datetime.date(2017, 3, 1), datetime.date(2017, 4, 1), datetime.date(2017, 5, 1),
         datetime.date(2017, 6, 1), datetime.date(2017, 7, 1)],
        [datetime.date(2017, 8, 1)],
        [datetime.date(2017, 9, 1)],
        [datetime.date(2017, 10, 1)]]
    # db_names = ['new_transaction',]
    # date_report_list = [[datetime.date(2017, 10, 1)],]
    for i in xrange(len(db_names)):
        db_name = db_names[i]
        date_list = date_report_list[i]

        # #######################
        # 查文件
        df_loan = pd.read_csv(os.path.join(file_path, 'all_loan_%s.csv' % db_name), encoding='utf8', low_memory=False)
        df_ref = pd.read_csv(os.path.join(file_path, 'all_ref_%s.txt' % db_name), sep='\t', low_memory=False)
        df_ref.columns = [u'ref_id', u'实还总额', u'实还本金', u'实还利息', u'实还服务费（减免后）', u'实还罚息', u'其他收益', u'repaid_at']

        df_loan[u'放款日期'] = pd.to_datetime(df_loan[u'放款日期']).dt.date
        df_loan.loc[df_loan[u'风险等级'] == 'D', u'风险等级'] = 'C'
        df_ref[u'repaid_at'] = pd.to_datetime(df_ref[u'repaid_at']).dt.date

        # #######################
        df_loan.loan_id = df_loan.loan_id.astype(str)

        df_loan_ratio = pd.merge(df_loan, df_ratio, on=[u'风险等级', u'年', u'月'], how='left')
        df_loan_ratio.loc[df_loan_ratio.funding_code.isin([270, 310, 320, 410]), u'计提风险金比例'] = 0

        for watch_date in date_list:
            print('{}, {}'.format(db_name, watch_date + datetime.timedelta(days=-1)))
            proc_save(watch_date)
    df_sum = pd.concat(res_sum)
    df_sum.to_excel(os.path.join(file_path, 'summary.xlsx'), index=None)
