# -*- encoding: utf8 -*-

"""
目标：
    现金贷还款表按还款月统计汇总
数据库：
    根据不同时段的需求，选取不同阶段的备份数据库
字段名：
    资金方，loan_id，放款期数，实还当期期数，应还款日，应还款金额，应还本金，应还利息，应还服务费，应还罚息（资金方），实还款日，收款账户，
    收款渠道流水号，实还金额，实还本金，实还利息，实还服务费，实还罚息，其他收益，减免金额，减免本金，减免利息，减免服务费，减免罚息，实还趸收服务费
注意：
    新造的表test_mzh.xjd_repay_plan_repay_record_ref_repay_date_flow包含还款时间和流水号
"""

import os

import datetime
import pandas as pd
import numpy as np
from db_con.db_connect import sql_engine
import multiprocessing as mtp

# ----------------------------------------------
pd.options.mode.chained_assignment = None
step = 10000
max_limit = 900000
file_path = u'E:/审计出表/现金贷'
file_name = u'现金贷还款表-明细表'
if not os.path.exists(file_path):
    os.makedirs(file_path)
mysql = sql_engine('audit', 'temp', False).get_engine()

# ----------------------------------------------