select
  t3.class,
  year(t1.loan_paid_at),
  month(t1.loan_paid_at),
  year(t2.deadline),
  month(t2.deadline),
  sum(t2.principle),
  sum(t2.interest)
from
  loan_manifest t1
  inner join user_repayment_plan t2
    on t1.ref_id = t2.ref_id
    and t1.is_active in (1, - 2)
    and t1.loan_paid_at < '2017-01-01'
  inner join loan_class t3
    on t1.ref_id = t3.ref_id
group by t3.class,
  date_format(t1.loan_paid_at, '%Y-%m'),
  year(t2.deadline),
  month(t2.deadline);




select
  t3.class,
  date_format(t1.loan_paid_at, '%Y-%m') loan_paid_at,
  date_format(t2.deadline, '%Y-%m') deadline,
  sum(t2.principle),
  sum(t2.interest) 
from
  loan_manifest t1 
  inner join user_repayment_plan t2 
    on t1.ref_id = t2.ref_id 
    and t1.is_active in (1, - 2) 
    and t1.loan_paid_at < '2017-01-01' 
  inner join loan_class t3 
    on t1.ref_id = t3.ref_id 
group by 1, 2, 3;