# -*- encoding: utf8 -*-

import pandas as pd
from sqlalchemy import create_engine
import numpy as np

pd.options.mode.chained_assignment = None

'''
1、ref_amount=  拆分后的本金+利息+服务费+罚息-所有的减免金额+remain_income
2、collection_relief= 减免本金+减免利息+减免服务费+减免罚息
3、collection_relief= 催收减免+红包减免
4、红包使用前提是 有减免 >0
5、如果红包使用了一半，则不使用红包，这种情况需要查看数据是什么原因造成的，
6、注意这个版本适用 201704之后的拆分，
'''

engine_audit = create_engine(
    'mysql+mysqldb://bo.wang:#mn89453YU9io80@172.16.3.201:3306/audit_temp?charset=utf8', echo=True)

chunksize = 5000


sql_update = """
    update audit_temp.xjd_repay_plan_repay_record_ref set principle = %s, interest = %s, service_fee = %s, punish = %s, collection_relief = %s, remain_income = %s,
    mitigate_principle = %s, mitigate_interest = %s, mitigate_service_fee = %s, mitigate_collection_relief = %s,red_package_fee=%s,mitigate_all=%s where id = %s
    """
columns = ['id', 'plan_id', 'ref_amount', 'principle', 'interest', 'service_fee', 'should_punish', 'red_package_fee',
           'repay_status','re_principle', 're_interest', 're_service_fee', 're_punish', 're_relief', 're_remain',
           'mitigate_prin', 'mitigate_inst', 'mitigate_fee', 'mitigate_punish', 'mitigate_all']
up_columns = ['re_principle', 're_interest', 're_service_fee', 're_punish', 're_relief', 're_remain', 'mitigate_prin',
              'mitigate_inst', 'mitigate_fee', 'mitigate_punish', 'red_package_fee', 'mitigate_all', 'id']


def split_money_3(df):
    df['re_principle'] = 0
    df['re_interest'] = 0
    df['re_service_fee'] = 0
    df['re_punish'] = 0
    df['re_relief'] = 0
    df['re_remain'] = 0
    df['mitigate_prin'] = 0
    df['mitigate_inst'] = 0
    df['mitigate_fee'] = 0
    df['mitigate_punish'] = 0
    df['red_package_fee'] = 0
    df['mitigate_all'] = 0

    left_prin = round(df['principle'].values[0], 2)
    left_inst = round(df['interest'].values[0], 2)
    left_fee = round(df['service_fee'].values[0], 2)
    left_punish = round(df['should_punish'].values[0], 2)
    left_red_packet = round(df['red_package'].values[0], 2)
    for index, row in df.iterrows():
        ref_amount = round(row['ref_amount'], 2)
        # 分配本金
        if left_prin > 0:
            if ref_amount <= left_prin:
                df.loc[index, 're_principle'] = ref_amount
                left_prin -= ref_amount
                continue
            else:
                df.loc[index, 're_principle'] = left_prin
                ref_amount -= left_prin
                left_prin = 0
        # 分配利息
        if left_inst > 0:
            if ref_amount <= left_inst:
                df.loc[index, 're_interest'] = ref_amount
                left_inst -= ref_amount
                continue
            else:
                df.loc[index, 're_interest'] = left_inst
                ref_amount -= left_inst
                left_inst = 0
        # 分配服务费
        if left_fee > 0:
            if ref_amount <= left_fee:
                df.loc[index, 're_service_fee'] = ref_amount
                left_fee -= ref_amount
                continue
            else:
                df.loc[index, 're_service_fee'] = left_fee
                ref_amount -= left_fee
                left_fee = 0
        # 分配罚息
        if left_punish > 0:
            if ref_amount <= left_punish:
                df.loc[index, 're_punish'] = ref_amount
                left_punish -= ref_amount
                continue
            else:
                df.loc[index, 're_punish'] = left_punish
                ref_amount -= left_punish
                left_punish = 0
        # 多出来的放到剩余金额里
        df.loc[index, 're_remain'] = ref_amount
    # 修改最后一条记录的金额
    df.loc[index, 're_principle'] = round(df['principle'].values[0], 2) - round(sum(df['re_principle'].values[:-1]), 2)
    df.loc[index, 're_interest'] = round(df['interest'].values[0], 2) - round(sum(df['re_interest'].values[:-1]), 2)
    df.loc[index, 're_service_fee'] = round(df['service_fee'].values[0], 2) - round(
        sum(df['re_service_fee'].values[:-1]), 2)
    df.loc[index, 're_punish'] = round(df['should_punish'].values[0], 2) - round(sum(df['re_punish'].values[:-1]), 2)
    sum_amount = df.loc[index, 're_principle'] + df.loc[index, 're_interest'] + df.loc[index, 're_service_fee'] + \
                 df.loc[index, 're_punish']

    sum_prin = sum(df['re_principle'])
    sum_inst = sum(df['re_interest'])
    sum_fee = sum(df['re_service_fee'])
    sum_punish = sum(df['re_punish'])
    sum_total = sum(df['ref_amount'])
    if sum_amount > df.loc[index, 'ref_amount']:  # 有减免
        df.loc[index, 're_relief'] = round(sum_amount - df.loc[index, 'ref_amount'], 2)
        df.loc[index, 'mitigate_prin'] = round(max(sum_prin - sum_total, 0), 2)
        df.loc[index, 'mitigate_inst'] = round(max(sum_prin + sum_inst - df.loc[index, 'mitigate_prin'] - sum_total, 0),
                                               2)
        df.loc[index, 'mitigate_fee'] = round(max(
            sum_prin + sum_inst + sum_fee - df.loc[index, 'mitigate_prin'] - df.loc[index, 'mitigate_inst'] - sum_total,
            0), 2)
        df.loc[index, 'mitigate_punish'] = round(max(
            sum_prin + sum_inst + sum_fee + sum_punish - df.loc[index, 'mitigate_prin'] - df.loc[
                index, 'mitigate_inst'] - df.loc[index, 'mitigate_fee'] - sum_total, 0), 2)
        df.loc[index, 're_remain'] = 0
        # 红包 使用前提有减免
        if df.loc[index, 're_relief'] > 0:
            if df.loc[index, 're_relief'] < left_red_packet:
                df.loc[index, 'red_package_fee'] = 0
            else:
                df.loc[index, 'red_package_fee'] = left_red_packet
        df.loc[index, 'mitigate_all'] = df.loc[index, 'mitigate_prin'] + df.loc[index, 'mitigate_inst'] + df.loc[index, 'mitigate_fee'] + df.loc[index, 'mitigate_punish'] - df.loc[index, 'red_package_fee']
    elif sum_amount < df.loc[index, 'ref_amount']:  # 没有减免
        df.loc[index, 're_relief'] = 0
        df.loc[index, 're_remain'] = round(df.loc[index, 'ref_amount'] - sum_amount, 2)
    else:  # 没有减免
        df.loc[index, 're_relief'] = 0
        df.loc[index, 're_remain'] = 0
    return df


def split_money_0(df):
    df['re_principle'] = 0
    df['re_interest'] = 0
    df['re_service_fee'] = 0
    df['re_punish'] = 0
    df['re_relief'] = 0
    df['re_remain'] = 0

    left_prin = round(df['principle'].values[0], 2)
    left_inst = round(df['interest'].values[0], 2)
    left_fee = round(df['service_fee'].values[0], 2)
    left_punish = round(df['should_punish'].values[0], 2)
    for index, row in df.iterrows():
        ref_amount = round(row['ref_amount'], 2)
        # 分配本金
        if left_prin > 0:
            if ref_amount <= left_prin:
                df.loc[index, 're_principle'] = ref_amount
                left_prin -= ref_amount
                continue
            else:
                df.loc[index, 're_principle'] = left_prin
                ref_amount -= left_prin
                left_prin = 0
        # 分配利息
        if left_inst > 0:
            if ref_amount <= left_inst:
                df.loc[index, 're_interest'] = ref_amount
                left_inst -= ref_amount
                continue
            else:
                df.loc[index, 're_interest'] = left_inst
                ref_amount -= left_inst
                left_inst = 0
        # 分配服务费
        if left_fee > 0:
            if ref_amount <= left_fee:
                df.loc[index, 're_service_fee'] = ref_amount
                left_fee -= ref_amount
                continue
            else:
                df.loc[index, 're_service_fee'] = left_fee
                ref_amount -= left_fee
                left_fee = 0
        # 分配罚息
        if left_punish > 0:
            if ref_amount <= left_punish:
                df.loc[index, 're_punish'] = ref_amount
                left_punish -= ref_amount
                continue
            else:
                df.loc[index, 're_punish'] = left_punish
                ref_amount -= left_punish
                left_punish = 0
        # 多出来的放到剩余金额里
        df.loc[index, 're_remain'] = ref_amount
    return df




# 注意退款的情况
# sql_xjd_ref = '''select id, plan_id, ref_amount from xjd_repay_plan_repay_record_ref where plan_id in %s and ref_amount > 0 '''

sql_xjd_ref = '''SELECT
	t1.id,
	t1.plan_id,
	t1.ref_amount
FROM
	xjd_repay_plan_repay_record_ref t1
JOIN audit_temp.repay_record_online t2 ON t1.record_id = t2.id
AND t1.repay_channel = t2.pay_approach
WHERE
	plan_id IN % s
AND ref_amount > 0 ORDER BY t2.bill_time ASC '''

sql_user_repayment_plan = '''
select id plan_id, ref_id,term_no,principle, interest, service_fee, should_punish ,repay_status,xyqb_repaid_at from audit_temp.user_repayment_plan where id in %s
'''
#红包数据
sql3 = """
select ref_id,term_no,amount red_amount from audit_temp.red_packet_detail where ref_id in %s
"""

# df_plan_id = pd.read_csv(u"""C:\\Users\\wangbo\\Desktop\\十月份对账\\new_ref.csv""",encoding="utf-8")
sql_query_plan_id = """
SELECT plan_id FROM audit_temp.xjd_repay_plan_repay_record_ref WHERE plan_id in (10039037, 10694181, 10700157, 12245805, 12297185, 9021491, 10985727, 11051525, 9054701, 12285509, 10581947, 10764473, 12267875, 11004579, 11534811, 10863279, 11273013, 9703619, 11384127, 12418929, 12239919, 10241951, 9784037, 9707843, 12234615, 12180399, 11169969, 11398241, 9781415, 10936425, 10795695, 11393019, 11543751, 11511417, 11221011, 10767819, 10970919, 11110473, 11318793, 11389401, 11317557, 10861373, 10628207, 9316277, 9992597, 11025681, 11454219, 10768347, 10241867, 11398143, 10532279, 10774275, 11317733, 9635789, 12424761, 10775241, 11398509, 10761621, 10851153, 10573595, 9336653, 11261001, 10926993, 10798359, 10800071, 12243333, 11463915, 11317983, 11210193, 12179127, 10901145, 11526459, 12272373, 10561379, 10496099, 9614159, 9352421, 11301897, 10025279, 10911401, 10978599, 10901415, 12302019, 10584467, 12371757, 10766637, 11390283, 11444925, 10793403, 9012809, 10754289, 11279637, 11460705, 12447003, 11553837, 11311383, 11328009, 11380061, 10793415, 11383607, 10833267, 10800873, 12226989, 11410191, 11461095, 12264741, 11315153, 10970913, 10940169, 9352643, 11424975, 12359037, 9346139, 9856829, 12232815, 11316423, 10956555, 11389989, 11049687, 12348219, 10875501, 10798293, 11523027, 11164737, 10696041, 11104611, 12307875, 9799349, 10799715, 10785255, 11622245, 10754283, 10279577, 12249825, 11317179, 11513703, 12300789, 10893201, 10794855, 12451149, 9280091, 9317981, 12178659, 9351635, 12448305, 9712487, 12416963, 9584483, 9871697, 12233649, 10792215, 12236487, 10992495, 10879383, 10932357, 10884777, 12294861, 9351005, 11319435, 12238947, 11552223, 11388483, 12308073, 12374211, 10244603, 11391609, 12343689, 10984865, 10755537, 11329479, 10772693, 10774239, 11331777, 11315679, 11398575, 11400849, 11400927, 11270901, 11157935, 9573479, 9689291, 10754169, 11197149, 9346481, 11394921, 10937967, 10760145, 12236031, 12302325, 11385165, 10796259, 10828911, 10763871, 12223293, 12223887, 12338805, 12224415, 12257877, 10506851, 9360407, 11130363, 10017143, 12245313, 11410569, 10789167, 11379831, 10758819, 10857129, 11381607, 9366647, 10694343, 10694193, 12217863, 12251289, 12284265, 12235089, 12333771, 9352175, 12235857, 10892769, 10810989, 11319477, 12236877, 10778979, 12221879, 9639773, 10940567, 10766871, 10924833, 11024343, 10592735, 10694651, 11317329, 11007521, 10761989, 10502741, 10716141, 10929423, 11208213, 10504037, 9849167, 12373287, 10770299, 11393163, 10557911, 12313761, 12233325, 12217311, 9859325, 10695741, 12237003, 11107665, 9633395, 10076513, 9880877, 10766855, 11455485, 12230145, 10757295, 12234255, 12237525, 12237843, 10763805, 12218487, 10244411, 11387493, 10888359, 12220125, 9348899, 10757919, 12217515, 10784361, 11534577, 11272203, 10436645, 9748895, 12353829, 11551005, 10502465, 9781607, 9093773, 9028277, 11273427, 11568573, 12240309, 12273057, 10421723, 12240345, 11552217, 12240333, 12240327, 11519343, 11126139, 10766063, 9783173, 10962909, 11519847, 10258289, 9046175, 11258265, 11209109, 9734621, 10717647, 10504511, 9849131, 9767609, 9358121, 12274533, 9768125, 11324625, 13339659, 9768023, 13110285, 12602409, 9325955, 12520863, 8998313, 9588167, 9768233, 12225917, 9768515, 9768575, 9768875, 11292615, 9752393, 11243685, 10801335, 10801341, 9752699, 9769247, 10047755, 11260593, 9736847, 11276943, 10769147, 11424687, 9065231, 10474349, 11424939, 11130047, 9360569, 11064465, 11064573, 12522585, 12325953, 10884551, 9852395, 9803039, 9770339, 9098801, 10573721, 10246109, 11212785, 11016147, 11212557, 10491671, 11278149, 10901643, 9738425, 10574057, 10901541, 10573841, 9541727, 11393093, 9722267, 10508741, 9722207, 9362051, 9362075, 9362105, 9542147, 10017335, 9346025, 9346037, 11049831, 11049801, 12426285, 11541549, 11050083, 10034255, 11246709, 9346175, 11541945, 9723293, 9526607, 12180819, 10723005, 11296503, 11148861, 9346655, 11279943, 11460495, 10723221, 9773021, 10477541, 12345173, 11264187, 12574929, 11149737, 11559213, 10494617, 9019961, 9790451, 11150187, 9364313, 11281413, 9921947, 11249079, 11560431, 9070061, 11281863, 10528217, 9348395, 9348425, 10036817, 9725567, 10987497, 10987323, 11544729, 11315357, 10479653, 10463651, 9333095, 13543737, 12348105, 10512923, 9022343, 9382823, 9776063, 9349913, 12561189, 9759581, 11316401, 11234433, 12217599, 11267079, 11561985, 10939419, 9776429, 11284155, 10776201, 11316893, 9776885, 11562699, 12234323, 9777041, 9334685, 10743699, 10694555, 11235309, 9334727, 11284287, 10776321, 10776429, 11088045, 9122021, 9728015, 11087967, 11547021, 11088177, 11088201, 11088195, 9318755, 9335165, 9777815, 12235505, 10777191, 11563905, 10695659, 12350247, 10712193, 10024097, 11400429, 11400417, 12563679, 11252949, 9090467, 9434531, 10958319, 9057749, 10958295, 11253213, 11400459, 11400477, 10253681, 9713369, 8992265, 10696205, 9713219, 11466639, 10696487, 11581209, 11253609, 12449631, 12351303, 12302517, 11319525, 11319549, 12449829, 12302463, 10729599, 10565723, 11385269, 10533359, 11565369, 12302637, 9779459, 11073819, 12204369, 12450129, 11631293, 10025639, 12352083, 11172855, 9042731, 9780077, 9780377, 12565647, 9354443, 9354491, 10877973, 9354347, 13336047, 9747791, 11255133, 9780587, 10960635, 11025933, 11484789, 8994761, 10043375, 11026209, 11484933, 10764375, 10765587, 9848735, 11389035, 10864899, 10800177, 12259617, 12341591, 11014875, 10834869, 11391879, 10769205, 11392485, 12343467, 10836567, 10886217, 13524381, 10854099, 11542335, 11378889, 11149365, 11396235, 12281469, 9349079, 9350675, 10874793, 10334441, 9744695, 10762209, 9713759, 10762743, 10762935, 10795995, 10763409, 10763505, 12549567, 11174127, 10928163, 10584437, 11109309, 11421831, 9357383, 10832181, 13536375, 10800579, 10572269, 10834593, 10818477, 11408229, 12342447, 10818561, 12227967, 12228261, 13538937, 12228489, 9344825, 12228915, 10820331, 12230013, 10821783, 12264687, 10790361, 10905219, 9349037, 11315391, 10840545, 11315463, 11315847, 11315745, 10759239, 11316291, 10760175, 11382747, 11317425, 10760385, 10793847, 11318403, 10761363, 13530369, 11171793, 10763343, 11370663, 11174055, 10534919, 9060737, 9847043, 11174151, 9732455, 9732461, 9634451, 9831053, 12321525, 11174415, 11616843, 9339833, 10060595, 10863387, 9995075, 12403865, 10454099, 11126421, 9750221, 11126355, 11405219, 10717047, 9324791, 9341045, 9472463, 13338951, 10717491, 9111839, 12241173, 9734843, 9112301, 10537487, 10537571, 9112175, 10832795, 11520975, 10537925, 10537739, 10062701, 11520855, 9407621, 9538691, 9079973, 9358397, 10439717, 10538399, 11275563, 11341077, 12783495, 10391741, 10539143, 13340805, 11112699, 11112657, 10457741, 10064639, 10048025, 10408535, 13390353, 9786341, 9753575, 12342059, 9819305, 9557201, 10064945, 13554813, 9360803, 9360851, 9688385, 11408711, 9541121, 10262081, 11212707, 10557377, 10754015, 10475705, 12556521, 11213007, 10066331, 10246541, 9738677, 9738689, 9836843, 9066821, 10558103, 13114005, 10050065, 10394123, 9116207, 10902081, 9100217, 10754891, 12426435, 10525955, 11050257, 11050305, 11050335, 13147887, 9084599, 12426975, 10444529, 11345829, 12427173, 10805225, 9707285, 11378447, 9707309, 10756241, 10068143, 10510541, 10559489, 10543109, 10543223, 11460993, 11314101, 9823217, 11346795, 10576733, 9823289, 9085991, 10577333, 10003733, 10511627, 10839399, 9004373, 9348743, 10544849, 11380259, 10282535, 9840563, 10987515, 10987521, 10774553, 9709685, 10496069, 10070117, 9824639, 9398933, 9120455, 12544611, 10054271, 9906797, 10038167, 12463005, 10038191, 12364779, 12692391, 12266277, 12462855, 11578227, 9300821, 11332857, 9088277, 11497137, 10055417, 13741691, 10366547, 9334355, 9105401, 11366571, 10793183, 10579979, 9072701, 9121889, 10055987, 10400123, 10564325, 11088633, 9859781, 12546789, 11088675, 11088651, 11088645, 11449157, 11629733, 10613807, 12383277, 10056767, 9090545, 11613795, 9107027, 10516421, 11400999, 11401017, 13416291, 9713801, 9123935, 9828467, 13695411, 10549541, 9107771, 13531437, 12548655, 12597879, 9845333, 11385785, 9747407, 10533689, 12548943, 13515993, 12451071, 9010403, 10058987, 12450933, 10370129, 10616213, 9944561, 12451125, 11484543, 9846527, 11337657, 11026353, 12533607, 10404041, 10862967, 10798287, 11240565, 11471229, 13585749, 10768575, 12423633, 13685451, 9359915, 11015547, 9344615, 10770177, 12523557, 10771341, 12344499, 11394471, 11394465, 11395095, 11395545, 11395761, 11102205, 11397135, 10694081, 11006373, 10776993, 11497917, 12333759, 10892163, 10892235, 10892097, 10892511, 12563889, 9598427, 10892763, 12302091, 10877211, 12270093, 12450405, 9353813, 10877949, 10877895, 12238425, 10764501, 11387685, 11387715, 9352907, 11417787, 10754517, 10791453, 11316573, 9781421, 9781469, 10436861, 9830441, 9797729, 9781655, 11370885, 10502555, 11174199, 10469693, 11370843, 11174229, 11567787, 9765611, 9765503, 9782165, 10847153, 10863375, 9995063, 9782051, 9765935, 10961991, 11126205, 12535197, 11126151, 10716465, 10503479, 9782567, 12240561, 12240531, 9782969, 10045097, 12240633, 9766415, 10520075, 9766811, 10504127, 10504067, 9783209, 9766871, 9963515, 10733511, 12240699, 9783077, 9816209, 10504253, 9766955, 10504661, 9767171, 9767177, 9538235, 11291289, 9783977, 9783815, 11569707, 9538103, 11307551, 11520609, 9767843, 10046429, 9358313, 9653009, 12372765, 10505045, 9079937, 9768131, 9784349, 10046519, 10521713, 10734717, 10079621, 11308437, 12373449, 10505489, 9768275, 9768311, 10505561, 9768671, 9768647, 11112159, 11308563, 10506119, 11112447, 9768947, 10506017, 10506035, 11112297, 9768809, 10522787, 11112633, 11292861, 10801389, 10490051, 10047743, 10801347, 10506443, 11112669, 9769001, 9785447, 11112531, 9752975, 9769391, 9753077, 11292957, 10801431, 12374367, 10506569, 9753101, 12538403, 9769577, 10474403, 9753365, 9769745, 11408183, 9753401, 9786227, 11310237, 12326397, 11064681, 11064699, 12326643, 11556405, 11573223, 10049519, 12326697, 11311275, 11294859, 10901661, 10901745, 10475747, 10246151, 10573853, 9787481, 9656771, 9755123, 10246427, 9738575, 9542291, 9771743, 13163087, 9542195, 9788027, 10508891, 13048749, 9280349, 9772187, 9346211, 9772205, 11050107, 12426663, 10083755, 12180939, 12180843, 9789059, 11148801, 12426867, 12426819, 10035083, 9789353, 10051577, 10051337, 11575107, 11149497, 11460789, 11460837, 10510583, 13852767, 11345973, 9773105, 9330743, 12361731, 9773159, 9773165, 11002299, 11329941, 10035623, 10379735, 9298415, 11149779, 10510811, 11460879, 9773387, 11051729, 12362439, 9773597, 11313771, 11543151, 9773987, 11297769, 9773849, 9659171, 10036043, 9773891, 10839183, 10511501, 10839195, 10511603, 10839291, 10839261, 9774083, 9364505, 10511381, 11281905, 11298255, 9348581, 9692453, 10036865, 10512017, 10249925, 9348647, 10036787, 10512311, 10987449, 10790843, 10528739, 10495979, 10987365, 9774929, 9791297, 10512209, 10987359, 10741593, 10037399, 11331765, 10037441, 9332843, 9709691, 9054761, 10529363, 9350021, 9776039, 10759157, 9349919, 10480469, 9333587, 9775973, 9775979, 11250849, 9825461, 9776303, 11250705, 9546851, 9792935, 12365283, 10038551, 9776783, 10038947, 12562151, 11562507, 13626897, 10038893, 9334391, 10432397, 9809825, 10514369, 10252283, 12562301, 10514243, 10776609, 10514471, 9728387, 9335189, 9335207, 10514843, 9744815, 10039751, 9744869, 10400081, 10072445, 12546743, 11301561, 11088567, 11088525, 11629205, 10515191, 10023449, 9744917, 9040403, 9794111, 11235957, 10777155, 9859685, 9745001, 11334537, 9335735, 9352169, 9794555, 10515203, 9335633, 11088717, 10040189, 9335675, 10499273, 9073919, 10515569, 9778577, 11400699, 9532691, 10515749, 10777911, 11400861, 10516199, 9778925, 10516079, 11302521, 10516043, 11400789, 9778793, 9713615, 9730043, 9861089, 9778991, 9779039, 11302779, 9074537, 11286357, 10057859, 10434773, 9779453, 9779429, 9336839, 9795611, 9074735, 9074723, 9812057, 12450183, 11303319, 9779669, 9779675, 9779657, 10959297, 9779519, 10795295, 10516835, 11319675, 11188593, 9779579, 11319645, 11188917, 10500761, 11582163, 12450345, 10500635, 9763409, 10058309, 12450387, 10959441, 10500905, 12450591, 11467533, 10501325, 10877985, 9780299, 10959993, 10960305, 11304249, 11566347, 9780521, 10960545, 10960521, 11484915, 11026137, 11026143, 11173587, 10501745, 11288481, 9076625, 9781187, 10731321, 11026185, 9076559, 10518377, 10059641, 11026251, 12239085, 10862601, 10698765, 9028019, 11469519, 11126217, 11470521, 8980355, 9029705, 9357851, 10799937, 10800237, 10244243, 9015737, 9982241, 12178563, 10573025, 11081013, 11556111, 12178791, 9131765, 12277331, 9279611, 9345611, 11475885, 12180621, 9002315, 11116071, 12328737, 10772339, 10838247, 10920887, 12313449, 12264837, 10773987, 11314851, 9988061, 9349535, 9349499, 9366251, 9039041, 11399151, 9351395, 9695681, 10924491, 13349211, 12300567, 10924581, 10924575, 12300903, 10924953, 10384343, 10925199, 11318685, 11318679, 11547987, 11319099, 11073405, 11319531, 11074695, 9698555, 12450939, 11124189, 9535043, 10387397, 9011333, 9027719, 9535595, 12239283, 9044399, 13517217, 10862889, 10862853, 9863501, 10961571, 12239607, 9634499, 9012107, 9044771, 9044807, 9045161, 9045209, 10077215, 11175321, 9045311, 9717563, 10241837, 10241879, 11159679, 11208819, 9603179, 11504271, 11176563, 8997503, 11160555, 10423115, 9047243, 9637067, 10800573, 11161071, 10243427, 10800789, 10800837, 11144907, 9572069, 9031235, 9031553, 9768959, 9654035, 11145027, 11161431, 9621743, 10571831, 8982635, 10702929, 9048191, 9360047, 9016013, 11162343, 10408703, 10408679, 9360119, 11162115, 11424663, 12424071, 10408913, 12423981, 9360191, 9638699, 9639095, 10425551, 11424873, 10703937, 12424275, 10245527, 10573241, 10245563, 9983483, 9033047, 9623171, 9983621, 9017015, 9000485, 11507229, 9049667, 10245713, 9983609, 10573385, 10573397, 9639845, 12179451, 9000917, 11212605, 11048715, 10409819, 9607169, 11196477, 11196423, 9984101, 9279881, 9050573, 11180295, 9279851, 11197167, 13687371, 11164239, 10410887, 10705821, 11197227, 11459439, 9772211, 12311933, 9641309, 11509257, 9002951, 12607281, 9740513, 9019457, 9035843, 9036179, 9642407, 9036233, 10953171, 9986333, 9019769, 11166045, 10412387, 12345993, 10838775, 12345885, 10953327, 9003611, 9642593, 11232243, 10839033, 10953687, 9642989, 10838787, 10249355, 10986681, 9036989, 10953957, 11658435, 10953951, 10839099, 9643061, 10249301, 9643079, 9004145, 10954149, 9037265, 10954191, 10249523, 9037133, 10954077, 11495097, 11314869, 9856547, 9856631, 9021353, 9037757, 9988067, 9643787, 9627407, 10954599, 9021281, 12347211, 10774719, 9005231, 9676967, 10774557, 9349559, 9349607, 9644519, 10774839, 10775199, 9022133, 10939107, 10955475, 9775643, 9022079, 9038795, 9644999, 9366527, 11496411, 9317369, 9988889, 11086599, 11086713, 10939209, 10939569, 10939533, 9628919, 9645287, 9366545, 9006155, 9366599, 10579385, 9039287, 10579415, 9366797, 10775865, 9039167, 10710375, 10251599, 10579325, 10251629, 10251623, 12447369, 9629351, 9662165, 11398887, 11398851, 10251851, 9646049, 10776537, 11185953, 11186019, 11399337, 10399877, 9629873, 11399319, 11399361, 11399385, 12333159, 10399859, 12530151, 11399631, 9351653, 11399463, 10252559, 9990413, 9990407, 9351515, 11153781, 9351545, 11399871, 10957539, 10695389, 11399805, 10957575, 12203211, 11400207, 8991797, 9008591, 9647591, 10925349, 10007831, 9024845, 12301959, 9631457, 9647639, 12449397, 9647741, 9025505, 11515845, 9991967, 11400969, 10401629, 9975659, 11319135, 12302571, 9648335, 9025751, 9648371, 9992225, 11188665, 11156103, 10074845, 9992729, 9894461, 9042503, 9648743, 9370229, 9648749, 9632651, 10418969, 9632543, 9026387, 11140299, 10075205, 9354341, 9993503, 9633419, 9600755, 9043529, 9043547, 9027341, 10075925, 11157351, 11190087, 10977435, 10797399, 9373067, 10814889, 10815027, 9013421, 10766847, 9407579, 10423409, 10244921, 11392035, 10770171, 12326409, 10754595, 11459703, 10886571, 11394495, 10477565, 11183001, 12363507, 11315025, 9349205, 10971653, 11316867, 9350699, 11317029, 11317119, 12235161, 9728363, 12448335, 10695549, 10941579, 11581311, 10795167, 9353999, 13548771, 11173091, 12286989, 12550431, 10781523, 9635345, 13026819, 11520423, 10587239, 12226257, 10571987, 12341673, 13506549, 10755255, 11132049, 10755453, 11214813, 9346895, 10823631, 11380755, 11315289, 10775175, 12234141, 12218169, 10694985, 11383557, 10779021, 10779117, 10779333, 9452123, 11386461, 10567871, 12550353, 11485215, 11665515, 9109613, 9846887, 11174331, 12550653, 9060815, 9978305, 9109817, 13517169, 9060701, 12550899, 9847793, 13517757, 13026237, 10863471, 10552481, 9094313, 9094391, 9094217, 12223937, 11372265, 9127475, 9062003, 11667363, 13535217, 9078743, 10815453, 9701219, 12535971, 10717335, 9111785, 12552237, 9127967, 10717197, 10258541, 11667873, 10717443, 10717563, 12224855, 12159653, 9751127, 13028301, 12159953, 11521191, 9817277, 11521155, 11619383, 10783847, 9096617, 10456529, 12537321, 10784033, 11374233, 9096809, 9064337, 9342815, 10424135, 12537675, 10244111, 11620763, 9343271, 9130367, 13341417, 9097913, 9097919, 9048821, 10408547, 12342197, 12243743, 9114407, 9114803, 13341873, 10032131, 10474535, 12539001, 9016409, 9131435, 10753473, 9360887, 9082379, 10819181, 12326823, 11212845, 10328141, 11212923, 11212875, 10295747, 10557707, 9115979, 9853661, 11655915, 10902063, 10803761, 10558061, 10492535, 9100271, 10754885, 10050419, 10787663, 9116873, 11377769, 11050401, 11050371, 12541497, 12525111, 11378639, 10575617, 11378441, 12279575, 9707345, 10510505, 9052415, 11624465, 13590543, 10805345, 9330815, 13525449, 9118103, 9118175, 10756355, 12427521, 11379053, 10756769, 11624969, 11150265, 10544099, 9544685, 9741089, 9741125, 9364637, 12608577, 9102629, 10003751, 9102713, 9119387, 11380643, 11626673, 9709757, 9119957, 12953787, 10987551, 13035531, 9103835, 11545041, 9054719, 11659629, 10562057, 10791545, 12544923, 9088157, 13511889, 10939605, 13347933, 11627549, 12463113, 12463215, 12463209, 12364899, 12463197, 12463191, 12545313, 13020435, 11578731, 10514147, 13020825, 12545733, 9055985, 13512297, 9105299, 12529563, 10973129, 11071449, 12218315, 12529607, 10580147, 11628695, 12398649, 10793345, 13513191, 12530169, 10498535, 9106061, 12219017, 12219131, 9859805, 12546759, 11629499, 9106391, 10564553, 10073075, 9368333, 11088749, 11088735, 10777671, 9090437, 10696091, 13530615, 12547457, 9795029, 9352457, 10040615, 9073997, 9090749, 10499741, 9090743, 11236965, 11236983, 13514733, 12547983, 9697265, 9107429, 9058295, 12547911, 9713879, 9058319, 11368509, 12744789, 9828431, 10565957, 11188989, 12237509, 11401997, 9042815, 10878087, 9108707, 10878065, 9076163, 9076187, 9076211, 10763561, 12451107, 12844395, 10435967, 9076397, 12533361, 9076331, 11026365, 11026359, 11026407, 11485125, 11485143, 9797441, 12533859, 12550569, 11388129, 13338759, 10963065, 12226065, 10818195, 10244609, 12424353, 12227625, 10901067, 10803213, 10820361, 12229461, 12344541, 10952241, 11165589, 10788645, 10805319, 10822029, 10821945, 12526221, 10887909, 10838721, 10789569, 12362301, 10756671, 12214881, 12280701, 10773993, 10806561, 11315105, 10758549, 11315877, 10759065, 10694277, 10826151, 10777497, 11400351, 10794201, 10761273, 10844553, 12385101, 11483991, 10763751, 11485017, 13527255, 12463155, 10839453, 9088325, 13343445, 9844427, 12161747, 10755587, 10760813, 10262129, 9130979, 9133865, 11360025, 11665161, 10250111, 12403797, 12223899, 9472085, 10782789, 12257607, 10260413, 12242769, 12242955, 10801809, 12243543, 12342405, 10786287, 10852341, 10869477, 13343361, 12245703, 11475531, 10755249, 9346757, 10756023, 10789119, 11149689, 10789437, 10838979, 10789653, 10806123, 10758387, 9661151, 10791483, 11578599, 11381865, 11317185, 10760031, 10760217, 11235609, 12218709, 13546461, 9352055, 10843311, 10778091, 9352739, 10828197, 9484763, 10025681, 10779951, 11484945, 9347369, 10945401, 11092803, 10765335, 10767171, 11390717, 10695291, 10974123, 10705107, 10917933, 10795689, 12286551, 10796727, 10715337, 11534421, 9683429, 9666833, 10731789, 9978239, 9355955, 11518563, 9683849, 9323435, 12157847, 11273157, 10961769, 9782081, 11224257, 12239889, 12240285, 12240201, 10258097, 11224779, 9324059, 9848987, 9472403, 11225547, 9669119, 9358061, 9358049, 9374249, 12339831, 11209329, 11389511, 11307789, 12340083, 10013921, 10439687, 11226615, 11111925, 11111889, 11275551, 9538853, 9538883, 11537973, 11210289, 11538027, 10801041, 9654227, 10719225, 11226927, 10801005, 9687269, 11210769, 9982391, 10801653, 9687557, 11424903, 9360413, 11424783, 9344123, 11424849, 11425047, 10573553, 10573559, 11146797, 10901037, 10016369, 9688967, 10442633, 9607091, 10442693, 10245935, 10573883, 11540493, 10541129, 10459253, 10000775, 10000823, 9279983, 9279989, 11049639, 9689795, 13343391, 9361961, 9361973, 11311683, 11262897, 11049957, 12426195, 9509651, 9345821, 12426021, 11049747, 10575011, 12426357, 11460045, 10034663, 9313967, 11329221, 11460543, 9691073, 10067957, 11231175, 11460399, 12279585, 13524855, 11460417, 11198289, 11231481, 9691205, 11001939, 11198781, 12329337, 9364043, 9364091, 9364085, 11215785, 10838967, 11527101, 10839027, 12330219, 10986921, 12264933, 10986807, 10986867, 10986879, 10249739, 11200491, 10512347, 9332489, 9856817, 10987389, 12560511, 12347487, 11200815, 9546437, 9677351, 9349709, 11201127, 9349721, 9349745, 10939281, 10939347, 9546539, 10447649, 12430185, 10431353, 10955967, 9743417, 10431575, 10955871, 12348483, 10775985, 13102581, 10775955, 10415609, 10513883, 10775847, 12332343, 12332313, 10956135, 10956123, 10251929, 11218665, 10432127, 10448735, 10252475, 9793541, 10957239, 11202849, 9335057, 12562815, 9990815, 9351851, 9990839, 10007093, 10957425, 11400171, 12448743, 11400045, 12203193, 11220111, 11203731, 9680075, 9679919, 13530141, 9925697, 11400267, 12448833, 11187285, 10958247, 12449271, 10925559, 10417655, 10925517, 11400513, 10466975, 12302007, 12449445, 10925631, 10925649, 10057631, 12302283, 11204409, 10713225, 10582061, 12335421, 11221305, 11516583, 10041881, 12352101, 9354209, 9714473, 10713885, 12336375, 11025417, 11025849, 10255739, 11025747, 11484693, 12550119, 13533375, 12517695, 9519845, 10863165, 10863231, 11256993, 12240297, 12240225, 12240441, 10503725, 9062273, 11519787, 11552577, 9783803, 12536781, 11553657, 10898441, 11537871, 9817367, 11390895, 10801149, 10784543, 10719087, 10915901, 10801155, 10801179, 12226661, 11227527, 9064721, 11538711, 9326963, 9097901, 11539383, 11260827, 11260887, 9327383, 11539203, 11228409, 11539653, 11425167, 11064591, 9327941, 10901259, 9000779, 11540625, 9771413, 11148015, 10017527, 11049681, 9280115, 10476431, 9051041, 11049951, 11049849, 11049855, 9345899, 12180609, 10034231, 12426327, 11673255, 9707057, 10247783, 9641879, 11542425, 11460579, 11263965, 12427071, 9068333, 11460471, 10084223, 11460435, 10035425, 13344951, 12345401, 11460651, 11460645, 11247645, 9708167, 9773753, 9708233, 9364301, 10756973, 11265219, 9004283, 9708995, 9348377, 11232633, 10020161, 10987137, 9954905, 9709121, 10987089, 11560947, 9774881, 11085881, 9988499, 11331873, 10758407, 9857393, 11545095, 9743273, 10939335, 9349925, 11545605, 10775973, 10776063, 11251065, 9334487, 10579469, 9006647, 10776183, 10579583, 10776129, 10481267, 12365739, 10432277, 10760015, 11088123, 12267891, 10957509, 10711581, 10957785, 10777563, 9712889, 11400315, 9336527, 12449535, 10925817, 12449319, 10925673, 10958421, 12449691, 11237175, 11187975, 12449661, 11188413, 12302481, 12302475, 11335985, 9730361, 10484093, 9025907, 11172537, 13630167, 11172483, 12450441, 11172597, 11270691, 10877907, 12450609, 9337703, 11173047, 10714131, 11025711, 10960197, 12451137, 11533887, 11025927, 12238899, 10862643, 13025739, 11141853, 9634373, 11436981, 12239733, 9635051, 12239979, 12239955, 9618887, 10700241, 10700463, 11159625, 12552483, 11094717, 11144373, 11553921, 10243247, 10800273, 10898433, 9407603, 10800585, 10243355, 10800429, 11209989, 11144547, 9637481, 11538399, 9982127, 8999345, 9638507, 11506557, 9589925, 12620937, 9639113, 12178635, 10245233, 10442027, 11163357, 10245701, 12425181, 12179415, 9345257, 10393619, 9623603, 9345335, 9345371, 10001117, 9345593, 12327855, 12540945, 9641369, 9346313, 11083425, 9969341, 10838451, 11166081, 11461083, 10838529, 10773411, 9364247, 9347927, 12330129, 10986507, 10986609, 11134347, 12264945, 11396603, 11330853, 10774233, 11281965, 9627161, 10954341, 11511585, 9643811, 10463063, 11495259, 10774677, 10004651, 10774947, 10774851, 10939047, 9644963, 9743453, 10579445, 11398521, 11398869, 9989633, 11399019, 10760405, 9351257, 11105733, 12302025, 9648563, 10877619, 10877649, 10877499, 12204663, 10075115, 9354047, 9600107, 10075697, 10075727, 12238593, 12238683, 10813449, 10387787, 10880151, 12240363, 11209155, 10832247, 10799859, 10768311, 10309667, 10834275, 10834287, 10573667, 10852875, 11393631, 11410725, 11411451, 10019531, 9349283, 10791159, 10529183, 10791645, 9350105, 10939185, 10792179, 12463131, 10873947, 10792707, 12235563, 10859325, 10761231, 11383899, 10761645, 10761537, 10909359, 10467515, 9353417, 10762437, 12450201, 9025967, 11385375, 10762839, 10828635, 10763649, 12254571, 9354881, 11419557, 10075961, 8994947, 11174067, 9633971, 12239055, 12239043, 12238875, 10862709, 12238941, 9355643, 11109147, 8995967, 9028943, 9619007, 11109909, 10700691, 10700649, 11110257, 11110461, 11110425, 11110527, 9357581, 10701453, 9620369, 10701717, 11176743, 11177205, 10800171, 10701927, 11324511, 10800777, 10931757, 9047573, 9637475, 9031475, 11128599, 10571825, 11128923, 9360005, 11424387, 11424669, 9360203, 10900317, 12178665, 10573049, 9639155, 12178641, 9344231, 9606551, 12178767, 9606875, 10409861, 10393595, 10409777, 11048793, 10950843, 11507739, 9984389, 9345479, 9345281, 9050399, 10950921, 9279821, 9312593, 9345377, 9361781, 9640637, 11459319, 11459121, 9345653, 10705905, 10951461, 9624413, 9985133, 9034865, 10247825, 11280093, 10952253, 9346631, 11312757, 11280549, 9609395, 9642023, 11133015, 12345651, 9363761, 12346041, 9626243, 10838679, 10953423, 10838625, 9003629, 11134125, 12264603, 11543709, 10249271, 9659459, 12264549, 9020813, 10954155, 10773951, 9037157, 10774215, 10954533, 10774341, 9316535, 11200755, 9349523, 10955163, 10398149, 9021713, 9644387, 10939131, 10939101, 10775259, 9660947, 10775349, 10939155, 11168577, 10513229, 9366749, 9039071, 11136207, 10448105, 9317849, 12316107, 11398461, 9645791, 13021095, 9858905, 11399007, 11399421, 10956819, 10399871, 11399247, 9351293, 11399625, 9351455, 11399475, 11170491, 11088603, 11154363, 9008075, 11400147, 12301083, 10925235, 12448827, 10925103, 12301317, 9647507, 9631145, 12318183, 10925337, 9319781, 11138613, 10581629, 11318865, 10925975, 11319255, 11483385, 10402127, 12450495, 11123379, 12352167, 10877637, 11139675, 10304105, 9993011, 9976997, 9993413, 9993461, 9633383, 9535361, 9535433, 10060013, 10813661, 10551371, 9748871, 10420517, 12550509, 13517559, 12419823, 12403601, 10306547, 10863393, 13518009, 10454129, 9831545, 12404141, 13223403, 11633975, 10962591, 10520111, 13387725, 12240831, 10815471, 12388305, 13518753, 10962723, 9111323, 10717023, 9767321, 10553843, 10406147, 12552573, 9734879, 10537589, 13027881, 9341567, 11521023, 13044669, 9358487, 11521029, 11521041, 11275347, 10702281, 11603247, 12390027, 9604841, 9096713, 9096731, 8998421, 10554905, 10800743, 10538609, 9834455, 12341211, 9834473, 11357991, 12537681, 10063727, 9342833, 12390543, 11620547, 10621001, 12390891, 9507305, 11112759, 12341615, 13587069, 10523573, 10065089, 9442511, 10556453, 9082175, 10065647, 11212719, 11212677, 9852887, 11212587, 12326775, 9000815, 10574021, 11212821, 9755105, 10574093, 13523463, 13540137, 9133265, 9100337, 9116795, 9100409, 11050383, 9346355, 11050365, 10034543, 12181143, 12230201, 11624045, 12181083, 9118097, 9609641, 12526059, 11379005, 10559759, 10756445, 9872021, 11002389, 10576415, 9822845, 10035827, 11150247, 10085309, 9741077, 10625807, 9102467, 10855439, 10085477, 10069451, 11380175, 13526445, 10003721, 9823547, 10462535, 10561211, 12265185, 9823757, 10610195, 9840221, 13985295, 12166745, 9857231, 10561787, 10987599, 9054647, 10070501, 12544299, 9857291, 9857339, 9742631, 13035813, 9775829, 10889745, 9103961, 9350063, 12463059, 12462945, 10480511, 10480487, 9841727, 9432143, 12463185, 10628177, 11349309, 11595405, 9055997, 13348437, 9842255, 12561993, 9597077, 10580123, 9122003, 9105659, 10580015, 11251779, 9728411, 10547459, 11088621, 13071015, 10547723, 9859643, 10777575, 10777581, 11088663, 10777449, 11088705, 9122993, 9352301, 9827729, 10630541, 10630517, 9090707, 10778255, 10548953, 11236917, 10450523, 10450529, 12547995, 9828341, 12679011, 10811237, 11401071, 9107609, 13040067, 9124271, 12302799, 11188911, 11188947, 10582553, 9845753, 12549069, 10779503, 13040421, 9829547, 12205119, 12450831, 12450921, 12450909, 10878039, 9829775, 9813323, 12222035, 12549705, 11026347, 9650237, 9355703, 10895643, 10699515, 13517397, 10764815, 13026459, 9635351, 10799865, 10799655, 10799625, 10800375, 9981173, 8998139, 12274779, 10800213, 10899429, 11063259, 9360029, 10556093, 10900197, 12423927, 9359963, 8999909, 13521669, 11424585, 11048109, 11408589, 9770213, 9360401, 9606269, 10245521, 11228607, 12178835, 10245629, 12326367, 10573061, 9016649, 10573169, 12342929, 10245803, 11196003, 10409753, 9279641, 9869423, 9345443, 9001613, 11459127, 11050005, 9346553, 11345895, 9642173, 10952811, 10412129, 9363851, 11149593, 10838343, 10724025, 9986795, 12345957, 11084361, 10838595, 10773423, 9774215, 12264621, 13755639, 10773771, 12264975, 13527003, 10987473, 12544155, 10774539, 9349517, 11266479, 9349823, 10775103, 9317255, 9530249, 11398017, 9513737, 12414183, 11316471, 9858839, 9498779, 11137221, 12333177, 10957299, 11399859, 11399925, 12448473, 11138145, 10581569, 12367671, 9631517, 9631565, 10925901, 11024457, 10582103, 9009269, 9353753, 9042497, 10877517, 11353071, 9354071, 11139921, 11025603, 9600029, 9633047, 10485323, 11157405, 11518119, 10797189, 12337701, 10797693, 9635327, 11437425, 11062455, 9702629, 13110765, 11210067, 12341295, 11391537, 10245047, 11048337, 9344873, 11393109, 11393487, 10934981, 10836843, 11541339, 12344613, 10886499, 12345321, 10886925, 9904421, 10887531, 11297313, 9036401, 12559533, 10888329, 10265675, 10937769, 9349229, 9366227, 11069955, 10022411, 11514051, 10940421, 10761723, 10925775, 11434287, 10860897, 9535289, 10796811, 9044099, 10862841, 12353577, 9027653, 9650585, 10862991, 10862997, 10387907, 9290015, 12189969, 10862865, 10862955, 9027923, 9011579, 9355913, 12239529, 9781943, 9355949, 9044717, 12239415, 12370467, 12239391, 9028499, 11158455, 11436957, 9012149, 10699521, 10077023, 9045137, 11207889, 8995859, 9028733, 9323849, 9651527, 9635171, 9045671, 11159277, 11093733, 11503311, 9651953, 12322815, 12322797, 9651989, 10733331, 11175801, 11159799, 9029651, 10029113, 11110839, 11176425, 9013535, 9357665, 10406555, 9292421, 11143845, 10406621, 10390253, 10406453, 9636443, 9030425, 11504385, 9653105, 8998055, 9047075, 9653333, 8997971, 10407299, 10800519, 10800633, 10800465, 10243739, 9785009, 10800783, 9604721, 9981863, 9031457, 10702623, 11177793, 9047921, 9965783, 11145471, 11505867, 10408001, 10571855, 11162013, 9015779, 11145597, 9360083, 9687635, 10408871, 10900269, 9360161, 11424537, 11424621, 11424627, 12424017, 10900299, 11424597, 12424413, 10900677, 9655307, 11162679, 9049193, 11507115, 12195255, 10245509, 9639305, 10261889, 9983465, 12424485, 10409261, 10409339, 9033077, 9033395, 9360899, 10245647, 10245719, 10245707, 10245731, 12425127, 9000911, 10393589, 9983981, 10704675, 10573673, 11163795, 11049183, 9885719, 10409999, 9050141, 10410083, 12179901, 11196909, 11049441, 9279965, 12179937, 9017813, 11180535, 10459637, 12376347, 11507973, 9001289, 12327567, 9345719, 9017897, 9050663, 10754583, 9984599, 9280085, 11213379, 9656957, 9345659, 9362351, 10410923, 9001961, 9034553, 9018161, 10410875, 10410863, 9985181, 11050137, 9985217, 9657359, 11394173, 10574975, 11197521, 9035165, 10411427, 10706181, 10952373, 9641609, 10952427, 12426957, 12688935, 10952265, 9625505, 10067933, 9658313, 9641795, 10412255, 9036023, 9035849, 9642275, 9986417, 10838709, 11526705, 10953231, 11166237, 9036371, 9642887, 9003935, 10838925, 10838943, 9003983, 10953861, 9626807, 9987245, 10953933, 10986711, 9348107, 9348101, 9004073, 10986591, 12264843, 10954179, 10986789, 9037115, 12264705, 9659693, 10954071, 12264777, 10512029, 11183865, 9348851, 10954263, 11183733, 10774503, 9627647, 10954713, 9037601, 9627425, 9037649, 9463649, 10774353, 10774761, 10774743, 9038069, 9660449, 9021515, 9021557, 9644417, 11184513, 11168001, 10709355, 9038177, 9038207, 9644399, 9644693, 10775211, 9022121, 9628343, 10939077, 10775247, 12331719, 10775085, 9349649, 9661025, 10775475, 11512707, 11086791, 9006077, 9988871, 9988901, 10939251, 10955949, 9022631, 11152635, 9039059, 9006161, 10251695, 11169219, 10251767, 9989615, 9645395, 9006407, 9023183, 9023189, 9645593, 9104915, 9629231, 9645647, 9645665, 9023369, 9859019, 11399121, 9940793, 9350975, 10776387, 11398977, 9990293, 9711845, 9990377, 10776585, 9039959, 9859199, 9351587, 11399661, 9351665, 9351533, 11399493, 9040535, 9007853, 9351695, 9351707, 9351725, 11399703, 11203089, 9318989, 11399793, 9318995, 12448695, 12301293, 10925049, 9024341, 9040739, 9319265, 12301479, 11154669, 10925289, 11187417, 9040901, 9991223, 10925181, 9024635, 11400489, 9630977, 10417421, 10925343, 10925433, 9631103, 9991697, 9991739, 9320033, 9827951, 9025421, 11319219, 10581953, 9041693, 9991949, 11319093, 10581779, 12302505, 9681029, 9615383, 11319381, 9042347, 10402097, 12450057, 12351837, 10402175, 9632477, 11483841, 9533969, 9992747, 11025009, 9354119, 9354131, 10877835, 9010115, 9649139, 9010145, 9009995, 10877763, 10877775, 9534617, 9993269, 9993257, 9288803, 9944471, 10452233, 13024635, 9633131, 9043643, 13041333, 10075751, 9650147, 9633647, 9863369, 11157579, 10765317, 10767075, 11390217, 11390319, 10915791, 11390733, 12342621, 9344723, 12344223, 11082699, 12540723, 10772739, 13345539, 13526799, 10889277, 11430399, 10415177, 10695435, 10794309, 10794579, 10909773, 10860837, 12417927, 9780167, 10959681, 13516209, 9126041, 9126035, 11665635, 9732509, 11174367, 12550803, 12829311, 12518319, 9094121, 10486541, 13042461, 10257551, 9848021, 13337775, 10454135, 9094271, 12551679, 9094421, 11126415, 11126427, 9061997, 13027323, 10815465, 12535791, 10798865, 9815855, 9127763, 9078611, 12240729, 9078641, 9078791, 10963047, 10963401, 12241209, 9111869, 11667789, 11668155, 10783409, 11651757, 10570241, 13699647, 11373531, 9734915, 10570499, 11521197, 9030821, 9850019, 11668623, 9850097, 9358583, 11373603, 9079883, 9113015, 9112919, 9342713, 9064331, 12161021, 9064229, 9654443, 9113627, 13340769, 11653233, 11391101, 11358279, 9850985, 9130391, 12341711, 12161309, 11112729, 11374917, 9769715, 13865559, 10801749, 10032125, 9097991, 10441565, 13341453, 9426107, 11670561, 11392121, 9082271, 11425209, 13030791, 10540529, 11359743, 11670831, 10540547, 10409747, 11212941, 10246547, 10246505, 12524271, 10902075, 9853499, 11360889, 10001351, 9100283, 9132821, 11623187, 10755227, 10755275, 11377883, 9100295, 10755149, 9018785, 9068009, 9068021, 9854261, 12180825, 9346403, 10427747, 12181137, 12426981, 9084641, 9084803, 10805129, 10559387, 10788845, 9084701, 10756271, 11378921, 9052397, 11657409, 11673705, 11362623, 12722517, 11379047, 13525305, 9118373, 10576529, 10756853, 11002413, 12542547, 13509171, 9364367, 12542865, 12575973, 13509759, 10741149, 9102785, 12396177, 10757771, 9610967, 12543585, 11315123, 12396441, 9709721, 11659425, 11675823, 10987587, 11675733, 11004335, 10414547, 9103829, 9103853, 9103841, 9742643, 10562291, 9103937, 11545179, 9120371, 12708837, 12463095, 12463047, 11365551, 12397743, 9088175, 10562813, 12463143, 9088097, 11382233, 12365109, 11660607, 10022153, 9088319, 9088331, 10759931, 11382341, 9105329, 9105203, 9121607, 10563407, 9105269, 10744029, 11382827, 10432535, 9072725, 9122249, 10301747, 12218747, 12218723, 10563923, 12399249, 9122351, 11661939, 9008021, 10777587, 11662137, 12530535, 10777701, 9123275, 9844211, 9090551, 11662611, 9073961, 9844025, 13514433, 9844415, 11236875, 11236887, 9844295, 11236989, 11236977, 9353123, 11663589, 9697289, 12548127, 12564585, 9124127, 9632051, 11630855, 9107819, 12515667, 9107825, 11188965, 11188935, 9042821, 9108227, 10550057, 11188995, 13532031, 12532605, 12451041, 12451035, 12451029, 12451023, 9108827, 9076361, 9109127, 10583777, 10715625, 11092239, 10505153, 10800363, 11062317, 9669953, 13127693, 12161387, 12326145, 11065755, 10509197, 11476263, 11476521, 10772871, 11215551, 9348113, 11397027, 10939365, 11398281, 11087361, 9351155, 11154603, 10957965, 11187231, 12450981, 11124081, 9583985, 12189981, 10879797, 11387775, 10863987, 11388645, 10765917, 11077851, 11390145, 10768233, 10408187, 10359521, 11424651, 11392389, 11392863, 9771167, 10918107, 10917903, 12262197, 10936257, 10559621, 13526225, 12232599, 12232563, 10774389, 10775409, 10791999, 11366199, 12283719, 9990281, 10793871, 10793811, 10925445, 10254737, 10762497, 11385429, 9681863, 10795797, 10764135, 10862727, 10764419, 10862733, 11157639, 12238893, 10862715, 12320847, 10420325, 9355649, 12239253, 9355751, 13533513, 12239151, 9355595, 9011573, 9667091, 10863147, 9650765, 10716297, 9635039, 9634829, 8995895, 9438323, 9029051, 10487531, 9979625, 11175447, 9029243, 10700589, 9357497, 10700847, 11110479, 11127213, 11110833, 9046433, 9013703, 11127159, 11520717, 11127501, 10800105, 12520431, 11127747, 11144403, 11160633, 11144253, 10800135, 10800201, 10243469, 8998151, 10800435, 11160837, 10800411, 9047759, 9982097, 12538035, 12423375, 9637913, 10440755, 9850967, 11112543, 11129223, 9638333, 9359837, 12423459, 12423525, 12423825, 9360095, 9638651, 10900191, 11129775, 11424699, 9360155, 10245347, 11424813, 12424197, 10392653, 13637073, 10704375, 11162925, 10245377, 11162895, 12424455, 10573157, 13047063, 9049427, 12424551, 12424539, 10245473, 12424515, 9033389, 11130513, 11196105, 10901727, 10901565, 9984053, 10246229, 9001055, 9361823, 9361727, 9279803, 9345707, 9018047, 10492511, 11164623, 11459523, 10509161, 9526457, 12426471, 11132115, 10574849, 9018401, 9035153, 9526577, 10264247, 11132619, 11460459, 11460441, 10952859, 9363653, 10952949, 9019631, 9609257, 9642077, 9855065, 9003455, 10838487, 12345663, 9363737, 10396019, 9347801, 9347969, 10953699, 9348035, 10249211, 9348065, 9003785, 9347855, 9347933, 12264609, 9348263, 12264543, 9315449, 10986963, 10773969, 12264765, 10773777, 10954053, 9856685, 10774263, 12265011, 13329927, 10774107, 10954737, 10774749, 10774923, 12315135, 9005507, 9644495, 12347703, 9972011, 9349445, 11086521, 10775229, 11135529, 10775049, 9005957, 11135871, 9628757, 9628775, 10579361, 11398581, 10251719, 10267997, 10399079, 13725249, 11398731, 9858887, 9646229, 9351305, 9351359, 9351389, 9351227, 9351233, 9056645, 10777053, 9367823, 9040163, 9351497, 9024233, 9744953, 10400687, 9630707, 10253303, 10777389, 10957665, 10925217, 9532553, 10925309, 10466549, 10925277, 12301329, 12186693, 10925145, 9647531, 9598433, 9041213, 9581951, 11482791, 10581653, 11318835, 12187167, 11138655, 11319075, 12449571, 9992009, 12187821, 11024583, 10958967, 11499909, 11139423, 9370247, 9353927, 9665123, 9354155, 12532731, 9993167, 11500503, 9354005, 10877721, 9648971, 9632915, 11123733, 9632855, 11025801, 9043373, 11206041, 11517393, 9026879, 13335825, 9027245, 12238539, 9600797, 12238719, 11174139, 9535733, 10797147, 11174259, 10797699, 10797603, 10797657, 12272619, 10028183, 10814691, 12289263, 9046025, 13338729, 12290163, 10243535, 10767825, 10947957, 12292263, 13111719, 12424317, 11015271, 12326415, 12540135, 11442207, 12540645, 10951587, 13327221, 12344337, 10968681, 11018127, 11002965, 9004355, 12544245, 10972371, 10431857, 12234885, 11317263, 9351899, 11400039, 10040375, 12236217, 12318825, 9353303, 11581875, 9648509, 10975827, 10796451, 10796463, 10796307, 10796925, 13352757, 9846791, 9060773, 11174349, 9863495, 9732473, 10551899, 10568693, 13533999, 10437785, 11617445, 9094379, 10454123, 10896843, 10437983, 10437959, 10962621, 10438391, 9684563, 9062015, 9815831, 13125501, 11634521, 9750773, 12535821, 9750941, 9849197, 10472093, 9865901, 9734909, 12388959, 11520939, 11520957, 10439615, 10816295, 10439483, 9554807, 10439531, 9342095, 10554395, 12389463, 9096533, 9948809, 13520505, 10555295, 9064397, 10522469, 9572195, 9064307, 11112627, 12341501, 10801659, 10310129, 11112723, 9048779, 10834475, 9343541, 13341645, 9114611, 9753611, 9376847, 10556525, 11064735, 9360875, 9688379, 9835889, 9835901, 12277455, 12326817, 12326805, 11212761, 13342647, 11376447, 10574063, 10557653, 11212851, 10557467, 11212899, 9607241, 13523427, 9738713, 10574099, 10246517, 10066607, 12278505, 10541675, 9100259, 11393819, 9509711, 9280367, 11377793, 9067985, 11050311, 10034537, 11509083, 12181053, 10756031, 12427149, 11362203, 9723701, 11608251, 10756265, 11378939, 9052409, 9969701, 13525047, 10789415, 10478099, 11002377, 13984365, 11461197, 9544667, 11150325, 9741065, 9544487, 11150151, 10069139, 9102491, 9364673, 10069001, 11150415, 9102773, 10839423, 10561205, 9840317, 12265191, 9479681, 10757699, 10250123, 9840569, 11626445, 10069763, 9709733, 10496117, 9660683, 9742637, 10545899, 9841169, 12217223, 10382147, 10546427, 9546995, 13511871, 12463137, 10628171, 12676503, 9694871, 10514093, 10514135, 10760093, 12546039, 10546997, 13037331, 12218525, 10252487, 10547237, 9122231, 9761219, 10252547, 11350299, 12645095, 10760849, 10318541, 11612889, 10744353, 12218987, 10056605, 11383721, 11088699, 11088693, 11318021, 9122609, 10793825, 10777461, 12399843, 10532045, 9843797, 11236761, 10630553, 11662647, 10794245, 11351325, 9024821, 10548509, 9844037, 11401113, 13514739, 10516475, 11368281, 13531353, 9713837, 9124055, 9713897, 9828383, 9975893, 11188953, 11631161, 10025879, 12204909, 9042809, 12204873, 10468505, 11631665, 10435619, 9813443, 9829649, 12533007, 10435913, 12451143, 9109241, 9354791, 9354785, 10780181, 9076325, 11485095, 11026401, 11353905, 10600571, 9888143, 11461017, 13525593, 9544253, 11461191, 10437545, 9675551, 9847577, 10437467, 12534645, 10863477, 10863435, 11150175, 10552361, 9094145, 9094169, 9094211, 11347047, 11437179, 9766013, 9364601, 10438115, 10462541, 11404667, 9840215, 10962513, 10528343, 11601819, 9726095, 9857255, 12240927, 10496075, 10717623, 10537271, 10717503, 9841373, 9546485, 10054181, 9350027, 10038155, 9022409, 9112397, 9677969, 12536967, 12463119, 9079901, 12463203, 10022183, 10604201, 10513973, 9367067, 12398463, 12341115, 11112609, 10539251, 10063901, 12390525, 13553703, 10252403, 13644261, 9859751, 10777317, 10777305, 10777599, 9343985, 9827369, 9811061, 10253711, 11236767, 9360857, 9819503, 10630493, 11319039, 12482281, 12391995, 11236893, 10540655, 10499699, 10549163, 9336749, 10532747, 10926075, 11212929, 10328135, 10901985, 9722351, 9124217, 11188905, 11188893, 9722393, 9640535, 9116273, 12450717, 10763165, 9747443, 9116459, 13556511, 12541149, 9837647, 11050419, 10034483, 10378547, 11050347, 9354893, 12426885, 9076421, 9428501, 11517489, 12426855, 11485077, 12418877, 11026281, 9084737, 12427107, 9027725, 11174061, 10862835, 10076207, 9633881, 9633857, 9027707, 9044081, 9027983, 12190119, 9535931, 10797455, 9044447, 9355739, 9044453, 10863057, 12321081, 10076423, 10076465, 9027905, 10076501, 10076543, 9978209, 10076825, 9044483, 9355823, 12239487, 12239463, 12239445, 9028505, 9651125, 9372605, 9028553, 12239871, 12239817, 12239637, 9028433, 12239691, 10716339, 9012401, 10962147, 9651401, 9028847, 9012449, 11175345, 9045443, 9061829, 9028865, 9028889, 11175183, 9012557, 9045347, 9045365, 9635531, 10405625, 11175483, 9651749, 9045569, 11175519, 9045623, 11192109, 9308003, 9045863, 9029729, 10422665, 9357719, 10406345, 9669101, 9357593, 10422575, 9029975, 10406543, 11111091, 11504235, 9046631, 10406825, 9046805, 11209473, 9046865, 9030833, 11176995, 10407005, 9047129, 11193435, 10407323, 10407353, 11505045, 11160981, 9031139, 11193633, 9047345, 8998211, 9047693, 11112093, 10800795, 10800855, 10800687, 10800717, 10407539, 10800735, 10800729, 11161593, 11505615, 9031469, 11177751, 9047897, 9015125, 10407791, 11145423, 9015323, 10407947, 9048107, 9015401, 11161677, 11145705, 11178447, 11505921, 10408613, 9360053, 9032279, 11276871, 11424675, 9048983, 9048995, 10900455, 9360137, 9360131, 9098009, 9360149, 9376553, 10900311, 11506515, 9426053, 9655463, 10900713, 9344225, 10900515, 11162637, 11424789, 10900593, 9033197, 9049583, 11163087, 12424653, 12424497, 9655595, 9655619, 11179683, 12179115, 12179073, 12342977, 9033239, 9655859, 10245671, 10573343, 10245725, 11163567, 11507637, 11212767, 9050099, 12425085, 11196285, 10393853, 11540679, 10573871, 13342815, 10409993, 9050147, 9361877, 9050597, 9034031, 9984641, 11557533, 9345713, 11049699, 10705605, 11197125, 9361931, 9050657, 9017921, 9984593, 9345929, 9001883, 11525049, 9018311, 9034577, 11213661, 9657479, 10574945, 11459685, 9034841, 9378899, 11459649, 11525565, 9035201, 11459865, 11509101, 9035087, 10952025, 9313973, 9035465, 9035489, 9625151, 10427975, 9035669, 9985997, 10411799, 11198247, 11509557, 10412207, 9986057, 9036191, 9019841, 10953153, 9986549, 11166057, 11166051, 11510433, 10953267, 9986573, 9363989, 10412627, 12345945, 11166273, 11166693, 10838817, 10838907, 10838853, 9986921, 9626777, 10953915, 9626819, 10986699, 10986705, 10986717, 9348119, 10953855, 9987143, 10953801, 10249613, 9627017, 9938357, 9102755, 12264759, 9626927, 12264789, 9037181, 9021113, 12264993, 10954299, 11331123, 10954251, 10954257, 9627179, 9987995, 9021395, 11184075, 9627413, 9578297, 10708803, 9021569, 9021575, 9038057, 9644051, 9644033, 11233335, 10955151, 10463693, 10955223, 9038105, 10955031, 9038171, 10775193, 10939113, 9038435, 10775127, 10939269, 9989033, 10775493, 9661439, 9350129, 10775331, 9038621, 9038609, 10775355, 10775319, 9382715, 10939239, 10775373, 10939227, 10775727, 9039095, 12332037, 13823451, 10956177, 11169063, 12217641, 10775823, 9006425, 9006461, 9039497, 11169453, 9039587, 10251791, 9023099, 9039749, 11186055, 11169669, 9629657, 12447693, 9744173, 10399889, 9040025, 9990317, 9629867, 10580207, 9629897, 10465475, 9318413, 9859181, 13742571, 10957293, 9023963, 10432973, 9351641, 11170293, 9351677, 11170257, 11399469, 11399457, 9023801, 9023795, 11399547, 9351521, 9024155, 9024227, 11399901, 9318959, 9040427, 9318947, 9728591, 11399745, 11399763, 9024401, 9319343, 9991103, 11400129, 9024287, 9319259, 9040763, 10253513, 9319637, 9041111, 10925253, 11515083, 9516053, 11187237, 9041015, 10925469, 11236851, 9041387, 10925373, 12301599, 10925403, 9319793, 9025181, 9336491, 10008083, 9041489, 11319267, 10450943, 10581809, 9041711, 12449655, 9320279, 9025391, 9041765, 10402013, 9631823, 11319387, 9992459, 9320795, 9632105, 12516027, 9026225, 10877679, 10877685, 9370325, 9026285, 9009917, 9992933, 10435193, 9993095, 9649085, 9354161, 9026513, 11025393, 12532707, 9649151, 10877739, 9009947, 9354077, 9993359, 9043169, 9026987, 9027035, 9649655, 9026867, 9043589, 9027227, 12320421, 12189321, 9584333, 11484747, 11485149, 9650045, 10895619, 10862973, 10896009, 12239721, 10815165, 10897137, 9651827, 11454699, 12552393, 9848915, 12241203, 10800423, 9719069, 12422685, 10243877, 10571867, 9032117, 12341573, 11424447, 11113197, 10900215, 11424339, 10245149, 10884149, 10245191, 13702695, 12539781, 9722603, 11311713, 10985451, 12345147, 12738705, 13525149, 11100243, 10838649, 10560077, 10838859, 10773549, 13101315, 10939305, 9989093, 11397951, 9038705, 9628823, 11398371, 9645527, 9351101, 10776753, 11071971, 11071953, 10925019, 13333311, 11318463, 9647147, 10712157, 10450499, 10925691, 11040771, 9353639, 9615731, 12237693, 12450891, 10927569, 10944699, 10879041, 11387343, 11551101, 11387757, 11388189, 10716831, 11389059, 9357599, 10930845, 10799643, 11389707, 10883901, 13341855, 9360629, 9606785, 10901267, 9347099, 12263547, 11002209, 9855587, 9856427, 10579391, 10891425, 11415729, 10793649, 10794591, 9779333, 11319447, 10795767, 12369321, 9780647, 10960605, 10764183, 12239301, 11075889, 9355937, 12551361, 11224101, 10799559, 11013537, 10276529, 13143711, 12341223, 13340835, 10949523, 11424927, 11163051, 11163591, 10901283, 11032923, 12180633, 11017449, 10771461, 10771893, 10984991, 11444055, 11378945, 9085667, 11395587, 12264393, 10839243, 11036151, 9856295, 11003559, 11396721, 11020743, 10939125, 11464323, 11464413, 10694363, 11448021, 10956765, 11235147, 11120649, 10777041, 13644477, 10924761, 11317833, 11171655, 11450613, 10877847, 11467731, 12237867, 10894647, 13532793, 10715151, 11125005, 10863327, 9749471, 9798903, 10798671, 10798683, 11175819, 10798857, 13338417, 11029113, 11029383, 11226849, 12308283, 11194977, 11146185, 12342083, 10572881, 10245497, 10982945, 10245899, 10753899, 11033187, 11508603, 13344135, 11361555, 11460321, 9788933, 11017833, 10772601, 11067729, 9855965, 11036097, 12330297, 10938135, 9349613, 12298851, 9628235, 11038329, 11055087, 11398923, 11022081, 9368207, 12301005, 11236521, 10696125, 11449821, 10008281, 13022745, 12236979, 9631901, 12237237, 11172459, 12237393, 10894995, 12303909, 13336755, 10518545, 11583933, 9650621, 10502597, 12370197, 9781895, 10961541, 11584131, 10437335, 13337205, 11355015, 9798821, 12403961, 12518451, 10028117, 9815105, 9749615, 9422255, 10438109, 9373013, 10503815, 10716819, 10716729, 9684515, 10716777, 12600849, 11126349, 10815399, 10553129, 10503947, 10077995, 10078031, 9799535, 9750755, 9799733, 12273729, 9783719, 10799603, 10439147, 10062311, 11520645, 11520759, 11520597, 9800681, 9538643, 9538625, 9784445, 12373401, 9801023, 10079603, 10505549, 9785129, 11112309, 9801575, 9703553, 10522853, 11112687, 10506341, 11112513, 11112519, 12423561, 11325945, 10801425, 10801437, 11293029, 9818765, 13931241, 10506869, 10507229, 10441553, 10015985, 9360779, 11212269, 9688325, 10048769, 9360659, 9360677, 11064651, 12326559, 13342461, 9967313, 9934535, 9328355, 12326463, 11622281, 10508225, 10574003, 9820247, 10246235, 10901931, 9820607, 9738683, 9722315, 10525049, 10901835, 11311773, 10508945, 10525379, 10017311, 10017299, 9771971, 10460141, 9837335, 9362207, 9362213, 9771863, 9542477, 9542849, 11050197, 10738737, 10509377, 9379223, 10083773, 12180975, 10083821, 10378541, 9543377, 10509947, 10739637, 9805787, 10526657, 13672275, 11149521, 11591685, 10526837, 10510769, 11149755, 10035671, 11002305, 11149767, 9806309, 11460897, 10510649, 9806129, 9790175, 9741023, 10511099, 9757439, 10035749, 10084943, 11313783, 9610163, 11150211, 10757009, 9823199, 9675521, 9675533, 10511225, 11297955, 9790871, 10052999, 11576751, 11593179, 10839387, 9348761, 9348629, 10430003, 9447317, 11347917, 11315141, 10807157, 9857195, 9545939, 13510827, 9791543, 9791573, 11298915, 9726071, 9775571, 10037747, 10053917, 9644309, 10529051, 12315365, 9890543, 10005017, 9546347, 9792413, 10628045, 9808691, 12528891, 10939599, 13118535, 9759755, 10529813, 9759779, 11332683, 9334169, 9334193, 10513901, 10530125, 9842321, 9842237, 9367073, 10513937, 9105011, 10514339, 10432403, 9793451, 10514237, 11251557, 9809765, 9105275, 10531061, 9810161, 9728447, 10531307, 9744893, 9794213, 11088543, 10515179, 12219107, 10531547, 10777197, 10040261, 10040315, 11088657, 10040099, 9794375, 10466123, 9810803, 11088729, 11121843, 9352337, 10515593, 9794759, 9827573, 11302089, 9352247, 9352295, 10253723, 10630547, 9352559, 13514457, 11368115, 10516109, 10516205, 11400945, 10515971, 11400819, 10925985, 10925997, 10926027, 10925943, 9811817, 10434701, 10041377, 9615761, 9337235, 9124259, 10041809, 12302643, 9337121, 10516751, 12302715, 9337169, 12302685, 12450465, 11188887, 10042103, 11188785, 9337409, 10435487, 10501025, 12549027, 12450585, 10025807, 9567401, 10501349, 9682121, 9813245, 9682145, 9796835, 12450867, 10501169, 9813005, 10501505, 9829883, 10501421, 9797255, 10501883, 9338423, 9797195, 9813623, 9076631, 10534847, 9322409, 11173875, 11173839, 11173845, 11484981, 10518293, 9076535, 10501955, 12435267, 10961067, 11518149, 11518071, 11518215, 9634433, 9749171, 9536255, 11518503, 11518803, 9782453, 9372839, 10814703, 12338211, 11437083, 12240315, 11552169, 10421633, 12240153, 12600587, 13518585, 10258133, 10258175, 12240579, 12240425, 9324419, 13518621, 9324545, 12240921, 13764615, 11569599, 10439135, 10078493, 10717449, 12339531, 9357995, 11536941, 9783869, 10455599, 11242443, 12848033, 9358091, 11242635, 13880825, 11111907, 11275737, 13192467, 10423871, 10243637, 12226049, 10243673, 11538039, 10719165, 10801125, 11210931, 9785525, 10457279, 10408427, 9621989, 11112771, 10441391, 10441415, 10719957, 9720443, 12374601, 11260713, 11424933, 11064483, 11539599, 11424801, 11424825, 11424777, 10900971, 10458599, 9328319, 12326433, 10458671, 10901013, 10524581, 10901403, 10721277, 10901445, 9590549, 10246007, 10754231, 10721415, 13523085, 11229399, 10573829, 10328105, 12540339, 10049975, 11049675, 9280013, 10902069, 11049585, 12426129, 10017701, 11525289, 12426405, 9346253, 10575077, 11050233, 10575095, 12180489, 11230305, 12180585, 12180573, 12180549, 11296161, 10460591, 11460075, 11230527, 12213549, 11525451, 11460267, 11525823, 10493597, 9346607, 11525751, 11460213, 11460189, 11460573, 9068531, 11460369, 11526279, 11149527, 10002857, 11149713, 11215125, 11231601, 9364109, 12362415, 9364157, 9659045, 9364145, 9364259, 10396511, 9364625, 12330117, 9348317, 9774089, 10249619, 10249655, 10249649, 10986957, 10462529, 12347073, 10610177, 12264969, 10331741, 9332291, 9856943, 10544903, 11265891, 11216739, 11249511, 9693425, 12348045, 10939323, 11217909, 9694073, 13823193, 10513625, 11496507, 12528765, 10464701, 10775949, 10776009, 11234655, 9121295, 10579487, 9006719, 10252211, 10956693, 10776567, 11317235, 10252265, 10776375, 12333201, 11579631, 10465301, 10694765, 9728399, 11530653, 10006979, 11088351, 9859343, 10481975, 9728747, 11400123, 11400117, 9745349, 10957761, 11219823, 11400033, 11531103, 11400375, 12547209, 10253477, 10466501, 11220165, 11400237, 10482719, 11400231, 13759491, 11400261, 11531649, 10450181, 13514067, 11220309, 12449469, 10925733, 10925727, 11187957, 11400903, 13334199, 11236923, 9860723, 10532423, 10925661, 12302223, 11220819, 11319465, 12351675, 10467461, 11319393, 10582097, 10713507, 10467767, 10451435, 10009061, 10516739, 11532999, 10959411, 11238303, 11533287, 9698273, 11516799, 9354479, 9354299, 9354317, 9354323, 11484573, 11222313, 11025669, 11222379, 10485071, 11025777, 10485377, 11533959, 11222763, 9698909, 11517927, 10485713, 11517735, 12238625, 9699125, 10501907, 12517545, 9683111, 11173953, 9634229, 10863075, 10863045, 9732365, 11518329, 9634175, 9355997, 11518911, 9749303, 12240063, 9782441, 11551941, 11437095, 11437149, 9749981, 9798935, 9815327, 12240159, 9749825, 11240787, 10438307, 11224701, 11519553, 9717617, 10815315, 11208891, 9324725, 9717929, 9882029, 11209017, 11569497, 9357977, 9358055, 9357893, 11586339, 9325373, 9702803, 9719177, 10014155, 10243727, 10243757, 10505783, 10243703, 9326195, 10801035, 10801107, 10800993, 10800987, 11112675, 9539777, 9326609, 9326657, 9982361, 12325275, 10441205, 11243859, 11523045, 11424765, 9360359, 10457981, 11211615, 11424963, 11523177, 11424885, 9360497, 12342677, 12326295, 10442213, 11425149, 13342001, 10573733, 10246139, 11147217, 10245893, 11229051, 10245965, 9951089, 10901313, 10901331, 13342953, 11212911, 10000685, 11049663, 11246277, 11049693, 10902051, 9280061, 12425841, 9362027, 11606619, 11049861, 12180363, 9345989, 12180471, 11049741, 11541375, 9345917, 11049813, 12164285, 10574981, 10574999, 12180525, 11525169, 9329765, 12426675, 11214231, 11050317, 11460237, 9084503, 10034801, 10002317, 9691061, 9773009, 10264373, 10460963, 10411841, 11002059, 11247831, 10477595, 9855005, 11001933, 11001951, 9675167, 10428833, 11002173, 12214551, 11002143, 9364097, 9724571, 9364121, 11526909, 11199177, 9364199, 9871967, 10445387, 10839039, 10838997, 10839003, 10396475, 12215133, 9364493, 9692255, 10249631, 10249661, 12264855, 11249049, 12264951, 12346857, 11216331, 11232525, 11527857, 10987017, 10987029, 10249763, 11527773, 11200425, 9103247, 9856877, 9709595, 11200635, 9988511, 10414373, 9349763, 9349799, 9103919, 12348021, 9677711, 10939275, 11217819, 9350069, 10939371, 10628093, 11529009, 10431341, 9366671, 9366689, 10955925, 9366713, 11217933, 12332043, 10775667, 10005569, 10005575, 10956099, 10956111, 12349077, 12332787, 10251971, 10252001, 10956309, 11529747, 11513421, 10579547, 9957251, 12398571, 10956741, 11087811, 11317409, 10956981, 10956939, 11219175, 11251905, 12333093, 11202609, 10957059, 9859409, 9859433, 9990875, 11219523, 12350349, 9909203, 10711809, 11252571, 11531451, 10253495, 10253489, 11187333, 11400599, 10778097, 11187669, 12449085, 11187579, 10417685, 11220519, 10713009, 11532177, 10467233, 12302319, 11188221, 12449565, 12302193, 12302181, 11319483, 9697307, 10582019, 11319405, 12449883, 12368301, 11532693, 12450285, 12302691, 10008899, 11188881, 10009097, 12335739, 10877871, 10877865, 10877877, 13335507, 9698237, 9124811, 9354233, 12450579, 11352909, 11549505, 11221845, 11254953, 9338063, 11533563, 11025609, 10058813, 11205735, 12450885, 11517417, 11025879, 11025717, 11517507, 10420139, 10715127, 11222991, 11517723, 12402539, 13533429, 11174121, 9338969, 12369987, 9798101, 10436957, 10486433, 10502789, 10502699, 10044005, 9782231, 10519529, 13517727, 9749447, 11305935, 12551109, 9798479, 9782129, 9798527, 10044551, 9749507, 11437161, 10503251, 11126253, 11306283, 12617085, 9750197, 10536581, 10503917, 10618583, 10503737, 11126277, 9815987, 9750521, 9799655, 12240681, 10766141, 10078007, 9701189, 10045625, 9324719, 9619667, 10012865, 9783377, 9799793, 9783743, 10504451, 12274365, 10046099, 11307711, 10046135, 9014015, 12372513, 9800255, 10504775, 11324373, 10505033, 10013537, 9784169, 10505345, 9800909, 11603391, 10046885, 11587053, 9588209, 10505525, 12340983, 11587275, 9817721, 11112411, 11112405, 11112231, 11112219, 10506425, 12374151, 11112651, 9736253, 10506257, 9719909, 10801557, 9769379, 10506881, 9753311, 9785861, 9769565, 9769571, 9753527, 10031897, 9753353, 9753383, 10031993, 9753455, 9786515, 9786521, 9524243, 9819155, 11572269, 9704885, 10048937, 10524059, 9704873, 11425053, 10753781, 11310669, 9803699, 11556855, 12326853, 13506411, 9787187, 9787181, 11212635, 12540063, 9066701, 10508327, 10524701, 10737771, 12523941, 10508675, 9787709, 10508555, 9787685, 11573613, 10508801, 9787973, 11311731, 10001303, 9771905, 12540903, 9280325, 11050149, 9788633, 10034375, 12426735, 10526195, 12180957, 11656509, 9084581, 10493639, 11296467, 10083899, 12426843, 11574861, 11149215, 11149485, 9806033, 9806069, 10887189, 11002281, 9773327, 11149665, 10510703, 9806159, 9740939, 9789977, 10035785, 9806801, 10511351, 9806831, 10625801, 10511591, 10511411, 9102359, 9790499, 9790853, 10511801, 12166559, 10839333, 10839357, 11085159, 12363105, 9790829, 12265149, 9791117, 9545417, 10987455, 10987407, 10512269, 10512173, 10987341, 10512419, 11348007, 10397747, 9791525, 10512653, 10512665, 10513121, 10513145, 10628069, 11660457, 10530041, 9334013, 10513451, 10513529, 9792587, 9088085, 11496945, 9334247, 9793175, 9793157, 11497023, 9547313, 9793061, 10039247, 9793481, 9793301, 10039145, 10514267, 9793385, 10039427, 10514567, 10514657, 10039535, 10481669, 10514531, 10252355, 9810323, 10056125, 10055981, 10498427, 9793889, 11236005, 9335477, 9368279, 9335537, 11088465, 9663083, 9778067, 9335681, 12940245, 11236137, 9335993, 12563649, 11383823, 10515563, 9352259, 9335903, 10417433, 9336065, 9336137, 10515815, 12547401, 10499417, 10057307, 11400825, 10516391, 9074561, 9074657, 9730031, 10516289, 9074549, 9337007, 11303115, 10516583, 13514799, 9336941, 9648227, 10500533, 10041821, 9517505, 11319801, 9992687, 9779693, 12302649, 9632033, 12302703, 12663099, 11188875, 9337565, 9779723, 9796145, 12450315, 9779777, 12450393, 9747365, 12450765, 10025789, 11320089, 10500893, 10500959, 11304105, 9682091, 9682127, 10878003, 9354629, 10501553, 9354665, 10042817, 10501583, 9797279, 10043009, 11484855, 10960575, 10042889, 9076613, 10518401, 9076487, 9666653, 11223165, 10863051, 11125425, 11518605, 9536111, 11437041, 9667811, 11208273, 9324527, 11208525, 11192463, 9980081, 9652415, 9603245, 11192523, 9668633, 11208771, 9111965, 12339705, 9783755, 9668987, 11209239, 10423043, 12536601, 9685865, 12324285, 9768503, 10571765, 10800933, 11538291, 13733975, 10899501, 12537867, 9687107, 10391675, 9851291, 10801587, 9032171, 10408253, 10408235, 11178753, 12751659, 9360245, 10900629, 10900719, 10900689, 11424837, 10900569, 10900941, 10900959, 10900815, 10901181, 10901127, 10000037, 10573523, 9688631, 10245749, 12179355, 12179439, 10573577, 10000211, 9705689, 12425637, 9279941, 12327285, 9345749, 12180393, 10574993, 9690323, 12213441, 12426243, 10411097, 11213919, 10411355, 11198205, 11181765, 11197977, 11460183, 9674699, 11460381, 9674585, 11001915, 11001963, 11526639, 9658679, 11198787, 9363971, 10412597, 9675329, 9692039, 9675755, 12231453, 10396463, 10986723, 11183145, 10839075, 10839081, 9348209, 11281833, 12264921, 11511141, 10249559, 9856733, 10413761, 9594611, 12265059, 11511711, 10708887, 10954503, 10708761, 9856841, 10430615, 11217141, 13035693, 9660431, 9644147, 10758497, 10955073, 10955481, 12790749, 10775523, 10939341, 10939179, 10939191, 9677579, 11234049, 11529075, 10464125, 10939215, 11513007, 10775739, 11513085, 11185395, 9661877, 10038725, 9366791, 10775919, 10710339, 10006025, 11185665, 10448477, 12332961, 9301997, 11513667, 11088075, 10039733, 9679349, 12448113, 11366721, 10433081, 11400051, 12448605, 12449007, 10253375, 10466369, 9679979, 10925487, 10925565, 10925511, 12301593, 9664133, 11220657, 11171373, 8992277, 12301839, 12301929, 10450817, 9320375, 10582007, 10712877, 9860873, 11400963, 9336671, 11516067, 9681107, 10467353, 10713585, 10025633, 11483709, 11483673, 10418729, 9370409, 11598999, 11189445, 11025411, 11025513, 9354305, 11189667, 12352995, 11222493, 11025753, 9354905, 11484813, 10714707, 11190063, 13336323, 10797195, 12419373, 10797765, 10994583, 10765475, 10995363, 11013651, 11014089, 10244957, 10769571, 10769421, 10720515, 10769679, 10770357, 9280307, 11394111, 10772679, 10838067, 11395161, 9333335, 11005035, 10890573, 11398815, 12317309, 12236115, 10762067, 12237051, 12237249, 10894023, 10992489, 10877811, 13614141, 12304125, 9334913, 9334859, 11173977, 9335231, 9830825, 10478039, 10801461, 10510643, 11088231, 9773741, 9675473, 9777905, 11149899, 12370503, 10040219, 13517763, 9774281, 10778043, 9770495, 12301761, 11064633, 11289915, 10630409, 11064645, 11126109, 10806963, 11400957, 12727953, 11400741, 10987401, 9058265, 10901739, 11319705, 9333197, 11319663, 11320059, 9665441, 9333689, 9747203, 10504967, 9346157, 10898871, 12398037, 11627885, 11173533, 9334517, 11251311, 9834263, 10055435, 9334583, 11173725, 10518539, 11173995, 10437119, 10437101, 9814325, 9732413, 9814307, 9732425, 10486445, 10961469, 9815009, 10863381, 12600189, 13337361, 13517919, 11584515, 9765923, 11584629, 10765379, 10519961, 10601789, 9749831, 12535107, 12535449, 9815717, 10716867, 11126313, 10061723, 10815441, 9717605, 10241903, 10537103, 10504349, 9324761, 10406135, 10831937, 9816539, 9488729, 9767267, 11602623, 11520693, 11520747, 9816581, 10472033, 11586549, 10013645, 9685991, 9800453, 9358493, 9784571, 10505639, 10784207, 9784589, 9817439, 9604853, 12537471, 11341725, 9064403, 9817925, 9638111, 9375995, 11112507, 11588019, 10801641, 10801617, 13521249, 9818861, 10539809, 9786221, 9819269, 11326479, 9802799, 9344081, 10507703, 10507649, 9803171, 10507763, 11064693, 9360737, 9967319, 9803471, 9819899, 9803273, 9820037, 11376639, 11212671, 11589441, 10065773, 9476201, 9820625, 10049897, 10050221, 10525427, 10050101, 9820949, 11590467, 13524141, 10542131, 9804803, 11312517, 11672865, 10542365, 11050263, 10346123, 9805361, 12181005, 10051145, 9838535, 9805769, 10510277, 10510289, 10051601, 10068017, 10510445, 11149701, 9806303, 11461119, 11329989, 9806525, 10756643, 9544223, 10084949, 9806453, 11150259, 10265585, 9364253, 9741107, 11150199, 10527887, 10511579, 11314203, 9364553, 10511477, 11330673, 11298303, 10839339, 9331997, 10839345, 10839303, 10528007, 10839327, 13624605, 9348671, 10561151, 9824147, 9447305, 10528571, 10790681, 9857159, 10496129, 9709745, 9742565, 12544203, 10987557, 9545843, 9808211, 9104003, 11365071, 10628009, 10480529, 12462849, 10038113, 10513589, 9563345, 10513649, 10448123, 10022117, 9088385, 9334175, 13348305, 10513853, 9334199, 10513913, 10513703, 9809159, 10513667, 10530077, 11595021, 9809219, 9743693, 12512937, 12168905, 10055243, 10415741, 9809843, 10432505, 9105377, 10580141, 11088573, 9040397, 10777113, 9810869, 10531739, 9810923, 9352367, 9794771, 10056941, 9352283, 10777683, 10057097, 10548665, 9336455, 10516097, 9336497, 11400939, 10515977, 10057259, 9811529, 11236929, 10516403, 9730019, 10926045, 9336635, 9336665, 10516343, 9713795, 10057919, 10434767, 10565681, 10057739, 12548205, 11336079, 10484147, 12302721, 9812423, 12302793, 10058213, 10516793, 10516817, 10058081, 12450483, 12450525, 10402547, 10041911, 10058321, 10041977, 12204633, 12450711, 12450813, 10042313, 12548919, 10517297, 9108299, 12450687, 10058621, 10517681, 10828853, 9337979, 9797051, 9944531, 9354695, 11484921, 10518233, 10780211, 9338441, 11173815, 11173767, 11173869, 11173863, 10502129, 11173881, 11173887, 9813995, 11484963, 10501997, 10403711, 11026263, 11223189, 9650369, 11190663, 11583987, 10453481, 9667229, 9355943, 9355973, 11518683, 9667103, 9994829, 9356195, 11535237, 9683885, 12272637, 9995261, 11437017, 11191149, 9356159, 12240045, 11191479, 9995327, 9323597, 12239937, 12240387, 9783227, 10078127, 10815273, 9849077, 9849065, 11536797, 9767597, 12339825, 10046387, 11570163, 12373221, 10013711, 9440753, 11292099, 9768197, 10800831, 12324387, 10243619, 11112225, 11522253, 10801185, 10932251, 9670775, 11522469, 9998669, 12341579, 13341525, 11195625, 11146299, 10900551, 10458527, 9671969, 11146521, 9540953, 10573481, 10245821, 11540211, 10409561, 11179941, 9672587, 9541553, 10245905, 10245929, 11196177, 10901361, 9689207, 9279935, 12327231, 12425583, 12179823, 12179781, 9542327, 10000901, 9787943, 9345803, 9378953, 10443911, 9673937, 12180603, 11181183, 12426633, 11197731, 10444049, 9592181, 10051325, 11460207, 11542563, 10428485, 9658673, 9363977, 11559495, 10838913, 13607757, 10838865, 10986645, 9348335, 9675857, 9053303, 12264879, 12264915, 11527839, 9856757, 11544525, 11527971, 10955007, 12347613, 9054209, 11184393, 9677345, 11266581, 10775487, 9759671, 10939257, 10775715, 10775685, 9366725, 11529243, 10775673, 10775961, 10956267, 11546067, 12332487, 11365671, 10775811, 11250945, 10825073, 10775877, 10579643, 10252007, 10448441, 9809483, 11186115, 9776897, 11186361, 9662675, 11088099, 10514519, 11087955, 10695041, 10433009, 10416389, 12448035, 10760555, 9351821, 11399835, 10957545, 11219553, 11186811, 9351785, 11170719, 11400159, 11399949, 11515011, 10253381, 11220051, 9319823, 10925481, 12449031, 9319805, 11171559, 12301887, 10925643, 12449355, 11204517, 9664289, 10958613, 12302145, 9631883, 11516157, 12351531, 11319351, 11319369, 11516343, 9681371, 9320945, 11270817, 10500863, 10402529, 12450357, 10877853, 9354197, 11025399, 10419035, 10877817, 9370493, 12811467, 9534623, 11222163, 9534677, 10877967, 9681953, 9698387, 11533425, 11222441, 9993899, 9682607, 10255991, 10501721, 9797405, 10043561, 12370161, 12714129, 13516965, 11173923, 11173941, 11173971, 9716159, 9781667, 9732359, 9748793, 11272467, 9732419, 10436975, 9781889, 10961559, 10863261, 10486427, 11289321, 10863339, 10863357, 13517463, 9749051, 10043945, 10437239, 9765689, 11567979, 9766085, 11273223, 11126157, 11568627, 11126241, 11126235, 11126061, 11273475, 9782573, 9750149, 9766595, 9766601, 10716699, 9750059, 12240495, 9783221, 9799607, 9766829, 9701147, 9111383, 10520387, 9095039, 9078923, 9799817, 9767165, 9766997, 11520507, 12388623, 9783965, 11520699, 9783989, 9767615, 9784001, 9538283, 9800207, 9783857, 9783845, 9767507, 10046399, 9784091, 11570007, 9079979, 10390547, 11668923, 9768221, 11112111, 9768611, 10522133, 9784907, 10506155, 9768953, 11292477, 9768719, 11390831, 9572165, 10243949, 11292501, 11112279, 9769109, 11292879, 11112501, 9719861, 9801773, 11112549, 10506365, 9769061, 10801539, 10801551, 11292939, 10801527, 10801491, 11571867, 10031855, 9540581, 11326251, 9540791, 10015967, 9688271, 9540719, 11212173, 9541079, 11310555, 11425071, 10294541, 9540935, 10507589, 11294337, 11310615, 9770813, 10901685, 10508441, 12589215, 10901703, 11311317, 10508333, 11212815, 10901631, 9787499, 9738641, 9722285, 9099743, 11295183, 10738023, 9820511, 9542303, 9280217, 9280235, 10525385, 9099815, 9362183, 9788279, 10034201, 10837037, 11050041, 11279415, 11050071, 10034621, 9772505, 9772493, 9772529, 11328969, 12180945, 9772373, 11148963, 12361353, 11394773, 10051133, 12426759, 12426873, 9772619, 10510241, 9052061, 11280375, 10510139, 11149083, 12361599, 11460747, 10035407, 11460801, 10084589, 10035209, 10526777, 9330731, 10510727, 10477985, 9773519, 9757163, 11460927, 12558609, 9789737, 11460975, 10051907, 11280729, 11460945, 10035887, 13148835, 10035737, 9757265, 11281257, 10839207, 10036361, 9774257, 10839177, 10839273, 9774299, 10511609, 10855433, 9774149, 10576961, 12575811, 11298237, 9790883, 9102839, 10036547, 12265107, 9774803, 9774617, 11380277, 10511987, 10036859, 11281989, 10987431, 11298729, 10987395, 10037183, 10348541, 9775079, 10987299, 10512191, 9103169, 10987377, 9775253, 12527799, 9742523, 9775277, 10512587, 9545957, 9332981, 9726011, 11282463, 10496021, 11577465, 9775175, 10414481, 9103781, 9775553, 9775379, 9546269, 12462711, 9333329, 9022337, 10513283, 9759743, 9776111, 9333509, 9349931, 9333575, 9088139, 11250855, 9776339, 9776375, 9088241, 9333785, 9776141, 9759791, 10628213, 10038389, 9776561, 11578863, 10038563, 10038599, 11283783, 9776819, 9334439, 9334511, 10038791, 9629627, 11333529, 9777137, 9334559, 10039079, 9334649, 10252445, 10776705, 11284713, 9334985, 11301105, 10776777, 11284503, 9334907, 9777557, 9318809, 9777617, 10777059, 11088381, 9794045, 9335069, 11235597, 9744731, 11088249, 9777479, 9777473, 9810281, 9335519, 10040039, 9777773, 9352079, 11285397, 9352157, 9401315, 9352181, 10499201, 10630397, 9516107, 13759521, 9778589, 10057169, 9352475, 9778517, 9778499, 10516139, 11286165, 11400909, 9778931, 11400831, 9336401, 11564997, 9074675, 11286747, 9730055, 9779303, 9091457, 10959273, 12450207, 10959255, 10500509, 10516757, 12302661, 9763493, 9747167, 10959423, 12450417, 9665453, 10501079, 13531983, 9780017, 12450669, 9092279, 10009793, 10763321, 10959957, 11336793, 10501559, 10501625, 9698795, 10960179, 10550915, 11026161, 11484867, 11173779, 11484939, 9797489, 10485923, 10469537, 9732293, 12353757, 11583699, 11567301, 13336683, 11174001, 10502609, 10486055, 9765599, 10863153, 10863201, 9765443, 10011257, 10863171, 9110327, 10715985, 12354663, 10028129, 10372535, 12240279, 9684473, 10716531, 9717407, 11257491, 11126301, 12355533, 10586069, 10258403, 11258049, 10438715, 10471469, 9538025, 10029407, 9849155, 11569833, 9800375, 9292391, 10439573, 9767927, 9833651, 8998295, 9751811, 11259207, 11112171, 11554425, 11112327, 10244051, 9064199, 10030973, 9769145, 10391723, 9736361, 12242975, 10801221, 10801239, 9720305, 9081125, 10490537, 12342233, 12162005, 9344237, 10507265, 11555955, 9704855, 11572515, 11212059, 9360695, 11064597, 10491599, 10246025, 10246073, 12343517, 10574039, 10901559, 12343319, 10901601, 10901577, 10901967, 9738557, 10901871, 9034109, 10901853, 9362087, 13097607, 10492817, 11049945, 10459931, 9050939, 11049819, 11246781, 12180639, 11050131, 11541753, 11263017, 10034183, 11295813, 10083749, 9100751, 11542005, 12180777, 10575155, 10476851, 12426603, 13508169, 12230171, 11460591, 11149269, 11558697, 11559045, 11002341, 10511075, 9757307, 10723923, 9757283, 10085297, 9708455, 9773939, 12215445, 9774245, 9331943, 12231689, 10839117, 9692423, 11396831, 10987131, 12691401, 10577807, 11249619, 9332909, 10037423, 9857045, 10037261, 9742775, 9742607, 9333467, 12348003, 9776051, 9087971, 12348207, 10726149, 10792127, 9333923, 10939443, 9743399, 10939461, 10513487, 9006737, 9777083, 10481585, 11235291, 11382743, 9777131, 11088057, 11235465, 10252493, 10694861, 12349635, 9302021, 10776597, 11284923, 9662951, 11563461, 9335051, 11252055, 11317913, 11317811, 11088387, 12366351, 9728903, 10515257, 11400357, 11400381, 11400441, 10253549, 10958313, 12219881, 9778493, 9532709, 10925763, 9779135, 12449931, 10533101, 10516703, 10958961, 12449889, 12449871, 9025937, 9779957, 11270661, 11369367, 10959651, 9747275, 10058891, 9714707, 11549781, 9354359, 11025843, 11271555, 9534947, 10960137, 11271495, 9076463, 9780845, 11173677, 10764113, 10502285, 11239785, 12157283, 9093887, 10863321, 12337713, 9028121, 10863213, 11568027, 12272583, 11551935, 12240015, 11551797, 9061433, 9717143, 11240937, 9012695, 12240141, 12240255, 12551535, 11126331, 10077965, 12355347, 11257677, 11225217, 11537127, 9669347, 12339741, 11274825, 11422635, 12274647, 11225877, 9719171, 10243823, 11226915, 10243847, 9031877, 12767325, 11210871, 9064553, 11259987, 9048575, 11211603, 11424909, 9573539, 11424969, 9720911, 9360467, 12358725, 10048973, 12326235, 10474865, 10016405, 9819857, 10901241, 10901193, 9066107, 10573823, 10016915, 11229351, 11540583, 10246415, 12359967, 9771377, 12556983, 11311863, 10803923, 9345995, 9346031, 12426207, 10017791, 9346019, 12426189, 11049939, 9100049, 12426429, 11049999, 11230335, 12180927, 12180783, 11230845, 12427095, 11002107, 11002227, 10478219, 13525749, 12558879, 10445705, 11297679, 9692387, 13706241, 13509687, 11544039, 9774581, 10987047, 10249751, 10987065, 10987119, 10987095, 9856901, 11315135, 9856949, 11233173, 11233251, 9824063, 11233047, 11233101, 10496027, 11233719, 9709961, 9103871, 11315501, 10758461, 11315945, 9349841, 10546079, 9349979, 9825149, 9776183, 10939395, 11562099, 9776555, 10022393, 10776231, 10432253, 10776279, 10776087, 10514045, 11316809, 10579535, 11579289, 10252259, 10252037, 9334619, 12349887, 11547063, 10023197, 11301159, 9056519, 10973825, 10957461, 10957551, 11547369, 9712241, 10007141, 10957725, 9351941, 10957593, 9007979, 10957647, 11252919, 10433723, 10482911, 11400405, 12334197, 10712499, 11400507, 10712397, 11400879, 9713393, 10712643, 11270019, 9861071, 11188191, 12449553, 9713465, 11188077, 12449613, 10025099, 11188407, 9615569, 11319507, 9779249, 9795989, 10500521, 13515261, 9779489, 10025609, 12548805, 11172609, 9354395, 9354407, 11598981, 11025633, 10763265, 11025855, 11025915, 10436183, 8994713, 11272167, 11239179, 10714947, 11174043, 11272419, 10731729, 9781271, 11272635, 11174355, 9781601, 9781613, 11305521, 9749003, 11567643, 9781841, 9765803, 11305977, 9995051, 11437119, 9749567, 12354675, 10028315, 12354879, 9782609, 9782801, 12240449, 12797913, 13158369, 9701141, 13748457, 12896439, 10029551, 9341615, 10504835, 9767453, 12601941, 10472051, 9538175, 9112535, 9800651, 11520771, 11291823, 11521167, 11390111, 12356739, 12848319, 9030707, 9325925, 10030667, 12373611, 9785297, 9736187, 9769127, 9638081, 10801353, 10522661, 11293089, 9081257, 9540095, 9753095, 9753149, 9540485, 9770207, 11605245, 10032359, 9704813, 10524191, 12326793, 10901463, 10901649, 11294769, 9788033, 9280145, 9542231, 9755777, 11050017, 12180903, 11263359, 11443551, 11149029, 10510067, 12181197, 13688415, 11149473, 11460795, 11149443, 11149515, 12918969, 11460669, 11460663, 11460657, 14000253, 9609635, 11542839, 9757019, 11002233, 9036539, 9740861, 12362241, 9101927, 9773969, 9774071, 12542739, 11264787, 12559527, 9790607, 10839159, 10839129, 10724793, 11543895, 11314503, 9545441, 12527589, 11560941, 9775085, 10037219, 9726059, 11561391, 10496369, 12561129, 10726095, 10037789, 9776069, 9349901, 9825053, 9775949, 11561823, 11414735, 9333803, 10939491, 10759553, 10497347, 9006821, 9334529, 9744155, 9744239, 10252433, 11383289, 9859523, 11088375, 10498499, 11088183, 9859601, 11317775, 9859673, 11236233, 9352037, 12809019, 9761819, 10515893, 11400531, 9778919, 10958553, 12662373, 9746027, 9779093, 9779315, 9763283, 12302625, 11565417, 11270517, 9763559, 9780371, 9780437, 11566275, 9092213, 11484627, 11173227, 9780551, 11484537, 11026131, 10960431, 11484675, 11271747, 12516951, 11484759, 10764083, 12574947, 12230781, 10043873, 12231681, 12420375, 12264717, 11388873, 10242713, 12225161, 9350381, 9350369, 9350555, 10579313, 11390883, 10875075, 10572173, 10949115, 10244597, 11170245, 10850775, 12259971, 10572323, 10850901, 10761117, 11383803, 11383857, 10834947, 10761717, 11392377, 11384145, 10852017, 10885281, 12236817, 12253599, 10795317, 12237183, 9943361, 12253809, 12262155, 12262569, 12254445, 9550883, 12230109, 10911237, 11386827, 12255033, 11395233, 11395257, 11395461, 11444547, 11452755, 11289261, 10945229, 10798005, 10797963, 11396085, 9855869, 12231503, 10798233, 11183307, 11453529, 10814943, 10798389, 10815009, 11061045, 11659119, 11446107, 11397261, 9611387, 11078277, 9366491, 11004711, 11053851, 10693821, 13028505, 11013339, 11292123, 11021895, 13512603, 12234695, 9351023, 9990341, 11423943, 10924245, 11317929, 13513461, 13644363, 10572719, 10572767, 10998915, 10245161, 11007093, 10614185, 9991613, 10696077, 11024037, 11450019, 12236463, 12236517, 12236499, 10769931, 10770405, 10893069, 11024151, 11212995, 12236841, 12236835, 12237297, 11000085, 10377929, 10771011, 13122519, 12295107, 11017023, 12294999, 12295569, 11009331, 10984731, 10984791, 11009679, 11443749, 12312183, 12255477, 12247047, 12230925, 12231363, 10790079, 10364033, 12264537, 12223803, 11380433, 11388471, 10790481, 9348965, 9857213, 10791111, 13519359, 9627953, 11315967, 11316597, 11448207, 11423727, 9907997, 10760019, 10760439, 11407641, 11407707, 10826379, 12227577, 12227571, 12227451, 10695891, 10925115, 12227607, 11383839, 12227589, 12227961, 11155095, 10761933, 12228207, 12236709, 12236769, 11417727, 12228687, 10762971, 10993029, 9543167, 11411109, 12246627, 10821531, 9347051, 11395083, 11395173, 10862703, 10797459, 10994145, 10797717, 12419781, 9626123, 10797591, 10797597, 11461605, 12420081, 10388285, 9855815, 10798227, 9684221, 12420459, 11028201, 10798785, 11027979, 10798623, 12297987, 11004069, 9848873, 12560505, 10799391, 10799787, 10799757, 11398029, 9579455, 12667809, 11013357, 10923219, 10890249, 11062581, 11439849, 9350879, 10923591, 10891173, 12292023, 10407929, 12447681, 10989357, 10768581, 11104281, 11423811, 10892025, 12235329, 12235689, 10253279, 11072493, 12235773, 10245083, 10892241, 12235719, 10244975, 10769541, 10572953, 12235815, 10999173, 12236169, 12236067, 9639209, 12285311, 10769739, 12236103, 11015823, 12236433, 10770165, 12236661, 10770255, 9943259, 9353453, 10991679, 12236829, 12236913, 11000079, 10893591, 12237057, 10402541, 12425763, 10254917, 11230095, 10025813, 9944495, 12344601, 10772115, 10985199, 10837701, 10993641, 11394885, 11435847, 9846935, 9633941, 10412165, 10960899, 11001927, 12329031, 12272037, 10862985, 9699629, 12271953, 9986735, 12239583, 12239571, 9986585, 11125287, 9355811, 9355835, 10953243, 9355841, 10035791, 12239469, 12239451, 11436975, 12239745, 9651119, 11191281, 9348083, 12321579, 13345551, 12240009, 9675977, 11175135, 10003463, 12239973, 9651305, 11208123, 12264861, 9987545, 12322293, 9651701, 12264897, 9856259, 10405127, 9856703, 9856565, 9856553, 9987677, 11511387, 9988055, 11167503, 10454825, 10815261, 9463661, 9988229, 9627881, 9644063, 10012733, 11504025, 9374171, 9996743, 12323121, 11176293, 9349853, 9349661, 9349667, 9628253, 9349727, 11184759, 10955769, 10939137, 9653057, 10775361, 12217521, 10407101, 9628877, 10775775, 9366563, 10579367, 10251707, 10800807, 9670355, 11579127, 9973451, 9858803, 11529765, 10579505, 10440233, 9989753, 11169705, 11505609, 10407701, 9957179, 11161455, 10399919, 9629861, 9629927, 11178105, 12447843, 9990545, 11145633, 11399601, 11399565, 9679307, 9360065, 10760915, 12448317, 9351689, 9351683, 11170365, 11399787, 9991061, 10900359, 10408733, 11424563, 10925247, 10900731, 10253561, 9360503, 9581957, 9991637, 11507187, 11064609, 11064687, 12449109, 10409621, 9615071, 9590525, 10901205, 9623093, 9991763, 12301935, 10573433, 12424779, 9992093, 11319279, 9975755, 12425061, 9992057, 10581827, 11540637, 9992441, 11221191, 11171949, 12425613, 10402223, 9361847, 9361883, 11049249, 10418489, 10402121, 11516247, 10025315, 9345677, 9984701, 11205273, 9788135, 12450507, 12319293, 13032033, 10410605, 9992801, 9354173, 9354167, 9534461, 9649121, 9353987, 10877823, 11164845, 12573741, 11164695, 9419843, 9649625, 12320235, 9993719, 9993701, 9649427, 11509437, 9657989, 11394803, 9986015, 9625541, 9650165, 11509701, 10411895, 9994421, 10862817, 9986279, 12271671, 12271695, 12239277, 12239271, 9642419, 10953111, 10862895, 12239145, 12525855, 10035551, 11207007, 9642641, 10838751, 10035731, 12321321, 9642509, 11461149, 10863135, 12345963, 10953651, 9634697, 12239673, 9642767, 12239625, 11158695, 10249391, 12240105, 10757327, 10986501, 10077221, 9626747, 10249331, 10249319, 11142561, 11388299, 9856445, 9856421, 9856475, 10708467, 12264747, 12264729, 12264735, 10954107, 12264807, 10036577, 9643667, 10708653, 9643757, 9995819, 9627221, 10577519, 9856583, 11142777, 9528905, 10258031, 11159487, 11143095, 10774509, 9996083, 10774665, 9636005, 9652427, 9636077, 11184255, 10774953, 9660815, 9349631, 10406165, 9644327, 9628319, 9644681, 9644795, 9644603, 11143683, 9357875, 9636755, 11160501, 11086815, 9636845, 11504427, 9653087, 12217497, 9645239, 10243235, 9645173, 10775631, 10800549, 10579373, 10579343, 9637313, 9637361, 9645539, 9637355, 11161047, 10800417, 10693905, 10251587, 10800459, 10702161, 10399391, 9973427, 10702377, 12529545, 9629663, 11513817, 12234519, 9645869, 10399559, 11399025, 11505807, 9982115, 9965789, 11112645, 9629723, 9646133, 11399241, 11399259, 9687455, 9368039, 9621761, 11399427, 9351551, 12448065, 9646739, 12423933, 9351887, 11399721, 10703409, 11399709, 12301245, 11424681, 9638825, 11399973, 10425155, 10900347, 11424591, 10900305, 12301443, 11064549, 11498523, 10925475, 11179437, 11163027, 10409381, 10925355, 10900749, 11220243, 9991463, 12326211, 10581695, 11220621, 10573451, 12326655, 10925793, 10581755, 9631487, 10581713, 11319003, 10245635, 12301905, 12301893, 11319201, 11048937, 9983945, 11155455, 9991979, 9647957, 11499369, 9984185, 9648317, 9648353, 9984113, 9664955, 9632255, 11614587, 9648479, 9984323, 9648497, 9632393, 9640589, 9640619, 9632453, 13023927, 10074851, 9984533, 11049531, 9902999, 9354137, 9640721, 9353993, 9632519, 9648953, 9354041, 11180829, 9354065, 12548937, 11025585, 9641195, 9641063, 10952121, 10419695, 9641441, 9575765, 9346391, 9649535, 10346141, 9641657, 10952439, 10403531, 11026173, 10075667, 10010171, 10346039, 11157393, 9633737, 10075949, 9625409, 11387055, 12230811, 12230901, 10797099, 10764351, 10887183, 10764387, 12230937, 9855539, 11387661, 12231489, 10888293, 12412335, 11519565, 12265353, 9848801, 10905567, 12412695, 10864491, 12232851, 11389425, 10873137, 10930557, 10242587, 10766973, 12217257, 10881843, 10767177, 11389779, 12217449, 9350507, 11398803, 10792917, 9858827, 10792821, 10694847, 10695093, 10244741, 10867239, 10572383, 10245005, 10793913, 10793979, 10884039, 10793937, 10859535, 10753785, 10917579, 12236781, 10901289, 10926279, 10770633, 12237101, 11385417, 12450951, 10763331, 10763769, 10763739, 12238119, 12262755, 12230397, 10878657, 12230463, 12230469, 10772655, 11018295, 10838025, 9347531, 11453079, 11436663, 12403625, 12264447, 11396043, 11396061, 12231621, 11059977, 11535123, 9757487, 10896219, 9348143, 10700253, 11396841, 12297969, 10798635, 11462205, 11453973, 11044863, 11020245, 12421293, 9488513, 9849041, 11454687, 13101387, 12339927, 11045685, 10799979, 12307461, 11045985, 11463801, 12299343, 9416141, 11398491, 11030601, 11424177, 10899759, 11235969, 12301191, 11080599, 11318265, 11318211, 11031507, 11318043, 10245143, 10696371, 11064897, 10565873, 9639941, 12237261, 12221091, 12237555, 10893861, 12237339, 12302967, 12237405, 11107215, 11090847, 12237819, 11041755, 12237579, 10066733, 12237675, 11025663, 12238041, 12237825, 12237945, 12237921, 11664465, 11033997, 11001327, 11451693, 12238137, 9346619, 11050569, 11018181, 11042595, 11452245, 10797207, 10928361, 12288045, 12345447, 9847073, 10944795, 10887957, 10978503, 11428959, 10929585, 10028927, 10766157, 10798929, 12667107, 10946715, 9349223, 11422209, 9349697, 10775433, 10767429, 9350693, 9350753, 12234627, 10891383, 12235239, 10973643, 12235083, 10245017, 12235653, 12235731, 11391765, 10769565, 11392053, 12235803, 10876329, 10941885, 12236133, 10942155, 10614383, 10696613, 10049459, 11393157, 12343431, 12417411, 10795329, 11393367, 12286503, 12344319, 10795971, 11434797, 12450645, 10075163, 10837359, 10935975, 11427561, 10772175, 10837599, 11395029, 11231085, 10887423, 12263433, 12263523, 9921005, 10765245, 10765263, 9938303, 12265103, 10798677, 10913673, 10766727, 10766691, 12233427, 12233697, 12233505, 10947753, 12233889, 12233775, 9948287, 9915803, 9350639, 12234081, 11390769, 11317107, 10891515, 11391015, 11391447, 10244795, 10875783, 9753599, 10949433, 10777839, 9639167, 10916991, 10884585, 10777863, 12334401, 10794633, 10884651, 12236403, 11392923, 10794795, 12236667, 10794873, 10885347, 9754625, 9361793, 11393301, 10885401, 11475603, 12343815, 11394303, 10796085, 9641087, 10861887, 10796769, 10796613, 12263235, 12263487, 10903575, 9634067, 10920213, 12239535, 11387523, 10904163, 10904361, 9446615, 10904823, 10880425, 9635201, 12281241, 12412287, 11388639, 12281349, 11388435, 11388861, 9848825, 12347157, 12233211, 10922343, 12233043, 11389599, 10766865, 12233289, 11389749, 12233571, 10881915, 10873683, 10882233, 11414769, 9538655, 11390361, 11316525, 10882761, 11390985, 9359441, 12235011, 10883757, 12235395, 10572305, 10572377, 10007441, 10793967, 10794153, 10794429, 10835427, 10253621, 10941783, 9353081, 11393277, 11442417, 10909737, 10754529, 10009589, 12327885, 10795809, 10886397, 12262899, 10599941, 10870341, 10919889, 10878723, 9691325, 11206707, 9863285, 9781505, 9634145, 11518599, 9364151, 10003151, 10437371, 9536225, 12329595, 9364073, 11223645, 9700211, 12240057, 12240051, 12240039, 12240021, 12239913, 12272685, 11199537, 12239997, 11273337, 11265411, 10986903, 12240267, 12240261, 13346187, 10454357, 10986819, 10249577, 13764309, 11208393, 10790423, 11208453, 9857267, 9840647, 11208801, 10758269, 11208783, 9644153, 9652667, 10078637, 11209203, 11209173, 9775415, 13125999, 11209449, 9349877, 10447379, 11209233, 9374279, 9349715, 10431095, 9357923, 11553345, 9694193, 9808715, 12225353, 10431689, 11201625, 10694091, 10358135, 9694865, 10776159, 10710987, 12332847, 10800963, 10006373, 11211003, 12251345, 10580183, 10006589, 10252361, 10776699, 11211105, 10441253, 10482263, 11400105, 11522961, 10515443, 11269065, 9360353, 11399979, 12227357, 10777455, 9360395, 11531373, 11187267, 9688493, 12334347, 12301995, 9696929, 12547719, 10426055, 10573529, 9565703, 12285447, 12220007, 10582001, 10246091, 11278299, 9828185, 10713279, 13514991, 9681089, 12302391, 10008629, 12425313, 11524521, 10754495, 9755057, 10959345, 11524383, 10451609, 10000925, 12335631, 9361979, 11205225, 10476461, 10476497, 9346013, 9354215, 10713963, 11214009, 10575041, 11025621, 12450855, 10959933, 9698351, 11329275, 11460219, 13025247, 9600935, 11214639, 11231049, 9691001, 11387037, 10846629, 12559101, 12223377, 12330231, 9373409, 9848759, 10414511, 12241797, 12225597, 9350165, 12266865, 10251989, 12218361, 10809333, 10768551, 10760415, 9744509, 10859175, 12300807, 12341865, 12218973, 10761369, 9450581, 9352589, 9483701, 10925757, 11515503, 10761993, 12228783, 11401413, 11393403, 10787517, 12319635, 12221229, 10755195, 10755381, 10788195, 10886517, 10755735, 10755627, 12221967, 9387623, 12255153, 12230457, 12230421, 9773207, 9863297, 11001999, 9723947, 9986123, 11215257, 10723629, 9707825, 11215215, 9724241, 10461545, 10429085, 11518635, 10445405, 11518959, 13509519, 10839009, 9692153, 9675575, 9773945, 9700217, 10470605, 13345977, 9782321, 9725003, 12412329, 10249643, 10249637, 11527653, 10249727, 11232555, 12240147, 12240249, 11126127, 9684293, 12240237, 11396799, 11314833, 10987041, 12265005, 10987071, 11232837, 10487705, 11519745, 12339357, 9644195, 12232937, 11241543, 9849101, 10012961, 10316147, 9357983, 11577987, 9701963, 11217483, 10455995, 10939389, 11250453, 11209899, 13372655, 10431665, 10546397, 13110363, 9997373, 11209827, 10775925, 10776225, 11112101, 11259621, 9702935, 11210241, 9809465, 10243649, 12553803, 9858959, 10014593, 11218929, 11227095, 13659993, 11112213, 10956609, 10956933, 10719459, 11210811, 11399267, 10514873, 10006949, 10801605, 9859415, 9965897, 9351917, 11227857, 12636675, 10007123, 11539371, 9351983, 10450079, 13907159, 11064531, 11400255, 11064375, 9360443, 11219997, 10384505, 11531673, 12449259, 12227867, 11400453, 9360755, 10901151, 9541373, 11187765, 10925595, 10246043, 11220933, 9541607, 10458905, 12449583, 10901271, 10008785, 11221185, 10574045, 10246145, 11524197, 11319561, 12450063, 11147619, 10001051, 9878219, 11320305, 10877889, 11049927, 10468169, 9345905, 11025561, 9354257, 9354335, 11025897, 9534923, 11222319, 11525427, 10018469, 11460351, 11460345, 11025965, 10583597, 10550831, 10255967, 11558835, 11460507, 9846737, 10493891, 11460561, 12336897, 11222895, 11534163, 12239007, 9380561, 9650777, 9888527, 10838901, 9462629, 11404437, 10757385, 10831533, 12224151, 10807005, 10790475, 10593875, 10758033, 11388729, 11380491, 12249123, 11315283, 11405733, 10758585, 11315667, 11381421, 10791555, 10758807, 11381307, 12250035, 10808241, 9857801, 9407333, 10996797, 11381871, 12234129, 10759677, 12217659, 10759443, 12226209, 10759743, 11333223, 9350723, 11407275, 12226455, 10694439, 11431689, 11382921, 11391183, 12259377, 11383281, 10785225, 10826103, 12252087, 12227487, 12301095, 10818411, 10695489, 10761237, 12342273, 11392683, 9352721, 12244977, 10819551, 10811559, 12228657, 12294807, 10287869, 12229521, 11287299, 9567353, 10870203, 12229989, 10804563, 11484777, 10796955, 13017219, 11378735, 11174295, 11461101, 11174397, 10543421, 10068671, 9847523, 10535639, 10560221, 11616807, 11395643, 11379251, 11174421, 11658135, 10560473, 13329219, 10068779, 12403457, 10552163, 11150181, 10044287, 10970351, 10765535, 12420137, 12575871, 10962321, 10028303, 13026561, 10839411, 9807203, 9839969, 10962567, 13027053, 10544795, 12265167, 11609625, 12264981, 11667051, 9832013, 13027287, 10069937, 10545389, 10553465, 12240987, 13699113, 11545011, 11610603, 11315651, 10832345, 12544449, 9857369, 11544921, 12389025, 10554095, 9841403, 9775847, 10873553, 11545107, 10717707, 11545119, 9849401, 11356761, 10070915, 10062779, 10038227, 11520969, 12274641, 11520963, 12389163, 12462957, 10439525, 9358475, 10546343, 10538135, 11406569, 10628195, 10784183, 9842057, 10546625, 11652423, 9809549, 10514069, 10514075, 12938925, 10694237, 12390291, 13168569, 10071815, 10555157, 13529307, 12218519, 12390615, 12218411, 11612175, 10580057, 10564019, 10498505, 11112717, 11112705, 12685695, 10908005, 10555925, 9851483, 10761023, 10056509, 13529979, 11088711, 9794957, 11064753, 9360863, 9360869, 11097413, 12326847, 10319747, 10786787, 12326859, 9803561, 12326763, 12326727, 10549085, 9713855, 12548295, 10926081, 9844853, 11655255, 10574123, 13023597, 12392811, 12392805, 13695279, 11188899, 12221171, 11369163, 13523541, 12302865, 10902093, 12220997, 10435493, 12229625, 11369271, 13024005, 10050389, 12450945, 10517711, 10878051, 12450915, 11615313, 13516251, 10780061, 11377973, 10755389, 12451089, 9829679, 11050353, 10755779, 10575407, 9354803, 12222065, 13516341, 11337633, 12427143, 10575851, 10493729, 10755845, 13025145, 10862787, 11067393, 12304407, 10838127, 11076039, 10715439, 10838277, 10838391, 11059767, 9364007, 9347675, 11215431, 12239771, 10838847, 10896231, 12264525, 12264909, 9643313, 10896933, 12305985, 9848729, 11200443, 11397069, 11110245, 11396949, 11397309, 9357461, 9848903, 11463147, 11045313, 10799361, 10799433, 11053773, 11463203, 10799667, 10799727, 10897995, 13528011, 11455395, 10243283, 10579223, 11079207, 10563077, 11104119, 11038911, 10793097, 11424147, 11038995, 11088531, 11113203, 11080203, 11424753, 11318073, 11457297, 11318139, 11515095, 11318373, 11072595, 9352523, 9639269, 11072853, 11466387, 11122227, 9360983, 9983951, 11089689, 10753865, 10754127, 9353675, 9967895, 11565315, 12237471, 11475723, 11074725, 10574957, 9968705, 12238089, 10772139, 10772109, 10895007, 12345057, 10772037, 10034807, 11075163, 12427029, 10895127, 11501697, 10076219, 10862595, 12337599, 9355661, 9355673, 9986435, 9748913, 11518437, 10404125, 10862859, 12239577, 12337689, 9650771, 12362367, 10838637, 9355859, 12345933, 12239439, 10699353, 11133525, 11436933, 9348017, 9642953, 10986453, 12264627, 12264585, 9856163, 9856223, 12264657, 12264663, 11437059, 9856439, 12264957, 12264927, 10773981, 9856301, 9635117, 10774161, 9619157, 10774257, 12314331, 9856637, 11118483, 9979811, 10774479, 10774305, 12314403, 9979703, 9849017, 10774779, 11118795, 9971951, 10774587, 10537061, 10774635, 9849227, 11135361, 9349565, 10389977, 10078481, 9349487, 9644561, 9357845, 9792059, 9349691, 10955373, 12315231, 10800075, 11144043, 10243217, 11398377, 11160783, 9997337, 9382937, 9636917, 12315657, 10775649, 12217461, 11177031, 12217413, 11505051, 9629147, 10251545, 12217605, 10038617, 11398503, 10800453, 9612977, 9629369, 9989651, 10759703, 10800759, 11112381, 11399055, 9990083, 11497221, 11398941, 9637757, 9351317, 12316827, 9351365, 9367793, 9596951, 11391011, 10899879, 9351617, 9359825, 9990647, 9720095, 11301213, 10900161, 11399715, 9359927, 12325491, 10924983, 9646985, 12301185, 9524207, 11481903, 11424525, 10490633, 10900239, 9982805, 9983141, 9344075, 11384309, 10704171, 10573103, 11400471, 10573133, 9614717, 9770639, 10245815, 9639461, 9639707, 10581821, 12424965, 9984137, 13777143, 11221035, 9533543, 11508135, 12319017, 9648419, 9984293, 11123067, 11163987, 11459295, 11123211, 9353771, 9353783, 9640883, 11377437, 11139957, 11377479, 9755501, 12229875, 10509515, 9804875, 11025483, 11124171, 9985505, 9403679, 11140365, 9977201, 13631067, 11124231, 10960509, 12254789, 12238785, 11165457, 9633623, 9986051, 10567751, 10772547, 12345429, 9347507, 12239307, 11485527, 9347765, 9347813, 9347621, 12239781, 11436993, 10773357, 9528563, 12264645, 9978971, 11437131, 9856103, 9569777, 9594125, 9594179, 9856331, 9963185, 10897089, 11397303, 9849023, 11085969, 9357527, 9357419, 9988565, 10897917, 10897857, 11397441, 9849191, 10955517, 11397825, 9603593, 10799673, 11397729, 10799703, 10898001, 12217323, 12307587, 10398887, 10505297, 11398557, 9596321, 10776029, 10898727, 11070783, 11398827, 12308445, 12308433, 11047323, 9359843, 12316989, 11424105, 9351527, 10900119, 9351875, 10924929, 11457429, 11072295, 11350797, 11072283, 10245263, 9639047, 10425395, 11457639, 10925397, 10573541, 10581539, 11081247, 11318877, 10696593, 9975563, 10508153, 11106117, 10696539, 11073723, 10950657, 9648251, 9345299, 9534083, 9640583, 10877631, 10951377, 11082249, 9968177, 11090535, 9353843, 12237813, 11377533, 10460357, 11074779, 12237873, 11066769, 12238305, 11066871, 12352827, 12238107, 11099457, 10952361, 11075259, 11067189, 11427605, 10035359, 9773285, 9781475, 10960917, 10035287, 9773129, 10035317, 11149407, 9781355, 10961337, 9748919, 9494963, 11272605, 9773567, 10510631, 10060037, 10035497, 10035503, 9781595, 10035557, 9773723, 9773747, 10863345, 9781763, 9740885, 9781835, 10035839, 9380453, 9740909, 9823013, 11567997, 9503585, 11592513, 10036079, 11273043, 10839213, 11568369, 9782327, 9774167, 10036307, 10036331, 10839429, 9782717, 9774521, 11126211, 9790745, 9815351, 9807137, 10462547, 11331243, 10815105, 12265119, 11282049, 10757783, 9774767, 12265095, 11544207, 9774833, 13149861, 12265173, 9782813, 9766433, 12559995, 12240477, 10037129, 9775037, 12363771, 9766877, 9783245, 9766901, 9783281, 9766889, 12240657, 10987275, 10037087, 9767063, 10037405, 9775319, 9767153, 9857273, 9767141, 9775343, 12371991, 9766949, 10397729, 9775187, 10504313, 10061951, 10414523, 11291115, 10504571, 12585723, 9783899, 11250621, 9358277, 9784295, 10038071, 9775937, 9768137, 9767951, 13552725, 9767975, 10513439, 10038353, 10939503, 11496891, 9776603, 10038731, 10038761, 12381645, 10038587, 10808681, 9776483, 12365475, 9801401, 11570817, 12340989, 11333325, 11562513, 10038821, 10514351, 9768845, 9768887, 11284359, 9768935, 11112201, 9768797, 10243913, 10514489, 10039385, 11112537, 9752981, 12546441, 12579207, 9753053, 9859529, 10752471, 9859553, 11596053, 11235603, 10498331, 11088225, 9769337, 10523303, 9777797, 12514047, 10318529, 10031843, 9744899, 11088495, 9753155, 11563623, 9769865, 9352109, 9778127, 10474433, 9376757, 11301651, 10031945, 10507097, 9778391, 9532667, 11564091, 10040321, 10933307, 9770027, 9811385, 9778457, 9778469, 11400867, 11212473, 9778865, 12367491, 11310843, 9770735, 10032647, 12367389, 9778733, 10524257, 11581047, 12326523, 11400807, 11400777, 9770969, 9795335, 9770795, 12367719, 9811787, 10925895, 10925919, 13048041, 10573973, 9869525, 13531287, 9779225, 13039719, 11278449, 12368307, 10729857, 9722303, 10901919, 10959339, 10041833, 11573709, 11286993, 10959207, 9779549, 9788075, 9779933, 9747149, 11303619, 12368595, 10041863, 12368499, 9788309, 10959789, 12377085, 10959831, 9788393, 10509101, 12778329, 9509687, 9984845, 12369081, 9772175, 9780401, 10960107, 11050227, 9780467, 10034405, 9780287, 10501235, 11304027, 10878045, 11148693, 9944543, 9354689, 9854405, 9780713, 9780605, 11173551, 11026083, 11026101, 11173557, 10034861, 9780905, 11484819, 10034909, 12361431, 11279913, 12426777, 11173389, 9772589, 12426825, 10035095, 9772943, 11296695, 10035077, 9772961, 10518521, 10035143, 12533721, 11280327, 12361677, 9772805, 12386169, 10035011, 11485041, 9772919, 11173701, 12427077, 9781493, 12288477, 12239121, 10797783, 12263937, 12264027, 9855995, 10003607, 10937475, 10814661, 10249223, 12289293, 10798425, 9848741, 10815303, 9349289, 12290253, 9963527, 10889295, 10799499, 10775277, 13093439, 10922937, 10980183, 12422253, 10923099, 12307953, 10767981, 10047047, 9858875, 10694423, 11399343, 12292245, 12234993, 12234771, 12234861, 12235143, 12235113, 10572449, 12235431, 12235413, 9360173, 10244897, 12235629, 10925223, 12235785, 12235779, 13513773, 12236277, 10982937, 11433555, 9631703, 11392881, 11393145, 13564317, 12515801, 11393703, 12294837, 11016921, 11393829, 11393811, 11050101, 10771551, 10067045, 11394489, 10796433, 10976763, 9338189, 11517633, 11394573, 10796547, 12533355, 9346643, 11149239, 10796943, 9986195, 11370597, 12517473, 10379741, 11461065, 11002317, 12534219, 9716195, 9716207, 10420511, 10068233, 9830711, 9822581, 11174223, 11174211, 11149977, 11461173, 10535435, 11600385, 11149923, 10044347, 10019771, 11617179, 10445741, 9847757, 10961691, 10298147, 9659231, 11150145, 9823367, 13346019, 11601039, 10003709, 10535987, 9765959, 9765965, 10085489, 10937735, 10028297, 13034877, 10437971, 10061129, 10839417, 9348827, 11347665, 12387897, 11339745, 10061801, 9578351, 10717359, 12535977, 12241029, 10799123, 9972113, 9849221, 11028881, 11299221, 9750995, 9603389, 9849179, 9750863, 9750881, 9906821, 11520765, 10070759, 10005035, 10062425, 9546353, 9915371, 9497363, 9841439, 12364599, 10439429, 12225293, 9554801, 9825419, 9538799, 10538021, 12463161, 11521149, 9825761, 10546547, 11497107, 10063421, 13020711, 10530371, 10513997, 10514009, 10063769, 10055579, 11374485, 10244063, 10563377, 11112621, 11112615, 10760369, 9719987, 11112579, 9703595, 10055879, 9736283, 10580087, 10400147, 9728471, 10531517, 9859787, 11342553, 10801701, 10801665, 13521507, 9744983, 9859661, 10032083, 10032113, 10064873, 9753581, 11088681, 11088687, 11522933, 9352379, 10433729, 13030581, 9835745, 9753617, 9352307, 11064741, 10565111, 9827789, 12547557, 10016009, 11670789, 11605359, 12383931, 10540715, 11237001, 10540769, 10532591, 11605725, 11343573, 10770143, 10532405, 9541133, 11597397, 11335599, 13604805, 11212701, 10418135, 12326877, 12326673, 12326781, 10508129, 9828173, 9836411, 11212953, 10541309, 10557473, 12228671, 10532903, 10532873, 12302769, 11344269, 9755099, 10902015, 10484051, 9836927, 9779885, 10017323, 10066511, 9837461, 12450807, 12450753, 9682157, 10435673, 9838031, 12393771, 10034465, 10616165, 10059107, 9821879, 9961127, 10444499, 10542791, 9830117, 12385875, 13041603, 12386229, 10264499, 10534661, 12427025, 9674579, 11485053, 11435867, 11280543, 10510577, 11174097, 11558961, 11542635, 9716099, 9732401, 12353889, 10044041, 10920689, 9634331, 9749027, 9749033, 12354171, 9765485, 9912941, 11559867, 11322291, 9388973, 9364463, 10036193, 12362529, 9773873, 10716021, 9773897, 10863441, 9774263, 9438401, 11306181, 9782501, 9774125, 9782375, 9348509, 11265501, 11544009, 10503647, 10036511, 9782537, 12354921, 10503497, 10987179, 11314937, 12265197, 10987215, 12240399, 12543603, 12240501, 12265071, 12355155, 9783065, 10987317, 10987287, 10512149, 12257123, 11282265, 9758867, 9750737, 9783545, 13543905, 10029365, 11553531, 11553483, 10439195, 10824239, 11553309, 9767465, 9734723, 9742961, 9783935, 9358223, 10496927, 13552515, 10628081, 11561829, 9423701, 9759587, 9759593, 13348041, 9997451, 10939527, 10448057, 9997475, 10939449, 9784733, 10038689, 12340689, 9743633, 10513769, 11308353, 10497365, 11283795, 11112081, 12234299, 9776657, 11267637, 9440783, 9694763, 10776489, 10776561, 9719807, 13520733, 11235171, 11088051, 9654437, 10801371, 9719819, 10514435, 9703505, 10571849, 11235411, 12366213, 11088369, 11088327, 11088345, 9753071, 9744665, 12546737, 10777275, 13341411, 9368303, 9769541, 11563593, 9769919, 11555727, 11236323, 11580387, 10777545, 11260881, 9769781, 11555613, 9688193, 11424993, 11064513, 11424981, 9802805, 11400627, 11064717, 11064579, 11662719, 13031103, 9778721, 10032713, 10761851, 10925991, 9713573, 12326799, 10573811, 12326871, 9623309, 10516241, 11269977, 12302547, 10958901, 9779213, 10917893, 10025009, 10475633, 11557311, 12450303, 12589463, 10394087, 9541907, 11368767, 12302619, 11319633, 11188923, 9542363, 12401187, 11188863, 9747047, 11614791, 12229187, 10533833, 11287491, 9780047, 9682139, 11271363, 11050011, 9780305, 9780341, 9772151, 11050077, 13344213, 9354641, 12574071, 10788167, 10256033, 10034891, 11484873, 11271693, 10960479, 10264517, 9789413, 9773027, 11026239, 13033257, 12345507, 9691199, 10862667, 10838403, 10953117, 10838499, 9773537, 10838319, 9363815, 9347717, 9757427, 9347693, 10773429, 10773453, 11084571, 9347897, 9347915, 10773315, 10036439, 9856217, 12264651, 12264477, 11134071, 10503233, 9635261, 11142627, 10249553, 9856325, 9856355, 10487429, 11396637, 10774047, 10774485, 9619229, 10774329, 11093871, 10954611, 11094195, 9357515, 11110647, 11282649, 11184201, 9848933, 9636347, 10553669, 10766657, 11496111, 11348685, 10406627, 9644657, 13585287, 9645023, 11397915, 11094807, 10800267, 10243295, 10579181, 10800339, 10800141, 10251677, 13553099, 9440711, 10407185, 10579277, 11112123, 9981677, 9605081, 12316497, 11145345, 9646271, 11096145, 11104767, 9621809, 9638177, 9982253, 9613931, 9647093, 9638729, 11121489, 11105415, 10925205, 9639125, 10900527, 9622529, 12424293, 11195817, 9631055, 9663857, 11105925, 11376219, 10753869, 9984155, 9812219, 9345449, 9361829, 9345527, 9345287, 9353849, 10877529, 9984965, 9976601, 9771785, 9640781, 11098971, 9632939, 10370069, 9698405, 10698219, 9747737, 12238521, 11001507, 11280105, 11181771, 11124261, 12238365, 9698933, 11124315, 12238413, 12238761, 12238845, 12238815, 9625451, 11247741, 10035323, 9773177, 11370933, 10723713, 10035473, 11280693, 11288907, 9781991, 10863195, 9896891, 9364289, 10830719, 9356117, 9831647, 9372881, 10429691, 13329597, 10036295, 9348497, 9348551, 12240369, 12240357, 12240321, 11552049, 10601795, 12363483, 12363387, 12265053, 12265035, 10987101, 10438241, 12273561, 10020773, 9856961, 10250177, 9857021, 10479791, 9644237, 10438679, 10029065, 11323455, 11429903, 9767003, 10479695, 9849137, 9857345, 9628019, 12339879, 13658751, 10521119, 9726551, 12217235, 9759605, 10489001, 10693763, 12348663, 9759797, 11234403, 12348903, 12553521, 11267391, 9719093, 12348777, 10038641, 11259219, 12340899, 13340397, 9703073, 10776309, 10243781, 10497575, 10252181, 9539459, 9752567, 9727751, 10776333, 10252115, 10243961, 10580111, 11022579, 11235573, 10801257, 11235399, 10072175, 11088267, 9777629, 11547135, 9859535, 10023401, 10768703, 11391281, 11284737, 11326083, 10474157, 11211459, 12554967, 9351923, 11563569, 9982493, 10023839, 13521675, 9360515, 10958061, 12367077, 11400435, 11277327, 9360419, 12350481, 13136937, 10499495, 10016171, 9811403, 11400483, 12350721, 9360689, 11425041, 12375387, 12326619, 12359373, 10508177, 10573727, 10491695, 12343085, 11269911, 10925925, 10925907, 11245737, 13514949, 10049675, 12449961, 12450033, 10901757, 11270181, 11540501, 9607247, 10017167, 12229007, 9992615, 10582475, 9763307, 9771287, 9722117, 10770749, 12302631, 10959123, 10582349, 12368211, 10517219, 9362123, 11147973, 12368397, 10902045, 9763439, 12335687, 12360639, 12385155, 11049837, 9780095, 11050173, 10042499, 11255025, 11271369, 12352569, 11254833, 11050035, 12426315, 11025837, 13024713, 9928103, 10083803, 10501613, 10960149, 12533085, 9772391, 9707153, 9723521, 12754667, 9707207, 10903241, 11279907, 11025975, 10034777, 11026311, 10034999, 9723707, 10535147, 10961139, 9814265, 11173965, 11173959, 11313597, 11002293, 9814403, 11149749, 11460999, 11510165, 12402969, 11313435, 11460987, 11460957, 11149959, 10044119, 9740999, 10044155, 9519869, 9757421, 9782159, 10437599, 9675569, 12534555, 10863369, 10527509, 10519739, 9823421, 10511597, 10028267, 10437725, 9823313, 10454105, 10511471, 10519631, 10839435, 11322875, 11330835, 9831767, 11576655, 12265143, 11126439, 11650803, 9750239, 13026981, 12379857, 10716795, 9750095, 10520159, 12240795, 11347857, 13035399, 10078013, 12240741, 10528577, 10716999, 10053695, 10504199, 13109721, 11315609, 13027827, 9644303, 9865871, 9734825, 10439189, 12233231, 12462993, 9800669, 12397533, 10038101, 10480463, 10046675, 9833903, 10513679, 10546853, 13373057, 9629651, 9867227, 11112441, 10522583, 10432481, 10522673, 11112477, 12227051, 11587893, 13341051, 10490135, 10801503, 9769625, 9769607, 11326197, 11088585, 11088579, 10056197, 11383325, 9778169, 9753569, 10474469, 11088753, 9786215, 9843557, 13350111, 9352391, 10040519, 9778205, 13522041, 13325343, 9794873, 11654403, 9794903, 10507943, 10557101, 10516121, 10049243, 10049231, 9451025, 10262033, 13506165, 9803333, 11236935, 10507853, 9820055, 9860999, 9697241, 9820157, 10057709, 12326703, 13342557, 9828167, 11327349, 10573991, 11327655, 12228863, 12302537, 9713717, 11589663, 9820571, 10435001, 12220925, 12450267, 10058225, 13146557, 9836825, 9812279, 10516745, 10525013, 10517051, 12450783, 12450597, 10025771, 9813197, 10009841, 12450861, 10517567, 9821279, 10878027, 9543101, 9698771, 9543029, 9526631, 10501811, 9830051, 9805331, 11591283, 10518131, 11591277, 10624601, 11321265, 9838511, 10084343, 10084133, 9707351, 11149461, 9986093, 12370023, 10863015, 10011035, 9667055, 12239159, 10862907, 10862943, 11281059, 9683585, 10076843, 11322009, 10461857, 9871961, 12272229, 10961529, 10420847, 10412951, 12239793, 10838937, 11437035, 11437005, 11437023, 11510655, 9995117, 9667727, 12330213, 10986747, 12338403, 11510991, 10986693, 10462259, 12239877, 12272763, 9348173, 12264891, 13125063, 10372517, 12535263, 12240189, 10986771, 10986861, 9856751, 10430357, 9660341, 10987491, 9701321, 10987305, 9684749, 9856835, 11200347, 10241891, 10954887, 9644201, 9676997, 9849059, 9660455, 9849113, 10439003, 10004819, 10955427, 10775073, 10431071, 9357899, 11512389, 12815301, 12217265, 10775445, 10939203, 10775745, 10775571, 10775577, 11529315, 10415231, 10415207, 10243565, 9997595, 10693931, 10464581, 9998003, 12217901, 9662033, 11185971, 9670463, 9719999, 13553889, 9859265, 10408133, 13103169, 9662489, 11194383, 10416197, 11530533, 11186487, 9875777, 11514537, 9351815, 9351827, 11145933, 9351911, 13693467, 12448329, 9352103, 11178909, 9360323, 11318057, 11219817, 11400363, 10417205, 11424867, 10900875, 11064711, 12523005, 10925553, 10442075, 10245851, 12302061, 12302043, 12326451, 9672245, 9934451, 9934463, 10819163, 12425169, 9779171, 9656135, 12621591, 11663199, 11147397, 12425343, 9656399, 11196897, 12532167, 11180709, 11213547, 10500659, 10009103, 11189247, 10877769, 12450957, 10411211, 12328167, 9354275, 10411133, 11025477, 12328443, 11181507, 12787119, 11197917, 10927361, 11025993, 9600893, 11002095, 11002101, 10723551, 11460699, 9749123, 9364175, 9364181, 13927023, 9364361, 13517787, 9364271, 11535183, 11519163, 11232507, 11224305, 11535597, 11519199, 9348347, 11437101, 10839051, 10839063, 9741785, 11232741, 11126067, 9348419, 9348449, 11519691, 10438583, 9775013, 9857015, 11315063, 9791333, 11233479, 11233323, 9857105, 11241585, 11397191, 9767381, 11233737, 10439153, 11536677, 9767237, 13732587, 9349871, 13855341, 11561487, 9776075, 9718559, 11545389, 9358097, 10759343, 11226267, 12553527, 9358595, 10243751, 10776219, 11546163, 11226627, 11112363, 10710921, 11259783, 11333625, 9785339, 11226939, 10252073, 9539399, 10023167, 12530093, 9982457, 10055963, 10957089, 10711407, 12349773, 10949295, 10957521, 10465841, 9351971, 11277477, 12334245, 12326031, 9352205, 12235799, 12325989, 12366921, 12326319, 11539941, 10925703, 11228925, 11187831, 11261511, 13342683, 9721733, 10958721, 10573709, 10901397, 10573781, 10925829, 10246013, 10573649, 10245989, 12302589, 13236375, 10958883, 10016807, 12302451, 10901625, 12359763, 11253855, 12335595, 12351957, 10574135, 10803485, 10959213, 12221111, 9362039, 9362249, 12450675, 11172723, 11377487, 9567383, 10575035, 9354413, 9379001, 12336267, 11246607, 9706541, 10009667, 11541891, 9346307, 11541825, 11558403, 12361227, 11025939, 11026017, 10444367, 11386799, 10723215, 9748409, 11296643, 11460393, 9715577, 12386553, 10502375, 10502381, 10502189, 10502195, 11296773, 11067417, 11149341, 11485203, 12370041, 11583597, 10502237, 9609629, 11174325, 11149707, 10510733, 11149725, 9798059, 11313465, 11305275, 11149581, 10502417, 10436903, 10510619, 11149641, 11305311, 10961235, 9781907, 10502831, 10502909, 9798347, 10502759, 10043975, 9781865, 9749393, 9782147, 9806777, 10503113, 9765869, 9519875, 10511219, 10503341, 12362985, 12526647, 9749561, 10503185, 9798695, 10503269, 12379245, 10028147, 10503587, 10511783, 10503653, 11126247, 10511819, 10503437, 12363123, 10503491, 10503863, 10512107, 9799373, 10503893, 10429979, 11126373, 13026867, 10815429, 10528709, 9750527, 9832427, 11331375, 10503983, 9807671, 10053437, 12240753, 10791167, 11299029, 10717221, 10512389, 9857129, 10037633, 10758557, 10504607, 10504673, 9783767, 10045919, 10037735, 10512863, 9783605, 10037567, 9849173, 9775451, 10037579, 12552555, 13125909, 10054295, 12266159, 9784031, 9374429, 10046201, 10471985, 12372483, 10029647, 11520627, 9783923, 10513319, 9784241, 11307933, 10513301, 9792431, 10046375, 10505195, 9382877, 9997283, 13536099, 10513169, 10513217, 10480481, 9367007, 12225809, 13151589, 10063169, 12381825, 10514159, 9440795, 12373545, 10047035, 12373527, 9801281, 9809525, 10514309, 11112423, 11112435, 10039271, 9785201, 9711473, 10039451, 9703589, 9785513, 9785561, 11112663, 11112495, 10514477, 10481711, 9785453, 11301285, 10506647, 11571591, 9744833, 12743061, 10506905, 10040021, 10539761, 11088591, 12374565, 9769487, 10506767, 9753215, 10572367, 10507175, 9679775, 10507181, 10507193, 10777485, 9794513, 9819101, 10048463, 9794537, 10007303, 9794357, 10441523, 10007333, 10031999, 10507103, 13128869, 10507271, 10777617, 9778223, 10507367, 9671777, 9541061, 12326379, 10040771, 10507733, 10261991, 10507553, 9540947, 11064669, 11400891, 12326607, 10507883, 11212713, 10926009, 9787163, 12326661, 9787235, 12531525, 10041503, 10574009, 11139227, 11311251, 10475729, 11581665, 11311299, 10516577, 12302781, 9673157, 12302805, 9836861, 11303235, 10500779, 9763487, 10500857, 10508999, 9796115, 12450351, 12343883, 10042301, 10501103, 10509311, 10509263, 11574039, 10025777, 9984863, 10460009, 11574087, 11050155, 12450975, 10894371, 13532247, 10509329, 9354647, 13909491, 10501595, 12295475, 10509623, 10501385, 9354605, 13425981, 11484843, 10493615, 11484879, 9707255, 9854477, 10788455, 13025235, 9641915, 11149287, 11149305, 10510115, 11484987, 11026227, 10526525, 11657399, 10510511, 11665581, 12542169, 10575881, 10805315, 10756511, 10756403, 11379059, 11370825, 13935345, 10478123, 13042197, 10576505, 13746747, 11617185, 11379473, 11617143, 10757345, 13624361, 10765733, 10839477, 11658513, 11380085, 10790573, 12265209, 9348809, 13682363, 12224063, 10815477, 13027251, 10250099, 10717425, 9980099, 12241119, 10815527, 11667519, 10987575, 11315225, 10864739, 10758257, 10783139, 10717629, 9882047, 13068795, 11676135, 11545071, 10783025, 10553675, 13347525, 11365011, 13027983, 10570475, 11315765, 10463747, 9751097, 11545101, 9751157, 10758737, 11365299, 10439645, 10783925, 10939587, 9547193, 9416159, 13339983, 10071299, 10759523, 9784691, 10071401, 10071407, 13340289, 13340307, 9826043, 12529211, 12217889, 10505747, 9367109, 11660901, 10571333, 11374167, 11382695, 11366331, 11661117, 12218543, 9720011, 10752111, 12595223, 12234851, 12226649, 10072565, 12218681, 9859775, 12219029, 11670075, 10556009, 11604573, 12227159, 10785689, 10032119, 12227363, 11088765, 9990983, 11375451, 11088723, 10384535, 12227759, 10441895, 12219641, 10433747, 11375661, 10073141, 10564637, 12579939, 10777689, 9844445, 12220151, 9852665, 9360941, 9360953, 9360971, 11236947, 12326835, 12326829, 12326865, 10245971, 11212935, 13342863, 11655399, 11212839, 13023357, 11671941, 10778909, 9853229, 10557809, 10778969, 10779197, 10017371, 12532341, 11402117, 13515771, 10025891, 12344195, 9747455, 10550051, 9763613, 9763625, 9542495, 10894169, 11656377, 12450999, 10468541, 10878099, 10517729, 12533175, 12516777, 13164027, 12402153, 13024701, 12393747, 12549381, 10763837, 9354857, 13098993, 10502135, 10756091, 11026371, 10788809, 11435789, 10567523, 11313785, 9610165, 9806803, 9823219, 9823201, 9741079, 9675535, 10511605, 13345979, 11543753, 10511581, 12526649, 10560565, 9790501, 9806929, 9364555, 9364603, 10085479, 11576753, 10511803, 13526447, 11593181, 10839329, 10839341, 10003723, 12363107, 10561153, 9823951, 10544851, 9348649, 11298305, 9791071, 10430035, 9791089, 9447319, 13527005, 10512313, 10512271, 10987517, 11347919, 10987457, 10528573, 10987343, 11331767, 9857239, 11299031, 9807997, 9840739, 10070119, 9775573, 9103831, 9857341, 10512655, 9546019, 9840937, 10561879, 9775459, 10054273, 9398935, 11365013, 9775831, 10529365, 9350029, 10562551, 9808843, 10628047, 9546751, 9546499, 10480471, 10038115, 10939571, 9825463, 9546949, 9088087, 10546249, 9334171, 10530199, 11578865, 12676505, 9842167, 10743239, 9334249, 11349311, 9547057, 10562821, 10513669, 11595023, 9743695, 11627887, 11497139, 10546831, 10514071, 11595407, 11415277, 11333327, 10055221, 10055245, 9334357, 13626899, 10579855, 10743593, 10071889, 11251559, 10514269, 10252447, 9105661, 10580017, 10252405, 10498477, 13513193, 10776971, 10776977, 9105907, 10776893, 10531081, 9842983, 10055983, 10498429, 10400125, 11088545, 9859783, 9744919, 10760755, 9826873, 9794095, 10777115, 10777193, 9744985, 9663085, 9810841, 10777487, 9810925, 10777439, 10630333, 10630291, 9352381, 9352369, 9843925, 9827539, 10630339, 9827575, 10056943, 9352285, 9811063, 9827731, 10630531, 9811387, 11662721, 10548625, 10630555, 9844207, 9073963, 9336457, 9827995, 10516099, 10057435, 12727955, 11400947, 9811711, 9451033, 10532425, 10925999, 10549183, 10057633, 9828301, 10926029, 9730021, 11400977, 9336667, 9811819, 10434703, 10057861, 9713803, 10041505, 10533103, 13531289, 11303027, 9828787, 9124261, 10041823, 10041811, 10533361, 12302795, 9828613, 9337123, 11188907, 11188991, 10042105, 9763561, 9828889, 12548657, 10582585, 11188787, 9796147, 12450317, 9337411, 10631797, 10549885, 12450689, 9665455, 12450767, 12450611, 10025791, 11320091, 12204911, 10058623, 10960037, 11304107, 10960043, 11598983, 9682141, 9682159, 10878005, 10583095, 12450833, 9370687, 9370675, 10468447, 12450923, 10517569, 9846163, 10960313, 10960265, 9354697, 9944563, 9797119, 9338341, 9846067, 10960547, 11484857, 10256005, 10632895, 10960577, 9354787, 9338425, 9338443, 10501747, 10255999, 11026349, 11173817, 9076627, 11173769, 11173781, 11173871, 11173877, 10534849, 11484965, 9109279, 10960643, 10059613, 11026265, 9814267, 10830037, 11173889, 9814141, 9470053, 9470059, 11173973, 9814405, 12157351, 10568065, 9650623, 9716161, 10437103, 9732415, 9732421, 9732463, 10961543, 10486429, 10437337, 10519087, 10437121, 11338355, 9847393, 10437223, 9814939, 9356161, 10044295, 11355017, 9339835, 9815011, 10060597, 10863371, 10863389, 10961693, 10765081, 9815191, 10437787, 11633851, 10028281, 9765925, 9094207, 11584631, 10454131, 9831547, 9373093, 10519963, 9422257, 10568965, 9815389, 9749833, 10962569, 9815719, 10618591, 9569797, 10520161, 10716797, 10552915, 9750121, 11601821, 9340849, 10586071, 9078613, 10717001, 10504351, 9111787, 9078793, 10504201, 9127969, 10062313, 9111841, 10766689, 9767257, 9849199, 11520701, 11520695, 11651759, 9734845, 9734827, 9833167, 10521133, 9816583, 9817009, 10439443, 10439533, 10062703, 9358495, 9800911, 9784573, 10554403, 10538401, 10505611, 11587055, 9784591, 9801025, 13339925, 11619673, 9817441, 12160321, 10276543, 12390029, 12537473, 10522165, 9817675, 9817723, 9850771, 11112443, 9064405, 10243951, 9064309, 10391743, 11112689, 9638113, 10244113, 11112509, 12390527, 11588021, 10801541, 10801559, 10801643, 11325947, 10047943, 10555849, 10801619, 9834835, 10801529, 9818767, 9097921, 10064617, 10523575, 9819103, 10474471, 9753577, 9786223, 9426103, 10065091, 9524251, 9819151, 10507651, 10507765, 9360859, 10556713, 10294549, 9688327, 11064695, 9819505, 9360739, 9803131, 9835873, 10507939, 9819901, 9328357, 9082381, 10524199, 9360901, 9541123, 9803275, 10262053, 9131617, 11212715, 10049461, 9328399, 11212589, 13342559, 12326699, 9115435, 9836413, 11212637, 11327657, 10524889, 11589665, 9820249, 9804199, 10869217, 10901987, 9853231, 10049899, 10525429, 10525381, 10017313, 10541677, 12344215, 12344203, 9771973, 9100273, 12540725, 9280321, 9362257, 10525519, 9346213, 10280149, 10280137, 9346261, 11050199, 10558501, 9804805, 10738739, 9837667, 11312519, 9805249, 10525957, 11050265, 10575181, 10050925, 10346125, 12426887, 9838291, 9821893, 11591285, 11591279, 10510243, 11345831, 10592179, 10264543, 9805789, 9805771, 9838537, 10084345, 10526659, 10510279, 10788811, 13524857, 9707311, 11608253, 9806035, 9052411, 11329577, 10084369, 10051603, 10526779, 10887191, 9969703, 10576303, 9118099, 11149751, 11149703, 11149727, 10527127, 10477987, 10478029, 9806311, 11379007, 11313437, 11149667, 11460989, 11460977, 9380539, 9741025, 10084951, 12411481, 9544669, 11625415, 9364255, 9757441, 10625803, 10068775, 9807001, 10511551, 10511503, 9364687, 9823477, 10511563, 10855441, 12166561, 10839425, 10528243, 10839305, 11330837, 10462531, 9348745, 10282525, 9348625, 10577515, 10577521, 9119317, 9447307, 10987451, 11347859, 10528741, 9857161, 9857185, 9857197, 13510829, 9644281, 9742567, 10987559, 10987553, 10397749, 9545845, 9546205, 10054135, 9644305, 9644311, 9742609, 9808213, 9857371, 10053961, 9775777, 11365073, 10005019, 9546271, 10971655, 9546277, 10889747, 9120379, 10038151, 12364781, 10628095, 9808669, 10054453, 12462857, 12462851, 9300823, 9677971, 9841801, 9563347, 11332859, 10611967, 10513855, 9334177, 9334201, 9334195, 10513903, 10530289, 10513705, 9809161, 10530079, 9809221, 11578733, 12545735, 10513975, 10366549, 9809485, 10334143, 10334137, 9105403, 12562303, 10612585, 10252435, 9072805, 9810163, 10432537, 10530823, 8974411, 9728413, 9843097, 9122233, 10531309, 10777055, 10547485, 11088575, 10777319, 12219133, 9368287, 11088635, 10777199, 9859687, 9745003, 13546463, 11088653, 11088665, 11088659, 10466125, 9810805, 10564435, 10040461, 9352249, 9827371, 9843811, 10548649, 10057099, 10532281, 10630537, 10696093, 9794833, 13530371, 9352561, 13514435, 10516111, 9336499, 10516201, 10516207, 10532593, 10515979, 10057261, 10499701, 9827953, 9058267, 9107431, 10926047, 9828121, 10549021, 10516345, 10434769, 12302539, 9713899, 10057741, 9058321, 13040069, 12302723, 12302801, 10058215, 10516795, 9812281, 10516759, 12302717, 9615733, 12663101, 12450485, 11188895, 9337567, 12450527, 9107983, 9124357, 9484831, 10041913, 9845335, 10058323, 10631803, 12204635, 10041979, 10549831, 10025881, 9747367, 9812911, 12450755, 12811469, 9829549, 9682129, 9682123, 9813247, 9682147, 10058989, 10877987, 10763323, 10435621, 12450941, 12450935, 9797053, 10616215, 9829885, 10616167, 9797281, 9076423, 9109243, 9797185, 9797197, 9076333, 10632781, 11485079, 11173865, 11173841, 11173847, 10551061, 10501999, 10059643, 9044101, 11157641, 9633973, 9027751, 11174141, 10862843, 9027829, 10960901, 10600453, 10076209, 9650239, 9338971, 11157581, 10567753, 9044083, 9027985, 10633663, 9535933, 9535909, 10076425, 9011473, 9732367, 12189971, 9535807, 9978145, 9027919, 10862957, 9027907, 10076503, 12239207, 9011581, 9781615, 10076827, 12239489, 9355957, 9044719, 9044485, 12239393, 12239465, 9093721, 9650767, 9306733, 12239447, 10420849, 9651127, 11436959, 12239747, 9749473, 9503491, 9372433, 9372463, 12239639, 9044809, 12239735, 12239723, 9388891, 12239693, 9388915, 9045139, 9372865, 9651403, 13026461, 9684217, 9012451, 11207891, 9094147, 12239921, 10355731, 9585679, 8995897, 9061435, 10077217, 10454101, 10503283, 9585739, 9028735, 13125065, 9569665, 9553291, 9454987, 12240287, 11175323, 9553321, 9569707, 10405129, 9012559, 11404669, 9045673, 10405597, 9651931, 10487533, 9635521, 9635533, 10405627, 10405399, 11175485, 10405435, 11175449, 9651751, 10258009, 10405465, 10585723, 9750133, 9651829, 9045625, 9045925, 10258405, 9324529, 9651991, 10340113, 10405711, 10471243, 11208527, 9308005, 9619303, 10422121, 9848989, 9652357, 9603211, 9095341, 11192465, 9652417, 9717985, 9619507, 9652279, 9095227, 9701467, 9800095, 10439059, 9013651, 9537979, 9357733, 9013705, 9374167, 8997331, 9325039, 9013537, 10422577, 11176295, 9865561, 11569499, 10471777, 11504273, 12339929, 9374461, 9669145, 9292321, 11504237, 10472053, 9636451, 10259383, 9030583, 10505155, 9358315, 10259443, 11176745, 9014017, 9374467, 9030427, 10423045, 9046807, 12340085, 12274535, 9653107, 12536969, 10259479, 11176997, 9047077, 10259497, 9653335, 9407587, 9407605, 9686419, 9588103, 10407301, 9047467, 10407355, 9113017, 11160983, 9440725, 10243537, 8998399, 9768199, 9047347, 9538885, 8998255, 10800467, 9653611, 9539245, 11226851, 9047749, 9457381, 9948763, 10800713, 12406351, 9031555, 8998825, 10801043, 10538905, 12161023, 11161595, 10571767, 10571563, 9637657, 10506037, 10817287, 9031459, 9539389, 11177753, 11177795, 11145029, 10407793, 11161433, 9998179, 10588303, 9769147, 9965743, 11505869, 12341441, 10571827, 9015403, 9081235, 11162015, 9015781, 9687523, 10408279, 11620705, 10851001, 9376429, 10064575, 9360055, 9016009, 9016015, 9360073, 9769717, 11194979, 11424701, 10376077, 9687949, 11424653, 10900361, 10376107, 10900457, 10621939, 10621891, 9376555, 9655135, 10425157, 9753457, 10900301, 10900313, 9360517, 10261645, 11162813, 12424337, 9098443, 10900715, 10294525, 12424415, 10621987, 9753619, 11162681, 11146301, 9032725, 9557053, 11424791, 9049195, 11507117, 10589623, 10261891, 10409383, 9704875, 10245631, 9983485, 9033199, 12424655, 12424487, 12424457, 10261855, 9049429, 10409341, 9049459, 9033079, 12179129, 12179117, 9623173, 10425985, 9082537, 11294339, 13342463, 10000039, 10491619, 10770145, 10507969, 11196107, 11540177, 10426099, 11572937, 9623095, 9655861, 10622479, 10245721, 9590365, 11196005, 10573387, 10704467, 13702697, 12424769, 9541507, 12425129, 10442635, 11507639, 9607111, 10442695, 12179417, 12425183, 11212763, 9983983, 10409959, 10426123, 9033511, 12425087, 9606997, 10753901, 9606985, 10065775, 9033949, 12589217, 9738493, 10705109, 10410001, 11196479, 10409995, 9115705, 12179903, 9279877, 10541491, 12425639, 9116053, 11049443, 10557937, 11180537, 9017815, 10393909, 9050401, 9001255, 10393951, 12179825, 9279871, 10623655, 11180711, 9984643, 9018049, 9542365, 9018085, 13687373, 9984595, 11164241, 9018313, 10705907, 9346033, 11197229, 9034555, 9280309, 10509181, 10410877, 10525513, 10754893, 10623823, 10443913, 11541677, 10411213, 10427449, 10411057, 12426245, 9034843, 11459651, 11197523, 9379225, 10427827, 9559513, 9035203, 10526197, 9559543, 9117169, 10378501, 9526609, 9035089, 11673257, 9002683, 10034863, 9461251, 11509259, 10411573, 11197979, 10427977, 10427971, 9739849, 9035671, 9625525, 11165591, 11509703, 9641797, 11460443, 10477723, 10461385, 9674995, 9036025, 9986059, 9625651, 10952813, 13590545, 9019795, 11166083, 10789261, 9675175, 11149715, 9298399, 9363931, 10953173, 10428691, 9904423, 9642277, 11166059, 9494893, 9986737, 13148837, 9560803, 9036541, 10576417, 9363973, 10953269, 11166239, 9036367, 9003613, 10953329, 9036373, 9364069, 9986665, 9003985, 9003991, 9348085, 12231455, 9675553, 10298149, 10838861, 9986923, 9626779, 10249357, 10953917, 13526227, 12330131, 10413229, 12330119, 10953953, 9331945, 9348103, 10265623, 9839617, 9004069, 10953803, 9102457, 10954151, 12264845, 9987547, 12264947, 11396605, 10954181, 9102841, 12264911, 10954193, 12264761, 12264707, 9659695, 10954109, 10954055, 11543897, 12264791, 9659905, 10954265, 9332293, 11511419, 11183735, 10462837, 9627241, 9463687, 9725887, 9316285, 10954739, 9021397, 11184077, 10987475, 9988069, 9627415, 9332491, 9987859, 11511587, 9316117, 9037603, 10708763, 10954601, 10807159, 10987391, 11200349, 10430617, 11544731, 11315359, 9021631, 9857233, 9627865, 10037461, 9627847, 10594513, 10774745, 9644035, 11200523, 9365551, 9660451, 9021493, 9021517, 9709687, 8988781, 11561393, 9038209, 9644419, 9021937, 10316041, 9972013, 10414375, 10955033, 9644695, 10775201, 10775213, 9104005, 9349801, 9628345, 10775279, 9022171, 10775243, 10775249, 10955483, 9775645, 9349651, 10775051, 10775141, 9005635, 10775105, 9022345, 9989035, 9743275, 9038797, 9530305, 11086793, 9432043, 10529587, 9038623, 10775357, 9677581, 10939229, 9677677, 9563299, 9366727, 9039043, 11152637, 10530043, 9104623, 9628921, 9645289, 9710827, 11627581, 9661441, 9382939, 9366601, 10579363, 13348307, 9006511, 10251721, 10579393, 9547261, 10694107, 10071343, 9006409, 9366877, 9825601, 10710341, 9006457, 9629317, 9334441, 9973423, 10251997, 9023185, 9023191, 9039589, 10252009, 9629413, 10251793, 9989635, 11267639, 9023101, 9006709, 11169707, 9023371, 11169671, 9039799, 12447695, 10956767, 11185955, 9629467, 12332849, 10956557, 9613141, 9678697, 9498781, 9482377, 11399345, 11399321, 11399423, 9318415, 9629713, 8974351, 10399807, 9072703, 9859117, 10399837, 12333179, 9859183, 11399567, 11399663, 9351637, 10793467, 9351679, 9351667, 12349889, 11399471, 11399465, 9531673, 12448037, 11399477, 9318673, 9531697, 9040165, 11153695, 9023797, 10629499, 12267877, 9073003, 11399495, 9351523, 10318465, 12645097, 10777331, 9024235, 11399873, 11399717, 9318943, 9990697, 11399711, 9040453, 9532009, 9122701, 11400125, 10613731, 10925051, 9024493, 9630709, 9712477, 9548611, 12448607, 9040741, 9319267, 12301481, 10417339, 10925291, 9041113, 9385201, 12448829, 11187233, 11187239, 9729037, 10073137, 9024565, 9942139, 9041017, 9434503, 9581953, 9631159, 8992177, 9450961, 10925555, 10565113, 9008611, 9647593, 9712903, 10925375, 8992057, 9041215, 9024847, 9319783, 9024889, 11400533, 9729385, 9811603, 12301997, 9664189, 9860803, 10270441, 9729763, 9451027, 11171375, 9991699, 9991741, 10843747, 10516081, 9320035, 11319203, 10450819, 9631669, 9648085, 10418125, 9615307, 9975793, 9025507, 13055927, 10581811, 9041695, 9041701, 9041713, 9860977, 9041767, 10581841, 9680743, 9631903, 9681031, 10025101, 9631885, 9697447, 12302465, 10402015, 11516159, 9615553, 9992443, 9615385, 9975811, 9631801, 9631789, 9631825, 9631831, 10631269, 9058387, 10532989, 9697393, 11319383, 9501109, 9304333, 9304345, 9992461, 10385707, 11532563, 10959215, 10402129, 9320797, 12302693, 12351839, 9681259, 10631821, 10877687, 9534157, 9370351, 9009919, 9370357, 10041883, 9533971, 10402327, 9534007, 9042517, 9534031, 9649087, 9370531, 9010099, 9010117, 9649141, 11500505, 9010165, 9370381, 10877741, 9009949, 9009937, 9009979, 10877723, 9009997, 9534295, 11221829, 12385103, 12548939, 10877777, 10255549, 10255567, 9010405, 10255603, 10075369, 9714745, 9567325, 9550951, 10583461, 9026989, 9403693, 9993505, 13024637, 9026869, 9813325, 11025779, 9027247, 9715387, 9043675, 9649861, 9600757, 10075891, 9092833, 10403569, 13631069, 8977987, 9043549, 9666457, 9650059, 9633757, 9650125, 9650149, 10076131, 10075963, 8994649, 9687199, 9318553, 11149445, 9785551, 12423377, 9302023, 10629127, 9351295, 9031795, 10863035, 10006981, 9859357, 9355597, 10838723, 9388777, 9323023, 9753163, 10376065, 9614269, 10056667, 9008077, 10433485, 9384913, 9647095, 9003787, 9405187, 9016081, 9503575, 9372529, 10618027, 9573535, 12178565, 9610435, 12178667, 11494607, 9012475, 12178637, 9856225, 9004039, 9573439, 9614407, 12264545, 12264551, 9413713, 10569121, 10622395, 9614803, 9598429, 11281865, 9696757, 10622431, 12264743, 9569575, 9975079, 10773863, 10499431, 9090391, 9553273, 9037159, 8971945, 10581655, 10774163, 9615067, 10774217, 10008085, 10282501, 9610765, 9594403, 9614893, 10425949, 9954907, 9934405, 9619009, 9983611, 9856615, 9778795, 13387727, 10393477, 10393597, 11626447, 10409779, 13125503, 10606363, 11319137, 9963337, 11110259, 9296011, 10594483, 12187823, 10774679, 10336471, 9775321, 11086067, 9988291, 9038059, 9636079, 13764617, 11110475, 9484693, 9517471, 9046435, 9345463, 9484765, 9767179, 9959719, 9349447, 9345373, 9025891, 9370249, 9767455, 10070533, 10381879, 11143685, 12315137, 9628237, 9317257, 12327857, 9358225, 10800107, 10075081, 11353073, 11377439, 9018163, 9423667, 10877819, 11139923, 8998057, 9620641, 11398373, 9354481, 10800137, 11050013, 10800155, 9526363, 11164739, 10615885, 9985135, 9641371, 9612703, 10403323, 11124191, 11250947, 10800413, 10411357, 9002317, 9575749, 9027229, 9612979, 9072361, 11132621, 12418765, 10084069, 9715255, 9629269, 9031261, 9637477, 10428193, 9744241, 10559491, 13110767, 9341353, 10630543, 9114043, 12537323, 9835891, 13630169, 9097903, 12451555, 12181199, 13517399, 9054763, 9107005, 9127507, 12462995, 12502823, 11353907, 9120589, 11088737, 10050373, 10567495, 11174063, 11460749, 13476067, 12714131, 10436863, 11149517, 11460803, 11149523, 11345975, 12361733, 10068007, 11173955, 12369989, 9773161, 10510735, 9781669, 10527229, 11305277, 11321663, 10510645, 10731791, 9863503, 10051909, 10084735, 10436977, 11370845, 9781603, 10035889, 10961557, 10863263, 10863359, 10887883, 12362441, 9773599, 11305475, 11461121, 12362243, 9740887, 10035793, 9912955, 12370505, 9773971, 12542867, 11150213, 10027999, 9749449, 9774073, 9544687, 9773875, 9560923, 11543423, 11338577, 11543711, 10839197, 9774301, 9766087, 10839245, 9774085, 9774169, 13624363, 10036333, 10028131, 10036615, 9815485, 11126237, 11289917, 11273477, 11085161, 9749827, 11126129, 10036549, 11126111, 10806965, 9791119, 9701047, 10045099, 12363509, 9766597, 9766603, 9545443, 9701095, 10618585, 9078331, 9750061, 9070189, 10962515, 11298731, 10815401, 9783175, 9807745, 9447301, 9103249, 9783223, 10504069, 10258351, 10569697, 10258381, 12240875, 10348543, 9963517, 10962911, 10037221, 10987301, 9701149, 12240683, 10077967, 10250035, 10733333, 9775261, 9799819, 9742525, 9783487, 9783547, 10717223, 9103375, 10504255, 9799735, 9783361, 10963067, 9799795, 10496071, 9111655, 9546199, 9800143, 9079267, 9538027, 9783991, 9374377, 10037977, 13658753, 9783847, 9767509, 9776053, 9022369, 9767845, 9759661, 10505197, 9776113, 11324375, 9800455, 11586341, 9759499, 10054807, 9776305, 10521733, 9817279, 10530019, 10546429, 11570399, 10038505, 10448107, 10513627, 9759745, 9079825, 9088021, 9776185, 9759781, 9333835, 10038391, 9800803, 9366943, 9366937, 10079623, 11603393, 11365673, 9768223, 12160267, 9096535, 9776785, 10833571, 9776827, 11112083, 9768619, 10505887, 10039039, 12168907, 9768673, 10038793, 10055227, 10513939, 10579879, 10497931, 11341727, 11112437, 9064201, 9334531, 9334561, 10579735, 9572167, 11652971, 9809767, 9785185, 9105277, 9334915, 10776755, 9089173, 10776707, 9638083, 9719863, 9801775, 10252375, 11112551, 9744499, 11112539, 10629205, 9785449, 9122203, 9335191, 9744817, 9335209, 10801553, 9335233, 12341737, 9818575, 11088371, 9335071, 10047757, 9777469, 9744697, 10039627, 12341575, 9793897, 10973827, 9073345, 10040041, 9753313, 11235959, 11563595, 9540487, 11563907, 10031899, 9769747, 10441555, 10507123, 9990979, 11449159, 9360571, 11064575, 12367079, 9794761, 10015987, 9524245, 11662433, 9778579, 9778591, 11212175, 12326369, 9090547, 10515751, 9360667, 9778495, 11212061, 11064599, 9778519, 9336139, 9778501, 9844039, 10507915, 9819859, 9787111, 11556407, 11400743, 10032649, 9770497, 10262017, 9565747, 12326417, 11400707, 9778723, 10630753, 11400827, 10630723, 9803365, 11400791, 9779095, 10925987, 10516405, 9090973, 11401115, 9074659, 9820153, 9861091, 12679013, 9762601, 11302781, 9058135, 9336673, 11286359, 9107611, 10901633, 10508443, 10541269, 10057759, 11360261, 9074737, 10573855, 10573921, 13039631, 10737773, 9066583, 11278451, 9787501, 9779305, 12302771, 9091459, 10901933, 10959275, 9656719, 9779671, 11319803, 9722365, 12302627, 9779491, 10451239, 10631521, 10738025, 9779521, 11565419, 9337195, 10631503, 10901855, 9542293, 10025659, 9542305, 11188883, 9804505, 9280219, 10959413, 11311715, 9542257, 9788029, 11336603, 11303831, 11377663, 10517497, 10058533, 9771865, 12450671, 10959683, 9821029, 10058905, 9346177, 9092281, 9837787, 13507751, 10877975, 9780301, 10959995, 10959959, 11336795, 12426677, 11296163, 10083745, 9772495, 10034665, 9084187, 10960139, 10378543, 9780523, 12803359, 9543031, 9780589, 11173535, 9707203, 11026163, 13041335, 11026139, 10518235, 9076465, 12181043, 10632751, 10960433, 10501693, 9772585, 11312759, 10509949, 11279945, 9117307, 12361601, 8994769, 10510333, 11149271, 10051339, 10731323, 11484941, 11026187, 11026283, 9084739, 9076561, 11370665, 9109729, 10633273, 13336685, 10633315, 10600573, 10551373, 9060739, 11370887, 10568077, 9060775, 11174297, 9847045, 11174201, 11174207, 10420519, 11354489, 11174231, 9634453, 11010793, 13517465, 11616977, 9847705, 9536395, 9356179, 12502015, 9847795, 9847579, 10863479, 10863437, 9356155, 10568893, 9094315, 10781899, 12158005, 9094171, 9094189, 13517921, 9848197, 12535199, 10438111, 9111001, 10896845, 10438117, 12535109, 10962593, 10962623, 10438309, 10766065, 12387899, 9569803, 9684565, 10815473, 11356151, 12388307, 10553131, 10569859, 11618461, 12241031, 9111613, 10963049, 10258543, 9111955, 9112027, 9341437, 10406149, 9750823, 9341287, 10472095, 9341581, 9292423, 9341569, 9112249, 9865903, 9112285, 10963463, 12388961, 10783303, 12503627, 9112177, 11520941, 11520959, 10062781, 9849775, 9341875, 11520971, 10537927, 11520965, 10439485, 12503831, 12225295, 9358489, 9342121, 9538747, 11521157, 9850021, 9079999, 13536395, 10390549, 11521025, 10554385, 10554397, 11521043, 9079903, 12389465, 9112987, 11210173, 9096619, 9096655, 11603249, 9112921, 9948811, 11620015, 10276549, 9850615, 9342715, 9604843, 11619907, 10555297, 9064399, 9867217, 9834463, 9834457, 9834475, 10244065, 11357993, 9113347, 12341117, 10522471, 10555255, 9342835, 11112629, 12390545, 11112701, 11112659, 11391103, 10621003, 12390893, 10801661, 9507307, 8982799, 11112761, 11112707, 12341587, 9851563, 9048781, 9114337, 9851641, 13341647, 10752911, 10032127, 9114613, 9098011, 9114409, 9851737, 12342085, 10441951, 9442513, 9753601, 10032133, 10474549, 9753637, 9114673, 11064737, 9835915, 9082291, 9360877, 9360889, 10442077, 10753783, 10557175, 12277457, 12391997, 11392555, 9852499, 9115207, 10262131, 12326825, 11212721, 11212679, 11212703, 11622283, 12326855, 9852709, 11360027, 11376449, 13342955, 9066703, 10574065, 10574071, 10557655, 11212901, 10328137, 11212925, 9738715, 9738691, 9755125, 12392927, 10574125, 9115981, 9066823, 9853261, 10246525, 9132409, 10246501, 12278507, 13114007, 10902053, 10541611, 9722395, 9116209, 12507725, 9116275, 9132961, 10001353, 10460143, 10050361, 9116467, 11606909, 9542479, 9280369, 11377903, 9116887, 12573743, 9116707, 9100339, 9854029, 9100411, 11050421, 11050373, 11050385, 9346363, 11050313, 11050319, 10034545, 11509085, 10575199, 12181145, 12426983, 9117409, 9854485, 12181055, 10755589, 10559083, 9854557, 12181085, 11165671, 9117667, 12427097, 9330817, 9052399, 13344953, 10575937, 13525049, 9888145, 9118105, 10576279, 10576357, 9052417, 9118045, 10560175, 9118375, 9839305, 9839359, 9118219, 13525595, 11461175, 10560013, 11002391, 13984367, 11150261, 11658137, 9741067, 11150177, 9741127, 11150153, 10069141, 9839749, 9102493, 10577029, 13346021, 9364675, 13509761, 9839809, 9839635, 10069003, 10560577, 10576963, 9839713, 10069453, 9823549, 9102631, 10003753, 10839401, 10462537, 9119389, 12265193, 12265187, 9840169, 9840223, 9840217, 10544761, 9840529, 9840565, 9840571, 10577713, 9709723, 9709741, 10561573, 12314629, 10496119, 10561957, 10545559, 9103837, 11610605, 9054703, 10070503, 9660685, 9742633, 11610449, 9841003, 9841285, 10562275, 9841171, 9054721, 11545097, 9103939, 10562119, 9906811, 10546105, 12790751, 10038205, 12708839, 10070983, 9497371, 12462959, 10382149, 9579685, 9546961, 9546997, 9088243, 9546991, 9841681, 13347935, 10546195, 9546793, 9432145, 12463193, 10628173, 10628179, 9547045, 9088321, 13020437, 9825931, 10694299, 11497109, 9055987, 9547267, 9367069, 11251691, 9597079, 13529309, 10072207, 13398265, 10580125, 10252489, 10580173, 10547239, 9121891, 10547275, 12562817, 9761221, 10547461, 11350301, 12480891, 11366723, 12219031, 10760851, 9859753, 9859807, 11612891, 9040393, 9106039, 10056607, 9106393, 11088677, 11088701, 11088695, 10056511, 9122611, 10793827, 10777451, 10777463, 11088755, 10564477, 11088707, 10384537, 9122995, 10532095, 9843937, 9843799, 10777685, 11236769, 10630549, 9795031, 11236853, 10417435, 9073921, 10548511, 10630495, 9090709, 9090745, 10499743, 11400937, 13334201, 11236895, 11613797, 10565215, 9353125, 9828343, 11401073, 9844903, 9713839, 10549483, 9713881, 11663591, 9844963, 9828385, 9058357, 9844813, 9123937, 9845245, 10565929, 9107773, 10336549, 11188949, 9124411, 9042817, 9042823, 9091993, 10566631, 9747445, 9763615, 10550071, 11352911, 12204875, 13515995, 10878101, 9108697, 12451043, 9108709, 10878053, 10435675, 12450911, 12450893, 10616197, 9076165, 9076189, 9076213, 12533009, 12451073, 10632553, 10550647, 12451151, 10829149, 10059109, 11402755, 11485097, 10567591, 11337635, 10551157, 11485043, 12435269, 9814153, 11174123, 10961141, 12550355, 10518547, 11305067, 9879643, 9109615, 12353965, 10551685, 9666979, 9716131, 9830827, 10502557, 9798103, 10502599, 9814279, 11321651, 9814327, 11174153, 12370199, 10436905, 10961573, 10486435, 9831055, 10551943, 9781945, 11584157, 10961561, 10863341, 12321527, 10502701, 11305523, 10486381, 9781831, 10535491, 11403847, 11616845, 10044007, 9782161, 9388999, 10519531, 10568701, 11305937, 9995065, 9782053, 12403459, 9798481, 9782131, 10961747, 13534001, 10257553, 9749683, 9798823, 11355329, 10503373, 9749527, 9094219, 11437163, 11437181, 9815107, 9798733, 10503589, 10716557, 11306285, 10781995, 10716533, 9799039, 11617969, 9963217, 10716869, 10716731, 10503739, 11126279, 9340477, 9750097, 10716779, 10061725, 9340831, 10504117, 12797915, 9799609, 11274137, 10586011, 9078745, 10962887, 10586053, 9750523, 9701143, 10077997, 10241905, 10520401, 13338419, 10537105, 9324721, 10012867, 9816295, 9750529, 12240929, 10553443, 9783379, 9783367, 9750595, 9341047, 12274049, 9783721, 10799605, 9783757, 9832945, 9800185, 9832939, 10439137, 12372269, 9832705, 10537273, 9799987, 10717451, 9783595, 9767239, 12274367, 9783967, 11520647, 11307713, 9734881, 9783859, 11520611, 10504777, 11520599, 10472035, 11586551, 9358279, 10505209, 10439617, 13044671, 9653011, 10046209, 12372767, 11307791, 11307845, 11520857, 9784171, 9538693, 10259707, 9784351, 11570183, 9538627, 12602411, 12586031, 10866109, 12373403, 10046887, 10046971, 12373451, 11275565, 10505491, 10505551, 10505977, 13143713, 11587277, 9096715, 12373529, 13520507, 11308565, 10506157, 9064339, 11112329, 10244005, 9850867, 11112413, 11112407, 11112233, 11112221, 9785131, 9817927, 10243909, 11112311, 10522789, 9703591, 10522663, 11391013, 11112503, 9736255, 12537869, 10506259, 10506343, 9801817, 11325509, 9785455, 11293091, 9785779, 11571597, 10801655, 10047745, 11292941, 10064179, 11292929, 10801439, 10801433, 12374369, 11326085, 11571869, 9786043, 9802453, 11571905, 9769531, 10408537, 10064485, 9753493, 10507195, 10507249, 9786307, 9376759, 9802561, 10031995, 9802621, 9786517, 11441323, 9786523, 9819271, 11310257, 11310239, 9376777, 10064947, 11310515, 9704887, 9360805, 10048939, 10524061, 9541081, 11670833, 10048771, 11425073, 9360679, 11425055, 9803041, 11064683, 11425151, 11064701, 9819469, 10507591, 11064671, 9803473, 9967315, 11310617, 10819183, 11212403, 10262083, 10507849, 12162985, 9803701, 10508179, 11573225, 9787189, 9787183, 9590593, 11589443, 11311277, 10524805, 9787633, 11311301, 10541257, 12228817, 10574041, 11294771, 10246237, 9787483, 9476203, 9738679, 9820627, 9722317, 9722353, 11344337, 10246429, 9787687, 10901873, 10525051, 11573615, 10901837, 11311775, 10508947, 10050223, 10558105, 13097609, 12540647, 10525387, 9771745, 9542377, 10771165, 9280243, 10017301, 9787999, 9787975, 11311685, 10001305, 9771907, 11344859, 9771799, 9837337, 9362215, 11606789, 9509713, 10001233, 9280327, 9509701, 13556513, 11574089, 11050139, 10509469, 9788473, 9804877, 12426665, 10083775, 11050397, 10624489, 12426737, 11574737, 12180941, 10083823, 10575127, 10542367, 9805147, 9526639, 9789061, 9084583, 10788577, 9789133, 10493641, 11394775, 10493659, 12525113, 12426761, 12426869, 12426845, 11574863, 10264477, 11149217, 9084805, 10264537, 9805813, 10510135, 10575619, 9789277, 12427079, 12427073, 11149487, 10756267, 11149499, 11149451, 11575529, 10510543, 9838831, 11149373, 11624467, 9330733, 10543111, 14000255, 11034649, 12427267, 11149739, 11002283, 10510771, 10035625, 9609637, 11510167, 9609643, 11461091, 9298417, 9773329, 11460899, 10756405, 9773371, 9806161, 11149691, 9494851, 9773389, 10035553, 9740941, 9118399, 10625737, 9790177, 9789979, 11297315, 10035751, 11149901, 11330129, 10265587, 9659173, 10511227, 9790609, 11297957, 11297981, 11543723, 9807031, 9790675, 9102361, 9364507, 10527763, 9790855, 11298239, 10577335, 9348583, 11330879, 10839359, 10511629, 12265151, 12265109, 9348829, 10249975, 10429981, 10282549, 10430005, 10561135, 9348673, 9348703, 11315107, 10987397, 10987409, 10544905, 10987367, 10987361, 9824065, 10512247, 10053499, 10512211, 9545965, 9857257, 11348009, 11348021, 10987523, 10496017, 11577467, 10528843, 9726073, 10512475, 11348405, 9546181, 9775555, 9791749, 10594567, 10529053, 10054297, 11348621, 10513129, 9546439, 10283749, 10529293, 9775651, 10054183, 12462713, 9792067, 13528013, 10480531, 9546715, 10513387, 12561191, 9349933, 10627867, 11578229, 10529995, 9334015, 10513453, 10628209, 9792589, 10513531, 9088387, 9792937, 10513915, 9104869, 10513873, 9792847, 9809269, 9825925, 10563313, 10514161, 9334279, 11251205, 9793063, 11595269, 11251313, 9334393, 10432405, 10432435, 11333531, 10039249, 11595749, 10579921, 10252261, 9793303, 10514239, 10039081, 10579837, 10039147, 9793387, 10530955, 11333789, 10514659, 10039537, 10563787, 10760407, 11382829, 11350121, 9793603, 10056127, 10514845, 10777067, 10039753, 9744871, 10498357, 10498321, 10514707, 9793825, 10776941, 10776953, 9810283, 11301563, 9335479, 10515181, 9368257, 9368281, 10318531, 10531549, 10023451, 12382775, 13644365, 10777175, 11088467, 11629501, 11596733, 9335683, 9335737, 9794527, 9352159, 9794557, 9352183, 11236139, 10040101, 11629735, 11121845, 9352339, 10630285, 9794773, 10040521, 9090259, 12563681, 11597021, 12563651, 12383279, 10253725, 10515895, 9123277, 11662811, 10516141, 11400911, 10548955, 10499611, 11400809, 12220015, 11400821, 9336403, 9107029, 11302841, 9336751, 11401097, 10860487, 9730033, 13416293, 10925921, 9795733, 9124057, 10516735, 11303117, 9336841, 10041379, 10434637, 9828469, 9336943, 9648229, 11303321, 9779677, 10533355, 9779659, 12302651, 12302645, 11073821, 10582369, 12302705, 9337171, 11303237, 9124219, 10058083, 10041997, 11188865, 11582165, 12450497, 11631163, 12302855, 10500637, 12204665, 11303531, 9779779, 10632115, 9091999, 9665419, 11320205, 13531985, 11467535, 10025809, 9042811, 9845611, 10009795, 10501171, 9813007, 10370131, 10370125, 9370723, 11304029, 9354631, 10501555, 10960307, 10501507, 9076159, 11304347, 10632673, 10042819, 10960181, 12451145, 9961105, 10960541, 11484923, 10960637, 12369635, 10043113, 10583761, 10042891, 10960481, 9076315, 12516953, 9813625, 9076633, 9322411, 10633201, 9813967, 9076489, 9830173, 12369719, 9797383, 12549929, 11484983, 10960697, 11484935, 9076537, 10501909, 11484947, 12566393, 10518379, 13336325, 10501957, 9846643, 9797491, 11173727, 8994949, 9011335, 9650305, 10862735, 9109687, 10404043, 12239087, 9535723, 9044215, 9469981, 12238901, 10862645, 9469957, 10436617, 11173943, 9977863, 9977917, 9863203, 10862711, 10862705, 12238943, 10387867, 12190121, 9355705, 9028021, 9650641, 9355735, 9912817, 9044455, 10502611, 10862909, 9634111, 10895645, 9781573, 9355645, 9027967, 10551979, 9519745, 9306781, 9355951, 9372331, 9618139, 10699517, 9306655, 9306661, 9519709, 10961531, 9519739, 12239441, 9896851, 9028507, 11109311, 9405199, 9536275, 9503509, 9388801, 12239669, 9503497, 9388837, 10404655, 9372511, 9388909, 10847395, 9372841, 10486927, 9012403, 10601707, 11175137, 10814705, 9045019, 9045049, 11175011, 9438325, 10438033, 10585525, 9110935, 9618865, 9029053, 10585495, 10257919, 10700243, 9569593, 11158805, 10257757, 9028945, 10700159, 9012589, 10503493, 9569659, 9635173, 9553255, 9553261, 9045367, 10815167, 8980177, 9619147, 9979627, 9635353, 9618979, 9979429, 11109911, 10585699, 10585717, 9979459, 10258039, 9979501, 8980357, 11126705, 10700693, 9045937, 10700591, 9619231, 9946927, 8980303, 10700651, 9996139, 9357499, 9046027, 9603097, 9979927, 11110427, 9029707, 11159627, 9603181, 11127215, 11110835, 9472417, 10963349, 11176427, 9374149, 9013741, 11225549, 10324471, 11209157, 9357583, 8997127, 12323123, 10406227, 11127161, 9374041, 10701455, 10619623, 10619629, 9980611, 8997589, 11127503, 10390255, 9538285, 10390243, 9636409, 10324513, 10455979, 10701719, 11127749, 10619689, 9554689, 10292053, 10292047, 10472587, 9620659, 9833653, 9768127, 10243249, 10439857, 11553923, 10800275, 10800365, 8998111, 10800377, 9981175, 8998141, 8998129, 10800173, 9522181, 9030709, 10701929, 10800239, 10800203, 10800215, 13880827, 11505047, 9440707, 10243531, 9637363, 11161049, 10243567, 8998153, 9342223, 10243357, 9587989, 10800431, 10800437, 9932047, 9588031, 9932089, 9620797, 9768313, 9014935, 9572005, 10800875, 10407625, 10800839, 9867007, 9096733, 9047575, 9031237, 10538611, 9654163, 10407889, 10588153, 10391533, 10588117, 10800935, 9572107, 11128601, 9031477, 9342787, 9047899, 9015127, 10833757, 9047923, 10588321, 10391707, 10244245, 9982099, 9048193, 9965701, 9982129, 10621153, 12423395, 10621135, 9015541, 10571833, 10915903, 9621589, 10391623, 9310291, 10408003, 8982637, 11128925, 10391653, 10571869, 9130369, 9507229, 9507211, 12341665, 9638335, 10310059, 8999347, 9032119, 11145707, 9359839, 9376219, 9032173, 12423635, 12423461, 9621769, 12423449, 10408237, 9982243, 9621805, 9834793, 12423527, 12341593, 12423515, 9360007, 9360031, 9753217, 12423833, 11424389, 12423827, 10900199, 12423929, 10900193, 10441417, 10900217, 9638653, 8999665, 10703411, 10621489, 10621441, 11162117, 9687637, 10621549, 9359965, 12423785, 9622129, 10621513, 9032581, 9524155, 9753529, 12424073, 8999911, 10408735, 11424527, 11424539, 9638701, 9360205, 9638731, 11424587, 10376059, 10900319, 11506517, 10261663, 9655429, 10261633, 9557173, 9639097, 10900721, 10573051, 12178661, 12178643, 9622765, 10900517, 9638917, 10261555, 12424199, 9344077, 11424875, 10392655, 9704515, 9671803, 12424277, 9655705, 9606553, 10245523, 10573243, 12342679, 12490219, 10704377, 9590263, 9655789, 11162927, 10245379, 10720517, 10573063, 9016651, 12178793, 10573171, 12424553, 9540937, 12178769, 9704815, 10245475, 11179685, 9606787, 9033391, 10409653, 9017017, 9033397, 9000655, 9606877, 9000667, 10360513, 9590293, 9541135, 11507231, 10245673, 9049669, 10245715, 10245703, 9590371, 11212709, 10409863, 9639847, 9656269, 8968171, 10393591, 10393573, 9606931, 9950995, 10704677, 10393345, 9803575, 11048717, 10409821, 11048795, 9639781, 9852769, 10492069, 9279643, 10950845, 9345259, 10475749, 10393621, 10328071, 10573825, 11196425, 9984055, 9033787, 9869425, 9279613, 9869413, 8968309, 11508137, 9279883, 9968047, 9345481, 9345517, 9345535, 9640207, 9836863, 10950923, 9279805, 9345337, 9001291, 9279823, 9345355, 9361729, 9312595, 9345379, 10393969, 9361783, 9279859, 9001615, 9640639, 12327569, 11459321, 9509617, 10541779, 10410559, 10066513, 9378427, 9345655, 10951589, 11525051, 9902989, 9378739, 9362353, 9378781, 9001963, 9378811, 9411343, 10951463, 10623805, 10410847, 12344189, 9624415, 10623829, 9526405, 11132051, 9592063, 11132117, 9641197, 9526303, 9378859, 9526333, 11050001, 9329773, 9935971, 9034867, 10558891, 10952123, 9559471, 9592075, 9575737, 10034485, 9592153, 9379177, 10264219, 10952363, 10952375, 10264249, 10493677, 9133783, 9641713, 10952243, 10264075, 13688417, 10264105, 9608785, 9346633, 9625153, 9002599, 10247791, 10264165, 11378587, 9658315, 9625345, 11378443, 10542859, 10428235, 10592119, 9969523, 9609367, 9789577, 9609403, 9363655, 9363679, 13525151, 9609445, 9609451, 10477597, 9035851, 9855067, 9363853, 10412431, 9363877, 10379683, 9036235, 9298369, 9986551, 10838489, 12345653, 9658681, 12558611, 9363763, 11460881, 9314635, 11657597, 12345713, 9380191, 9363799, 10396021, 9986419, 12345665, 12346043, 10396333, 10838681, 9560779, 10576579, 9085669, 9986797, 9871903, 12345887, 10838531, 10396201, 10838627, 10396237, 10838597, 9036403, 9347971, 10462123, 9348037, 10249165, 10249213, 9004003, 9348067, 9675523, 9364249, 9347857, 10838789, 9741109, 9347899, 9347935, 9003871, 9823093, 9626479, 12264623, 12264605, 10773755, 10921159, 9348121, 9004051, 10986503, 10249303, 10986611, 9659461, 9692275, 9315451, 10954157, 11134349, 9610681, 12264839, 9528787, 10282459, 10773995, 9528781, 9020899, 9938227, 10773773, 10773779, 9856297, 10609993, 10397041, 9037183, 9315697, 8971951, 10774169, 9578179, 10774265, 9578191, 10774235, 9528853, 9627163, 9627145, 9315859, 10610179, 9528889, 9528865, 9954859, 10331737, 9528925, 11281991, 10397281, 9660343, 9873343, 9037759, 9316297, 10397689, 10954535, 10774307, 9643801, 9856831, 9480013, 10774343, 9316537, 9005233, 9627841, 10316029, 10397935, 10774751, 10397719, 10774529, 11184203, 10774949, 10578307, 10774925, 9005509, 10053919, 10397953, 10316077, 13101317, 10316113, 9627973, 10774853, 10398061, 9497239, 9022081, 9513625, 9513613, 9022123, 10775177, 10381999, 10398373, 9022135, 9693889, 10939133, 9366229, 10775237, 9382633, 11135531, 9021967, 9660949, 10775087, 9906703, 10398259, 10775129, 9382513, 9005959, 9382813, 11135873, 11152283, 9350071, 9366451, 9645001, 9317371, 9661417, 9350131, 10775351, 9300763, 9300769, 9546529, 10939157, 12495737, 9530215, 13511891, 9612451, 9612505, 9039073, 9039097, 11414737, 12315659, 9563173, 9661519, 9563251, 9645175, 9612385, 9022579, 9661549, 11398583, 9416113, 9006541, 9645529, 9317851, 9612745, 9989617, 12316109, 11398463, 10267999, 9039169, 11398523, 10251625, 10399081, 10399417, 9531043, 12447371, 10612375, 11398805, 11267819, 12562153, 9613003, 11398871, 11546165, 10251853, 11398733, 9629299, 10432399, 9646015, 9646027, 9105379, 9646051, 9989917, 9858841, 9318169, 10546999, 9858853, 9744175, 9858907, 9350977, 9858889, 10399591, 9498769, 10399891, 9990295, 9040027, 9990283, 9498763, 10252423, 11399297, 10793099, 10399909, 9351361, 9351391, 9351397, 11137223, 11399363, 10465327, 9023551, 9351235, 9039961, 10399861, 11399261, 11087957, 9367939, 10416529, 9728389, 9351589, 9351655, 11383075, 13349213, 9367825, 9367849, 9351457, 9367861, 9351499, 9007429, 9367903, 9351517, 9367909, 9351547, 11170493, 9614023, 10384123, 12301007, 9286387, 9351709, 10547767, 9368113, 12300905, 11399795, 9351787, 10318459, 9007729, 10318435, 10384267, 8991661, 8991655, 9384883, 10924955, 9925573, 11154419, 10253305, 10073077, 10384129, 10400563, 9007933, 9548587, 10957667, 9319261, 9007981, 10040191, 9352057, 11154605, 9614467, 9614527, 9614497, 10925201, 10499227, 10400983, 9614581, 10925105, 10925117, 12301331, 9647149, 8991799, 11138147, 13759493, 9024619, 9352297, 10712159, 10925147, 12186695, 9614737, 9614743, 9647509, 9631129, 8992159, 9631147, 9614761, 12318185, 9975235, 9041389, 9598435, 9565669, 9614599, 12449033, 9581863, 9614635, 11220245, 9581917, 9614713, 9614701, 11482793, 10270393, 12302027, 9860833, 9647641, 12187169, 11318837, 11138615, 9860659, 9991729, 9614935, 9975391, 11138657, 9614923, 10925693, 10581631, 9008749, 9664111, 10516393, 10401673, 10024879, 13514741, 9009091, 10582009, 11319235, 11319257, 9991951, 11319095, 11400965, 9975589, 9533275, 9992011, 9631567, 10925945, 10925903, 9975661, 9025393, 9091243, 13826297, 10336477, 11483387, 11024585, 10336495, 10385635, 10336483, 9992227, 12318827, 11319371, 9009271, 9697675, 10402177, 11499911, 9009571, 10402225, 9501091, 9386461, 9533713, 10402075, 10385677, 9369901, 11139425, 9369961, 12516029, 9370267, 11123381, 11483843, 9009913, 10877651, 12548807, 9386509, 9992731, 10402321, 9370135, 9353785, 10304113, 11139677, 12335689, 10304107, 9370231, 9648751, 9370225, 9993169, 9010147, 10255333, 9354007, 9632545, 9648937, 9354049, 10074949, 9026389, 9648973, 9337705, 9616225, 9632917, 10615951, 11025563, 12450953, 9632941, 10255561, 12418271, 10403053, 9419785, 10255375, 10615867, 9550891, 9288781, 10615915, 9632857, 10255447, 9567349, 9288805, 9550945, 9059449, 9829777, 9977317, 10583341, 10075399, 9633139, 10583389, 10911403, 9600703, 9600727, 8994499, 9584167, 11484695, 12533363, 9600589, 9633385, 9863059, 9863047, 9650101, 10600417, 9977851, 10600405, 9600811, 12238595, 9633625, 12238685, 9863011, 9027445, 9633943, 9027727, 9781417, 10862837, 9666763, 9781477, 9535519, 11206709, 9535537, 9027661, 9633883, 9666655, 12320849, 9027709, 9027973, 9355651, 12272039, 10862993, 9798061, 9044401, 9355741, 9060817, 10387909, 10076665, 9044449, 9535981, 10387939, 12321083, 10862891, 9290017, 9027877, 10862867, 10862975, 12239417, 9355813, 9667105, 10764817, 9355825, 9781843, 9994831, 10388035, 13517765, 9651103, 9077659, 9683851, 9028501, 9372607, 9012151, 9028555, 9372625, 10699523, 9028435, 9995119, 9782455, 12403963, 9683995, 11224103, 8995861, 9372751, 9323599, 9012301, 9585733, 9012307, 12239939, 9569695, 11175347, 9569701, 9045445, 11633977, 9012487, 9028891, 10257733, 9651529, 9012565, 9684301, 9045349, 9667951, 10258105, 10012351, 9045727, 9651955, 9782803, 10257943, 9324061, 10405381, 10405423, 10569319, 9045571, 10405441, 9045613, 10618447, 9045607, 9029245, 9963421, 10586047, 8980393, 10454965, 9701305, 9045967, 12322799, 9684943, 9619447, 9815857, 10241881, 9029467, 9045841, 9045865, 9324415, 9603223, 10045627, 9062587, 9603247, 9668635, 9029653, 10029115, 9619495, 9537577, 12322817, 12241019, 11208773, 9013375, 11110841, 11536799, 9865693, 10406347, 11618797, 9357595, 9603373, 9029977, 10422595, 9046357, 10406545, 9538177, 11111093, 12159655, 9865915, 9997009, 9374431, 10390267, 10324501, 11405827, 11618821, 9357877, 9046633, 10619683, 9554713, 10390309, 9030475, 10423117, 10292095, 10292083, 10505047, 10407049, 10488985, 9030835, 11160635, 9751609, 10407007, 10259551, 9047131, 9407581, 10423363, 10407325, 9686425, 11161073, 9031141, 11275553, 9588013, 8998213, 9047695, 13045469, 10800791, 10800785, 11112095, 10800797, 11144909, 10800689, 12226051, 9653875, 9604723, 10800719, 9015247, 11505611, 9015271, 11505617, 11177783, 9031471, 9637705, 11112281, 10408189, 10588363, 11145425, 9637915, 9670681, 9654301, 9015325, 12455971, 9048109, 10391629, 9687109, 9752701, 9310327, 10801241, 9982393, 10310107, 9720313, 10441201, 10408225, 9654595, 9621829, 10522945, 9376441, 9015985, 10408615, 13931243, 9671383, 9048823, 9671221, 13390355, 9048997, 10408873, 11424665, 9835495, 11523029, 10507231, 9016075, 9360139, 9360133, 9016069, 12342061, 13620061, 9016099, 9376549, 9360193, 9426055, 9573511, 12424355, 10261687, 10261699, 11162639, 9557071, 12522587, 10900571, 11163053, 10622359, 11507189, 10884553, 10622413, 9049585, 12424499, 10294543, 10343737, 9655597, 12424517, 10573483, 9000583, 12179105, 10245823, 12179075, 9590485, 9590491, 10360531, 10426057, 9606907, 10245649, 9000523, 10245727, 10409563, 9000559, 9066109, 11195987, 11163569, 9672589, 10606465, 12539783, 12179453, 10557415, 9852889, 12425171, 9050101, 9606919, 11196287, 11622247, 12425063, 9951091, 9000817, 8968333, 10754233, 10016989, 10426567, 10573873, 9607171, 9050143, 9050149, 12343369, 10410373, 9312691, 9361867, 11196911, 9279967, 9361879, 9050599, 10246417, 11180297, 9034033, 9722209, 9640297, 9001627, 9345715, 9722539, 11213549, 9689797, 9722605, 9050665, 9050659, 9984601, 11213381, 9345661, 9001879, 11541377, 9001933, 9345991, 9001939, 9346027, 13048751, 9018169, 9018181, 9034579, 10705733, 11213663, 9018505, 11525291, 9378949, 9657481, 10574977, 9526459, 9526483, 10443997, 9526489, 9378877, 10574947, 11459687, 9804871, 9378901, 11377741, 10411135, 9575833, 9035155, 10411429, 9068011, 12180959, 10001695, 10427671, 11459867, 11509103, 12311935, 11525453, 9690493, 10264213, 11509439, 10264237, 9543379, 10264261, 10035097, 10002319, 10592131, 9985999, 9969433, 11198249, 9117469, 11509559, 9133867, 11460461, 9674587, 10772341, 9969535, 9691003, 11280551, 11280545, 10428547, 9822397, 9691309, 9019633, 10019041, 10412257, 11542565, 10428469, 9035845, 9609331, 12329033, 10412443, 9888133, 9494965, 9478591, 9675169, 10002859, 9986521, 9019843, 10953155, 9117997, 11379055, 11166053, 9019735, 11166047, 11510435, 10511077, 9036487, 9364201, 9986575, 11526707, 10953233, 9364045, 9871957, 10412629, 11379271, 9740911, 9675697, 9003937, 10838927, 10003363, 10953701, 11166695, 10838981, 10838819, 9560857, 10396465, 11379529, 9348265, 9987247, 10953959, 10953935, 10986707, 11166929, 11510993, 10265611, 10265605, 9004075, 10626049, 9987145, 9626749, 10265707, 11511227, 10839431, 9102799, 9594325, 12346859, 9037267, 12330299, 10446091, 10986773, 9037117, 10429729, 9037135, 9004357, 13624607, 9921919, 10954073, 9987757, 9856735, 9856759, 9791203, 12264977, 10954259, 9594409, 9627181, 9021001, 10331731, 9070201, 9610855, 9987997, 9021355, 10348465, 9316345, 10954715, 10512349, 9627409, 9447223, 9627427, 9824077, 9037651, 9021283, 9021577, 9676945, 9627799, 9627835, 9709759, 11200757, 9627883, 9660433, 9054211, 11085883, 9660421, 10496023, 9021505, 10627489, 9546139, 10955153, 10561951, 9038107, 9021715, 10955009, 11168003, 10758409, 9038173, 9038179, 9022117, 10775195, 9120457, 9661135, 10955477, 10939103, 9087499, 10562059, 10775165, 9038437, 9661027, 9366457, 10775495, 9989095, 10939181, 9988873, 11234051, 9628459, 10775321, 9988903, 10939241, 11086715, 10775411, 11512649, 11168579, 10939211, 9448603, 10775729, 10775741, 9989329, 12561653, 9039061, 11185397, 9432073, 9366565, 9743419, 9366589, 12332039, 12217463, 9612367, 10775675, 9661555, 10300519, 9628777, 9006487, 10956179, 9727405, 10759663, 10251769, 11546069, 10579417, 10513699, 10268029, 10431859, 10268017, 9006463, 10956125, 10481311, 9039499, 9006739, 11316895, 9973441, 9629419, 10612447, 10006027, 10366471, 9104917, 10448443, 9006625, 9039439, 9039775, 10710923, 9613255, 10465225, 10579765, 10055437, 9039649, 9957181, 9629521, 11186021, 10956611, 11513669, 9957217, 10399897, 9531553, 9629863, 9384121, 9629869, 9629899, 9122005, 9122023, 9990379, 9695281, 9596977, 9859135, 9596971, 9318469, 10694767, 10793347, 9859525, 9023965, 11170295, 9679351, 11170259, 10580263, 9990409, 9023803, 11399549, 9351817, 9024157, 9532123, 10318543, 9007867, 11170367, 9351697, 9351727, 9318949, 11203091, 11317777, 9318961, 11399789, 9318997, 12448337, 11399747, 11399765, 9024403, 9057175, 9991105, 9024289, 10007371, 9024343, 10056565, 12203195, 10482823, 9024661, 9335995, 9319639, 10925255, 11515085, 9532669, 12203213, 9516055, 9040903, 10613809, 9827335, 9024571, 9516067, 9516073, 10384465, 10253383, 9024637, 10925477, 10925483, 9680257, 10925567, 10925351, 10925345, 10417423, 10630411, 9581911, 9712987, 11400515, 10925405, 9664135, 9025183, 11400833, 12301961, 9025273, 9991915, 9615079, 10598107, 9025423, 9631621, 11319221, 9320383, 9320377, 9615313, 11319269, 9615325, 9025513, 11515847, 9860893, 11204411, 10581823, 9713467, 11171657, 10581829, 9123685, 9664645, 9615541, 9681109, 9615565, 9959665, 10402039, 10025011, 9041995, 11171951, 10958969, 9042349, 13515263, 9681403, 9320947, 11335987, 9992557, 11516249, 11516585, 10418899, 10877681, 9370327, 9026287, 9992935, 10402363, 11483675, 10418731, 9042505, 9370177, 9091675, 9370201, 9992821, 9534055, 9354133, 11025395, 10418971, 9353989, 9370411, 9010009, 10877813, 9354079, 9354097, 10468507, 9993361, 9534607, 10255543, 11222165, 9338065, 9043171, 9993463, 9649153, 10828855, 9534475, 9993259, 10533907, 9010255, 9419845, 9829471, 10878067, 10583131, 10435969, 9993649, 9027037, 9354715, 10632703, 9993721, 9027067, 11517395, 9026881, 10485073, 9682279, 9043591, 9354907, 9584263, 12189323, 9584347, 9617113, 8994529, 10583587, 10501651, 9027121, 9043531, 9076327, 9961081, 9027457, 8994715, 9650083, 9338821, 9666325, 12238627, 11190065, 9600841, 11190089, 9682807, 9650047, 10485937, 10567873, 9060583, 10715153, 10420297, 11534423, 12353945, 10961345, 9797905, 11239787, 9650509, 9781609, 12517697, 11322011, 9028279, 9355999, 12337715, 12370469, 12337703, 11174417, 10863215, 9847417, 9388939, 10552213, 11535239, 11518805, 8995969, 11256995, 11519165, 12240017, 10962149, 11535599, 11273429, 11551799, 10454107, 12223615, 12354665, 11240567, 10962347, 10421671, 12240257, 11240939, 10520041, 9012679, 9012697, 10044709, 9782569, 12240227, 10716833, 9799351, 11126423, 9078499, 9012763, 9062275, 13158371, 9078709, 10258429, 10504135, 12355535, 12355349, 10798867, 11519849, 9717619, 10815317, 10815323, 10258561, 9046177, 13338761, 9324763, 9603325, 9046267, 11405371, 11241545, 9980023, 9537973, 12421513, 12339707, 10029367, 9849133, 9849157, 9341617, 11307553, 12339743, 9751087, 9374317, 11389513, 10439647, 9833461, 9030631, 11226077, 9358099, 10488691, 9423697, 11570009, 10505383, 10554553, 11521169, 10030105, 11553839, 10439743, 9030733, 9538657, 9063817, 8998297, 9719173, 12520865, 9063883, 11619787, 9719071, 11226485, 10489159, 10604161, 9440773, 8998423, 10489351, 10800745, 10719167, 10801151, 9736189, 11226917, 10424071, 10719089, 9064285, 11390833, 9719665, 11112611, 11112635, 10801343, 10031311, 9736213, 10801157, 11210873, 9752983, 11620765, 9753055, 9064723, 13521251, 10473799, 9326965, 10949297, 9491125, 11276945, 9818863, 10457605, 9622051, 9343543, 9736801, 9016207, 11260889, 9540583, 11260883, 10064641, 11211605, 11424929, 9720967, 11424911, 9442483, 11424905, 9557167, 9344239, 9786607, 10622071, 9507919, 10622023, 9360505, 12325955, 9360781, 9328003, 9409981, 10589695, 9819481, 12326237, 10016407, 12342931, 10901243, 9737983, 10262041, 9328135, 13538939, 9098803, 9737809, 9328195, 9737851, 12326465, 10475413, 10049521, 9066493, 9000745, 10491649, 10901261, 10491667, 9000781, 10573675, 10246009, 9541501, 10753867, 11229353, 11540627, 9738427, 9738415, 10574059, 10426393, 10901561, 9328699, 9607207, 10901603, 10246231, 9721921, 11540585, 10426483, 9329029, 12589465, 9738559, 9722179, 9722227, 9542011, 9362107, 9362125, 11148017, 11049665, 11049689, 11049695, 9329239, 9280117, 10508893, 10476433, 9051043, 11049863, 10017703, 9051073, 11049959, 11049929, 9706495, 12426191, 9346039, 9100051, 11049743, 10476337, 11049749, 9050965, 11049821, 9706627, 11230337, 12180623, 9379051, 10624207, 12426287, 10017793, 10476547, 12180587, 12180575, 9706597, 10526089, 9329935, 10018063, 12426605, 11230529, 10018435, 10034893, 13508171, 9559579, 10493503, 9330217, 11624047, 9346657, 11460581, 11460593, 11263967, 9068335, 11575049, 9052003, 11460437, 10018957, 11002103, 11002109, 10494157, 9723913, 9511315, 9724351, 10625479, 11461085, 11002145, 11378947, 11002229, 11231603, 10576195, 13525307, 10805923, 9708223, 10494619, 9364183, 9069283, 9380371, 9019963, 10084945, 9757309, 10445707, 10462207, 10462183, 9708289, 9364261, 9724729, 10576747, 10756975, 10429261, 10396519, 10396513, 9102469, 10462339, 9823423, 13444345, 9708757, 10429693, 11543747, 9004285, 10429465, 10429453, 10839065, 10265671, 12412331, 12264857, 11265413, 9725359, 10429909, 10020295, 10610113, 9331999, 9807139, 11232635, 9758017, 10020163, 10020223, 10577233, 11577001, 10987139, 10020595, 10987217, 11281967, 10987043, 10987049, 9348631, 11380279, 10987067, 10249765, 10987121, 11232839, 10626643, 10987091, 10987097, 10250125, 9856903, 10577809, 9545635, 11233175, 10528711, 10627039, 9594637, 11233049, 9774883, 10577695, 11265893, 9578317, 11233103, 10250089, 9726097, 9054349, 12347549, 10479793, 11266481, 9546193, 9103855, 11577725, 9333469, 9513679, 12348107, 10480135, 10562077, 9103963, 12348005, 9742951, 9054841, 10939337, 10939349, 9677803, 10382107, 9497347, 9022255, 9022261, 9333577, 9022279, 9743491, 10939445, 9432109, 11545607, 11562101, 10628215, 10775975, 9366919, 10268101, 10022395, 10776011, 10628575, 12217601, 9366871, 11267393, 9793177, 9006775, 10579657, 9367057, 10776089, 10579549, 9334729, 9777151, 11087813, 9744157, 10481491, 11235149, 10628941, 9728191, 9482407, 11088125, 10399999, 10694863, 9711715, 9056647, 10564021, 9794047, 10023199, 9728281, 10481977, 10481953, 9859411, 9711955, 12267893, 10711409, 11088203, 9711985, 9793891, 9073321, 10039981, 9990877, 10957553, 11547371, 10957511, 10547749, 11088389, 9744955, 9712243, 10007143, 10711937, 12350351, 10957727, 10957787, 9712405, 9335635, 10957649, 11400353, 11400377, 10712195, 10630399, 9712891, 9532507, 12334199, 12563891, 10958249, 8992207, 10499563, 10778099, 10450375, 9450991, 12334349, 9712969, 12449471, 10925729, 9336493, 9713395, 9778927, 12449321, 12449399, 10761853, 10417945, 12449555, 12449537, 10434337, 9336661, 12547913, 12351677, 11466913, 12449963, 9746593, 12302477, 12302591, 11319551, 11319509, 10958885, 9648181, 11188229, 9074725, 12449891, 11188313, 9615763, 9025939, 9025969, 9517507, 9779695, 12335423, 9632029, 10336519, 10025221, 10516741, 12450065, 9304381, 12450059, 9714007, 9304393, 11172485, 9714421, 9665263, 10517053, 12335741, 12352103, 9386605, 10467961, 9042559, 9370501, 9730957, 11369369, 10877951, 10877891, 10877909, 10533691, 9075499, 9567379, 9354397, 10009819, 10763267, 10288537, 10485205, 11025857, 9714949, 11025713, 9731377, 12844397, 11566349, 9747793, 11484539, 11255135, 10583737, 11533961, 11353751, 9715393, 10583611, 10485655, 11288483, 8994733, 9748411, 9060343, 11239181, 8994667, 10714949, 9027721, 9863311, 9994429, 11223191, 10535071, 13516967, 9650431, 9732331, 9666577, 9027655, 9633859, 9633871, 9535615, 9535597, 13025741, 12239285, 9535885, 12239153, 9011485, 12550433, 10862855, 12189983, 10076467, 12157309, 9011551, 9027925, 9863497, 9011575, 9306763, 12239531, 9355975, 10387999, 9667093, 9355777, 9012109, 11158457, 9388975, 9372601, 9372595, 8995777, 8995837, 11437019, 10863395, 9093889, 9372457, 9749305, 9044773, 9372469, 9012049, 10552483, 9045163, 9045211, 9012439, 9635041, 9028849, 9733171, 10454137, 9422221, 10257805, 10257853, 10012093, 9553315, 10454443, 9061831, 10585591, 10618333, 9028867, 9045313, 11142821, 10536583, 11159279, 11503313, 10585651, 8996383, 10585663, 11175521, 12240451, 10028929, 10569601, 8996827, 9635791, 10258231, 10241839, 11175803, 9111385, 8980309, 9013423, 9980083, 11159681, 11159801, 9750757, 9324793, 11110463, 9979909, 9865291, 9504883, 9029731, 9013663, 9324961, 9374155, 10553845, 9636337, 9865699, 12552575, 9488731, 9668989, 9865573, 8997505, 11143847, 9767599, 10406623, 11520719, 9112303, 8997391, 9013801, 9980461, 9013867, 9013861, 10259347, 11406307, 11209475, 11504387, 9014089, 9423691, 9046867, 11144375, 9342097, 10407103, 9079975, 9047245, 8998087, 9637057, 9637093, 11144405, 11144255, 10259467, 8997973, 11193437, 10800575, 10800521, 11308439, 10456531, 9637315, 8998363, 10800635, 10800581, 10784209, 10800419, 10800425, 8998165, 9391423, 10358053, 9669955, 9702775, 9325921, 10702163, 10243429, 9047761, 10800833, 10243825, 9572071, 9473767, 10014217, 9768505, 10243675, 10047049, 10030669, 9080413, 9604711, 9637483, 9867157, 9015193, 9981865, 8998843, 9867205, 11292617, 9473809, 10702625, 10407703, 12538037, 9998473, 9801943, 8982727, 8982745, 8982751, 9621745, 10407949, 9768961, 12242977, 9326611, 9539641, 10440757, 9850969, 11161679, 10571857, 10621321, 10588561, 9015739, 9687355, 9621823, 11145599, 9654643, 9736849, 10506883, 10621573, 9360049, 11162345, 10408681, 9360121, 9376267, 9753097, 10408507, 9032281, 9376381, 9376375, 10621531, 9048985, 10507153, 9638827, 9376717, 9360361, 10425115, 10408705, 11506439, 11424623, 13521671, 11424629, 9376609, 12424019, 11424599, 9688213, 9639049, 10425553, 10900679, 11424971, 9671929, 10261549, 10703939, 12195257, 10999231, 9639307, 10245511, 10589599, 12326399, 10540531, 9721147, 10409263, 9033049, 9360751, 10261879, 8983927, 9590413, 9115297, 10360489, 10901147, 10524403, 9115345, 9688819, 10065649, 10573345, 9033241, 9000487, 12326411, 10245709, 9360985, 10540621, 12277333, 9639835, 12179357, 10754017, 9770947, 9000913, 9000919, 11163593, 10524625, 9983797, 10606453, 9033865, 9066637, 8968321, 9869491, 9017509, 11163797, 10754279, 9017551, 10901729, 11049185, 12540137, 9279733, 10393825, 9492517, 9459751, 9099319, 9001057, 10541131, 8968291, 10410085, 10394005, 9017755, 10049977, 9050575, 11180543, 9640213, 9640219, 9656635, 9787711, 9034021, 10623247, 10393897, 10393939, 9279853, 9771379, 10246519, 9345709, 10623643, 13343363, 9345751, 9361933, 9345541, 9017899, 9345595, 9787945, 10754585, 9345613, 9017923, 9656959, 10410607, 9001885, 10410889, 10705823, 9001909, 11459525, 9100285, 11164625, 11049839, 11459441, 13540139, 10411147, 9084079, 10280119, 9018565, 9657361, 9018403, 9378895, 10411099, 11394175, 10607701, 9575527, 9575809, 9035167, 10444255, 13344137, 9641443, 9641311, 9018715, 9592135, 9575797, 9575779, 10952027, 10428037, 12181139, 9313975, 10264231, 9035467, 10952429, 10264273, 10051327, 9035491, 11280095, 10952255, 10346029, 9559591, 9657949, 10264141, 10051147, 10952267, 9625477, 9691063, 9625507, 9002953, 11345897, 10592059, 9002803, 10755925, 9609397, 10412209, 11559047, 9953515, 9019459, 10543225, 10625119, 10444897, 9478555, 9036181, 9036193, 9003457, 9986335, 9953593, 9609517, 9019771, 9363835, 10412389, 9118357, 10396327, 10068691, 10838777, 10298101, 9003751, 12477137, 9839353, 10953425, 9986587, 12362303, 9740863, 12345959, 10396225, 9003631, 11166275, 9642595, 12345935, 9642889, 10757011, 10265557, 9790453, 9004027, 9642991, 10265569, 9364285, 9560869, 9003883, 9003901, 10986683, 9364627, 13755641, 9626809, 9036991, 9626821, 11183309, 10986713, 9643009, 10249225, 10249273, 10462261, 10986509, 10986593, 9004111, 10364023, 9004147, 9348211, 9020815, 9921949, 9315817, 10282483, 10282477, 10986965, 12264749, 10986809, 10609945, 10626331, 9938257, 11511143, 10511737, 9004375, 11495099, 11314871, 10430143, 9545395, 9021115, 9856687, 11183867, 9578215, 10626775, 12265013, 9594427, 9856573, 9856549, 10479199, 9643609, 9594463, 12166747, 9856633, 10397599, 9004945, 10774457, 9873331, 9037753, 9316279, 10708889, 10774505, 10397635, 9578251, 9643789, 10774391, 10774355, 9021571, 9332911, 10496131, 9758899, 10774667, 9005257, 10774763, 10774733, 9038071, 9021451, 10627105, 8988673, 11233337, 9627649, 9627709, 10774631, 10774637, 10479697, 9103465, 9726061, 9021559, 11184515, 9349561, 10955165, 10774943, 9333199, 10463695, 9349609, 10774829, 10774841, 9021739, 10774895, 9644401, 9644389, 9349765, 10939049, 10381969, 10775231, 10939109, 10545901, 10939115, 10939079, 10382071, 9661165, 10447585, 9906733, 9071491, 12217225, 9644965, 9644995, 9366523, 9006079, 9988891, 10382101, 9038611, 11086601, 11529077, 9775975, 9038707, 9022633, 10775777, 11513087, 11316473, 11627569, 9710611, 9366529, 9006097, 9006157, 9628759, 9006145, 9006163, 10579387, 9039289, 9006583, 9006355, 12332315, 10251601, 10956137, 9006427, 10464583, 10251631, 9039229, 10628437, 9661807, 9006721, 11398817, 9629353, 10432219, 11398889, 11398853, 10612429, 9531115, 9645595, 9629233, 11087363, 10579471, 9645649, 9629275, 9317983, 9645667, 9858967, 9039751, 9334687, 11186057, 10334113, 11153387, 9629659, 9859021, 11399153, 9301999, 9629665, 11513819, 11399123, 9613087, 9957145, 9940795, 9613099, 10399561, 9957199, 9531211, 9072481, 11398979, 9957229, 11366573, 10399903, 9646231, 11399339, 9744541, 9629827, 9859201, 10399879, 11169971, 10399873, 9629875, 9466027, 9056449, 10580209, 11399387, 9596953, 9646093, 9646135, 10465315, 9007189, 11399243, 9351553, 10039735, 11022745, 9023923, 10957301, 11088347, 11399633, 9056521, 11153783, 9351823, 9040537, 9007771, 10957541, 9007855, 9024229, 12448319, 8991235, 12448307, 9040429, 9695803, 11399705, 8991295, 9318991, 11399807, 9679777, 10384297, 9319345, 10843117, 9401287, 12301295, 11400131, 11399951, 11531105, 9040765, 10925237, 11515013, 11220113, 9319663, 10925279, 12399815, 9024559, 11498525, 8991793, 12301319, 10925183, 9532513, 9024631, 9631123, 10352017, 9631105, 9647533, 11154923, 10401235, 9008593, 9630979, 9614653, 9319807, 9729391, 8992117, 9319795, 9631417, 9647779, 8992435, 10598047, 10270429, 10598137, 9647857, 11319005, 9631459, 9631471, 9615085, 9598525, 9598531, 9041491, 9631339, 9844675, 9615355, 11319077, 9631519, 9631495, 9336655, 10401631, 10581865, 9320281, 10762069, 9992047, 9615211, 10762075, 9959605, 9844957, 9025753, 10450945, 8992819, 10516585, 9009277, 10713509, 10402189, 12220711, 9009481, 9648499, 9533815, 9025909, 11156105, 10631827, 9026227, 10074847, 9632479, 9042685, 9533983, 10041865, 9697843, 9894463, 9370171, 9992749, 10304089, 9042499, 10402381, 11025011, 9026161, 9354157, 9010087, 9010129, 9026515, 10009543, 10255345, 9649123, 9370423, 9534253, 12450647, 9370495, 9780373, 10255501, 9682057, 9649321, 10255573, 11173093, 10255555, 8994025, 11140301, 9026605, 10075189, 9993271, 10255405, 9550933, 10615921, 9337981, 9338251, 9944473, 10288519, 9043375, 9649627, 9944515, 9649657, 10927571, 10255639, 8994115, 10255723, 9633133, 9354883, 12320423, 9633421, 9043645, 10075861, 8994319, 10075699, 8977957, 10403431, 13434823, 10420141, 11157395, 12238721, 8994763, 9650167, 9027343, 10403599, 11157353, 9453427, 9683089, 10961069, 10863017, 9634177, 9650611, 11190665, 9634231, 9748897, 9683431, 10863059, 9634081, 9978205, 11288909, 9060733, 9355915, 9667231, 10486447, 11125427, 11518607, 9749173, 9700027, 9323191, 9700057, 9994783, 11518565, 10519147, 12157849, 9683887, 11437007, 9995263, 12239819, 10568659, 9372661, 11191151, 9667405, 12240047, 9372853, 9700603, 9929731, 9372715, 12239873, 9995329, 9684091, 12256753, 9553351, 9684265, 12617087, 9323851, 10585765, 9995917, 10503919, 10618465, 10077799, 11405221, 9324421, 9324475, 9668569, 10585879, 10241869, 9701191, 10585921, 9324397, 10012831, 10717337, 9849043, 9750775, 11192525, 9898219, 9849067, 9668623, 10405939, 10586143, 10422361, 10078639, 11209111, 9734623, 9488677, 10422655, 9357997, 9685711, 9325171, 9358285, 9718753, 10439653, 9554737, 9554743, 11520773, 10619761, 9702589, 11324627, 10046521, 9522247, 9407599, 12324287, 9588121, 8998327, 9817555, 10014349, 11390719, 10800857, 10931759, 11210291, 12324389, 10030645, 10801031, 9670573, 9637879, 10784545, 9572149, 10243915, 10800965, 10440553, 10408081, 10588339, 9310357, 9310369, 10588315, 13340807, 10539253, 11522255, 10899503, 9097219, 9064555, 9621907, 11522471, 9621889, 9982375, 10801463, 10408255, 9343273, 9998671, 10556095, 9687739, 9343711, 10719959, 10015459, 9851485, 11276873, 10507177, 10376101, 11326253, 11178755, 9360247, 9557149, 10900631, 11064551, 9819337, 9344227, 10458349, 10900691, 9999391, 9573493, 10458529, 9328111, 10589647, 9328123, 10261783, 9671971, 10442029, 10900817, 10049161, 10475137, 9623227, 10901129, 9656023, 10360537, 9934537, 10458817, 10360549, 10262047, 11179553, 9688633, 10245751, 12424781, 11179943, 9607093, 12179441, 9656287, 10459105, 10245901, 10426117, 13506413, 10245937, 10622737, 11196179, 10000213, 9656137, 9607033, 9820003, 10901687, 10721417, 9705691, 10934473, 9656551, 10574047, 9885721, 11376641, 10459177, 9689209, 10819663, 10623067, 9722287, 9279943, 9279937, 12179939, 10000837, 9279991, 10393981, 10623313, 12179783, 11197127, 10000903, 9361981, 9345931, 11262899, 9820951, 10558315, 10804051, 9378955, 11181185, 10574995, 10575079, 10575097, 12213443, 11213921, 9575827, 11525567, 12328445, 9100753, 9657805, 13344065, 12213551, 9821455, 12328313, 12574073, 9592159, 9592183, 10247827, 10411663, 11198111, 9313969, 11460323, 10264309, 11181767, 9575947, 9674311, 10034803, 10411621, 9330565, 10411981, 11460545, 11214815, 9707287, 10264351, 10428175, 10821481, 11198291, 10445005, 10445053, 11002061, 9773287, 10084591, 9625627, 11001965, 10444921, 10330513, 9380317, 10002943, 9806131, 11002211, 10428751, 9724273, 9658747, 11198789, 10019533, 10511101, 9363979, 10625581, 10428943, 9363997, 9363991, 10412599, 9364075, 10838945, 11510657, 11183003, 9675721, 11232245, 9675757, 10396417, 9560875, 9364303, 10838867, 10364053, 10364047, 10986647, 10527889, 10609891, 10986695, 10986701, 10986719, 9675859, 10265665, 9692257, 13509689, 10249615, 9938305, 9774583, 10986959, 10560991, 9102619, 9004315, 10249525, 10249561, 10462543, 10986869, 9348451, 10446481, 10036867, 9709243, 9594541, 9594589, 10249927, 10249741, 11511713, 11233253, 12527591, 10954505, 9594661, 9856855, 9332575, 10708805, 9644203, 10004647, 10905655, 9545791, 9791527, 10479703, 9775177, 9119869, 10529185, 10955225, 9627925, 9693469, 11184395, 10955075, 11496113, 10382041, 9513673, 9546487, 10382053, 9349699, 9349723, 9120349, 9333337, 10709627, 10791547, 11512391, 10939271, 10775435, 10775525, 10939373, 11529215, 10939193, 9300775, 9841453, 10005343, 9694027, 10939259, 10939205, 10431355, 10464109, 11513009, 10415233, 11316403, 9563311, 10513651, 9432085, 9661879, 10956269, 9530821, 12332489, 10464745, 10775813, 9088333, 10825075, 10005871, 9088369, 9727639, 9334489, 10251973, 10038811, 10579513, 9842239, 11185667, 10694173, 9662041, 9777043, 9613279, 11218931, 10956743, 10415881, 10628881, 9711445, 10776389, 10448737, 11186363, 10416349, 9662677, 10006777, 10580185, 10563589, 10956821, 11547023, 9122251, 10957295, 9777631, 9695683, 9744895, 10416391, 9875773, 12448067, 11514539, 11399837, 13513463, 11399927, 10007095, 11186813, 12448331, 11170721, 11400083, 10613743, 10433479, 9909199, 11400149, 10416949, 11399939, 10957595, 11219819, 12219235, 9712489, 10433725, 9024685, 10482913, 9663553, 9925699, 11400269, 9712765, 11514971, 11187287, 11220053, 10925489, 10253701, 9319825, 10925447, 10925471, 12547459, 12449273, 9582019, 10352119, 9844063, 10515817, 10925435, 11547989, 12449111, 9581935, 11368117, 11171561, 10008283, 13448833, 10270417, 9336529, 10417681, 8992273, 12301841, 10565233, 12301931, 13022747, 11515505, 10417783, 10925663, 9975775, 9861073, 10582003, 10581955, 9058285, 12302285, 9860875, 9336637, 11516069, 10860715, 9795763, 10713227, 11319449, 10451149, 10451197, 11319353, 10451053, 9681001, 9697669, 11516345, 10500535, 10418593, 9681373, 10959347, 9501181, 10009063, 9959683, 9681553, 10025611, 9763495, 11533001, 9747169, 9665053, 11483711, 10402393, 10402387, 9681529, 9747409, 9124813, 11025401, 10042315, 9354199, 10468351, 9042733, 10419037, 10877765, 9436009, 10419043, 9780379, 10075273, 12565649, 9534625, 9338047, 10419445, 11189447, 9534691, 9698353, 11025515, 11533427, 11189669, 9534925, 10059025, 10452235, 10255627, 10616077, 9354553, 10616161, 13335827, 10255681, 10960199, 10501441, 9747817, 10452631, 10960523, 9666259, 11484875, 11173589, 10485283, 9698935, 10714709, 9600901, 9617161, 10583821, 10502287, 9781423, 11272421, 9781471, 12370163, 11583701, 11174099, 11173925, 9764899, 9830443, 9797731, 9781357, 9846889, 11583935, 9781639, 10437091, 9732361, 9748795, 10961177, 10436959, 10633573, 9847105, 9732475, 10961237, 10863329, 11289323, 9798349, 10552021, 9765613, 10863323, 9749053, 9126439, 9765445, 10437241, 9798271, 9765487, 9749395, 9896887, 9765805, 9388993, 9749443, 9847783, 10847035, 10961687, 9995053, 11354903, 10961771, 11567981, 11273045, 10028179, 10044553, 10028203, 9782503, 10028257, 10962137, 10044475, 9782323, 9765967, 9749617, 10961993, 9569689, 11126207, 11126159, 10520035, 11126255, 9373129, 11126243, 11126063, 9782575, 10437961, 9750199, 10716821, 12240635, 12240617, 10536493, 9553411, 12404257, 10716701, 12240497, 13535219, 9766873, 10586101, 9766897, 13518755, 9078535, 9783067, 10520389, 9635701, 9078925, 10881199, 9504901, 10406101, 11323595, 11569367, 10406137, 9767143, 12240905, 10520605, 10504663, 12388625, 11668157, 11569835, 10046137, 9538237, 9767617, 11520761, 9784003, 9800209, 10439179, 9783817, 11569709, 9538105, 9800257, 10783345, 9358255, 10013647, 10046401, 10816297, 9554779, 10505035, 11291825, 9079981, 9768133, 10800373, 12373223, 10521715, 10079311, 9784447, 10505299, 9325957, 10784131, 10079707, 9588211, 11275739, 9768235, 9817753, 11112161, 10522135, 12373613, 9768949, 12373955, 9768721, 9834265, 11112203, 10571527, 11112299, 11292503, 9769111, 11292863, 9703555, 10506427, 9801865, 10539145, 9801895, 10801391, 10801349, 10801355, 11112671, 9801745, 9769003, 13127695, 11112545, 11112521, 13553705, 11604059, 9719911, 9752977, 9753079, 10310131, 9769249, 11112725, 10506571, 10588495, 9753301, 9753103, 12227161, 12162007, 9802555, 10474327, 9540793, 9573547, 9688273, 11605247, 10032361, 9770215, 9819157, 9704857, 11064719, 9541063, 10261987, 11425049, 9082177, 11064647, 11572913, 10262035, 9836437, 9820039, 11212697, 9951181, 10246141, 9623323, 9770815, 10557625, 9296023, 10901645, 10901651, 10901663, 10901741, 10901747, 11311319, 10066333, 9673117, 9099745, 9542143, 10508755, 11295185, 9820513, 9542329, 10509001, 9099817, 10508821, 9640495, 13523465, 11606621, 9100219, 9542647, 9100261, 9509689, 9820963, 9083731, 9772189, 9772207, 9346255, 9788635, 9542851, 11050235, 11050019, 9346069, 9083941, 9346123, 9788509, 11574371, 11050109, 9346159, 11295815, 12180905, 11378059, 11148695, 12180977, 9772531, 11328971, 12180947, 12180929, 9542929, 11361557, 12180845, 11148965, 12361379, 11296391, 11149031, 10510069, 12361433, 11148803, 9772621, 10035085, 9772963, 9789355, 11149103, 10510141, 11149085, 9772921, 10035361, 10035409, 9117943, 10035211, 9330745, 11149757, 11461019, 11329943, 11002343, 11149781, 11575667, 10510705, 10035571, 11460929, 9790099, 9085627, 9675475, 9675511, 11051731, 10035739, 9757201, 9822739, 12558881, 11575829, 9544255, 9544225, 9757267, 9773989, 11625457, 11297771, 10511353, 9806833, 12379079, 11281259, 9773893, 11150201, 10036045, 9773941, 10019683, 11543729, 10036369, 9774259, 10839179, 9807019, 10511611, 9774283, 10839263, 9364495, 9085993, 9774151, 12379247, 9774523, 9790885, 9790927, 11281907, 10610137, 10839335, 10003735, 9692455, 11314505, 9774745, 9348763, 10757785, 9529027, 9545467, 13543037, 10282537, 10036819, 10036861, 10249837, 9824149, 10250143, 10495897, 10987499, 10037185, 11544557, 9775087, 9775081, 10512175, 10987277, 9774931, 9103171, 10987379, 10512193, 12527801, 10528993, 9332983, 10774555, 9791575, 9857119, 9742429, 12364223, 9103783, 11331875, 11594021, 10938697, 11283119, 9808543, 10627753, 9513691, 9546301, 9333331, 9906799, 10546081, 10628011, 9022339, 10513285, 9759667, 9022411, 9382879, 9776071, 10759159, 9776077, 9382867, 9382891, 9087973, 9349903, 9333511, 9825055, 9349921, 9333589, 9546901, 11250851, 10513591, 10448125, 9776377, 10022119, 9759757, 9759793, 11250707, 9841711, 11332685, 13528535, 10268125, 11496947, 10513885, 9793003, 9104671, 9088279, 10038565, 11284157, 9006823, 11562719, 9334519, 11562515, 10415665, 11562509, 9842257, 11562563, 9105013, 10497955, 10252213, 10252207, 9809827, 10743701, 9072619, 10514371, 9777139, 10039273, 9072469, 9711475, 10563409, 10580149, 9334987, 11284715, 10531063, 10039531, 10481671, 10579981, 8974399, 9809965, 9334861, 10776653, 9334909, 10514521, 9777559, 11284925, 11088383, 9859531, 10777043, 11563463, 9761053, 10776875, 10776887, 9335059, 11235599, 11235611, 10776857, 11088251, 9368203, 11236007, 11088527, 9777907, 9335521, 9859615, 9744901, 10547725, 12366353, 10498645, 9777775, 11236235, 11236325, 10499071, 9352171, 9073807, 10384513, 10499203, 10515595, 10761361, 10499275, 10040377, 11301899, 10515565, 10515571, 9516109, 10499497, 9434521, 10778045, 10352125, 10499533, 12301763, 9532693, 9336067, 9778471, 10515835, 12367493, 11286167, 9778933, 11400899, 10040923, 10450525, 9811531, 10450531, 9074563, 10811269, 11564999, 9762799, 10598185, 10827577, 9778993, 9074539, 10925897, 9844885, 10533091, 10057921, 9795613, 9779215, 9730057, 11335709, 10500523, 11188667, 12450185, 10959257, 10959299, 11286995, 12302633, 12302639, 11565317, 10959209, 11319677, 11188595, 11319665, 9779581, 9107827, 11188889, 11320061, 9829117, 9796117, 12450347, 10631689, 10959425, 12450389, 10959443, 10501027, 12549029, 12450713, 10435489, 12450785, 10631995, 12450593, 10500865, 9796393, 9796747, 12451037, 9780469, 10632319, 9370729, 11566481, 11484545, 11632009, 10501627, 10632661, 10501387, 10043011, 11173559, 11484815, 9076399, 11026145, 10501879, 10501885, 11484869, 10960607, 11026133, 9764383, 10960391, 12860989, 9781189, 12418879, 11026211, 9846529, 9126043, 9126037, 10813579, 10813663, 11403289, 12533861, 11665517, 11174333, 11174351, 11174357, 9109777, 9109819, 9060703, 12403375, 10568443, 12403423, 13337207, 11174423, 9896899, 10568695, 9094123, 13026239, 9094129, 10486543, 9094273, 11617447, 9094333, 9848023, 10568947, 9094381, 9094393, 13518011, 10552363, 9847843, 9094213, 12404143, 10569061, 10601803, 9062017, 11372267, 10438393, 9127477, 9062005, 9078715, 10782613, 13338497, 10815455, 12240833, 9111325, 10438435, 10438477, 10717049, 9127765, 9078643, 10569979, 10717199, 12535823, 9127987, 10258519, 10783153, 10717625, 10717631, 13060481, 10717493, 10717445, 9111871, 10553629, 10963307, 10717565, 10717505, 10783411, 10570369, 9734911, 9751129, 9751159, 13028303, 9734917, 10570501, 11521199, 9079939, 9030823, 12586235, 9850099, 9358561, 9358585, 11619385, 10439689, 11521031, 9079885, 9112687, 13553101, 11668925, 10571233, 9850315, 10702283, 10259743, 10784035, 13339985, 12160369, 9113293, 9096811, 12553805, 9064333, 11374487, 12341225, 12341213, 9064231, 9342817, 12537677, 12341377, 12341503, 11620549, 9113629, 11653235, 9834589, 9850987, 9130393, 9851389, 12161311, 9031999, 9097915, 13341323, 12161749, 12407491, 10834477, 11604575, 9343987, 13341527, 10441567, 10752863, 9426109, 9114805, 11130049, 11670563, 9016411, 10523725, 10523737, 9131437, 9819643, 11670791, 10540549, 13506167, 12244555, 12326819, 12326795, 10754047, 13342649, 9115405, 10901269, 12409015, 13523087, 12556523, 9066745, 11213009, 10803211, 9115723, 10328143, 11212913, 10246543, 10295749, 9869623, 10557811, 10246507, 9132673, 11655917, 13343393, 10803763, 9853501, 11360891, 10902083, 12622789, 10558447, 11361083, 9132823, 9116461, 10803979, 13327223, 9542497, 10787665, 11623243, 11656379, 9854089, 9854131, 9116875, 10788085, 12541151, 10755277, 11377885, 9772117, 11377771, 9116797, 11050403, 9346459, 13344215, 9018787, 9068023, 9116935, 9854263, 11377939, 11050367, 9346405, 10755715, 11378311, 11378401, 10755781, 9084643, 9117199, 11378191, 10575469, 12427175, 10805131, 10559389, 10575847, 10756033, 11378641, 9084703, 8986399, 10755847, 12427109, 10559323, 10510507, 10756243, 11378941, 11657411, 9117703, 10330543, 9118177, 10559749, 12427523, 11379049, 11362625, 9118339, 10576531, 10756855, 11624971, 11461199, 13509173, 9364369, 10544101, 10544107, 10544119, 12297187, 11150327, 12510161, 9118717, 13329221, 12542741, 9741091, 10576735, 9544873, 9118897, 10544131, 13706243, 12510287, 11150417, 10839479, 9102757, 9102775, 9102787, 11380177, 11380087, 13985033, 9102715, 11380063, 12396179, 9348811, 9610969, 12576335, 11315125, 10250113, 11626675, 9119881, 11659427, 12544157, 9709747, 9709735, 10561789, 9119959, 10561735, 12544205, 9840661, 10561561, 10987589, 10987601, 9054649, 11545073, 11545043, 10561993, 9103843, 9988597, 9742645, 12396803, 11659631, 9857395, 11544923, 12561131, 10758853, 10873555, 11545109, 9103921, 11365301, 12463097, 12463049, 11365547, 12397745, 9088159, 9088177, 10562815, 10792129, 9088249, 9121021, 11627551, 12463115, 9088099, 10562653, 9121171, 10759555, 13102583, 9547249, 12545315, 9088315, 9088327, 10562941, 12512939, 9055999, 13725251, 9105301, 12529565, 9105319, 9105331, 12546041, 10907629, 11382745, 9105205, 9121609, 10760017, 9105271, 12218527, 10252543, 9072727, 11251781, 12530171, 10498537, 10564063, 10301743, 12218725, 10563925, 9745045, 9106063, 12546791, 9122515, 10744355, 9040399, 11629063, 9122353, 11661941, 12940247, 10564531, 9008023, 10777589, 10056697, 11318023, 11629321, 10810231, 12530537, 11088731, 11088725, 10777601, 10056769, 9090439, 10253749, 9090469, 11236763, 9090553, 9352459, 11662649, 9844027, 10040617, 9024823, 9073999, 10778257, 9090751, 9844429, 11630119, 11236919, 11236967, 9844297, 11236937, 12547985, 10926077, 10565581, 9058297, 10565413, 12400415, 9123709, 11368283, 9697291, 10565701, 11663801, 9124225, 10566043, 9124273, 11401519, 10795297, 9124129, 11630857, 9124171, 13531439, 10565959, 9107821, 10844761, 13532033, 9108457, 10550059, 9108229, 10861375, 11188997, 9108301, 13040423, 9370753, 10878089, 12451025, 11631667, 10566685, 12205121, 13336049, 12451109, 9108829, 12451139, 9076363, 9354895, 9109129, 10780303, 10583785, 11632147, 11402857, 10813027, 12222037, 13041605, 11026361, 11026373, 11665163, 9797443, 12517547, 11665637, 11485217, 11403313, 12550655, 11174369, 12157285, 12550805, 13517561, 12223039, 13042199, 12518321, 12403603, 13517729, 12534647, 11125627, 10863473, 13337363, 13337777, 12551363, 10765429, 10782091, 11126435, 12535451, 11126429, 11126417, 13026983, 12551681, 11667365, 10962725, 10766143, 10717025, 10782577, 12240731, 12535973, 12535949, 11667875, 10963403, 12241211, 12241205, 11667791, 12848035, 12159955, 11373533, 10816339, 11521193, 11373599, 13536377, 11668595, 11619451, 10783849, 11668793, 11374235, 10751735, 11620075, 11374169, 12537683, 11669669, 11620561, 11374637, 13340771, 10932253, 10752113, 11358281, 12341713, 13046123, 11112731, 12161389, 12226927, 11374919, 13685453, 10785439, 13587071, 11620975, 11375177, 10801751, 12342199, 12243745, 12342049, 13341455, 11375453, 13341875, 10802221, 13554815, 12539003, 11425211, 11408713, 10982947, 11212787, 11376419, 11212847, 13342817, 11212817, 11212823, 12523943, 13523429, 13359407, 13343447, 11623063, 12524273, 10902065, 13163089, 10902077, 12540905, 11623189, 12164287, 10755283, 11672867, 12180827, 12656321, 11378383, 10903243, 12541499, 11362205, 12427151, 11624197, 11378449, 10755865, 10756273, 11378737, 11673707, 13525451, 12722519, 10756357, 10756771, 10756645, 11002415, 10789417, 12542549, 13607759, 10822405, 12166327, 13329599, 11379757, 10855435, 11380117, 10741151, 10806739, 10757773, 13985297, 12543587, 10757701, 11380645, 12691403, 12576761, 13526801, 13527257, 10987577, 11004337, 11381245, 11676137, 12544301, 13035815, 11545103, 11545181, 11381341, 12544925, 12692393, 13511873, 11660459, 12430561, 10939607, 12463163, 13528133, 12463157, 12463133, 12463205, 12463199, 12463187, 11660609, 13020827, 13512299, 10694239, 11317237, 11661119, 13037333, 11366267, 11628697, 10744031, 12398651, 10826029, 12218647, 12218749, 10760557, 12399251, 12235507, 12546761, 10695391, 11662139, 10744625, 10793791, 11088751, 12416251, 10777703, 10777673, 10778107, 13514069, 11580755, 12482283, 11236877, 11236889, 11236991, 11236979, 11236931, 13514735, 12547997, 11581211, 10778455, 13531355, 12548129, 12564587, 13514801, 12515669, 10762933, 11188913, 11188937, 11188955, 10811941, 12532343, 12220999, 10877897, 11369273, 10780153, 10763563, 12549383, 11402605, 10780381, 10780213, 10780183, 12549707, 10780243, 11026367, 11026409, 11026403, 12550121, 10485925, 10043563, 13533431, 10551451, 10469539, 11534579, 10486009, 12353759, 8994817, 11337761, 11173997, 10420345, 10600537, 11272637, 10715627, 9978307, 12353831, 9650497, 10502467, 10568353, 9093775, 9306811, 9306805, 11633401, 9028315, 9028123, 10863167, 11567645, 9781837, 10863173, 10847155, 9585589, 9782233, 11305979, 11273015, 9110329, 11256659, 10765477, 10716341, 12403867, 8995933, 11437151, 12240317, 12240311, 12240299, 12240281, 12240371, 9012709, 12486095, 11126141, 11519345, 10487167, 9733489, 9062029, 9717409, 11257493, 9127645, 9078493, 9831955, 11126303, 10569313, 9061999, 10471327, 12273563, 9783295, 11519789, 9815833, 10258267, 9946969, 11257679, 11634523, 10258291, 10406035, 9504907, 9324727, 10438867, 9767155, 11258051, 9767167, 10471651, 10471471, 9766987, 9750961, 11258267, 10488319, 13338953, 9767173, 12241175, 9046309, 12224857, 9046387, 12339881, 10504837, 11520749, 10471987, 9767467, 11422637, 10439575, 11258813, 10390447, 9030577, 10390477, 9751501, 12536603, 9358123, 9358171, 12356741, 9800917, 9030685, 10259581, 8998315, 9588163, 9063715, 9391417, 12225919, 10358143, 9768301, 10358113, 9604789, 10522249, 10030795, 9768649, 12341177, 9752449, 11390897, 10489735, 9080755, 10243849, 9572185, 10424137, 10030975, 9572197, 9703279, 11243687, 10342543, 9736363, 9703621, 9638095, 9703429, 9539671, 10801223, 11259989, 12423563, 9982429, 9621991, 11292959, 10473823, 9539959, 10473835, 11391319, 9491095, 10490539, 9491101, 9048709, 11260595, 10474153, 12227323, 10490605, 10769149, 9786103, 12554969, 10031857, 9753151, 9802357, 12374603, 10376137, 9016273, 9097993, 9065233, 9851713, 11424941, 9819307, 11424965, 9327871, 9770209, 10556455, 11572271, 9016375, 11555957, 10261903, 10261897, 9328093, 11621845, 9688381, 13047065, 9770341, 9328321, 9737977, 10524175, 10540657, 10573729, 10475419, 10246027, 9770965, 9803719, 10721279, 10606537, 10573783, 9541609, 10491697, 11212559, 10491673, 11065111, 9770845, 12326765, 10901363, 11278151, 9771223, 10524901, 8968399, 12343519, 10787017, 10328113, 10573843, 9607243, 10901579, 9541729, 9771415, 9820609, 10394053, 10901969, 10524979, 9738577, 9673033, 9034111, 9362053, 9362089, 9329365, 9280237, 9362149, 11246279, 11147975, 9542197, 10492513, 9542233, 9280093, 9280087, 11049857, 10509199, 9329599, 10492819, 11049941, 9001975, 10459933, 9050941, 11049833, 10558327, 9821005, 11049803, 11541341, 12426431, 9739417, 10493107, 11246783, 9755779, 12180641, 9100459, 9378997, 9051313, 11541755, 11263019, 10034203, 9100297, 12426293, 11050043, 11541551, 11246711, 9772153, 11541947, 9723295, 9051541, 11591057, 9133477, 9575869, 12426635, 11574767, 9330145, 11574581, 9018625, 12180779, 9346345, 9018685, 9379165, 10558843, 12180821, 11541827, 10444447, 12230203, 11279909, 11148863, 9330235, 9051715, 9084505, 10034809, 11558837, 9052063, 10084225, 10723223, 11460497, 10788847, 11280377, 9772807, 11542337, 9625729, 11264189, 11149463, 9330937, 11460647, 11247647, 9625687, 11460707, 9740389, 9085321, 9494941, 10510729, 12526061, 10494457, 9757165, 11624767, 11559215, 10494211, 11460959, 9757033, 12362429, 9773755, 9773743, 9659131, 12509821, 9101929, 9773689, 11035207, 10723925, 11559497, 10494553, 11150249, 9364363, 9708457, 9036577, 10839209, 10036363, 9774217, 12215447, 10839185, 10429663, 9004249, 11265221, 11658437, 9692389, 11281415, 9315379, 10839161, 10839119, 10265713, 11249081, 9348553, 9348397, 9823561, 10249753, 9725479, 10987133, 10528345, 10987433, 9054103, 10495981, 10250179, 10348537, 9103351, 11249621, 10987325, 12298003, 10561381, 10741595, 9775255, 9545905, 9758905, 9775279, 9857047, 11298917, 9332845, 9709693, 11282513, 9988513, 10463701, 9333211, 9726439, 10316125, 10627435, 10496371, 9972091, 9513715, 9022177, 9022207, 9775843, 10480141, 10627639, 10627687, 9120373, 9382831, 9382825, 12217237, 9333691, 9776041, 9350065, 10021837, 12348377, 9530341, 12348209, 9022237, 9333565, 10513171, 11250455, 9022273, 11561825, 9022309, 12397379, 11234435, 9333925, 10513441, 9333787, 9776143, 11267081, 9333805, 9743401, 10939493, 11234405, 9841729, 10447969, 10595767, 9366967, 10628593, 12365285, 10628371, 9776431, 11234657, 10038601, 12348779, 9006445, 10497349, 11283785, 10776233, 10579669, 10366525, 9727573, 10038895, 9334675, 11579291, 10481587, 11235311, 9105373, 13021097, 10628899, 9776899, 10612543, 10776323, 10776341, 9334585, 10776431, 11235173, 10514245, 11284289, 9334651, 9711469, 9727855, 11088047, 11088059, 10498195, 10252495, 9728017, 10776599, 9613345, 10252327, 11087969, 10695043, 13644263, 13742573, 9777619, 11088353, 11088377, 9662953, 9335053, 11088185, 11088179, 11235605, 9777481, 9318757, 9335167, 11252057, 9875809, 12219019, 9368263, 11252423, 9335539, 11301437, 11317813, 11547137, 10040221, 9073549, 10630075, 9106339, 9728773, 9007969, 9352039, 11252573, 11400383, 9024667, 9532603, 11400431, 11400419, 11400443, 9352423, 10253551, 9811039, 9335905, 10958315, 10958321, 8992213, 9057751, 11253215, 11400485, 11400479, 9057631, 10925819, 10925765, 10630873, 10958555, 9778921, 8992267, 8992279, 11581049, 8992363, 10024567, 9598567, 12285511, 11270021, 11466641, 9795583, 12449663, 12449633, 12351305, 12302519, 9713797, 10729601, 10582165, 11319527, 9713857, 12302573, 9615589, 9107467, 10958903, 12449831, 9812059, 9795991, 9763285, 12220927, 11319797, 10402285, 11565371, 9632053, 10484053, 12204371, 12450131, 12450443, 10402471, 9779959, 11270693, 11270663, 12368399, 9091663, 12352085, 10566529, 12385157, 11172857, 9780169, 11320307, 9010159, 10959653, 10500907, 9780019, 9747277, 9665353, 11549507, 9780079, 10517731, 11255027, 11271365, 10632397, 11566277, 9714709, 9010237, 9010225, 9780307, 9354349, 9780337, 11549783, 9092215, 9747859, 12369323, 11025845, 9338275, 11255243, 9764347, 11025881, 11484629, 12352829, 11271497, 9059845, 11304461, 10255927, 9059899, 11484791, 11271749, 10583647, 9076615, 9600931, 9093073, 11173679, 13533377, 10469593, 11567303, 11518073, 10600531, 9781687, 10551751, 13533515, 11551103, 12353891, 10010995, 9028237, 9306799, 9519829, 10453711, 9519859, 11518685, 9028351, 9814765, 11518505, 10388095, 10011259, 9912937, 9782167, 10486693, 9798529, 12272639, 11437043, 9536257, 10453771, 9356083, 9077605, 9372895, 10470607, 10388527, 9749569, 10011727, 9618835, 9717145, 11552171, 9569779, 12240347, 9684475, 11552219, 12240161, 9700645, 12240203, 9684325, 9700717, 10258135, 10258165, 10487335, 10503727, 9111067, 11519555, 9111481, 9701287, 9783211, 9963487, 10258225, 10585933, 9717607, 11503801, 10586161, 11208803, 10258537, 9718171, 9882031, 11569601, 12421435, 9603361, 10012963, 9849169, 9702037, 9357979, 9669289, 9358051, 10439197, 9374239, 9341461, 10537489, 11209235, 9357895, 9701965, 10439233, 9865801, 9292393, 12372875, 9112537, 9063385, 11242445, 10800073, 9915367, 9358093, 9685765, 9325375, 12848321, 10488841, 13110287, 9702805, 9112975, 9719179, 10505707, 12406255, 10603993, 11111891, 9751813, 10505527, 11259209, 10505563, 11210069, 10243741, 9080467, 9768613, 10243759, 11537975, 11538041, 9768517, 10243705, 10801037, 9703339, 10801127, 11538401, 10719227, 11128777, 9539341, 10243879, 10801007, 9539401, 9326731, 9031879, 9539779, 9375997, 10457137, 10801181, 9326659, 10015123, 9540031, 9720235, 10457407, 9326893, 9720097, 9965893, 10457743, 10556119, 10048027, 9785863, 9687559, 11523047, 10621897, 10457947, 9376597, 12424009, 11424935, 11539601, 12620939, 13341857, 10294519, 9016321, 9360415, 11523083, 10523659, 9360469, 10261927, 10048975, 11228609, 10901183, 9541291, 11540213, 10901195, 10524193, 11146799, 10901015, 10016371, 11376221, 10573735, 10524583, 9541555, 10016677, 10606495, 9131971, 11212769, 9541597, 10901447, 9541627, 11147219, 10409737, 10245931, 9541447, 10901315, 9099121, 8968375, 11540681, 9705499, 10573885, 12343321, 10573831, 9541675, 12294145, 11524199, 10016845, 9738643, 10000777, 9738685, 9066973, 10508743, 9279985, 9722119, 12359969, 10049905, 10475875, 9788035, 10066609, 9329335, 11049677, 11049683, 12425765, 9280063, 9837097, 12425843, 9280393, 12180395, 10050445, 12180365, 9345997, 10443775, 11393821, 9345919, 11049815, 9739411, 11345081, 12180635, 9379003, 12180611, 9329857, 11050229, 9329917, 10575061, 11279417, 12180527, 12180491, 10624105, 12426329, 9329767, 12426317, 11050079, 12180551, 10984867, 9706885, 10476967, 11460077, 10493389, 9346315, 9706789, 9805471, 10723007, 11460347, 12230173, 10444339, 9707065, 9461281, 9346609, 11460215, 11460209, 12688937, 11460191, 11460185, 10411945, 9773011, 9773023, 10477543, 11460395, 12279587, 11460401, 9707347, 11460419, 11526311, 10428589, 12738707, 10428619, 12574949, 11247833, 11149529, 9855007, 9740317, 10625125, 10526839, 9609619, 11526641, 10625329, 9740551, 9789739, 9609559, 9609541, 9724573, 9364123, 10724027, 9364189, 10625749, 9675301, 11313773, 9675331, 12214883, 11150267, 9724855, 11297681, 10839029, 10838999, 10445575, 10396477, 10462003, 10396495, 10429309, 12215135, 10625875, 10626187, 9692335, 10495135, 10560715, 9348349, 9348337, 10839083, 10626109, 10610083, 10249657, 10249633, 12264917, 10446313, 10610143, 11527463, 9708907, 9446767, 10626397, 11314853, 9725569, 11527859, 10626691, 10036915, 11396833, 11396801, 12347075, 13919869, 10987019, 11527775, 11200427, 11200445, 9775027, 9873403, 10348531, 10069765, 12347213, 10479853, 9709597, 9873409, 9316369, 9758755, 11233721, 9546061, 10627399, 10316137, 10037791, 9103873, 11545127, 11315767, 11201129, 9710161, 9906781, 9726553, 9546349, 9759673, 10939283, 11217821, 9382837, 9087925, 10939367, 10939391, 10627885, 10382095, 9759583, 9349981, 12430187, 10627957, 10578769, 9775981, 10431619, 10480831, 9366715, 9366781, 11496509, 11217935, 9677881, 9432097, 12332045, 12528767, 10775669, 10005571, 10939463, 9809305, 9547171, 10775963, 12398039, 12332345, 10775849, 9366805, 10513771, 10775879, 9366883, 10055323, 9842323, 9055879, 12349079, 9760441, 10038949, 9055981, 10776281, 9334513, 11529749, 10481269, 12234325, 9957253, 10760095, 9694999, 10432273, 10612531, 10776377, 9334621, 11317411, 10252477, 10956941, 11088101, 10465477, 11251907, 10399987, 10072111, 10514533, 10252363, 11530655, 10006987, 9859345, 10957061, 10006861, 9777475, 11088197, 9728365, 10318483, 11629207, 10482355, 10465969, 10957463, 9695953, 10957547, 12333761, 12350003, 9040405, 9089611, 9728593, 11219555, 12218989, 10039921, 9728905, 9745351, 10564555, 10515205, 9794377, 9335677, 11400017, 9532573, 11252921, 9532555, 10253491, 9024691, 10253479, 9352393, 10253563, 11220167, 9057295, 9532429, 9696319, 10482721, 10384477, 11187269, 10384489, 12448835, 10712501, 10548667, 11531675, 10040773, 9844213, 10925519, 9451003, 10925513, 9696751, 11187671, 10958297, 12449087, 10450183, 12301595, 11187581, 10565281, 12302009, 11400881, 10466977, 9778885, 11400905, 9713401, 11220521, 11236925, 10696207, 9320005, 10925675, 11302523, 10450501, 9860725, 10925645, 12449357, 10925651, 10581937, 9795469, 9336727, 12433297, 11532179, 10925977, 12302321, 9730045, 11220935, 11237177, 12449573, 10958615, 11253611, 12302195, 10516291, 11319485, 9631915, 11319533, 9615559, 10467355, 10582063, 12744791, 9779251, 9975841, 9631867, 11319389, 10582099, 10467427, 12368303, 11385271, 12450209, 10631665, 12450269, 12351959, 9484795, 10451437, 11221307, 10008889, 11631295, 10402477, 11532953, 10025635, 11172599, 10402549, 10025491, 10009099, 11172461, 9714271, 10566271, 9697909, 9697915, 10402423, 10877879, 10877873, 9665443, 10484677, 9354235, 9698101, 10713887, 9714475, 12532607, 10500961, 11320169, 12450677, 10009411, 9092239, 13548773, 11533565, 11025611, 9698557, 10959935, 10058815, 9681955, 10370095, 9681997, 9354361, 11025803, 9780649, 9534895, 11025899, 11517419, 11222495, 9698797, 11025719, 11025665, 11025671, 11222381, 10075489, 10583779, 9617143, 10583557, 9961063, 8994697, 11337659, 11517929, 10485715, 9797407, 10485517, 10354525, 10403665, 11222867, 11518151, 10551505, 13336757, 11223167, 10436707, 9978241, 10863077, 9699799, 11583989, 9093589, 11534813, 12239317, 9634435, 9798385, 10863155, 9699955, 10388077, 10551901, 11437037, 11551613, 9782083, 10715987, 11420845, 9372877, 12240083, 11551943, 11437103, 12338213, 9372745, 9716863, 9372769, 10421635, 12240263, 9684397, 9700807, 9094423, 12240155, 10601797, 10487431, 13518587, 10618525, 10045141, 10618561, 11126333, 9700909, 12240389, 11519567, 9095041, 9815989, 10471339, 10241953, 9324499, 10258195, 12371759, 9946939, 11519747, 9946951, 10585927, 9816211, 9717937, 9717931, 9324547, 10438717, 9619519, 9619537, 9046105, 10405993, 9750943, 9111967, 10078681, 10488313, 10439155, 10078495, 11536679, 10488181, 10504513, 12339533, 9357985, 11537111, 9669349, 9783871, 10455601, 9374281, 10029667, 11570165, 13536101, 10947755, 10013881, 11406571, 9702631, 10439719, 9522259, 11209829, 10456141, 8998309, 9538987, 11226617, 11111927, 13585751, 11209991, 9768277, 14044439, 9325927, 10243819, 10489363, 9784909, 11538029, 9326197, 10014595, 11259785, 10244023, 11112227, 11538293, 10800995, 10800989, 9801577, 10391713, 11112677, 10014919, 10506445, 11112449, 9539677, 10506367, 11227529, 9769393, 11211239, 9736651, 10408429, 12161287, 11211107, 10490533, 10441393, 9048577, 10031719, 11424689, 11522963, 10752995, 9130981, 9753583, 9327385, 11539205, 11211617, 10457983, 10474351, 9442495, 9573541, 9557161, 11424803, 10884151, 9802753, 11424827, 11424779, 9376831, 10622053, 12358727, 12326297, 9082273, 12178837, 10900973, 10458601, 9360697, 12359039, 9327943, 10261843, 10474867, 13342003, 10786531, 9819889, 10458673, 10901069, 10246075, 12326807, 9607117, 9541393, 10901285, 9590551, 10245907, 12343087, 10245895, 9000739, 10574005, 9754825, 11229401, 9607201, 10328107, 11540495, 10524703, 9099343, 9541747, 10459255, 10394023, 10459615, 9673159, 9804055, 11311385, 11049641, 12556985, 9280147, 10017445, 11049701, 10017529, 9280021, 10754617, 10017337, 11311733, 9362029, 9378403, 12180401, 12426131, 12180473, 12426209, 9345859, 9280351, 9788281, 9362275, 9378973, 12426407, 9690325, 9133267, 10476781, 10034185, 11525171, 10034233, 9067579, 11230307, 9755725, 10444177, 11214233, 9592237, 9772507, 9575875, 9575929, 9559549, 12180785, 10444051, 10378507, 10476853, 10575115, 11050349, 10444099, 11460269, 11460239, 9690793, 12263131, 11525825, 9100813, 10444303, 9559555, 9707059, 12181007, 11460221, 10444357, 10247785, 9641881, 11231177, 11460563, 9068533, 10477369, 10460965, 11460371, 11460473, 12607283, 11526305, 11460797, 11526281, 9773251, 11378695, 10510447, 9625705, 10428835, 10494367, 10035673, 10510651, 9609523, 11215127, 9101665, 9364111, 9708169, 9872011, 9659047, 9364147, 9708265, 10494499, 10461721, 9380353, 11526665, 10445407, 9822847, 9364093, 10429393, 9692155, 9724903, 10494781, 10789663, 9364291, 9806659, 9774247, 10429603, 10036435, 10364101, 10855621, 10839041, 10249663, 10249651, 10249639, 11527655, 12264935, 9070063, 11216333, 10528219, 9709033, 9348379, 10839347, 9102613, 10528009, 10626403, 11527841, 9610909, 9086611, 9610915, 12264995, 10331743, 9709123, 9463681, 10790683, 11216741, 9856843, 9856879, 10463365, 11299049, 10463431, 10037263, 13035533, 11626579, 10463347, 9545827, 9758827, 9628051, 9628069, 11315503, 10414339, 9627997, 9333097, 9726319, 11070139, 9841375, 9693925, 12348023, 9333637, 9530329, 9120709, 9530335, 11217911, 11496413, 13527995, 10464127, 9694075, 10464097, 9563317, 10939529, 9694459, 12463121, 11529245, 10939421, 10431577, 10447951, 9546853, 13823453, 10628533, 10464703, 10775951, 10431949, 9792961, 10579453, 9727471, 8990017, 10432129, 12332789, 10432255, 11595461, 11562701, 10776065, 9006631, 10366513, 9006649, 11333225, 11513423, 9629569, 10776539, 10432279, 10252039, 10481527, 10793185, 10023121, 10006729, 10399981, 9793543, 9695233, 12333095, 10465369, 10580035, 11383291, 10400029, 9089281, 10301749, 10629385, 9318745, 9499159, 11383321, 10465885, 12317311, 9122395, 11219525, 9368185, 11383723, 11400119, 11400173, 10482631, 11269067, 10957763, 10711811, 11350799, 11400047, 11400041, 11400035, 10629997, 11400053, 11236523, 11531453, 12449009, 9696463, 10433791, 11400407, 11400239, 11400233, 10433599, 11400317, 13530143, 11400263, 11400257, 10384483, 10565041, 9582025, 9450985, 10532143, 11400461, 9712939, 10712399, 10450291, 10253683, 11220311, 10925735, 10057387, 11187767, 10925633, 9844351, 10958423, 10549165, 12302225, 10467235, 10712879, 9713461, 10778395, 12302183, 9729865, 9074551, 11319467, 12302507, 10467463, 12302483, 9337009, 9697309, 10565683, 10582039, 11319407, 11319395, 10958963, 12449873, 9615457, 9336955, 10467433, 10582105, 9337237, 10467769, 9124297, 9992689, 9337093, 10008901, 10385731, 10025317, 9697945, 10762801, 10451569, 11238305, 10877867, 9730945, 9698239, 11516801, 11533289, 9370603, 9698275, 10517683, 11173049, 9354445, 11025635, 11025605, 9354493, 10484965, 10484761, 12450869, 9354301, 10714133, 9354319, 9354325, 9764251, 10255753, 10501561, 10255795, 11484575, 11222417, 10501603, 10468825, 11222315, 9354511, 10288405, 11222765, 11517695, 10550833, 11025935, 9698911, 10468987, 11517509, 9715609, 11026313, 11485151, 11517737, 10354495, 9699127, 12336899, 11222897, 9699193, 11174069, 10600483, 10600489, 12353579, 9470041, 9470017, 9634237, 10862999, 10863047, 10863053, 9666835, 10469695, 11518331, 9978211, 9732457, 10863281, 9781891, 11518601, 9355945, 9536185, 9536167, 12829313, 10617577, 9536221, 9994987, 9683569, 10437217, 9077365, 9323437, 10961801, 9536479, 12272621, 11518913, 9700117, 10863383, 10568479, 9126739, 9684097, 9077905, 9684181, 9684163, 9372901, 12239915, 12239891, 9684031, 12354677, 10699855, 11208125, 9553375, 12240335, 10437895, 12240239, 9750193, 10831597, 11208395, 10585801, 13682365, 12240581, 9012811, 10618489, 11208275, 10995703, 10815275, 10585867, 11208455, 13518623, 9684805, 10487623, 12241073, 11208893, 9849079, 10586131, 10389583, 10405957, 10831939, 12356011, 11028883, 9669103, 9063049, 10078885, 9325273, 11537129, 9358063, 9325285, 9325087, 9669121, 12601943, 11536943, 9374251, 11209241, 10537573, 11209331, 9374323, 9735121, 9112399, 10390363, 10079071, 9554755, 9554761, 10505347, 10456237, 9686245, 10013713, 10259515, 10898443, 9096307, 10423699, 10489273, 9588145, 9588133, 10538491, 11537873, 11292101, 9391411, 9932113, 10358089, 11406709, 11112103, 10276531, 9604771, 9457387, 10505785, 10243639, 12783497, 9867127, 9768811, 9326449, 11210933, 9719947, 10555525, 9687271, 9326605, 10801187, 11210771, 9982363, 9081259, 12325277, 9621937, 9081127, 9736573, 11243861, 9327325, 9687793, 9982495, 12538405, 10441273, 9671245, 9687655, 10474087, 11539385, 9360313, 12342235, 12325841, 9376543, 9737011, 9376561, 9786229, 11064467, 11228411, 10458367, 10015969, 10933309, 9360403, 11424785, 11523179, 9344125, 11424851, 13030793, 10900943, 10261777, 9786667, 9541249, 12408481, 10409683, 10573555, 11228927, 10573561, 10573531, 9131767, 12342979, 9590509, 10901039, 9541213, 11621965, 9688969, 10901465, 10573579, 9049951, 10901333, 9656503, 10475707, 9672895, 10016779, 10901567, 10557469, 11393095, 9722269, 12425615, 9312727, 9312763, 10459453, 9722167, 10574101, 12425585, 10459471, 10934983, 10623697, 9280015, 9312781, 9312775, 10558003, 9361963, 11049587, 10001017, 9722473, 10443673, 10492843, 9395113, 10443703, 9771961, 12426197, 9689881, 12426023, 11049851, 10575013, 11214011, 10427527, 9378991, 10574983, 10575001, 9706543, 12229753, 12180605, 11050085, 10493017, 9592207, 9575857, 13524383, 9067987, 11460047, 10575157, 9526579, 12475667, 9526573, 9772375, 10427749, 9084601, 11542157, 10428145, 10624717, 9969547, 10739639, 10411999, 10428415, 10477567, 10067959, 10428169, 11460383, 10411843, 12345175, 10411879, 9101455, 10068145, 11231483, 9806071, 12574931, 10428643, 12345403, 10313749, 11001917, 9625633, 11001953, 10428493, 9691207, 10428487, 11001935, 9691237, 9494929, 9773521, 10379737, 12214553, 12329339, 9707845, 10461547, 9364099, 9364159, 13525751, 9708235, 11199179, 10625569, 9019927, 9740851, 8970805, 11215787, 9692041, 10838969, 10838915, 9036793, 10839005, 10478347, 9560881, 10396453, 10838909, 9691981, 9004195, 12330221, 9790657, 9004261, 12411961, 10839101, 9053305, 10839131, 9938323, 9348487, 10249621, 12264881, 9790873, 10986923, 9938329, 10429825, 10446307, 11232527, 10986821, 9807493, 10528441, 9070279, 10446535, 9594613, 12363323, 10446391, 13329929, 9856945, 10479595, 9856819, 10987289, 10463065, 9693013, 10037425, 11217143, 10463425, 9693427, 11429905, 11200637, 12347489, 9087373, 10004917, 9988567, 10463683, 9677299, 11200817, 9742639, 9710227, 12348047, 10562293, 10529527, 9677551, 9087493, 10480183, 9677347, 9677353, 11266583, 9349717, 10431097, 9677713, 10480513, 9776065, 11578331, 10545955, 10447651, 9710425, 9382777, 9694063, 10775717, 9366667, 9088141, 11365553, 9366673, 10939535, 9366691, 10955927, 12414185, 10775747, 9088051, 10955873, 10005577, 11201627, 10775987, 9792907, 10775957, 9776557, 10563025, 9366799, 10775867, 10775825, 10775921, 10956101, 10956113, 10775903, 10251931, 10759933, 10628821, 10579489, 10022413, 9121297, 9825847, 9547315, 10366519, 10956311, 10776185, 12234667, 10514311, 10973131, 9088777, 11022139, 11366201, 10497847, 10465081, 10612501, 9957247, 10907467, 10006375, 10530655, 11579549, 12333203, 9679021, 9711847, 10465303, 11202611, 11284505, 9728401, 9318811, 9793993, 9679309, 9646573, 10465567, 11202851, 9679153, 9351853, 11317915, 10515193, 12219109, 9859645, 9368149, 10007161, 9122407, 10531741, 12448745, 9532411, 9368335, 10433281, 9843559, 9712783, 10253497, 10957967, 10253515, 10466503, 11629783, 9516085, 11400209, 10466371, 10466425, 9073783, 9679981, 9582013, 12285313, 10057171, 12449261, 10925561, 10253593, 11400509, 9352477, 9696577, 10499419, 9696919, 12203689, 12302045, 10712645, 11204519, 10581949, 11188193, 11171795, 9074677, 9729817, 9844489, 9697087, 12449657, 11188079, 12449639, 10073965, 12302147, 10565761, 9762985, 12351533, 9975823, 10582021, 10008631, 11221013, 10483783, 10435003, 11532695, 9075151, 11286977, 9730363, 10484095, 10582363, 11319635, 11270819, 11172539, 12450467, 9747163, 9484801, 11205227, 10402405, 13335509, 9370537, 10501105, 9354211, 9370405, 10779505, 9370489, 11221847, 9010339, 9682093, 9534679, 12450857, 11025419, 10779751, 11205737, 9698389, 9354307, 12450887, 10583533, 10583497, 13516211, 9534745, 9092359, 10255705, 10255687, 10255741, 10485379, 12500643, 10550917, 9715219, 9682489, 9698899, 9682831, 9600949, 10420129, 12435439, 9060313, 10715129, 9732067, 11222993, 9584413, 11517725, 9584425, 10420051, 9600895, 9347227, 10248331, 9453757, 10821785, 9502975, 9420835, 12247049, 10469419, 10559593, 10248277, 9609283, 12345449, 10248259, 10846631, 9388477, 10584469, 10330531, 10879385, 9855481, 10510813, 10985729, 10314037, 9494845, 9494863, 9429373, 9855331, 10035841, 10330753, 13935347, 9421477, 9347767, 9380563, 9855739, 10355425, 10322455, 9601549, 9552421, 9437743, 9871963, 9380437, 9806455, 9814639, 9855889, 9495439, 10019755, 9429967, 9429961, 9487297, 9356287, 12272585, 9495523, 9888529, 9847555, 9855805, 9495391, 10511221, 9421693, 10503343, 10314973, 10298617, 10790081, 10323001, 12231683, 10036309, 9454663, 10511785, 12412337, 9430423, 9479563, 10618339, 10790363, 10028317, 12223805, 9495901, 11060575, 9438865, 10307209, 12265105, 9471679, 10512031, 10307305, 10257949, 11380261, 9430567, 12543605, 12404327, 10593877, 10790483, 9897877, 9422731, 10987445, 10315657, 9455545, 9455521, 9873325, 10823633, 11388731, 10897213, 12412697, 10307371, 9348967, 10798931, 9504913, 9963649, 10299523, 9447619, 10021069, 9980101, 11315393, 9422851, 10323979, 12249125, 9431149, 10291609, 9349567, 10299811, 10299865, 10840547, 11315681, 9644521, 10250527, 11315507, 10864901, 11315465, 10348855, 10291507, 10250533, 10578283, 9480565, 10857131, 10791557, 9857755, 10250953, 10382059, 10406629, 11315747, 13699649, 10349071, 9513511, 10045987, 10791455, 10250845, 10250833, 9464389, 12257879, 9857947, 9423745, 12250037, 10619785, 9472957, 9587689, 9497365, 10439431, 9587509, 10488595, 9841441, 10365775, 9440071, 9890683, 9431935, 9620635, 10783927, 9432235, 10046677, 10579183, 10759367, 11316425, 9415921, 9423901, 10791941, 9448483, 10308643, 11381867, 10251349, 11381873, 9473143, 10759241, 9842059, 10317247, 10276267, 9424327, 10022353, 10759679, 10546627, 11292125, 10358251, 9571633, 10792217, 9579859, 10374811, 10759853, 11382461, 9432733, 13340399, 10432177, 10301137, 9359083, 9637393, 9989653, 9899533, 9850429, 10759745, 10341985, 9637783, 10375045, 10768313, 10260415, 10325977, 10760177, 11382749, 10792919, 10760147, 10071823, 12406529, 10588009, 10760021, 9818245, 13553891, 10891517, 10301689, 10760387, 9580783, 10006531, 10309669, 10793087, 10056091, 10572175, 10293667, 10351057, 10572271, 10441207, 10793417, 10334485, 9498907, 11407643, 10293595, 9965911, 10826105, 10694987, 11407709, 9843055, 10293607, 10834595, 10826381, 10343095, 10818197, 10031845, 10760921, 10867241, 10293775, 10244611, 10875503, 10760825, 9802315, 10760783, 10302055, 12252089, 10359709, 10818479, 10245049, 9434041, 9483175, 10761119, 12227579, 10490857, 12227573, 10302403, 9507835, 10589143, 10253281, 10343197, 12235565, 10859327, 9483019, 11383559, 9409315, 10244959, 11408231, 9982807, 10892099, 9417589, 9458833, 10761365, 11236511, 9499843, 10351819, 9417955, 10523857, 9360631, 10761269, 9499663, 10761275, 10310701, 12227591, 12342275, 10302541, 13637075, 10696127, 9483703, 12227969, 9344461, 9557455, 9934315, 10327345, 12227963, 10310989, 9418069, 9409903, 10294651, 9483619, 11384147, 11450021, 12228263, 9352867, 9426625, 9819841, 10761935, 11007523, 10311229, 9442873, 10294873, 12228209, 10581571, 10393207, 9352801, 9975415, 9361297, 10819553, 11393021, 10852343, 10303477, 9435109, 10360801, 9361171, 12228377, 11024153, 9344827, 12408581, 10794857, 9361237, 9492301, 9828199, 9353083, 11393165, 13236377, 11393279, 10311919, 12228659, 12523559, 10532875, 10016809, 13023359, 10516579, 9492595, 12228673, 10623361, 10623367, 9452023, 9836827, 12228917, 10295557, 10508557, 11393405, 9525901, 12229265, 10820333, 10574569, 9484891, 9353815, 9460303, 9452149, 10353259, 9673621, 9436051, 10632175, 10025965, 9501463, 11393831, 9575239, 9427801, 9681733, 10361725, 9976699, 10304665, 10337431, 12262571, 9444481, 9550981, 9419929, 11599001, 9780439, 9346249, 10419253, 9493537, 10763345, 10632277, 10067047, 11378089, 9477511, 9362857, 10378717, 9420229, 9657817, 10485193, 12230111, 11410727, 12295477, 9420049, 12230015, 12229991, 9494161, 10313359, 10297045, 11394575, 10534519, 12246629, 9420415, 10337893, 9666451, 9568153, 11386801, 10821533, 9347053, 10493893, 9428989, 9445135, 9436987, 10567525, 12230507, 9355099, 10256203, 9346897, 9412753, 10256551, 9412807, 9437401, 10322149, 10928165, 10600501, 10559551, 10805321, 10559911, 10043833, 10248637, 10822031, 10592737, 9413119, 10346983, 11387345, 10789169, 9855235, 10821947, 9355567, 10789121, 9347371, 10559761, 9363775, 10510621, 9421105, 9855301, 10584439, 10486135, 10576219, 10346851, 10248877, 9962191, 9855733, 10560223, 9634309, 10789439, 9519661, 12403325, 10756673, 9855589, 10502743, 12403271, 9421711, 9429889, 12223379, 10757003, 9667543, 12223295, 9929521, 10789655, 11404159, 10838903, 9462631, 9462931, 12559535, 11404439, 10306765, 9438451, 9405673, 10511413, 9659443, 9684061, 10372165, 10249333, 10085491, 10577329, 9840001, 9487753, 12223901, 12223889, 9856429, 12412289, 11568629, 9430495, 9979381, 10044901, 10462489, 10806563, 10978601, 9782611, 9356617, 12404393, 12224153, 10454707, 11314939, 9619141, 9840331, 9774835, 9373411, 9405967, 10331701, 10405489, 10298977, 10430359, 12224417, 9414571, 9775015, 10758035, 10061731, 9865165, 9619441, 9406441, 10757921, 10807085, 11380493, 9807673, 9406267, 9553711, 9422659, 9414511, 10307443, 10757963, 11446109, 10250389, 10946717, 10578079, 10307803, 10758389, 9857269, 10791113, 10512421, 9463855, 10053697, 11315285, 9422965, 13109723, 10758587, 9496975, 12224921, 10283437, 9496993, 10758551, 11315611, 10357201, 10250749, 11315669, 10250599, 11389601, 9857677, 11315849, 12225275, 12249827, 9349843, 9497329, 11381309, 10791485, 9407023, 10349101, 10381927, 10808243, 12241799, 10759067, 13585289, 10628083, 9350107, 9407449, 12217313, 10431487, 10333177, 9956347, 9645025, 9858031, 10758941, 11381609, 9603907, 9407335, 10578781, 9571459, 9432217, 10570909, 9587887, 9407695, 9415693, 12225599, 10415131, 9833479, 10333237, 10374199, 10382371, 10308673, 9858163, 10309015, 11398577, 10350079, 9350641, 12217661, 9448729, 9358597, 10759445, 9571669, 9424195, 10308937, 11316599, 10308985, 10800461, 9497983, 10522303, 12218009, 10694279, 10333903, 10694345, 10604065, 12217865, 12308075, 9449065, 11407277, 9424849, 10432483, 10694441, 10760033, 10768235, 10309447, 9416851, 11382923, 10064053, 9490621, 12374153, 10760441, 9572581, 9990205, 12242957, 10309705, 10326091, 10826153, 9761167, 12243335, 9425365, 11383283, 9982459, 10244599, 10785227, 11383259, 9417073, 10523305, 10539691, 9769627, 12235433, 9425575, 10801811, 9507499, 12333773, 11014877, 10580701, 9900613, 12227489, 9409459, 10261471, 9909211, 9368413, 10695491, 10277737, 10351459, 10318993, 12342449, 10441903, 12342407, 9557017, 12227627, 9622531, 12227609, 9802801, 9557047, 10261591, 10302877, 11384207, 9467329, 10786289, 9581893, 9975109, 11384129, 9442687, 9344383, 9860761, 9590407, 11155097, 9852577, 10557157, 10311373, 9410257, 9352723, 9352741, 10761737, 9360955, 10794593, 10810991, 12408749, 13506551, 12244979, 9631705, 10336201, 10303249, 9426745, 12621593, 10303639, 12228785, 10811561, 9427123, 10377427, 9427183, 9640177, 9492727, 11442373, 12236819, 10803215, 9451615, 12228689, 9533551, 9410959, 10328479, 9361795, 9361849, 9394651, 10459639, 10058005, 10754321, 12228865, 9451843, 11385167, 10500781, 9779851, 12294809, 11000461, 9853663, 12221173, 9427675, 10287871, 12237527, 10058269, 9509413, 9452125, 10304077, 9550723, 11402119, 10320811, 10320841, 12532709, 9845755, 12245807, 10820363, 12262157, 11410193, 9960295, 10828637, 9772177, 12344543, 10370071, 9509917, 12237869, 11050037, 9469009, 9550957, 9412015, 9420217, 10288639, 10296817, 12787121, 9960943, 10788197, 9338191, 12304015, 9412297, 10305259, 10305049, 10583599, 10788359, 9453109, 9502279, 9354859, 12254791, 12345323, 10788647, 10510117, 9846559, 10297093, 12279577, 9879355, 9469741, 9428809, 10248001, 9855109, 11387057, 9953461, 9846973, 9437395, 9429217, 9773107, 9584761, 10346905, 10617331, 12444139, 9978175, 9421093, 11387165, 9847075, 10281295, 9412951, 9888073, 9666913, 11444927, 9437839, 9806527, 10789571, 11387495, 10576507, 13746749, 10298263, 10347445, 9413599, 12403655, 9855769, 11379515, 10806125, 12231505, 10781525, 11379881, 10757297, 12559529, 9479353, 12403853, 9446617, 9839815, 9684223, 9405685, 9635053, 9356353, 11379833, 12403799, 11380133, 9856441, 9405901, 11126219, 10601761, 9643315, 10757387, 10609939, 9553189, 9880879, 10364245, 9364801, 9856327, 10757495, 9823609, 12404051, 10003831, 10315423, 13592281, 10249897, 10438399, 9422563, 10807007, 9766435, 12559997, 10757735, 11388485, 10790477, 10618459, 9873301, 10471303, 9848761, 9553831, 9963469, 9857023, 9848827, 9439201, 9873391, 10307347, 9856783, 9348901, 10422055, 9414793, 9857167, 10430593, 10250371, 10250419, 9750739, 9996535, 10242061, 10799125, 11380757, 9472045, 10381345, 10578031, 10782791, 9824383, 10578001, 11315291, 10578013, 11405735, 10242481, 10504675, 10004941, 9857527, 9857521, 11389403, 10324279, 10004821, 10758821, 11381423, 9570967, 12266161, 10357423, 10758809, 10570495, 9497335, 10791647, 9857563, 11545121, 10512949, 9808435, 9792061, 9857593, 10766867, 10766975, 9857659, 10308199, 10513321, 9792415, 11398031, 9440167, 9407455, 9857803, 9423715, 9899143, 12217517, 10792181, 10382359, 11389991, 10251283, 9350167, 9858097, 10587241, 9416071, 9915805, 9850279, 9432529, 10268149, 10603987, 9719095, 12225811, 9522475, 10038619, 12266867, 10833269, 10579315, 13192469, 9416017, 10071421, 10038643, 12226211, 9809551, 9350821, 10260187, 9981649, 12226259, 9350881, 9629437, 12529213, 10694183, 10694195, 9358867, 9408043, 10300981, 12226067, 9416263, 10784363, 9989755, 10571335, 9416581, 9441163, 12226457, 12218255, 12218363, 10809335, 9490417, 9408493, 12234697, 12218171, 12242771, 9515155, 10768553, 12218531, 12251291, 9572539, 11579633, 10760417, 10416337, 10064113, 9416935, 10571989, 9408523, 12259379, 9588751, 9433123, 10760219, 12218489, 12300415, 10375255, 9359443, 12226991, 10293643, 12341675, 9408931, 9425335, 10785251, 11317735, 10785257, 11530535, 10244413, 9425227, 10834273, 9736513, 10293625, 12218711, 9802087, 9507457, 10531519, 13341413, 10293967, 10310341, 13128343, 10466041, 10760917, 10359307, 10244641, 12341867, 12243545, 12218975, 12341837, 10580563, 10245019, 12407711, 9434077, 9573319, 9777943, 10769207, 10539835, 9794365, 10310455, 10302301, 12227453, 10818413, 9458503, 10851155, 13907161, 10785979, 10302655, 10573027, 11383841, 11383859, 10335295, 9925681, 10818563, 9499741, 10900595, 10359913, 9352309, 9352591, 10778093, 9352645, 10352083, 9442813, 9983467, 10696043, 9426289, 9361045, 9975481, 9950899, 10516123, 12220127, 12228305, 9410275, 9991705, 10335775, 10778213, 9516943, 12228491, 11048939, 9951175, 9549817, 9361153, 10761995, 9377611, 12236669, 10245973, 10778495, 9599107, 13777145, 9574591, 10754291, 9525493, 11401415, 10377445, 9492487, 9631795, 12220445, 10352737, 10828199, 10574245, 10295707, 9460099, 10779023, 10779119, 10295569, 10516747, 10000681, 10778981, 9410911, 12245315, 12409531, 10279579, 10795697, 10787519, 9403081, 9444043, 10779335, 12245705, 13023929, 10836523, 10787443, 9443953, 9984613, 13507571, 12221231, 10459963, 9427783, 10779515, 10304371, 10509493, 10755251, 10755257, 11410571, 9477355, 9550867, 10361869, 10574959, 10828913, 10755197, 12385369, 9428065, 13164029, 11066771, 9436639, 10755539, 9436657, 10755383, 10779953, 9420055, 10272007, 10755335, 9346357, 11025683, 9575767, 10755455, 10616131, 10804565, 12238151, 10378903, 9428665, 9485995, 10755737, 9346759, 11615957, 10346005, 10755629, 9469447, 12221969, 10321459, 9363001, 9420343, 10763807, 10763873, 9379399, 12238427, 9387625, 9379429, 9346681, 9592705, 10756019, 10756025, 9641917, 10051579, 10067941, 10764065, 10592047, 12230423, 9437029, 9363607, 10944701, 9486511, 10928363, 10797101, 9347101, 11395085, 9347107, 11067419, 10903577, 10764389, 12263549, 12263525, 10879043, 10346911, 11387321, 9642409, 10248697, 10764755, 9453847, 10510633, 10297645, 9953569, 10338679, 10355053, 9560713, 12427931, 11387525, 9970345, 10797719, 9585313, 9585325, 9495247, 10306303, 10379815, 10904165, 9634375, 10338931, 9454207, 11223647, 9478765, 9593455, 9479071, 10765247, 11387777, 10994585, 10716143, 9356251, 9896911, 9847759, 9495547, 9577471, 9634591, 11387663, 9511735, 11387759, 10355545, 11387717, 10371937, 12231863, 9823369, 9462925, 9553075, 9348319, 9938173, 10363921, 10331137, 10331191, 9348145, 12231779, 12239951, 9471481, 9594349, 10036483, 9471265, 12551537, 10339681, 9578113, 10249915, 9963187, 10331821, 9684643, 11388647, 9946843, 9356803, 10364419, 11388437, 12281351, 9356875, 10356295, 9356905, 10798679, 10340233, 10332043, 12232601, 9578431, 9471919, 9455611, 9832429, 10315543, 11388683, 9504559, 12232565, 9455473, 9529207, 9455773, 9488515, 12413087, 10324147, 10324141, 10504405, 10332391, 10766375, 12232817, 9349207, 11520425, 9456031, 11389313, 12233213, 11389427, 9562597, 9464083, 9496855, 9849115, 10873139, 10389793, 10766693, 9963841, 9865549, 10242715, 10578619, 10341037, 12225163, 9472705, 9349855, 9456331, 9652981, 9431803, 10365673, 9554671, 10340875, 11430401, 10242595, 9734725, 9579079, 12233327, 11389553, 12233291, 10496929, 10423177, 10365883, 9579481, 9489403, 9423631, 11389733, 10251019, 11389751, 11389709, 10242877, 10365757, 9464611, 9464623, 10570597, 10881917, 10251073, 9489267, 10873685, 10480489, 11389781, 12217535, 12233891, 10882235, 9956539, 9587911, 11414771, 11390147, 9858079, 12233765, 12364811, 10775633, 9858145, 11390033, 10767797, 10333573, 10251709, 11398559, 10268065, 12406231, 9956839, 11316527, 10374469, 10071403, 12234377, 10620643, 9490141, 10342093, 10882763, 9490147, 9547327, 10776161, 9588631, 9867163, 9375667, 9613273, 9359329, 11390771, 10342207, 11431691, 12234617, 9457483, 9785203, 10375015, 10309783, 9498757, 11415731, 10301617, 10317997, 10301611, 10326217, 9982207, 9761017, 9474103, 10702931, 9359473, 10793405, 10326451, 9466315, 10424809, 9712111, 12218683, 10326283, 10342663, 10334497, 10023205, 12235013, 9859435, 9785707, 10334869, 10883759, 10244743, 9482971, 10375885, 10982131, 9507583, 9720337, 9482755, 10891837, 10334779, 10506769, 9572899, 10572307, 9515599, 9556585, 12235691, 9376669, 10007437, 10793915, 11391881, 9556921, 10793873, 9442213, 10572787, 10326979, 10335229, 10884041, 10580791, 10883903, 10244923, 12514049, 9450325, 10695551, 10793813, 12809021, 10794155, 10916993, 10335451, 10032337, 9466897, 9770029, 11392019, 10327111, 10614187, 10327447, 9557383, 9491947, 10343683, 10343797, 10360171, 10884779, 10319521, 10573543, 9344725, 10942157, 9524971, 9516565, 10327561, 10614385, 10057321, 9713263, 9951127, 10606519, 9344953, 9975553, 10344229, 12424967, 9647959, 9795445, 9525397, 10336399, 10467469, 9771169, 10516705, 10328263, 10926281, 9574633, 10909739, 10246147, 10917905, 9812047, 10328161, 10017169, 10328461, 9468295, 9345451, 10484149, 10836451, 10344919, 9460213, 12237251, 10352947, 10885403, 9476437, 10328437, 10574497, 10771073, 9468601, 10410667, 10795769, 9394915, 10803925, 9788137, 10074853, 12286505, 10328587, 10304005, 9386533, 9640537, 9460315, 10254919, 9599605, 10328677, 13122521, 10795955, 10369975, 10926995, 10435495, 12377087, 9444313, 9444289, 10271695, 10337221, 12549071, 10050313, 9468673, 11393813, 10836845, 9468745, 9526129, 9460927, 12238043, 10575043, 10501327, 10361875, 10796087, 9583627, 9444385, 10509331, 9518119, 9534583, 10886219, 9452953, 10870205, 10419679, 12262901, 10509811, 9649429, 10345747, 9461041, 9461077, 10837361, 10329409, 11107667, 9494155, 10362541, 9780907, 10378969, 9453271, 10362619, 10878659, 10444531, 10321633, 10599943, 9354835, 10870343, 11026355, 10338229, 10764185, 10518523, 10936259, 10919891, 9355255, 10878725, 10075951, 11231087, 11394923, 9551683, 10026859, 10764119, 9969505, 12263237, 10764421, 9511129, 9535735, 12263435, 10887185, 9502825, 10043491, 10338709, 10248577, 9470425, 9921007, 10338787, 9953557, 9347353, 9478435, 9584929, 10944797, 10248535, 9552199, 10248517, 9593167, 9470335, 9855667, 9855691, 9470467, 9749005, 9470473, 12263939, 9585193, 9855571, 10797695, 9470581, 10379893, 9486955, 10339225, 9593815, 10765265, 9470959, 9855751, 10339081, 9814837, 10339135, 9356095, 10887959, 9577309, 11158697, 9421993, 10814693, 9463009, 9831649, 10618075, 9470983, 10765337, 9725005, 9765961, 9495655, 12575813, 9561499, 9471391, 10339765, 9463207, 10503649, 9446899, 9627133, 9479443, 9790723, 10364221, 12420377, 10364251, 9348427, 12420461, 10511695, 11404639, 10503841, 10487539, 10364659, 10864183, 10438153, 9356821, 9725509, 9504325, 9856585, 10913675, 9471985, 9578479, 10970915, 9504577, 11421833, 9971911, 9472249, 10889279, 10340359, 11315227, 10577989, 10586185, 10414525, 12224993, 10766813, 13101389, 9865483, 9726295, 10488175, 10922345, 10930559, 10767011, 10578607, 10341055, 10578565, 10930847, 10767077, 10341079, 9349825, 9489139, 12233429, 10471951, 11422211, 9505381, 10341253, 10578841, 9366493, 12233699, 10578745, 9472813, 10341199, 12233573, 10767173, 12413777, 9653089, 10439527, 13348043, 10341553, 10341541, 10579099, 11013359, 9677845, 12233777, 9694267, 10341469, 12234173, 12234131, 10350037, 10579447, 10366435, 9366793, 9465103, 9440563, 10341691, 10546549, 12234083, 10063171, 11390321, 10333843, 10374799, 9465475, 10768103, 10358503, 10579507, 9555469, 10612225, 12234257, 10366507, 9473653, 10776131, 9530989, 9523099, 9572293, 9965509, 9506767, 9981949, 9465853, 11317187, 13168571, 10915793, 10563379, 11390735, 9940801, 11317109, 9359515, 9359527, 9359539, 12234887, 9785563, 9621697, 9580747, 11038913, 11391017, 9490435, 11390987, 12234773, 10350637, 10580059, 11391449, 9523687, 9671149, 11104613, 9499003, 12341581, 10244797, 10351285, 10351303, 9564925, 10351117, 9474571, 9392683, 10695293, 10351207, 9524101, 10253191, 9909175, 9425839, 9491383, 10343371, 10925021, 10695437, 9466711, 10351441, 9950365, 10359991, 11318405, 11203733, 9622747, 10777841, 11187419, 9483265, 10622059, 10245193, 9606271, 12236219, 10425751, 9467269, 10794431, 9573823, 9696679, 9467311, 9385267, 11392379, 12342623, 9770641, 10794635, 10327723, 10344157, 10581697, 10925777, 9500179, 10884653, 10515973, 9631273, 9492061, 9770611, 10794581, 10770359, 9467827, 10606477, 9721765, 10786789, 9713617, 10418137, 10344385, 10344445, 10794797, 9590539, 10327849, 10344277, 10795169, 11319479, 12343433, 10352863, 10885349, 9533659, 9500917, 10918109, 10917935, 9508873, 10459183, 9353269, 9484381, 9640009, 10909775, 10066039, 12236879, 9468313, 10860839, 10344727, 10795319, 11393303, 9468253, 10025281, 10795331, 12294839, 9493171, 9968305, 11475605, 9550537, 10386145, 9517597, 9632257, 9353755, 10336771, 10369591, 12343817, 10336861, 12302969, 11475533, 9468523, 9493399, 9468811, 12344225, 10795997, 11467733, 11434799, 10795799, 9362251, 10410865, 10337125, 10058893, 10353799, 9444529, 12450959, 10337503, 12286991, 9493591, 9928105, 12402155, 12352997, 9461197, 9469429, 11394497, 9493993, 9485593, 10534147, 11394305, 10943765, 9469225, 10861889, 10337653, 9469309, 10755415, 10346161, 10796771, 9952975, 10354369, 10837703, 10338043, 9485869, 9969247, 9535045, 11419559, 10354561, 12345221, 10354645, 9633739, 10330051, 10026991, 9363241, 12418931, 9683113, 10002643, 11002097, 9781495, 9740527, 12345391, 9683017, 9863245, 9863287, 9863293, 10035319, 9863269, 9494935, 11518439, 11198783, 11206919, 10002721, 11518637, 10429105, 9364153, 10044121, 11526911, 10797781, 9536227, 10625539, 10388023, 9749029, 12329597, 10445389, 9896545, 9871969, 10003417, 10839011, 9364225, 10396459, 10478425, 11617145, 12240059, 12240041, 12330143, 12240023, 10020067, 12272687, 11199539, 9372727, 12239999, 10445911, 10003525, 9413749, 12264893, 10986881, 10372519, 10986905, 11126249, 9708997, 9553357, 10003957, 12264899, 12240191, 9831697, 12240149, 10454359, 10986863, 10462549, 11240789, 13764311, 10757809, 10258099, 11314835, 11519693, 10520113, 11331125, 10012237, 9610873, 9709177, 10987493, 10078171, 10258393, 9766867, 11200493, 9742285, 9963457, 9857017, 9873379, 9684751, 9578299, 12330851, 10471279, 11552579, 10012849, 11315353, 9644197, 10963163, 9685021, 10258441, 9840649, 10479655, 9644149, 9857149, 11208785, 9652669, 9685411, 10414501, 10570237, 11209205, 11315653, 11209175, 10004965, 11209019, 9627949, 9972055, 10316149, 13543739, 10004839, 11209451, 11348687, 9358057, 10431223, 10447381, 9685549, 9349711, 9357901, 9357925, 11553347, 10431073, 10939277, 9694195, 10431475, 10627951, 10021753, 10431343, 10005637, 9366751, 9522235, 10054693, 11529317, 11324513, 9997435, 10563007, 10014157, 10415611, 9367009, 9686311, 9538855, 10423645, 9932101, 11308355, 9694867, 10776227, 10006207, 11218667, 9604813, 10628629, 10243621, 10448479, 11554427, 10423873, 10514047, 9957265, 10014613, 10006423, 11112383, 12332963, 10776569, 9793483, 10710989, 9867025, 11226929, 9539377, 10252075, 9768799, 10243963, 10580113, 9859243, 13733977, 10514479, 10514491, 10006591, 12234853, 11235413, 10400149, 9982369, 11112719, 9965875, 9875791, 12349775, 9990841, 9736921, 13644479, 10514953, 9728551, 9368143, 12636677, 10482265, 10007107, 10539925, 9360307, 11400161, 10621933, 10032121, 9360355, 11399981, 11399975, 11399963, 10507105, 9704287, 10621819, 10007407, 9729187, 9680077, 11424815, 9532435, 9679921, 10507273, 9712735, 13136939, 12399683, 9434533, 9688495, 10024399, 10417657, 10532311, 10442215, 10007833, 10261771, 10261819, 9540955, 10925705, 9852667, 10417687, 9565705, 10548835, 10425973, 9951115, 10475443, 9861031, 9713575, 11016149, 10458907, 12367673, 10901291, 9795337, 10573597, 10901273, 10516255, 10319707, 11229053, 9860929, 9860965, 9713515, 9869467, 11147399, 9869485, 11122729, 9754627, 10057735, 10754149, 12425315, 10000825, 10508677, 10713587, 9689545, 10549759, 10754497, 9828859, 11524385, 9779461, 10770751, 9992533, 12392795, 9689467, 10001053, 10017427, 10001119, 9788101, 9689827, 10000927, 10009105, 11049533, 9894481, 11049953, 9681865, 12360641, 9345823, 9706249, 9681727, 12229381, 10443601, 12336377, 10460359, 9813199, 9379069, 11025623, 11025413, 10877969, 11025485, 9354343, 11222105, 10018231, 11206043, 9575845, 9559507, 11402701, 12549569, 11525429, 10616089, 11025749, 11296505, 11517635, 12222001, 11025977, 10477063, 9535057, 10436185, 11272169, 10805227, 9691075, 9699265, 10420171, 10805029, 9617185, 11427607, 11231051, 11223209, 11518121, 9699481, 9863299, 11518091, 11002001, 10428625, 10485973, 10420351, 10428823, 9978259, 9609631, 9978289, 11215259, 9707983, 10453483, 11526461, 11002175, 11518217, 9863467, 10420513, 9609565, 11215217, 12484949, 11460947, 10428955, 10863149, 10453627, 10044013, 9364087, 10478479, 11527103, 10830721, 9388969, 10478539, 11518961, 9692131, 13517759, 10298137, 9732889, 9773899, 9700213, 9700219, 10470553, 10060939, 9725059, 10003633, 9782443, 12240113, 12240107, 11224259, 12240065, 10839077, 10355743, 11387947, 9765949, 9716773, 11437085, 10437727, 12272765, 9700753, 10249645, 9921961, 10421725, 12264959, 11232743, 9938371, 9938377, 12264923, 12240329, 11232557, 9782539, 9815329, 12240143, 10470751, 12240251, 9684295, 10429819, 10987181, 10462969, 12240443, 12265007, 10987031, 9954901, 9537115, 11224703, 10987073, 10962851, 10012555, 10782511, 10626865, 10258177, 9856837, 10585981, 12257125, 12339359, 12896441, 9726187, 9873415, 10078261, 12363899, 11241587, 9857131, 9718165, 9988501, 10463653, 9816529, 9849103, 10004791, 10012969, 10627423, 10029781, 9358033, 10726097, 13093441, 10807861, 9841189, 12544631, 12339827, 12544613, 11217485, 10939325, 10455997, 10832797, 12340205, 10505203, 10939343, 9915361, 9513739, 11529011, 9808693, 9718567, 10513231, 9685867, 11209901, 10431667, 9538963, 9538969, 9743635, 10808683, 10775927, 10063231, 10464613, 10243729, 10579585, 10243753, 10776221, 9842377, 11538113, 10252003, 10497577, 11210243, 10554907, 9858961, 10252183, 10956695, 11235293, 9719617, 9867133, 10039453, 11235467, 10956935, 10055851, 10391725, 10719461, 10490053, 11112665, 11210813, 10776635, 10776587, 12546443, 10006951, 10777061, 9662941, 10801607, 9621997, 11260223, 11596055, 11538713, 9965899, 9875779, 10006909, 11088569, 9728749, 10408477, 9646603, 10007125, 9368161, 12407371, 9368179, 11400107, 11334539, 10040239, 9909205, 9728995, 11318059, 9351943, 9671509, 11219825, 11400365, 10024099, 10450081, 10958063, 10458355, 9360397, 11064377, 10433593, 9360445, 11219999, 11424887, 12325991, 11424839, 10622029, 10433641, 10450333, 12449195, 11531651, 9713071, 9582037, 9713113, 11572517, 9835831, 11400455, 12252433, 11523353, 10442083, 10901153, 10557103, 12449447, 9696931, 10598119, 10417873, 9713371, 10270453, 10901207, 10491601, 10016257, 10925597, 10696615, 10901417, 9721735, 13342685, 10573711, 9951151, 10581991, 12449585, 11400971, 10434355, 9746221, 10508131, 10246015, 11220821, 11319437, 10016929, 10565875, 10016971, 11221187, 11212997, 12302393, 10508335, 9476191, 11524523, 12540341, 10779055, 9640351, 9992599, 9697771, 9656605, 11147621, 9714037, 10500421, 12221113, 11188919, 10803847, 10001113, 10451671, 12450509, 12335633, 9828949, 9714247, 12450407, 9902977, 9698245, 9722875, 9984793, 10025773, 9706327, 11221859, 10468171, 9755509, 11050175, 12450983, 11025587, 10042501, 10632391, 12352571, 9354259, 10476601, 9755719, 9919555, 11025479, 9379231, 11025851, 10255759, 10829245, 11263361, 9534907, 10460593, 11025917, 10444273, 10501423, 12254509, 11222321, 10575121, 9707155, 9723547, 9715381, 10509955, 10010299, 9830053, 13147889, 9707257, 10436335, 10460695, 9559567, 9764407, 13532795, 9707095, 10255951, 11525753, 10583677, 11484761, 13025249, 11460509, 12533723, 10043377, 11460575, 10264375, 11460353, 9707353, 10764115, 11534165, 10305691, 10764475, 12230813, 11387039, 9527509, 12255479, 10535149, 10313935, 10510579, 9560263, 12230885, 9437437, 9978085, 9445615, 12304409, 10248241, 10813451, 10248265, 10305943, 9863581, 9511357, 9437629, 9748921, 9855397, 9773539, 9560329, 10297657, 12230927, 10314055, 10305895, 10576549, 10306201, 10478221, 9626245, 11018899, 10388131, 10388197, 9855541, 10306105, 9855547, 9454123, 9683533, 10355311, 10773431, 10920889, 11436935, 10437595, 11387687, 10314505, 9618271, 10306387, 9634675, 10888361, 10519741, 9454783, 10413217, 12264689, 11388131, 10904825, 10626097, 9446455, 10511473, 10306639, 9528439, 10519633, 10347913, 9496021, 10503655, 9438685, 9962953, 10355989, 10028299, 10323205, 12231971, 10601791, 9454909, 10765589, 10061131, 10315417, 10831535, 9430657, 9447103, 11388641, 9446941, 12240427, 11388473, 10348075, 10307155, 9545281, 9381769, 9357187, 12265355, 9848743, 10381231, 9848737, 10905569, 9447385, 9431005, 9349081, 10970921, 10348291, 9439063, 9979717, 10323829, 10815305, 9431173, 10324105, 10791161, 9529573, 12552395, 12953789, 10479637, 10954783, 10364965, 11389037, 9463897, 9463879, 11323457, 9972115, 10250647, 9546121, 9865651, 9423295, 10308061, 10250713, 10250695, 10250737, 10250725, 10766639, 10832183, 9529663, 9447751, 10832249, 10439029, 10553677, 12257609, 10316443, 11315879, 10316467, 9407191, 9382651, 10308325, 10299973, 12217259, 10341295, 12536783, 9915373, 11315969, 10308385, 9448267, 10324855, 10029931, 10308451, 10316959, 10693765, 10259617, 10243285, 9350383, 9350371, 9432289, 10530007, 9784339, 10021951, 9489493, 9743455, 9727045, 11316293, 10873949, 9784735, 9350557, 9497989, 12250505, 11390363, 9416143, 9432553, 9498103, 9571837, 9825763, 10038553, 9415939, 9432355, 9440551, 10317169, 9776485, 9432439, 10309297, 10514149, 10391293, 10505749, 9473575, 9358975, 11382697, 10874795, 9433003, 9457621, 10301377, 9441265, 9867235, 10325989, 9359119, 10309381, 9432877, 9359167, 10350373, 9555793, 9867103, 10063729, 9359221, 11317427, 9359557, 10309837, 10875077, 12218569, 9457759, 9523321, 9965677, 9548179, 10695095, 12267931, 10949117, 10244605, 9449971, 9449983, 10850777, 9441565, 9572617, 9892105, 10834277, 10859177, 10793651, 9441979, 10474159, 9589423, 10252963, 10310359, 11080441, 10572325, 10433035, 10818049, 10252855, 10555927, 9859675, 9425491, 10850903, 10572379, 10335109, 9442189, 9352105, 10548115, 11383805, 10793969, 10761203, 10335223, 9556741, 10367749, 10384183, 9515815, 10244899, 10580845, 10793849, 10843313, 10761371, 10343623, 9606391, 10794203, 10834949, 10761239, 10761233, 10245163, 11383825, 11015273, 10318939, 9466969, 10335301, 9950281, 10761647, 10319233, 10761623, 10835429, 9860551, 10761719, 10343923, 11392475, 11384075, 9999709, 10761539, 10761545, 9500005, 9459055, 10852019, 9524923, 9680551, 9950893, 11400851, 9352909, 9443011, 9950953, 12367393, 10032715, 9434731, 10344049, 10344343, 13055945, 9377707, 10303417, 12408719, 9353143, 9639895, 10762211, 9484225, 9983947, 10311625, 10614775, 10336249, 9492463, 9598753, 9991981, 9451345, 10573669, 9451333, 10311499, 10794875, 10885283, 9476239, 10467517, 9541801, 9541885, 10508329, 12408869, 10303543, 9615397, 9361483, 12253601, 10844555, 12343691, 12417413, 9623977, 9451999, 10312135, 9550321, 12515803, 10754519, 10320361, 13146559, 10311949, 10484029, 9673009, 12237059, 10312021, 9943363, 11163989, 12409535, 11401897, 10328731, 10762937, 10345147, 9534121, 9460441, 9484999, 11385377, 9452047, 10852877, 10304047, 9746983, 10017325, 10615393, 9452119, 12253811, 11393633, 11385419, 10836569, 10762841, 10337155, 9558961, 12229523, 10312627, 10763159, 10017787, 9370597, 10574797, 10328845, 9476923, 12229463, 10280071, 9460945, 10771691, 12254447, 10763507, 9436369, 9403645, 9460765, 10345477, 13474927, 10320973, 10763333, 11394491, 9362875, 12238307, 10419697, 10337767, 10329391, 9477457, 10403167, 10886519, 12254573, 9780553, 12262757, 11411111, 9608839, 10247851, 10018471, 12230399, 9436903, 10796549, 10321471, 9813553, 10329655, 12230147, 10362451, 10255993, 9526885, 12255155, 10305469, 10518403, 10371001, 11411453, 11386829, 9347047, 12230459, 12255035, 9436939, 10313509, 10764137, 9731911, 9846937, 10330273, 12230903, 10772681, 10764503, 9634021, 12230783, 10764353, 9773179, 10420327, 10764377, 10477957, 10297777, 10363297, 9667057, 9855475, 9855487, 9855457, 9634069, 10248451, 12222757, 12230939, 10920215, 9871699, 10797401, 9749143, 9650845, 10338949, 9855631, 9454267, 9847519, 10347223, 10535641, 12231365, 12501537, 9568831, 11051527, 11379229, 10330717, 9478741, 9454147, 9568837, 10355305, 9454465, 9855877, 9446317, 10331089, 10322935, 10331119, 10355479, 9495325, 10904363, 10879799, 12280703, 9454411, 12231491, 10323103, 10364035, 11388083, 10880153, 9495745, 10978505, 9471211, 10765319, 9978961, 10331257, 9421951, 9479569, 9356683, 10880429, 10044805, 12281243, 9553339, 10765823, 10364167, 9479437, 10339639, 10765577, 11388191, 10929425, 10323235, 9700651, 10863989, 10331491, 10905221, 9864883, 10430173, 10356427, 10323709, 10323703, 9356815, 10315267, 9856567, 9496117, 9954865, 10618399, 12281471, 10372723, 10765919, 10340251, 10356631, 11388863, 9349039, 9381793, 9873337, 9455527, 9447391, 11388875, 9848803, 10315525, 9979711, 9717565, 10864493, 11389061, 12232853, 9455809, 10332367, 12232919, 10324195, 9963547, 9472009, 10364977, 12412943, 9848875, 9513073, 10381705, 10389979, 9832957, 9447907, 9816349, 12233045, 9456277, 10242745, 10250917, 9489151, 9661153, 9456367, 10242787, 10242589, 10349083, 11389499, 10250815, 10340917, 10332721, 13855343, 10316323, 10029649, 9456193, 9579073, 9423457, 10332769, 10381921, 12233651, 10374037, 9448351, 9440185, 10333105, 11389889, 9448219, 10881845, 12233507, 9464629, 12233495, 9554731, 10259299, 9653377, 9440389, 10759345, 9948289, 10325203, 9456835, 9956593, 9448681, 10546399, 9571351, 10374169, 10316803, 9759799, 10628197, 12217451, 10792001, 10251361, 12234143, 9350563, 9596323, 10317265, 9514471, 11390219, 9514303, 11398511, 10325317, 11390285, 9350509, 10341745, 11316575, 9440923, 9440947, 9989797, 12217991, 12226301, 9965299, 9440785, 9481735, 9350677, 9448975, 9350725, 11316811, 9694843, 9375355, 11390885, 10473349, 9359251, 9539515, 9441217, 9359317, 9449419, 9449467, 10792925, 9474031, 9907999, 9555739, 11317031, 9359125, 9858829, 10792709, 10940171, 10694425, 9957163, 9359155, 9351007, 10792823, 12283721, 11439961, 9490579, 13955281, 10932359, 12292247, 9695455, 10694849, 10334443, 11391185, 10514473, 10326067, 14004325, 10317913, 9376135, 9474463, 12235163, 9466285, 10342855, 10392061, 9589237, 12259619, 9638179, 12284267, 10834289, 12235091, 10793291, 9875815, 9474727, 12259973, 10580707, 10277587, 9351901, 9548539, 13071017, 10007053, 10252861, 9515575, 10572385, 9450073, 9450109, 9450391, 9548701, 10834871, 9646987, 9581455, 10335157, 10875785, 10359727, 10777499, 9450433, 10326991, 10793981, 10376185, 10793939, 10343395, 10924835, 9573169, 9442081, 10007335, 10384201, 9474895, 9466741, 10761025, 9442147, 12235907, 9499819, 10409167, 10318879, 10859537, 9720913, 9450583, 12342377, 11392391, 12523007, 11392487, 10884587, 11310557, 11400491, 11064611, 12227869, 10777865, 12236135, 9966919, 10794311, 11392685, 10909361, 10344121, 10245817, 9451195, 9443005, 10925795, 10753787, 10917581, 12236489, 10450459, 9975313, 12220009, 9508429, 10573399, 9918061, 9615259, 9951109, 9992077, 10057615, 9500551, 10762169, 10409749, 9443131, 10377373, 12343469, 11417789, 9386131, 9771199, 11417729, 10762379, 9353419, 9459931, 9468097, 10762439, 10762463, 9345031, 9869347, 9451585, 10254739, 10303909, 10762745, 9763309, 10353121, 11385125, 10762499, 10516753, 9435787, 10795691, 11385521, 9517711, 12221093, 9452209, 10869479, 9476803, 10763003, 12245713, 9419491, 10762973, 12999355, 11385389, 9452053, 9542149, 10353205, 10345009, 10328623, 10574455, 10312261, 10345087, 12286553, 9484927, 11385431, 10320793, 10320781, 9354175, 10320895, 11385809, 10795811, 9468697, 12262199, 10509103, 9444097, 11385653, 10263301, 9771835, 9640783, 9444223, 11483993, 9755503, 11050157, 10321087, 10927253, 10763411, 10280101, 10796261, 10886399, 10321129, 9583699, 10771553, 9583681, 10378363, 10329481, 12221869, 10763651, 9960865, 10763753, 9575887, 10763771, 9346555, 10485223, 10763741, 10321165, 10763531, 9469255, 10362229, 9567589, 11001509, 10583731, 10329739, 11402935, 9797257, 10321627, 11329277, 10763975, 10854101, 9788935, 10911239, 10337845, 10346035, 10337887, 9363019, 10329691, 10329673, 11386463, 9461635, 10321801, 9494407, 9650107, 9486295, 9355237, 10755893, 11386673, 12230429, 12402541, 11435869, 12230465, 12230471, 10068121, 11174045, 10518727, 10969141, 10633279, 10534921, 10518541, 10805347, 10805317, 11173961, 11173967, 10518961, 11313599, 10961339, 11461001, 10797457, 11149769, 11002307, 9716209, 11461067, 11002319, 11329991, 9716197, 9806305, 11313467, 12402971, 9863461, 9732427, 11149643, 11149979, 10068673, 10044157, 10527253, 11461193, 9782149, 11314103, 10445743, 9519877, 11592515, 12575873, 10511599, 10028269, 10560559, 10535989, 9831439, 11584517, 11347049, 10511479, 10454125, 10053049, 13223405, 10839437, 9749821, 10528105, 9373027, 12265145, 10553065, 10053367, 12379859, 10618579, 11126315, 10520077, 10610197, 11126351, 10815431, 10880971, 11544527, 12240743, 10528579, 10062007, 9545941, 9619669, 10062073, 9545959, 10258483, 10504315, 10496077, 9807973, 13027829, 11405797, 13126001, 9750865, 9546073, 10029721, 9865873, 9906823, 10054363, 11520767, 9890545, 9841405, 10439191, 11463205, 11340395, 10537591, 10521505, 10038157, 10628023, 12274649, 9685993, 12364601, 12389165, 10038103, 9554809, 10046611, 10538137, 10783939, 13044907, 10529851, 9358399, 10513435, 10505641, 10079683, 9367027, 10513681, 10604203, 12381827, 13340291, 9457405, 9809527, 9719419, 9825889, 10055593, 10579867, 10694557, 9867229, 10522585, 12234559, 10252441, 10055839, 11112647, 10580011, 10481713, 10252333, 11112479, 10252357, 11112515, 11112533, 10801589, 10588567, 11587897, 10539361, 10400095, 10801505, 11342513, 11326199, 11088581, 12218905, 11383327, 9859627, 9392731, 10056313, 10056589, 9810871, 10777583, 10777577, 9753571, 10777391, 11522935, 9843565, 9786217, 12227623, 9794623, 10564639, 9344083, 10048915, 10253713, 10048897, 10507705, 9360823, 9803011, 9794875, 11351327, 11654405, 12375389, 12383933, 10507945, 12326561, 11400959, 12326609, 10262029, 10532407, 12326525, 9803335, 9697243, 10754041, 10516423, 10049287, 10049341, 11327351, 9828169, 10574011, 11212937, 13048043, 10541311, 10557475, 11655257, 12229009, 11336081, 9812425, 10058227, 10058209, 10057999, 9869569, 9820471, 13023599, 10574095, 10484017, 11614589, 10516819, 11188877, 9779887, 10394125, 10902047, 10058311, 10631767, 11614793, 12450719, 10517299, 12450587, 10050391, 11590469, 10550425, 13524143, 10542133, 9837649, 10566721, 12516779, 9543103, 9346465, 9944533, 9698773, 9805261, 10051069, 12221905, 10059037, 12393749, 10378549, 10034539, 10346137, 10518181, 10501813, 10256035, 12426977, 10558981, 9805363, 10051135, 9821785, 10788457, 13516343, 10403731, 11173883, 9813997, 10534663, 9723709, 10534681, 10084135, 11026253, 11026241, 10501975, 13352759, 10551487, 10567933, 9846793, 12222583, 11461103, 13517171, 9863509, 10568053, 11370827, 9863527, 11174225, 10068631, 10060471, 10068679, 9847525, 11002379, 10044289, 10544077, 11150303, 10625809, 9544489, 11150189, 10437805, 10069015, 10757137, 9766015, 10560595, 9807253, 10962323, 13346189, 11322877, 9373153, 10028305, 11658515, 10544407, 10569073, 10839419, 9807205, 10437985, 10561207, 10569403, 11650805, 12265199, 12265169, 10561069, 11609627, 9832015, 10438243, 9357205, 13027289, 10069939, 9750337, 9701221, 10577749, 10553353, 10545253, 10553467, 9767323, 9750997, 9841117, 10562035, 10561999, 10717649, 12544451, 10553635, 12552485, 10791169, 13125911, 12389027, 10070761, 9775849, 10766857, 9751099, 12364307, 13552517, 10038229, 12397535, 12463061, 11520977, 12266279, 9554803, 9849727, 10071193, 11668625, 10538023, 10439713, 10571197, 10694083, 10554823, 9932137, 10546855, 10514095, 13373059, 10514137, 10554925, 9367075, 9367111, 12390293, 13340597, 10071817, 10571533, 9720013, 12390617, 13340837, 11350085, 9851293, 9728473, 10252549, 11391247, 12546739, 10801667, 13693469, 10007443, 10548145, 10032085, 10032115, 9786343, 11088689, 11088767, 11088713, 12407995, 10441897, 12399845, 10532047, 11375663, 9753625, 9753613, 10556527, 13325345, 10540459, 11064755, 12219883, 9360865, 10630519, 11237003, 9844447, 9360937, 12219919, 12507011, 9697267, 12326879, 12416965, 9852721, 9844543, 11319041, 9803563, 11663201, 12326729, 10549087, 11212955, 11557115, 12548297, 10549291, 9975895, 12237103, 12392813, 9845401, 10902071, 12302867, 12229627, 10550053, 11123533, 12548945, 9362293, 11377795, 10755229, 12500161, 10837039, 12450863, 12450917, 11615315, 9370747, 10878041, 9813445, 9829651, 9346381, 10059091, 10435915, 10812787, 13425983, 9354805, 12533357, 12427157, 10264531, 10756093, 11485127, 11485145, 9854959, 10493731, 10575679, 9723703, 12427027, 13025147, 11485055, 13033259, 10059919, 9863329, 10502377, 10043629, 11534345, 12509189, 9715825, 11460701, 10723715, 10846705, 10035475, 9863449, 9756931, 9732403, 11551007, 9724243, 11289263, 9765505, 10863233, 9364177, 9519847, 10027579, 9716329, 9724801, 10085299, 9536287, 9732925, 9675577, 10429219, 9560899, 11535185, 10044283, 10429297, 9364639, 10036441, 10437853, 11519201, 9438403, 11232509, 11224307, 9692407, 11551937, 11437097, 10839053, 9749563, 11273339, 10462273, 10610095, 10724795, 12264953, 9733591, 9938383, 10429705, 9815335, 9708883, 10437973, 9700687, 10487125, 9839971, 9790831, 10618537, 11380435, 9782815, 12264971, 10470949, 9741889, 9734017, 9856951, 10438585, 9766879, 9963475, 9775045, 10258411, 10258207, 9709321, 10585861, 10782487, 10504039, 10258249, 9553741, 9791335, 10585939, 9980053, 12535979, 10061953, 10627207, 11225219, 10406059, 9824431, 10610935, 11233481, 12347615, 10512589, 11233325, 10020871, 12240923, 9791545, 9619543, 10029121, 9849229, 9709963, 9882037, 9628087, 9816541, 11233739, 12347705, 9849139, 9857347, 10479937, 9374347, 13347527, 9865771, 10628071, 11586497, 12348221, 11545391, 9718561, 11225879, 11553659, 9718627, 10013539, 9759595, 9358477, 10480783, 11226269, 10489063, 10939397, 9997375, 9841747, 10038355, 10259557, 11382235, 9735829, 10022563, 10923751, 11259623, 9973501, 9702937, 11226629, 10415743, 10719119, 10489831, 10244053, 13512605, 10776563, 9752569, 10801109, 11227097, 11226941, 10252117, 9719989, 11211005, 11088077, 12743063, 10023403, 10752473, 10957091, 10588471, 9793807, 11391283, 10588429, 10400083, 11301215, 13341419, 11235971, 9736951, 11211461, 10957523, 11227859, 12472877, 9900601, 10711583, 9654877, 10957427, 10056259, 9720445, 9761695, 10015627, 11539373, 9769921, 9753367, 12350249, 9351973, 9351985, 9712795, 12334247, 12326033, 9712813, 9385177, 11064515, 11539655, 11064533, 9360421, 10024063, 9721243, 9803173, 10712549, 10450381, 11539943, 9360871, 12326213, 10925759, 9967291, 9778867, 11187959, 12326435, 12285449, 9713221, 11187833, 9746029, 10713011, 10958723, 9861049, 10573723, 12302327, 9770971, 12294103, 10696489, 10270477, 11187977, 10598149, 10245967, 10573651, 10245991, 10016917, 11188415, 10492045, 9869509, 10025215, 9607189, 11270183, 11540503, 9492541, 9779293, 12302453, 9722281, 12335597, 9640447, 10533337, 9541909, 9771289, 10795315, 9615679, 9673039, 13695281, 10033531, 12450359, 10467853, 9894475, 9362041, 10017673, 9345949, 9722761, 10460071, 12647303, 10017733, 9346021, 11172611, 11172725, 9345901, 10476409, 10607779, 12450977, 9354415, 9354409, 10607761, 9346237, 10009801, 10009843, 10026061, 9706561, 9821281, 10288543, 12402089, 9592243, 11271557, 9706939, 11541893, 10501597, 10468633, 11173229, 9715039, 11050307, 10444501, 9559585, 10444369, 11230847, 11533889, 9789415, 9617197, 11149475, 10510513, 11542697, 9756883, 10035427, 11558963, 11460671, 11460665, 11460659, 11272205, 11575325, 11542637, 11583599, 10600513, 11272265, 9732223, 11173979, 11272607, 11002259, 10478041, 11461097, 9757153, 11542841, 9863425, 10543423, 9716005, 11272469, 9757021, 10035559, 9749149, 10044055, 10920691, 9765601, 10035715, 13927025, 12354173, 13517789, 10527673, 10027909, 11568029, 11273159, 11264789, 10716023, 9356119, 9364333, 10036081, 9438385, 10839293, 9798907, 9372925, 9774127, 10036297, 11437121, 9348511, 10372537, 10528141, 11265503, 11544011, 11330855, 9774427, 12354923, 10036579, 12354881, 10249885, 11331245, 10618555, 10249933, 9766417, 10249795, 11560949, 10520551, 11560943, 12240701, 10987307, 9742105, 10987319, 9783079, 10037401, 9619609, 9545869, 9857215, 10070191, 10545391, 11282651, 9766951, 9767005, 10504609, 10029469, 10512865, 9783805, 9857299, 9603391, 10037947, 11291291, 9652909, 9824989, 9923293, 10570477, 11553533, 9652939, 9784033, 11553485, 11561489, 11553311, 9865849, 9350023, 11250623, 10046431, 10079227, 10726151, 10038079, 10382119, 9358165, 10513219, 9759607, 10079395, 12528893, 13110365, 10939451, 11561987, 12274781, 10022005, 11554235, 10898873, 9776563, 10046929, 10038739, 10038775, 12340691, 10038763, 9588199, 12373289, 10726709, 9358633, 10063141, 10358119, 9744031, 11112125, 12218017, 9801403, 11112173, 10579693, 9694765, 10628725, 11497025, 10776491, 10514353, 9629629, 12529547, 10629109, 10432507, 9785341, 9777133, 10506019, 10555159, 11112215, 10039111, 9752395, 11088053, 9498805, 9769129, 11301107, 9793777, 10547419, 9719809, 9719821, 10776701, 11235401, 10571851, 9859459, 12685697, 9859537, 12530153, 9769471, 9859567, 11284739, 10498333, 10064167, 10498777, 10801703, 9859585, 9753157, 9769543, 9376663, 11555729, 9401305, 9401317, 9769783, 11555615, 11236223, 10777427, 10507099, 9360541, 11482291, 9745651, 11424983, 9761821, 10040323, 10507267, 10040371, 11277329, 12366923, 12326321, 11064713, 9827791, 11064581, 11400869, 9754243, 10032811, 9746167, 12359375, 10802725, 9754135, 11400779, 10246111, 10573813, 11278301, 10057699, 9623311, 10925831, 11269913, 10516243, 9770797, 10925927, 9713521, 11269979, 11294861, 12449933, 10860769, 12450035, 10033351, 9779455, 12302549, 10582237, 10532905, 9885745, 12359765, 9713761, 11581877, 10754455, 11319707, 10959341, 10508779, 9722305, 12360143, 10394089, 9615619, 10582273, 10959125, 10492279, 11270519, 12302687, 12368213, 11368769, 11319647, 10025683, 12368597, 12450395, 10034053, 11049947, 9362185, 9804667, 9984865, 11271371, 10960079, 10050589, 9346057, 11050073, 10878047, 10083805, 11378173, 10026475, 11279639, 11443553, 12262753, 10493611, 9707137, 12361355, 10493599, 9534985, 10624513, 11271695, 11484677, 9535009, 12361229, 9690709, 10567279, 12426827, 10255969, 9543571, 9748423, 11280329, 11558699, 9740041, 10026829, 10035013, 10264435, 11657403, 10575883, 10559503, 10756213, 12394601, 9846859, 12394943, 9748873, 12534221, 12550511, 13509521, 10306549, 12551111, 13042463, 10757347, 9782293, 13026563, 10790575, 13027055, 12600851, 11667053, 12396443, 10839865, 11315065, 10569907, 12241121, 10553641, 10561801, 10553671, 9865927, 13027985, 10463749, 10570243, 10717709, 10570363, 12274643, 10529743, 13118537, 11521151, 12364901, 9547195, 10022155, 10071301, 9784693, 11652425, 10571503, 9826045, 11071451, 9850675, 12218521, 9654445, 10940569, 10072261, 12595225, 10556011, 10408549, 10564369, 9990985, 12227761, 12219643, 10474537, 10777619, 11425169, 10040611, 12547403, 9844417, 9852661, 11073061, 9360943, 9360973, 10565221, 10262125, 13604807, 12326837, 12326831, 12326861, 13514951, 11212943, 11655401, 9852949, 10917895, 9607249, 10246537, 10557745, 10778911, 10574149, 12401189, 10017373, 10492537, 10041955, 10763167, 10025893, 9763621, 13024007, 12401519, 10754887, 10050421, 11369297, 12451001, 10468543, 12451031, 13532249, 10755193, 10558537, 13516253, 9379255, 10780063, 11377975, 10755757, 9961129, 10780363, 10567225, 11517491, 11673209, 12427145, 10583845, 10764085, 10567489, 10723553, 11378923, 9732295, 9781273, 10436647, 9855019, 11403391, 11247743, 11174003, 9773131, 10502239, 11157937, 10043875, 9634285, 9732373, 10486057, 11280695, 12525857, 10772737, 10477873, 10019119, 11002235, 9380377, 10060303, 10863203, 9871987, 9380455, 10863197, 11559869, 11322293, 9560917, 10068859, 10839215, 10364095, 10028197, 10765537, 10511593, 10364107, 9372883, 9708547, 11379721, 11568575, 10053001, 12273059, 11560433, 12240359, 9782773, 10511821, 12240323, 11552051, 10601773, 9790747, 10036543, 9348421, 10487461, 12265097, 12379877, 10045177, 10610209, 9782809, 10249729, 12240401, 12265073, 9717343, 12265055, 12355157, 10495573, 12265037, 10987103, 9766813, 9963427, 10020775, 9856963, 10504129, 11315155, 10078033, 10479475, 10037407, 9619615, 12667109, 9857227, 10021093, 10070047, 10029067, 9775189, 10537063, 13543907, 9767383, 10029553, 10439149, 12552557, 9628021, 10029409, 9652873, 10021507, 11602625, 9865795, 11274827, 9742963, 10013299, 10504789, 9784243, 11561831, 9423703, 10489003, 9997453, 12348665, 9997393, 9768025, 9366625, 12348485, 9522283, 11046373, 12348905, 10497313, 10079605, 11259221, 12340901, 10604167, 10776203, 9703075, 10776311, 10563079, 12365741, 9539461, 10334131, 12259207, 9719803, 9727753, 10776335, 10030969, 9768805, 10432363, 9744571, 11022581, 12349637, 10801373, 10039387, 10801259, 10072177, 9539683, 12218437, 11547065, 12579209, 11243921, 10498501, 9777637, 11301161, 11088233, 9859417, 10023241, 9777817, 9368215, 9351925, 11563571, 9540097, 9728569, 9769573, 9376657, 10023841, 10474405, 9728983, 10490827, 12391229, 10031887, 10007389, 10024075, 9737425, 10499281, 11252951, 12350483, 10384507, 9704839, 11400629, 12875227, 11400473, 12350723, 9704785, 12416341, 9360757, 10032793, 11400863, 11310845, 9770737, 10499629, 11188133, 12449693, 9861037, 10426321, 10246093, 11188223, 9779173, 9762649, 10925909, 11245739, 11188409, 9844867, 10631395, 9869539, 10901543, 13039721, 11253857, 10901627, 12449885, 9844855, 9992617, 10582477, 10582321, 12302621, 10803487, 12352169, 10025641, 11541203, 13032035, 9763411, 11541077, 9763441, 10550041, 9780049, 9567385, 11050151, 11254835, 11246609, 9780343, 11025839, 10034563, 13909493, 10083751, 11542007, 9534949, 10026469, 10542373, 9346309, 11304251, 9403723, 9788737, 9748189, 9707209, 11025929, 11025941, 10034779, 11026019, 11542427, 11313053, 10035145, 10526527, 10035001, 10493725, 9584467, 9674581, 11665583, 11485205, 11370599, 10756513, 11174399, 10781053, 12526223, 12550901, 11174593, 11379253, 12403309, 11617187, 11617181, 11387671, 11379475, 13345541, 12608579, 12510227, 10765735, 10757551, 10937737, 12535265, 10757413, 13034879, 13026821, 10815467, 11675825, 10717427, 13035695, 10954957, 12552239, 10758259, 11675735, 11667521, 13699115, 10783141, 13019447, 11315947, 10758739, 10939589, 13184177, 11373605, 12463145, 12463139, 12463217, 12463211, 12553529, 12365111, 12553523, 11660903, 13020713, 11366333, 11374535, 12529609, 12218317, 13659995, 13414259, 12218545, 10784977, 12226651, 12218803, 11112773, 11408035, 11670077, 12399599, 13333313, 13529981, 13341899, 12227725, 12408061, 11580653, 11580617, 12579941, 10777691, 13530617, 12547559, 10753475, 11236805, 10917163, 11662613, 12547721, 11359745, 11236985, 11236949, 12326849, 11482915, 10811239, 10762093, 12540065, 11212931, 11368511, 11212853, 10926083, 12548207, 11212877, 11377025, 11671943, 13564319, 12261871, 12769699, 10803841, 11188967, 11369165, 13523543, 10902095, 12401591, 11369363, 11401999, 10755151, 12221881, 12533177, 13024703, 12451127, 12393773, 12451091, 12221791, 10763839, 10755685, 12222067, 11419531, 13098995, 11378647, 12230455, 12533609, 9986191, 13017221, 10731731, 10067995, 9969667, 10068019, 11591687, 10035289, 12370025, 9879649, 9773167, 10051999, 9781657, 9716101, 9765295, 9765361, 10477837, 9781507, 10035505, 10084681, 9797965, 10051963, 11280731, 9773725, 11281061, 9740959, 12362417, 9749125, 11567789, 9773749, 10502791, 9749203, 9741001, 9519871, 9757423, 9740845, 11543153, 9749101, 9364441, 10028005, 13517657, 12362531, 9765691, 9823015, 10863377, 9356107, 11567999, 9995077, 10028161, 9774265, 11568371, 12362987, 9765907, 12518453, 9749509, 10454077, 11273225, 9798697, 9782377, 11281835, 10429885, 9782707, 9782719, 9749983, 11544041, 9799165, 11126213, 11298257, 9798937, 10503481, 9766189, 10045081, 11126441, 12240563, 10036873, 9750151, 11544209, 9774769, 9782971, 11282051, 12240533, 11568893, 12363485, 12240605, 10528297, 9774619, 11544107, 10036789, 10511989, 12240479, 11322953, 10037131, 10987403, 9766831, 12363773, 12535793, 9783247, 10733513, 9766891, 10078009, 12240659, 10503949, 10151725, 10487629, 11659433, 10037443, 9775345, 11282465, 13338731, 12371993, 9726013, 10397731, 10864741, 9857089, 11291117, 11520509, 9628111, 10037737, 9775381, 10512697, 9857293, 9783607, 10504453, 10504573, 10766659, 9767269, 11520677, 10046101, 9783937, 10627735, 10046203, 10521121, 10005001, 11520629, 10046377, 9784297, 9784093, 9497353, 10480465, 9775939, 9775951, 9792379, 11250857, 9776341, 9768139, 13552727, 10939505, 10734719, 10529869, 11496893, 10079629, 9588169, 9793021, 10038589, 11251067, 12340907, 12365477, 9776821, 11570819, 10055419, 10514125, 10424035, 9776659, 12217903, 12373547, 10047037, 10038847, 11382343, 10513999, 12561995, 9793135, 11284361, 9777085, 10055599, 9768877, 9793453, 12398465, 9785299, 10694653, 9768955, 9768937, 10497841, 11292479, 10039093, 10039429, 10801337, 11235575, 12374237, 10776779, 12374213, 10776611, 10252303, 9703507, 9769063, 9810325, 11571623, 10514875, 10629565, 11088269, 9769381, 12366215, 9728449, 11088329, 9859555, 9769237, 11088227, 10498417, 9777799, 9794215, 11088533, 9777913, 9622033, 11563625, 10777157, 10507183, 9769867, 9352081, 9352111, 11334533, 11285399, 9376705, 9794539, 11301653, 9802591, 9818989, 9770155, 9778393, 11424995, 11326661, 9778207, 11564093, 9540721, 9671779, 9516133, 11400701, 10261963, 9778459, 9360661, 10253623, 9835813, 9532711, 11064593, 11425043, 10630507, 10253641, 11064653, 9852271, 13031105, 11294375, 9328279, 9836221, 10049245, 12326621, 12326453, 12662375, 12228103, 10516045, 10507855, 10925993, 11581313, 11556857, 12367721, 9779041, 10573993, 9779335, 10901705, 11286749, 9779431, 9779227, 9713749, 9828433, 12368309, 10492339, 10729859, 9755059, 13507043, 10500511, 10050037, 11573711, 10582285, 10574185, 9779551, 10582351, 10582357, 9738601, 10402495, 10050265, 11311865, 9747151, 11303621, 11328011, 10525207, 12368501, 9820795, 12343885, 9894499, 10959791, 9780097, 10001281, 10042303, 11336579, 11287493, 10501081, 9788395, 10959833, 9747205, 12778331, 12450581, 10500895, 10025815, 9984847, 10312549, 11377489, 12286789, 12369083, 9780403, 11050133, 10960109, 9346075, 9346117, 12385391, 11050103, 10042777, 9354643, 10632577, 10034623, 9592255, 10337749, 9354691, 9780715, 10960151, 9829723, 9354607, 9780607, 9526633, 10050919, 11484845, 11026085, 10510009, 11173553, 11026103, 10583701, 11026079, 10043101, 9805333, 11279915, 12426779, 10051123, 9764389, 9772591, 9772945, 11296697, 10035079, 11321267, 11599751, 9781201, 9764803, 10264519, 12361679, 10583851, 12386171, 11173703, 11575109, 10559617, 9691327, 9773227, 9658591, 9650371, 9986095, 11001929, 10011037, 9994633, 10379743, 9609493, 9658675, 9953575, 9609511, 10862945, 9634147, 10756447, 12272375, 9994993, 10043977, 10035787, 12272231, 9536113, 12411835, 12239795, 12239783, 10625923, 10838939, 11437025, 9683953, 10298125, 9995071, 12231445, 9560911, 9806707, 10077025, 12240053, 11191481, 10429579, 9438343, 9438349, 10986725, 12330233, 9397501, 10757329, 10265617, 11437061, 10003507, 12239879, 9348175, 12239975, 9667969, 10560955, 11249051, 10986791, 9995575, 10249579, 11306657, 9758341, 10536631, 10815107, 9610933, 12265211, 9774805, 10258129, 9856753, 13149863, 10446565, 10413613, 11511389, 10012597, 9701323, 11208641, 11315143, 10258237, 9996085, 9856813, 11659121, 9996157, 11282267, 10241893, 9980077, 10004731, 9849061, 10078225, 10258447, 9660457, 9979939, 9979969, 10012741, 11208821, 9472405, 9849223, 10422667, 9996685, 10029493, 13814243, 10414549, 10422739, 9628105, 9668875, 9972043, 9750883, 9972079, 9996949, 9513655, 12307195, 9997003, 12331721, 9349873, 10775075, 9357847, 9349669, 9374269, 11512343, 10512925, 9701977, 9349729, 10775447, 11447287, 12667811, 9767935, 10390327, 9349927, 9997111, 10521367, 10939253, 11193179, 10390375, 12217499, 10775687, 10513561, 10243237, 13372657, 9366721, 10955969, 9800941, 10013923, 10431517, 10021909, 10775573, 10775579, 9538645, 13339661, 9407611, 9579625, 9833905, 9776605, 9440755, 10694093, 10489123, 9997597, 11193635, 9817369, 12217643, 10505497, 9661795, 11283797, 9998005, 10694365, 10366495, 11529767, 10030603, 13741693, 9662035, 9662029, 10243651, 9613237, 10506121, 9654229, 9637837, 10252285, 10252267, 11185973, 10047355, 10580143, 9859225, 9785527, 10399975, 10522675, 9695245, 11194385, 9597013, 10391677, 9744511, 10539097, 9621895, 9662887, 10433011, 9965851, 9965845, 9965833, 11186489, 12448115, 10768705, 11399861, 9990817, 9351913, 9376507, 10441255, 13341635, 11178911, 9376513, 10957577, 11277479, 11187335, 9827491, 11195627, 11400437, 10417351, 9360499, 11195819, 11179439, 9581995, 9729475, 10261813, 11146523, 10343749, 11220659, 9623209, 10245853, 9860863, 10573525, 9999895, 9672247, 12301937, 10434127, 9934453, 12301889, 9951121, 9861001, 9672475, 9467659, 12449567, 10761991, 9664291, 9860941, 9869449, 10533097, 10713281, 10000609, 9656401, 9476179, 11344271, 11196899, 9501151, 11049251, 10418491, 12327287, 12327233, 10451611, 10025629, 10623661, 11524751, 11205275, 10009261, 10066441, 12450305, 10877825, 13515773, 9354169, 10877855, 9698251, 9354217, 10558243, 9345805, 9681685, 10713965, 9534325, 10877771, 12328169, 9379027, 9526519, 9690121, 11189249, 9780289, 9567355, 10583473, 10427815, 9690583, 9854407, 11181509, 10255633, 9698623, 10255699, 10255693, 9666211, 9993901, 11198207, 11394805, 11558405, 10501723, 10002313, 9600937, 10846207, 10264357, 10060015, 11174327, 11460995, 10068235, 10060039, 9830713, 10871059, 11379061, 11174261, 9822583, 9872023, 9380509, 10478101, 11395645, 10535437, 10478125, 11600387, 11149925, 10068589, 10085311, 9823141, 10437547, 12534557, 10068781, 11346797, 10437469, 11150183, 9847627, 9659233, 12493985, 11601041, 12575975, 10003711, 10364143, 11314205, 9373069, 9373087, 9373117, 10839455, 10438129, 9839887, 10839413, 10438003, 10839389, 10544797, 9750223, 12265175, 9750241, 11347667, 9479683, 9823759, 12264983, 11126375, 10250137, 10487707, 11339747, 13035401, 10815479, 10061803, 10815443, 9578353, 10545289, 10258477, 10258465, 12240989, 11545013, 9824641, 10758559, 11299223, 9472465, 10570231, 9751009, 10062103, 10504477, 12421483, 10062427, 11422309, 11405947, 9546355, 10054249, 11356763, 10038169, 10070917, 12463007, 10038193, 13052923, 10570537, 10537741, 10480483, 9825421, 9997489, 9997495, 11578601, 9358573, 10063081, 10939601, 11275349, 10693933, 11341079, 9833839, 10849969, 9604855, 10538707, 10063423, 9850471, 10514011, 10063771, 10055581, 9850777, 10571671, 9834409, 9629653, 10547149, 11112617, 11112623, 11112581, 9703597, 10055881, 9720001, 11112653, 11612177, 10432549, 10825753, 10580089, 10056109, 10539301, 10055989, 10490137, 12341617, 12546745, 9859729, 9859759, 11088623, 9859789, 10564351, 11342555, 13865561, 10056199, 9859663, 9744997, 10007449, 10064821, 9827269, 10064875, 10064869, 11088683, 10539811, 11653949, 11088647, 10548085, 11596655, 11088719, 9557203, 10433731, 9835747, 9835525, 10073143, 11392123, 9376855, 9376849, 9352303, 12383669, 11064743, 9360853, 10016011, 10777913, 11605361, 10564969, 9688387, 9794893, 9835903, 10540717, 10540771, 11605727, 11343575, 10851907, 11597399, 10540633, 11335601, 10532749, 9951193, 9836485, 10516477, 10557379, 11401019, 12326675, 12326663, 12326657, 12326783, 12326777, 9828175, 9803617, 10066105, 12499085, 13342865, 10574023, 13400075, 10549375, 10246549, 9755101, 10549543, 9836845, 12392807, 11188925, 9853615, 9763537, 10050067, 10902017, 12597881, 10558063, 10050115, 9837463, 12450809, 10058701, 10754875, 10050367, 10025797, 10542259, 12450947, 9837811, 10435825, 9837589, 9747457, 10878029, 10542499, 9379237, 9944569, 10525987, 11656511, 10755391, 10059043, 11050337, 11050355, 10346143, 9821881, 10542805, 9428503, 9354793, 12426875, 10624603, 12386231, 10502041, 10502137, 11485019, 11174057, 11460791, 11149493, 10559623, 10633375, 12386555, 11460839, 10772695, 10567717, 10502191, 11296775, 11149343, 12370043, 11149409, 10871209, 11002295, 11370935, 11002301, 11149709, 10961189, 9863431, 9814309, 10502419, 11305313, 11174213, 9781909, 10502833, 9781897, 11149961, 11584133, 10863347, 10502911, 9675505, 9781993, 9781765, 11616809, 10961471, 10060291, 10510867, 10535449, 10502761, 9830989, 10289731, 9634429, 9781867, 9806779, 10503115, 10437601, 10543915, 9831229, 10527511, 10052437, 11150147, 10519717, 10839275, 10970353, 11306183, 10511407, 9823291, 10503187, 9364531, 12362873, 9823315, 10028119, 11330675, 10765381, 10265725, 9364591, 10028149, 10503613, 11126153, 12363137, 10610149, 10421737, 11314469, 10716467, 9815353, 10503439, 9372979, 12363125, 9372997, 11273891, 10503865, 12265121, 10503817, 10249903, 9529045, 10512109, 9799375, 9545419, 9684517, 11347523, 11126357, 10716767, 10520449, 12240797, 10250149, 13027325, 10520569, 13027253, 10503985, 11331377, 12240671, 10053439, 12363521, 12240761, 12240755, 9791299, 9799537, 10250101, 10717361, 10553557, 9545815, 12273731, 10037635, 9791935, 10963337, 9783769, 9783745, 9882049, 10037749, 10045921, 9783553, 12273935, 10512667, 9775453, 9849181, 10037581, 12396887, 9865861, 9800377, 9783979, 10439389, 10513123, 11307755, 10513147, 12315367, 9652963, 12372515, 9775675, 10005037, 12372485, 12487169, 9906775, 12233323, 9783925, 13027883, 10373743, 10046389, 11307935, 10513303, 9800671, 9997285, 10627873, 10038073, 10504969, 10038055, 9808717, 9554785, 10546345, 10448059, 9784483, 10906663, 10628101, 10521625, 10538089, 9759811, 9841789, 9588175, 9416161, 12381647, 10530127, 9793159, 12340991, 12340985, 13340309, 9809611, 12938927, 12234301, 9440797, 10047067, 9801283, 10366537, 11251265, 10579891, 10579897, 9809845, 11112425, 11333627, 10243897, 10342549, 9785515, 10522855, 12226795, 11292881, 10579975, 9843091, 10776995, 10506673, 9826729, 9744835, 9802189, 9802225, 9892111, 13341053, 10801427, 10776935, 11293031, 9769339, 9769609, 10777241, 10040023, 10539763, 11088587, 11088605, 11088593, 11236049, 9769489, 9843229, 10777151, 12374567, 9794113, 11088497, 9998917, 10039909, 9769579, 9778069, 11301785, 9778129, 9794515, 10040263, 10040317, 9778171, 10777547, 10007305, 11424565, 10515259, 10064647, 9753403, 9753385, 10031947, 9786589, 9819355, 11302091, 11236571, 9352207, 9802807, 11326481, 10613791, 9516121, 10507369, 9352261, 10778017, 11400601, 11212271, 12326381, 9360691, 9540949, 9360715, 9360733, 11212475, 11400893, 11302547, 11400941, 11400929, 10065601, 11556587, 11212325, 10057309, 9844303, 11310671, 11400797, 10819165, 10040929, 9820057, 10319749, 10926011, 11212673, 9795547, 11589605, 9861109, 11401007, 11401001, 9787165, 12326705, 9787237, 12531527, 10049383, 10573975, 11311253, 10049755, 10434775, 11581667, 11212841, 11556917, 10246153, 11663483, 13514753, 10565725, 12302783, 10901921, 9820573, 9656773, 13695413, 9632035, 10041691, 10516837, 12302663, 9763489, 9788077, 10517221, 10631929, 12450353, 10508803, 10050091, 10582555, 12450419, 9763453, 10508887, 9788311, 12532733, 10509253, 10042339, 12450599, 11574041, 9984859, 11574143, 10058935, 10632337, 10050781, 10501351, 10034377, 9796837, 12426437, 10960091, 10034407, 10894373, 12540947, 11336819, 10509379, 10779721, 13614143, 13024715, 9354667, 10501585, 10509625, 10034467, 11050259, 11296097, 10820989, 13171985, 10788169, 11361971, 11026175, 11484917, 9830119, 11296469, 9854479, 10042885, 10083901, 11304449, 12426857, 12385877, 12426821, 10403713, 9838513, 9600979, 11149289, 11149307, 10502131, 11329481, 11484989, 11345717, 11026229, 10632967, 10043185, 9445219, 9773209, 11395259, 12239009, 10977437, 10567891, 9576499, 10551301, 11395175, 9986125, 12345431, 9355363, 9478243, 10371517, 12288479, 9609535, 11149595, 11444549, 10076515, 9568621, 10797701, 9380521, 9593563, 9634501, 9519841, 9634333, 9568801, 10797593, 10248739, 10248793, 10797659, 9511825, 9503671, 11535125, 9855829, 9388897, 10355569, 10937477, 9684139, 12289265, 10626295, 10814663, 9512167, 9577705, 10503235, 10937771, 9586099, 9422251, 10339819, 12289295, 10036513, 9356965, 12289673, 10585831, 9553633, 9512677, 9545233, 9561631, 10405459, 9447007, 9586249, 9954889, 9569917, 11388511, 10249831, 9783283, 11511761, 10372873, 12347159, 10512151, 9979723, 9488203, 10372981, 9529195, 9529501, 9586861, 9472219, 10356943, 12290255, 9766957, 12290165, 10889297, 10627549, 10783027, 9513289, 9505141, 10971481, 9505459, 10357429, 10390183, 9579223, 10799861, 11397827, 10824241, 9497095, 11069957, 9849403, 10365475, 9431947, 9587593, 10922939, 10357693, 10578823, 10300369, 9505729, 9358309, 9358111, 10242823, 10570507, 10242901, 9513853, 9366391, 12217529, 9522403, 10923221, 10259473, 10996799, 9497653, 9505825, 12422255, 9563215, 10923101, 10489321, 10767821, 10800587, 10767827, 10767671, 12447005, 10947959, 9506167, 10497367, 10808671, 9563779, 10366663, 10333945, 12217891, 9809467, 10767983, 9948745, 10923593, 10366567, 9555871, 11317181, 9768889, 9351103, 9859039, 9785281, 10768349, 9515191, 9547945, 12234995, 9466075, 12234983, 9523435, 11104283, 9515047, 11317265, 9736285, 12234863, 9646189, 12423611, 12235145, 13373941, 10318297, 9490909, 12235241, 10973645, 10318309, 11317559, 9515299, 12235115, 10359109, 10801493, 10572451, 12235439, 9351829, 12235397, 10359505, 10359523, 9769567, 9507739, 10974125, 9565099, 10490779, 10785691, 10245085, 9589711, 12235733, 9548773, 10367977, 12227359, 11506559, 12235631, 12751661, 9516211, 9499837, 10360021, 10581235, 9524431, 10695893, 11424977, 10015765, 10695743, 9499711, 9507883, 9524293, 10581061, 10900553, 10581073, 11383901, 10360213, 10589683, 10507735, 12326147, 9794905, 12236105, 9450859, 10368661, 12236465, 9467521, 9467527, 9500371, 10786513, 10376713, 10245637, 10384933, 9500227, 10270279, 9786991, 11433557, 9459601, 9557941, 11392925, 9590701, 9476077, 10360633, 11392865, 9500509, 10508155, 11392883, 11393159, 11393153, 13514993, 9812221, 10770635, 12236843, 12220453, 9500725, 10369105, 9353305, 10360957, 10393993, 12237185, 9517525, 9501145, 11385319, 9558517, 9755107, 10557913, 11393489, 10557751, 9361687, 9648421, 11393369, 9501031, 11393705, 9878149, 9534085, 10361587, 10894025, 10779199, 10050103, 10492525, 10975829, 11090849, 10771331, 12237821, 10574791, 9518077, 10574629, 10427227, 9345907, 12336269, 9510139, 10362097, 9583633, 12344339, 10493041, 10501237, 10796453, 9551257, 10796465, 9444745, 10993031, 10796435, 9502165, 10501615, 10976765, 10362367, 11451695, 9829681, 10796309, 9444649, 9493843, 9559369, 10370371, 10354039, 9559423, 9428347, 10362217, 10370719, 10509997, 10796729, 12304127, 9961165, 9494041, 10575409, 9510403, 10788355, 12418565, 12312185, 10837601, 10968683, 10378831, 9346645, 10796615, 10837597, 11149241, 9469837, 9551803, 10796945, 10796957, 10436545, 10362817, 9502711, 11395031, 9494287, 9535291, 10796927, 10362727, 10379413, 9953467, 12517631, 9584845, 9986281, 10698767, 10838129, 9363559, 9584767, 11100245, 10387855, 10772873, 9585067, 9527797, 10625491, 12337601, 10862897, 10838321, 10772741, 10895621, 10035499, 10379557, 9527599, 10527007, 9888085, 9584983, 9888079, 10838393, 10379647, 11067731, 9970315, 10076845, 10461859, 10003153, 9577159, 10437373, 9970423, 11059769, 9847303, 12321323, 9576973, 9585211, 10379821, 9962023, 9585235, 9355843, 9560671, 9577057, 9912943, 9962395, 10388359, 9929665, 9962491, 9855973, 10355689, 9962257, 10560259, 11109149, 9364273, 10896233, 9577291, 10773317, 10543963, 9528475, 12313763, 10478773, 10380529, 9553129, 10773551, 9569311, 12264449, 9585745, 9978973, 12264527, 9528427, 9594259, 9348499, 9528757, 9536983, 9971197, 9954793, 10151197, 12322081, 9938185, 9577789, 11175185, 9577801, 11576657, 9963145, 9602695, 9963139, 11044535, 11396843, 10249963, 10815011, 9635329, 9578071, 12305987, 11397029, 9979795, 9848731, 9226141, 9578371, 9988063, 11397071, 10078015, 10397497, 9578359, 11396951, 11397311, 9357463, 9586831, 9578677, 11454701, 9898195, 11454689, 9849025, 9578731, 9865453, 10512391, 11397137, 9857107, 10381387, 9349519, 9660817, 9865603, 11463149, 9587191, 10897859, 11045315, 10799393, 9586969, 10439005, 9865555, 9980245, 10045771, 10037569, 9472369, 9587047, 10799789, 11577989, 9554653, 10554097, 9554629, 9357853, 10799627, 10390111, 10054237, 12339833, 10799729, 9497161, 10381951, 10897997, 10898003, 9529963, 9513583, 10390429, 11455397, 11398019, 12520433, 11455487, 10259401, 12217325, 10243057, 9432055, 9645037, 11397917, 11053853, 9685849, 10603381, 11242637, 9587893, 10357969, 9932023, 10628299, 9964771, 9767953, 10300435, 10390537, 9579529, 10464307, 12307463, 11045987, 11398243, 11463803, 11275693, 10800551, 10579339, 12307955, 9571801, 10038727, 9932065, 9694873, 9768577, 9588403, 9842359, 9785011, 9858727, 9866971, 9588421, 9776887, 9940723, 9572065, 10440235, 10038823, 10522237, 10588045, 9596881, 11399147, 10407931, 9867031, 12308285, 9580315, 11398943, 11104121, 9588595, 10383511, 9957547, 9367759, 9990343, 9982201, 9859327, 13103171, 12767327, 11047325, 9589165, 9720277, 10473943, 11071973, 12227053, 13111721, 9966061, 11038997, 9359725, 9359737, 9581185, 9368209, 9581239, 11113199, 9859777, 9573061, 10375927, 10777307, 9581083, 9998851, 11080205, 11424341, 9581167, 10924931, 10400689, 11080601, 10384345, 9720769, 11318213, 11072297, 9581341, 11318075, 11072285, 11457299, 11318141, 9581431, 9573247, 10925225, 10572955, 9614509, 10433749, 9344233, 9565411, 10245151, 12227641, 9360409, 9737263, 11318375, 11424869, 9942133, 10572871, 10572883, 10589575, 11318687, 10581475, 9967099, 11105735, 10474981, 10073575, 10073359, 11556113, 9794887, 9590425, 9959047, 12351151, 11466389, 10049233, 10581541, 9598477, 9967165, 9860701, 10507885, 10360441, 11064899, 10425961, 10074037, 9590731, 9820159, 9885673, 9959293, 10483855, 9648337, 9361639, 9713719, 11040773, 10754129, 9959533, 9353641, 9353677, 10402099, 10025305, 10533187, 9664891, 9640585, 12237473, 9960103, 12237557, 10017481, 10500859, 10509055, 10877639, 9411301, 9960163, 10025527, 10377805, 10467943, 9353845, 11107217, 9354163, 10255327, 9968635, 10533835, 9550819, 12548921, 11180831, 9378685, 9567079, 10894171, 9559195, 9534619, 11074697, 9977017, 9526453, 10378423, 9641179, 10771697, 9600199, 12238061, 10771463, 9354277, 9591865, 9567277, 12237947, 10034257, 10034251, 9968707, 9559159, 9575521, 9960853, 10378711, 11066873, 9944545, 12238091, 10771811, 10378573, 9583945, 10895009, 10772141, 9969301, 9723523, 9371281, 9969343, 10772111, 10772117, 10894997, 10428127, 12345059, 10591951, 10984993, 10772039, 12238415, 9953161, 11296645, 9584545, 10821523, 12238847, 10985453, 10387399, 9986017, 12345149, 13672277, 9723679, 11042597, 10772279, 10895129, 9576277, 9576283, 9617245, 9576289, 9986197, 9519247, 10797191, 10797197, 9519265, 9552037, 10952861, 11378891, 9593083, 10436839, 10788925, 13852769, 10387501, 9855013, 11395097, 9510955, 9551917, 9592879, 9494611, 9576571, 11395163, 10797149, 10412479, 9642421, 10797461, 10994147, 9519379, 10617121, 9552151, 12419375, 11075891, 9830725, 9380215, 9642643, 9511573, 11395763, 10797767, 12419783, 10797605, 9871879, 9560629, 9347623, 10797599, 9511471, 9347677, 11592293, 12264029, 9511819, 9651121, 10372093, 9855997, 10560475, 9962467, 10248991, 9773851, 9855781, 9519913, 10543987, 9855817, 10896221, 9962701, 10372297, 10798289, 10372117, 10372099, 9372721, 10265677, 12264539, 11412559, 10617931, 11002967, 10503253, 10814891, 9741787, 12240365, 10700255, 9586159, 9938281, 10798427, 10995365, 9569929, 10372741, 9561781, 9447079, 11028203, 9529057, 10503895, 9512473, 9586183, 10618393, 12240503, 10937969, 9963121, 9856639, 9512545, 9569893, 9488275, 9619387, 12421001, 9447175, 9979663, 12420899, 9570133, 10037089, 9513115, 9562255, 9349291, 10315963, 10758367, 10315813, 10782745, 12560507, 9365899, 9570751, 9644497, 12372449, 9947407, 10758463, 10758499, 9595249, 9521533, 11078279, 10422823, 10799717, 13519361, 9906757, 10381891, 9644659, 10578919, 9767899, 10251247, 10251241, 10291969, 9521977, 10242853, 10980185, 10800269, 9391339, 10243297, 11062319, 10374157, 10374151, 10578955, 10349617, 10890251, 10415209, 10784185, 9571747, 10374571, 9522625, 9514483, 9514489, 11062583, 10374475, 10980731, 10890575, 10055317, 11439851, 9858763, 9973477, 11013653, 11038331, 11021897, 10579537, 9514597, 10891175, 12292025, 11448209, 11014091, 12308447, 10989359, 9522949, 9563947, 9564001, 12292265, 9965785, 10768583, 10768577, 11514053, 9548011, 10063903, 9555979, 10342435, 10891385, 9965683, 9523327, 9465955, 11317331, 10957241, 11424149, 9515473, 12341701, 9367819, 9548113, 11424107, 9515353, 10613107, 9621865, 12243271, 9515665, 9515659, 12219037, 10031785, 9417421, 10466005, 11317985, 9523915, 10465987, 10892027, 9966325, 10392289, 10367575, 10760815, 12235331, 10769339, 9565105, 10949525, 12235655, 12235775, 12235721, 9565159, 10572601, 9958153, 10384189, 10253101, 9941803, 10244977, 10056553, 10769573, 9557143, 9442459, 9688195, 10351753, 10769543, 10581247, 9827557, 9958627, 12235817, 12235805, 10425397, 12235787, 12235781, 11531375, 10359889, 11007095, 10253389, 10253377, 12235859, 10073491, 10761725, 9524725, 9573871, 12236069, 10794247, 10360123, 9549091, 12236033, 9590083, 10376527, 9409879, 12236117, 10433893, 9574075, 12236435, 10376887, 11015825, 10466833, 9623053, 10982939, 9590353, 9786973, 9344617, 10246045, 12236711, 9492385, 10893203, 9672619, 10377169, 12236783, 12326873, 10057711, 9549805, 9631489, 9959179, 10893071, 12220279, 9475957, 9549673, 10336405, 9509047, 9869503, 10614925, 9951403, 9361585, 9615571, 12237053, 9943261, 11450615, 11221037, 11442209, 10614835, 10991681, 9361513, 9509251, 9836929, 10394029, 9517555, 9566473, 11319563, 11000081, 10893593, 9550177, 9591139, 9648481, 10361503, 11557535, 9616033, 9575149, 10369555, 12270095, 10066525, 11033189, 9968533, 9517963, 10771343, 10476499, 12295109, 9558805, 9435913, 10574653, 9567031, 13081463, 10992491, 10378063, 10992497, 9550663, 9567097, 10460011, 12344501, 9665713, 10583269, 9551065, 12426473, 9551083, 9952279, 10509313, 10370107, 9550885, 9509965, 11664467, 12344405, 11394113, 11394473, 9428383, 9518467, 9526771, 9936373, 9960949, 9526765, 9551113, 12344603, 10370707, 12754669, 10370737, 10370779, 10985201, 11484881, 10378759, 9510463, 10894955, 10518133, 11394683, 10075753, 13025237, 9363355, 12435343, 10993643, 10371013, 9551863, 9510907, 9584623, 10370863, 9953113, 11435849, 11394887, 9559915, 10412167, 9609355, 11501699, 10952951, 9953509, 12239045, 12238895, 11149367, 9609259, 9723949, 9642025, 9863209, 9977947, 10862717, 11133017, 12239291, 10387861, 9380251, 9986437, 9347509, 10838501, 9904411, 10715441, 11149583, 11125007, 10862861, 11207009, 9380179, 9363817, 9372325, 9355939, 12362369, 12239609, 10838753, 11404009, 10437325, 9347803, 9372397, 9429733, 12239369, 9650773, 10838639, 9355861, 9347695, 10699355, 9519727, 11133527, 9978769, 10011541, 10953653, 10019773, 9986983, 9642955, 9987013, 9929713, 9978853, 9978637, 9405217, 11248499, 9503587, 11134127, 9979021, 12264611, 9979015, 10405051, 10716299, 12264587, 9618643, 9856219, 10609903, 9741505, 12264665, 12264659, 12264653, 9667813, 12264647, 9979111, 9585691, 11134073, 11142563, 9643393, 9627019, 9856447, 10585483, 9856423, 9987493, 9528769, 12264929, 9594355, 10773953, 10773971, 10773983, 10609963, 11126069, 9569599, 9422113, 9856303, 9840319, 10585759, 10774259, 12314333, 9348853, 9635347, 10585639, 9627223, 9528907, 10626625, 10258033, 10774109, 9979807, 10405765, 9971647, 10397647, 9979843, 11315137, 10774481, 10258183, 10774331, 10012471, 10815263, 11167505, 10307743, 9619597, 13748459, 11085971, 10594537, 11110649, 10070221, 9676999, 9357529, 12339431, 10594501, 11118797, 9865465, 9865447, 9488617, 10700849, 9775111, 10774589, 10594309, 9980029, 9357721, 12323237, 9349525, 11135363, 9865681, 10013125, 9865495, 9775387, 9980161, 9865507, 9472381, 9357667, 10414447, 9513607, 9644683, 9628321, 9382603, 10939127, 9366253, 11209427, 10021399, 10267189, 10406455, 9349693, 9513565, 9636445, 12315233, 9349747, 9620371, 12217267, 9366403, 9366427, 10406827, 9366487, 10800077, 9767929, 9751321, 10939187, 9554695, 9530173, 11398379, 10480891, 9653503, 10800341, 11136209, 9563191, 9563197, 9767977, 11177033, 12217415, 10251679, 9637303, 10251697, 10579345, 9440713, 9645541, 10251547, 10071313, 12406063, 10267951, 12217607, 11398505, 11144549, 9530689, 9588037, 10579285, 9629341, 10612405, 10579645, 9457333, 9629371, 10800779, 9629347, 9670357, 9703159, 9645793, 10497583, 12455449, 10604047, 9973333, 10571353, 9596809, 9613231, 10252231, 9990085, 9981943, 9654037, 12234521, 10055485, 9858859, 10399573, 9351307, 12316829, 10408135, 9654289, 11399207, 9531421, 9981967, 11120651, 9351229, 12333161, 9465979, 9982057, 11399249, 9367945, 10006933, 10899881, 12530095, 11129225, 9351619, 10498507, 12316991, 9875743, 9990415, 9875767, 10424629, 9507175, 9613675, 9367921, 9646741, 9630385, 10392235, 10392283, 12301045, 9360085, 10900163, 9360097, 9490981, 9359929, 10449493, 9613933, 9614209, 11129777, 12301187, 9524143, 10253275, 9384943, 10900271, 12227365, 10023739, 12301085, 9376573, 9360187, 10392361, 10384237, 10376041, 11121491, 10925219, 11400359, 10622143, 10925207, 12301445, 11154671, 9639115, 10261507, 10417207, 13759523, 9426037, 9581959, 9794959, 9590197, 9614767, 11130365, 9811405, 9590269, 9623023, 10507555, 10925357, 10704173, 10573105, 9639169, 9655639, 9655621, 9409897, 10245499, 9614719, 10925399, 9409909, 10409623, 10409617, 13514459, 12318371, 9975427, 9606799, 9983623, 11220623, 10598023, 9590437, 9950965, 9615073, 10598101, 9598495, 9975301, 9590323, 9639481, 9967195, 9778771, 9860677, 9623167, 9533317, 12326801, 9533347, 9631663, 9836539, 9533419, 12220357, 9639709, 10524469, 9975565, 9975613, 11499371, 9951067, 9984157, 11540639, 10393855, 9459763, 9869365, 11507741, 10475635, 9648253, 10402195, 9517447, 9517453, 9361825, 9615871, 9828835, 9345289, 9345283, 10385665, 9369907, 9984295, 11123069, 9632395, 9640591, 9984703, 9640621, 9353929, 11459297, 11197151, 11459129, 9353773, 9615931, 9533995, 9370195, 10304101, 12229189, 11385787, 9903025, 10009591, 10370023, 9755425, 9354073, 11139959, 9902971, 9395059, 9641089, 10615939, 9567403, 12229877, 9977035, 9993415, 10394851, 10402903, 12237931, 9944497, 9346483, 11124173, 10624465, 9985507, 9633049, 10706183, 11140367, 9592117, 9575743, 9403681, 9977203, 9985399, 9944419, 10403533, 9600715, 10952441, 11181773, 10542793, 12238541, 9543169, 9960961, 11124233, 10346041, 9461293, 10485325, 9633397, 10493515, 9600637, 10411927, 9486235, 9535363, 10395553, 9625561, 9535435, 12238817, 9625549, 9863155, 10600393, 9773029, 10256191, 11583263, 9633649, 9658213, 9978037, 9978031, 9978073, 10862819, 9535693, 12239057, 12918971, 9625615, 10567807, 12271697, 12239273, 9863557, 12550571, 12239279, 9511309, 12239255, 10953113, 12239327, 9535993, 13517219, 9978163, 10060105, 10862969, 9650533, 9519775, 9642625, 12345995, 12559103, 12239579, 11215553, 10019575, 10035733, 9642511, 10396207, 9650779, 12345965, 9634423, 12239453, 10396279, 10035829, 9757285, 10765201, 9348019, 10421215, 10265545, 11191283, 10986455, 9987049, 9765871, 10953689, 12239675, 9642769, 10298113, 9675571, 12239627, 9962287, 9986905, 9364315, 10838849, 10028185, 10405009, 10249393, 9856165, 9675979, 12338405, 10986749, 12330215, 9585673, 9634831, 9643063, 12231691, 12239981, 9643081, 10404985, 9651307, 10257811, 10372495, 9938353, 12240269, 9553327, 9856477, 10708469, 9856501, 12264767, 12264737, 12264731, 10061089, 9635119, 10249555, 9643669, 10708655, 9856705, 11224781, 9643759, 10561063, 10954253, 10585621, 9610795, 9856555, 10954343, 12363389, 9651805, 10331725, 12224065, 10348441, 11143097, 9979837, 10250203, 10774511, 9873355, 11159489, 10340125, 9643813, 10446673, 10954613, 11495261, 9463663, 10422427, 11110529, 11184257, 10954889, 9636007, 10004653, 12560513, 12232939, 10774781, 10406083, 9652429, 10774721, 9857275, 10438681, 9644053, 10774541, 10774559, 10496101, 9742405, 9644155, 10774955, 10422745, 10004929, 9636349, 9971971, 9627955, 9644329, 10004857, 9636223, 9849193, 10955429, 10406557, 9513631, 11086523, 9890491, 10955519, 10472131, 9644797, 10775261, 9349879, 9644563, 9374209, 9349633, 11405833, 9644605, 10062391, 10029613, 9906721, 10775069, 11184761, 10472011, 11176565, 10005109, 9636757, 10292113, 10775477, 11160503, 11160557, 11086817, 9800653, 10955771, 9653233, 10775489, 9636847, 9366295, 9382717, 11144045, 9825151, 10775375, 9563287, 13823195, 10439815, 9645241, 11177207, 9637069, 10415335, 11160785, 12561469, 9997339, 9636919, 10423351, 10529815, 9997411, 9588115, 11505053, 9989629, 9637357, 11169065, 9391399, 11160839, 13151591, 9637153, 9637165, 9588049, 9645397, 10251589, 10579327, 10800455, 10071409, 11112113, 9973429, 10399393, 9662167, 11407081, 11579129, 9973447, 9572083, 9654007, 10702379, 9948757, 9637447, 10800761, 10334107, 9703303, 9596845, 9859027, 9981937, 9613063, 9957175, 9711421, 9613117, 9645871, 11399021, 11399009, 10399567, 11399027, 11145347, 10399921, 11505809, 9654481, 9965761, 9662491, 9982003, 12447845, 10588249, 11399603, 9368005, 10457539, 9368041, 10072567, 9990637, 10252561, 9744667, 9982285, 9351535, 9351529, 9982609, 10564231, 10506907, 10900121, 12423935, 9376453, 9351877, 9351889, 10621645, 9368305, 10465843, 10318417, 10515013, 10449523, 10376095, 12301247, 9647005, 11424671, 10384303, 12301193, 11260829, 10384351, 11580389, 10515445, 9925603, 10777565, 9524203, 9925609, 11383609, 11408185, 9360151, 9368359, 9360163, 10900241, 13521677, 10777457, 10900349, 10900307, 11424593, 11064485, 9983143, 9385165, 9639127, 9639157, 11515097, 9925651, 10900529, 10253317, 9925687, 13522043, 12424295, 9573481, 10261603, 9434509, 10245529, 9409927, 10409353, 10245565, 12424607, 10352053, 9541027, 11163029, 9983443, 9991639, 9991669, 9639421, 9852397, 11507153, 9991465, 9631057, 9590431, 9860743, 10245805, 12220153, 10508005, 10581757, 10049275, 9664249, 9860857, 10581715, 12424763, 10417675, 10630681, 9770563, 12301907, 9647743, 9934447, 10245733, 9860719, 12301895, 10901399, 9975715, 9983953, 11319293, 9631687, 10631113, 10270489, 10409755, 10622761, 9950983, 10581781, 9991969, 11319143, 9828187, 9639751, 10753871, 9984187, 10393783, 9959611, 9648319, 9648373, 9648355, 10623193, 9959659, 10450975, 9869437, 9984103, 10008961, 9984391, 9533857, 10844563, 12450287, 12302807, 12319019, 11507975, 9992503, 10393945, 9984325, 10762573, 9632107, 10402147, 11188901, 9362077, 9779935, 9878221, 9984763, 10050301, 9804319, 12319277, 9779725, 10811965, 12302861, 9648745, 9354121, 9903001, 9632641, 9354139, 9632653, 9640885, 10410925, 12344197, 9919447, 12450815, 10255351, 9534463, 9640723, 9509653, 9353995, 9632521, 9354001, 9648955, 10025779, 9993013, 9354043, 10074991, 9985183, 10280083, 9936001, 10575037, 9673939, 9526495, 9526525, 10075165, 9370633, 9378871, 10419283, 10075207, 9550927, 9550969, 10402921, 9641065, 11222443, 9354649, 9657763, 9838033, 9993673, 9690565, 11197919, 9526585, 10493299, 10411339, 9346393, 9534793, 9592141, 9584281, 12222121, 10264201, 9641611, 9682609, 9641659, 11329223, 9969379, 10075669, 11484779, 10264183, 9732031, 10067935, 9625543, 10600441, 12238823, 9994237, 10075927, 11214641, 12328739, 9649957, 9625429, 10354513, 9625411, 10592095, 10322089, 12542171, 9650425, 10068205, 10567693, 10600465, 9691201, 11001941, 12222907, 9658759, 10076545, 9994681, 9748915, 10862987, 9494947, 10953119, 9978139, 10723631, 9699631, 9724207, 9535861, 12271955, 9511291, 10412395, 12239537, 9683587, 9519811, 12239585, 12239573, 11125289, 10863137, 9658933, 12337691, 9364009, 10043947, 9355837, 10953245, 9912919, 12239471, 12345947, 10412953, 11436977, 10453933, 9372619, 11436995, 10396447, 12321581, 9405211, 10838855, 10003609, 9667729, 10953863, 10953857, 12240011, 10249423, 9348109, 10019857, 10003465, 9774091, 10003519, 9987181, 9569713, 12322295, 9651703, 9372931, 9856261, 12264809, 12264779, 10954079, 10512019, 10413763, 10954301, 9725851, 9988057, 11192111, 9635605, 10454827, 11249513, 9684829, 9463651, 9758869, 12331193, 9988231, 9676969, 9644239, 9668815, 12560603, 11331779, 9627673, 9644065, 10758271, 10414483, 9742777, 11504027, 13068797, 9996745, 9374173, 9660913, 9374185, 9865723, 9996769, 9865705, 10078483, 10316089, 9988405, 10316083, 9357601, 10709357, 9668965, 9513637, 10283725, 12233233, 9783901, 9628255, 10939307, 11512709, 9915355, 10775333, 11504429, 10939139, 9546541, 9653059, 12462947, 10070911, 10775363, 12225355, 10939217, 10021729, 10955951, 12217523, 9800887, 9997477, 10431691, 13028507, 10775651, 9366649, 10579369, 9989521, 10579375, 10014139, 9989575, 11169221, 10407187, 10693907, 10022185, 10710377, 9719119, 10358137, 11169455, 9858805, 9654013, 9653815, 10759705, 10800737, 10251847, 10530373, 9948793, 10800731, 13479817, 12398573, 11513705, 9670465, 11161457, 9867121, 10612555, 10588345, 10399915, 9990319, 10457281, 9859321, 9629725, 12218413, 11112497, 10514437, 11178107, 9859147, 9670771, 9670777, 11145635, 9990547, 9621919, 9859465, 10506649, 9351643, 11399627, 9720307, 11170247, 9998827, 11178449, 10432993, 10064155, 11399459, 10023169, 11399429, 11145473, 11505923, 9761071, 9654613, 9982303, 9744733, 9982327, 10432873, 9646447, 10621609, 10564327, 9663199, 9360067, 11145935, 9351691, 9351685, 9531907, 10433083, 9671209, 12325493, 11424683, 11424677, 9991063, 10621879, 9663421, 10408879, 10449829, 9360325, 10408915, 10695661, 11424755, 9524209, 9360157, 10441525, 9360199, 10261651, 9999499, 9655465, 9655471, 10900733, 10925249, 9655309, 10589629, 10900961, 10261993, 11163089, 12301601, 11162897, 10925339, 9352525, 11064689, 9663859, 12424541, 9434491, 9991525, 10573453, 12326645, 9590467, 12302063, 9656005, 9860851, 9590527, 12302021, 9991765, 10573435, 11261513, 10622887, 9992095, 9615289, 11319281, 12408637, 11212607, 12302093, 9819985, 9811789, 9992059, 12449615, 9680737, 9869443, 12425345, 9681091, 9640141, 9648145, 10623031, 9992197, 9975883, 10475587, 10631563, 10402255, 9361885, 10000687, 10402123, 10017145, 9730405, 10525015, 9345721, 11197169, 10705607, 9370345, 12319295, 10500661, 9894469, 9984619, 9992803, 9993097, 9722803, 10877837, 12319637, 11230097, 9673705, 11287301, 11164445, 9435991, 10754899, 11164847, 9550987, 10624141, 10452223, 10509517, 9919513, 10370065, 11164697, 11050007, 10493029, 12426359, 9346141, 9649537, 12320237, 9444853, 9993703, 11197733, 9403669, 10927363, 9592147, 9649525, 11025755, 9592165, 9772393, 9657991, 9617059, 10428121, 10034911, 13639303, 10559185, 9715201, 10452487, 11173391, 10010173, 9961021, 9584215, 9674701, 10067947, 10411801, 10075915, 10411783, 10624771, 10518295, 10624885, 10411897, 9600871, 10772657, 9863341, 9863389, 10502383, 10510585, 9863371, 9355501, 10027039, 10838069, 9953287, 11018297, 10502197, 9363481, 10838027, 10960919, 9666643, 10772603, 10035325, 10862669, 10412131, 9380245, 10379653, 12239249, 9961909, 9347533, 10387921, 11076041, 9585145, 9953599, 10387789, 9585001, 9429721, 10945231, 10617385, 9773569, 10486375, 9560977, 12239773, 9855967, 11461607, 11396045, 11396063, 12231623, 12600191, 10863443, 10249057, 11396237, 9528505, 9962707, 11183147, 9348115, 9552937, 10503271, 9577597, 9938359, 11388301, 9979303, 10773989, 10814945, 11036153, 11552225, 9954805, 11036099, 9585937, 9561373, 9692425, 9528667, 12600589, 9831769, 9577855, 9856357, 10774241, 12297971, 9561823, 10798787, 10798637, 10618411, 10815029, 11462207, 10388995, 11453975, 11208215, 9979483, 9987679, 12265061, 10798673, 9570181, 9578419, 10078129, 9775069, 10381267, 9963511, 9799657, 9603055, 9946897, 11527973, 9463561, 11142961, 12314405, 9594673, 10798859, 12297989, 10348369, 9570451, 12421295, 9652423, 9570511, 11077853, 9586927, 10012735, 11044865, 9963553, 9848917, 9357385, 11397239, 9963955, 10373599, 11020745, 10799561, 12224821, 10799363, 9627961, 9775417, 10381657, 9570673, 10373497, 9562477, 9562753, 9587329, 10799759, 13732589, 11053775, 9964045, 9579133, 11029385, 9989083, 9964489, 10300399, 9964297, 9349915, 9562921, 11062457, 11463917, 10063057, 9628879, 10898647, 9555181, 10578991, 9956443, 9595999, 12299345, 10423411, 10374553, 12307877, 11357597, 10604005, 10374613, 10374421, 10562875, 10759525, 9858715, 9555589, 9957049, 9957031, 9563815, 9957073, 9957061, 9973453, 9866953, 9981679, 10366483, 9965059, 10481239, 9956953, 10407541, 11112365, 9949117, 11136995, 11423729, 9564157, 12447683, 11022083, 9563995, 9867115, 9564319, 10760371, 10514569, 9875701, 9605359, 9556021, 9588799, 9482323, 11030603, 9588859, 9572455, 10006939, 11301287, 11424179, 9368017, 10375675, 10383673, 9662755, 9573019, 10777277, 9966241, 9966283, 11113205, 9581287, 11399723, 10318357, 13521509, 9515935, 9966469, 10384309, 9401251, 9565141, 10474447, 11318267, 11146187, 11031509, 9966367, 9556747, 9966343, 11318045, 9524059, 10376401, 10925311, 11318465, 10245349, 10245145, 10982461, 9557077, 11261003, 10384495, 9598363, 11048339, 11384311, 11449823, 10073569, 10900751, 9557287, 9639211, 10376539, 10073821, 9582283, 12252883, 9541375, 9844285, 9582115, 10524259, 10032709, 9525121, 9762769, 9557953, 9779137, 9959413, 10508227, 9558007, 9574369, 11089691, 9951013, 9525073, 12236981, 9959557, 9984139, 11139229, 9369793, 9525451, 9566413, 9558271, 9639943, 10377307, 10754171, 10377331, 10074211, 12237239, 12450203, 12237191, 10009051, 9968125, 10041835, 12237263, 9967897, 9533725, 9566515, 9353509, 12237167, 9582967, 11032925, 9960085, 12237497, 12540659, 12237511, 10893863, 12237341, 9558613, 9566815, 10771013, 12237407, 12237395, 10378129, 9960409, 10255309, 10066735, 12237581, 10074913, 11377535, 9714511, 11033459, 9575245, 12237659, 11377481, 12237995, 10771637, 9378979, 9960661, 9403621, 9968683, 9559123, 9935953, 10263949, 12238139, 11476265, 10288411, 12238121, 9715033, 10493617, 9567991, 10772177, 12303911, 9346621, 11017835, 10960511, 10632829, 9567859, 11050571, 10583635, 9961363, 10575853, 11018183, 10313707, 10067839, 9977707, 11452247, 11395235, 10617067, 9494755, 9552103, 9519121, 12271673, 12255271, 9363475, 12517475, 9519229, 10526803, 9355663, 9593239, 9732511, 11395463, 9527713, 11395547, 9511213, 9781597, 9568585, 9519481, 10838711, 10044043, 10896011, 10617493, 11453081, 12296837, 9347815, 9536251, 9528043, 9871897, 9503233, 9626125, 11395589, 10584679, 11436665, 10560079, 10412647, 10798007, 10797965, 10355659, 11396087, 9356245, 12264395, 10372075, 10248967, 11059979, 10552165, 9855871, 10372255, 10798229, 10798235, 10798295, 10052845, 9577489, 9413671, 10077223, 12239957, 11453531, 11142629, 12223939, 10798391, 9422137, 10798361, 10618141, 9373015, 9856363, 10438303, 11003561, 11470523, 10798727, 11445977, 10798625, 11027981, 9553441, 12338807, 11396723, 10372717, 10798685, 10372993, 9529249, 12421067, 11020247, 10004239, 9529099, 11061047, 11454221, 10938137, 9480031, 11004071, 9767065, 10373263, 11397263, 9849019, 10815529, 9570349, 9570379, 9848905, 9529471, 9611389, 9848935, 9554023, 9497017, 10398151, 9963805, 9513253, 9980251, 9554251, 9554293, 9562489, 9554569, 10373821, 9349663, 9865729, 10627693, 11029115, 12298853, 9792433, 9571255, 10242997, 9579457, 11004713, 10799981, 9628825, 10693823, 10357927, 10366159, 11013341, 10251289, 10251277, 10357771, 10259461, 10579003, 9202711, 10357813, 9563179, 11005037, 10374559, 11013539, 9416083, 9416119, 10038733, 10604023, 10776031, 9580009, 9841921, 10366255, 10579225, 10571125, 9530743, 11464325, 9612961, 9989833, 11464415, 11448023, 9547501, 9555583, 9613213, 12218281, 9768847, 10342363, 11055089, 12308435, 9351157, 9547759, 13520735, 9547531, 9858877, 10399537, 9580321, 9351025, 10956983, 9506995, 11219177, 9564403, 11423945, 10924247, 9875695, 10711057, 11423813, 11497919, 10383799, 9687457, 9556399, 9597385, 9875749, 9957727, 10146127, 11317931, 9515707, 9515731, 9564883, 9515767, 9523963, 9589483, 11317835, 9638509, 9548695, 10572721, 10892165, 9548755, 10048465, 10892237, 10892243, 10949435, 9360175, 10998917, 9524389, 10892513, 10769635, 10351813, 9622777, 13128871, 9548803, 10261519, 12235801, 10286137, 9991201, 12424319, 10999175, 9991615, 10696079, 12236171, 10892771, 12236279, 10892765, 10769681, 10622233, 10351945, 11015549, 9557323, 10769741, 10696373, 9934465, 10073779, 10770167, 10770173, 12236519, 12236501, 10769969, 10769933, 9557563, 10614373, 9476011, 10770407, 9492439, 12236771, 9795535, 9558001, 10770179, 10753801, 9860923, 12220171, 12236663, 10417987, 10770245, 10770257, 9549979, 9566383, 9869527, 11000051, 9353455, 12237005, 9500905, 12236993, 9869329, 12236837, 12236831, 9525307, 9566269, 12236801, 12236927, 12236915, 9574525, 9558121, 9550225, 12237215, 9345445, 9574867, 12237299, 9525727, 9525523, 10574137, 9517363, 11000087, 10754327, 10877213, 10778971, 10377889, 10377931, 9632455, 11016923, 12294863, 9550405, 10377835, 10025569, 9591685, 13573103, 10877849, 10378201, 9346015, 9952207, 9984967, 11041757, 10771247, 9435937, 10509163, 11508605, 9583429, 12295001, 9550711, 11017025, 9984871, 11254955, 10378369, 11017451, 9575425, 10517527, 12237827, 9919531, 9378883, 10624117, 10378645, 10771895, 9551245, 11033999, 12295571, 10083757, 9461203, 10345921, 11337173, 11009333, 10894649, 12238109, 10984733, 9583963, 9583987, 10624321, 9944425, 10984793, 11075261, 9576103, 11009681, 11280107, 10411549, 11025967, 11443751, 11025995, 9526891, 9551773, 9518989, 10370947, 9469885, 11018129, 9568207, 9363427, 10510291, 9756655, 9568021, 9576199, 9527047, 11435791, 9568117, 9715579, 9584485, 11444057, 12345509, 9535681, 10862789, 9740515, 11460653, 10453015, 12238877, 10862603, 9642079, 12238949, 9650587, 10838453, 10838405, 10379725, 12239309, 10404127, 12239161, 9363739, 9511219, 9363769, 11092241, 9494869, 9380167, 9494881, 9347719, 9642691, 11141855, 9372409, 10429153, 9912859, 10387969, 9871927, 9749035, 11674219, 9601651, 11084363, 11215433, 10773413, 10773425, 10044349, 9388981, 10773497, 10839035, 10036195, 9388825, 11084573, 9347917, 10773359, 9388867, 12313451, 9856147, 12264629, 9667801, 9765937, 9438301, 9635203, 9635263, 10380721, 9831889, 9856465, 10012159, 10585363, 12264719, 10503451, 9856333, 9569653, 9594229, 9619159, 11093735, 9610945, 9946879, 9602785, 9651943, 9963247, 10774049, 10282507, 11396639, 9995821, 10790425, 11142779, 10438213, 10790845, 11175821, 9783229, 11118485, 9979813, 9766903, 10774487, 9963271, 9979705, 9463591, 9479983, 11093873, 9447289, 11094197, 12544247, 10004491, 9504829, 10496029, 9865621, 10037683, 9349537, 9636307, 9603571, 10381819, 10324465, 10406167, 11274545, 9865525, 9374017, 11094719, 11299505, 9767611, 9382561, 12585725, 9923281, 10799867, 9784039, 9382645, 10799657, 10799669, 9603595, 10373683, 10381867, 9382495, 10775459, 9530251, 9620473, 9366499, 11397905, 10799939, 10423447, 10243219, 9530497, 11398283, 9563137, 10800143, 11398145, 9972769, 10243165, 9407563, 9530461, 10898525, 9596371, 9629149, 11210195, 10898729, 9981241, 10243417, 10579279, 11398493, 11398829, 10276501, 9612943, 9596605, 9973417, 9596635, 10251991, 12422873, 9621019, 10612285, 9866809, 9948739, 10612315, 9957271, 10514341, 10391449, 10588081, 10588093, 10391539, 11063261, 9604891, 9867013, 9867019, 11398925, 10243903, 11497223, 9867043, 9596719, 9973627, 9637759, 10030945, 9351319, 9982117, 9965791, 9351367, 9646273, 9859267, 12251347, 9367777, 9367795, 10588207, 9965611, 10342489, 12226663, 9965665, 11096147, 9965671, 10621363, 10383757, 10383829, 12300791, 9359827, 9753073, 9359845, 9376225, 9621763, 9859387, 9982255, 10908007, 10383715, 10629787, 9917131, 9351919, 9884407, 10056433, 11424449, 9917155, 10924763, 11104769, 9974311, 10392157, 10506853, 9605707, 10572369, 11154365, 10032001, 9638797, 10924985, 10056637, 9524167, 10507225, 11260715, 12423983, 10277671, 9614161, 11105417, 13350113, 9622717, 10261669, 9614557, 11408591, 10466551, 13030583, 9991225, 9942109, 10261585, 9974857, 9426007, 10352011, 11318681, 9409993, 11064635, 10384699, 9385273, 9581905, 10573159, 10573135, 9639271, 12334403, 9590125, 11105927, 9623239, 11163359, 9967117, 9631291, 9860665, 9991735, 9639463, 9778735, 10385335, 10901405, 9975757, 11024345, 9885667, 10565419, 11319101, 10049293, 9533233, 10319677, 10606339, 9639775, 10770301, 10319683, 10049677, 10393777, 10246309, 10475731, 10901759, 9689293, 11221193, 9369835, 10328095, 9599005, 11155457, 12261385, 9869359, 11024459, 9599095, 11557313, 9345529, 12376349, 9533749, 10557709, 9345679, 10877621, 9984649, 9616015, 11270903, 10402543, 10951379, 10459879, 11459123, 11123213, 9345625, 10877519, 9353851, 9747049, 10877531, 12253765, 9378727, 12393437, 10509265, 10271725, 10075117, 10370017, 11492141, 9976603, 9771787, 9354067, 9976999, 9985219, 10574887, 9919519, 9600031, 10574851, 9567289, 11123735, 9550915, 9526339, 10009669, 9698407, 9600109, 12238229, 9960871, 12230135, 10337737, 9944527, 9977323, 9747739, 9575731, 11124083, 9624955, 11099459, 9961111, 11083427, 10387129, 11484821, 9584335, 10043131, 12426959, 9969163, 12238367, 10075729, 11484749, 9584251, 9985651, 12451393, 9486217, 9977731, 10264501, 11157407, 9625519, 9846739, 12238793, 12238787, 9862939, 10387303, 10797209, 9486367, 12288047, 10076221, 10444843, 10936427, 9486463, 12263489, 10060177, 9478567, 9494995, 10363387, 9355753, 9568741, 10887425, 12239123, 10346803, 10363171, 10887533, 10371403, 10355071, 11452757, 10248859, 10347193, 9487009, 9372343, 10887911, 12419825, 10797785, 9372205, 10297945, 9388615, 10289737, 10355599, 9634699, 11436983, 9929689, 12420083, 9364465, 10388287, 9478993, 10945403, 11092805, 9593995, 10888331, 10511383, 10372129, 10888295, 11428961, 9372757, 10347619, 10355809, 10929587, 12264863, 10339771, 10061239, 9520597, 10356199, 9495865, 10626325, 11437427, 9496285, 9594619, 9487927, 10364449, 9528919, 9487963, 9578107, 13026869, 9348733, 10249825, 9496519, 10504141, 9873385, 10766117, 10364689, 9480007, 10422139, 10766159, 10069879, 11315027, 9349285, 9480439, 9504787, 9824263, 10356793, 10315825, 10766345, 10356787, 9766999, 9472087, 9349231, 10766405, 11397193, 9349225, 10766411, 11110481, 9972097, 10766729, 10414513, 9349615, 10807771, 9480529, 9849175, 11471231, 10348879, 10324303, 10324345, 11004581, 9480871, 9964285, 10349287, 9366259, 9480721, 10570279, 9505309, 9480757, 10766849, 10365493, 9366073, 10766873, 10365517, 10767257, 9579475, 9489367, 10374091, 9612229, 9800683, 11045687, 10767209, 10242883, 10349437, 10767179, 9759589, 9407623, 9358465, 9792721, 9489625, 9587905, 9538801, 10972373, 9825505, 10406941, 10243111, 10767431, 10243471, 10038691, 9612757, 9522673, 9457141, 10349887, 9489715, 9989461, 9522829, 11316869, 9809629, 9481945, 10243783, 10350097, 9350701, 9350695, 9965143, 10350145, 10325623, 9350755, 10341997, 9490363, 11317121, 12234629, 9867223, 9670423, 12234539, 10333963, 9514801, 10350421, 10891427, 9564289, 9556135, 10522777, 9498865, 9629929, 12341297, 10940423, 9515041, 12234755, 9588823, 11006375, 12235175, 10359271, 11399437, 9621811, 10309933, 9359671, 10367317, 12382553, 12235085, 12235073, 9531757, 10359139, 12235415, 9556723, 10924583, 9859603, 9482761, 11391539, 12300809, 11391611, 10506871, 9499237, 10245007, 9499561, 10572769, 10474435, 9810913, 9483037, 9753355, 11391767, 9556807, 11391857, 10941581, 9524395, 10769567, 9999589, 9548821, 11392037, 10351639, 9425923, 11392055, 10769423, 9524263, 10581103, 13513775, 12235871, 10876331, 10941887, 10900877, 9475549, 9573679, 9409885, 10941785, 10614427, 9475597, 10786315, 9467425, 12236405, 9475699, 10336183, 9369529, 10475425, 10377181, 9508837, 10352611, 9860887, 9492241, 9582373, 10377037, 11073407, 9344875, 9500515, 9984223, 10008787, 11442419, 9484543, 10352665, 10369051, 9484345, 9517123, 11393147, 9533545, 11393111, 9492907, 10754531, 11434289, 10860899, 9648511, 9492843, 10754689, 10500763, 10402531, 9501421, 10353379, 10754597, 9550369, 10353277, 10476463, 12417929, 9845719, 9370567, 9993157, 10345411, 10795973, 12327887, 10615771, 10025737, 9763627, 13916977, 10353517, 11394239, 10616059, 10353685, 9534523, 12344321, 11459705, 12237923, 10337695, 10886573, 11394467, 10427791, 9461131, 9485779, 10698221, 12344615, 9338155, 10886501, 9444703, 9862519, 9494173, 10935977, 11427563, 10026697, 9453307, 10345993, 9584209, 9510475, 10436203, 9961357, 10346431, 9363379, 10886927, 10796813, 9494335, 9600829, 9862993, 9600865, 9494377, 9642175, 10862729, 9994423, 10838249, 11174129, 10715339, 9593071, 9977875, 9986053, 10862597, 11067395, 11395183, 10772549, 9592957, 10756183, 9609319, 9675163, 9355675, 9978313, 12239303, 12239147, 10494259, 9978127, 10838279, 9535795, 9707827, 9511243, 10772801, 10838345, 10330483, 11485529, 10429087, 9757429, 11469521, 9519679, 9372223, 11461151, 9593425, 10838651, 10535509, 12403627, 9601975, 9372583, 9896893, 9356197, 10044325, 10380235, 10380229, 10773455, 9970435, 9757489, 9528133, 9347929, 13345553, 9536335, 10249081, 9773947, 9585517, 9594001, 9856177, 9528487, 9528541, 10380493, 9528565, 12420139, 12264479, 9782329, 9970753, 9593929, 11437133, 9536635, 10249321, 9856105, 9528733, 9668023, 9938395, 9618889, 11232715, 11109695, 9594127, 9626929, 10773869, 9594181, 10503499, 9422197, 9946771, 9586333, 10700465, 9586309, 10561213, 9979609, 9586369, 10897139, 9963205, 10340095, 9963259, 10897091, 10896935, 10380871, 9586297, 10380901, 9775039, 9611221, 11102207, 9586639, 10348483, 9586681, 9594859, 9586669, 9963265, 10774277, 9963319, 11110247, 9602893, 9963391, 10070173, 9865369, 11397305, 9865357, 10389679, 10315999, 9357517, 9586885, 9865423, 9971953, 9357325, 9963529, 9357337, 10414081, 9979963, 10528783, 9357421, 9865327, 10799501, 9865663, 10897919, 10832347, 9586945, 9373987, 9374011, 9595231, 9587017, 9881983, 11397443, 10799435, 9349501, 9349489, 9382573, 9587377, 10283707, 9964255, 9595633, 9906709, 9587203, 10799675, 10398271, 10373689, 9366055, 10799645, 9587281, 10955375, 9677401, 11397731, 9513577, 10799705, 12815303, 9964429, 9964417, 9587641, 9563071, 10169287, 10062823, 9530167, 10382131, 11094809, 9964321, 10791799, 11397953, 11390113, 10398889, 12307589, 10022083, 9964789, 9964777, 10620121, 10800179, 9595909, 9595915, 9366547, 10243135, 10898435, 10415179, 9579595, 10300483, 10513489, 9964975, 11111909, 10784245, 10382797, 9735655, 9596185, 10579249, 9587977, 11070785, 9588373, 9965203, 10800809, 10382977, 9957043, 10612363, 9965227, 10514077, 9866995, 9867001, 10620637, 11079209, 13348439, 9948727, 12422687, 9604693, 11398781, 9596485, 9605047, 9596857, 11399057, 10899431, 9605083, 9539521, 9695221, 11186117, 10588123, 9596725, 9965359, 9596767, 12316499, 9588577, 9466003, 9465997, 9654439, 9367771, 10055911, 9760807, 9965605, 10588261, 11399269, 9351259, 10416199, 9990583, 10621333, 10432975, 9990649, 9376237, 10924493, 11071955, 10055965, 10055953, 10899761, 12300569, 10072447, 9507199, 9359743, 9671359, 10040029, 10621681, 12448475, 10253041, 11399903, 9990895, 10924577, 9376279, 9359917, 10007089, 9900583, 10392181, 12448697, 10056595, 9589639, 11457431, 9573289, 11072495, 11424767, 11482103, 9352177, 9687829, 9589531, 12301097, 10384135, 11481905, 9794359, 10490635, 10375981, 10277713, 9966457, 9614203, 11048111, 10458259, 10245265, 12547211, 9589927, 9581785, 9778225, 9573409, 11457641, 10245235, 9573475, 11072597, 10016173, 11449843, 9581851, 11081015, 9565501, 9434449, 11097415, 11072855, 11024039, 9967273, 11130515, 9967321, 10606333, 11081249, 11122229, 9614899, 11318795, 10360375, 9934375, 9606721, 9623155, 9533047, 11318879, 11318867, 10049419, 10696595, 12326867, 9648097, 9967591, 9852715, 10442563, 11106119, 12457807, 10696541, 11073725, 10582201, 10385599, 9959587, 10754285, 9959629, 9369811, 9713677, 9459721, 10950659, 9623605, 9869401, 9779317, 9984115, 9771109, 9648565, 9361831, 9664957, 9484705, 11065757, 9591259, 9624055, 12532169, 9345301, 10778893, 10001029, 9509551, 10877633, 9411325, 9984535, 9968143, 10877501, 9591307, 11082251, 9370153, 9968179, 9361975, 11090537, 10435195, 9378409, 9665125, 11475887, 11066279, 9567151, 9567193, 12237815, 11082701, 9567223, 9419749, 9419767, 9526045, 11475725, 9362209, 10312543, 12237695, 12237677, 11098973, 10394473, 9378673, 10378399, 11074727, 9772213, 9608401, 10517713, 11074781, 9575659, 10583263, 12237875, 12237857, 12409873, 12237845, 9935959, 9378919, 9354337, 9526381, 9616819, 9559477, 9960895, 11074949, 12238217, 11001329, 9960931, 9616873, 9559357, 9600295, 11361563, 12533087, 9960829, 9583975, 12238523, 9961123, 9969313, 9862909, 9977575, 11116073, 11476523, 11124263, 11124317, 11075165, 9780847, 10772393, 12238763, 9650053, 10067845, 9535393, 10723217, 9863107, 9600799, 11067191, 9862963, 10583815, 12427031, 9862951, 11165459, 10420003, 9453397, 9625453)
"""
df_plan_id= pd.read_sql(sql=sql_query_plan_id,con=engine_audit)
# if i < 76:
#    continue
total_plan_ids = df_plan_id['plan_id'].astype(str).tolist()
for i in range(0, len(total_plan_ids),5000):
    plan_ids = total_plan_ids[i:i+5000]
    df_xjd_ref = pd.read_sql(sql=sql_xjd_ref % (str(tuple(plan_ids)).replace(',)', ')'),), con=engine_audit)
    df_user_repayment_plan = pd.read_sql(sql=sql_user_repayment_plan % (str(tuple(plan_ids)).replace(',)', ')'),), con=engine_audit)

    df_user_repayment_plan.fillna(0, inplace=True)
    df_user_repayment_plan['repay_status'] = df_user_repayment_plan['repay_status'].astype(int)
    df_repayment_ref_merge = pd.merge(df_xjd_ref, df_user_repayment_plan, on='plan_id')
    df_count = df_repayment_ref_merge.groupby('plan_id')['id'].agg(['count']).reset_index()
    df_repayment_ref_merge = pd.merge(df_repayment_ref_merge, df_count, on='plan_id')

    #叠加红包数据
    ref_ids = df_repayment_ref_merge['ref_id'].astype(str).tolist()
    df_3 = pd.read_sql(sql=sql3 % (str(tuple(ref_ids)).replace(',)', ')'),), con=engine_audit)
    df_repayment_ref_merge['ref_id'] = df_repayment_ref_merge['ref_id'].astype(int)
    df_repayment_ref_merge['term_no'] = df_repayment_ref_merge['term_no'].astype(int)
    df_3['ref_id'] = df_3['ref_id'].astype(int)
    df_3['term_no'] = df_3['term_no'].astype(int)
    df_repayment_ref_merge = pd.merge(df_repayment_ref_merge, df_3, on=['ref_id', 'term_no'], how='left')
    df_repayment_ref_merge.fillna(0, inplace=True)
    df_repayment_ref_merge['red_package'] = df_repayment_ref_merge['red_amount']
    # =====================红包获取end===============


    # 'principle, interest, service_fee, should_punish,red_package '
    df_repayment_ref_merge['principle'] = np.round(df_repayment_ref_merge['principle'], 2)
    df_repayment_ref_merge['interest'] = np.round(df_repayment_ref_merge['interest'], 2)
    df_repayment_ref_merge['service_fee'] = np.round(df_repayment_ref_merge['service_fee'], 2)
    df_repayment_ref_merge['xyqb_repaid_at'] = pd.to_datetime(df_repayment_ref_merge['xyqb_repaid_at']).apply(lambda x: x.date())


    df_repayment_ref_merge['re_principle'] = 0
    df_repayment_ref_merge['re_interest'] = 0
    df_repayment_ref_merge['re_service_fee'] = 0
    df_repayment_ref_merge['re_punish'] = 0
    df_repayment_ref_merge['re_relief'] = 0
    df_repayment_ref_merge['re_remain'] = 0
    df_repayment_ref_merge['mitigate_prin'] = 0
    df_repayment_ref_merge['mitigate_inst'] = 0
    df_repayment_ref_merge['mitigate_fee'] = 0
    df_repayment_ref_merge['mitigate_punish'] = 0
    df_repayment_ref_merge['red_package_fee'] = 0
    df_repayment_ref_merge['mitigate_all'] = 0

    # count=1的可以直接拆
    # count>1的需要合并拆
    df_repay_success_single = df_repayment_ref_merge.ix[(df_repayment_ref_merge['repay_status'] == 3) & (df_repayment_ref_merge['count'] == 1)]
    df_repay_success_multi = df_repayment_ref_merge.ix[(df_repayment_ref_merge['repay_status'] == 3) & (df_repayment_ref_merge['count'] > 1)]
    df_repay_no_success_single = df_repayment_ref_merge.ix[(df_repayment_ref_merge['repay_status'] != 3) & (df_repayment_ref_merge['count'] == 1)]
    df_repay_no_success_multi = df_repayment_ref_merge.ix[(df_repayment_ref_merge['repay_status'] != 3) & (df_repayment_ref_merge['count'] > 1)]

    if len(df_repay_success_single) > 0:  # 直接拆
        # 实还本金
        df_repay_success_single['re_principle'] = df_repay_success_single['principle']
        # 实还利息
        df_repay_success_single['re_interest'] = df_repay_success_single['interest']
        # 实还服务费
        df_repay_success_single['re_service_fee'] = df_repay_success_single['service_fee']
        # 实还罚息
        df_repay_success_single['re_punish'] = df_repay_success_single['should_punish'].apply(lambda x: np.round(x, 2))
        # 实还本金+利息+服务费+罚息-还款 的差值
        df_repay_success_single['diff'] = df_repay_success_single['ref_amount'] - (df_repay_success_single['re_principle'] + df_repay_success_single['re_interest'] + df_repay_success_single['re_service_fee'] + df_repay_success_single['re_punish'])
        # 还款少了 催收减免 多了 放到remain
        df_repay_success_single['re_relief'] = df_repay_success_single['diff'].apply(lambda x: np.round(-x, 2) if x < 0 else 0)
        df_repay_success_single['re_remain'] = df_repay_success_single['diff'].apply(lambda x: np.round(x, 2) if x > 0 else 0)
        # 本金减免
        df_repay_success_single['mitigate_prin'] = df_repay_success_single.apply(lambda x: max(np.round(x['re_principle'] - x['ref_amount'], 2), 0),axis=1)
        # 利息减免
        df_repay_success_single['mitigate_inst'] = df_repay_success_single.apply(lambda x: max(x['re_principle'] + x['re_interest'] - x['mitigate_prin'] - x['ref_amount'], 0), axis=1)
        # 服务费减免
        df_repay_success_single['mitigate_fee'] = df_repay_success_single.apply(lambda x: max(
            round(x['re_principle'] + x['re_interest'] + x['re_service_fee'] - x['mitigate_prin'] - x['mitigate_inst'] - x['ref_amount'],2), 0), axis=1)
        # 罚息减免
        df_repay_success_single['mitigate_punish'] = df_repay_success_single.apply(lambda x: max(
            round(x['re_principle'] + x['re_interest'] + x['re_service_fee'] + x['re_punish'] - x['mitigate_prin'] - x[
                'mitigate_inst'] - x['mitigate_fee'] - x['ref_amount'],2), 0), axis=1)
        # #######红包使用前提是：：：减免 > 0 ，没有红包余额的概念#################
        #红包金额减免
        df_repay_success_single.ix[((df_repay_success_single['re_relief'] > 0) & (df_repay_success_single['red_package'] <= df_repay_success_single['re_relief'])), 'red_package_fee'] = \
            (df_repay_success_single.ix[((df_repay_success_single['re_relief'] > 0) & (df_repay_success_single['red_package'] <= df_repay_success_single['re_relief']))])['red_package']
        #催收减免
        df_repay_success_single['mitigate_all'] = np.round(df_repay_success_single['mitigate_prin'] + df_repay_success_single['mitigate_inst'] + df_repay_success_single['mitigate_fee'] + df_repay_success_single['mitigate_punish'] - df_repay_success_single['red_package_fee'],2)
    if len(df_repay_no_success_single) > 0:
        df_repay_no_success_single['re_principle'] = df_repay_no_success_single.apply(lambda x: x['principle'] if x['ref_amount'] > x['principle'] else x['ref_amount'], axis=1)
        df_repay_no_success_single['ref_amount'] = np.round(df_repay_no_success_single['ref_amount'] - df_repay_no_success_single['principle'], 2)
        df_repay_no_success_single.ix[df_repay_no_success_single['ref_amount'] > 0, 're_interest'] = df_repay_no_success_single.ix[df_repay_no_success_single['ref_amount'] > 0].apply(
            lambda x: x['interest'] if x['ref_amount'] > x['interest'] else x['ref_amount'],
            axis=1)
        df_repay_no_success_single['ref_amount'] = np.round(df_repay_no_success_single['ref_amount'] - df_repay_no_success_single['interest'], 2)

        df_repay_no_success_single.ix[df_repay_no_success_single['ref_amount'] > 0, 're_service_fee'] = df_repay_no_success_single.ix[df_repay_no_success_single['ref_amount'] > 0].apply(
            lambda x: x['service_fee'] if x['ref_amount'] > x['service_fee'] else x['ref_amount'],
            axis=1)
        df_repay_no_success_single['ref_amount'] = np.round(df_repay_no_success_single['ref_amount'] - df_repay_no_success_single['service_fee'], 2)

        df_repay_no_success_single.ix[df_repay_no_success_single['ref_amount'] > 0, 're_punish'] = df_repay_no_success_single.ix[df_repay_no_success_single['ref_amount'] > 0].apply(
            lambda x: x['should_punish'] if x['ref_amount'] > x['should_punish'] else x['ref_amount'],
            axis=1)
        df_repay_no_success_single['ref_amount'] = np.round(df_repay_no_success_single['ref_amount'] - df_repay_no_success_single['should_punish'], 2)

        df_repay_no_success_single.ix[df_repay_no_success_single['ref_amount'] > 0, 're_remain'] = df_repay_no_success_single.ix[df_repay_no_success_single['ref_amount'] > 0, 'ref_amount']

    print '-------------------> len(df_repayment_ref_merge): %s <------------------------------------' % (len(df_repayment_ref_merge),)
    print '-------------------> len(df_repay_success_single): %s, len(df_repay_success_multi): %s <------------------------------------' % (len(df_repay_success_single), len(df_repay_success_multi))
    print '-------------------> len(df_repay_no_success_single): %s, len(df_repay_no_success_multi): %s <------------------------------------' % (len(df_repay_no_success_single), len(df_repay_no_success_multi))

    result_3 = pd.DataFrame(columns=columns)
    str1 = df_repay_success_multi.plan_id.unique()
    for i in str1:
        df_repayment_ref_merge = df_repay_success_multi.ix[df_repay_success_multi.plan_id == i]
        b = split_money_3(df_repayment_ref_merge)
        result_3 = result_3.append(b)
    # result_3.to_csv("df_3_2.csv", index=False, columns=columns)
    # df_3_1.to_csv("df_3_1.csv", index=False, columns=columns)

    print '-------------------> split 3, len(result_3): %s <------------------------------------' % (
        len(result_3),)
    result_0 = pd.DataFrame(columns=columns)
    str1 = df_repay_no_success_multi.plan_id.unique()
    for i in str1:
        df_repayment_ref_merge = df_repay_no_success_multi.ix[df_repay_no_success_multi.plan_id == i]
        b = split_money_0(df_repayment_ref_merge)
        result_0 = result_0.append(b)
    # result_0.to_csv("df_0_2.csv", index=False, columns=columns)
    # df_0_1.to_csv("df_0_1.csv", index=False, columns=columns)
    print '-------------------> split 0, len(result_0): %s <------------------------------------' % (
        len(result_0),)

    # result_3.fillna(0, inplace=True)
    # df_3_1.fillna(0, inplace=True)
    # df_0_1.fillna(0, inplace=True)
    # result_0.fillna(0, inplace=True)
    df_list = result_3[up_columns].values.tolist()
    df_list.extend(df_repay_success_single[up_columns].values.tolist())
    df_list.extend(result_0[up_columns].values.tolist())
    df_list.extend(df_repay_no_success_single[up_columns].values.tolist())
    if len(df_list) > 0:
        engine_audit.execute(sql_update, df_list)
    print '-------------------> update len(df_list): %s <------------------------------------' % (
        len(df_list),)
