# -*- coding:utf-8 -*-
#!/usr/bin/python
from Caiwu import connect_sql
import inspect
from tools.tools_xls_new import Excelxls
import pandas as pd
import numpy as np
from tools.tools_File import File
import pprint

from tools.tools_FileToSql import File_ToSql
from tools import tools_time
fromMonth_time = tools_time.get_fromMonthYMDHMS()[0]
fromMonth = tools_time.get_datetime()
def get_current_function_name():
    return inspect.stack()[1][3]


class 现金贷(object):
    def __init__(self,file_path):
        # self.xls = Excelxls()
        self.baitiao_audit = connect_sql.connect_baitiao_audit()
        self.new_transaction = connect_sql.connect_new_transaction()
        self.audit = connect_sql.connect_audit()
        self.basic = connect_sql.connect_basic()
        self.file_path = file_path

    def save_xls(self, xls, con, fname):
        key = []
        value = []
        filename = ''
        print(len(con))
        if len(con) > 0:
            for c in con:
                key = c.keys()
                value.append(c.values())

        else:
            filename = "_无问题"

        xls.wirte_xls(fname, key, value)
        path = self.file_path + fname + filename + ".xls"
        xls.save_xls(path)


    def save_xls_two(self, xls, con,con2, fname):
        key = []
        value = []
        for c in con:
            key = c.keys()
            value.append(c.values())
        for c in con2:
            key.extend(c.keys())
            value.extend(c.values())
        self.xls.wirte_xls(fname, key, value)
        self.xls.save_xls(u'C:/Users/xufei/Desktop' + get_current_function_name() + '.xls')
        print(con)
        print(con2)

    def 校验loan_manifest中ref_id是否有空有重复(self):
        str_sql1 = "select * as cnt from loan_manifest where is_active=1 group by ref_id HAVING cnt > 1"
        str_sql2 = "select * from loan_manifest where is_active=1 and ref_id is null"
        con1 = self.audit.select(str_sql1)
        con2 = self.audit.select(str_sql2)
        xls = Excelxls()
        self.save_xls_two(self,xls,con1,con2,get_current_function_name())

    def 校验loan_manifest中amount数值不在1000和10000区间数据(self):
        str_sql = "select a.id from audit.loan_manifest as a where a.is_active = '1' and a.funding_code <> '0' and (a.real_loan_amount not between '1000' and '10000' or a.contract_loan_amount not between '1000' and '10000')"
        con = self.audit.select(str_sql)

        if len(con) <=0:
            print(1)
        else:
            print(2)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验loan_manifeas与user_repayment_plan放款与还款计划应还本金是否一致(self):
        str_sql = """
            select 
            t1.ref_id,t1.loan_paid_at,t1.contract_loan_amount,t2.*
            from audit.loan_manifest as t1
            join (select ref_id,sum(principle) sum_principle from new_transaction.user_repayment_plan GROUP BY ref_id) as t2
            on t1.ref_id = t2.ref_id and is_active in (1,-2) and t1.loan_paid_at >= '2017-01-01'
            where abs(t1.contract_loan_amount - t2.sum_principle) >0.2
        """
        df_merchant = pd.read_sql(str_sql ,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)

        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验loan_manifest是否有还款计划(self):
        str_sql = """
            select * from (
            select count(t1.ref_id) cnt1,count(t2.ref_id) cnt2 from audit.loan_manifest as t1 
            LEFT JOIN (select ref_id from new_transaction.user_repayment_plan GROUP BY ref_id) t2
            on t1.ref_id = t2.ref_id 
            )tt 
            where tt.cnt1-tt.cnt2 > 0
        """
        df_merchant = pd.read_sql(str_sql ,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验user_repayment_plan应还金额是否等于本金_利息_服务费之和(self):
        str_sql = """
            select * from (
                select ref_id ,sum(principle + interest + service_fee ) sum_principe ,sum(required_repayment)required_repayment 
                from new_transaction.user_repayment_plan 
            -- 	where repay_status = 3
                GROUP BY ref_id
            )tt 
            where tt.required_repayment - tt.sum_principe >0.1
        """
        df_merchant = pd.read_sql(str_sql ,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验user_repayment_plan实还金额_current_repayment_是否等于本金_利息_服务费_罚息_remain减去减免(self):
        str_sql = """
            select id plan_id ,ref_id,current_repayment,real_amount from (
                select id ,ref_id ,current_repayment,
                (real_principle+real_interest+real_service_fee+real_punish-collection_relief + remain) real_amount
                from new_transaction.user_repayment_plan 
                where repay_status = 3 
            )tt
            where abs(tt.current_repayment - real_amount) > 0.01
        """
        df_merchant = pd.read_sql(str_sql,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)

        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))


    def 校验loan_manifest与user_repayment_plan还款期数是否一致(self):
        # str_sql = """
        #     select ref_id,contract_term,is_active,created_at,updated_at  from audit.loan_manifest as loan
        #     where loan.contract_term <>
        #     (select count(1) cnt from new_transaction.user_repayment_plan where ref_id = loan.ref_id GROUP BY ref_id)
        # """
        str_sql = """
            select loan.loan_id,loan.ref_id,loan.loan_paid_at,loan.created_at loan_created_at,loan.updated_at loan_updated_at,loan.contract_term loan_term,
            plan.cnt ,plan.created_at plan_created_at,plan.updated_at plan_updated_at from
            (select loan_id,ref_id,contract_term,is_active,created_at,updated_at,loan_paid_at from audit.loan_manifest where is_active = 1 and loan_paid_at >= '%s' ) as loan
            join
            (select ref_id,count(1) cnt,created_at,updated_at from new_transaction.user_repayment_plan GROUP BY ref_id) as plan
            on loan.ref_id = plan.ref_id 
            where loan.contract_term <> plan.cnt
        """

        df_merchant = pd.read_sql(str_sql %( fromMonth_time ) ,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)

        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验per_term_service_fee和user_repayment_plan中service_fee是否一致_1毛以内算作一致(self):
        str_sql = """
                select funding.name,fest.*,plan.* from
                (select funding_code,ref_id,per_term_service_fee,contract_term ,created_at,updated_at from audit.loan_manifest ) as fest
                join
                (select ref_id,(sum(service_fee)/count(1)) service_fee,count(1) cnt,created_at,updated_at from new_transaction.user_repayment_plan GROUP BY ref_id) as plan
                on fest.ref_id = plan.ref_id
                join basic.funding_corp as funding on funding.funding_code = fest.funding_code
                where fest.per_term_service_fee - plan.service_fee >= 0.1
        """
        # 目前有496 笔有问题的数据
        df_merchant = pd.read_sql(str_sql,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))
        pass

    def 校验loan_manifest和user_repayment_plan的required_repayment是否一致(self):
        str_sql = """
                select funding.name,fest.*,plan.* from
                (select funding_code,ref_id,monthly_required_repayment_amount mrr_zmount ,created_at,updated_at,is_active from audit.loan_manifest where is_active = 1 ) fest
                join
                (select ref_id,(sum(required_repayment)/count(1))mrr_zmount,created_at,updated_at from new_transaction.user_repayment_plan GROUP BY ref_id ) plan
                on fest.ref_id = plan.ref_id
                join basic.funding_corp as funding on funding.funding_code = fest.funding_code
                where fest.mrr_zmount - plan.mrr_zmount >0.1
        """
        # con = self.audit.select(str_sql)
        # xls = Excelxls()
        # self.save_xls(xls, con, get_current_function_name())
        df_merchant = pd.read_sql(str_sql,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+str(fromMonth)+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验loan_manifest中loan_paid_at是否存在大于user_repayment_plan第一期deadline(self):
        str_sql = """
            SELECT
            a.id,a.ref_id,a.funding_code, b.`real_loan_id`, b.`current_repayment`, b.id,a.loan_paid_at,b.deadline
            FROM
            loan_manifest AS a
            INNER JOIN user_repayment_plan AS b on a.ref_id=b.ref_id
            where a.loan_paid_at > b.deadline and b.term_no=1 AND a.loan_id REGEXP '^[^-]'
            and is_active > 0
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验loan_manifest中contract_loan_amount是否等于real_loan_amount加qg_one_time_service_fee加funding_one_time_service_fee_趸交服务费(self):
        # str_sql = """
        #     select * from `loan_manifest` lm
        #     where lm.`is_active` = 1
        #     and lm.contract_loan_amount != ( lm.`real_loan_amount` + lm.`qg_one_time_service_fee` + lm.`funding_one_time_service_fee`)
        # """
        str_sql = """
            select fest.loan_id,fest.ref_id,fest.real_loan_amount,fest.real_loan_amount,fest.qg_one_time_service_fee,fest.created_at,fest.updated_at,
            dunjiao.real_qg_one_time_service_fee,
            fest.contract_loan_amount,( fest.real_loan_amount + fest.qg_one_time_service_fee + fest.funding_one_time_service_fee + dunjiao.real_qg_one_time_service_fee)
            from audit.loan_manifest as fest
            LEFT JOIN new_transaction.xjd_dunjiao_plan as dunjiao on dunjiao.ref_id = fest.ref_id
            where fest.is_active = 1
            and  fest.contract_loan_amount != ( fest.real_loan_amount + fest.qg_one_time_service_fee + fest.funding_one_time_service_fee + dunjiao.real_qg_one_time_service_fee)
        """

        df_merchant = pd.read_sql(str_sql,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验loan_manifest中monthly_interest_rate是否在百分之8到15并处以12之间(self):
        str_sql = """
            SELECT loan_manifest.monthly_interest_rate,
            loan_manifest.id
            FROM loan_manifest
            WHERE loan_manifest.monthly_interest_rate < 0.08/12 and loan_manifest.monthly_interest_rate > 0.15/12 and is_active = 1
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验user_repayment_plan的required_repayment与principle加interest加service_fee的差异小于0点01(self):
        str_sql = """
            select b.required_repayment, b.principle, b.interest, b.service_fee, abs(b.required_repayment - b.principle - b.interest - b.service_fee) as difference 
            from new_transaction.user_repayment_plan b
            where abs(b.required_repayment - b.principle - b.interest - b.service_fee) > 0.01
       """
        df_merchant = pd.read_sql(str_sql,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))


    def 校验user_repayment_plan的collection_relief是否等于mitigate_all加red_package(self):
        str_sql = """
            SELECT collection_relief, (mitigate_all+red_package)
            FROM user_repayment_plan as urp
            WHERE collection_relief != (mitigate_all+red_package)
        """
        df_merchant = pd.read_sql(str_sql,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验user_repayment_plan的real_principle加real_interest加real_service_fee加real_punish加remain减collection_relief是否等于principle加interest加service_fee加should_punish(self):
        str_sql = """
            select count(1) from `user_repayment_plan` urp where
            abs((real_principle+real_interest+real_service_fee +real_punish +remain -collection_relief ) -current_repayment
            )>0.03 and current_repayment>0
            # select count(1) from `user_repayment_plan` urp where
            # abs((real_principle+real_interest+real_service_fee +real_punish +remain -collection_relief ) -current_repayment
            # )>0.03 and xyqb_repaid_at<'2017-05-01' and current_repayment>0
            
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验loan_manifest中funding_code和funding_repayment_record中funding_code是否一致(self):
        str_sql = """
            select a.ref_id,a.funding_code,b.funding_code from
            loan_manifest as a INNER JOIN
            funding_repayment_record as b on a.ref_id=b.ref_id
            where a.funding_code != b.funding_code and a.loan_id REGEXP '^[0-9]'
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())


    def 校验datediffloan_manifest中loan_paid_at加term减user_repayment_plan对应期数的deadline是否有大于2天的(self):
        str_sql1 = """
            select count(1)
            from loan_manifest a
            inner join user_repayment_plan b on a.ref_id = b.ref_id
            where a.is_active = 1
            AND a.loan_id REGEXP '^[0-9]'
            and abs(datediff(date_add(a.loan_paid_at, interval b.term_no MONTH), b.deadline)) > 2
        """
        str_sql2 = """
            select a.loan_paid_at, b.term_no,b.deadline,
            date_add(a.loan_paid_at, interval b.term_no MONTH),
            datediff(date_add(a.loan_paid_at, interval b.term_no MONTH), b.deadline)
            from loan_manifest a
            inner join user_repayment_plan b on a.ref_id = b.ref_id
            where a.is_active = 1
            AND a.loan_id REGEXP '^[0-9]'
            and abs(datediff(date_add(a.loan_paid_at, interval b.term_no MONTH), b.deadline)) > 2
            limit 10
        """
        con1 = self.audit.select(str_sql1)
        con2 = self.audit.select(str_sql2)
        xls = Excelxls()
        self.save_xls_two(self,xls,con1,con2,get_current_function_name())

    def 校验loan_manifest中contract_loan_amount是否和user_repayment_plan的全部应还本金差距是否在1毛钱以上(self):
        str_sql = """
            select count(1)
            from loan_manifest as a
            where
            a.is_active = 1
            and
            abs(a.contract_loan_amount -
            (
            select sum(b.principle)
            from user_repayment_plan as b
            where b.ref_id = a.ref_id
            group by b.ref_id
            )) > 0.1
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验xjd_repay_plan_repay_record_ref中mitigate_collection_relief加mitigate_service_fee加mitigate_interest加mitigate_principle是否等于red_package_fee加mitigate_all(self):
        str_sql = """
            SELECT count(a.id)
            FROM xjd_repay_plan_repay_record_ref as a
            WHERE (a.mitigate_collection_relief + a.mitigate_service_fee + a.mitigate_interest + a.mitigate_principle) <> (red_package_fee + mitigate_all)
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验baitiao_repay_plan_repay_record_ref中mitigate_collection_relief加mitigate_service_fee加mitigate_interest加mitigate_principle是否等于red_package_fee加mitigate_all(self):
        str_sql = """
            SELECT plan_id,record_id,
            (mitigate_collection_relief + mitigate_service_fee + mitigate_interest + mitigate_principle) 'c1',
            (red_package_fee + mitigate_all) 'c2'
            FROM baitiao_repay_plan_repay_record_ref WHERE
            (mitigate_collection_relief + mitigate_service_fee + mitigate_interest + mitigate_principle) != (red_package_fee + mitigate_all)
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验funding_repayment_record中AIR是否等于loan_manifest中monthly_interest_rate乘以12不一样的列出条数即可(self):
        str_sql = """
            select count(1) from funding_repayment_record as a inner join loan_manifest as b on a.ref_id=b.ref_id
            where a.AIR != b.monthly_interest_rate*12 and a.loan_id REGEXP '^[0-9]'
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验baitiao_fund_repayment_record中某贷款同一期还款计划是否存在多条(self):
        str_sql = """
            SELECT loan_no, term_no, count(1)
            FROM baitiao_fund_repayment_record
            GROUP BY loan_no,term_no
            HAVING count(1)>1
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验loan_manifest分组是否存在异常数据(self):
        str_sql = """
            select funding_code,contract_loan_amount,monthly_interest_rate,
            qg_one_time_service_fee,funding_one_time_service_fee,contract_term
            from loan_manifest group by funding_code,contract_loan_amount,monthly_interest_rate,
            qg_one_time_service_fee,funding_one_time_service_fee,contract_term
        """
        con = self.audit.select(str_sql)
        xls = Excelxls()
        self.save_xls(xls, con, get_current_function_name())

    def 校验阿里线下还款金额拆分(self):
        # repay_channel = 13  阿里线下还款1
        str_sql= """
            SELECT t1.*
            FROM
            new_transaction.xjd_repay_plan_repay_record_ref t1
            JOIN new_transaction.user_repayment_plan t2 ON t2.id = t1.plan_id
            JOIN new_transaction.funding_corp t6 ON t2.fund_code = t6.id
            JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
            JOIN new_transaction.offline_alipay_record t3 ON t1.repay_channel = 13
            AND t3.id = t1.record_id
            -- WHERE t3.transfer_time>='2017-06-01'
            -- AND t3.transfer_time<'2017-07-01'
            -- AND t6.id=140
            where (t1.ref_amount-t1.principle-t1.interest-t1.service_fee-t1.punish-t1.remain_income+t1.mitigate_principle+t1.mitigate_interest+mitigate_service_fee+t1.mitigate_collection_relief)<>0
        """
        df_merchant = pd.read_sql(str_sql,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

       # repay_channel = 13 阿里线下还款1
    def 现金贷月份数据校验(self,汇总_xlsx,明细_xlsx,sql_huizong,sql_mingxi):
        """
        汇总、明细、保存表名称
        """
        columns={
            u'产品编号':'product_no',
            u'分期编号':'current_stage_no',
            u'还款时间':'repay_time',
            u'资金方':'fund_name',
            u'放款id':'loan_id',
            u'放款期数':'contract_term',
            u'期数':'term_no',
            u'实还款日':'repaid_at' ,
            u'还款总额':'ref_amount' ,
            u'实还本金':'real_principle',
            u'实还利息':'real_interest',
            u'实还服务费':'real_service_fee',
            u'实还罚息':'real_punish',
            u'其他收益':'remain',
            u'渠道流水号':'order_id',
            u'收款账户':'approach_name'
        }
        # ToSql = File_ToSql(明细_xlsx,sql_mingxi,columns=columns)
        # ToSql.write_Sql('replace')

        print(sql_huizong)
        ToSql = File_ToSql(汇总_xlsx,sql_huizong,columns=columns)
        ToSql.write_Sql('replace')

    def 校验支付保收入与总支出(self):
        str_sql = """
          select t2.record_id,income,outcome,t2.sum_ref_amount from  offline_alipay_record  as t3 join
            (
            SELECT t1.record_id, sum(t1.ref_amount) sum_ref_amount
            FROM
                (
                    SELECT record_id,sum(ref_amount) ref_amount
                    FROM baitiao_repay_plan_repay_record_ref
                    WHERE repay_channel = 13
                    GROUP BY record_id
                    UNION ALL
                    SELECT record_id,sum(ref_amount) ref_amount
                    FROM xjd_repay_plan_repay_record_ref
                    WHERE repay_channel = 13
                    GROUP BY record_id
                ) t1
            GROUP BY record_id) t2 on t2.record_id = t3.id
            WHERE income - t2.sum_ref_amount >0 and outcome-t2.sum_ref_amount > 0
        """
        df_merchant = pd.read_sql(str_sql,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

        pass
    def 校验现金贷收入支出(self):
        str_sql = """
            select t2.record_id,income,outcome,t2.sum_ref_amount from  new_transaction.offline_alipay_record  as t3 join
            (
            SELECT t1.record_id, sum(t1.ref_amount) sum_ref_amount
            FROM
                (
                  SELECT record_id,sum(ref_amount) ref_amount
                  FROM new_transaction.xjd_repay_plan_repay_record_ref
                  WHERE repay_channel = 13
                  GROUP BY record_id
                ) t1
            GROUP BY record_id) t2 on t2.record_id = t3.id
            WHERE income - t2.sum_ref_amount >0 and outcome-t2.sum_ref_amount > 0
        """
        df_merchant = pd.read_sql(str_sql,con = self.new_transaction.get_connet())
        df = pd.concat([df_merchant],ignore_index=True)
        if len(df) > 0:
            print('error ：%s'%(get_current_function_name()))
            file_path = self.file_path +get_current_function_name()+'_'+str(fromMonth)+'.xlsx'
            df.to_excel(file_path,columns = df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验xjd_repay_plan_repay_record_ref中的ref_amount是否等于实还减减免(self):
        str_sql = """
            select * from (
            select plan_id,record_id,ref_amount,created_at,updated_at,
            (principle - mitigate_principle) principle,
            (interest - mitigate_interest) interest,
            (service_fee-mitigate_service_fee) service_fee,
            (punish - mitigate_collection_relief) punish,
            remain_income
            from xjd_repay_plan_repay_record_ref 
            where created_at >= '%s'
            ) t1
            where t1.ref_amount - t1.principle-t1.interest-t1.service_fee-t1.punish-t1.remain_income >0
        """
        df_merchant = pd.read_sql(str_sql  %(fromMonth_time) , con=self.new_transaction.get_connet())
        df = pd.concat([df_merchant], ignore_index=True)
        file_path = self.file_path + get_current_function_name() + '.xlsx'
        # df.drop(df[(df['principle']+df['interest']+df['service_fee']+df['punish']+df['remain_income']) - df['ref_amount'] == 0].index, inplace=True)
        if len(df) > 0:
            print('error ：%s' % (get_current_function_name()))
            df.to_excel(file_path, columns=df.columns,index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))


    def 校验xjd_repay_plan_repay_record_ref中总减免是否等于减免中的collection_relief加service_fee加interest加principle之和(self):
        str_sql = """
            SELECT plan_id,record_id,updated_at From xjd_repay_plan_repay_record_ref 
            WHERE collection_relief <> mitigate_collection_relief + mitigate_service_fee + mitigate_principle + mitigate_interest
            AND updated_at >= '%(fromMonth_time)s'
        """

        df_merchant = pd.read_sql(str_sql % {'fromMonth_time':fromMonth_time}, con=self.new_transaction.get_connet())
        df = pd.concat([df_merchant], ignore_index=True)
        file_path = self.file_path + get_current_function_name() + '.xlsx'
        # df.drop(df[(df['principle']+df['interest']+df['service_fee']+df['punish']+df['remain_income']) - df['ref_amount'] == 0].index, inplace=True)
        if len(df) > 0:
            print('error ：%s' % (get_current_function_name()))
            df.to_excel(file_path, columns=df.columns, index=None)
    def 校验xjd_repay_plan_repay_record_ref中总减免是否等于红包减免加催收减免(self):

        str_sql = """select plan_id,record_id,updated_at from xjd_repay_plan_repay_record_ref where collection_relief <> red_package_fee+mitigate_all"""
        df_merchant = pd.read_sql(str_sql, con=self.new_transaction.get_connet())
        df = pd.concat([df_merchant], ignore_index=True)
        file_path = self.file_path + get_current_function_name() + '.xlsx'
        if len(df) > 0:
            print('error ：%s' % (get_current_function_name()))
            df.to_excel(file_path, columns=df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验xjd_repay_plan_repay_record_ref和user_repayment_plan中re_amount总和与current_repayment是否一致(self):
        str_sql = """
            select t1.plan_id,sum(t1.ref_amount),t2.current_repayment,t2.created_at,t2.updated_at from xjd_repay_plan_repay_record_ref as t1
            JOIN user_repayment_plan as t2 on t1.plan_id = t2.id
            GROUP BY t1.plan_id
            HAVING sum(t1.ref_amount) <> t2.current_repayment
        """
        df_merchant = pd.read_sql(str_sql, con=self.new_transaction.get_connet())
        df = pd.concat([df_merchant], ignore_index=True)
        file_path = self.file_path + get_current_function_name() + '.xlsx'
        if len(df) > 0:
            print('error ：%s' % (get_current_function_name()))
            df.to_excel(file_path, columns=df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))


    def 校验xjd_repay_plan_repay_record_ref中red_package和remain_income不能同时大于零(self):
        str_sql = """SELECT plan_id,record_id,updated_at FROM `xjd_repay_plan_repay_record_ref` WHERE `red_package_fee` > 0 AND `remain_income` > 0"""
        df_merchant = pd.read_sql(str_sql, con=self.new_transaction.get_connet())
        df = pd.concat([df_merchant], ignore_index=True)
        file_path = self.file_path + get_current_function_name() + '.xlsx'
        if len(df) > 0:
            print('error ：%s' % (get_current_function_name()))
            df.to_excel(file_path, columns=df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))
        pass



    def 校验user_repayment_plan_repay_statusd等于3时_实还本金_利息_服务费_罚息_余额减去所有减免与current_repayment是否一致(self):
        str_sql = """
            select * from (
            select 
            id,ref_id,real_loan_id,
            user_biz_id,xyqb_repaid_at,current_repayment,
            (real_principle+real_interest+real_service_fee+real_punish + remain - collection_relief) sum 
            from user_repayment_plan where repay_status = 3
            and xyqb_repaid_at >= '%s'
            )t1 
            where t1.current_repayment - t1.sum != 0  
        """
        df_merchant = pd.read_sql(str_sql %(fromMonth_time), con=self.new_transaction.get_connet())
        df = pd.concat([df_merchant], ignore_index=True)

        df.drop(df[df['current_repayment'] - df['sum']  == 0].index,inplace=True)

        if len(df) > 0:
            print('error ：%s' % (get_current_function_name()))
            file_path = self.file_path + get_current_function_name() + '.xlsx'
            df.to_excel(file_path, columns=df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))


    def 校验user_replayment_plan中的红包_其他减免等于催收减免(self):
        str_sql = """
            select * from 
            (select (red_package+mitigate_all)sum_mitigate,collection_relief from user_repayment_plan where xyqb_repaid_at >= '%s')t1
            where abs(t1.sum_mitigate - collection_relief) >= 0.1
        """
        df_merchant = pd.read_sql(str_sql %(fromMonth_time), con=self.new_transaction.get_connet())
        df = pd.concat([df_merchant], ignore_index=True)
        if len(df) > 0:
            print('error ：%s' % (get_current_function_name()))
            file_path = self.file_path + get_current_function_name() + '.xlsx'
            df.to_excel(file_path, columns=df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验所有资金方对应流水号_每个流水号对应的还资金方表的金额和是否一致(self):
        sql_funding_code = """
          select funding_code from basic.funding_corp;
        """
        sql_flow_id = """
          select DISTINCT flow_id from audit.funding_repayment_record where funding_code IN ( %s );
        """
        sql_lkb = """
          select flow_id,ref_amount from basic.lkb_to_fund_ref 
          where flow_id in ( %s ) and created_at > '2017-08-31';
        """

        sql_repayment_record = """
          select flow_id,loan_id,sum(principle+interest) sum_principle_interest ,sum(punish_fee) sum_punish_fee,
          sum(prepay_fee) sum_prepay_fee,sum(funding_service_fee) sum_funding_service_fee,
          sum(current_repayment) sum_current_repayment  from audit.funding_repayment_record 
          where flow_id in ( %s ) GROUP BY flow_id;
        """

        df_funding_code  = pd.read_sql(sql_funding_code ,con=self.audit.get_connet())
        funding_code = ((',').join(df_funding_code['funding_code'].astype(str)))

        df_flow_id = pd.read_sql(sql_flow_id % (funding_code),con=self.audit.get_connet())
        flow_id = ((',').join(pd.Series(df_flow_id['flow_id'].tolist()).dropna().astype(str)))

        df_lkb = pd.read_sql(sql_lkb % (flow_id), con = self.basic.get_connet())

        df_repayment_record = pd.read_sql(sql_repayment_record % (flow_id) ,con=self.audit.get_connet())
        df_lkb['ref_amount'] = round(df_lkb['ref_amount'],2)
        df_repayment_record['sum_principle_interest'] = round(df_repayment_record['sum_principle_interest'], 2)
        df_repayment_record['sum_current_repayment'] = round(df_repayment_record['sum_current_repayment'], 2)

        df_repayment_record['sum_punish_fee'] = df_repayment_record['sum_punish_fee'].fillna(0)
        df_repayment_record['sum_punish_fee'] = round(df_repayment_record['sum_punish_fee'] ,2)

        df_repayment_record['sum_prepay_fee'] = df_repayment_record['sum_prepay_fee'].fillna(0)
        df_repayment_record['sum_prepay_fee'] = round(df_repayment_record['sum_prepay_fee'] ,2)

        df_repayment_record['sum_funding_service_fee'] = df_repayment_record['sum_funding_service_fee'].fillna(0)
        df_repayment_record['sum_funding_service_fee'] = round(df_repayment_record['sum_funding_service_fee'] ,2)


        pdmerge = pd.merge(df_lkb,df_repayment_record,how='left',on=['flow_id'])
        pdmerge.drop(pdmerge[(pdmerge['sum_principle_interest'] + pdmerge['sum_punish_fee']+pdmerge['sum_prepay_fee'] + pdmerge['sum_funding_service_fee'] - pdmerge['sum_current_repayment'] > 0.1)].index, inplace=True)
        if len(pdmerge) > 0:
            print('error ：%s' % (get_current_function_name()))
            file_path = self.file_path + get_current_function_name()+'_'+str(fromMonth) + '.xlsx'
            pdmerge.to_excel(file_path, columns=pdmerge.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))


    def 校验xjd_repay_plan_repay_record_ref表中还款流水与还款计划中的实还金额和实还流水是否一致(self):
        str_sql = """
            #校验xjd_repay_plan_repay_record_ref表中还款流水与还款计划中的实还金额和实还流水是否一致
            select t2.ref_id,t1.plan_id ,t1.ref_amount ref_amount,t2.current_repayment current_repayment,t2.real_amount real_amount from (
                (
                    select plan_id,sum(ref_amount) ref_amount 
                    from new_transaction.xjd_repay_plan_repay_record_ref 
                    -- where plan_id = 6976315
                    GROUP BY plan_id 
                ) as t1
                join 
                (
                    select id,current_repayment,ref_id,(real_principle+real_interest+real_service_fee+real_punish-collection_relief + remain) real_amount 
                    from new_transaction.user_repayment_plan
                    -- where id = 6976315
                )t2 on t1.plan_id = t2.id
            )
            where ref_amount - current_repayment != 0
            and current_repayment - real_amount != 0
        
        """
        df_merchant = pd.read_sql(str_sql, con=self.new_transaction.get_connet())
        df = pd.concat([df_merchant], ignore_index=True)
        if len(df) > 0:
            print('error ：%s' % (get_current_function_name()))
            file_path = self.file_path + get_current_function_name() + '.xlsx'
            df.to_excel(file_path, columns=df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))

    def 校验xjd_repay_plan_repay_record_ref中ref_amount是否等于principle_interest_service_fee_punish之和减去collection_relief(self):
        str_sql = """
            SELECT t.id,t.ref_amount,t.sum_amount from (
            select id, ref_amount,sum(principle+interest+service_fee+punish+remain_income - collection_relief) sum_amount from new_transaction.xjd_repay_plan_repay_record_ref GROUP BY id
            )t
            where abs(ref_amount - sum_amount) >0.01  

        """
        df_merchant = pd.read_sql(str_sql, con=self.new_transaction.get_connet())
        df = pd.concat([df_merchant], ignore_index=True)
        if len(df) > 0:
            print('error ：%s' % (get_current_function_name()))
            file_path = self.file_path + get_current_function_name() + '.xlsx'
            df.to_excel(file_path, columns=df.columns, index=None)
        else:
            print('pass ：%s'%(get_current_function_name()))
        pass
    def aa(self):
        # pd.DataFrame(np.random())
        df = pd.DataFrame({'a': [1, 2, 3], 'b': ['a', 'b', 'c'], 'c': ["A", "B", "C"]})
        print(df.loc[:1,2:])
        pass




if __name__ == '__main__':

    file_path = u"F:/量化派需求/测试任务/测试结果/现金贷/0912/"
    xianjindai = 现金贷(file_path)

    # xianjindai.校验loan_manifest中amount数值不在1000和10000区间数据()
    # xianjindai.校验loan_manifest中ref_id是否有空有重复()

    # xianjindai.现金贷月份数据校验(u'F:/量化派需求/测试任务/王博/7-19/现金贷还款表汇总___OK2.xlsx',
    #                      u'F:/量化派需求/测试任务/王博/7-19/现金贷还款4-6月_allback_0630/',
    #                      'xianjindai_huizong_4_6',
    #                      'xianjindai_mingxi_4_6'
    # #                      )

    xianjindai.校验loan_manifeas与user_repayment_plan放款与还款计划应还本金是否一致()
    xianjindai.校验loan_manifest是否有还款计划()
    xianjindai.校验user_repayment_plan应还金额是否等于本金_利息_服务费之和()
    xianjindai.校验user_repayment_plan实还金额_current_repayment_是否等于本金_利息_服务费_罚息_remain减去减免()
    xianjindai.校验loan_manifest与user_repayment_plan还款期数是否一致()
    xianjindai.校验per_term_service_fee和user_repayment_plan中service_fee是否一致_1毛以内算作一致()
    xianjindai.校验loan_manifest和user_repayment_plan的required_repayment是否一致()
    xianjindai.校验loan_manifest中contract_loan_amount是否等于real_loan_amount加qg_one_time_service_fee加funding_one_time_service_fee_趸交服务费()
    xianjindai.校验user_repayment_plan的required_repayment与principle加interest加service_fee的差异小于0点01()
    xianjindai.校验阿里线下还款金额拆分()
    xianjindai.校验支付保收入与总支出()
    xianjindai.校验现金贷收入支出()
    xianjindai.校验xjd_repay_plan_repay_record_ref中的ref_amount是否等于实还减减免()
    xianjindai.校验xjd_repay_plan_repay_record_ref中总减免是否等于减免中的collection_relief加service_fee加interest加principle之和()
    xianjindai.校验xjd_repay_plan_repay_record_ref中总减免是否等于红包减免加催收减免()
    xianjindai.校验xjd_repay_plan_repay_record_ref中red_package和remain_income不能同时大于零()
    xianjindai.校验user_repayment_plan_repay_statusd等于3时_实还本金_利息_服务费_罚息_余额减去所有减免与current_repayment是否一致()
    xianjindai.校验user_replayment_plan中的红包_其他减免等于催收减免()
    xianjindai.校验所有资金方对应流水号_每个流水号对应的还资金方表的金额和是否一致()
    xianjindai.校验xjd_repay_plan_repay_record_ref表中还款流水与还款计划中的实还金额和实还流水是否一致()
    xianjindai.校验xjd_repay_plan_repay_record_ref中ref_amount是否等于principle_interest_service_fee_punish之和减去collection_relief()

