# -*- coding:utf-8 -*-
# Author: Perry_Zhu

import datetime
import sys

import pandas as pd
from sqlalchemy import create_engine

reload(sys)
sys.setdefaultencoding('utf8')

engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong_rw:TouBStYwN8wkdxVt@172.16.3.201:3306/new_transaction?charset=utf8',
    echo=True)
engine_xyqb = create_engine('mysql+mysqldb://syzhu_data_r:ulk0989742097y43@192.168.4.6:8066/xyqb?charset=utf8',
                            echo=True)

start_time = '2017-08-01'
end_time = '2017-10-01'
end_y = 2017
end_m = 10

path = u'E:/数据汇总/白条/每日赔付/'
end_date = datetime.date(end_y, end_m, 1)
# 还资金方还款计划
loan_plan_hk = '''
    SELECT 
      t.day_hk,t.order_no,t.ref_id,t.term_no,t.loan_paid_at,
        sum(t.principle)principle,SUM(t.plan_all) plan_all
    FROM(
        SELECT DATE(plan.deadline) day_hk,plan.order_no,plan.ref_id,
          plan.term_no,DATE(t2.loan_paid_at)loan_paid_at,
          sum(ifnull(plan.principal,0))principle,SUM(ifnull(plan.principal,0)+ifnull(plan.interest,0)) plan_all
        FROM  bt_funding_repayment_plan plan
        JOIN user_bt_repayment_plan t1 on plan.repay_plan_id=t1.repayment_plan_id AND t1.sys_tag='XYQB_BILL_BT'
        JOIN baitiao_audit.baitiao_order t2 ON t1.ref_id=t2.ref_id
        WHERE 
         plan.refund_status!=3
        AND plan.funding_code=%s and plan.deadline >= '%s' AND plan.deadline < '%s'  
        GROUP BY 1,2,3

         UNION ALL 
          SELECT DATE(plan.deadline) day_hk,plan.order_no,plan.ref_id,
          plan.term_no,DATE(t2.loan_paid_at)loan_paid_at,
           0.0 principle,SUM(ifnull(plan.interest,0)) plan_all
        FROM  bt_funding_repayment_plan plan
        JOIN user_bt_repayment_plan t1 on plan.repay_plan_id=t1.repayment_plan_id AND t1.sys_tag='XYQB_BILL_BT'
        JOIN baitiao_audit.baitiao_order t2 ON t1.ref_id=t2.ref_id
        WHERE 
         plan.refund_status=3
        AND plan.funding_code=%s and plan.deadline >= '%s' AND plan.deadline < '%s'  
        GROUP BY 1,2,3
    )t 
    GROUP BY 1,2,3
'''
loan_plan_amount = """
 SELECT 
      t.day_hk,t.order_no,t.term_no,t.loan_paid_at,
        sum(t.principle)principle,SUM(t.principle+t.interest) plan_all
    FROM(
        SELECT DATE(plan.deadline) day_hk,plan.order_no,
          plan.term_no,DATE(t2.loan_paid_at)loan_paid_at,
          sum(ifnull(plan.principal,0))principle,0.0 interest
        FROM  bt_funding_repayment_record plan
        JOIN user_bt_repayment_plan t1 on plan.repay_plan_id=t1.repayment_plan_id AND t1.sys_tag='XYQB_BILL_BT' 
            AND plan.principal_account=%s AND plan.refund_status!=3
        JOIN baitiao_audit.baitiao_order t2 ON t1.ref_id=t2.ref_id
        WHERE 

         plan.funding_code=%s and plan.deadline >= '%s' AND plan.deadline < '%s'  
        GROUP BY 1,2,3

         UNION ALL 
          SELECT DATE(plan.deadline) day_hk,plan.order_no,
          plan.term_no,DATE(t2.loan_paid_at)loan_paid_at,
           0.0 principle,SUM(ifnull(plan.interest,0)) interest
        FROM  bt_funding_repayment_record plan
        JOIN user_bt_repayment_plan t1 on plan.repay_plan_id=t1.repayment_plan_id AND t1.sys_tag='XYQB_BILL_BT'  
            AND plan.interest_account=%s AND plan.refund_status!=3
        JOIN baitiao_audit.baitiao_order t2 ON t1.ref_id=t2.ref_id
        WHERE 
         plan.funding_code=%s and plan.deadline >= '%s' AND plan.deadline < '%s'  
        GROUP BY 1,2,3
    )t 
    GROUP BY 1,2,3
"""
loan_pri_zbj = '''
        SELECT plan.order_no,plan.term_no,sum(ifnull(plan.principal,0))zbj_principle
        FROM  bt_funding_repayment_record plan
        JOIN user_bt_repayment_plan t1 on plan.repay_plan_id=t1.repayment_plan_id AND t1.sys_tag='XYQB_BILL_BT' 
          AND plan.principal_account=%s AND plan.refund_status!=3
        JOIN baitiao_audit.baitiao_order t2 ON t1.ref_id=t2.ref_id
        WHERE 
         plan.funding_code=%s and plan.deadline >= '%s' AND plan.deadline < '%s'  
        GROUP BY 1,2
'''
loan_int_zbj = '''
        SELECT plan.order_no,plan.term_no,sum(ifnull(plan.interest,0))zbj_interest
        FROM  bt_funding_repayment_record plan
        JOIN user_bt_repayment_plan t1 on plan.repay_plan_id=t1.repayment_plan_id AND t1.sys_tag='XYQB_BILL_BT' 
          AND plan.interest_account=%s AND plan.refund_status!=3
        JOIN baitiao_audit.baitiao_order t2 ON t1.ref_id=t2.ref_id
        WHERE 
         plan.funding_code=%s and plan.deadline >= '%s' AND plan.deadline < '%s'  
        GROUP BY 1,2
'''

loan_hk_online = '''
    SELECT t3.order_no,t3.term_no,DATE(t2.bill_time) repaid_at ,DATE(plan.deadline) deadline ,
      sum(ifnull(t1.principle,0)-ifnull(t1.mitigate_principle,0)) real_principle,
      sum(ifnull(t1.interest,0)-ifnull(t1.mitigate_interest,0)) real_interest
    FROM baitiao_repay_plan_repay_record_ref t1
    JOIN repay_record_online t2 ON t1.record_id = t2.id AND t1.repay_channel in(22,23,24)
    JOIN user_bt_repayment_plan t3 ON t1.plan_id = t3.id AND t3.sys_tag='XYQB_BILL_BT'
    JOIN bt_funding_repayment_record plan on plan.repay_plan_id=t3.repayment_plan_id  AND plan.refund_status!=3
    JOIN baitiao_audit.baitiao_order t4 ON t4.ref_id=t3.ref_id AND t4.is_active = 1
    WHERE   
    (ifnull(t1.principle,0)-ifnull(t1.mitigate_principle,0))>0
    AND t4.funding_corp_id = %s 
    and t2.bill_time >= '%s' 
    and t2.bill_time < '%s'
    GROUP BY  1,2 '''

loan_hk_ali = '''
    SELECT t3.order_no,t3.term_no,DATE(t2.transfer_time) repaid_at,DATE(plan.deadline) deadline ,
      sum(ifnull(t1.principle,0)-ifnull(t1.mitigate_principle,0)) real_principle,
      sum(ifnull(t1.interest,0)-ifnull(t1.mitigate_interest,0)) real_interest
    FROM baitiao_repay_plan_repay_record_ref t1
    JOIN offline_alipay_record t2 ON  t1.record_id = t2.id AND t1.repay_channel = 13
    JOIN user_bt_repayment_plan t3 ON t1.plan_id = t3.id AND t3.sys_tag='XYQB_BILL_BT'
    JOIN bt_funding_repayment_record plan on plan.repay_plan_id=t3.repayment_plan_id  AND plan.refund_status!=3
    JOIN baitiao_audit.baitiao_order t4 ON t4.ref_id=t3.ref_id AND t4.is_active = 1
    WHERE  
      t4.funding_corp_id=%s 
    and t2.transfer_time >= '%s' 
    and  t2.transfer_time < '%s'
    GROUP BY  1,2
'''

tx_amount = 1
sr_amount = 2
zbj_amount = 3


# 按loan_id出的每日赔付
def spread_loan_id(funding_code):
    df_plan = pd.read_sql(loan_plan_hk % (funding_code, start_time, end_time, funding_code, start_time, end_time),
                          engine_new_transaction)
    df_tx = pd.read_sql(loan_plan_amount % (tx_amount, funding_code, start_time, end_time,
                                            tx_amount, funding_code, start_time, end_time), engine_new_transaction)
    df_tx.rename(columns={'principle': 'tx_principle', 'plan_all': 'tx_plan_all'}, inplace=True)
    df_sr = pd.read_sql(loan_plan_amount % (sr_amount, funding_code, start_time, end_time,
                                            sr_amount, funding_code, start_time, end_time), engine_new_transaction)
    df_sr.rename(columns={'principle': 'sr_principle', 'plan_all': 'sr_plan_all'}, inplace=True)

    df_zbj_all = pd.read_sql(loan_plan_amount % (zbj_amount, funding_code, start_time, end_time,
                                                 zbj_amount, funding_code, start_time, end_time),
                             engine_new_transaction)
    df_zbj_all.rename(columns={'principle': 'zbj_principle', 'plan_all': 'zbj_plan_all'}, inplace=True)

    df_zbj_p = pd.read_sql(loan_pri_zbj % (zbj_amount, funding_code, start_time, end_time), engine_new_transaction)
    df_zbj_i = pd.read_sql(loan_int_zbj % (zbj_amount, funding_code, start_time, end_time), engine_new_transaction)
    df_zbj = pd.merge(df_zbj_p, df_zbj_i, on=['order_no', 'term_no'], how='left')
    df_zbj.fillna(0, inplace=True)
    df_plan = pd.merge(df_plan, df_zbj, on=['order_no', 'term_no'], how='left')
    df_plan.fillna(0, inplace=True)
    df_plan.order_no = df_plan.order_no.astype(str)
    df_plan.term_no = df_plan.term_no.astype(int)
    df_hk_online = pd.read_sql(loan_hk_online % (funding_code, start_time, end_time), engine_new_transaction)
    df_hk_ali = pd.read_sql(loan_hk_ali % (funding_code, start_time, end_time), engine_new_transaction)
    df_repay = pd.concat([df_hk_online, df_hk_ali], axis=0, ignore_index=True)
    df_repay['repaid_at'] = pd.to_datetime(df_repay['repaid_at']).apply(lambda x: x.date())
    df_repay['deadline'] = pd.to_datetime(df_repay['deadline']).apply(lambda x: x.date())
    df_repay.order_no = df_repay.order_no.astype(str)
    df_repay.term_no = df_repay.term_no.astype(int)
    # 正常还款
    df_zc = df_repay.ix[df_repay['repaid_at'] == df_repay['deadline']]
    df_zc = df_zc.groupby(by=['order_no', 'term_no'])['real_principle', 'real_interest'].sum().reset_index()
    df_zc.rename(columns={'real_principle': 'zc_prin_total', 'real_interest': 'zc_inte_total'}, inplace=True)

    # ===========逾期还款==============
    df_yq = df_repay.ix[df_repay['deadline'] < df_repay['repaid_at']]
    df_yq = df_yq.groupby(by=['order_no', 'term_no'])['real_principle', 'real_interest'].sum().reset_index()

    df_yq.rename(columns={'real_principle': 'yq_prin_total', 'real_interest': 'yq_inte_total'}, inplace=True)
    # ============提前还款==============
    df_tq = df_repay.ix[df_repay['deadline'] > df_repay['repaid_at']]
    # 实还可用筛选
    df_tq = df_tq.ix[df_tq['deadline'] < end_date]
    # 提前还款的可用日期变更
    df_tq = df_tq.groupby(by=['order_no', 'term_no'])['real_principle', 'real_interest'].sum().reset_index()
    df_tq.rename(columns={'real_principle': 'tq_prin_total', 'real_interest': 'tq_inte_total'}, inplace=True)
    # 合并
    df_hk_new = pd.merge(df_zc, df_yq, how='outer', on=['order_no', 'term_no'])
    df_hk_new = pd.merge(df_hk_new, df_tq, how='outer', on=['order_no', 'term_no'])
    df_hk_tx = pd.merge(df_tx, df_hk_new, how='left', on=['order_no', 'term_no'])
    df_hk_tx = df_hk_tx[['order_no', 'term_no', 'zc_prin_total', 'yq_prin_total', 'tq_prin_total', 'tx_plan_all']]
    df_hk_tx.rename(columns={'zc_prin_total': 'tx_zc_principle', 'yq_prin_total': 'tx_yq_principle',
                             'tq_prin_total': 'tx_tq_principle'}, inplace=True)

    df_hk_sr = pd.merge(df_sr, df_hk_new, how='left', on=['order_no', 'term_no'])
    df_hk_sr = df_hk_sr[['order_no', 'term_no', 'zc_prin_total', 'yq_prin_total', 'tq_prin_total', 'sr_plan_all']]
    df_hk_sr.rename(columns={'zc_prin_total': 'sr_zc_principle', 'yq_prin_total': 'sr_yq_principle',
                             'tq_prin_total': 'sr_tq_principle'}, inplace=True)
    df_hk_zbj = pd.merge(df_zbj_all, df_hk_new, how='left', on=['order_no', 'term_no'])
    df_hk_zbj = df_hk_zbj[['order_no', 'term_no', 'zc_prin_total', 'yq_prin_total', 'tq_prin_total', 'zbj_plan_all']]
    df_hk_zbj.rename(columns={'zc_prin_total': 'zbj_zc_principle', 'yq_prin_total': 'zbj_yq_principle',
                              'tq_prin_total': 'zbj_tq_principle'}, inplace=True)
    df_hk_new = pd.merge(df_plan, df_hk_new, how='outer', on=['order_no', 'term_no'])
    df_hk_new = pd.merge(df_hk_new, df_hk_tx, how='left', on=['order_no', 'term_no'])
    df_hk_new = pd.merge(df_hk_new, df_hk_sr, how='left', on=['order_no', 'term_no'])
    df_hk_new = pd.merge(df_hk_new, df_hk_zbj, how='left', on=['order_no', 'term_no'])
    df_hk_new.fillna(0, inplace=True)
    df_hk_new['real_all'] = df_hk_new['zc_prin_total'] + df_hk_new['yq_prin_total'] + df_hk_new['tq_prin_total']
    df_hk_new = df_hk_new[
        ['order_no', 'term_no', 'loan_paid_at', 'day_hk', 'zbj_principle', 'zbj_interest', 'plan_all', 'zc_prin_total',
         'yq_prin_total', 'tq_prin_total', 'tx_plan_all', 'tx_zc_principle', 'tx_yq_principle', 'tx_tq_principle',
         'sr_plan_all', 'sr_zc_principle', 'sr_yq_principle', 'sr_tq_principle', 'zbj_plan_all', 'zbj_zc_principle',
         'zbj_yq_principle', 'zbj_tq_principle', 'real_all']]
    df_hk_new.rename(columns={'day_hk': '还款日期', 'plan_all': '应还资金方本息', 'real_all': '客户实还可用',
                              'zbj_principle': '质保金账户代偿本金', 'zbj_interest': '质保金账户代偿利息',
                              'zc_prin_total': '客户正常还款本金', 'yq_prin_total': '客户逾期还款本金',
                              'tq_prin_total': '客户提前可用本金', 'tx_zc_principle': '提现账户客户正常还款本金',
                              'tx_yq_principle': '提现账户客户逾期还款本金', 'tx_tq_principle': '提现账户客户提前可用本金',
                              'sr_zc_principle': '收入账户客户正常还款本金', 'sr_yq_principle': '收入账户客户逾期还款本金',
                              'sr_tq_principle': '收入账户客户提前可用本金', 'zbj_zc_principle': '质保金账户客户正常还款本金',
                              'tx_plan_all': '提现账户应还资方本息', 'sr_plan_all': '收入账户应还资方本息',
                              'zbj_plan_all': '质保金账户应还资方本息', 'zbj_yq_principle': '质保金账户客户逾期还款本金',
                              'zbj_tq_principle': '质保金账户客户提前可用本金'}, inplace=True)
    df_hk_new.to_excel(path + str(funding_code) + 'loan_id维度展开10-08-02.xlsx', index=None, columns=df_hk_new.columns,
                       encoding='utf8')


spread_loan_id(5)
