# -*- coding: utf-8 -*-
import sys
import numpy as np
import pandas as pd
from sqlalchemy import create_engine
import datetime
reload(sys)
sys.setdefaultencoding('utf8')


'''
@author linfang
根据 客户等级+赔付日为维度
渤海信托（660万），以及 张初阳220万(ref_id = 1,2,3)
'''

path='E:/peifu/peifu_v6/'
loan_year=2016
listen_time=datetime.date(2017,7,1)

df_pay=pd.read_csv(path+'loan.csv')
#扣除新马上,渤海信托
df_pay=df_pay.ix[~df_pay.funding_code.isin([160,270])]
df_pay.loan_paid_at=pd.to_datetime(df_pay.loan_paid_at).dt.date
df_pay['loan_year']=df_pay.loan_paid_at.apply(lambda x:x.year)
df_pay=df_pay.ix[df_pay.loan_year == loan_year]
df_pay.ref_id = df_pay.ref_id.astype(int)

#=====剔除 50，80，130 那三笔
df_pay=df_pay.ix[~df_pay.ref_id.isin([1,2,3])]

df_class=pd.read_csv(path+'loan_class.csv')
df_class.ref_id=df_class.ref_id.astype(int)
df_pay=pd.merge(df_pay,df_class,on='ref_id',how='left')
#放款金额
df_pay_gp=df_pay.groupby(['class','funding_code','loan_paid_at'])['loan_amount'].sum()\
    .reset_index().rename(columns={'funding_code':'fund_code','loan_paid_at':'day_hk','loan_amount':'放款金额'})

#资金方应还
df_fund=pd.read_csv(path+'fund.csv')
print '---------------fund is null---------',df_fund.ix[df_fund.funding_code.isnull()]
df_fund=df_fund.ix[~df_fund.funding_code.isnull()]
df_fund.funding_code=df_fund.funding_code.astype(int)
df_fund=df_fund.ix[~df_fund.funding_code.isin([1, 2, 3, 4, 5,210,270,310,320,50,80,130])]
df_plan=pd.read_csv(path+'plan.csv')
df_plan.funding_code=df_plan.funding_code.astype(int)
df_plan=df_plan.ix[df_plan.funding_code.isin([1, 2, 3, 4, 5,210,270,310,320])]
df_acd=pd.read_csv(path+'ACD.csv')
df_acd.funding_code=df_acd.funding_code.astype(int)
df_acd=df_acd.ix[df_acd.funding_code.isin([50,80,130])]
df_fund_all=pd.concat([df_fund,df_plan,df_acd],ignore_index=True)
df_fund_all.ref_id=df_fund_all.ref_id.astype(int)
#对应的放款-- 这儿注意 ACD 的那三笔大额的缺少，ref_id = 1,2,3
df_fund_all=df_fund_all.ix[df_fund_all.ref_id.isin(df_pay.ref_id)]

#deadline 在观察时间点之前的应还
df_fund_all.fund_deadline=pd.to_datetime(df_fund_all.fund_deadline).dt.date
df_fund_all = pd.merge(df_fund_all,df_class,on='ref_id',how='left')
#虚记的那三笔大额默认等级为A
df_fund_all.ix[df_fund_all.ref_id.isin([1,2,3]),'class'] = 'A'
print '-------------',df_fund_all['fund_prin_inst'].sum()
#资金方应还
df_fund_all_gp = df_fund_all.ix[df_fund_all.fund_deadline < listen_time]
df_fund_all_gp = df_fund_all_gp.groupby(['class','funding_code','fund_deadline'])['fund_prin_inst'].sum()\
    .reset_index().rename(columns={'funding_code':'fund_code','fund_deadline':'day_hk'})

#客户实还
df_repay_online=pd.read_csv(path+'repay_online.csv')
df_repay_offline=pd.read_csv(path+'repay_offline.csv')
df_repay=pd.concat([df_repay_online,df_repay_offline],ignore_index=True)
df_repay=df_repay.ix[df_repay.fund_code != 160]
df_repay=pd.merge(df_repay,df_class,on='ref_id',how='left')
#提取放款时间
df_repay.ref_id=df_repay.ref_id.astype(int)
df_repay=df_repay.ix[df_repay.ref_id.isin(df_pay.ref_id)]
df_repay_other=df_repay.ix[~df_repay.fund_code.isin([150,29,50,80,130])]
df_repay_fund_deadline=df_repay.ix[df_repay.fund_code.isin([150,29,50,80,130])]
df_repay_fund_deadline=pd.merge(df_repay_fund_deadline,df_fund_all[['ref_id','term_no','fund_deadline']],on=['ref_id','term_no'],how='left')
print '-----------lost fund_deadline-----------',df_repay_fund_deadline.ix[df_repay_fund_deadline.fund_deadline.isnull()]
df_repay_fund_deadline.deadline=df_repay_fund_deadline.fund_deadline
df_repay=pd.concat([df_repay_other,df_repay_fund_deadline[df_repay_other.columns]],ignore_index=True)
df_repay.repaid_at=pd.to_datetime(df_repay.repaid_at).dt.date
df_repay.deadline=pd.to_datetime(df_repay.deadline).dt.date
print '--------df_repay-----',df_repay['real_prin_inst'].sum()
#--- 实还可用，逾期收回本息，实收服务费，实收罚息，逾期收回本息，逾期收回服务费，逾期收回罚息
#实还可用
df_1=(df_repay.ix[(df_repay.repaid_at < listen_time) & (df_repay.repaid_at <= df_repay.deadline)]).groupby(['class','fund_code','deadline'])['real_prin_inst'].sum()\
    .reset_index().rename(columns={'deadline':'day_hk','real_prin_inst':'客户实还可用'})
#逾期收回本息
df_2=(df_repay.ix[(df_repay.repaid_at < listen_time) & (df_repay.repaid_at > df_repay.deadline)]).groupby(['class','fund_code','deadline'])['real_prin_inst'].sum()\
    .reset_index().rename(columns={'deadline':'day_hk','real_prin_inst':'逾期收回本息'})
#实收服务费，实收罚息
df_3=(df_repay.ix[(df_repay.repaid_at < listen_time) ]).groupby(['class','fund_code','repaid_at'])['real_service_fee','real_punish'].sum()\
    .reset_index().rename(columns={'repaid_at':'day_hk','real_service_fee':'实收服务费','real_punish':'实收罚息'})
#逾期收回本息，逾期收回服务费，逾期收回罚息
if loan_year == 2015:
    df_4=(df_repay.ix[(df_repay.repaid_at < datetime.date(2017,7,1))&(df_repay.repaid_at > df_repay.deadline)]).groupby(['class','fund_code','repaid_at'])['real_prin_inst','real_service_fee','real_punish'].sum()\
        .reset_index().rename(columns={'repaid_at':'day_hk','real_prin_inst':'逾期收回本息170630','real_service_fee':'逾期收回服务费170630','real_punish':'逾期收回罚息170630'})
else:
    df_4=pd.DataFrame(columns=['class','fund_code','day_hk','逾期收回本息170630','逾期收回服务费170630','逾期收回罚息170630'])


df_new=pd.merge(df_fund_all_gp,df_pay_gp,on=['class','fund_code','day_hk'],how='outer')\
    .merge(df_1,on=['class','fund_code','day_hk'],how='outer')\
    .merge(df_2,on=['class','fund_code','day_hk'],how='outer')\
    .merge(df_3,on=['class','fund_code','day_hk'],how='outer')\
    .merge(df_4,on=['class','fund_code','day_hk'],how='outer')
df_new.fillna(0,inplace=True)
df_new.to_csv(path+'peifu_time_%d.csv' % loan_year)

