# -*- coding: utf8 -*-
import sys
import numpy as np
import pandas as pd
import datetime
from sqlalchemy import create_engine

# reload(sys)
# sys.setdefaultencoding('utf8')

'''
根据loan_id 展开赔付
注意：首先根据 导出数据.sql 执行将数据导出到对应的文件中
涉及到的文件： loan_{year}.csv  fund_{year}.csv plan_{year}.csv ACD_{year}.csv 
repay_online_{year}.csv repay_offline_{year}.csv 
fund_kaola_{year}.csv fund_kjmx_{year}.csv
hr_repay_online_{year}.csv hr_repay_offline_{year}.csv
kjmx_repay_online_{year}.csv kjmx_repay_offline_{year}.csv

说明：
1、考拉应还资金方金额  将 2017.1.1 号的应还 计算到 2016年
2、橘子理财、小嬴理财、口袋理财、米庄理财 将 2017.1.1-2017.1.2 号的结算到 2016年
3、华融的实还金额中加入 实还时间 2017.1.1-2017.1.10 号 应还在 2016年的还款统计到 2016年
4、晋商的 2016.12.30-2016.12.31 的应还资金方金额归为 0 
5、针对考拉（T+1），橘子理财、小嬴理财、口袋理财、米庄理财 （T+2） 各自的 应还 提前1天或2天，所以这5个资金方的对应的 实际还款 也需要提前到 2016年

数据基于 linfang/ 下的一样
'''

engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong_rw:TouBStYwN8wkdxVt@172.16.3.201:3306/all_back_0630?charset=utf8',
    echo=True)

path = 'E:/peifu/2016/'

year = 2016
time = datetime.date(2017, 1, 1)

df_pay = pd.read_csv(path + 'loan_%d.csv' % year, low_memory=False)
df_pay.loan_paid_at = pd.to_datetime(df_pay.loan_paid_at).dt.date
df_pay = df_pay.ix[df_pay.funding_code != 270]

df_fund = pd.read_csv(path + 'fund.csv', low_memory=False)
df_fund=df_fund.ix[~df_fund.funding_code.isin([135,240,290])]
df_135=pd.read_csv(path + 'fund_135.csv')
df_plan=pd.read_csv(path+'plan.csv')
df_acd=pd.read_csv(path+'ACD.csv')
df_fund=pd.concat([df_fund,df_plan,df_acd,df_135],axis=0,ignore_index=True)
df_fund_1=df_fund.ix[df_fund.funding_code.isin([141,50,80,130])]
df_fund_2=df_fund.ix[~df_fund.funding_code.isin([141,50,80,130])]
df_fund_1.drop_duplicates(['ref_id','term_no'],inplace=True)
df_fund=pd.concat([df_fund_1,df_fund_2],axis=0,ignore_index=True)
df_fund.fillna(0, inplace=True)
df_fund = df_fund.groupby(['ref_id','term_no','fund_deadline','funding_code'])['fund_prin_inst'].sum().reset_index()
# df_fund = df_fund.loc[~df_fund.funding_code.isin([0, 1, 2, 3, 4, 5,210])]
# if year == 2016:
#     df_plan = pd.read_csv(path + 'plan_%d.csv' % year, low_memory=False)
#     df_acd = pd.read_csv(path + 'ACD_%d.csv' % year, low_memory=False)
#     df_kaola = pd.read_csv(path + 'fund_kaola_%d.csv' % year, low_memory=False)
#     df_kaola.fund_deadline = pd.to_datetime(df_kaola.fund_deadline).dt.date
#     # T+1处理
#     df_kaola.loc[df_kaola.fund_deadline >= time, 'fund_deadline'] = datetime.date(2016, 12, 31)
#     # T+2处理
#     df_kjxm = pd.read_csv(path + 'fund_kjmx_%d.csv' % year, low_memory=False)
#     df_kjxm.fund_deadline = pd.to_datetime(df_kjxm.fund_deadline).dt.date
#     df_kjxm.loc[df_kjxm.fund_deadline >= time, 'fund_deadline'] = datetime.date(2016, 12, 31)
#     df_fund = pd.concat([df_fund, df_plan, df_acd, df_kaola, df_kjxm], ignore_index=True)

# df_fund.ref_id = df_fund.ref_id.apply(lambda x: str(x).replace('.0', ''))
df_fund.ref_id = df_fund.ref_id.astype(int)
df_fund.funding_code = df_fund.funding_code.astype(int)
df_fund.term_no = df_fund.term_no.astype(int)
# 计算资金方应还的金额
df_fund.fund_deadline = pd.to_datetime(df_fund.fund_deadline).dt.date
# TODO
df_fund.ix[(df_fund.funding_code == 140) & (df_fund.fund_deadline >= datetime.date(2017,1,1)) & (df_fund.fund_deadline < datetime.date(2017,1,3)),'fund_prin_inst'] = 0

# # 客户还款--还款时间2016年
# df_online_repay = pd.read_csv(path + 'repay_online.csv', low_memory=False)
# df_offline_repay = pd.read_csv(path + 'repay_offline.csv', low_memory=False)
# df_repay = pd.concat([df_online_repay, df_offline_repay], ignore_index=True)
# df_repay.deadline = pd.to_datetime(df_repay.deadline).dt.date
# df_repay.repaid_at = pd.to_datetime(df_repay.repaid_at).dt.date
#
# df_repay = df_repay.loc[df_repay.fund_code != 160]
# # 考拉
# df_repay.loc[(df_repay.fund_code == 170) & (df_repay.deadline >= datetime.date(2017, 1, 2)), 'real_prin_inst'] = 0
# df_repay.loc[
#     (df_repay.fund_code == 170) & (df_repay.deadline == datetime.date(2017, 1, 1)), 'deadline'] = datetime.date(
#     2016, 12, 31)
# # 橘子小樱米庄
# df_repay.loc[(df_repay.fund_code.isin([230, 240, 250, 260])) & (
#     df_repay.deadline >= datetime.date(2017, 1, 3)), 'real_prin_inst'] = 0
# df_repay.loc[
#     (df_repay.fund_code.isin([230, 240, 250, 260])) & (
#         df_repay.deadline < datetime.date(2017, 1, 3)), 'deadline'] = datetime.date(2016, 12, 31)
# # 其他资金方--除去还资金方
# df_repay.loc[(df_repay.fund_code != 150) & (df_repay.deadline >= datetime.date(2017, 1, 1)), 'real_prin_inst'] = 0
#
# # 考拉
# df_repay.loc[
#     (df_repay.fund_code == 170) & (df_repay.repaid_at >= datetime.date(2017, 1, 2)), 'real_prin_inst'] = 0
# df_repay.loc[
#     (df_repay.fund_code == 170) & (df_repay.deadline > datetime.date(2017, 1, 2)), 'real_prin_inst'] = 0
# # 小嬴橘子米庄口袋理财T+2
# df_repay.loc[(df_repay.fund_code.isin([230, 240, 250, 260])) & (
#     df_repay.deadline >= datetime.date(2017, 1, 3)), 'real_prin_inst'] = 0


# 客户还款--还款时间2016年
# df_online_repay = pd.read_csv(path + 'repay_online_%d.csv' % year)
# df_offline_repay = pd.read_csv(path + 'repay_offline_%d.csv' % year)

df_online_repay = pd.read_csv(path + 'repay_online.csv')
df_offline_repay = pd.read_csv(path + 'repay_offline.csv')

df_repay = pd.concat([df_online_repay, df_offline_repay], ignore_index=True)
df_repay = df_repay.ix[df_repay.fund_code !=160]
df_repay.repaid_at=pd.to_datetime(df_repay.repaid_at).dt.date
df_repay.deadline=pd.to_datetime(df_repay.deadline).dt.date
# TODO
df_repay.ix[(df_repay.fund_code == 140 ) & (df_repay.repaid_at >=datetime.date(2017,1,1)) & (df_repay.repaid_at < datetime.date(2017,1,3)) &
            (df_repay.deadline < datetime.date(2017,1,3)),'real_prin_inst'] = 0

df_repay.ix[(df_repay.fund_code == 140 ) & (df_repay.deadline >=datetime.date(2017,1,1)) & (df_repay.deadline < datetime.date(2017,1,3)) &
            (df_repay.repaid_at < datetime.date(2017,1,3)),'real_prin_inst'] = 0

# 考拉
# df_repay.ix[(df_repay.fund_code == 170) & (df_repay.deadline >= '2017-01-01'), 'real_prin_inst'] = 0

# df_repay.ix[(df_repay.fund_code == 170) & (df_repay.deadline == '2017-01-01'), 'repaid_at'] = '2016-12-31'
# df_repay.ix[(df_repay.fund_code == 170) & (df_repay.deadline == '2017-01-01'), 'deadline'] = '2016-12-31'
# 橘子小樱米庄
# df_repay.ix[(df_repay.fund_code.isin([230, 240, 250, 260])) & (df_repay.deadline >= '2017-01-03'), 'real_prin_inst'] = 0

# df_repay.ix[(df_repay.fund_code.isin([230, 240, 250, 260])) & (df_repay.deadline >= '2017-01-01') & (df_repay.deadline < '2017-01-03'), 'repaid_at'] = '2016-12-31'

# df_repay.ix[
    # (df_repay.fund_code.isin([230, 240, 250, 260])) & (df_repay.deadline >= '2017-01-01') & (df_repay.deadline < '2017-01-03'), 'deadline'] = '2016-12-31'
# 其他资金方--除去还资金方
# df_repay.ix[(df_repay.fund_code != 150) & (df_repay.deadline >= '2017-01-01'), 'real_prin_inst'] = 0
# 华融---需要使用还资金方时间

# 华融逾期还款
# df_hr_online_repay = pd.read_csv(path + 'hr_repay_online_%d.csv' % year)
# df_hr_offline_repay = pd.read_csv(path + 'hr_repay_offline_%d.csv' % year)
# 考拉橘子小樱米庄 2017.1.1-2017.1.2
# df_kjxm_online_repay = pd.read_csv(path + 'kjmx_repay_online_2016.csv')
# df_kjxm_offline_repay = pd.read_csv(path + 'kjmx_repay_offline_2016.csv')
# df_kjxm_repay = pd.concat([df_kjxm_online_repay, df_kjxm_offline_repay], ignore_index=True)
# 考拉
# df_kjxm_repay.ix[(df_kjxm_repay.fund_code == 170) & (df_kjxm_repay.repaid_at >= '2017-01-02'), 'real_prin_inst'] = 0
# df_kjxm_repay.ix[(df_kjxm_repay.fund_code == 170) & (df_kjxm_repay.deadline > '2017-01-02'), 'real_prin_inst'] = 0
# 小嬴橘子米庄口袋理财T+2
# df_kjxm_repay.ix[(df_kjxm_repay.fund_code.isin([230, 240, 250, 260])) & (
# df_kjxm_repay.deadline >= '2017-01-03'), 'real_prin_inst'] = 0

# df_repay = pd.concat([df_repay, df_hr_online_repay, df_hr_offline_repay, df_kjxm_repay], ignore_index=True)
df_repay.repaid_at = pd.to_datetime(df_repay.repaid_at).dt.date


# df_repay.term_no = df_repay.term_no.astype(int)
# df_repay.ref_id = df_repay.ref_id.astype(int)
# df_repay_other = df_repay.loc[~df_repay.fund_code.isin([150, 29, 50, 80, 130])]
#
# # 使用资金方的deadline
# df_repay_fund_deadline = df_repay.loc[df_repay.fund_code.isin([150, 29, 50, 80, 130])]
# df_repay_fund_deadline = pd.merge(df_fund, df_repay_fund_deadline, on=['ref_id', 'term_no'], how='inner')
# df_repay_fund_deadline = df_repay_fund_deadline.loc[df_repay_fund_deadline.fund_deadline < datetime.date(2017, 7, 1)]

peifu_sum = 0
res = []

def get_fund(start_date, end_date):
    global peifu_sum
    df_pay_current = df_pay.loc[(df_pay.loan_paid_at >= start_date) & (df_pay.loan_paid_at < end_date)]

    df_fund_plan_current = df_fund.loc[(df_fund.ref_id.isin(df_pay_current.ref_id)) & (df_fund.fund_deadline >= start_date) & (df_fund.fund_deadline < end_date)]
    df_fund_plan_after = df_fund.loc[(df_fund.ref_id.isin(df_pay_current.ref_id)) & (df_fund.fund_deadline >= end_date)]

    # df_repay_other_current = df_repay_other.loc[
    #     (df_repay_other.repaid_at >= start_date) & (df_repay_other.repaid_at < end_date)]
    # df_repay_other_after = df_repay_other.loc[df_repay_other.repaid_at >= end_date]

    # df_repay_fund_deadline_current = df_repay_fund_deadline.loc[
    #     (df_repay_fund_deadline.repaid_at >= start_date) & (df_repay_fund_deadline.repaid_at < end_date)]
    # df_repay_fund_deadline_after = df_repay_fund_deadline.loc[df_repay_fund_deadline.repaid_at >= end_date]

    df_repay_current = df_repay.loc[(df_repay.ref_id.isin(df_pay_current.ref_id)) & (df_repay.repaid_at >= start_date) & (df_repay.repaid_at < end_date)]
    df_repay_after = df_repay.loc[(df_repay.ref_id.isin(df_pay_current.ref_id)) & (df_repay.repaid_at >= end_date)]

    # 当季
    # 晋商 2016.12.30-12.31 还资金方为0
    # df_fund_plan.loc[(df_fund_plan.funding_code == 180) & (
    # df_fund_plan.fund_deadline >= datetime.date(2016, 12, 30)), 'fund_prin_inst'] = 0
    df_fund_plan_current = df_fund_plan_current.groupby(['ref_id','term_no'])['fund_prin_inst'].sum().reset_index()
    df_repay_current = df_repay_current.groupby(['ref_id','term_no'])['real_prin_inst'].sum().reset_index()
    # df_repay_fund_deadline_current = df_repay_fund_deadline_current.groupby('ref_id')[
    #     'real_prin_inst'].sum().reset_index()

    # df_repay_real_current = pd.concat([df_repay_other_current, df_repay_fund_deadline_current], ignore_index=True)

    df_current = pd.merge(df_pay_current, df_fund[['ref_id', 'term_no','fund_deadline']], on='ref_id', how='left')
    df_current = pd.merge(df_current, df_fund_plan_current, on=['ref_id', 'term_no'], how='outer')
    df_current = pd.merge(df_current, df_repay_current, on=['ref_id','term_no'], how='outer')
    df_current.fillna(0, inplace=True)
    df_current['peifu'] = np.round(df_current.fund_prin_inst - df_current.real_prin_inst, 2)
    # df_current = df_current.loc[df_current['peifu'] != 0]
    # df_current = df_current.loc[(df_current['peifu'] > 0.5) | (df_current['peifu'] < -0.5)]
    peifu_sum += df_current['peifu'].sum()
    df_current.to_csv(path + 'peifu_current(%s).csv' % str(end_date + datetime.timedelta(days=-1)), index=None)

    # 季后
    df_fund_plan_after = df_fund_plan_after.groupby(['ref_id','term_no'])['fund_prin_inst'].sum().reset_index()
    df_repay_after = df_repay_after.groupby(['ref_id','term_no'])['real_prin_inst'].sum().reset_index()
    # df_repay_fund_deadline_after = df_repay_fund_deadline_after.groupby('ref_id')['real_prin_inst'].sum().reset_index()

    # df_repay_real_after = pd.concat([df_repay_other_after, df_repay_fund_deadline_after], ignore_index=True)

    df_after = pd.merge(df_pay_current, df_fund[['ref_id','term_no','fund_deadline']], on='ref_id', how='left')
    df_after = pd.merge(df_after, df_fund_plan_after, on=['ref_id','term_no'], how='left')
    df_after = pd.merge(df_after, df_repay_after, on=['ref_id','term_no'], how='left')

    df_after.fillna(0, inplace=True)
    df_after['peifu'] = np.round(df_after.fund_prin_inst - df_after.real_prin_inst, 2)
    # df_after = df_after.loc[df_after['peifu'] != 0]
    # df_after = df_after.loc[(df_after['peifu'] > 0.5) | (df_after['peifu'] < -0.5)]
    peifu_sum += df_after['peifu'].sum()
    df_after.to_csv(path + 'peifu_after(%s).csv' % str(end_date + datetime.timedelta(days=-1)), index=None)
    print start_date, end_date,df_current['peifu'].sum(), df_after['peifu'].sum(), df_current['peifu'].sum() + df_after['peifu'].sum()
    # df_current.to_csv(path+'')
    # df_all = pd.merge(df_current, df_after[['ref_id','term_no', 'fund_prin_inst', 'real_prin_inst', 'peifu']], on=['ref_id','term_no'],
    #                   how='outer')
    # df_all.fillna(0, inplace=True)
    # df_all = df_all.loc[~((df_all['peifu_x'] == 0) & (df_all['peifu_y'] == 0))]
    # df_all = df_all.loc[((df_all['peifu_x'] > 0.5) | (df_all['peifu_x'] < -0.5)) | ((df_all['peifu_y'] > 0.5) | (df_all['peifu_y'] < -0.5))]
    # df_all.to_csv(path + 'peifu_all(%s).csv' % str(end_date + datetime.timedelta(days=-1)), index=None)
    # print len(df_pay_current), len(df_current), len(df_after), len(df_all)
    # res.append(df_current)
    # res.append(df_after)

date_list = [datetime.date(2016, 1, 1), datetime.date(2016, 4, 1), datetime.date(2016, 7, 1),
             datetime.date(2016, 10, 1), datetime.date(2017, 1, 1)]
for i in range(0, len(date_list) - 1):
    get_fund(date_list[i], date_list[i + 1])

# print peifu_sum
# df_peifu = pd.concat(res)
# df_peifu = df_peifu.groupby('ref_id')[['fund_prin_inst', 'real_prin_inst', 'peifu']].agg('sum').reset_index()
# df_peifu = df_peifu.loc[df_peifu['peifu'] != 0]
# df_peifu = df_peifu.loc[(df_peifu['peifu'] > 0.5) | (df_peifu['peifu'] < -0.5)]
# df_peifu.to_csv(path + 'peifu_all.csv', index=None)

