# -*- encoding: utf8 -*-

"""
目标：
    现金贷放款表按放款月统计汇总
数据库：
    audit.loan_manifest
    根据不同时段的需求，选取不同阶段的备份数据库
字段名：
    放款年，放款月，资金方，放款账户，放款金额，本金（债权），一次性手续费（QG），一次性手续费（资金方），风险等级（ABC）
注意：
    筛选条件is_active的选择
"""

import os

import pandas as pd

from db_con.db_connect import sql_engine

# ----------------------------------------------
pd.options.mode.chained_assignment = None
file_path = u'E:/审计出表/现金贷'
file_name = u'现金贷放款表-汇总表'
if not os.path.exists(file_path):
    os.makedirs(file_path)
mysql = sql_engine('audit', 'temp').get_engine()
sql = """
SELECT
  year(lm.loan_paid_at)                '放款年',
  month(lm.loan_paid_at)               '放款月',
  fc.name                              '资金方',
  la.accountName                       '放款账户',
  sum(lm.real_loan_amount)             '放款金额',
  sum(lm.contract_loan_amount)         '本金（债权）',
  sum(lm.qg_one_time_service_fee)      '一次性手续费（QG）',
  sum(lm.funding_one_time_service_fee) '一次性手续费（资金方）',
  lct.class                            '风险等级',
  sum(xdp.qg_one_time_service_fee)     '应扣趸收服务费'
FROM audit.loan_manifest lm
  LEFT JOIN new_transaction.xjd_dunjiao_plan xdp ON xdp.ref_id = lm.ref_id
  JOIN basic.loan_class_test lct ON lct.ref_id = lm.ref_id
  JOIN audit.funding_corp fc ON fc.funding_code = lm.funding_code
  JOIN audit.loan_account la ON la.id = lm.loan_account_id
WHERE lm.is_active IN (1, -2)
GROUP BY 1, 2, 3, 4, 9;
"""
# ----------------------------------------------
df = pd.read_sql(sql=sql, con=mysql)
df.to_csv(os.path.join(file_path, '%s.csv' % file_name), index=None, encoding='utf8')
df.to_excel(os.path.join(file_path, '%s.xlsx' % file_name), index=None)