# -*- coding:utf-8 -*-
# Author: Perry_Zhu
import sys
import datetime
import pandas as pd
import numpy as np
from itertools import product
from sqlalchemy import create_engine
import multiprocessing as mtp
from dateutil.relativedelta import relativedelta

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None
engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/all_back_0630?charset=utf8', echo=False).connect()
'''
表1：'产品编号','贷款时间',退款时间，转分期时间，'合同放款金额', '分期数' ,'是否为转分期后订单号'
'''

path = u'E:/数据汇总/白条/去哪儿/放款/'
sql_loan = '''
select DISTINCT t1.product_no ,'FALSE' AS  is_ptf
from qunaer_new.pay_detail t1
WHERE
	t1.STATUS = 1
and  t1.loan_time >= '%s' and t1.loan_time < '%s'
'''

sql_transf = """
    SELECT
	trans_no ,product_no,'TRUE' AS is_ptf
FROM
	qunaer_new.trans_ref
WHERE
	product_no IN %s
"""
sql_loan_info = '''
select DISTINCT 
    t1.product_no 产品编号,
	t1.loan_time 贷款时间,
	'' as 退款时间,
	t1.trans_time 转分期时间,
	t1.loan_amount 合同放款金额,
	t1.stages 分期数
from qunaer_new.pay_detail t1
WHERE
	t1.product_no in %s
'''

sql_loan_info_ptf = '''
select DISTINCT 
    t1.product_no 产品编号,
	t1.loan_time 贷款时间,
	'' as 退款时间,
	t1.trans_time 转分期时间,
	t1.loan_amount 合同放款金额,
	t1.stages 分期数
from qunaer_new.pay_detail t1
WHERE
    t1.loan_time>='%s'
    AND t1.loan_time<'%s'
	'%s'
'''

sql_refund = '''
select t1.product_no 产品编号,t2.loan_time as 贷款时间,date(t1.refund_time) 退款时间,'' as 转分期时间,
    t1.refund_amount 合同放款金额,t2.stages 分期数,
    'FALSE' as 是否为转分期后订单号 ,to_days(t1.refund_time) refund_days
from qunaer_new.refund_detail t1 
join qunaer_new.pay_detail  t2 on t1.product_no = t2.product_no
where t1.refund_status = 1 
and t1.product_no in %s
'''

sql_refund_real = '''
select t1.product_no 产品编号,t2.loan_time as 贷款时间,date(t1.refund_time) 退款时间,'' as 转分期时间,
    t1.refund_amount 合同放款金额,t2.stages 分期数,
    'FALSE' as 是否为转分期后订单号 ,to_days(t1.refund_time) refund_days
from qunaer_new.refund_detail t1 
join qunaer_new.pay_detail  t2 on t1.product_no = t2.product_no
where t1.refund_status = 1 
and t1.refund_time >= '%s'
AND t1.refund_time < '%s'
AND t2.loan_time<'%s'
'''


def loan_info(year, month):
    start_time = datetime.date(year, month, 1)
    end_time = datetime.date(year, month, 1) + relativedelta(months=+1)
    df_product = pd.read_sql(sql_loan % (start_time, end_time), engine_new_transaction)
    df_product['product_no'] = df_product['product_no'].astype(str)
    df_product['trans_after'] = ''
    product_no_list = df_product['product_no'].tolist()
    df_transf = pd.read_sql(sql_transf % str(tuple(product_no_list)).replace(',)', ')'), engine_new_transaction)
    df_transf['product_no'] = df_transf['product_no'].astype(str)
    df_transf['trans_no'] = df_transf['trans_no'].astype(str)
    df_t1 = df_transf[['trans_no', 'is_ptf']]
    df_t1['trans_after'] = 'TRUE'
    df_t1.rename(columns={'trans_no': 'product_no'}, inplace=True)
    df_t2 = df_transf[['product_no', 'is_ptf']]
    df_t2['trans_after'] = 'FALSE'
    before_sql = " and t1.trans_time >='%s' " % start_time
    current_sql = " and t1.trans_time >='%s' and t1.trans_time <'%s' " % (start_time, end_time)
    after_sql = " and t1.trans_time >='%s' " % end_time
    df_before = pd.read_sql(sql_loan_info_ptf % (start_time, end_time, before_sql), engine_new_transaction)
    df_before[u'产品编号'] = df_before[u'产品编号'].astype(str)
    df_before = df_before.ix[~df_before[u'产品编号'].isin(df_t2[u'产品编号'])]
    df_current = pd.read_sql(sql_loan_info_ptf % (start_time, end_time, current_sql), engine_new_transaction)
    df_current[u'产品编号'] = df_current[u'产品编号'].astype(str)
    df_current = df_current.ix[~df_current[u'产品编号'].isin(df_t2[u'产品编号'])]
    df_after = pd.read_sql(sql_loan_info_ptf % (start_time, end_time, after_sql), engine_new_transaction)
    df_after[u'产品编号'] = df_after[u'产品编号'].astype(str)
    df_after = df_after.ix[~df_after[u'产品编号'].isin(df_t2[u'产品编号'])]

    df_transf = pd.concat([df_t1, df_t2], axis=0, ignore_index=True)
    df_product = df_product.ix[~df_product['product_no'].isin(df_transf['product_no'])]
    df_product = pd.concat([df_product, df_transf], axis=0, ignore_index=True)
    df_product = df_product.drop_duplicates(['product_no'])
    df_product.rename(columns={'is_ptf': u'是否为转分期后订单号', 'trans_after': u'是否转分期之后订单'}, inplace=True)
    product_no_list = df_product['product_no'].tolist()
    df_loan = pd.read_sql(sql_loan_info % str(tuple(product_no_list)).replace(',)', ')'), engine_new_transaction)
    df_loan[u'产品编号'] = df_loan[u'产品编号'].astype(str)
    df_loan = df_loan.merge(df_product, left_on=u'产品编号', right_on='product_no')
    df_refund = pd.read_sql(sql_refund % str(tuple(product_no_list)).replace(',)', ')'), engine_new_transaction)
    df_refund[u'产品编号'] = df_refund[u'产品编号'].astype(str)
    df_refund['refund_days'] = df_refund[u'产品编号'].astype(str)
    df_refund['unique'] = df_refund[u'产品编号'] + df_refund['refund_days']
    df_refund_real = pd.read_sql(sql_refund_real % (start_time, end_time, start_time), engine_new_transaction)
    df_refund_real[u'产品编号'] = df_refund_real[u'产品编号'].astype(str)
    df_refund_real['refund_days'] = df_refund_real[u'产品编号'].astype(str)
    df_refund_real['unique'] = df_refund_real[u'产品编号'] + df_refund_real['refund_days']
    df_refund_real = df_refund_real.ix[~df_refund_real['unique'].isin(df_refund['unique'])]
    df_refund = pd.concat([df_refund, df_refund_real], ignore_index=True)
    df_refund.drop(['unique', 'refund_days'], axis=1, inplace=True)
    df_pay = pd.concat([df_loan, df_refund], axis=0, ignore_index=True)
    df_pay = df_pay[[u'产品编号', u'合同放款金额', u'贷款时间', u'退款时间', u'转分期时间', u'分期数', u'是否为转分期后订单号', u'是否转分期之后订单']]
    df_pay.to_excel(path + u'去哪儿%s-%s放款.xlsx' % (year, month), index=None)


loan_info(2016, 8)

# years = (2015,2016,2017,)
# months = (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
# if __name__ == '__main__':
#     pool = mtp.Pool(processes=8)
#     for year, month in product(years, months):
#         print year, month
#         if year == 2016 and month < 8:
#             continue
#         elif year == 2017 and month > 6:
#             continue
#         elif year == 2015 and month < 12:
#             continue
#         else:
#             pool.apply_async(loan_info, (year, month))
#     pool.close()
#     pool.join()
